'use strict';var lang_1 = require('angular2/src/facade/lang');
exports.Map = lang_1.global.Map;
exports.Set = lang_1.global.Set;
// Safari and Internet Explorer do not support the iterable parameter to the
// Map constructor.  We work around that by manually adding the items.
var createMapFromPairs = (function () {
    try {
        if (new exports.Map([[1, 2]]).size === 1) {
            return function createMapFromPairs(pairs) { return new exports.Map(pairs); };
        }
    }
    catch (e) {
    }
    return function createMapAndPopulateFromPairs(pairs) {
        var map = new exports.Map();
        for (var i = 0; i < pairs.length; i++) {
            var pair = pairs[i];
            map.set(pair[0], pair[1]);
        }
        return map;
    };
})();
var createMapFromMap = (function () {
    try {
        if (new exports.Map(new exports.Map())) {
            return function createMapFromMap(m) { return new exports.Map(m); };
        }
    }
    catch (e) {
    }
    return function createMapAndPopulateFromMap(m) {
        var map = new exports.Map();
        m.forEach(function (v, k) { map.set(k, v); });
        return map;
    };
})();
var _clearValues = (function () {
    if ((new exports.Map()).keys().next) {
        return function _clearValues(m) {
            var keyIterator = m.keys();
            var k;
            while (!((k = keyIterator.next()).done)) {
                m.set(k.value, null);
            }
        };
    }
    else {
        return function _clearValuesWithForeEach(m) {
            m.forEach(function (v, k) { m.set(k, null); });
        };
    }
})();
// Safari doesn't implement MapIterator.next(), which is used is Traceur's polyfill of Array.from
// TODO(mlaval): remove the work around once we have a working polyfill of Array.from
var _arrayFromMap = (function () {
    try {
        if ((new exports.Map()).values().next) {
            return function createArrayFromMap(m, getValues) {
                return getValues ? Array.from(m.values()) : Array.from(m.keys());
            };
        }
    }
    catch (e) {
    }
    return function createArrayFromMapWithForeach(m, getValues) {
        var res = ListWrapper.createFixedSize(m.size), i = 0;
        m.forEach(function (v, k) {
            res[i] = getValues ? v : k;
            i++;
        });
        return res;
    };
})();
var MapWrapper = (function () {
    function MapWrapper() {
    }
    MapWrapper.clone = function (m) { return createMapFromMap(m); };
    MapWrapper.createFromStringMap = function (stringMap) {
        var result = new exports.Map();
        for (var prop in stringMap) {
            result.set(prop, stringMap[prop]);
        }
        return result;
    };
    MapWrapper.toStringMap = function (m) {
        var r = {};
        m.forEach(function (v, k) { return r[k] = v; });
        return r;
    };
    MapWrapper.createFromPairs = function (pairs) { return createMapFromPairs(pairs); };
    MapWrapper.clearValues = function (m) { _clearValues(m); };
    MapWrapper.iterable = function (m) { return m; };
    MapWrapper.keys = function (m) { return _arrayFromMap(m, false); };
    MapWrapper.values = function (m) { return _arrayFromMap(m, true); };
    return MapWrapper;
})();
exports.MapWrapper = MapWrapper;
/**
 * Wraps Javascript Objects
 */
var StringMapWrapper = (function () {
    function StringMapWrapper() {
    }
    StringMapWrapper.create = function () {
        // Note: We are not using Object.create(null) here due to
        // performance!
        // http://jsperf.com/ng2-object-create-null
        return {};
    };
    StringMapWrapper.contains = function (map, key) {
        return map.hasOwnProperty(key);
    };
    StringMapWrapper.get = function (map, key) {
        return map.hasOwnProperty(key) ? map[key] : undefined;
    };
    StringMapWrapper.set = function (map, key, value) { map[key] = value; };
    StringMapWrapper.keys = function (map) { return Object.keys(map); };
    StringMapWrapper.isEmpty = function (map) {
        for (var prop in map) {
            return false;
        }
        return true;
    };
    StringMapWrapper.delete = function (map, key) { delete map[key]; };
    StringMapWrapper.forEach = function (map, callback) {
        for (var prop in map) {
            if (map.hasOwnProperty(prop)) {
                callback(map[prop], prop);
            }
        }
    };
    StringMapWrapper.merge = function (m1, m2) {
        var m = {};
        for (var attr in m1) {
            if (m1.hasOwnProperty(attr)) {
                m[attr] = m1[attr];
            }
        }
        for (var attr in m2) {
            if (m2.hasOwnProperty(attr)) {
                m[attr] = m2[attr];
            }
        }
        return m;
    };
    StringMapWrapper.equals = function (m1, m2) {
        var k1 = Object.keys(m1);
        var k2 = Object.keys(m2);
        if (k1.length != k2.length) {
            return false;
        }
        var key;
        for (var i = 0; i < k1.length; i++) {
            key = k1[i];
            if (m1[key] !== m2[key]) {
                return false;
            }
        }
        return true;
    };
    return StringMapWrapper;
})();
exports.StringMapWrapper = StringMapWrapper;
var ListWrapper = (function () {
    function ListWrapper() {
    }
    // JS has no way to express a statically fixed size list, but dart does so we
    // keep both methods.
    ListWrapper.createFixedSize = function (size) { return new Array(size); };
    ListWrapper.createGrowableSize = function (size) { return new Array(size); };
    ListWrapper.clone = function (array) { return array.slice(0); };
    ListWrapper.createImmutable = function (array) {
        var result = ListWrapper.clone(array);
        Object.seal(result);
        return result;
    };
    ListWrapper.forEachWithIndex = function (array, fn) {
        for (var i = 0; i < array.length; i++) {
            fn(array[i], i);
        }
    };
    ListWrapper.first = function (array) {
        if (!array)
            return null;
        return array[0];
    };
    ListWrapper.last = function (array) {
        if (!array || array.length == 0)
            return null;
        return array[array.length - 1];
    };
    ListWrapper.indexOf = function (array, value, startIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        return array.indexOf(value, startIndex);
    };
    ListWrapper.contains = function (list, el) { return list.indexOf(el) !== -1; };
    ListWrapper.reversed = function (array) {
        var a = ListWrapper.clone(array);
        return a.reverse();
    };
    ListWrapper.concat = function (a, b) { return a.concat(b); };
    ListWrapper.insert = function (list, index, value) { list.splice(index, 0, value); };
    ListWrapper.removeAt = function (list, index) {
        var res = list[index];
        list.splice(index, 1);
        return res;
    };
    ListWrapper.removeAll = function (list, items) {
        for (var i = 0; i < items.length; ++i) {
            var index = list.indexOf(items[i]);
            list.splice(index, 1);
        }
    };
    ListWrapper.remove = function (list, el) {
        var index = list.indexOf(el);
        if (index > -1) {
            list.splice(index, 1);
            return true;
        }
        return false;
    };
    ListWrapper.clear = function (list) { list.length = 0; };
    ListWrapper.isEmpty = function (list) { return list.length == 0; };
    ListWrapper.fill = function (list, value, start, end) {
        if (start === void 0) { start = 0; }
        if (end === void 0) { end = null; }
        list.fill(value, start, end === null ? list.length : end);
    };
    ListWrapper.equals = function (a, b) {
        if (a.length != b.length)
            return false;
        for (var i = 0; i < a.length; ++i) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    };
    ListWrapper.slice = function (l, from, to) {
        if (from === void 0) { from = 0; }
        if (to === void 0) { to = null; }
        return l.slice(from, to === null ? undefined : to);
    };
    ListWrapper.splice = function (l, from, length) { return l.splice(from, length); };
    ListWrapper.sort = function (l, compareFn) {
        if (lang_1.isPresent(compareFn)) {
            l.sort(compareFn);
        }
        else {
            l.sort();
        }
    };
    ListWrapper.toString = function (l) { return l.toString(); };
    ListWrapper.toJSON = function (l) { return JSON.stringify(l); };
    ListWrapper.maximum = function (list, predicate) {
        if (list.length == 0) {
            return null;
        }
        var solution = null;
        var maxValue = -Infinity;
        for (var index = 0; index < list.length; index++) {
            var candidate = list[index];
            if (lang_1.isBlank(candidate)) {
                continue;
            }
            var candidateValue = predicate(candidate);
            if (candidateValue > maxValue) {
                solution = candidate;
                maxValue = candidateValue;
            }
        }
        return solution;
    };
    ListWrapper.isImmutable = function (list) { return Object.isSealed(list); };
    return ListWrapper;
})();
exports.ListWrapper = ListWrapper;
function isListLikeIterable(obj) {
    if (!lang_1.isJsObject(obj))
        return false;
    return lang_1.isArray(obj) ||
        (!(obj instanceof exports.Map) &&
            lang_1.getSymbolIterator() in obj); // JS Iterable have a Symbol.iterator prop
}
exports.isListLikeIterable = isListLikeIterable;
function areIterablesEqual(a, b, comparator) {
    var iterator1 = a[lang_1.getSymbolIterator()]();
    var iterator2 = b[lang_1.getSymbolIterator()]();
    while (true) {
        var item1 = iterator1.next();
        var item2 = iterator2.next();
        if (item1.done && item2.done)
            return true;
        if (item1.done || item2.done)
            return false;
        if (!comparator(item1.value, item2.value))
            return false;
    }
}
exports.areIterablesEqual = areIterablesEqual;
function iterateListLike(obj, fn) {
    if (lang_1.isArray(obj)) {
        for (var i = 0; i < obj.length; i++) {
            fn(obj[i]);
        }
    }
    else {
        var iterator = obj[lang_1.getSymbolIterator()]();
        var item;
        while (!((item = iterator.next()).done)) {
            fn(item.value);
        }
    }
}
exports.iterateListLike = iterateListLike;
// Safari and Internet Explorer do not support the iterable parameter to the
// Set constructor.  We work around that by manually adding the items.
var createSetFromList = (function () {
    var test = new exports.Set([1, 2, 3]);
    if (test.size === 3) {
        return function createSetFromList(lst) { return new exports.Set(lst); };
    }
    else {
        return function createSetAndPopulateFromList(lst) {
            var res = new exports.Set(lst);
            if (res.size !== lst.length) {
                for (var i = 0; i < lst.length; i++) {
                    res.add(lst[i]);
                }
            }
            return res;
        };
    }
})();
var SetWrapper = (function () {
    function SetWrapper() {
    }
    SetWrapper.createFromList = function (lst) { return createSetFromList(lst); };
    SetWrapper.has = function (s, key) { return s.has(key); };
    SetWrapper.delete = function (m, k) { m.delete(k); };
    return SetWrapper;
})();
exports.SetWrapper = SetWrapper;
//# sourceMappingURL=data:application/json;base64,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