/* @flow */

"use strict";

var _interopRequireWildcard = require("babel-runtime/helpers/interop-require-wildcard")["default"];

exports.__esModule = true;
exports.AnyTypeAnnotation = AnyTypeAnnotation;
exports.ArrayTypeAnnotation = ArrayTypeAnnotation;
exports.BooleanTypeAnnotation = BooleanTypeAnnotation;
exports.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
exports.DeclareClass = DeclareClass;
exports.DeclareFunction = DeclareFunction;
exports.DeclareModule = DeclareModule;
exports.DeclareVariable = DeclareVariable;
exports.FunctionTypeAnnotation = FunctionTypeAnnotation;
exports.FunctionTypeParam = FunctionTypeParam;
exports.InterfaceExtends = InterfaceExtends;
exports._interfaceish = _interfaceish;
exports.InterfaceDeclaration = InterfaceDeclaration;
exports.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
exports.MixedTypeAnnotation = MixedTypeAnnotation;
exports.NullableTypeAnnotation = NullableTypeAnnotation;
exports.NumberTypeAnnotation = NumberTypeAnnotation;
exports.StringLiteralTypeAnnotation = StringLiteralTypeAnnotation;
exports.StringTypeAnnotation = StringTypeAnnotation;
exports.TupleTypeAnnotation = TupleTypeAnnotation;
exports.TypeofTypeAnnotation = TypeofTypeAnnotation;
exports.TypeAlias = TypeAlias;
exports.TypeAnnotation = TypeAnnotation;
exports.TypeParameterInstantiation = TypeParameterInstantiation;
exports.ObjectTypeAnnotation = ObjectTypeAnnotation;
exports.ObjectTypeCallProperty = ObjectTypeCallProperty;
exports.ObjectTypeIndexer = ObjectTypeIndexer;
exports.ObjectTypeProperty = ObjectTypeProperty;
exports.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
exports.UnionTypeAnnotation = UnionTypeAnnotation;
exports.TypeCastExpression = TypeCastExpression;
exports.VoidTypeAnnotation = VoidTypeAnnotation;

var _babelTypes = require("babel-types");

var t = _interopRequireWildcard(_babelTypes);

function AnyTypeAnnotation() {
  this.push("any");
}

function ArrayTypeAnnotation(node /*: Object*/) {
  this.print(node.elementType, node);
  this.push("[");
  this.push("]");
}

function BooleanTypeAnnotation() {
  this.push("bool");
}

function BooleanLiteralTypeAnnotation(node /*: Object*/) {
  this.push(node.value ? "true" : "false");
}

function DeclareClass(node /*: Object*/) {
  this.push("declare class ");
  this._interfaceish(node);
}

function DeclareFunction(node /*: Object*/) {
  this.push("declare function ");
  this.print(node.id, node);
  this.print(node.id.typeAnnotation.typeAnnotation, node);
  this.semicolon();
}

function DeclareModule(node /*: Object*/) {
  this.push("declare module ");
  this.print(node.id, node);
  this.space();
  this.print(node.body, node);
}

function DeclareVariable(node /*: Object*/) {
  this.push("declare var ");
  this.print(node.id, node);
  this.print(node.id.typeAnnotation, node);
  this.semicolon();
}

function FunctionTypeAnnotation(node /*: Object*/, parent /*: Object*/) {
  this.print(node.typeParameters, node);
  this.push("(");
  this.printList(node.params, node);

  if (node.rest) {
    if (node.params.length) {
      this.push(",");
      this.space();
    }
    this.push("...");
    this.print(node.rest, node);
  }

  this.push(")");

  // this node type is overloaded, not sure why but it makes it EXTREMELY annoying
  if (parent.type === "ObjectTypeProperty" || parent.type === "ObjectTypeCallProperty" || parent.type === "DeclareFunction") {
    this.push(":");
  } else {
    this.space();
    this.push("=>");
  }

  this.space();
  this.print(node.returnType, node);
}

function FunctionTypeParam(node /*: Object*/) {
  this.print(node.name, node);
  if (node.optional) this.push("?");
  this.push(":");
  this.space();
  this.print(node.typeAnnotation, node);
}

function InterfaceExtends(node /*: Object*/) {
  this.print(node.id, node);
  this.print(node.typeParameters, node);
}

exports.ClassImplements = InterfaceExtends;
exports.GenericTypeAnnotation = InterfaceExtends;

function _interfaceish(node /*: Object*/) {
  this.print(node.id, node);
  this.print(node.typeParameters, node);
  if (node["extends"].length) {
    this.push(" extends ");
    this.printJoin(node["extends"], node, { separator: ", " });
  }
  this.space();
  this.print(node.body, node);
}

function InterfaceDeclaration(node /*: Object*/) {
  this.push("interface ");
  this._interfaceish(node);
}

function IntersectionTypeAnnotation(node /*: Object*/) {
  this.printJoin(node.types, node, { separator: " & " });
}

function MixedTypeAnnotation() {
  this.push("mixed");
}

function NullableTypeAnnotation(node /*: Object*/) {
  this.push("?");
  this.print(node.typeAnnotation, node);
}

var _types = require("./types");

exports.NumberLiteralTypeAnnotation = _types.NumberLiteral;

function NumberTypeAnnotation() {
  this.push("number");
}

function StringLiteralTypeAnnotation(node /*: Object*/) {
  this.push(this._stringLiteral(node.value));
}

function StringTypeAnnotation() {
  this.push("string");
}

function TupleTypeAnnotation(node /*: Object*/) {
  this.push("[");
  this.printJoin(node.types, node, { separator: ", " });
  this.push("]");
}

function TypeofTypeAnnotation(node /*: Object*/) {
  this.push("typeof ");
  this.print(node.argument, node);
}

function TypeAlias(node /*: Object*/) {
  this.push("type ");
  this.print(node.id, node);
  this.print(node.typeParameters, node);
  this.space();
  this.push("=");
  this.space();
  this.print(node.right, node);
  this.semicolon();
}

function TypeAnnotation(node /*: Object*/) {
  this.push(":");
  this.space();
  if (node.optional) this.push("?");
  this.print(node.typeAnnotation, node);
}

function TypeParameterInstantiation(node /*: Object*/) {
  // istanbul ignore next

  var _this = this;

  this.push("<");
  this.printJoin(node.params, node, {
    separator: ", ",
    iterator: function iterator(node /*: Object*/) {
      _this.print(node.typeAnnotation, node);
    }
  });
  this.push(">");
}

exports.TypeParameterDeclaration = TypeParameterInstantiation;

function ObjectTypeAnnotation(node /*: Object*/) {
  // istanbul ignore next

  var _this2 = this;

  this.push("{");
  var props = node.properties.concat(node.callProperties, node.indexers);

  if (props.length) {
    this.space();

    this.printJoin(props, node, {
      separator: false,
      indent: true,
      iterator: function iterator() {
        if (props.length !== 1) {
          _this2.semicolon();
          _this2.space();
        }
      }
    });

    this.space();
  }

  this.push("}");
}

function ObjectTypeCallProperty(node /*: Object*/) {
  if (node["static"]) this.push("static ");
  this.print(node.value, node);
}

function ObjectTypeIndexer(node /*: Object*/) {
  if (node["static"]) this.push("static ");
  this.push("[");
  this.print(node.id, node);
  this.push(":");
  this.space();
  this.print(node.key, node);
  this.push("]");
  this.push(":");
  this.space();
  this.print(node.value, node);
}

function ObjectTypeProperty(node /*: Object*/) {
  if (node["static"]) this.push("static ");
  this.print(node.key, node);
  if (node.optional) this.push("?");
  if (!t.isFunctionTypeAnnotation(node.value)) {
    this.push(":");
    this.space();
  }
  this.print(node.value, node);
}

function QualifiedTypeIdentifier(node /*: Object*/) {
  this.print(node.qualification, node);
  this.push(".");
  this.print(node.id, node);
}

function UnionTypeAnnotation(node /*: Object*/) {
  this.printJoin(node.types, node, { separator: " | " });
}

function TypeCastExpression(node /*: Object*/) {
  this.push("(");
  this.print(node.expression, node);
  this.print(node.typeAnnotation, node);
  this.push(")");
}

function VoidTypeAnnotation() {
  this.push("void");
}