"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryHistory = void 0;
var react_1 = __importDefault(require("react"));
var HistoryQuery_1 = __importDefault(require("./HistoryQuery"));
var HistoryStore_1 = __importDefault(require("../utility/HistoryStore"));
var QueryHistory = (function (_super) {
    __extends(QueryHistory, _super);
    function QueryHistory(props) {
        var _this = _super.call(this, props) || this;
        _this.onUpdateHistory = function (query, variables, headers, operationName) {
            _this.historyStore.updateHistory(query, variables, headers, operationName);
            _this.setState({ queries: _this.historyStore.queries });
        };
        _this.onHandleEditLabel = function (query, variables, headers, operationName, label, favorite) {
            _this.historyStore.editLabel(query, variables, headers, operationName, label, favorite);
            _this.setState({ queries: _this.historyStore.queries });
        };
        _this.onToggleFavorite = function (query, variables, headers, operationName, label, favorite) {
            _this.historyStore.toggleFavorite(query, variables, headers, operationName, label, favorite);
            _this.setState({ queries: _this.historyStore.queries });
        };
        _this.historyStore = new HistoryStore_1.default(_this.props.storage, _this.props.maxHistoryLength);
        var queries = _this.historyStore.queries;
        _this.state = { queries: queries };
        return _this;
    }
    QueryHistory.prototype.render = function () {
        var _this = this;
        var queries = this.state.queries.slice().reverse();
        var queryNodes = queries.map(function (query, i) {
            return (react_1.default.createElement(HistoryQuery_1.default, __assign({ handleEditLabel: _this.onHandleEditLabel, handleToggleFavorite: _this.onToggleFavorite, key: i + ":" + (query.label || query.query), onSelect: _this.props.onSelectQuery }, query)));
        });
        return (react_1.default.createElement("section", { "aria-label": "History" },
            react_1.default.createElement("div", { className: "history-title-bar" },
                react_1.default.createElement("div", { className: "history-title" }, 'History'),
                react_1.default.createElement("div", { className: "doc-explorer-rhs" }, this.props.children)),
            react_1.default.createElement("ul", { className: "history-contents" }, queryNodes)));
    };
    return QueryHistory;
}(react_1.default.Component));
exports.QueryHistory = QueryHistory;
//# sourceMappingURL=QueryHistory.js.map