var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import React from 'react';
import Argument from './Argument';
import Directive from './Directive';
import MarkdownContent from './MarkdownContent';
import TypeLink from './TypeLink';
export default function FieldDoc(_a) {
    var field = _a.field, onClickType = _a.onClickType;
    var _b = __read(React.useState(false), 2), showDeprecated = _b[0], handleShowDeprecated = _b[1];
    var argsDef;
    var deprecatedArgsDef;
    if (field && 'args' in field && field.args.length > 0) {
        argsDef = (React.createElement("div", { id: "doc-args", className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, 'arguments'),
            field.args
                .filter(function (arg) { return !arg.deprecationReason; })
                .map(function (arg) { return (React.createElement("div", { key: arg.name, className: "doc-category-item" },
                React.createElement("div", null,
                    React.createElement(Argument, { arg: arg, onClickType: onClickType })),
                React.createElement(MarkdownContent, { className: "doc-value-description", markdown: arg.description }),
                arg && 'deprecationReason' in arg && (React.createElement(MarkdownContent, { className: "doc-deprecation", markdown: arg === null || arg === void 0 ? void 0 : arg.deprecationReason })))); })));
        var deprecatedArgs = field.args.filter(function (arg) {
            return Boolean(arg.deprecationReason);
        });
        if (deprecatedArgs.length > 0) {
            deprecatedArgsDef = (React.createElement("div", { id: "doc-deprecated-args", className: "doc-category" },
                React.createElement("div", { className: "doc-category-title" }, 'deprecated arguments'),
                !showDeprecated ? (React.createElement("button", { className: "show-btn", onClick: function () { return handleShowDeprecated(!showDeprecated); } }, 'Show deprecated arguments...')) : (deprecatedArgs.map(function (arg, i) { return (React.createElement("div", { key: i },
                    React.createElement("div", null,
                        React.createElement(Argument, { arg: arg, onClickType: onClickType })),
                    React.createElement(MarkdownContent, { className: "doc-value-description", markdown: arg.description }),
                    arg && 'deprecationReason' in arg && (React.createElement(MarkdownContent, { className: "doc-deprecation", markdown: arg === null || arg === void 0 ? void 0 : arg.deprecationReason })))); }))));
        }
    }
    var directivesDef;
    if (field &&
        field.astNode &&
        field.astNode.directives &&
        field.astNode.directives.length > 0) {
        directivesDef = (React.createElement("div", { id: "doc-directives", className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, 'directives'),
            field.astNode.directives.map(function (directive) { return (React.createElement("div", { key: directive.name.value, className: "doc-category-item" },
                React.createElement("div", null,
                    React.createElement(Directive, { directive: directive })))); })));
    }
    return (React.createElement("div", null,
        React.createElement(MarkdownContent, { className: "doc-type-description", markdown: (field === null || field === void 0 ? void 0 : field.description) || 'No Description' }),
        field && 'deprecationReason' in field && (React.createElement(MarkdownContent, { className: "doc-deprecation", markdown: field === null || field === void 0 ? void 0 : field.deprecationReason })),
        React.createElement("div", { className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, 'type'),
            React.createElement(TypeLink, { type: field === null || field === void 0 ? void 0 : field.type, onClick: onClickType })),
        argsDef,
        directivesDef,
        deprecatedArgsDef));
}
//# sourceMappingURL=FieldDoc.js.map