"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tabs = exports.TabAddButton = exports.Tab = void 0;
var react_1 = __importDefault(require("react"));
function TabCloseButton(props) {
    return (react_1.default.createElement("div", { role: "button", "aria-pressed": false, className: "close", "aria-label": "Close Tab", title: "Close Tab", onClick: function (ev) {
            ev.stopPropagation();
            props.onClick();
        } }));
}
function Tab(props) {
    return (react_1.default.createElement("button", __assign({}, props.tabProps, { role: "tab", type: "button", "aria-selected": props.isActive, title: props.title, className: "tab" + (props.isActive ? ' active' : ''), onClick: props.onSelect }),
        props.title,
        props.isCloseable ? (react_1.default.createElement(TabCloseButton, { onClick: function () { return props.onClose(); } })) : null));
}
exports.Tab = Tab;
function TabAddButton(props) {
    return (react_1.default.createElement("button", { onClick: props.onClick, className: "tab-add", title: "Create new tab" },
        react_1.default.createElement("span", null, '+')));
}
exports.TabAddButton = TabAddButton;
function Tabs(props) {
    return (react_1.default.createElement("div", __assign({ role: "tablist", className: "tabs" }, props.tabsProps), props.children));
}
exports.Tabs = Tabs;
//# sourceMappingURL=Tabs.js.map