import React from 'react';
import { Editor } from 'codemirror';
import { FragmentDefinitionNode, GraphQLSchema, GraphQLType, ValidationRule } from 'graphql';
import { SizerComponent } from '../utility/CodeMirrorSizer';
import { CodeMirrorEditor } from '../types';
declare type QueryEditorProps = {
    schema?: GraphQLSchema | null;
    validationRules?: ValidationRule[];
    value?: string;
    onEdit?: (value: string) => void;
    readOnly?: boolean;
    onHintInformationRender: (elem: HTMLDivElement) => void;
    onClickReference?: (reference: GraphQLType) => void;
    onCopyQuery?: () => void;
    onPrettifyQuery?: () => void;
    onMergeQuery?: () => void;
    onRunQuery?: () => void;
    editorTheme?: string;
    externalFragments?: string | FragmentDefinitionNode[];
};
export declare class QueryEditor extends React.Component<QueryEditorProps, {}> implements SizerComponent {
    cachedValue: string | undefined;
    editor: CodeMirrorEditor | null;
    ignoreChangeEvent: boolean;
    CodeMirror: any;
    _node: HTMLElement | null;
    constructor(props: QueryEditorProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: QueryEditorProps): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
    addonModules: () => Promise<{
        default: typeof import("codemirror/addon/comment/comment");
    }>[];
    initializeEditor(): Promise<CodeMirrorEditor>;
    getCodeMirror(): Editor;
    getClientHeight(): number | null;
    private _onKeyUp;
    private _onEdit;
    private _onHasCompletion;
    private _onBeforeChange;
}
export {};
//# sourceMappingURL=QueryEditor.d.ts.map