var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import React from 'react';
import ReactDOM from 'react-dom';
import commonKeys from '../utility/commonKeys';
import { importCodeMirror } from '../utility/importCodeMirror';
var ResultViewer = (function (_super) {
    __extends(ResultViewer, _super);
    function ResultViewer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.viewer = null;
        _this._node = null;
        _this.allAddons = function () { return [
            import('codemirror/addon/fold/foldgutter'),
            import('codemirror/addon/fold/brace-fold'),
            import('codemirror/addon/dialog/dialog'),
            import('codemirror/addon/search/search'),
            import('codemirror/addon/search/searchcursor'),
            import('codemirror/addon/search/jump-to-line'),
            import('codemirror/keymap/sublime'),
            import('codemirror-graphql/results/mode'),
        ]; };
        return _this;
    }
    ResultViewer.prototype.componentDidMount = function () {
        this.initializeEditor();
    };
    ResultViewer.prototype.shouldComponentUpdate = function (nextProps) {
        return this.props.value !== nextProps.value;
    };
    ResultViewer.prototype.componentDidUpdate = function () {
        if (this.viewer) {
            this.viewer.setValue(this.props.value || '');
        }
    };
    ResultViewer.prototype.componentWillUnmount = function () {
        this.viewer = null;
    };
    ResultViewer.prototype.render = function () {
        var _this = this;
        return (React.createElement("section", { className: "result-window", "aria-label": "Result Window", "aria-live": "polite", "aria-atomic": "true", ref: function (node) {
                if (node) {
                    _this.props.registerRef(node);
                    _this._node = node;
                }
            } }));
    };
    ResultViewer.prototype.initializeEditor = function () {
        return __awaiter(this, void 0, void 0, function () {
            var CodeMirror, Tooltip, ImagePreview, tooltipDiv_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, importCodeMirror(this.allAddons(), {
                            useCommonAddons: false,
                        })];
                    case 1:
                        CodeMirror = _a.sent();
                        Tooltip = this.props.ResultsTooltip;
                        ImagePreview = this.props.ImagePreview;
                        if (!(Tooltip || ImagePreview)) return [3, 3];
                        return [4, import('codemirror-graphql/utils/info-addon')];
                    case 2:
                        _a.sent();
                        tooltipDiv_1 = document.createElement('div');
                        CodeMirror.registerHelper('info', 'graphql-results', function (token, _options, _cm, pos) {
                            var infoElements = [];
                            if (Tooltip) {
                                infoElements.push(React.createElement(Tooltip, { pos: pos }));
                            }
                            if (ImagePreview &&
                                typeof ImagePreview.shouldRender === 'function' &&
                                ImagePreview.shouldRender(token)) {
                                infoElements.push(React.createElement(ImagePreview, { token: token }));
                            }
                            if (!infoElements.length) {
                                ReactDOM.unmountComponentAtNode(tooltipDiv_1);
                                return null;
                            }
                            ReactDOM.render(React.createElement("div", null, infoElements), tooltipDiv_1);
                            return tooltipDiv_1;
                        });
                        _a.label = 3;
                    case 3:
                        this.viewer = CodeMirror(this._node, {
                            lineWrapping: true,
                            value: this.props.value || '',
                            readOnly: true,
                            theme: this.props.editorTheme || 'graphiql',
                            mode: 'graphql-results',
                            keyMap: 'sublime',
                            foldGutter: {
                                minFoldSize: 4,
                            },
                            gutters: ['CodeMirror-foldgutter'],
                            info: Boolean(this.props.ResultsTooltip || this.props.ImagePreview),
                            extraKeys: commonKeys,
                        });
                        return [2];
                }
            });
        });
    };
    ResultViewer.prototype.getCodeMirror = function () {
        return this.viewer;
    };
    ResultViewer.prototype.getClientHeight = function () {
        return this._node && this._node.clientHeight;
    };
    return ResultViewer;
}(React.Component));
export { ResultViewer };
//# sourceMappingURL=ResultViewer.js.map