import QueryStore, { QueryStoreItem } from './QueryStore';
import StorageAPI from './StorageAPI';
import { HandleEditLabelFn, HandleToggleFavoriteFn } from '../components/HistoryQuery';
export default class HistoryStore {
    private storage;
    private maxHistoryLength;
    queries: Array<QueryStoreItem>;
    history: QueryStore;
    favorite: QueryStore;
    constructor(storage: StorageAPI, maxHistoryLength: number);
    shouldSaveQuery: (query?: string | undefined, variables?: string | undefined, headers?: string | undefined, lastQuerySaved?: QueryStoreItem | undefined) => boolean;
    fetchAllQueries: () => QueryStoreItem[];
    updateHistory: (query?: string | undefined, variables?: string | undefined, headers?: string | undefined, operationName?: string | undefined) => void;
    toggleFavorite: HandleToggleFavoriteFn;
    editLabel: HandleEditLabelFn;
}
//# sourceMappingURL=HistoryStore.d.ts.map