var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
import QueryStore from './QueryStore';
import { parse } from 'graphql';
var MAX_QUERY_SIZE = 100000;
var HistoryStore = (function () {
    function HistoryStore(storage, maxHistoryLength) {
        var _this = this;
        this.storage = storage;
        this.maxHistoryLength = maxHistoryLength;
        this.shouldSaveQuery = function (query, variables, headers, lastQuerySaved) {
            if (!query) {
                return false;
            }
            try {
                parse(query);
            }
            catch (e) {
                return false;
            }
            if (query.length > MAX_QUERY_SIZE) {
                return false;
            }
            if (!lastQuerySaved) {
                return true;
            }
            if (JSON.stringify(query) === JSON.stringify(lastQuerySaved.query)) {
                if (JSON.stringify(variables) === JSON.stringify(lastQuerySaved.variables)) {
                    if (JSON.stringify(headers) === JSON.stringify(lastQuerySaved.headers)) {
                        return false;
                    }
                    if (headers && !lastQuerySaved.headers) {
                        return false;
                    }
                }
                if (variables && !lastQuerySaved.variables) {
                    return false;
                }
            }
            return true;
        };
        this.fetchAllQueries = function () {
            var historyQueries = _this.history.fetchAll();
            var favoriteQueries = _this.favorite.fetchAll();
            return historyQueries.concat(favoriteQueries);
        };
        this.updateHistory = function (query, variables, headers, operationName) {
            if (_this.shouldSaveQuery(query, variables, headers, _this.history.fetchRecent())) {
                _this.history.push({
                    query: query,
                    variables: variables,
                    headers: headers,
                    operationName: operationName,
                });
                var historyQueries = _this.history.items;
                var favoriteQueries = _this.favorite.items;
                _this.queries = historyQueries.concat(favoriteQueries);
            }
        };
        this.toggleFavorite = function (query, variables, headers, operationName, label, favorite) {
            var item = {
                query: query,
                variables: variables,
                headers: headers,
                operationName: operationName,
                label: label,
            };
            if (!_this.favorite.contains(item)) {
                item.favorite = true;
                _this.favorite.push(item);
            }
            else if (favorite) {
                item.favorite = false;
                _this.favorite.delete(item);
            }
            _this.queries = __spread(_this.history.items, _this.favorite.items);
        };
        this.editLabel = function (query, variables, headers, operationName, label, favorite) {
            var item = {
                query: query,
                variables: variables,
                headers: headers,
                operationName: operationName,
                label: label,
            };
            if (favorite) {
                _this.favorite.edit(__assign(__assign({}, item), { favorite: favorite }));
            }
            else {
                _this.history.edit(item);
            }
            _this.queries = __spread(_this.history.items, _this.favorite.items);
        };
        this.history = new QueryStore('queries', this.storage, this.maxHistoryLength);
        this.favorite = new QueryStore('favorites', this.storage, null);
        this.queries = this.fetchAllQueries();
    }
    return HistoryStore;
}());
export default HistoryStore;
//# sourceMappingURL=HistoryStore.js.map