'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findGraphQLConfigDir = findGraphQLConfigDir;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _GraphQLConfig = require('./GraphQLConfig');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Finds a .graphqlrc configuration file, and returns null if not found.
 * If the file isn't present in the provided directory path, walk up the
 * directory tree until the file is found or it reaches the root directory.
 */
/**
 *  Copyright (c) Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the license found in the
 *  LICENSE file in the root directory of this source tree.
 *
 *  
 */

function findGraphQLConfigDir(dirPath) {
  var currentPath = _path2.default.resolve(dirPath);
  while (true) {
    var filePath = _path2.default.join(currentPath, _GraphQLConfig.GRAPHQL_CONFIG_NAME);
    if (_fs2.default.existsSync(filePath)) {
      break;
    }
    if (isRootDir(currentPath)) {
      break;
    }
    currentPath = _path2.default.dirname(currentPath);
  }

  return !isRootDir(currentPath) ? currentPath : null;
}

function isRootDir(dirPath) {
  return _path2.default.dirname(dirPath) === dirPath;
}