'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphQLLanguageService = undefined;

var _kinds = require('graphql/language/kinds');

var _graphql = require('graphql');

var _getAutocompleteSuggestions2 = require('./getAutocompleteSuggestions');

var _getDiagnostics = require('./getDiagnostics');

var _getDefinition = require('./getDefinition');

var _graphqlLanguageServiceUtils = require('graphql-language-service-utils');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
                                                                                                                                                           *  Copyright (c) Facebook, Inc.
                                                                                                                                                           *  All rights reserved.
                                                                                                                                                           *
                                                                                                                                                           *  This source code is licensed under the license found in the
                                                                                                                                                           *  LICENSE file in the root directory of this source tree.
                                                                                                                                                           *
                                                                                                                                                           *  
                                                                                                                                                           */

var GraphQLLanguageService = exports.GraphQLLanguageService = function () {
  function GraphQLLanguageService(cache) {
    _classCallCheck(this, GraphQLLanguageService);

    this._graphQLCache = cache;
    this._graphQLConfig = cache.getGraphQLConfig();
  }

  GraphQLLanguageService.prototype.getDiagnostics = function getDiagnostics(query, uri) {
    var source, appName, schema, customRules, fragmentDefinitions, fragmentDependencies, dependenciesSource, customRulesModulePath, rulesPath;
    return regeneratorRuntime.async(function getDiagnostics$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            source = query;
            appName = this._graphQLConfig.getAppConfigNameByFilePath(uri);
            // If there's a matching config, proceed to prepare to run validation

            schema = void 0;
            customRules = void 0;

            if (!this._graphQLConfig.getSchemaPath(appName)) {
              _context.next = 18;
              break;
            }

            _context.next = 7;
            return regeneratorRuntime.awrap(this._graphQLCache.getSchema(this._graphQLConfig.getSchemaPath(appName)));

          case 7:
            schema = _context.sent;
            _context.next = 10;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDefinitions(this._graphQLConfig, appName));

          case 10:
            fragmentDefinitions = _context.sent;
            _context.next = 13;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDependencies(query, fragmentDefinitions));

          case 13:
            fragmentDependencies = _context.sent;
            dependenciesSource = fragmentDependencies.reduce(function (prev, cur) {
              return prev + ' ' + (0, _graphql.print)(cur.definition);
            }, '');


            source = source + ' ' + dependenciesSource;

            // Check if there are custom validation rules to be used
            customRulesModulePath = this._graphQLConfig.getCustomValidationRulesModulePath(appName);

            if (customRulesModulePath) {
              rulesPath = require.resolve(customRulesModulePath);

              if (rulesPath) {
                customRules = require(rulesPath)(this._graphQLConfig);
              }
            }

          case 18:
            return _context.abrupt('return', (0, _getDiagnostics.getDiagnostics)(source, schema, customRules));

          case 19:
          case 'end':
            return _context.stop();
        }
      }
    }, null, this);
  };

  GraphQLLanguageService.prototype.getAutocompleteSuggestions = function getAutocompleteSuggestions(query, position, filePath) {
    var appName, schema;
    return regeneratorRuntime.async(function getAutocompleteSuggestions$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            appName = this._graphQLConfig.getAppConfigNameByFilePath(filePath);
            schema = void 0;

            if (!this._graphQLConfig.getSchemaPath(appName)) {
              _context2.next = 8;
              break;
            }

            _context2.next = 5;
            return regeneratorRuntime.awrap(this._graphQLCache.getSchema(this._graphQLConfig.getSchemaPath(appName)));

          case 5:
            schema = _context2.sent;

            if (!schema) {
              _context2.next = 8;
              break;
            }

            return _context2.abrupt('return', (0, _getAutocompleteSuggestions2.getAutocompleteSuggestions)(schema, query, position));

          case 8:
            return _context2.abrupt('return', []);

          case 9:
          case 'end':
            return _context2.stop();
        }
      }
    }, null, this);
  };

  GraphQLLanguageService.prototype.getDefinition = function getDefinition(query, position, filePath) {
    var appName, ast, node;
    return regeneratorRuntime.async(function getDefinition$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            appName = this._graphQLConfig.getAppConfigNameByFilePath(filePath);
            ast = void 0;
            _context3.prev = 2;

            ast = (0, _graphql.parse)(query);
            _context3.next = 9;
            break;

          case 6:
            _context3.prev = 6;
            _context3.t0 = _context3['catch'](2);
            return _context3.abrupt('return', null);

          case 9:
            node = (0, _graphqlLanguageServiceUtils.getASTNodeAtPosition)(query, ast, position);

            if (!node) {
              _context3.next = 16;
              break;
            }

            _context3.t1 = node.kind;
            _context3.next = _context3.t1 === _kinds.FRAGMENT_SPREAD ? 14 : _context3.t1 === _kinds.FRAGMENT_DEFINITION ? 15 : _context3.t1 === _kinds.OPERATION_DEFINITION ? 15 : 16;
            break;

          case 14:
            return _context3.abrupt('return', this._getDefinitionForFragmentSpread(query, ast, node, filePath, this._graphQLConfig, appName));

          case 15:
            return _context3.abrupt('return', (0, _getDefinition.getDefinitionQueryResultForDefinitionNode)(filePath, query, node));

          case 16:
            return _context3.abrupt('return', null);

          case 17:
          case 'end':
            return _context3.stop();
        }
      }
    }, null, this, [[2, 6]]);
  };

  GraphQLLanguageService.prototype._getDefinitionForFragmentSpread = function _getDefinitionForFragmentSpread(query, ast, node, filePath, graphQLConfig, appName) {
    var fragmentDefinitions, dependencies, localFragDefinitions, typeCastedDefs, localFragInfos, result;
    return regeneratorRuntime.async(function _getDefinitionForFragmentSpread$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDefinitions(graphQLConfig, appName));

          case 2:
            fragmentDefinitions = _context4.sent;
            _context4.next = 5;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDependenciesForAST(ast, fragmentDefinitions));

          case 5:
            dependencies = _context4.sent;
            localFragDefinitions = ast.definitions.filter(function (definition) {
              return definition.kind === _kinds.FRAGMENT_DEFINITION;
            });
            typeCastedDefs = localFragDefinitions;
            localFragInfos = typeCastedDefs.map(function (definition) {
              return {
                filePath: filePath,
                content: query,
                definition: definition
              };
            });
            _context4.next = 11;
            return regeneratorRuntime.awrap((0, _getDefinition.getDefinitionQueryResultForFragmentSpread)(query, node, dependencies.concat(localFragInfos)));

          case 11:
            result = _context4.sent;
            return _context4.abrupt('return', result);

          case 13:
          case 'end':
            return _context4.stop();
        }
      }
    }, null, this);
  };

  return GraphQLLanguageService;
}();