/*
 * Input Mask plugin for jquery
 * http://github.com/RobinHerbots/jquery.inputmask
 * Copyright (c) Robin Herbots
 * Licensed under the MIT license
 */
var $ = require("jquery"), Inputmask = require("./inputmask");
if ($.fn.inputmask === undefined) {
    //jquery plugin
    $.fn.inputmask = function (fn, options) {
        var nptmask, input = this[0];
        if (options === undefined) options = {};
        if (typeof fn === "string") {
            switch (fn) {
                case "unmaskedvalue":
                    return input && input.inputmask ? input.inputmask.unmaskedvalue() : $(input).val();
                case "remove":
                    return this.each(function () {
                        if (this.inputmask) this.inputmask.remove();
                    });
                case "getemptymask":
                    return input && input.inputmask ? input.inputmask.getemptymask() : "";
                case "hasMaskedValue": //check whether the returned value is masked or not; currently only works reliable when using jquery.val fn to retrieve the value
                    return input && input.inputmask ? input.inputmask.hasMaskedValue() : false;
                case "isComplete":
                    return input && input.inputmask ? input.inputmask.isComplete() : true;
                case "getmetadata": //return mask metadata if exists
                    return input && input.inputmask ? input.inputmask.getmetadata() : undefined;
                case "setvalue":
                    Inputmask.setValue(input, options);
                    break;
                case "option":
                    if (typeof options === "string") {
                        if (input && input.inputmask !== undefined) {
                            return input.inputmask.option(options);
                        }
                    } else {
                        return this.each(function () {
                            if (this.inputmask !== undefined) {
                                return this.inputmask.option(options);
                            }
                        });
                    }
                    break;
                default:
                    options.alias = fn;
                    nptmask = new Inputmask(options);
                    return this.each(function () {
                        nptmask.mask(this);
                    });
            }
        } else if (Array.isArray(fn)) {
            options.alias = fn;
            nptmask = new Inputmask(options);
            return this.each(function () {
                nptmask.mask(this);
            });
        } else if (typeof fn == "object") {
            nptmask = new Inputmask(fn);
            if (fn.mask === undefined && fn.alias === undefined) {
                return this.each(function () {
                    if (this.inputmask !== undefined) {
                        return this.inputmask.option(fn);
                    } else nptmask.mask(this);
                });
            } else {
                return this.each(function () {
                    nptmask.mask(this);
                });
            }
        } else if (fn === undefined) {
            //look for data-inputmask atributes
            return this.each(function () {
                nptmask = new Inputmask(options);
                nptmask.mask(this);
            });
        }
    };
}
