// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/dom/focus-trap
//   ../../@material/base/foundation

declare module '@material/banner' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/banner/adapter';
    export * from '@material/banner/component';
    export * from '@material/banner/constants';
    export * from '@material/banner/foundation';
}

declare module '@material/banner/adapter' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { CloseReason } from '@material/banner/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCBannerAdapter {
            /**
                * Adds the given class to the banner root element.
                */
            addClass(className: string): void;
            /**
                * @return Returns the height of the banner content element.
                */
            getContentHeight(): number;
            /**
                * Broadcasts an event denoting that the banner has finished closing.
                */
            notifyClosed(reason: CloseReason): void;
            /**
                * Broadcasts an event denoting that the banner has just started closing.
                */
            notifyClosing(reason: CloseReason): void;
            /**
                * Broadcasts an event denoting that the banner has finished opening.
                */
            notifyOpened(): void;
            /**
                * Broadcasts an event denoting that the banner has just started opening.
                */
            notifyOpening(): void;
            /**
                * Releases focus from banner and restores focus to the previously focused
                * element.
                */
            releaseFocus(): void;
            /**
                * Removes the given class from the banner root element.
                */
            removeClass(className: string): void;
            /**
                * Sets a style property of the banner root element to the passed value.
                */
            setStyleProperty(propertyName: string, value: string): void;
            /**
                * Traps focus in banner and focuses on the primary action button.
                */
            trapFocus(): void;
    }
}

declare module '@material/banner/component' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { CloseReason, MDCBannerFocusTrapFactory } from '@material/banner/constants';
    import { MDCBannerFoundation } from '@material/banner/foundation';
    /** Vanilla JS implementation of banner component. */
    export class MDCBanner extends MDCComponent<MDCBannerFoundation> {
            static attachTo(root: Element): MDCBanner;
            root: HTMLElement;
            initialize(focusTrapFactory?: MDCBannerFocusTrapFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            layout(): void;
            /**
                * Opens the banner and fires events.OPENING to indicate the beginning of its
                * opening animation and then events.OPENED once the animation finishes.
                */
            open(): void;
            /**
                * Closes the banner and fires events.CLOSING to indicate the beginning of its
                * closing animation and then events.CLOSED once the animation finishes.
                * @param reason Why the banner was closed. Value will be passed to
                *     events.CLOSING and events.CLOSED via the `event.detail.reason`
                *     property. Standard values are CloseReason.PRIMARY and
                *     CloseReason.SECONDARY, but CloseReason.UNSPECIFIED is provided for
                *     custom handling of programmatic closing of the banner.
                */
            close(reason: CloseReason): void;
            getDefaultFoundation(): MDCBannerFoundation;
            get isOpen(): boolean;
            getText(): string;
            setText(text: string): void;
            getPrimaryActionText(): string;
            setPrimaryActionText(actionButtonText: string): void;
            /** Returns null if the banner has no secondary action. */
            getSecondaryActionText(): string | null;
            setSecondaryActionText(actionButtonText: string): void;
    }
}

declare module '@material/banner/constants' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { FocusOptions, FocusTrap } from '@material/dom/focus-trap';
    /** Banner element classes. */
    export const cssClasses: {
        CLOSING: string;
        OPEN: string;
        OPENING: string;
    };
    /** Banner numbers. */
    export const numbers: {
        BANNER_ANIMATION_CLOSE_TIME_MS: number;
        BANNER_ANIMATION_OPEN_TIME_MS: number;
    };
    /** Banner events. */
    export const events: {
        CLOSED: string;
        CLOSING: string;
        OPENED: string;
        OPENING: string;
    };
    /** Banner selectors. */
    export const selectors: {
        CONTENT: string;
        PRIMARY_ACTION: string;
        SECONDARY_ACTION: string;
        TEXT: string;
    };
    /** Reason as to why the banner was closed. */
    export enum CloseReason {
        PRIMARY = 0,
        SECONDARY = 1,
        UNSPECIFIED = 2
    }
    /** Interface for the detail of the closing and closed events emitted. */
    export interface MDCBannerCloseEventDetail {
        reason: CloseReason;
    }
    /**  */
    export type MDCBannerFocusTrapFactory = (element: HTMLElement, options: FocusOptions) => FocusTrap;
}

declare module '@material/banner/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCBannerAdapter } from '@material/banner/adapter';
    import { CloseReason } from '@material/banner/constants';
    /**
        * Foundation class for banner. Responsibilities include opening and closing the
        * banner.
        */
    export class MDCBannerFoundation extends MDCFoundation<MDCBannerAdapter> {
            static get defaultAdapter(): MDCBannerAdapter;
            constructor(adapter?: Partial<MDCBannerAdapter>);
            destroy(): void;
            open(): void;
            /**
                * @param reason Why the banner was closed. Value will be passed to
                *     events.CLOSING and events.CLOSED via the `event.detail.reason`
                *     property. Standard values are CloseReason.PRIMARY and
                *     CloseReason.SECONDARY, but CloseReason.UNSPECIFIED is provided for
                *     custom handling of programmatic closing of the banner.
                */
            close(reason: CloseReason): void;
            isOpen(): boolean;
            handlePrimaryActionClick(): void;
            handleSecondaryActionClick(): void;
            layout(): void;
    }
}

