/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * CssClasses provides the named constants for class names.
 */
export var CssClasses;
(function (CssClasses) {
    CssClasses["SELECTING"] = "mdc-evolution-chip--selecting";
    CssClasses["DESELECTING"] = "mdc-evolution-chip--deselecting";
    CssClasses["SELECTING_WITH_PRIMARY_ICON"] = "mdc-evolution-chip--selecting-with-primary-icon";
    CssClasses["DESELECTING_WITH_PRIMARY_ICON"] = "mdc-evolution-chip--deselecting-with-primary-icon";
    CssClasses["DISABLED"] = "mdc-evolution-chip--disabled";
    CssClasses["ENTER"] = "mdc-evolution-chip--enter";
    CssClasses["EXIT"] = "mdc-evolution-chip--exit";
    CssClasses["SELECTED"] = "mdc-evolution-chip--selected";
    CssClasses["HIDDEN"] = "mdc-evolution-chip--hidden";
    CssClasses["WITH_PRIMARY_ICON"] = "mdc-evolution-chip--with-primary-icon";
})(CssClasses || (CssClasses = {}));
/**
 * Events provides the named constants for emitted events.
 */
export var Events;
(function (Events) {
    Events["INTERACTION"] = "MDCChip:interaction";
    Events["NAVIGATION"] = "MDCChip:navigation";
    Events["ANIMATION"] = "MDCChip:animation";
})(Events || (Events = {}));
/**
 * Events provides the named constants for strings used by the foundation.
 */
export var Attributes;
(function (Attributes) {
    Attributes["DATA_REMOVED_ANNOUNCEMENT"] = "data-mdc-removed-announcement";
    Attributes["DATA_ADDED_ANNOUNCEMENT"] = "data-mdc-added-announcement";
})(Attributes || (Attributes = {}));
/**
 * Animation provides the names of runnable animations.
 */
export var Animation;
(function (Animation) {
    Animation["ENTER"] = "mdc-evolution-chip-enter";
    Animation["EXIT"] = "mdc-evolution-chip-exit";
})(Animation || (Animation = {}));
//# sourceMappingURL=constants.js.map