// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../@material/base/component
//   ../../../@material/base/foundation

declare module 'mdc-notched-outline' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from 'mdc-notched-outline/adapter';
    export * from 'mdc-notched-outline/component';
    export * from 'mdc-notched-outline/foundation';
}

declare module 'mdc-notched-outline/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCNotchedOutlineAdapter {
            /**
                * Adds a class to the root element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the root element.
                */
            removeClass(className: string): void;
            /**
                * Sets the width style property of the notch element.
                */
            setNotchWidthProperty(width: number): void;
            /**
                * Removes the width style property from the notch element.
                */
            removeNotchWidthProperty(): void;
    }
}

declare module 'mdc-notched-outline/component' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCNotchedOutlineFoundation } from 'mdc-notched-outline/foundation';
    export type MDCNotchedOutlineFactory = (el: Element, foundation?: MDCNotchedOutlineFoundation) => MDCNotchedOutline;
    export class MDCNotchedOutline extends MDCComponent<MDCNotchedOutlineFoundation> {
            static attachTo(root: Element): MDCNotchedOutline;
            initialSyncWithDOM(): void;
            /**
                * Updates classes and styles to open the notch to the specified width.
                * @param notchWidth The notch width in the outline.
                */
            notch(notchWidth: number): void;
            /**
                * Updates classes and styles to close the notch.
                */
            closeNotch(): void;
            getDefaultFoundation(): MDCNotchedOutlineFoundation;
    }
}

declare module 'mdc-notched-outline/foundation' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCNotchedOutlineAdapter } from 'mdc-notched-outline/adapter';
    export class MDCNotchedOutlineFoundation extends MDCFoundation<MDCNotchedOutlineAdapter> {
            static readonly strings: {
                    NOTCH_ELEMENT_SELECTOR: string;
            };
            static readonly cssClasses: {
                    NO_LABEL: string;
                    OUTLINE_NOTCHED: string;
                    OUTLINE_UPGRADED: string;
            };
            static readonly numbers: {
                    NOTCH_ELEMENT_PADDING: number;
            };
            /**
                * See {@link MDCNotchedOutlineAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCNotchedOutlineAdapter;
            constructor(adapter?: Partial<MDCNotchedOutlineAdapter>);
            /**
                * Adds the outline notched selector and updates the notch width calculated based off of notchWidth.
                */
            notch(notchWidth: number): void;
            /**
                * Removes notched outline selector to close the notch in the outline.
                */
            closeNotch(): void;
    }
    export default MDCNotchedOutlineFoundation;
}

