// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/foundation
//   ../../@material/base/component
//   ../../@material/ripple/component
//   ../../@material/ripple/types

declare module '@material/segmented-button' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/segmented-button/segmented-button/index';
    export * from '@material/segmented-button/segment/index';
    export * from '@material/segmented-button/types';
}

declare module '@material/segmented-button/segmented-button/index' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/segmented-button/segmented-button/adapter';
    export * from '@material/segmented-button/segmented-button/foundation';
    export * from '@material/segmented-button/segmented-button/component';
}

declare module '@material/segmented-button/segment/index' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/segmented-button/segment/adapter';
    export * from '@material/segmented-button/segment/foundation';
    export * from '@material/segmented-button/segment/component';
}

declare module '@material/segmented-button/types' {
    /**
        * Event detail triggered by a click on a segment. This event detail is used
        * to alert the segment-button to the change and trigger a DOM event.
        */
    export interface SegmentDetail {
            index: number;
            selected: boolean;
            segmentId?: string;
    }
    /**
        * Event emitted by segment to alert the segment-button of a change in its
        * selected status.
        */
    export interface MDCSegmentedButtonEvent extends Event {
            readonly detail: SegmentDetail;
    }
}

declare module '@material/segmented-button/segmented-button/adapter' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { SegmentDetail } from '@material/segmented-button/types';
    export interface MDCSegmentedButtonAdapter {
            /**
                * @param className Class of interest
                * @return Returns true if segmented button has css class, otherwise returns
                * false
                */
            hasClass(className: string): boolean;
            /**
                * @return Returns child segments represented as readonly list of
                * SegmentDetails
                */
            getSegments(): readonly SegmentDetail[];
            /**
                * Sets identified child segment to be selected
                *
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                */
            selectSegment(indexOrSegmentId: number | string): void;
            /**
                * Sets identified child segment to be not selected
                *
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                */
            unselectSegment(indexOrSegmentId: number | string): void;
            /**
                * Emits event about changed child segment to client
                *
                * @param detail Changed child segment represented as a SegmentDetail
                * @event change With detail - SegmentDetail
                */
            notifySelectedChange(detail: SegmentDetail): void;
    }
}

declare module '@material/segmented-button/segmented-button/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { SegmentDetail } from '@material/segmented-button/types';
    import { MDCSegmentedButtonAdapter } from '@material/segmented-button/segmented-button/adapter';
    export class MDCSegmentedButtonFoundation extends MDCFoundation<MDCSegmentedButtonAdapter> {
            static get defaultAdapter(): MDCSegmentedButtonAdapter;
            constructor(adapter?: Partial<MDCSegmentedButtonAdapter>);
            /**
                * Sets identified child segment to be selected
                *
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                */
            selectSegment(indexOrSegmentId: number | string): void;
            /**
                * Sets identified child segment to be not selected
                *
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                */
            unselectSegment(indexOrSegmentId: number | string): void;
            /**
                * @return Returns currently selected child segments as readonly list of
                * SegmentDetails
                */
            getSelectedSegments(): readonly SegmentDetail[];
            /**
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                * @return Returns true if identified child segment is currently selected,
                * otherwise returns false
                */
            isSegmentSelected(indexOrSegmentId: number | string | undefined): boolean;
            /**
                * @return Returns true if segmented button is single select, otherwise
                * returns false
                */
            isSingleSelect(): boolean;
            /**
                * Called when child segment's selected status may have changed. If segmented
                * button is single select, unselects all child segments other than identified
                * child segment. Finally, emits event to client.
                *
                * @param detail Child segment affected represented as SegmentDetail
                * @event change With detail - SegmentDetail
                */
            handleSelected(detail: SegmentDetail): void;
    }
}

declare module '@material/segmented-button/segmented-button/component' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCSegmentedButtonSegment, MDCSegmentedButtonSegmentFactory } from '@material/segmented-button/segment/component';
    import { SegmentDetail } from '@material/segmented-button/types';
    import { MDCSegmentedButtonFoundation } from '@material/segmented-button/segmented-button/foundation';
    export class MDCSegmentedButton extends MDCComponent<MDCSegmentedButtonFoundation> {
            static attachTo(root: Element): MDCSegmentedButton;
            get segments(): ReadonlyArray<MDCSegmentedButtonSegment>;
            initialize(segmentFactory?: MDCSegmentedButtonSegmentFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCSegmentedButtonFoundation;
            /**
                * @return Returns readonly list of selected child segments as SegmentDetails
                */
            getSelectedSegments(): readonly SegmentDetail[];
            /**
                * Sets identified segment to be selected
                *
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                */
            selectSegment(indexOrSegmentId: number | string): void;
            /**
                * Sets identified segment to be not selected
                *
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                */
            unselectSegment(indexOrSegmentId: number | string): void;
            /**
                * @param indexOrSegmentId Number index or string segmentId that identifies
                * child segment
                * @return Returns true if identified child segment is currently selected,
                * otherwise returns false
                */
            isSegmentSelected(indexOrSegmentId: number | string): boolean;
    }
}

declare module '@material/segmented-button/segment/adapter' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    export interface MDCSegmentedButtonSegmentAdapter {
            /**
                * @return Returns true if wrapping segmented button is single select
                */
            isSingleSelect(): boolean;
            /**
                * @param attrName Attribute of interest
                * @return Returns segment's attribute value if it is set, otherwise returns
                * null
                */
            getAttr(attrName: string): string | null;
            /**
                * Sets segment's attribute value to new value
                *
                * @param attrName Attribute of interest
                * @param value New value of attribute
                */
            setAttr(attrName: string, value: string): void;
            /**
                * Adds css class to segment
                *
                * @param className Class to add
                */
            addClass(className: string): void;
            /**
                * Removes css class from segment
                *
                * @param className Class to remove
                */
            removeClass(className: string): void;
            /**
                * @param className Class of interest
                * @return Returns true if segment has css class, otherwise returns false
                */
            hasClass(className: string): boolean;
            /**
                * Emits event about segment to wrapping segmented button
                *
                * @param selected Represents whether segment is currently selected
                * @event selected With detail - SegmentDetail
                */
            notifySelectedChange(selected: boolean): void;
            /**
                * @return Returns bounding rectangle for ripple effect
                */
            getRootBoundingClientRect(): ClientRect;
    }
}

declare module '@material/segmented-button/segment/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSegmentedButtonSegmentAdapter } from '@material/segmented-button/segment/adapter';
    export class MDCSegmentedButtonSegmentFoundation extends MDCFoundation<MDCSegmentedButtonSegmentAdapter> {
            static get defaultAdapter(): MDCSegmentedButtonSegmentAdapter;
            constructor(adapter?: Partial<MDCSegmentedButtonSegmentAdapter>);
            /**
                * @return Returns true if segment is currently selected, otherwise returns
                * false
                */
            isSelected(): boolean;
            /**
                * Sets segment to be selected
                */
            setSelected(): void;
            /**
                * Sets segment to be not selected
                */
            setUnselected(): void;
            /**
                * @return Returns segment's segmentId if it was set by client
                */
            getSegmentId(): string | undefined;
            /**
                * Called when segment is clicked. If the wrapping segmented button is single
                * select, doesn't allow segment to be set to not selected. Otherwise, toggles
                * segment's selected status. Finally, emits event to wrapping segmented
                * button.
                *
                * @event selected With detail - SegmentDetail
                */
            handleClick(): void;
            /**
                * @return Returns bounding rectangle for ripple effect
                */
            getDimensions(): ClientRect;
    }
}

declare module '@material/segmented-button/segment/component' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCRipple, MDCRippleFactory } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCSegmentedButtonSegmentFoundation } from '@material/segmented-button/segment/foundation';
    /**
        * MDCSegmentedButtonSegment factory type.
        */
    export type MDCSegmentedButtonSegmentFactory = (el: Element, foundation?: MDCSegmentedButtonSegmentFoundation) => MDCSegmentedButtonSegment;
    /**
        * Implementation of MDCSegmentedButtonSegmentFoundation
        */
    export class MDCSegmentedButtonSegment extends MDCComponent<MDCSegmentedButtonSegmentFoundation> implements MDCRippleCapableSurface {
            get ripple(): MDCRipple;
            static attachTo(root: Element): MDCSegmentedButtonSegment;
            initialize(rippleFactory?: MDCRippleFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCSegmentedButtonSegmentFoundation;
            /**
                * Sets segment's index value
                *
                * @param index Segment's index within wrapping segmented button
                */
            setIndex(index: number): void;
            /**
                * Sets segment's isSingleSelect value
                *
                * @param isSingleSelect True if wrapping segmented button is single select
                */
            setIsSingleSelect(isSingleSelect: boolean): void;
            /**
                * @return Returns true if segment is currently selected, otherwise returns
                * false
                */
            isSelected(): boolean;
            /**
                * Sets segment to be selected
                */
            setSelected(): void;
            /**
                * Sets segment to be not selected
                */
            setUnselected(): void;
            /**
                * @return Returns segment's segmentId if it was set by client
                */
            getSegmentId(): string | undefined;
    }
}

