/**
 * @license
 * Copyright 2020 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/** Slider element classes. */
export declare const cssClasses: {
    DISABLED: string;
    DISCRETE: string;
    INPUT: string;
    RANGE: string;
    THUMB: string;
    THUMB_FOCUSED: string;
    THUMB_KNOB: string;
    THUMB_TOP: string;
    THUMB_WITH_INDICATOR: string;
    TICK_MARKS: string;
    TICK_MARKS_CONTAINER: string;
    TICK_MARK_ACTIVE: string;
    TICK_MARK_INACTIVE: string;
    TRACK: string;
    TRACK_ACTIVE: string;
    VALUE_INDICATOR_TEXT: string;
};
/** Slider numbers. */
export declare const numbers: {
    STEP_SIZE: number;
    THUMB_UPDATE_MIN_PX: number;
};
/** Slider attributes. */
export declare const attributes: {
    ARIA_VALUETEXT: string;
    INPUT_DISABLED: string;
    INPUT_MIN: string;
    INPUT_MAX: string;
    INPUT_VALUE: string;
    INPUT_STEP: string;
};
/** Slider events. */
export declare const events: {
    CHANGE: string;
    INPUT: string;
};
