var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.mermaid = factory());
})(this, function() {
  "use strict";
  function dedent(templ) {
    var values2 = [];
    for (var _i = 1; _i < arguments.length; _i++) {
      values2[_i - 1] = arguments[_i];
    }
    var strings = Array.from(typeof templ === "string" ? [templ] : templ);
    strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
    var indentLengths = strings.reduce(function(arr, str2) {
      var matches2 = str2.match(/\n([\t ]+|(?!\s).)/g);
      if (matches2) {
        return arr.concat(matches2.map(function(match5) {
          var _a, _b;
          return (_b = (_a = match5.match(/[\t ]/g)) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0;
        }));
      }
      return arr;
    }, []);
    if (indentLengths.length) {
      var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
      strings = strings.map(function(str2) {
        return str2.replace(pattern_1, "\n");
      });
    }
    strings[0] = strings[0].replace(/^\r?\n/, "");
    var string2 = strings[0];
    values2.forEach(function(value, i2) {
      var endentations = string2.match(/(?:^|\n)( *)$/);
      var endentation = endentations ? endentations[1] : "";
      var indentedValue = value;
      if (typeof value === "string" && value.includes("\n")) {
        indentedValue = String(value).split("\n").map(function(str2, i3) {
          return i3 === 0 ? str2 : "" + endentation + str2;
        }).join("\n");
      }
      string2 += indentedValue + strings[i2 + 1];
    });
    return string2;
  }
  //! moment.js
  //! version : 2.29.4
  //! authors : Tim Wood, Iskren Chernev, Moment.js contributors
  //! license : MIT
  //! momentjs.com
  var hookCallback;
  function hooks() {
    return hookCallback.apply(null, arguments);
  }
  function setHookCallback(callback) {
    hookCallback = callback;
  }
  function isArray$7(input) {
    return input instanceof Array || Object.prototype.toString.call(input) === "[object Array]";
  }
  function isObject$8(input) {
    return input != null && Object.prototype.toString.call(input) === "[object Object]";
  }
  function hasOwnProp(a, b) {
    return Object.prototype.hasOwnProperty.call(a, b);
  }
  function isObjectEmpty(obj) {
    if (Object.getOwnPropertyNames) {
      return Object.getOwnPropertyNames(obj).length === 0;
    } else {
      var k;
      for (k in obj) {
        if (hasOwnProp(obj, k)) {
          return false;
        }
      }
      return true;
    }
  }
  function isUndefined$1(input) {
    return input === void 0;
  }
  function isNumber(input) {
    return typeof input === "number" || Object.prototype.toString.call(input) === "[object Number]";
  }
  function isDate(input) {
    return input instanceof Date || Object.prototype.toString.call(input) === "[object Date]";
  }
  function map$3(arr, fn2) {
    var res = [], i2, arrLen = arr.length;
    for (i2 = 0; i2 < arrLen; ++i2) {
      res.push(fn2(arr[i2], i2));
    }
    return res;
  }
  function extend$3(a, b) {
    for (var i2 in b) {
      if (hasOwnProp(b, i2)) {
        a[i2] = b[i2];
      }
    }
    if (hasOwnProp(b, "toString")) {
      a.toString = b.toString;
    }
    if (hasOwnProp(b, "valueOf")) {
      a.valueOf = b.valueOf;
    }
    return a;
  }
  function createUTC(input, format2, locale2, strict) {
    return createLocalOrUTC(input, format2, locale2, strict, true).utc();
  }
  function defaultParsingFlags() {
    return {
      empty: false,
      unusedTokens: [],
      unusedInput: [],
      overflow: -2,
      charsLeftOver: 0,
      nullInput: false,
      invalidEra: null,
      invalidMonth: null,
      invalidFormat: false,
      userInvalidated: false,
      iso: false,
      parsedDateParts: [],
      era: null,
      meridiem: null,
      rfc2822: false,
      weekdayMismatch: false
    };
  }
  function getParsingFlags(m) {
    if (m._pf == null) {
      m._pf = defaultParsingFlags();
    }
    return m._pf;
  }
  var some;
  if (Array.prototype.some) {
    some = Array.prototype.some;
  } else {
    some = function(fun) {
      var t = Object(this), len = t.length >>> 0, i2;
      for (i2 = 0; i2 < len; i2++) {
        if (i2 in t && fun.call(this, t[i2], i2, t)) {
          return true;
        }
      }
      return false;
    };
  }
  function isValid(m) {
    if (m._isValid == null) {
      var flags = getParsingFlags(m), parsedParts = some.call(flags.parsedDateParts, function(i2) {
        return i2 != null;
      }), isNowValid = !isNaN(m._d.getTime()) && flags.overflow < 0 && !flags.empty && !flags.invalidEra && !flags.invalidMonth && !flags.invalidWeekday && !flags.weekdayMismatch && !flags.nullInput && !flags.invalidFormat && !flags.userInvalidated && (!flags.meridiem || flags.meridiem && parsedParts);
      if (m._strict) {
        isNowValid = isNowValid && flags.charsLeftOver === 0 && flags.unusedTokens.length === 0 && flags.bigHour === void 0;
      }
      if (Object.isFrozen == null || !Object.isFrozen(m)) {
        m._isValid = isNowValid;
      } else {
        return isNowValid;
      }
    }
    return m._isValid;
  }
  function createInvalid(flags) {
    var m = createUTC(NaN);
    if (flags != null) {
      extend$3(getParsingFlags(m), flags);
    } else {
      getParsingFlags(m).userInvalidated = true;
    }
    return m;
  }
  var momentProperties = hooks.momentProperties = [], updateInProgress = false;
  function copyConfig(to2, from2) {
    var i2, prop, val, momentPropertiesLen = momentProperties.length;
    if (!isUndefined$1(from2._isAMomentObject)) {
      to2._isAMomentObject = from2._isAMomentObject;
    }
    if (!isUndefined$1(from2._i)) {
      to2._i = from2._i;
    }
    if (!isUndefined$1(from2._f)) {
      to2._f = from2._f;
    }
    if (!isUndefined$1(from2._l)) {
      to2._l = from2._l;
    }
    if (!isUndefined$1(from2._strict)) {
      to2._strict = from2._strict;
    }
    if (!isUndefined$1(from2._tzm)) {
      to2._tzm = from2._tzm;
    }
    if (!isUndefined$1(from2._isUTC)) {
      to2._isUTC = from2._isUTC;
    }
    if (!isUndefined$1(from2._offset)) {
      to2._offset = from2._offset;
    }
    if (!isUndefined$1(from2._pf)) {
      to2._pf = getParsingFlags(from2);
    }
    if (!isUndefined$1(from2._locale)) {
      to2._locale = from2._locale;
    }
    if (momentPropertiesLen > 0) {
      for (i2 = 0; i2 < momentPropertiesLen; i2++) {
        prop = momentProperties[i2];
        val = from2[prop];
        if (!isUndefined$1(val)) {
          to2[prop] = val;
        }
      }
    }
    return to2;
  }
  function Moment(config2) {
    copyConfig(this, config2);
    this._d = new Date(config2._d != null ? config2._d.getTime() : NaN);
    if (!this.isValid()) {
      this._d = new Date(NaN);
    }
    if (updateInProgress === false) {
      updateInProgress = true;
      hooks.updateOffset(this);
      updateInProgress = false;
    }
  }
  function isMoment(obj) {
    return obj instanceof Moment || obj != null && obj._isAMomentObject != null;
  }
  function warn$1(msg) {
    if (hooks.suppressDeprecationWarnings === false && typeof console !== "undefined" && console.warn) {
      console.warn("Deprecation warning: " + msg);
    }
  }
  function deprecate(msg, fn2) {
    var firstTime = true;
    return extend$3(function() {
      if (hooks.deprecationHandler != null) {
        hooks.deprecationHandler(null, msg);
      }
      if (firstTime) {
        var args = [], arg, i2, key, argLen = arguments.length;
        for (i2 = 0; i2 < argLen; i2++) {
          arg = "";
          if (typeof arguments[i2] === "object") {
            arg += "\n[" + i2 + "] ";
            for (key in arguments[0]) {
              if (hasOwnProp(arguments[0], key)) {
                arg += key + ": " + arguments[0][key] + ", ";
              }
            }
            arg = arg.slice(0, -2);
          } else {
            arg = arguments[i2];
          }
          args.push(arg);
        }
        warn$1(
          msg + "\nArguments: " + Array.prototype.slice.call(args).join("") + "\n" + new Error().stack
        );
        firstTime = false;
      }
      return fn2.apply(this, arguments);
    }, fn2);
  }
  var deprecations = {};
  function deprecateSimple(name2, msg) {
    if (hooks.deprecationHandler != null) {
      hooks.deprecationHandler(name2, msg);
    }
    if (!deprecations[name2]) {
      warn$1(msg);
      deprecations[name2] = true;
    }
  }
  hooks.suppressDeprecationWarnings = false;
  hooks.deprecationHandler = null;
  function isFunction$3(input) {
    return typeof Function !== "undefined" && input instanceof Function || Object.prototype.toString.call(input) === "[object Function]";
  }
  function set$6(config2) {
    var prop, i2;
    for (i2 in config2) {
      if (hasOwnProp(config2, i2)) {
        prop = config2[i2];
        if (isFunction$3(prop)) {
          this[i2] = prop;
        } else {
          this["_" + i2] = prop;
        }
      }
    }
    this._config = config2;
    this._dayOfMonthOrdinalParseLenient = new RegExp(
      (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) + "|" + /\d{1,2}/.source
    );
  }
  function mergeConfigs(parentConfig, childConfig) {
    var res = extend$3({}, parentConfig), prop;
    for (prop in childConfig) {
      if (hasOwnProp(childConfig, prop)) {
        if (isObject$8(parentConfig[prop]) && isObject$8(childConfig[prop])) {
          res[prop] = {};
          extend$3(res[prop], parentConfig[prop]);
          extend$3(res[prop], childConfig[prop]);
        } else if (childConfig[prop] != null) {
          res[prop] = childConfig[prop];
        } else {
          delete res[prop];
        }
      }
    }
    for (prop in parentConfig) {
      if (hasOwnProp(parentConfig, prop) && !hasOwnProp(childConfig, prop) && isObject$8(parentConfig[prop])) {
        res[prop] = extend$3({}, res[prop]);
      }
    }
    return res;
  }
  function Locale(config2) {
    if (config2 != null) {
      this.set(config2);
    }
  }
  var keys$2;
  if (Object.keys) {
    keys$2 = Object.keys;
  } else {
    keys$2 = function(obj) {
      var i2, res = [];
      for (i2 in obj) {
        if (hasOwnProp(obj, i2)) {
          res.push(i2);
        }
      }
      return res;
    };
  }
  var defaultCalendar = {
    sameDay: "[Today at] LT",
    nextDay: "[Tomorrow at] LT",
    nextWeek: "dddd [at] LT",
    lastDay: "[Yesterday at] LT",
    lastWeek: "[Last] dddd [at] LT",
    sameElse: "L"
  };
  function calendar$1(key, mom, now2) {
    var output2 = this._calendar[key] || this._calendar["sameElse"];
    return isFunction$3(output2) ? output2.call(mom, now2) : output2;
  }
  function zeroFill(number2, targetLength, forceSign) {
    var absNumber = "" + Math.abs(number2), zerosToFill = targetLength - absNumber.length, sign2 = number2 >= 0;
    return (sign2 ? forceSign ? "+" : "" : "-") + Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
  }
  var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g, localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, formatFunctions = {}, formatTokenFunctions = {};
  function addFormatToken(token2, padded, ordinal2, callback) {
    var func = callback;
    if (typeof callback === "string") {
      func = function() {
        return this[callback]();
      };
    }
    if (token2) {
      formatTokenFunctions[token2] = func;
    }
    if (padded) {
      formatTokenFunctions[padded[0]] = function() {
        return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
      };
    }
    if (ordinal2) {
      formatTokenFunctions[ordinal2] = function() {
        return this.localeData().ordinal(
          func.apply(this, arguments),
          token2
        );
      };
    }
  }
  function removeFormattingTokens(input) {
    if (input.match(/\[[\s\S]/)) {
      return input.replace(/^\[|\]$/g, "");
    }
    return input.replace(/\\/g, "");
  }
  function makeFormatFunction(format2) {
    var array2 = format2.match(formattingTokens), i2, length2;
    for (i2 = 0, length2 = array2.length; i2 < length2; i2++) {
      if (formatTokenFunctions[array2[i2]]) {
        array2[i2] = formatTokenFunctions[array2[i2]];
      } else {
        array2[i2] = removeFormattingTokens(array2[i2]);
      }
    }
    return function(mom) {
      var output2 = "", i3;
      for (i3 = 0; i3 < length2; i3++) {
        output2 += isFunction$3(array2[i3]) ? array2[i3].call(mom, format2) : array2[i3];
      }
      return output2;
    };
  }
  function formatMoment(m, format2) {
    if (!m.isValid()) {
      return m.localeData().invalidDate();
    }
    format2 = expandFormat(format2, m.localeData());
    formatFunctions[format2] = formatFunctions[format2] || makeFormatFunction(format2);
    return formatFunctions[format2](m);
  }
  function expandFormat(format2, locale2) {
    var i2 = 5;
    function replaceLongDateFormatTokens(input) {
      return locale2.longDateFormat(input) || input;
    }
    localFormattingTokens.lastIndex = 0;
    while (i2 >= 0 && localFormattingTokens.test(format2)) {
      format2 = format2.replace(
        localFormattingTokens,
        replaceLongDateFormatTokens
      );
      localFormattingTokens.lastIndex = 0;
      i2 -= 1;
    }
    return format2;
  }
  var defaultLongDateFormat = {
    LTS: "h:mm:ss A",
    LT: "h:mm A",
    L: "MM/DD/YYYY",
    LL: "MMMM D, YYYY",
    LLL: "MMMM D, YYYY h:mm A",
    LLLL: "dddd, MMMM D, YYYY h:mm A"
  };
  function longDateFormat(key) {
    var format2 = this._longDateFormat[key], formatUpper = this._longDateFormat[key.toUpperCase()];
    if (format2 || !formatUpper) {
      return format2;
    }
    this._longDateFormat[key] = formatUpper.match(formattingTokens).map(function(tok) {
      if (tok === "MMMM" || tok === "MM" || tok === "DD" || tok === "dddd") {
        return tok.slice(1);
      }
      return tok;
    }).join("");
    return this._longDateFormat[key];
  }
  var defaultInvalidDate = "Invalid date";
  function invalidDate() {
    return this._invalidDate;
  }
  var defaultOrdinal = "%d", defaultDayOfMonthOrdinalParse = /\d{1,2}/;
  function ordinal$1(number2) {
    return this._ordinal.replace("%d", number2);
  }
  var defaultRelativeTime = {
    future: "in %s",
    past: "%s ago",
    s: "a few seconds",
    ss: "%d seconds",
    m: "a minute",
    mm: "%d minutes",
    h: "an hour",
    hh: "%d hours",
    d: "a day",
    dd: "%d days",
    w: "a week",
    ww: "%d weeks",
    M: "a month",
    MM: "%d months",
    y: "a year",
    yy: "%d years"
  };
  function relativeTime(number2, withoutSuffix, string2, isFuture) {
    var output2 = this._relativeTime[string2];
    return isFunction$3(output2) ? output2(number2, withoutSuffix, string2, isFuture) : output2.replace(/%d/i, number2);
  }
  function pastFuture(diff2, output2) {
    var format2 = this._relativeTime[diff2 > 0 ? "future" : "past"];
    return isFunction$3(format2) ? format2(output2) : format2.replace(/%s/i, output2);
  }
  var aliases = {};
  function addUnitAlias(unit2, shorthand) {
    var lowerCase = unit2.toLowerCase();
    aliases[lowerCase] = aliases[lowerCase + "s"] = aliases[shorthand] = unit2;
  }
  function normalizeUnits(units) {
    return typeof units === "string" ? aliases[units] || aliases[units.toLowerCase()] : void 0;
  }
  function normalizeObjectUnits(inputObject) {
    var normalizedInput = {}, normalizedProp, prop;
    for (prop in inputObject) {
      if (hasOwnProp(inputObject, prop)) {
        normalizedProp = normalizeUnits(prop);
        if (normalizedProp) {
          normalizedInput[normalizedProp] = inputObject[prop];
        }
      }
    }
    return normalizedInput;
  }
  var priorities = {};
  function addUnitPriority(unit2, priority) {
    priorities[unit2] = priority;
  }
  function getPrioritizedUnits(unitsObj) {
    var units = [], u;
    for (u in unitsObj) {
      if (hasOwnProp(unitsObj, u)) {
        units.push({ unit: u, priority: priorities[u] });
      }
    }
    units.sort(function(a, b) {
      return a.priority - b.priority;
    });
    return units;
  }
  function isLeapYear(year2) {
    return year2 % 4 === 0 && year2 % 100 !== 0 || year2 % 400 === 0;
  }
  function absFloor(number2) {
    if (number2 < 0) {
      return Math.ceil(number2) || 0;
    } else {
      return Math.floor(number2);
    }
  }
  function toInt(argumentForCoercion) {
    var coercedNumber = +argumentForCoercion, value = 0;
    if (coercedNumber !== 0 && isFinite(coercedNumber)) {
      value = absFloor(coercedNumber);
    }
    return value;
  }
  function makeGetSet(unit2, keepTime) {
    return function(value) {
      if (value != null) {
        set$1$1(this, unit2, value);
        hooks.updateOffset(this, keepTime);
        return this;
      } else {
        return get$6(this, unit2);
      }
    };
  }
  function get$6(mom, unit2) {
    return mom.isValid() ? mom._d["get" + (mom._isUTC ? "UTC" : "") + unit2]() : NaN;
  }
  function set$1$1(mom, unit2, value) {
    if (mom.isValid() && !isNaN(value)) {
      if (unit2 === "FullYear" && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
        value = toInt(value);
        mom._d["set" + (mom._isUTC ? "UTC" : "") + unit2](
          value,
          mom.month(),
          daysInMonth(value, mom.month())
        );
      } else {
        mom._d["set" + (mom._isUTC ? "UTC" : "") + unit2](value);
      }
    }
  }
  function stringGet(units) {
    units = normalizeUnits(units);
    if (isFunction$3(this[units])) {
      return this[units]();
    }
    return this;
  }
  function stringSet(units, value) {
    if (typeof units === "object") {
      units = normalizeObjectUnits(units);
      var prioritized = getPrioritizedUnits(units), i2, prioritizedLen = prioritized.length;
      for (i2 = 0; i2 < prioritizedLen; i2++) {
        this[prioritized[i2].unit](units[prioritized[i2].unit]);
      }
    } else {
      units = normalizeUnits(units);
      if (isFunction$3(this[units])) {
        return this[units](value);
      }
    }
    return this;
  }
  var match1 = /\d/, match2 = /\d\d/, match3 = /\d{3}/, match4 = /\d{4}/, match6 = /[+-]?\d{6}/, match1to2 = /\d\d?/, match3to4 = /\d\d\d\d?/, match5to6 = /\d\d\d\d\d\d?/, match1to3 = /\d{1,3}/, match1to4 = /\d{1,4}/, match1to6 = /[+-]?\d{1,6}/, matchUnsigned = /\d+/, matchSigned = /[+-]?\d+/, matchOffset = /Z|[+-]\d\d:?\d\d/gi, matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi, matchTimestamp = /[+-]?\d+(\.\d{1,3})?/, matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i, regexes;
  regexes = {};
  function addRegexToken(token2, regex, strictRegex) {
    regexes[token2] = isFunction$3(regex) ? regex : function(isStrict, localeData2) {
      return isStrict && strictRegex ? strictRegex : regex;
    };
  }
  function getParseRegexForToken(token2, config2) {
    if (!hasOwnProp(regexes, token2)) {
      return new RegExp(unescapeFormat(token2));
    }
    return regexes[token2](config2._strict, config2._locale);
  }
  function unescapeFormat(s) {
    return regexEscape(
      s.replace("\\", "").replace(
        /\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,
        function(matched, p1, p2, p3, p4) {
          return p1 || p2 || p3 || p4;
        }
      )
    );
  }
  function regexEscape(s) {
    return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
  }
  var tokens$1 = {};
  function addParseToken(token2, callback) {
    var i2, func = callback, tokenLen;
    if (typeof token2 === "string") {
      token2 = [token2];
    }
    if (isNumber(callback)) {
      func = function(input, array2) {
        array2[callback] = toInt(input);
      };
    }
    tokenLen = token2.length;
    for (i2 = 0; i2 < tokenLen; i2++) {
      tokens$1[token2[i2]] = func;
    }
  }
  function addWeekParseToken(token2, callback) {
    addParseToken(token2, function(input, array2, config2, token3) {
      config2._w = config2._w || {};
      callback(input, config2._w, config2, token3);
    });
  }
  function addTimeToArrayFromToken(token2, input, config2) {
    if (input != null && hasOwnProp(tokens$1, token2)) {
      tokens$1[token2](input, config2._a, config2, token2);
    }
  }
  var YEAR = 0, MONTH = 1, DATE = 2, HOUR = 3, MINUTE = 4, SECOND = 5, MILLISECOND = 6, WEEK = 7, WEEKDAY = 8;
  function mod(n, x2) {
    return (n % x2 + x2) % x2;
  }
  var indexOf;
  if (Array.prototype.indexOf) {
    indexOf = Array.prototype.indexOf;
  } else {
    indexOf = function(o) {
      var i2;
      for (i2 = 0; i2 < this.length; ++i2) {
        if (this[i2] === o) {
          return i2;
        }
      }
      return -1;
    };
  }
  function daysInMonth(year2, month2) {
    if (isNaN(year2) || isNaN(month2)) {
      return NaN;
    }
    var modMonth = mod(month2, 12);
    year2 += (month2 - modMonth) / 12;
    return modMonth === 1 ? isLeapYear(year2) ? 29 : 28 : 31 - modMonth % 7 % 2;
  }
  addFormatToken("M", ["MM", 2], "Mo", function() {
    return this.month() + 1;
  });
  addFormatToken("MMM", 0, 0, function(format2) {
    return this.localeData().monthsShort(this, format2);
  });
  addFormatToken("MMMM", 0, 0, function(format2) {
    return this.localeData().months(this, format2);
  });
  addUnitAlias("month", "M");
  addUnitPriority("month", 8);
  addRegexToken("M", match1to2);
  addRegexToken("MM", match1to2, match2);
  addRegexToken("MMM", function(isStrict, locale2) {
    return locale2.monthsShortRegex(isStrict);
  });
  addRegexToken("MMMM", function(isStrict, locale2) {
    return locale2.monthsRegex(isStrict);
  });
  addParseToken(["M", "MM"], function(input, array2) {
    array2[MONTH] = toInt(input) - 1;
  });
  addParseToken(["MMM", "MMMM"], function(input, array2, config2, token2) {
    var month2 = config2._locale.monthsParse(input, token2, config2._strict);
    if (month2 != null) {
      array2[MONTH] = month2;
    } else {
      getParsingFlags(config2).invalidMonth = input;
    }
  });
  var defaultLocaleMonths = "January_February_March_April_May_June_July_August_September_October_November_December".split(
    "_"
  ), defaultLocaleMonthsShort = "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"), MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/, defaultMonthsShortRegex = matchWord, defaultMonthsRegex = matchWord;
  function localeMonths(m, format2) {
    if (!m) {
      return isArray$7(this._months) ? this._months : this._months["standalone"];
    }
    return isArray$7(this._months) ? this._months[m.month()] : this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format2) ? "format" : "standalone"][m.month()];
  }
  function localeMonthsShort(m, format2) {
    if (!m) {
      return isArray$7(this._monthsShort) ? this._monthsShort : this._monthsShort["standalone"];
    }
    return isArray$7(this._monthsShort) ? this._monthsShort[m.month()] : this._monthsShort[MONTHS_IN_FORMAT.test(format2) ? "format" : "standalone"][m.month()];
  }
  function handleStrictParse(monthName, format2, strict) {
    var i2, ii, mom, llc = monthName.toLocaleLowerCase();
    if (!this._monthsParse) {
      this._monthsParse = [];
      this._longMonthsParse = [];
      this._shortMonthsParse = [];
      for (i2 = 0; i2 < 12; ++i2) {
        mom = createUTC([2e3, i2]);
        this._shortMonthsParse[i2] = this.monthsShort(
          mom,
          ""
        ).toLocaleLowerCase();
        this._longMonthsParse[i2] = this.months(mom, "").toLocaleLowerCase();
      }
    }
    if (strict) {
      if (format2 === "MMM") {
        ii = indexOf.call(this._shortMonthsParse, llc);
        return ii !== -1 ? ii : null;
      } else {
        ii = indexOf.call(this._longMonthsParse, llc);
        return ii !== -1 ? ii : null;
      }
    } else {
      if (format2 === "MMM") {
        ii = indexOf.call(this._shortMonthsParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._longMonthsParse, llc);
        return ii !== -1 ? ii : null;
      } else {
        ii = indexOf.call(this._longMonthsParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._shortMonthsParse, llc);
        return ii !== -1 ? ii : null;
      }
    }
  }
  function localeMonthsParse(monthName, format2, strict) {
    var i2, mom, regex;
    if (this._monthsParseExact) {
      return handleStrictParse.call(this, monthName, format2, strict);
    }
    if (!this._monthsParse) {
      this._monthsParse = [];
      this._longMonthsParse = [];
      this._shortMonthsParse = [];
    }
    for (i2 = 0; i2 < 12; i2++) {
      mom = createUTC([2e3, i2]);
      if (strict && !this._longMonthsParse[i2]) {
        this._longMonthsParse[i2] = new RegExp(
          "^" + this.months(mom, "").replace(".", "") + "$",
          "i"
        );
        this._shortMonthsParse[i2] = new RegExp(
          "^" + this.monthsShort(mom, "").replace(".", "") + "$",
          "i"
        );
      }
      if (!strict && !this._monthsParse[i2]) {
        regex = "^" + this.months(mom, "") + "|^" + this.monthsShort(mom, "");
        this._monthsParse[i2] = new RegExp(regex.replace(".", ""), "i");
      }
      if (strict && format2 === "MMMM" && this._longMonthsParse[i2].test(monthName)) {
        return i2;
      } else if (strict && format2 === "MMM" && this._shortMonthsParse[i2].test(monthName)) {
        return i2;
      } else if (!strict && this._monthsParse[i2].test(monthName)) {
        return i2;
      }
    }
  }
  function setMonth(mom, value) {
    var dayOfMonth;
    if (!mom.isValid()) {
      return mom;
    }
    if (typeof value === "string") {
      if (/^\d+$/.test(value)) {
        value = toInt(value);
      } else {
        value = mom.localeData().monthsParse(value);
        if (!isNumber(value)) {
          return mom;
        }
      }
    }
    dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
    mom._d["set" + (mom._isUTC ? "UTC" : "") + "Month"](value, dayOfMonth);
    return mom;
  }
  function getSetMonth(value) {
    if (value != null) {
      setMonth(this, value);
      hooks.updateOffset(this, true);
      return this;
    } else {
      return get$6(this, "Month");
    }
  }
  function getDaysInMonth() {
    return daysInMonth(this.year(), this.month());
  }
  function monthsShortRegex(isStrict) {
    if (this._monthsParseExact) {
      if (!hasOwnProp(this, "_monthsRegex")) {
        computeMonthsParse.call(this);
      }
      if (isStrict) {
        return this._monthsShortStrictRegex;
      } else {
        return this._monthsShortRegex;
      }
    } else {
      if (!hasOwnProp(this, "_monthsShortRegex")) {
        this._monthsShortRegex = defaultMonthsShortRegex;
      }
      return this._monthsShortStrictRegex && isStrict ? this._monthsShortStrictRegex : this._monthsShortRegex;
    }
  }
  function monthsRegex(isStrict) {
    if (this._monthsParseExact) {
      if (!hasOwnProp(this, "_monthsRegex")) {
        computeMonthsParse.call(this);
      }
      if (isStrict) {
        return this._monthsStrictRegex;
      } else {
        return this._monthsRegex;
      }
    } else {
      if (!hasOwnProp(this, "_monthsRegex")) {
        this._monthsRegex = defaultMonthsRegex;
      }
      return this._monthsStrictRegex && isStrict ? this._monthsStrictRegex : this._monthsRegex;
    }
  }
  function computeMonthsParse() {
    function cmpLenRev(a, b) {
      return b.length - a.length;
    }
    var shortPieces = [], longPieces = [], mixedPieces = [], i2, mom;
    for (i2 = 0; i2 < 12; i2++) {
      mom = createUTC([2e3, i2]);
      shortPieces.push(this.monthsShort(mom, ""));
      longPieces.push(this.months(mom, ""));
      mixedPieces.push(this.months(mom, ""));
      mixedPieces.push(this.monthsShort(mom, ""));
    }
    shortPieces.sort(cmpLenRev);
    longPieces.sort(cmpLenRev);
    mixedPieces.sort(cmpLenRev);
    for (i2 = 0; i2 < 12; i2++) {
      shortPieces[i2] = regexEscape(shortPieces[i2]);
      longPieces[i2] = regexEscape(longPieces[i2]);
    }
    for (i2 = 0; i2 < 24; i2++) {
      mixedPieces[i2] = regexEscape(mixedPieces[i2]);
    }
    this._monthsRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
    this._monthsShortRegex = this._monthsRegex;
    this._monthsStrictRegex = new RegExp(
      "^(" + longPieces.join("|") + ")",
      "i"
    );
    this._monthsShortStrictRegex = new RegExp(
      "^(" + shortPieces.join("|") + ")",
      "i"
    );
  }
  addFormatToken("Y", 0, 0, function() {
    var y2 = this.year();
    return y2 <= 9999 ? zeroFill(y2, 4) : "+" + y2;
  });
  addFormatToken(0, ["YY", 2], 0, function() {
    return this.year() % 100;
  });
  addFormatToken(0, ["YYYY", 4], 0, "year");
  addFormatToken(0, ["YYYYY", 5], 0, "year");
  addFormatToken(0, ["YYYYYY", 6, true], 0, "year");
  addUnitAlias("year", "y");
  addUnitPriority("year", 1);
  addRegexToken("Y", matchSigned);
  addRegexToken("YY", match1to2, match2);
  addRegexToken("YYYY", match1to4, match4);
  addRegexToken("YYYYY", match1to6, match6);
  addRegexToken("YYYYYY", match1to6, match6);
  addParseToken(["YYYYY", "YYYYYY"], YEAR);
  addParseToken("YYYY", function(input, array2) {
    array2[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
  });
  addParseToken("YY", function(input, array2) {
    array2[YEAR] = hooks.parseTwoDigitYear(input);
  });
  addParseToken("Y", function(input, array2) {
    array2[YEAR] = parseInt(input, 10);
  });
  function daysInYear(year2) {
    return isLeapYear(year2) ? 366 : 365;
  }
  hooks.parseTwoDigitYear = function(input) {
    return toInt(input) + (toInt(input) > 68 ? 1900 : 2e3);
  };
  var getSetYear = makeGetSet("FullYear", true);
  function getIsLeapYear() {
    return isLeapYear(this.year());
  }
  function createDate(y2, m, d, h, M, s, ms2) {
    var date2;
    if (y2 < 100 && y2 >= 0) {
      date2 = new Date(y2 + 400, m, d, h, M, s, ms2);
      if (isFinite(date2.getFullYear())) {
        date2.setFullYear(y2);
      }
    } else {
      date2 = new Date(y2, m, d, h, M, s, ms2);
    }
    return date2;
  }
  function createUTCDate(y2) {
    var date2, args;
    if (y2 < 100 && y2 >= 0) {
      args = Array.prototype.slice.call(arguments);
      args[0] = y2 + 400;
      date2 = new Date(Date.UTC.apply(null, args));
      if (isFinite(date2.getUTCFullYear())) {
        date2.setUTCFullYear(y2);
      }
    } else {
      date2 = new Date(Date.UTC.apply(null, arguments));
    }
    return date2;
  }
  function firstWeekOffset(year2, dow, doy) {
    var fwd = 7 + dow - doy, fwdlw = (7 + createUTCDate(year2, 0, fwd).getUTCDay() - dow) % 7;
    return -fwdlw + fwd - 1;
  }
  function dayOfYearFromWeeks(year2, week, weekday2, dow, doy) {
    var localWeekday = (7 + weekday2 - dow) % 7, weekOffset = firstWeekOffset(year2, dow, doy), dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset, resYear, resDayOfYear;
    if (dayOfYear <= 0) {
      resYear = year2 - 1;
      resDayOfYear = daysInYear(resYear) + dayOfYear;
    } else if (dayOfYear > daysInYear(year2)) {
      resYear = year2 + 1;
      resDayOfYear = dayOfYear - daysInYear(year2);
    } else {
      resYear = year2;
      resDayOfYear = dayOfYear;
    }
    return {
      year: resYear,
      dayOfYear: resDayOfYear
    };
  }
  function weekOfYear(mom, dow, doy) {
    var weekOffset = firstWeekOffset(mom.year(), dow, doy), week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1, resWeek, resYear;
    if (week < 1) {
      resYear = mom.year() - 1;
      resWeek = week + weeksInYear(resYear, dow, doy);
    } else if (week > weeksInYear(mom.year(), dow, doy)) {
      resWeek = week - weeksInYear(mom.year(), dow, doy);
      resYear = mom.year() + 1;
    } else {
      resYear = mom.year();
      resWeek = week;
    }
    return {
      week: resWeek,
      year: resYear
    };
  }
  function weeksInYear(year2, dow, doy) {
    var weekOffset = firstWeekOffset(year2, dow, doy), weekOffsetNext = firstWeekOffset(year2 + 1, dow, doy);
    return (daysInYear(year2) - weekOffset + weekOffsetNext) / 7;
  }
  addFormatToken("w", ["ww", 2], "wo", "week");
  addFormatToken("W", ["WW", 2], "Wo", "isoWeek");
  addUnitAlias("week", "w");
  addUnitAlias("isoWeek", "W");
  addUnitPriority("week", 5);
  addUnitPriority("isoWeek", 5);
  addRegexToken("w", match1to2);
  addRegexToken("ww", match1to2, match2);
  addRegexToken("W", match1to2);
  addRegexToken("WW", match1to2, match2);
  addWeekParseToken(
    ["w", "ww", "W", "WW"],
    function(input, week, config2, token2) {
      week[token2.substr(0, 1)] = toInt(input);
    }
  );
  function localeWeek(mom) {
    return weekOfYear(mom, this._week.dow, this._week.doy).week;
  }
  var defaultLocaleWeek = {
    dow: 0,
    doy: 6
  };
  function localeFirstDayOfWeek() {
    return this._week.dow;
  }
  function localeFirstDayOfYear() {
    return this._week.doy;
  }
  function getSetWeek(input) {
    var week = this.localeData().week(this);
    return input == null ? week : this.add((input - week) * 7, "d");
  }
  function getSetISOWeek(input) {
    var week = weekOfYear(this, 1, 4).week;
    return input == null ? week : this.add((input - week) * 7, "d");
  }
  addFormatToken("d", 0, "do", "day");
  addFormatToken("dd", 0, 0, function(format2) {
    return this.localeData().weekdaysMin(this, format2);
  });
  addFormatToken("ddd", 0, 0, function(format2) {
    return this.localeData().weekdaysShort(this, format2);
  });
  addFormatToken("dddd", 0, 0, function(format2) {
    return this.localeData().weekdays(this, format2);
  });
  addFormatToken("e", 0, 0, "weekday");
  addFormatToken("E", 0, 0, "isoWeekday");
  addUnitAlias("day", "d");
  addUnitAlias("weekday", "e");
  addUnitAlias("isoWeekday", "E");
  addUnitPriority("day", 11);
  addUnitPriority("weekday", 11);
  addUnitPriority("isoWeekday", 11);
  addRegexToken("d", match1to2);
  addRegexToken("e", match1to2);
  addRegexToken("E", match1to2);
  addRegexToken("dd", function(isStrict, locale2) {
    return locale2.weekdaysMinRegex(isStrict);
  });
  addRegexToken("ddd", function(isStrict, locale2) {
    return locale2.weekdaysShortRegex(isStrict);
  });
  addRegexToken("dddd", function(isStrict, locale2) {
    return locale2.weekdaysRegex(isStrict);
  });
  addWeekParseToken(["dd", "ddd", "dddd"], function(input, week, config2, token2) {
    var weekday2 = config2._locale.weekdaysParse(input, token2, config2._strict);
    if (weekday2 != null) {
      week.d = weekday2;
    } else {
      getParsingFlags(config2).invalidWeekday = input;
    }
  });
  addWeekParseToken(["d", "e", "E"], function(input, week, config2, token2) {
    week[token2] = toInt(input);
  });
  function parseWeekday(input, locale2) {
    if (typeof input !== "string") {
      return input;
    }
    if (!isNaN(input)) {
      return parseInt(input, 10);
    }
    input = locale2.weekdaysParse(input);
    if (typeof input === "number") {
      return input;
    }
    return null;
  }
  function parseIsoWeekday(input, locale2) {
    if (typeof input === "string") {
      return locale2.weekdaysParse(input) % 7 || 7;
    }
    return isNaN(input) ? null : input;
  }
  function shiftWeekdays(ws, n) {
    return ws.slice(n, 7).concat(ws.slice(0, n));
  }
  var defaultLocaleWeekdays = "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), defaultLocaleWeekdaysShort = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"), defaultLocaleWeekdaysMin = "Su_Mo_Tu_We_Th_Fr_Sa".split("_"), defaultWeekdaysRegex = matchWord, defaultWeekdaysShortRegex = matchWord, defaultWeekdaysMinRegex = matchWord;
  function localeWeekdays(m, format2) {
    var weekdays = isArray$7(this._weekdays) ? this._weekdays : this._weekdays[m && m !== true && this._weekdays.isFormat.test(format2) ? "format" : "standalone"];
    return m === true ? shiftWeekdays(weekdays, this._week.dow) : m ? weekdays[m.day()] : weekdays;
  }
  function localeWeekdaysShort(m) {
    return m === true ? shiftWeekdays(this._weekdaysShort, this._week.dow) : m ? this._weekdaysShort[m.day()] : this._weekdaysShort;
  }
  function localeWeekdaysMin(m) {
    return m === true ? shiftWeekdays(this._weekdaysMin, this._week.dow) : m ? this._weekdaysMin[m.day()] : this._weekdaysMin;
  }
  function handleStrictParse$1(weekdayName, format2, strict) {
    var i2, ii, mom, llc = weekdayName.toLocaleLowerCase();
    if (!this._weekdaysParse) {
      this._weekdaysParse = [];
      this._shortWeekdaysParse = [];
      this._minWeekdaysParse = [];
      for (i2 = 0; i2 < 7; ++i2) {
        mom = createUTC([2e3, 1]).day(i2);
        this._minWeekdaysParse[i2] = this.weekdaysMin(
          mom,
          ""
        ).toLocaleLowerCase();
        this._shortWeekdaysParse[i2] = this.weekdaysShort(
          mom,
          ""
        ).toLocaleLowerCase();
        this._weekdaysParse[i2] = this.weekdays(mom, "").toLocaleLowerCase();
      }
    }
    if (strict) {
      if (format2 === "dddd") {
        ii = indexOf.call(this._weekdaysParse, llc);
        return ii !== -1 ? ii : null;
      } else if (format2 === "ddd") {
        ii = indexOf.call(this._shortWeekdaysParse, llc);
        return ii !== -1 ? ii : null;
      } else {
        ii = indexOf.call(this._minWeekdaysParse, llc);
        return ii !== -1 ? ii : null;
      }
    } else {
      if (format2 === "dddd") {
        ii = indexOf.call(this._weekdaysParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._shortWeekdaysParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._minWeekdaysParse, llc);
        return ii !== -1 ? ii : null;
      } else if (format2 === "ddd") {
        ii = indexOf.call(this._shortWeekdaysParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._weekdaysParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._minWeekdaysParse, llc);
        return ii !== -1 ? ii : null;
      } else {
        ii = indexOf.call(this._minWeekdaysParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._weekdaysParse, llc);
        if (ii !== -1) {
          return ii;
        }
        ii = indexOf.call(this._shortWeekdaysParse, llc);
        return ii !== -1 ? ii : null;
      }
    }
  }
  function localeWeekdaysParse(weekdayName, format2, strict) {
    var i2, mom, regex;
    if (this._weekdaysParseExact) {
      return handleStrictParse$1.call(this, weekdayName, format2, strict);
    }
    if (!this._weekdaysParse) {
      this._weekdaysParse = [];
      this._minWeekdaysParse = [];
      this._shortWeekdaysParse = [];
      this._fullWeekdaysParse = [];
    }
    for (i2 = 0; i2 < 7; i2++) {
      mom = createUTC([2e3, 1]).day(i2);
      if (strict && !this._fullWeekdaysParse[i2]) {
        this._fullWeekdaysParse[i2] = new RegExp(
          "^" + this.weekdays(mom, "").replace(".", "\\.?") + "$",
          "i"
        );
        this._shortWeekdaysParse[i2] = new RegExp(
          "^" + this.weekdaysShort(mom, "").replace(".", "\\.?") + "$",
          "i"
        );
        this._minWeekdaysParse[i2] = new RegExp(
          "^" + this.weekdaysMin(mom, "").replace(".", "\\.?") + "$",
          "i"
        );
      }
      if (!this._weekdaysParse[i2]) {
        regex = "^" + this.weekdays(mom, "") + "|^" + this.weekdaysShort(mom, "") + "|^" + this.weekdaysMin(mom, "");
        this._weekdaysParse[i2] = new RegExp(regex.replace(".", ""), "i");
      }
      if (strict && format2 === "dddd" && this._fullWeekdaysParse[i2].test(weekdayName)) {
        return i2;
      } else if (strict && format2 === "ddd" && this._shortWeekdaysParse[i2].test(weekdayName)) {
        return i2;
      } else if (strict && format2 === "dd" && this._minWeekdaysParse[i2].test(weekdayName)) {
        return i2;
      } else if (!strict && this._weekdaysParse[i2].test(weekdayName)) {
        return i2;
      }
    }
  }
  function getSetDayOfWeek(input) {
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    var day2 = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
    if (input != null) {
      input = parseWeekday(input, this.localeData());
      return this.add(input - day2, "d");
    } else {
      return day2;
    }
  }
  function getSetLocaleDayOfWeek(input) {
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    var weekday2 = (this.day() + 7 - this.localeData()._week.dow) % 7;
    return input == null ? weekday2 : this.add(input - weekday2, "d");
  }
  function getSetISODayOfWeek(input) {
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    if (input != null) {
      var weekday2 = parseIsoWeekday(input, this.localeData());
      return this.day(this.day() % 7 ? weekday2 : weekday2 - 7);
    } else {
      return this.day() || 7;
    }
  }
  function weekdaysRegex(isStrict) {
    if (this._weekdaysParseExact) {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        computeWeekdaysParse.call(this);
      }
      if (isStrict) {
        return this._weekdaysStrictRegex;
      } else {
        return this._weekdaysRegex;
      }
    } else {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        this._weekdaysRegex = defaultWeekdaysRegex;
      }
      return this._weekdaysStrictRegex && isStrict ? this._weekdaysStrictRegex : this._weekdaysRegex;
    }
  }
  function weekdaysShortRegex(isStrict) {
    if (this._weekdaysParseExact) {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        computeWeekdaysParse.call(this);
      }
      if (isStrict) {
        return this._weekdaysShortStrictRegex;
      } else {
        return this._weekdaysShortRegex;
      }
    } else {
      if (!hasOwnProp(this, "_weekdaysShortRegex")) {
        this._weekdaysShortRegex = defaultWeekdaysShortRegex;
      }
      return this._weekdaysShortStrictRegex && isStrict ? this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
    }
  }
  function weekdaysMinRegex(isStrict) {
    if (this._weekdaysParseExact) {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        computeWeekdaysParse.call(this);
      }
      if (isStrict) {
        return this._weekdaysMinStrictRegex;
      } else {
        return this._weekdaysMinRegex;
      }
    } else {
      if (!hasOwnProp(this, "_weekdaysMinRegex")) {
        this._weekdaysMinRegex = defaultWeekdaysMinRegex;
      }
      return this._weekdaysMinStrictRegex && isStrict ? this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
    }
  }
  function computeWeekdaysParse() {
    function cmpLenRev(a, b) {
      return b.length - a.length;
    }
    var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [], i2, mom, minp, shortp, longp;
    for (i2 = 0; i2 < 7; i2++) {
      mom = createUTC([2e3, 1]).day(i2);
      minp = regexEscape(this.weekdaysMin(mom, ""));
      shortp = regexEscape(this.weekdaysShort(mom, ""));
      longp = regexEscape(this.weekdays(mom, ""));
      minPieces.push(minp);
      shortPieces.push(shortp);
      longPieces.push(longp);
      mixedPieces.push(minp);
      mixedPieces.push(shortp);
      mixedPieces.push(longp);
    }
    minPieces.sort(cmpLenRev);
    shortPieces.sort(cmpLenRev);
    longPieces.sort(cmpLenRev);
    mixedPieces.sort(cmpLenRev);
    this._weekdaysRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
    this._weekdaysShortRegex = this._weekdaysRegex;
    this._weekdaysMinRegex = this._weekdaysRegex;
    this._weekdaysStrictRegex = new RegExp(
      "^(" + longPieces.join("|") + ")",
      "i"
    );
    this._weekdaysShortStrictRegex = new RegExp(
      "^(" + shortPieces.join("|") + ")",
      "i"
    );
    this._weekdaysMinStrictRegex = new RegExp(
      "^(" + minPieces.join("|") + ")",
      "i"
    );
  }
  function hFormat() {
    return this.hours() % 12 || 12;
  }
  function kFormat() {
    return this.hours() || 24;
  }
  addFormatToken("H", ["HH", 2], 0, "hour");
  addFormatToken("h", ["hh", 2], 0, hFormat);
  addFormatToken("k", ["kk", 2], 0, kFormat);
  addFormatToken("hmm", 0, 0, function() {
    return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2);
  });
  addFormatToken("hmmss", 0, 0, function() {
    return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
  });
  addFormatToken("Hmm", 0, 0, function() {
    return "" + this.hours() + zeroFill(this.minutes(), 2);
  });
  addFormatToken("Hmmss", 0, 0, function() {
    return "" + this.hours() + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
  });
  function meridiem(token2, lowercase) {
    addFormatToken(token2, 0, 0, function() {
      return this.localeData().meridiem(
        this.hours(),
        this.minutes(),
        lowercase
      );
    });
  }
  meridiem("a", true);
  meridiem("A", false);
  addUnitAlias("hour", "h");
  addUnitPriority("hour", 13);
  function matchMeridiem(isStrict, locale2) {
    return locale2._meridiemParse;
  }
  addRegexToken("a", matchMeridiem);
  addRegexToken("A", matchMeridiem);
  addRegexToken("H", match1to2);
  addRegexToken("h", match1to2);
  addRegexToken("k", match1to2);
  addRegexToken("HH", match1to2, match2);
  addRegexToken("hh", match1to2, match2);
  addRegexToken("kk", match1to2, match2);
  addRegexToken("hmm", match3to4);
  addRegexToken("hmmss", match5to6);
  addRegexToken("Hmm", match3to4);
  addRegexToken("Hmmss", match5to6);
  addParseToken(["H", "HH"], HOUR);
  addParseToken(["k", "kk"], function(input, array2, config2) {
    var kInput = toInt(input);
    array2[HOUR] = kInput === 24 ? 0 : kInput;
  });
  addParseToken(["a", "A"], function(input, array2, config2) {
    config2._isPm = config2._locale.isPM(input);
    config2._meridiem = input;
  });
  addParseToken(["h", "hh"], function(input, array2, config2) {
    array2[HOUR] = toInt(input);
    getParsingFlags(config2).bigHour = true;
  });
  addParseToken("hmm", function(input, array2, config2) {
    var pos = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos));
    array2[MINUTE] = toInt(input.substr(pos));
    getParsingFlags(config2).bigHour = true;
  });
  addParseToken("hmmss", function(input, array2, config2) {
    var pos1 = input.length - 4, pos2 = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos1));
    array2[MINUTE] = toInt(input.substr(pos1, 2));
    array2[SECOND] = toInt(input.substr(pos2));
    getParsingFlags(config2).bigHour = true;
  });
  addParseToken("Hmm", function(input, array2, config2) {
    var pos = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos));
    array2[MINUTE] = toInt(input.substr(pos));
  });
  addParseToken("Hmmss", function(input, array2, config2) {
    var pos1 = input.length - 4, pos2 = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos1));
    array2[MINUTE] = toInt(input.substr(pos1, 2));
    array2[SECOND] = toInt(input.substr(pos2));
  });
  function localeIsPM(input) {
    return (input + "").toLowerCase().charAt(0) === "p";
  }
  var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i, getSetHour = makeGetSet("Hours", true);
  function localeMeridiem(hours2, minutes2, isLower) {
    if (hours2 > 11) {
      return isLower ? "pm" : "PM";
    } else {
      return isLower ? "am" : "AM";
    }
  }
  var baseConfig = {
    calendar: defaultCalendar,
    longDateFormat: defaultLongDateFormat,
    invalidDate: defaultInvalidDate,
    ordinal: defaultOrdinal,
    dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
    relativeTime: defaultRelativeTime,
    months: defaultLocaleMonths,
    monthsShort: defaultLocaleMonthsShort,
    week: defaultLocaleWeek,
    weekdays: defaultLocaleWeekdays,
    weekdaysMin: defaultLocaleWeekdaysMin,
    weekdaysShort: defaultLocaleWeekdaysShort,
    meridiemParse: defaultLocaleMeridiemParse
  };
  var locales = {}, localeFamilies = {}, globalLocale;
  function commonPrefix(arr1, arr2) {
    var i2, minl = Math.min(arr1.length, arr2.length);
    for (i2 = 0; i2 < minl; i2 += 1) {
      if (arr1[i2] !== arr2[i2]) {
        return i2;
      }
    }
    return minl;
  }
  function normalizeLocale(key) {
    return key ? key.toLowerCase().replace("_", "-") : key;
  }
  function chooseLocale(names) {
    var i2 = 0, j, next2, locale2, split;
    while (i2 < names.length) {
      split = normalizeLocale(names[i2]).split("-");
      j = split.length;
      next2 = normalizeLocale(names[i2 + 1]);
      next2 = next2 ? next2.split("-") : null;
      while (j > 0) {
        locale2 = loadLocale(split.slice(0, j).join("-"));
        if (locale2) {
          return locale2;
        }
        if (next2 && next2.length >= j && commonPrefix(split, next2) >= j - 1) {
          break;
        }
        j--;
      }
      i2++;
    }
    return globalLocale;
  }
  function isLocaleNameSane(name2) {
    return name2.match("^[^/\\\\]*$") != null;
  }
  function loadLocale(name2) {
    var oldLocale = null, aliasedRequire;
    if (locales[name2] === void 0 && typeof module !== "undefined" && module && module.exports && isLocaleNameSane(name2)) {
      try {
        oldLocale = globalLocale._abbr;
        aliasedRequire = require;
        aliasedRequire("./locale/" + name2);
        getSetGlobalLocale(oldLocale);
      } catch (e) {
        locales[name2] = null;
      }
    }
    return locales[name2];
  }
  function getSetGlobalLocale(key, values2) {
    var data2;
    if (key) {
      if (isUndefined$1(values2)) {
        data2 = getLocale(key);
      } else {
        data2 = defineLocale(key, values2);
      }
      if (data2) {
        globalLocale = data2;
      } else {
        if (typeof console !== "undefined" && console.warn) {
          console.warn(
            "Locale " + key + " not found. Did you forget to load it?"
          );
        }
      }
    }
    return globalLocale._abbr;
  }
  function defineLocale(name2, config2) {
    if (config2 !== null) {
      var locale2, parentConfig = baseConfig;
      config2.abbr = name2;
      if (locales[name2] != null) {
        deprecateSimple(
          "defineLocaleOverride",
          "use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."
        );
        parentConfig = locales[name2]._config;
      } else if (config2.parentLocale != null) {
        if (locales[config2.parentLocale] != null) {
          parentConfig = locales[config2.parentLocale]._config;
        } else {
          locale2 = loadLocale(config2.parentLocale);
          if (locale2 != null) {
            parentConfig = locale2._config;
          } else {
            if (!localeFamilies[config2.parentLocale]) {
              localeFamilies[config2.parentLocale] = [];
            }
            localeFamilies[config2.parentLocale].push({
              name: name2,
              config: config2
            });
            return null;
          }
        }
      }
      locales[name2] = new Locale(mergeConfigs(parentConfig, config2));
      if (localeFamilies[name2]) {
        localeFamilies[name2].forEach(function(x2) {
          defineLocale(x2.name, x2.config);
        });
      }
      getSetGlobalLocale(name2);
      return locales[name2];
    } else {
      delete locales[name2];
      return null;
    }
  }
  function updateLocale(name2, config2) {
    if (config2 != null) {
      var locale2, tmpLocale, parentConfig = baseConfig;
      if (locales[name2] != null && locales[name2].parentLocale != null) {
        locales[name2].set(mergeConfigs(locales[name2]._config, config2));
      } else {
        tmpLocale = loadLocale(name2);
        if (tmpLocale != null) {
          parentConfig = tmpLocale._config;
        }
        config2 = mergeConfigs(parentConfig, config2);
        if (tmpLocale == null) {
          config2.abbr = name2;
        }
        locale2 = new Locale(config2);
        locale2.parentLocale = locales[name2];
        locales[name2] = locale2;
      }
      getSetGlobalLocale(name2);
    } else {
      if (locales[name2] != null) {
        if (locales[name2].parentLocale != null) {
          locales[name2] = locales[name2].parentLocale;
          if (name2 === getSetGlobalLocale()) {
            getSetGlobalLocale(name2);
          }
        } else if (locales[name2] != null) {
          delete locales[name2];
        }
      }
    }
    return locales[name2];
  }
  function getLocale(key) {
    var locale2;
    if (key && key._locale && key._locale._abbr) {
      key = key._locale._abbr;
    }
    if (!key) {
      return globalLocale;
    }
    if (!isArray$7(key)) {
      locale2 = loadLocale(key);
      if (locale2) {
        return locale2;
      }
      key = [key];
    }
    return chooseLocale(key);
  }
  function listLocales() {
    return keys$2(locales);
  }
  function checkOverflow(m) {
    var overflow, a = m._a;
    if (a && getParsingFlags(m).overflow === -2) {
      overflow = a[MONTH] < 0 || a[MONTH] > 11 ? MONTH : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH]) ? DATE : a[HOUR] < 0 || a[HOUR] > 24 || a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0) ? HOUR : a[MINUTE] < 0 || a[MINUTE] > 59 ? MINUTE : a[SECOND] < 0 || a[SECOND] > 59 ? SECOND : a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND : -1;
      if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
        overflow = DATE;
      }
      if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
        overflow = WEEK;
      }
      if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
        overflow = WEEKDAY;
      }
      getParsingFlags(m).overflow = overflow;
    }
    return m;
  }
  var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/, basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/, tzRegex = /Z|[+-]\d\d(?::?\d\d)?/, isoDates = [
    ["YYYYYY-MM-DD", /[+-]\d{6}-\d\d-\d\d/],
    ["YYYY-MM-DD", /\d{4}-\d\d-\d\d/],
    ["GGGG-[W]WW-E", /\d{4}-W\d\d-\d/],
    ["GGGG-[W]WW", /\d{4}-W\d\d/, false],
    ["YYYY-DDD", /\d{4}-\d{3}/],
    ["YYYY-MM", /\d{4}-\d\d/, false],
    ["YYYYYYMMDD", /[+-]\d{10}/],
    ["YYYYMMDD", /\d{8}/],
    ["GGGG[W]WWE", /\d{4}W\d{3}/],
    ["GGGG[W]WW", /\d{4}W\d{2}/, false],
    ["YYYYDDD", /\d{7}/],
    ["YYYYMM", /\d{6}/, false],
    ["YYYY", /\d{4}/, false]
  ], isoTimes = [
    ["HH:mm:ss.SSSS", /\d\d:\d\d:\d\d\.\d+/],
    ["HH:mm:ss,SSSS", /\d\d:\d\d:\d\d,\d+/],
    ["HH:mm:ss", /\d\d:\d\d:\d\d/],
    ["HH:mm", /\d\d:\d\d/],
    ["HHmmss.SSSS", /\d\d\d\d\d\d\.\d+/],
    ["HHmmss,SSSS", /\d\d\d\d\d\d,\d+/],
    ["HHmmss", /\d\d\d\d\d\d/],
    ["HHmm", /\d\d\d\d/],
    ["HH", /\d\d/]
  ], aspNetJsonRegex = /^\/?Date\((-?\d+)/i, rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/, obsOffsets = {
    UT: 0,
    GMT: 0,
    EDT: -4 * 60,
    EST: -5 * 60,
    CDT: -5 * 60,
    CST: -6 * 60,
    MDT: -6 * 60,
    MST: -7 * 60,
    PDT: -7 * 60,
    PST: -8 * 60
  };
  function configFromISO(config2) {
    var i2, l, string2 = config2._i, match5 = extendedIsoRegex.exec(string2) || basicIsoRegex.exec(string2), allowTime, dateFormat2, timeFormat2, tzFormat, isoDatesLen = isoDates.length, isoTimesLen = isoTimes.length;
    if (match5) {
      getParsingFlags(config2).iso = true;
      for (i2 = 0, l = isoDatesLen; i2 < l; i2++) {
        if (isoDates[i2][1].exec(match5[1])) {
          dateFormat2 = isoDates[i2][0];
          allowTime = isoDates[i2][2] !== false;
          break;
        }
      }
      if (dateFormat2 == null) {
        config2._isValid = false;
        return;
      }
      if (match5[3]) {
        for (i2 = 0, l = isoTimesLen; i2 < l; i2++) {
          if (isoTimes[i2][1].exec(match5[3])) {
            timeFormat2 = (match5[2] || " ") + isoTimes[i2][0];
            break;
          }
        }
        if (timeFormat2 == null) {
          config2._isValid = false;
          return;
        }
      }
      if (!allowTime && timeFormat2 != null) {
        config2._isValid = false;
        return;
      }
      if (match5[4]) {
        if (tzRegex.exec(match5[4])) {
          tzFormat = "Z";
        } else {
          config2._isValid = false;
          return;
        }
      }
      config2._f = dateFormat2 + (timeFormat2 || "") + (tzFormat || "");
      configFromStringAndFormat(config2);
    } else {
      config2._isValid = false;
    }
  }
  function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
    var result = [
      untruncateYear(yearStr),
      defaultLocaleMonthsShort.indexOf(monthStr),
      parseInt(dayStr, 10),
      parseInt(hourStr, 10),
      parseInt(minuteStr, 10)
    ];
    if (secondStr) {
      result.push(parseInt(secondStr, 10));
    }
    return result;
  }
  function untruncateYear(yearStr) {
    var year2 = parseInt(yearStr, 10);
    if (year2 <= 49) {
      return 2e3 + year2;
    } else if (year2 <= 999) {
      return 1900 + year2;
    }
    return year2;
  }
  function preprocessRFC2822(s) {
    return s.replace(/\([^()]*\)|[\n\t]/g, " ").replace(/(\s\s+)/g, " ").replace(/^\s\s*/, "").replace(/\s\s*$/, "");
  }
  function checkWeekday(weekdayStr, parsedInput, config2) {
    if (weekdayStr) {
      var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr), weekdayActual = new Date(
        parsedInput[0],
        parsedInput[1],
        parsedInput[2]
      ).getDay();
      if (weekdayProvided !== weekdayActual) {
        getParsingFlags(config2).weekdayMismatch = true;
        config2._isValid = false;
        return false;
      }
    }
    return true;
  }
  function calculateOffset(obsOffset, militaryOffset, numOffset) {
    if (obsOffset) {
      return obsOffsets[obsOffset];
    } else if (militaryOffset) {
      return 0;
    } else {
      var hm = parseInt(numOffset, 10), m = hm % 100, h = (hm - m) / 100;
      return h * 60 + m;
    }
  }
  function configFromRFC2822(config2) {
    var match5 = rfc2822.exec(preprocessRFC2822(config2._i)), parsedArray;
    if (match5) {
      parsedArray = extractFromRFC2822Strings(
        match5[4],
        match5[3],
        match5[2],
        match5[5],
        match5[6],
        match5[7]
      );
      if (!checkWeekday(match5[1], parsedArray, config2)) {
        return;
      }
      config2._a = parsedArray;
      config2._tzm = calculateOffset(match5[8], match5[9], match5[10]);
      config2._d = createUTCDate.apply(null, config2._a);
      config2._d.setUTCMinutes(config2._d.getUTCMinutes() - config2._tzm);
      getParsingFlags(config2).rfc2822 = true;
    } else {
      config2._isValid = false;
    }
  }
  function configFromString(config2) {
    var matched = aspNetJsonRegex.exec(config2._i);
    if (matched !== null) {
      config2._d = new Date(+matched[1]);
      return;
    }
    configFromISO(config2);
    if (config2._isValid === false) {
      delete config2._isValid;
    } else {
      return;
    }
    configFromRFC2822(config2);
    if (config2._isValid === false) {
      delete config2._isValid;
    } else {
      return;
    }
    if (config2._strict) {
      config2._isValid = false;
    } else {
      hooks.createFromInputFallback(config2);
    }
  }
  hooks.createFromInputFallback = deprecate(
    "value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",
    function(config2) {
      config2._d = new Date(config2._i + (config2._useUTC ? " UTC" : ""));
    }
  );
  function defaults$j(a, b, c2) {
    if (a != null) {
      return a;
    }
    if (b != null) {
      return b;
    }
    return c2;
  }
  function currentDateArray(config2) {
    var nowValue = new Date(hooks.now());
    if (config2._useUTC) {
      return [
        nowValue.getUTCFullYear(),
        nowValue.getUTCMonth(),
        nowValue.getUTCDate()
      ];
    }
    return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
  }
  function configFromArray(config2) {
    var i2, date2, input = [], currentDate, expectedWeekday, yearToUse;
    if (config2._d) {
      return;
    }
    currentDate = currentDateArray(config2);
    if (config2._w && config2._a[DATE] == null && config2._a[MONTH] == null) {
      dayOfYearFromWeekInfo(config2);
    }
    if (config2._dayOfYear != null) {
      yearToUse = defaults$j(config2._a[YEAR], currentDate[YEAR]);
      if (config2._dayOfYear > daysInYear(yearToUse) || config2._dayOfYear === 0) {
        getParsingFlags(config2)._overflowDayOfYear = true;
      }
      date2 = createUTCDate(yearToUse, 0, config2._dayOfYear);
      config2._a[MONTH] = date2.getUTCMonth();
      config2._a[DATE] = date2.getUTCDate();
    }
    for (i2 = 0; i2 < 3 && config2._a[i2] == null; ++i2) {
      config2._a[i2] = input[i2] = currentDate[i2];
    }
    for (; i2 < 7; i2++) {
      config2._a[i2] = input[i2] = config2._a[i2] == null ? i2 === 2 ? 1 : 0 : config2._a[i2];
    }
    if (config2._a[HOUR] === 24 && config2._a[MINUTE] === 0 && config2._a[SECOND] === 0 && config2._a[MILLISECOND] === 0) {
      config2._nextDay = true;
      config2._a[HOUR] = 0;
    }
    config2._d = (config2._useUTC ? createUTCDate : createDate).apply(
      null,
      input
    );
    expectedWeekday = config2._useUTC ? config2._d.getUTCDay() : config2._d.getDay();
    if (config2._tzm != null) {
      config2._d.setUTCMinutes(config2._d.getUTCMinutes() - config2._tzm);
    }
    if (config2._nextDay) {
      config2._a[HOUR] = 24;
    }
    if (config2._w && typeof config2._w.d !== "undefined" && config2._w.d !== expectedWeekday) {
      getParsingFlags(config2).weekdayMismatch = true;
    }
  }
  function dayOfYearFromWeekInfo(config2) {
    var w2, weekYear, week, weekday2, dow, doy, temp, weekdayOverflow, curWeek;
    w2 = config2._w;
    if (w2.GG != null || w2.W != null || w2.E != null) {
      dow = 1;
      doy = 4;
      weekYear = defaults$j(
        w2.GG,
        config2._a[YEAR],
        weekOfYear(createLocal(), 1, 4).year
      );
      week = defaults$j(w2.W, 1);
      weekday2 = defaults$j(w2.E, 1);
      if (weekday2 < 1 || weekday2 > 7) {
        weekdayOverflow = true;
      }
    } else {
      dow = config2._locale._week.dow;
      doy = config2._locale._week.doy;
      curWeek = weekOfYear(createLocal(), dow, doy);
      weekYear = defaults$j(w2.gg, config2._a[YEAR], curWeek.year);
      week = defaults$j(w2.w, curWeek.week);
      if (w2.d != null) {
        weekday2 = w2.d;
        if (weekday2 < 0 || weekday2 > 6) {
          weekdayOverflow = true;
        }
      } else if (w2.e != null) {
        weekday2 = w2.e + dow;
        if (w2.e < 0 || w2.e > 6) {
          weekdayOverflow = true;
        }
      } else {
        weekday2 = dow;
      }
    }
    if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
      getParsingFlags(config2)._overflowWeeks = true;
    } else if (weekdayOverflow != null) {
      getParsingFlags(config2)._overflowWeekday = true;
    } else {
      temp = dayOfYearFromWeeks(weekYear, week, weekday2, dow, doy);
      config2._a[YEAR] = temp.year;
      config2._dayOfYear = temp.dayOfYear;
    }
  }
  hooks.ISO_8601 = function() {
  };
  hooks.RFC_2822 = function() {
  };
  function configFromStringAndFormat(config2) {
    if (config2._f === hooks.ISO_8601) {
      configFromISO(config2);
      return;
    }
    if (config2._f === hooks.RFC_2822) {
      configFromRFC2822(config2);
      return;
    }
    config2._a = [];
    getParsingFlags(config2).empty = true;
    var string2 = "" + config2._i, i2, parsedInput, tokens2, token2, skipped, stringLength = string2.length, totalParsedInputLength = 0, era, tokenLen;
    tokens2 = expandFormat(config2._f, config2._locale).match(formattingTokens) || [];
    tokenLen = tokens2.length;
    for (i2 = 0; i2 < tokenLen; i2++) {
      token2 = tokens2[i2];
      parsedInput = (string2.match(getParseRegexForToken(token2, config2)) || [])[0];
      if (parsedInput) {
        skipped = string2.substr(0, string2.indexOf(parsedInput));
        if (skipped.length > 0) {
          getParsingFlags(config2).unusedInput.push(skipped);
        }
        string2 = string2.slice(
          string2.indexOf(parsedInput) + parsedInput.length
        );
        totalParsedInputLength += parsedInput.length;
      }
      if (formatTokenFunctions[token2]) {
        if (parsedInput) {
          getParsingFlags(config2).empty = false;
        } else {
          getParsingFlags(config2).unusedTokens.push(token2);
        }
        addTimeToArrayFromToken(token2, parsedInput, config2);
      } else if (config2._strict && !parsedInput) {
        getParsingFlags(config2).unusedTokens.push(token2);
      }
    }
    getParsingFlags(config2).charsLeftOver = stringLength - totalParsedInputLength;
    if (string2.length > 0) {
      getParsingFlags(config2).unusedInput.push(string2);
    }
    if (config2._a[HOUR] <= 12 && getParsingFlags(config2).bigHour === true && config2._a[HOUR] > 0) {
      getParsingFlags(config2).bigHour = void 0;
    }
    getParsingFlags(config2).parsedDateParts = config2._a.slice(0);
    getParsingFlags(config2).meridiem = config2._meridiem;
    config2._a[HOUR] = meridiemFixWrap(
      config2._locale,
      config2._a[HOUR],
      config2._meridiem
    );
    era = getParsingFlags(config2).era;
    if (era !== null) {
      config2._a[YEAR] = config2._locale.erasConvertYear(era, config2._a[YEAR]);
    }
    configFromArray(config2);
    checkOverflow(config2);
  }
  function meridiemFixWrap(locale2, hour2, meridiem2) {
    var isPm;
    if (meridiem2 == null) {
      return hour2;
    }
    if (locale2.meridiemHour != null) {
      return locale2.meridiemHour(hour2, meridiem2);
    } else if (locale2.isPM != null) {
      isPm = locale2.isPM(meridiem2);
      if (isPm && hour2 < 12) {
        hour2 += 12;
      }
      if (!isPm && hour2 === 12) {
        hour2 = 0;
      }
      return hour2;
    } else {
      return hour2;
    }
  }
  function configFromStringAndArray(config2) {
    var tempConfig, bestMoment, scoreToBeat, i2, currentScore, validFormatFound, bestFormatIsValid = false, configfLen = config2._f.length;
    if (configfLen === 0) {
      getParsingFlags(config2).invalidFormat = true;
      config2._d = new Date(NaN);
      return;
    }
    for (i2 = 0; i2 < configfLen; i2++) {
      currentScore = 0;
      validFormatFound = false;
      tempConfig = copyConfig({}, config2);
      if (config2._useUTC != null) {
        tempConfig._useUTC = config2._useUTC;
      }
      tempConfig._f = config2._f[i2];
      configFromStringAndFormat(tempConfig);
      if (isValid(tempConfig)) {
        validFormatFound = true;
      }
      currentScore += getParsingFlags(tempConfig).charsLeftOver;
      currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
      getParsingFlags(tempConfig).score = currentScore;
      if (!bestFormatIsValid) {
        if (scoreToBeat == null || currentScore < scoreToBeat || validFormatFound) {
          scoreToBeat = currentScore;
          bestMoment = tempConfig;
          if (validFormatFound) {
            bestFormatIsValid = true;
          }
        }
      } else {
        if (currentScore < scoreToBeat) {
          scoreToBeat = currentScore;
          bestMoment = tempConfig;
        }
      }
    }
    extend$3(config2, bestMoment || tempConfig);
  }
  function configFromObject(config2) {
    if (config2._d) {
      return;
    }
    var i2 = normalizeObjectUnits(config2._i), dayOrDate = i2.day === void 0 ? i2.date : i2.day;
    config2._a = map$3(
      [i2.year, i2.month, dayOrDate, i2.hour, i2.minute, i2.second, i2.millisecond],
      function(obj) {
        return obj && parseInt(obj, 10);
      }
    );
    configFromArray(config2);
  }
  function createFromConfig(config2) {
    var res = new Moment(checkOverflow(prepareConfig(config2)));
    if (res._nextDay) {
      res.add(1, "d");
      res._nextDay = void 0;
    }
    return res;
  }
  function prepareConfig(config2) {
    var input = config2._i, format2 = config2._f;
    config2._locale = config2._locale || getLocale(config2._l);
    if (input === null || format2 === void 0 && input === "") {
      return createInvalid({ nullInput: true });
    }
    if (typeof input === "string") {
      config2._i = input = config2._locale.preparse(input);
    }
    if (isMoment(input)) {
      return new Moment(checkOverflow(input));
    } else if (isDate(input)) {
      config2._d = input;
    } else if (isArray$7(format2)) {
      configFromStringAndArray(config2);
    } else if (format2) {
      configFromStringAndFormat(config2);
    } else {
      configFromInput(config2);
    }
    if (!isValid(config2)) {
      config2._d = null;
    }
    return config2;
  }
  function configFromInput(config2) {
    var input = config2._i;
    if (isUndefined$1(input)) {
      config2._d = new Date(hooks.now());
    } else if (isDate(input)) {
      config2._d = new Date(input.valueOf());
    } else if (typeof input === "string") {
      configFromString(config2);
    } else if (isArray$7(input)) {
      config2._a = map$3(input.slice(0), function(obj) {
        return parseInt(obj, 10);
      });
      configFromArray(config2);
    } else if (isObject$8(input)) {
      configFromObject(config2);
    } else if (isNumber(input)) {
      config2._d = new Date(input);
    } else {
      hooks.createFromInputFallback(config2);
    }
  }
  function createLocalOrUTC(input, format2, locale2, strict, isUTC) {
    var c2 = {};
    if (format2 === true || format2 === false) {
      strict = format2;
      format2 = void 0;
    }
    if (locale2 === true || locale2 === false) {
      strict = locale2;
      locale2 = void 0;
    }
    if (isObject$8(input) && isObjectEmpty(input) || isArray$7(input) && input.length === 0) {
      input = void 0;
    }
    c2._isAMomentObject = true;
    c2._useUTC = c2._isUTC = isUTC;
    c2._l = locale2;
    c2._i = input;
    c2._f = format2;
    c2._strict = strict;
    return createFromConfig(c2);
  }
  function createLocal(input, format2, locale2, strict) {
    return createLocalOrUTC(input, format2, locale2, strict, false);
  }
  var prototypeMin = deprecate(
    "moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",
    function() {
      var other = createLocal.apply(null, arguments);
      if (this.isValid() && other.isValid()) {
        return other < this ? this : other;
      } else {
        return createInvalid();
      }
    }
  ), prototypeMax = deprecate(
    "moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",
    function() {
      var other = createLocal.apply(null, arguments);
      if (this.isValid() && other.isValid()) {
        return other > this ? this : other;
      } else {
        return createInvalid();
      }
    }
  );
  function pickBy(fn2, moments) {
    var res, i2;
    if (moments.length === 1 && isArray$7(moments[0])) {
      moments = moments[0];
    }
    if (!moments.length) {
      return createLocal();
    }
    res = moments[0];
    for (i2 = 1; i2 < moments.length; ++i2) {
      if (!moments[i2].isValid() || moments[i2][fn2](res)) {
        res = moments[i2];
      }
    }
    return res;
  }
  function min$4() {
    var args = [].slice.call(arguments, 0);
    return pickBy("isBefore", args);
  }
  function max$4() {
    var args = [].slice.call(arguments, 0);
    return pickBy("isAfter", args);
  }
  var now$5 = function() {
    return Date.now ? Date.now() : +new Date();
  };
  var ordering = [
    "year",
    "quarter",
    "month",
    "week",
    "day",
    "hour",
    "minute",
    "second",
    "millisecond"
  ];
  function isDurationValid(m) {
    var key, unitHasDecimal = false, i2, orderLen = ordering.length;
    for (key in m) {
      if (hasOwnProp(m, key) && !(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
        return false;
      }
    }
    for (i2 = 0; i2 < orderLen; ++i2) {
      if (m[ordering[i2]]) {
        if (unitHasDecimal) {
          return false;
        }
        if (parseFloat(m[ordering[i2]]) !== toInt(m[ordering[i2]])) {
          unitHasDecimal = true;
        }
      }
    }
    return true;
  }
  function isValid$1() {
    return this._isValid;
  }
  function createInvalid$1() {
    return createDuration(NaN);
  }
  function Duration(duration) {
    var normalizedInput = normalizeObjectUnits(duration), years2 = normalizedInput.year || 0, quarters = normalizedInput.quarter || 0, months2 = normalizedInput.month || 0, weeks2 = normalizedInput.week || normalizedInput.isoWeek || 0, days2 = normalizedInput.day || 0, hours2 = normalizedInput.hour || 0, minutes2 = normalizedInput.minute || 0, seconds2 = normalizedInput.second || 0, milliseconds2 = normalizedInput.millisecond || 0;
    this._isValid = isDurationValid(normalizedInput);
    this._milliseconds = +milliseconds2 + seconds2 * 1e3 + minutes2 * 6e4 + hours2 * 1e3 * 60 * 60;
    this._days = +days2 + weeks2 * 7;
    this._months = +months2 + quarters * 3 + years2 * 12;
    this._data = {};
    this._locale = getLocale();
    this._bubble();
  }
  function isDuration(obj) {
    return obj instanceof Duration;
  }
  function absRound(number2) {
    if (number2 < 0) {
      return Math.round(-1 * number2) * -1;
    } else {
      return Math.round(number2);
    }
  }
  function compareArrays(array1, array2, dontConvert) {
    var len = Math.min(array1.length, array2.length), lengthDiff = Math.abs(array1.length - array2.length), diffs = 0, i2;
    for (i2 = 0; i2 < len; i2++) {
      if (dontConvert && array1[i2] !== array2[i2] || !dontConvert && toInt(array1[i2]) !== toInt(array2[i2])) {
        diffs++;
      }
    }
    return diffs + lengthDiff;
  }
  function offset(token2, separator) {
    addFormatToken(token2, 0, 0, function() {
      var offset2 = this.utcOffset(), sign2 = "+";
      if (offset2 < 0) {
        offset2 = -offset2;
        sign2 = "-";
      }
      return sign2 + zeroFill(~~(offset2 / 60), 2) + separator + zeroFill(~~offset2 % 60, 2);
    });
  }
  offset("Z", ":");
  offset("ZZ", "");
  addRegexToken("Z", matchShortOffset);
  addRegexToken("ZZ", matchShortOffset);
  addParseToken(["Z", "ZZ"], function(input, array2, config2) {
    config2._useUTC = true;
    config2._tzm = offsetFromString(matchShortOffset, input);
  });
  var chunkOffset = /([\+\-]|\d\d)/gi;
  function offsetFromString(matcher2, string2) {
    var matches2 = (string2 || "").match(matcher2), chunk, parts, minutes2;
    if (matches2 === null) {
      return null;
    }
    chunk = matches2[matches2.length - 1] || [];
    parts = (chunk + "").match(chunkOffset) || ["-", 0, 0];
    minutes2 = +(parts[1] * 60) + toInt(parts[2]);
    return minutes2 === 0 ? 0 : parts[0] === "+" ? minutes2 : -minutes2;
  }
  function cloneWithOffset(input, model) {
    var res, diff2;
    if (model._isUTC) {
      res = model.clone();
      diff2 = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
      res._d.setTime(res._d.valueOf() + diff2);
      hooks.updateOffset(res, false);
      return res;
    } else {
      return createLocal(input).local();
    }
  }
  function getDateOffset(m) {
    return -Math.round(m._d.getTimezoneOffset());
  }
  hooks.updateOffset = function() {
  };
  function getSetOffset(input, keepLocalTime, keepMinutes) {
    var offset2 = this._offset || 0, localAdjust;
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    if (input != null) {
      if (typeof input === "string") {
        input = offsetFromString(matchShortOffset, input);
        if (input === null) {
          return this;
        }
      } else if (Math.abs(input) < 16 && !keepMinutes) {
        input = input * 60;
      }
      if (!this._isUTC && keepLocalTime) {
        localAdjust = getDateOffset(this);
      }
      this._offset = input;
      this._isUTC = true;
      if (localAdjust != null) {
        this.add(localAdjust, "m");
      }
      if (offset2 !== input) {
        if (!keepLocalTime || this._changeInProgress) {
          addSubtract(
            this,
            createDuration(input - offset2, "m"),
            1,
            false
          );
        } else if (!this._changeInProgress) {
          this._changeInProgress = true;
          hooks.updateOffset(this, true);
          this._changeInProgress = null;
        }
      }
      return this;
    } else {
      return this._isUTC ? offset2 : getDateOffset(this);
    }
  }
  function getSetZone(input, keepLocalTime) {
    if (input != null) {
      if (typeof input !== "string") {
        input = -input;
      }
      this.utcOffset(input, keepLocalTime);
      return this;
    } else {
      return -this.utcOffset();
    }
  }
  function setOffsetToUTC(keepLocalTime) {
    return this.utcOffset(0, keepLocalTime);
  }
  function setOffsetToLocal(keepLocalTime) {
    if (this._isUTC) {
      this.utcOffset(0, keepLocalTime);
      this._isUTC = false;
      if (keepLocalTime) {
        this.subtract(getDateOffset(this), "m");
      }
    }
    return this;
  }
  function setOffsetToParsedOffset() {
    if (this._tzm != null) {
      this.utcOffset(this._tzm, false, true);
    } else if (typeof this._i === "string") {
      var tZone = offsetFromString(matchOffset, this._i);
      if (tZone != null) {
        this.utcOffset(tZone);
      } else {
        this.utcOffset(0, true);
      }
    }
    return this;
  }
  function hasAlignedHourOffset(input) {
    if (!this.isValid()) {
      return false;
    }
    input = input ? createLocal(input).utcOffset() : 0;
    return (this.utcOffset() - input) % 60 === 0;
  }
  function isDaylightSavingTime() {
    return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
  }
  function isDaylightSavingTimeShifted() {
    if (!isUndefined$1(this._isDSTShifted)) {
      return this._isDSTShifted;
    }
    var c2 = {}, other;
    copyConfig(c2, this);
    c2 = prepareConfig(c2);
    if (c2._a) {
      other = c2._isUTC ? createUTC(c2._a) : createLocal(c2._a);
      this._isDSTShifted = this.isValid() && compareArrays(c2._a, other.toArray()) > 0;
    } else {
      this._isDSTShifted = false;
    }
    return this._isDSTShifted;
  }
  function isLocal() {
    return this.isValid() ? !this._isUTC : false;
  }
  function isUtcOffset() {
    return this.isValid() ? this._isUTC : false;
  }
  function isUtc() {
    return this.isValid() ? this._isUTC && this._offset === 0 : false;
  }
  var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/, isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;
  function createDuration(input, key) {
    var duration = input, match5 = null, sign2, ret, diffRes;
    if (isDuration(input)) {
      duration = {
        ms: input._milliseconds,
        d: input._days,
        M: input._months
      };
    } else if (isNumber(input) || !isNaN(+input)) {
      duration = {};
      if (key) {
        duration[key] = +input;
      } else {
        duration.milliseconds = +input;
      }
    } else if (match5 = aspNetRegex.exec(input)) {
      sign2 = match5[1] === "-" ? -1 : 1;
      duration = {
        y: 0,
        d: toInt(match5[DATE]) * sign2,
        h: toInt(match5[HOUR]) * sign2,
        m: toInt(match5[MINUTE]) * sign2,
        s: toInt(match5[SECOND]) * sign2,
        ms: toInt(absRound(match5[MILLISECOND] * 1e3)) * sign2
      };
    } else if (match5 = isoRegex.exec(input)) {
      sign2 = match5[1] === "-" ? -1 : 1;
      duration = {
        y: parseIso(match5[2], sign2),
        M: parseIso(match5[3], sign2),
        w: parseIso(match5[4], sign2),
        d: parseIso(match5[5], sign2),
        h: parseIso(match5[6], sign2),
        m: parseIso(match5[7], sign2),
        s: parseIso(match5[8], sign2)
      };
    } else if (duration == null) {
      duration = {};
    } else if (typeof duration === "object" && ("from" in duration || "to" in duration)) {
      diffRes = momentsDifference(
        createLocal(duration.from),
        createLocal(duration.to)
      );
      duration = {};
      duration.ms = diffRes.milliseconds;
      duration.M = diffRes.months;
    }
    ret = new Duration(duration);
    if (isDuration(input) && hasOwnProp(input, "_locale")) {
      ret._locale = input._locale;
    }
    if (isDuration(input) && hasOwnProp(input, "_isValid")) {
      ret._isValid = input._isValid;
    }
    return ret;
  }
  createDuration.fn = Duration.prototype;
  createDuration.invalid = createInvalid$1;
  function parseIso(inp, sign2) {
    var res = inp && parseFloat(inp.replace(",", "."));
    return (isNaN(res) ? 0 : res) * sign2;
  }
  function positiveMomentsDifference(base, other) {
    var res = {};
    res.months = other.month() - base.month() + (other.year() - base.year()) * 12;
    if (base.clone().add(res.months, "M").isAfter(other)) {
      --res.months;
    }
    res.milliseconds = +other - +base.clone().add(res.months, "M");
    return res;
  }
  function momentsDifference(base, other) {
    var res;
    if (!(base.isValid() && other.isValid())) {
      return { milliseconds: 0, months: 0 };
    }
    other = cloneWithOffset(other, base);
    if (base.isBefore(other)) {
      res = positiveMomentsDifference(base, other);
    } else {
      res = positiveMomentsDifference(other, base);
      res.milliseconds = -res.milliseconds;
      res.months = -res.months;
    }
    return res;
  }
  function createAdder(direction2, name2) {
    return function(val, period) {
      var dur, tmp;
      if (period !== null && !isNaN(+period)) {
        deprecateSimple(
          name2,
          "moment()." + name2 + "(period, number) is deprecated. Please use moment()." + name2 + "(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."
        );
        tmp = val;
        val = period;
        period = tmp;
      }
      dur = createDuration(val, period);
      addSubtract(this, dur, direction2);
      return this;
    };
  }
  function addSubtract(mom, duration, isAdding, updateOffset) {
    var milliseconds2 = duration._milliseconds, days2 = absRound(duration._days), months2 = absRound(duration._months);
    if (!mom.isValid()) {
      return;
    }
    updateOffset = updateOffset == null ? true : updateOffset;
    if (months2) {
      setMonth(mom, get$6(mom, "Month") + months2 * isAdding);
    }
    if (days2) {
      set$1$1(mom, "Date", get$6(mom, "Date") + days2 * isAdding);
    }
    if (milliseconds2) {
      mom._d.setTime(mom._d.valueOf() + milliseconds2 * isAdding);
    }
    if (updateOffset) {
      hooks.updateOffset(mom, days2 || months2);
    }
  }
  var add = createAdder(1, "add"), subtract = createAdder(-1, "subtract");
  function isString(input) {
    return typeof input === "string" || input instanceof String;
  }
  function isMomentInput(input) {
    return isMoment(input) || isDate(input) || isString(input) || isNumber(input) || isNumberOrStringArray(input) || isMomentInputObject(input) || input === null || input === void 0;
  }
  function isMomentInputObject(input) {
    var objectTest = isObject$8(input) && !isObjectEmpty(input), propertyTest = false, properties = [
      "years",
      "year",
      "y",
      "months",
      "month",
      "M",
      "days",
      "day",
      "d",
      "dates",
      "date",
      "D",
      "hours",
      "hour",
      "h",
      "minutes",
      "minute",
      "m",
      "seconds",
      "second",
      "s",
      "milliseconds",
      "millisecond",
      "ms"
    ], i2, property2, propertyLen = properties.length;
    for (i2 = 0; i2 < propertyLen; i2 += 1) {
      property2 = properties[i2];
      propertyTest = propertyTest || hasOwnProp(input, property2);
    }
    return objectTest && propertyTest;
  }
  function isNumberOrStringArray(input) {
    var arrayTest = isArray$7(input), dataTypeTest = false;
    if (arrayTest) {
      dataTypeTest = input.filter(function(item) {
        return !isNumber(item) && isString(input);
      }).length === 0;
    }
    return arrayTest && dataTypeTest;
  }
  function isCalendarSpec(input) {
    var objectTest = isObject$8(input) && !isObjectEmpty(input), propertyTest = false, properties = [
      "sameDay",
      "nextDay",
      "lastDay",
      "nextWeek",
      "lastWeek",
      "sameElse"
    ], i2, property2;
    for (i2 = 0; i2 < properties.length; i2 += 1) {
      property2 = properties[i2];
      propertyTest = propertyTest || hasOwnProp(input, property2);
    }
    return objectTest && propertyTest;
  }
  function getCalendarFormat(myMoment, now2) {
    var diff2 = myMoment.diff(now2, "days", true);
    return diff2 < -6 ? "sameElse" : diff2 < -1 ? "lastWeek" : diff2 < 0 ? "lastDay" : diff2 < 1 ? "sameDay" : diff2 < 2 ? "nextDay" : diff2 < 7 ? "nextWeek" : "sameElse";
  }
  function calendar$1$1(time2, formats) {
    if (arguments.length === 1) {
      if (!arguments[0]) {
        time2 = void 0;
        formats = void 0;
      } else if (isMomentInput(arguments[0])) {
        time2 = arguments[0];
        formats = void 0;
      } else if (isCalendarSpec(arguments[0])) {
        formats = arguments[0];
        time2 = void 0;
      }
    }
    var now2 = time2 || createLocal(), sod = cloneWithOffset(now2, this).startOf("day"), format2 = hooks.calendarFormat(this, sod) || "sameElse", output2 = formats && (isFunction$3(formats[format2]) ? formats[format2].call(this, now2) : formats[format2]);
    return this.format(
      output2 || this.localeData().calendar(format2, this, createLocal(now2))
    );
  }
  function clone$4() {
    return new Moment(this);
  }
  function isAfter(input, units) {
    var localInput = isMoment(input) ? input : createLocal(input);
    if (!(this.isValid() && localInput.isValid())) {
      return false;
    }
    units = normalizeUnits(units) || "millisecond";
    if (units === "millisecond") {
      return this.valueOf() > localInput.valueOf();
    } else {
      return localInput.valueOf() < this.clone().startOf(units).valueOf();
    }
  }
  function isBefore(input, units) {
    var localInput = isMoment(input) ? input : createLocal(input);
    if (!(this.isValid() && localInput.isValid())) {
      return false;
    }
    units = normalizeUnits(units) || "millisecond";
    if (units === "millisecond") {
      return this.valueOf() < localInput.valueOf();
    } else {
      return this.clone().endOf(units).valueOf() < localInput.valueOf();
    }
  }
  function isBetween(from2, to2, units, inclusivity) {
    var localFrom = isMoment(from2) ? from2 : createLocal(from2), localTo = isMoment(to2) ? to2 : createLocal(to2);
    if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
      return false;
    }
    inclusivity = inclusivity || "()";
    return (inclusivity[0] === "(" ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) && (inclusivity[1] === ")" ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
  }
  function isSame(input, units) {
    var localInput = isMoment(input) ? input : createLocal(input), inputMs;
    if (!(this.isValid() && localInput.isValid())) {
      return false;
    }
    units = normalizeUnits(units) || "millisecond";
    if (units === "millisecond") {
      return this.valueOf() === localInput.valueOf();
    } else {
      inputMs = localInput.valueOf();
      return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
    }
  }
  function isSameOrAfter(input, units) {
    return this.isSame(input, units) || this.isAfter(input, units);
  }
  function isSameOrBefore(input, units) {
    return this.isSame(input, units) || this.isBefore(input, units);
  }
  function diff(input, units, asFloat) {
    var that, zoneDelta, output2;
    if (!this.isValid()) {
      return NaN;
    }
    that = cloneWithOffset(input, this);
    if (!that.isValid()) {
      return NaN;
    }
    zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
    units = normalizeUnits(units);
    switch (units) {
      case "year":
        output2 = monthDiff(this, that) / 12;
        break;
      case "month":
        output2 = monthDiff(this, that);
        break;
      case "quarter":
        output2 = monthDiff(this, that) / 3;
        break;
      case "second":
        output2 = (this - that) / 1e3;
        break;
      case "minute":
        output2 = (this - that) / 6e4;
        break;
      case "hour":
        output2 = (this - that) / 36e5;
        break;
      case "day":
        output2 = (this - that - zoneDelta) / 864e5;
        break;
      case "week":
        output2 = (this - that - zoneDelta) / 6048e5;
        break;
      default:
        output2 = this - that;
    }
    return asFloat ? output2 : absFloor(output2);
  }
  function monthDiff(a, b) {
    if (a.date() < b.date()) {
      return -monthDiff(b, a);
    }
    var wholeMonthDiff = (b.year() - a.year()) * 12 + (b.month() - a.month()), anchor = a.clone().add(wholeMonthDiff, "months"), anchor2, adjust2;
    if (b - anchor < 0) {
      anchor2 = a.clone().add(wholeMonthDiff - 1, "months");
      adjust2 = (b - anchor) / (anchor - anchor2);
    } else {
      anchor2 = a.clone().add(wholeMonthDiff + 1, "months");
      adjust2 = (b - anchor) / (anchor2 - anchor);
    }
    return -(wholeMonthDiff + adjust2) || 0;
  }
  hooks.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
  hooks.defaultFormatUtc = "YYYY-MM-DDTHH:mm:ss[Z]";
  function toString$5() {
    return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
  }
  function toISOString(keepOffset) {
    if (!this.isValid()) {
      return null;
    }
    var utc = keepOffset !== true, m = utc ? this.clone().utc() : this;
    if (m.year() < 0 || m.year() > 9999) {
      return formatMoment(
        m,
        utc ? "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"
      );
    }
    if (isFunction$3(Date.prototype.toISOString)) {
      if (utc) {
        return this.toDate().toISOString();
      } else {
        return new Date(this.valueOf() + this.utcOffset() * 60 * 1e3).toISOString().replace("Z", formatMoment(m, "Z"));
      }
    }
    return formatMoment(
      m,
      utc ? "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYY-MM-DD[T]HH:mm:ss.SSSZ"
    );
  }
  function inspect() {
    if (!this.isValid()) {
      return "moment.invalid(/* " + this._i + " */)";
    }
    var func = "moment", zone = "", prefix, year2, datetime, suffix;
    if (!this.isLocal()) {
      func = this.utcOffset() === 0 ? "moment.utc" : "moment.parseZone";
      zone = "Z";
    }
    prefix = "[" + func + '("]';
    year2 = 0 <= this.year() && this.year() <= 9999 ? "YYYY" : "YYYYYY";
    datetime = "-MM-DD[T]HH:mm:ss.SSS";
    suffix = zone + '[")]';
    return this.format(prefix + year2 + datetime + suffix);
  }
  function format$2(inputString) {
    if (!inputString) {
      inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
    }
    var output2 = formatMoment(this, inputString);
    return this.localeData().postformat(output2);
  }
  function from$1(time2, withoutSuffix) {
    if (this.isValid() && (isMoment(time2) && time2.isValid() || createLocal(time2).isValid())) {
      return createDuration({ to: this, from: time2 }).locale(this.locale()).humanize(!withoutSuffix);
    } else {
      return this.localeData().invalidDate();
    }
  }
  function fromNow(withoutSuffix) {
    return this.from(createLocal(), withoutSuffix);
  }
  function to(time2, withoutSuffix) {
    if (this.isValid() && (isMoment(time2) && time2.isValid() || createLocal(time2).isValid())) {
      return createDuration({ from: this, to: time2 }).locale(this.locale()).humanize(!withoutSuffix);
    } else {
      return this.localeData().invalidDate();
    }
  }
  function toNow(withoutSuffix) {
    return this.to(createLocal(), withoutSuffix);
  }
  function locale$2(key) {
    var newLocaleData;
    if (key === void 0) {
      return this._locale._abbr;
    } else {
      newLocaleData = getLocale(key);
      if (newLocaleData != null) {
        this._locale = newLocaleData;
      }
      return this;
    }
  }
  var lang$1 = deprecate(
    "moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",
    function(key) {
      if (key === void 0) {
        return this.localeData();
      } else {
        return this.locale(key);
      }
    }
  );
  function localeData() {
    return this._locale;
  }
  var MS_PER_SECOND = 1e3, MS_PER_MINUTE = 60 * MS_PER_SECOND, MS_PER_HOUR = 60 * MS_PER_MINUTE, MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;
  function mod$1(dividend, divisor) {
    return (dividend % divisor + divisor) % divisor;
  }
  function localStartOfDate(y2, m, d) {
    if (y2 < 100 && y2 >= 0) {
      return new Date(y2 + 400, m, d) - MS_PER_400_YEARS;
    } else {
      return new Date(y2, m, d).valueOf();
    }
  }
  function utcStartOfDate(y2, m, d) {
    if (y2 < 100 && y2 >= 0) {
      return Date.UTC(y2 + 400, m, d) - MS_PER_400_YEARS;
    } else {
      return Date.UTC(y2, m, d);
    }
  }
  function startOf(units) {
    var time2, startOfDate;
    units = normalizeUnits(units);
    if (units === void 0 || units === "millisecond" || !this.isValid()) {
      return this;
    }
    startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
    switch (units) {
      case "year":
        time2 = startOfDate(this.year(), 0, 1);
        break;
      case "quarter":
        time2 = startOfDate(
          this.year(),
          this.month() - this.month() % 3,
          1
        );
        break;
      case "month":
        time2 = startOfDate(this.year(), this.month(), 1);
        break;
      case "week":
        time2 = startOfDate(
          this.year(),
          this.month(),
          this.date() - this.weekday()
        );
        break;
      case "isoWeek":
        time2 = startOfDate(
          this.year(),
          this.month(),
          this.date() - (this.isoWeekday() - 1)
        );
        break;
      case "day":
      case "date":
        time2 = startOfDate(this.year(), this.month(), this.date());
        break;
      case "hour":
        time2 = this._d.valueOf();
        time2 -= mod$1(
          time2 + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
          MS_PER_HOUR
        );
        break;
      case "minute":
        time2 = this._d.valueOf();
        time2 -= mod$1(time2, MS_PER_MINUTE);
        break;
      case "second":
        time2 = this._d.valueOf();
        time2 -= mod$1(time2, MS_PER_SECOND);
        break;
    }
    this._d.setTime(time2);
    hooks.updateOffset(this, true);
    return this;
  }
  function endOf(units) {
    var time2, startOfDate;
    units = normalizeUnits(units);
    if (units === void 0 || units === "millisecond" || !this.isValid()) {
      return this;
    }
    startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
    switch (units) {
      case "year":
        time2 = startOfDate(this.year() + 1, 0, 1) - 1;
        break;
      case "quarter":
        time2 = startOfDate(
          this.year(),
          this.month() - this.month() % 3 + 3,
          1
        ) - 1;
        break;
      case "month":
        time2 = startOfDate(this.year(), this.month() + 1, 1) - 1;
        break;
      case "week":
        time2 = startOfDate(
          this.year(),
          this.month(),
          this.date() - this.weekday() + 7
        ) - 1;
        break;
      case "isoWeek":
        time2 = startOfDate(
          this.year(),
          this.month(),
          this.date() - (this.isoWeekday() - 1) + 7
        ) - 1;
        break;
      case "day":
      case "date":
        time2 = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
        break;
      case "hour":
        time2 = this._d.valueOf();
        time2 += MS_PER_HOUR - mod$1(
          time2 + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
          MS_PER_HOUR
        ) - 1;
        break;
      case "minute":
        time2 = this._d.valueOf();
        time2 += MS_PER_MINUTE - mod$1(time2, MS_PER_MINUTE) - 1;
        break;
      case "second":
        time2 = this._d.valueOf();
        time2 += MS_PER_SECOND - mod$1(time2, MS_PER_SECOND) - 1;
        break;
    }
    this._d.setTime(time2);
    hooks.updateOffset(this, true);
    return this;
  }
  function valueOf() {
    return this._d.valueOf() - (this._offset || 0) * 6e4;
  }
  function unix() {
    return Math.floor(this.valueOf() / 1e3);
  }
  function toDate() {
    return new Date(this.valueOf());
  }
  function toArray$1() {
    var m = this;
    return [
      m.year(),
      m.month(),
      m.date(),
      m.hour(),
      m.minute(),
      m.second(),
      m.millisecond()
    ];
  }
  function toObject() {
    var m = this;
    return {
      years: m.year(),
      months: m.month(),
      date: m.date(),
      hours: m.hours(),
      minutes: m.minutes(),
      seconds: m.seconds(),
      milliseconds: m.milliseconds()
    };
  }
  function toJSON() {
    return this.isValid() ? this.toISOString() : null;
  }
  function isValid$2() {
    return isValid(this);
  }
  function parsingFlags() {
    return extend$3({}, getParsingFlags(this));
  }
  function invalidAt() {
    return getParsingFlags(this).overflow;
  }
  function creationData() {
    return {
      input: this._i,
      format: this._f,
      locale: this._locale,
      isUTC: this._isUTC,
      strict: this._strict
    };
  }
  addFormatToken("N", 0, 0, "eraAbbr");
  addFormatToken("NN", 0, 0, "eraAbbr");
  addFormatToken("NNN", 0, 0, "eraAbbr");
  addFormatToken("NNNN", 0, 0, "eraName");
  addFormatToken("NNNNN", 0, 0, "eraNarrow");
  addFormatToken("y", ["y", 1], "yo", "eraYear");
  addFormatToken("y", ["yy", 2], 0, "eraYear");
  addFormatToken("y", ["yyy", 3], 0, "eraYear");
  addFormatToken("y", ["yyyy", 4], 0, "eraYear");
  addRegexToken("N", matchEraAbbr);
  addRegexToken("NN", matchEraAbbr);
  addRegexToken("NNN", matchEraAbbr);
  addRegexToken("NNNN", matchEraName);
  addRegexToken("NNNNN", matchEraNarrow);
  addParseToken(
    ["N", "NN", "NNN", "NNNN", "NNNNN"],
    function(input, array2, config2, token2) {
      var era = config2._locale.erasParse(input, token2, config2._strict);
      if (era) {
        getParsingFlags(config2).era = era;
      } else {
        getParsingFlags(config2).invalidEra = input;
      }
    }
  );
  addRegexToken("y", matchUnsigned);
  addRegexToken("yy", matchUnsigned);
  addRegexToken("yyy", matchUnsigned);
  addRegexToken("yyyy", matchUnsigned);
  addRegexToken("yo", matchEraYearOrdinal);
  addParseToken(["y", "yy", "yyy", "yyyy"], YEAR);
  addParseToken(["yo"], function(input, array2, config2, token2) {
    var match5;
    if (config2._locale._eraYearOrdinalRegex) {
      match5 = input.match(config2._locale._eraYearOrdinalRegex);
    }
    if (config2._locale.eraYearOrdinalParse) {
      array2[YEAR] = config2._locale.eraYearOrdinalParse(input, match5);
    } else {
      array2[YEAR] = parseInt(input, 10);
    }
  });
  function localeEras(m, format2) {
    var i2, l, date2, eras = this._eras || getLocale("en")._eras;
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      switch (typeof eras[i2].since) {
        case "string":
          date2 = hooks(eras[i2].since).startOf("day");
          eras[i2].since = date2.valueOf();
          break;
      }
      switch (typeof eras[i2].until) {
        case "undefined":
          eras[i2].until = Infinity;
          break;
        case "string":
          date2 = hooks(eras[i2].until).startOf("day").valueOf();
          eras[i2].until = date2.valueOf();
          break;
      }
    }
    return eras;
  }
  function localeErasParse(eraName, format2, strict) {
    var i2, l, eras = this.eras(), name2, abbr, narrow;
    eraName = eraName.toUpperCase();
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      name2 = eras[i2].name.toUpperCase();
      abbr = eras[i2].abbr.toUpperCase();
      narrow = eras[i2].narrow.toUpperCase();
      if (strict) {
        switch (format2) {
          case "N":
          case "NN":
          case "NNN":
            if (abbr === eraName) {
              return eras[i2];
            }
            break;
          case "NNNN":
            if (name2 === eraName) {
              return eras[i2];
            }
            break;
          case "NNNNN":
            if (narrow === eraName) {
              return eras[i2];
            }
            break;
        }
      } else if ([name2, abbr, narrow].indexOf(eraName) >= 0) {
        return eras[i2];
      }
    }
  }
  function localeErasConvertYear(era, year2) {
    var dir = era.since <= era.until ? 1 : -1;
    if (year2 === void 0) {
      return hooks(era.since).year();
    } else {
      return hooks(era.since).year() + (year2 - era.offset) * dir;
    }
  }
  function getEraName() {
    var i2, l, val, eras = this.localeData().eras();
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      val = this.clone().startOf("day").valueOf();
      if (eras[i2].since <= val && val <= eras[i2].until) {
        return eras[i2].name;
      }
      if (eras[i2].until <= val && val <= eras[i2].since) {
        return eras[i2].name;
      }
    }
    return "";
  }
  function getEraNarrow() {
    var i2, l, val, eras = this.localeData().eras();
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      val = this.clone().startOf("day").valueOf();
      if (eras[i2].since <= val && val <= eras[i2].until) {
        return eras[i2].narrow;
      }
      if (eras[i2].until <= val && val <= eras[i2].since) {
        return eras[i2].narrow;
      }
    }
    return "";
  }
  function getEraAbbr() {
    var i2, l, val, eras = this.localeData().eras();
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      val = this.clone().startOf("day").valueOf();
      if (eras[i2].since <= val && val <= eras[i2].until) {
        return eras[i2].abbr;
      }
      if (eras[i2].until <= val && val <= eras[i2].since) {
        return eras[i2].abbr;
      }
    }
    return "";
  }
  function getEraYear() {
    var i2, l, dir, val, eras = this.localeData().eras();
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      dir = eras[i2].since <= eras[i2].until ? 1 : -1;
      val = this.clone().startOf("day").valueOf();
      if (eras[i2].since <= val && val <= eras[i2].until || eras[i2].until <= val && val <= eras[i2].since) {
        return (this.year() - hooks(eras[i2].since).year()) * dir + eras[i2].offset;
      }
    }
    return this.year();
  }
  function erasNameRegex(isStrict) {
    if (!hasOwnProp(this, "_erasNameRegex")) {
      computeErasParse.call(this);
    }
    return isStrict ? this._erasNameRegex : this._erasRegex;
  }
  function erasAbbrRegex(isStrict) {
    if (!hasOwnProp(this, "_erasAbbrRegex")) {
      computeErasParse.call(this);
    }
    return isStrict ? this._erasAbbrRegex : this._erasRegex;
  }
  function erasNarrowRegex(isStrict) {
    if (!hasOwnProp(this, "_erasNarrowRegex")) {
      computeErasParse.call(this);
    }
    return isStrict ? this._erasNarrowRegex : this._erasRegex;
  }
  function matchEraAbbr(isStrict, locale2) {
    return locale2.erasAbbrRegex(isStrict);
  }
  function matchEraName(isStrict, locale2) {
    return locale2.erasNameRegex(isStrict);
  }
  function matchEraNarrow(isStrict, locale2) {
    return locale2.erasNarrowRegex(isStrict);
  }
  function matchEraYearOrdinal(isStrict, locale2) {
    return locale2._eraYearOrdinalRegex || matchUnsigned;
  }
  function computeErasParse() {
    var abbrPieces = [], namePieces = [], narrowPieces = [], mixedPieces = [], i2, l, eras = this.eras();
    for (i2 = 0, l = eras.length; i2 < l; ++i2) {
      namePieces.push(regexEscape(eras[i2].name));
      abbrPieces.push(regexEscape(eras[i2].abbr));
      narrowPieces.push(regexEscape(eras[i2].narrow));
      mixedPieces.push(regexEscape(eras[i2].name));
      mixedPieces.push(regexEscape(eras[i2].abbr));
      mixedPieces.push(regexEscape(eras[i2].narrow));
    }
    this._erasRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
    this._erasNameRegex = new RegExp("^(" + namePieces.join("|") + ")", "i");
    this._erasAbbrRegex = new RegExp("^(" + abbrPieces.join("|") + ")", "i");
    this._erasNarrowRegex = new RegExp(
      "^(" + narrowPieces.join("|") + ")",
      "i"
    );
  }
  addFormatToken(0, ["gg", 2], 0, function() {
    return this.weekYear() % 100;
  });
  addFormatToken(0, ["GG", 2], 0, function() {
    return this.isoWeekYear() % 100;
  });
  function addWeekYearFormatToken(token2, getter) {
    addFormatToken(0, [token2, token2.length], 0, getter);
  }
  addWeekYearFormatToken("gggg", "weekYear");
  addWeekYearFormatToken("ggggg", "weekYear");
  addWeekYearFormatToken("GGGG", "isoWeekYear");
  addWeekYearFormatToken("GGGGG", "isoWeekYear");
  addUnitAlias("weekYear", "gg");
  addUnitAlias("isoWeekYear", "GG");
  addUnitPriority("weekYear", 1);
  addUnitPriority("isoWeekYear", 1);
  addRegexToken("G", matchSigned);
  addRegexToken("g", matchSigned);
  addRegexToken("GG", match1to2, match2);
  addRegexToken("gg", match1to2, match2);
  addRegexToken("GGGG", match1to4, match4);
  addRegexToken("gggg", match1to4, match4);
  addRegexToken("GGGGG", match1to6, match6);
  addRegexToken("ggggg", match1to6, match6);
  addWeekParseToken(
    ["gggg", "ggggg", "GGGG", "GGGGG"],
    function(input, week, config2, token2) {
      week[token2.substr(0, 2)] = toInt(input);
    }
  );
  addWeekParseToken(["gg", "GG"], function(input, week, config2, token2) {
    week[token2] = hooks.parseTwoDigitYear(input);
  });
  function getSetWeekYear(input) {
    return getSetWeekYearHelper.call(
      this,
      input,
      this.week(),
      this.weekday(),
      this.localeData()._week.dow,
      this.localeData()._week.doy
    );
  }
  function getSetISOWeekYear(input) {
    return getSetWeekYearHelper.call(
      this,
      input,
      this.isoWeek(),
      this.isoWeekday(),
      1,
      4
    );
  }
  function getISOWeeksInYear() {
    return weeksInYear(this.year(), 1, 4);
  }
  function getISOWeeksInISOWeekYear() {
    return weeksInYear(this.isoWeekYear(), 1, 4);
  }
  function getWeeksInYear() {
    var weekInfo = this.localeData()._week;
    return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
  }
  function getWeeksInWeekYear() {
    var weekInfo = this.localeData()._week;
    return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
  }
  function getSetWeekYearHelper(input, week, weekday2, dow, doy) {
    var weeksTarget;
    if (input == null) {
      return weekOfYear(this, dow, doy).year;
    } else {
      weeksTarget = weeksInYear(input, dow, doy);
      if (week > weeksTarget) {
        week = weeksTarget;
      }
      return setWeekAll.call(this, input, week, weekday2, dow, doy);
    }
  }
  function setWeekAll(weekYear, week, weekday2, dow, doy) {
    var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday2, dow, doy), date2 = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
    this.year(date2.getUTCFullYear());
    this.month(date2.getUTCMonth());
    this.date(date2.getUTCDate());
    return this;
  }
  addFormatToken("Q", 0, "Qo", "quarter");
  addUnitAlias("quarter", "Q");
  addUnitPriority("quarter", 7);
  addRegexToken("Q", match1);
  addParseToken("Q", function(input, array2) {
    array2[MONTH] = (toInt(input) - 1) * 3;
  });
  function getSetQuarter(input) {
    return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
  }
  addFormatToken("D", ["DD", 2], "Do", "date");
  addUnitAlias("date", "D");
  addUnitPriority("date", 9);
  addRegexToken("D", match1to2);
  addRegexToken("DD", match1to2, match2);
  addRegexToken("Do", function(isStrict, locale2) {
    return isStrict ? locale2._dayOfMonthOrdinalParse || locale2._ordinalParse : locale2._dayOfMonthOrdinalParseLenient;
  });
  addParseToken(["D", "DD"], DATE);
  addParseToken("Do", function(input, array2) {
    array2[DATE] = toInt(input.match(match1to2)[0]);
  });
  var getSetDayOfMonth = makeGetSet("Date", true);
  addFormatToken("DDD", ["DDDD", 3], "DDDo", "dayOfYear");
  addUnitAlias("dayOfYear", "DDD");
  addUnitPriority("dayOfYear", 4);
  addRegexToken("DDD", match1to3);
  addRegexToken("DDDD", match3);
  addParseToken(["DDD", "DDDD"], function(input, array2, config2) {
    config2._dayOfYear = toInt(input);
  });
  function getSetDayOfYear(input) {
    var dayOfYear = Math.round(
      (this.clone().startOf("day") - this.clone().startOf("year")) / 864e5
    ) + 1;
    return input == null ? dayOfYear : this.add(input - dayOfYear, "d");
  }
  addFormatToken("m", ["mm", 2], 0, "minute");
  addUnitAlias("minute", "m");
  addUnitPriority("minute", 14);
  addRegexToken("m", match1to2);
  addRegexToken("mm", match1to2, match2);
  addParseToken(["m", "mm"], MINUTE);
  var getSetMinute = makeGetSet("Minutes", false);
  addFormatToken("s", ["ss", 2], 0, "second");
  addUnitAlias("second", "s");
  addUnitPriority("second", 15);
  addRegexToken("s", match1to2);
  addRegexToken("ss", match1to2, match2);
  addParseToken(["s", "ss"], SECOND);
  var getSetSecond = makeGetSet("Seconds", false);
  addFormatToken("S", 0, 0, function() {
    return ~~(this.millisecond() / 100);
  });
  addFormatToken(0, ["SS", 2], 0, function() {
    return ~~(this.millisecond() / 10);
  });
  addFormatToken(0, ["SSS", 3], 0, "millisecond");
  addFormatToken(0, ["SSSS", 4], 0, function() {
    return this.millisecond() * 10;
  });
  addFormatToken(0, ["SSSSS", 5], 0, function() {
    return this.millisecond() * 100;
  });
  addFormatToken(0, ["SSSSSS", 6], 0, function() {
    return this.millisecond() * 1e3;
  });
  addFormatToken(0, ["SSSSSSS", 7], 0, function() {
    return this.millisecond() * 1e4;
  });
  addFormatToken(0, ["SSSSSSSS", 8], 0, function() {
    return this.millisecond() * 1e5;
  });
  addFormatToken(0, ["SSSSSSSSS", 9], 0, function() {
    return this.millisecond() * 1e6;
  });
  addUnitAlias("millisecond", "ms");
  addUnitPriority("millisecond", 16);
  addRegexToken("S", match1to3, match1);
  addRegexToken("SS", match1to3, match2);
  addRegexToken("SSS", match1to3, match3);
  var token$1, getSetMillisecond;
  for (token$1 = "SSSS"; token$1.length <= 9; token$1 += "S") {
    addRegexToken(token$1, matchUnsigned);
  }
  function parseMs(input, array2) {
    array2[MILLISECOND] = toInt(("0." + input) * 1e3);
  }
  for (token$1 = "S"; token$1.length <= 9; token$1 += "S") {
    addParseToken(token$1, parseMs);
  }
  getSetMillisecond = makeGetSet("Milliseconds", false);
  addFormatToken("z", 0, 0, "zoneAbbr");
  addFormatToken("zz", 0, 0, "zoneName");
  function getZoneAbbr() {
    return this._isUTC ? "UTC" : "";
  }
  function getZoneName() {
    return this._isUTC ? "Coordinated Universal Time" : "";
  }
  var proto = Moment.prototype;
  proto.add = add;
  proto.calendar = calendar$1$1;
  proto.clone = clone$4;
  proto.diff = diff;
  proto.endOf = endOf;
  proto.format = format$2;
  proto.from = from$1;
  proto.fromNow = fromNow;
  proto.to = to;
  proto.toNow = toNow;
  proto.get = stringGet;
  proto.invalidAt = invalidAt;
  proto.isAfter = isAfter;
  proto.isBefore = isBefore;
  proto.isBetween = isBetween;
  proto.isSame = isSame;
  proto.isSameOrAfter = isSameOrAfter;
  proto.isSameOrBefore = isSameOrBefore;
  proto.isValid = isValid$2;
  proto.lang = lang$1;
  proto.locale = locale$2;
  proto.localeData = localeData;
  proto.max = prototypeMax;
  proto.min = prototypeMin;
  proto.parsingFlags = parsingFlags;
  proto.set = stringSet;
  proto.startOf = startOf;
  proto.subtract = subtract;
  proto.toArray = toArray$1;
  proto.toObject = toObject;
  proto.toDate = toDate;
  proto.toISOString = toISOString;
  proto.inspect = inspect;
  if (typeof Symbol !== "undefined" && Symbol.for != null) {
    proto[Symbol.for("nodejs.util.inspect.custom")] = function() {
      return "Moment<" + this.format() + ">";
    };
  }
  proto.toJSON = toJSON;
  proto.toString = toString$5;
  proto.unix = unix;
  proto.valueOf = valueOf;
  proto.creationData = creationData;
  proto.eraName = getEraName;
  proto.eraNarrow = getEraNarrow;
  proto.eraAbbr = getEraAbbr;
  proto.eraYear = getEraYear;
  proto.year = getSetYear;
  proto.isLeapYear = getIsLeapYear;
  proto.weekYear = getSetWeekYear;
  proto.isoWeekYear = getSetISOWeekYear;
  proto.quarter = proto.quarters = getSetQuarter;
  proto.month = getSetMonth;
  proto.daysInMonth = getDaysInMonth;
  proto.week = proto.weeks = getSetWeek;
  proto.isoWeek = proto.isoWeeks = getSetISOWeek;
  proto.weeksInYear = getWeeksInYear;
  proto.weeksInWeekYear = getWeeksInWeekYear;
  proto.isoWeeksInYear = getISOWeeksInYear;
  proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
  proto.date = getSetDayOfMonth;
  proto.day = proto.days = getSetDayOfWeek;
  proto.weekday = getSetLocaleDayOfWeek;
  proto.isoWeekday = getSetISODayOfWeek;
  proto.dayOfYear = getSetDayOfYear;
  proto.hour = proto.hours = getSetHour;
  proto.minute = proto.minutes = getSetMinute;
  proto.second = proto.seconds = getSetSecond;
  proto.millisecond = proto.milliseconds = getSetMillisecond;
  proto.utcOffset = getSetOffset;
  proto.utc = setOffsetToUTC;
  proto.local = setOffsetToLocal;
  proto.parseZone = setOffsetToParsedOffset;
  proto.hasAlignedHourOffset = hasAlignedHourOffset;
  proto.isDST = isDaylightSavingTime;
  proto.isLocal = isLocal;
  proto.isUtcOffset = isUtcOffset;
  proto.isUtc = isUtc;
  proto.isUTC = isUtc;
  proto.zoneAbbr = getZoneAbbr;
  proto.zoneName = getZoneName;
  proto.dates = deprecate(
    "dates accessor is deprecated. Use date instead.",
    getSetDayOfMonth
  );
  proto.months = deprecate(
    "months accessor is deprecated. Use month instead",
    getSetMonth
  );
  proto.years = deprecate(
    "years accessor is deprecated. Use year instead",
    getSetYear
  );
  proto.zone = deprecate(
    "moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",
    getSetZone
  );
  proto.isDSTShifted = deprecate(
    "isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",
    isDaylightSavingTimeShifted
  );
  function createUnix(input) {
    return createLocal(input * 1e3);
  }
  function createInZone() {
    return createLocal.apply(null, arguments).parseZone();
  }
  function preParsePostFormat(string2) {
    return string2;
  }
  var proto$1 = Locale.prototype;
  proto$1.calendar = calendar$1;
  proto$1.longDateFormat = longDateFormat;
  proto$1.invalidDate = invalidDate;
  proto$1.ordinal = ordinal$1;
  proto$1.preparse = preParsePostFormat;
  proto$1.postformat = preParsePostFormat;
  proto$1.relativeTime = relativeTime;
  proto$1.pastFuture = pastFuture;
  proto$1.set = set$6;
  proto$1.eras = localeEras;
  proto$1.erasParse = localeErasParse;
  proto$1.erasConvertYear = localeErasConvertYear;
  proto$1.erasAbbrRegex = erasAbbrRegex;
  proto$1.erasNameRegex = erasNameRegex;
  proto$1.erasNarrowRegex = erasNarrowRegex;
  proto$1.months = localeMonths;
  proto$1.monthsShort = localeMonthsShort;
  proto$1.monthsParse = localeMonthsParse;
  proto$1.monthsRegex = monthsRegex;
  proto$1.monthsShortRegex = monthsShortRegex;
  proto$1.week = localeWeek;
  proto$1.firstDayOfYear = localeFirstDayOfYear;
  proto$1.firstDayOfWeek = localeFirstDayOfWeek;
  proto$1.weekdays = localeWeekdays;
  proto$1.weekdaysMin = localeWeekdaysMin;
  proto$1.weekdaysShort = localeWeekdaysShort;
  proto$1.weekdaysParse = localeWeekdaysParse;
  proto$1.weekdaysRegex = weekdaysRegex;
  proto$1.weekdaysShortRegex = weekdaysShortRegex;
  proto$1.weekdaysMinRegex = weekdaysMinRegex;
  proto$1.isPM = localeIsPM;
  proto$1.meridiem = localeMeridiem;
  function get$1$1(format2, index, field, setter) {
    var locale2 = getLocale(), utc = createUTC().set(setter, index);
    return locale2[field](utc, format2);
  }
  function listMonthsImpl(format2, index, field) {
    if (isNumber(format2)) {
      index = format2;
      format2 = void 0;
    }
    format2 = format2 || "";
    if (index != null) {
      return get$1$1(format2, index, field, "month");
    }
    var i2, out = [];
    for (i2 = 0; i2 < 12; i2++) {
      out[i2] = get$1$1(format2, i2, field, "month");
    }
    return out;
  }
  function listWeekdaysImpl(localeSorted, format2, index, field) {
    if (typeof localeSorted === "boolean") {
      if (isNumber(format2)) {
        index = format2;
        format2 = void 0;
      }
      format2 = format2 || "";
    } else {
      format2 = localeSorted;
      index = format2;
      localeSorted = false;
      if (isNumber(format2)) {
        index = format2;
        format2 = void 0;
      }
      format2 = format2 || "";
    }
    var locale2 = getLocale(), shift = localeSorted ? locale2._week.dow : 0, i2, out = [];
    if (index != null) {
      return get$1$1(format2, (index + shift) % 7, field, "day");
    }
    for (i2 = 0; i2 < 7; i2++) {
      out[i2] = get$1$1(format2, (i2 + shift) % 7, field, "day");
    }
    return out;
  }
  function listMonths(format2, index) {
    return listMonthsImpl(format2, index, "months");
  }
  function listMonthsShort(format2, index) {
    return listMonthsImpl(format2, index, "monthsShort");
  }
  function listWeekdays(localeSorted, format2, index) {
    return listWeekdaysImpl(localeSorted, format2, index, "weekdays");
  }
  function listWeekdaysShort(localeSorted, format2, index) {
    return listWeekdaysImpl(localeSorted, format2, index, "weekdaysShort");
  }
  function listWeekdaysMin(localeSorted, format2, index) {
    return listWeekdaysImpl(localeSorted, format2, index, "weekdaysMin");
  }
  getSetGlobalLocale("en", {
    eras: [
      {
        since: "0001-01-01",
        until: Infinity,
        offset: 1,
        name: "Anno Domini",
        narrow: "AD",
        abbr: "AD"
      },
      {
        since: "0000-12-31",
        until: -Infinity,
        offset: 1,
        name: "Before Christ",
        narrow: "BC",
        abbr: "BC"
      }
    ],
    dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
    ordinal: function(number2) {
      var b = number2 % 10, output2 = toInt(number2 % 100 / 10) === 1 ? "th" : b === 1 ? "st" : b === 2 ? "nd" : b === 3 ? "rd" : "th";
      return number2 + output2;
    }
  });
  hooks.lang = deprecate(
    "moment.lang is deprecated. Use moment.locale instead.",
    getSetGlobalLocale
  );
  hooks.langData = deprecate(
    "moment.langData is deprecated. Use moment.localeData instead.",
    getLocale
  );
  var mathAbs = Math.abs;
  function abs$2() {
    var data2 = this._data;
    this._milliseconds = mathAbs(this._milliseconds);
    this._days = mathAbs(this._days);
    this._months = mathAbs(this._months);
    data2.milliseconds = mathAbs(data2.milliseconds);
    data2.seconds = mathAbs(data2.seconds);
    data2.minutes = mathAbs(data2.minutes);
    data2.hours = mathAbs(data2.hours);
    data2.months = mathAbs(data2.months);
    data2.years = mathAbs(data2.years);
    return this;
  }
  function addSubtract$1(duration, input, value, direction2) {
    var other = createDuration(input, value);
    duration._milliseconds += direction2 * other._milliseconds;
    duration._days += direction2 * other._days;
    duration._months += direction2 * other._months;
    return duration._bubble();
  }
  function add$1(input, value) {
    return addSubtract$1(this, input, value, 1);
  }
  function subtract$1(input, value) {
    return addSubtract$1(this, input, value, -1);
  }
  function absCeil(number2) {
    if (number2 < 0) {
      return Math.floor(number2);
    } else {
      return Math.ceil(number2);
    }
  }
  function bubble() {
    var milliseconds2 = this._milliseconds, days2 = this._days, months2 = this._months, data2 = this._data, seconds2, minutes2, hours2, years2, monthsFromDays;
    if (!(milliseconds2 >= 0 && days2 >= 0 && months2 >= 0 || milliseconds2 <= 0 && days2 <= 0 && months2 <= 0)) {
      milliseconds2 += absCeil(monthsToDays(months2) + days2) * 864e5;
      days2 = 0;
      months2 = 0;
    }
    data2.milliseconds = milliseconds2 % 1e3;
    seconds2 = absFloor(milliseconds2 / 1e3);
    data2.seconds = seconds2 % 60;
    minutes2 = absFloor(seconds2 / 60);
    data2.minutes = minutes2 % 60;
    hours2 = absFloor(minutes2 / 60);
    data2.hours = hours2 % 24;
    days2 += absFloor(hours2 / 24);
    monthsFromDays = absFloor(daysToMonths(days2));
    months2 += monthsFromDays;
    days2 -= absCeil(monthsToDays(monthsFromDays));
    years2 = absFloor(months2 / 12);
    months2 %= 12;
    data2.days = days2;
    data2.months = months2;
    data2.years = years2;
    return this;
  }
  function daysToMonths(days2) {
    return days2 * 4800 / 146097;
  }
  function monthsToDays(months2) {
    return months2 * 146097 / 4800;
  }
  function as(units) {
    if (!this.isValid()) {
      return NaN;
    }
    var days2, months2, milliseconds2 = this._milliseconds;
    units = normalizeUnits(units);
    if (units === "month" || units === "quarter" || units === "year") {
      days2 = this._days + milliseconds2 / 864e5;
      months2 = this._months + daysToMonths(days2);
      switch (units) {
        case "month":
          return months2;
        case "quarter":
          return months2 / 3;
        case "year":
          return months2 / 12;
      }
    } else {
      days2 = this._days + Math.round(monthsToDays(this._months));
      switch (units) {
        case "week":
          return days2 / 7 + milliseconds2 / 6048e5;
        case "day":
          return days2 + milliseconds2 / 864e5;
        case "hour":
          return days2 * 24 + milliseconds2 / 36e5;
        case "minute":
          return days2 * 1440 + milliseconds2 / 6e4;
        case "second":
          return days2 * 86400 + milliseconds2 / 1e3;
        case "millisecond":
          return Math.floor(days2 * 864e5) + milliseconds2;
        default:
          throw new Error("Unknown unit " + units);
      }
    }
  }
  function valueOf$1() {
    if (!this.isValid()) {
      return NaN;
    }
    return this._milliseconds + this._days * 864e5 + this._months % 12 * 2592e6 + toInt(this._months / 12) * 31536e6;
  }
  function makeAs(alias) {
    return function() {
      return this.as(alias);
    };
  }
  var asMilliseconds = makeAs("ms"), asSeconds = makeAs("s"), asMinutes = makeAs("m"), asHours = makeAs("h"), asDays = makeAs("d"), asWeeks = makeAs("w"), asMonths = makeAs("M"), asQuarters = makeAs("Q"), asYears = makeAs("y");
  function clone$1$1() {
    return createDuration(this);
  }
  function get$2$1(units) {
    units = normalizeUnits(units);
    return this.isValid() ? this[units + "s"]() : NaN;
  }
  function makeGetter(name2) {
    return function() {
      return this.isValid() ? this._data[name2] : NaN;
    };
  }
  var milliseconds = makeGetter("milliseconds"), seconds = makeGetter("seconds"), minutes = makeGetter("minutes"), hours = makeGetter("hours"), days = makeGetter("days"), months = makeGetter("months"), years = makeGetter("years");
  function weeks() {
    return absFloor(this.days() / 7);
  }
  var round = Math.round, thresholds = {
    ss: 44,
    s: 45,
    m: 45,
    h: 22,
    d: 26,
    w: null,
    M: 11
  };
  function substituteTimeAgo(string2, number2, withoutSuffix, isFuture, locale2) {
    return locale2.relativeTime(number2 || 1, !!withoutSuffix, string2, isFuture);
  }
  function relativeTime$1(posNegDuration, withoutSuffix, thresholds2, locale2) {
    var duration = createDuration(posNegDuration).abs(), seconds2 = round(duration.as("s")), minutes2 = round(duration.as("m")), hours2 = round(duration.as("h")), days2 = round(duration.as("d")), months2 = round(duration.as("M")), weeks2 = round(duration.as("w")), years2 = round(duration.as("y")), a = seconds2 <= thresholds2.ss && ["s", seconds2] || seconds2 < thresholds2.s && ["ss", seconds2] || minutes2 <= 1 && ["m"] || minutes2 < thresholds2.m && ["mm", minutes2] || hours2 <= 1 && ["h"] || hours2 < thresholds2.h && ["hh", hours2] || days2 <= 1 && ["d"] || days2 < thresholds2.d && ["dd", days2];
    if (thresholds2.w != null) {
      a = a || weeks2 <= 1 && ["w"] || weeks2 < thresholds2.w && ["ww", weeks2];
    }
    a = a || months2 <= 1 && ["M"] || months2 < thresholds2.M && ["MM", months2] || years2 <= 1 && ["y"] || ["yy", years2];
    a[2] = withoutSuffix;
    a[3] = +posNegDuration > 0;
    a[4] = locale2;
    return substituteTimeAgo.apply(null, a);
  }
  function getSetRelativeTimeRounding(roundingFunction) {
    if (roundingFunction === void 0) {
      return round;
    }
    if (typeof roundingFunction === "function") {
      round = roundingFunction;
      return true;
    }
    return false;
  }
  function getSetRelativeTimeThreshold(threshold, limit) {
    if (thresholds[threshold] === void 0) {
      return false;
    }
    if (limit === void 0) {
      return thresholds[threshold];
    }
    thresholds[threshold] = limit;
    if (threshold === "s") {
      thresholds.ss = limit - 1;
    }
    return true;
  }
  function humanize(argWithSuffix, argThresholds) {
    if (!this.isValid()) {
      return this.localeData().invalidDate();
    }
    var withSuffix = false, th = thresholds, locale2, output2;
    if (typeof argWithSuffix === "object") {
      argThresholds = argWithSuffix;
      argWithSuffix = false;
    }
    if (typeof argWithSuffix === "boolean") {
      withSuffix = argWithSuffix;
    }
    if (typeof argThresholds === "object") {
      th = Object.assign({}, thresholds, argThresholds);
      if (argThresholds.s != null && argThresholds.ss == null) {
        th.ss = argThresholds.s - 1;
      }
    }
    locale2 = this.localeData();
    output2 = relativeTime$1(this, !withSuffix, th, locale2);
    if (withSuffix) {
      output2 = locale2.pastFuture(+this, output2);
    }
    return locale2.postformat(output2);
  }
  var abs$1$1 = Math.abs;
  function sign$1(x2) {
    return (x2 > 0) - (x2 < 0) || +x2;
  }
  function toISOString$1() {
    if (!this.isValid()) {
      return this.localeData().invalidDate();
    }
    var seconds2 = abs$1$1(this._milliseconds) / 1e3, days2 = abs$1$1(this._days), months2 = abs$1$1(this._months), minutes2, hours2, years2, s, total = this.asSeconds(), totalSign, ymSign, daysSign, hmsSign;
    if (!total) {
      return "P0D";
    }
    minutes2 = absFloor(seconds2 / 60);
    hours2 = absFloor(minutes2 / 60);
    seconds2 %= 60;
    minutes2 %= 60;
    years2 = absFloor(months2 / 12);
    months2 %= 12;
    s = seconds2 ? seconds2.toFixed(3).replace(/\.?0+$/, "") : "";
    totalSign = total < 0 ? "-" : "";
    ymSign = sign$1(this._months) !== sign$1(total) ? "-" : "";
    daysSign = sign$1(this._days) !== sign$1(total) ? "-" : "";
    hmsSign = sign$1(this._milliseconds) !== sign$1(total) ? "-" : "";
    return totalSign + "P" + (years2 ? ymSign + years2 + "Y" : "") + (months2 ? ymSign + months2 + "M" : "") + (days2 ? daysSign + days2 + "D" : "") + (hours2 || minutes2 || seconds2 ? "T" : "") + (hours2 ? hmsSign + hours2 + "H" : "") + (minutes2 ? hmsSign + minutes2 + "M" : "") + (seconds2 ? hmsSign + s + "S" : "");
  }
  var proto$2 = Duration.prototype;
  proto$2.isValid = isValid$1;
  proto$2.abs = abs$2;
  proto$2.add = add$1;
  proto$2.subtract = subtract$1;
  proto$2.as = as;
  proto$2.asMilliseconds = asMilliseconds;
  proto$2.asSeconds = asSeconds;
  proto$2.asMinutes = asMinutes;
  proto$2.asHours = asHours;
  proto$2.asDays = asDays;
  proto$2.asWeeks = asWeeks;
  proto$2.asMonths = asMonths;
  proto$2.asQuarters = asQuarters;
  proto$2.asYears = asYears;
  proto$2.valueOf = valueOf$1;
  proto$2._bubble = bubble;
  proto$2.clone = clone$1$1;
  proto$2.get = get$2$1;
  proto$2.milliseconds = milliseconds;
  proto$2.seconds = seconds;
  proto$2.minutes = minutes;
  proto$2.hours = hours;
  proto$2.days = days;
  proto$2.weeks = weeks;
  proto$2.months = months;
  proto$2.years = years;
  proto$2.humanize = humanize;
  proto$2.toISOString = toISOString$1;
  proto$2.toString = toISOString$1;
  proto$2.toJSON = toISOString$1;
  proto$2.locale = locale$2;
  proto$2.localeData = localeData;
  proto$2.toIsoString = deprecate(
    "toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",
    toISOString$1
  );
  proto$2.lang = lang$1;
  addFormatToken("X", 0, 0, "unix");
  addFormatToken("x", 0, 0, "valueOf");
  addRegexToken("x", matchSigned);
  addRegexToken("X", matchTimestamp);
  addParseToken("X", function(input, array2, config2) {
    config2._d = new Date(parseFloat(input) * 1e3);
  });
  addParseToken("x", function(input, array2, config2) {
    config2._d = new Date(toInt(input));
  });
  //! moment.js
  hooks.version = "2.29.4";
  setHookCallback(createLocal);
  hooks.fn = proto;
  hooks.min = min$4;
  hooks.max = max$4;
  hooks.now = now$5;
  hooks.utc = createUTC;
  hooks.unix = createUnix;
  hooks.months = listMonths;
  hooks.isDate = isDate;
  hooks.locale = getSetGlobalLocale;
  hooks.invalid = createInvalid;
  hooks.duration = createDuration;
  hooks.isMoment = isMoment;
  hooks.weekdays = listWeekdays;
  hooks.parseZone = createInZone;
  hooks.localeData = getLocale;
  hooks.isDuration = isDuration;
  hooks.monthsShort = listMonthsShort;
  hooks.weekdaysMin = listWeekdaysMin;
  hooks.defineLocale = defineLocale;
  hooks.updateLocale = updateLocale;
  hooks.locales = listLocales;
  hooks.weekdaysShort = listWeekdaysShort;
  hooks.normalizeUnits = normalizeUnits;
  hooks.relativeTimeRounding = getSetRelativeTimeRounding;
  hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
  hooks.calendarFormat = getCalendarFormat;
  hooks.prototype = proto;
  hooks.HTML5_FMT = {
    DATETIME_LOCAL: "YYYY-MM-DDTHH:mm",
    DATETIME_LOCAL_SECONDS: "YYYY-MM-DDTHH:mm:ss",
    DATETIME_LOCAL_MS: "YYYY-MM-DDTHH:mm:ss.SSS",
    DATE: "YYYY-MM-DD",
    TIME: "HH:mm",
    TIME_SECONDS: "HH:mm:ss",
    TIME_MS: "HH:mm:ss.SSS",
    WEEK: "GGGG-[W]WW",
    MONTH: "YYYY-MM"
  };
  const LEVELS = {
    trace: 0,
    debug: 1,
    info: 2,
    warn: 3,
    error: 4,
    fatal: 5
  };
  const log$1 = {
    trace: (..._args) => {
    },
    debug: (..._args) => {
    },
    info: (..._args) => {
    },
    warn: (..._args) => {
    },
    error: (..._args) => {
    },
    fatal: (..._args) => {
    }
  };
  const setLogLevel$1 = function(level = "fatal") {
    let numericLevel = LEVELS.fatal;
    if (typeof level === "string") {
      level = level.toLowerCase();
      if (level in LEVELS) {
        numericLevel = LEVELS[level];
      }
    } else if (typeof level === "number") {
      numericLevel = level;
    }
    log$1.trace = () => {
    };
    log$1.debug = () => {
    };
    log$1.info = () => {
    };
    log$1.warn = () => {
    };
    log$1.error = () => {
    };
    log$1.fatal = () => {
    };
    if (numericLevel <= LEVELS.fatal) {
      log$1.fatal = console.error ? console.error.bind(console, format$1("FATAL"), "color: orange") : console.log.bind(console, "\x1B[35m", format$1("FATAL"));
    }
    if (numericLevel <= LEVELS.error) {
      log$1.error = console.error ? console.error.bind(console, format$1("ERROR"), "color: orange") : console.log.bind(console, "\x1B[31m", format$1("ERROR"));
    }
    if (numericLevel <= LEVELS.warn) {
      log$1.warn = console.warn ? console.warn.bind(console, format$1("WARN"), "color: orange") : console.log.bind(console, `\x1B[33m`, format$1("WARN"));
    }
    if (numericLevel <= LEVELS.info) {
      log$1.info = console.info ? console.info.bind(console, format$1("INFO"), "color: lightblue") : console.log.bind(console, "\x1B[34m", format$1("INFO"));
    }
    if (numericLevel <= LEVELS.debug) {
      log$1.debug = console.debug ? console.debug.bind(console, format$1("DEBUG"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("DEBUG"));
    }
    if (numericLevel <= LEVELS.trace) {
      log$1.trace = console.debug ? console.debug.bind(console, format$1("TRACE"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("TRACE"));
    }
  };
  const format$1 = (level) => {
    const time2 = hooks().format("ss.SSS");
    return `%c${time2} : ${level} : `;
  };
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  var dist$1 = {};
  Object.defineProperty(dist$1, "__esModule", { value: true });
  var sanitizeUrl_1 = dist$1.sanitizeUrl = void 0;
  var invalidProtocolRegex = /^([^\w]*)(javascript|data|vbscript)/im;
  var htmlEntitiesRegex = /&#(\w+)(^\w|;)?/g;
  var ctrlCharactersRegex = /[\u0000-\u001F\u007F-\u009F\u2000-\u200D\uFEFF]/gim;
  var urlSchemeRegex = /^([^:]+):/gm;
  var relativeFirstCharacters = [".", "/"];
  function isRelativeUrlWithoutProtocol(url) {
    return relativeFirstCharacters.indexOf(url[0]) > -1;
  }
  function decodeHtmlCharacters(str2) {
    return str2.replace(htmlEntitiesRegex, function(match5, dec) {
      return String.fromCharCode(dec);
    });
  }
  function sanitizeUrl(url) {
    var sanitizedUrl = decodeHtmlCharacters(url || "").replace(ctrlCharactersRegex, "").trim();
    if (!sanitizedUrl) {
      return "about:blank";
    }
    if (isRelativeUrlWithoutProtocol(sanitizedUrl)) {
      return sanitizedUrl;
    }
    var urlSchemeParseResults = sanitizedUrl.match(urlSchemeRegex);
    if (!urlSchemeParseResults) {
      return sanitizedUrl;
    }
    var urlScheme = urlSchemeParseResults[0];
    if (invalidProtocolRegex.test(urlScheme)) {
      return "about:blank";
    }
    return sanitizedUrl;
  }
  sanitizeUrl_1 = dist$1.sanitizeUrl = sanitizeUrl;
  function ascending$2(a, b) {
    return a == null || b == null ? NaN : a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function descending$2(a, b) {
    return a == null || b == null ? NaN : b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function bisector(f2) {
    let compare1, compare2, delta;
    if (f2.length !== 2) {
      compare1 = ascending$2;
      compare2 = (d, x2) => ascending$2(f2(d), x2);
      delta = (d, x2) => f2(d) - x2;
    } else {
      compare1 = f2 === ascending$2 || f2 === descending$2 ? f2 : zero$1;
      compare2 = f2;
      delta = f2;
    }
    function left2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) < 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function right2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) <= 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function center2(a, x2, lo = 0, hi = a.length) {
      const i2 = left2(a, x2, lo, hi - 1);
      return i2 > lo && delta(a[i2 - 1], x2) > -delta(a[i2], x2) ? i2 - 1 : i2;
    }
    return { left: left2, center: center2, right: right2 };
  }
  function zero$1() {
    return 0;
  }
  function number$5(x2) {
    return x2 === null ? NaN : +x2;
  }
  const ascendingBisect = bisector(ascending$2);
  const bisectRight = ascendingBisect.right;
  bisector(number$5).center;
  const bisect = bisectRight;
  class InternMap extends Map {
    constructor(entries, key = keyof) {
      super();
      Object.defineProperties(this, { _intern: { value: /* @__PURE__ */ new Map() }, _key: { value: key } });
      if (entries != null)
        for (const [key2, value] of entries)
          this.set(key2, value);
    }
    get(key) {
      return super.get(intern_get(this, key));
    }
    has(key) {
      return super.has(intern_get(this, key));
    }
    set(key, value) {
      return super.set(intern_set(this, key), value);
    }
    delete(key) {
      return super.delete(intern_delete(this, key));
    }
  }
  function intern_get({ _intern, _key }, value) {
    const key = _key(value);
    return _intern.has(key) ? _intern.get(key) : value;
  }
  function intern_set({ _intern, _key }, value) {
    const key = _key(value);
    if (_intern.has(key))
      return _intern.get(key);
    _intern.set(key, value);
    return value;
  }
  function intern_delete({ _intern, _key }, value) {
    const key = _key(value);
    if (_intern.has(key)) {
      value = _intern.get(key);
      _intern.delete(key);
    }
    return value;
  }
  function keyof(value) {
    return value !== null && typeof value === "object" ? value.valueOf() : value;
  }
  var e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
  function ticks(start2, stop, count) {
    var reverse, i2 = -1, n, ticks2, step2;
    stop = +stop, start2 = +start2, count = +count;
    if (start2 === stop && count > 0)
      return [start2];
    if (reverse = stop < start2)
      n = start2, start2 = stop, stop = n;
    if ((step2 = tickIncrement(start2, stop, count)) === 0 || !isFinite(step2))
      return [];
    if (step2 > 0) {
      let r0 = Math.round(start2 / step2), r1 = Math.round(stop / step2);
      if (r0 * step2 < start2)
        ++r0;
      if (r1 * step2 > stop)
        --r1;
      ticks2 = new Array(n = r1 - r0 + 1);
      while (++i2 < n)
        ticks2[i2] = (r0 + i2) * step2;
    } else {
      step2 = -step2;
      let r0 = Math.round(start2 * step2), r1 = Math.round(stop * step2);
      if (r0 / step2 < start2)
        ++r0;
      if (r1 / step2 > stop)
        --r1;
      ticks2 = new Array(n = r1 - r0 + 1);
      while (++i2 < n)
        ticks2[i2] = (r0 + i2) / step2;
    }
    if (reverse)
      ticks2.reverse();
    return ticks2;
  }
  function tickIncrement(start2, stop, count) {
    var step2 = (stop - start2) / Math.max(0, count), power = Math.floor(Math.log(step2) / Math.LN10), error2 = step2 / Math.pow(10, power);
    return power >= 0 ? (error2 >= e10 ? 10 : error2 >= e5 ? 5 : error2 >= e2 ? 2 : 1) * Math.pow(10, power) : -Math.pow(10, -power) / (error2 >= e10 ? 10 : error2 >= e5 ? 5 : error2 >= e2 ? 2 : 1);
  }
  function tickStep(start2, stop, count) {
    var step0 = Math.abs(stop - start2) / Math.max(0, count), step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)), error2 = step0 / step1;
    if (error2 >= e10)
      step1 *= 10;
    else if (error2 >= e5)
      step1 *= 5;
    else if (error2 >= e2)
      step1 *= 2;
    return stop < start2 ? -step1 : step1;
  }
  function max$3(values2, valueof) {
    let max2;
    if (valueof === void 0) {
      for (const value of values2) {
        if (value != null && (max2 < value || max2 === void 0 && value >= value)) {
          max2 = value;
        }
      }
    } else {
      let index = -1;
      for (let value of values2) {
        if ((value = valueof(value, ++index, values2)) != null && (max2 < value || max2 === void 0 && value >= value)) {
          max2 = value;
        }
      }
    }
    return max2;
  }
  function min$3(values2, valueof) {
    let min2;
    if (valueof === void 0) {
      for (const value of values2) {
        if (value != null && (min2 > value || min2 === void 0 && value >= value)) {
          min2 = value;
        }
      }
    } else {
      let index = -1;
      for (let value of values2) {
        if ((value = valueof(value, ++index, values2)) != null && (min2 > value || min2 === void 0 && value >= value)) {
          min2 = value;
        }
      }
    }
    return min2;
  }
  function identity$6(x2) {
    return x2;
  }
  var top = 1, right = 2, bottom = 3, left = 4, epsilon$2 = 1e-6;
  function translateX(x2) {
    return "translate(" + x2 + ",0)";
  }
  function translateY(y2) {
    return "translate(0," + y2 + ")";
  }
  function number$4(scale) {
    return (d) => +scale(d);
  }
  function center(scale, offset2) {
    offset2 = Math.max(0, scale.bandwidth() - offset2 * 2) / 2;
    if (scale.round())
      offset2 = Math.round(offset2);
    return (d) => +scale(d) + offset2;
  }
  function entering() {
    return !this.__axis;
  }
  function axis(orient, scale) {
    var tickArguments = [], tickValues = null, tickFormat2 = null, tickSizeInner = 6, tickSizeOuter = 6, tickPadding = 3, offset2 = typeof window !== "undefined" && window.devicePixelRatio > 1 ? 0 : 0.5, k = orient === top || orient === left ? -1 : 1, x2 = orient === left || orient === right ? "x" : "y", transform = orient === top || orient === bottom ? translateX : translateY;
    function axis2(context) {
      var values2 = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments) : scale.domain() : tickValues, format2 = tickFormat2 == null ? scale.tickFormat ? scale.tickFormat.apply(scale, tickArguments) : identity$6 : tickFormat2, spacing = Math.max(tickSizeInner, 0) + tickPadding, range2 = scale.range(), range0 = +range2[0] + offset2, range1 = +range2[range2.length - 1] + offset2, position2 = (scale.bandwidth ? center : number$4)(scale.copy(), offset2), selection2 = context.selection ? context.selection() : context, path2 = selection2.selectAll(".domain").data([null]), tick = selection2.selectAll(".tick").data(values2, scale).order(), tickExit = tick.exit(), tickEnter = tick.enter().append("g").attr("class", "tick"), line2 = tick.select("line"), text2 = tick.select("text");
      path2 = path2.merge(path2.enter().insert("path", ".tick").attr("class", "domain").attr("stroke", "currentColor"));
      tick = tick.merge(tickEnter);
      line2 = line2.merge(tickEnter.append("line").attr("stroke", "currentColor").attr(x2 + "2", k * tickSizeInner));
      text2 = text2.merge(tickEnter.append("text").attr("fill", "currentColor").attr(x2, k * spacing).attr("dy", orient === top ? "0em" : orient === bottom ? "0.71em" : "0.32em"));
      if (context !== selection2) {
        path2 = path2.transition(context);
        tick = tick.transition(context);
        line2 = line2.transition(context);
        text2 = text2.transition(context);
        tickExit = tickExit.transition(context).attr("opacity", epsilon$2).attr("transform", function(d) {
          return isFinite(d = position2(d)) ? transform(d + offset2) : this.getAttribute("transform");
        });
        tickEnter.attr("opacity", epsilon$2).attr("transform", function(d) {
          var p2 = this.parentNode.__axis;
          return transform((p2 && isFinite(p2 = p2(d)) ? p2 : position2(d)) + offset2);
        });
      }
      tickExit.remove();
      path2.attr("d", orient === left || orient === right ? tickSizeOuter ? "M" + k * tickSizeOuter + "," + range0 + "H" + offset2 + "V" + range1 + "H" + k * tickSizeOuter : "M" + offset2 + "," + range0 + "V" + range1 : tickSizeOuter ? "M" + range0 + "," + k * tickSizeOuter + "V" + offset2 + "H" + range1 + "V" + k * tickSizeOuter : "M" + range0 + "," + offset2 + "H" + range1);
      tick.attr("opacity", 1).attr("transform", function(d) {
        return transform(position2(d) + offset2);
      });
      line2.attr(x2 + "2", k * tickSizeInner);
      text2.attr(x2, k * spacing).text(format2);
      selection2.filter(entering).attr("fill", "none").attr("font-size", 10).attr("font-family", "sans-serif").attr("text-anchor", orient === right ? "start" : orient === left ? "end" : "middle");
      selection2.each(function() {
        this.__axis = position2;
      });
    }
    axis2.scale = function(_2) {
      return arguments.length ? (scale = _2, axis2) : scale;
    };
    axis2.ticks = function() {
      return tickArguments = Array.from(arguments), axis2;
    };
    axis2.tickArguments = function(_2) {
      return arguments.length ? (tickArguments = _2 == null ? [] : Array.from(_2), axis2) : tickArguments.slice();
    };
    axis2.tickValues = function(_2) {
      return arguments.length ? (tickValues = _2 == null ? null : Array.from(_2), axis2) : tickValues && tickValues.slice();
    };
    axis2.tickFormat = function(_2) {
      return arguments.length ? (tickFormat2 = _2, axis2) : tickFormat2;
    };
    axis2.tickSize = function(_2) {
      return arguments.length ? (tickSizeInner = tickSizeOuter = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeInner = function(_2) {
      return arguments.length ? (tickSizeInner = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeOuter = function(_2) {
      return arguments.length ? (tickSizeOuter = +_2, axis2) : tickSizeOuter;
    };
    axis2.tickPadding = function(_2) {
      return arguments.length ? (tickPadding = +_2, axis2) : tickPadding;
    };
    axis2.offset = function(_2) {
      return arguments.length ? (offset2 = +_2, axis2) : offset2;
    };
    return axis2;
  }
  function axisTop(scale) {
    return axis(top, scale);
  }
  function axisBottom(scale) {
    return axis(bottom, scale);
  }
  var noop$4 = { value: () => {
  } };
  function dispatch() {
    for (var i2 = 0, n = arguments.length, _2 = {}, t; i2 < n; ++i2) {
      if (!(t = arguments[i2] + "") || t in _2 || /[\s.]/.test(t))
        throw new Error("illegal type: " + t);
      _2[t] = [];
    }
    return new Dispatch(_2);
  }
  function Dispatch(_2) {
    this._ = _2;
  }
  function parseTypenames$1(typenames, types2) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name2 = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name2 = t.slice(i2 + 1), t = t.slice(0, i2);
      if (t && !types2.hasOwnProperty(t))
        throw new Error("unknown type: " + t);
      return { type: t, name: name2 };
    });
  }
  Dispatch.prototype = dispatch.prototype = {
    constructor: Dispatch,
    on: function(typename, callback) {
      var _2 = this._, T = parseTypenames$1(typename + "", _2), t, i2 = -1, n = T.length;
      if (arguments.length < 2) {
        while (++i2 < n)
          if ((t = (typename = T[i2]).type) && (t = get$5(_2[t], typename.name)))
            return t;
        return;
      }
      if (callback != null && typeof callback !== "function")
        throw new Error("invalid callback: " + callback);
      while (++i2 < n) {
        if (t = (typename = T[i2]).type)
          _2[t] = set$5(_2[t], typename.name, callback);
        else if (callback == null)
          for (t in _2)
            _2[t] = set$5(_2[t], typename.name, null);
      }
      return this;
    },
    copy: function() {
      var copy2 = {}, _2 = this._;
      for (var t in _2)
        copy2[t] = _2[t].slice();
      return new Dispatch(copy2);
    },
    call: function(type2, that) {
      if ((n = arguments.length - 2) > 0)
        for (var args = new Array(n), i2 = 0, n, t; i2 < n; ++i2)
          args[i2] = arguments[i2 + 2];
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    },
    apply: function(type2, that, args) {
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (var t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    }
  };
  function get$5(type2, name2) {
    for (var i2 = 0, n = type2.length, c2; i2 < n; ++i2) {
      if ((c2 = type2[i2]).name === name2) {
        return c2.value;
      }
    }
  }
  function set$5(type2, name2, callback) {
    for (var i2 = 0, n = type2.length; i2 < n; ++i2) {
      if (type2[i2].name === name2) {
        type2[i2] = noop$4, type2 = type2.slice(0, i2).concat(type2.slice(i2 + 1));
        break;
      }
    }
    if (callback != null)
      type2.push({ name: name2, value: callback });
    return type2;
  }
  var xhtml = "http://www.w3.org/1999/xhtml";
  const namespaces = {
    svg: "http://www.w3.org/2000/svg",
    xhtml,
    xlink: "http://www.w3.org/1999/xlink",
    xml: "http://www.w3.org/XML/1998/namespace",
    xmlns: "http://www.w3.org/2000/xmlns/"
  };
  function namespace(name2) {
    var prefix = name2 += "", i2 = prefix.indexOf(":");
    if (i2 >= 0 && (prefix = name2.slice(0, i2)) !== "xmlns")
      name2 = name2.slice(i2 + 1);
    return namespaces.hasOwnProperty(prefix) ? { space: namespaces[prefix], local: name2 } : name2;
  }
  function creatorInherit(name2) {
    return function() {
      var document2 = this.ownerDocument, uri = this.namespaceURI;
      return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name2) : document2.createElementNS(uri, name2);
    };
  }
  function creatorFixed(fullname) {
    return function() {
      return this.ownerDocument.createElementNS(fullname.space, fullname.local);
    };
  }
  function creator(name2) {
    var fullname = namespace(name2);
    return (fullname.local ? creatorFixed : creatorInherit)(fullname);
  }
  function none() {
  }
  function selector(selector2) {
    return selector2 == null ? none : function() {
      return this.querySelector(selector2);
    };
  }
  function selection_select(select2) {
    if (typeof select2 !== "function")
      select2 = selector(select2);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select2.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function array$2(x2) {
    return x2 == null ? [] : Array.isArray(x2) ? x2 : Array.from(x2);
  }
  function empty() {
    return [];
  }
  function selectorAll(selector2) {
    return selector2 == null ? empty : function() {
      return this.querySelectorAll(selector2);
    };
  }
  function arrayAll(select2) {
    return function() {
      return array$2(select2.apply(this, arguments));
    };
  }
  function selection_selectAll(select2) {
    if (typeof select2 === "function")
      select2 = arrayAll(select2);
    else
      select2 = selectorAll(select2);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          subgroups.push(select2.call(node2, node2.__data__, i2, group));
          parents2.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, parents2);
  }
  function matcher(selector2) {
    return function() {
      return this.matches(selector2);
    };
  }
  function childMatcher(selector2) {
    return function(node2) {
      return node2.matches(selector2);
    };
  }
  var find$2 = Array.prototype.find;
  function childFind(match5) {
    return function() {
      return find$2.call(this.children, match5);
    };
  }
  function childFirst() {
    return this.firstElementChild;
  }
  function selection_selectChild(match5) {
    return this.select(match5 == null ? childFirst : childFind(typeof match5 === "function" ? match5 : childMatcher(match5)));
  }
  var filter$2 = Array.prototype.filter;
  function children() {
    return Array.from(this.children);
  }
  function childrenFilter(match5) {
    return function() {
      return filter$2.call(this.children, match5);
    };
  }
  function selection_selectChildren(match5) {
    return this.selectAll(match5 == null ? children : childrenFilter(typeof match5 === "function" ? match5 : childMatcher(match5)));
  }
  function selection_filter(match5) {
    if (typeof match5 !== "function")
      match5 = matcher(match5);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match5.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function sparse(update2) {
    return new Array(update2.length);
  }
  function selection_enter() {
    return new Selection$1(this._enter || this._groups.map(sparse), this._parents);
  }
  function EnterNode(parent, datum2) {
    this.ownerDocument = parent.ownerDocument;
    this.namespaceURI = parent.namespaceURI;
    this._next = null;
    this._parent = parent;
    this.__data__ = datum2;
  }
  EnterNode.prototype = {
    constructor: EnterNode,
    appendChild: function(child) {
      return this._parent.insertBefore(child, this._next);
    },
    insertBefore: function(child, next2) {
      return this._parent.insertBefore(child, next2);
    },
    querySelector: function(selector2) {
      return this._parent.querySelector(selector2);
    },
    querySelectorAll: function(selector2) {
      return this._parent.querySelectorAll(selector2);
    }
  };
  function constant$3(x2) {
    return function() {
      return x2;
    };
  }
  function bindIndex(parent, group, enter2, update2, exit2, data2) {
    var i2 = 0, node2, groupLength = group.length, dataLength = data2.length;
    for (; i2 < dataLength; ++i2) {
      if (node2 = group[i2]) {
        node2.__data__ = data2[i2];
        update2[i2] = node2;
      } else {
        enter2[i2] = new EnterNode(parent, data2[i2]);
      }
    }
    for (; i2 < groupLength; ++i2) {
      if (node2 = group[i2]) {
        exit2[i2] = node2;
      }
    }
  }
  function bindKey(parent, group, enter2, update2, exit2, data2, key) {
    var i2, node2, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group.length, dataLength = data2.length, keyValues = new Array(groupLength), keyValue;
    for (i2 = 0; i2 < groupLength; ++i2) {
      if (node2 = group[i2]) {
        keyValues[i2] = keyValue = key.call(node2, node2.__data__, i2, group) + "";
        if (nodeByKeyValue.has(keyValue)) {
          exit2[i2] = node2;
        } else {
          nodeByKeyValue.set(keyValue, node2);
        }
      }
    }
    for (i2 = 0; i2 < dataLength; ++i2) {
      keyValue = key.call(parent, data2[i2], i2, data2) + "";
      if (node2 = nodeByKeyValue.get(keyValue)) {
        update2[i2] = node2;
        node2.__data__ = data2[i2];
        nodeByKeyValue.delete(keyValue);
      } else {
        enter2[i2] = new EnterNode(parent, data2[i2]);
      }
    }
    for (i2 = 0; i2 < groupLength; ++i2) {
      if ((node2 = group[i2]) && nodeByKeyValue.get(keyValues[i2]) === node2) {
        exit2[i2] = node2;
      }
    }
  }
  function datum(node2) {
    return node2.__data__;
  }
  function selection_data(value, key) {
    if (!arguments.length)
      return Array.from(this, datum);
    var bind = key ? bindKey : bindIndex, parents2 = this._parents, groups = this._groups;
    if (typeof value !== "function")
      value = constant$3(value);
    for (var m = groups.length, update2 = new Array(m), enter2 = new Array(m), exit2 = new Array(m), j = 0; j < m; ++j) {
      var parent = parents2[j], group = groups[j], groupLength = group.length, data2 = arraylike(value.call(parent, parent && parent.__data__, j, parents2)), dataLength = data2.length, enterGroup = enter2[j] = new Array(dataLength), updateGroup = update2[j] = new Array(dataLength), exitGroup = exit2[j] = new Array(groupLength);
      bind(parent, group, enterGroup, updateGroup, exitGroup, data2, key);
      for (var i0 = 0, i1 = 0, previous, next2; i0 < dataLength; ++i0) {
        if (previous = enterGroup[i0]) {
          if (i0 >= i1)
            i1 = i0 + 1;
          while (!(next2 = updateGroup[i1]) && ++i1 < dataLength)
            ;
          previous._next = next2 || null;
        }
      }
    }
    update2 = new Selection$1(update2, parents2);
    update2._enter = enter2;
    update2._exit = exit2;
    return update2;
  }
  function arraylike(data2) {
    return typeof data2 === "object" && "length" in data2 ? data2 : Array.from(data2);
  }
  function selection_exit() {
    return new Selection$1(this._exit || this._groups.map(sparse), this._parents);
  }
  function selection_join(onenter, onupdate, onexit) {
    var enter2 = this.enter(), update2 = this, exit2 = this.exit();
    if (typeof onenter === "function") {
      enter2 = onenter(enter2);
      if (enter2)
        enter2 = enter2.selection();
    } else {
      enter2 = enter2.append(onenter + "");
    }
    if (onupdate != null) {
      update2 = onupdate(update2);
      if (update2)
        update2 = update2.selection();
    }
    if (onexit == null)
      exit2.remove();
    else
      onexit(exit2);
    return enter2 && update2 ? enter2.merge(update2).order() : update2;
  }
  function selection_merge(context) {
    var selection2 = context.selection ? context.selection() : context;
    for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Selection$1(merges, this._parents);
  }
  function selection_order() {
    for (var groups = this._groups, j = -1, m = groups.length; ++j < m; ) {
      for (var group = groups[j], i2 = group.length - 1, next2 = group[i2], node2; --i2 >= 0; ) {
        if (node2 = group[i2]) {
          if (next2 && node2.compareDocumentPosition(next2) ^ 4)
            next2.parentNode.insertBefore(node2, next2);
          next2 = node2;
        }
      }
    }
    return this;
  }
  function selection_sort(compare) {
    if (!compare)
      compare = ascending$1;
    function compareNode(a, b) {
      return a && b ? compare(a.__data__, b.__data__) : !a - !b;
    }
    for (var groups = this._groups, m = groups.length, sortgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, sortgroup = sortgroups[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          sortgroup[i2] = node2;
        }
      }
      sortgroup.sort(compareNode);
    }
    return new Selection$1(sortgroups, this._parents).order();
  }
  function ascending$1(a, b) {
    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function selection_call() {
    var callback = arguments[0];
    arguments[0] = this;
    callback.apply(null, arguments);
    return this;
  }
  function selection_nodes() {
    return Array.from(this);
  }
  function selection_node() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length; i2 < n; ++i2) {
        var node2 = group[i2];
        if (node2)
          return node2;
      }
    }
    return null;
  }
  function selection_size() {
    let size2 = 0;
    for (const node2 of this)
      ++size2;
    return size2;
  }
  function selection_empty() {
    return !this.node();
  }
  function selection_each(callback) {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          callback.call(node2, node2.__data__, i2, group);
      }
    }
    return this;
  }
  function attrRemove$1(name2) {
    return function() {
      this.removeAttribute(name2);
    };
  }
  function attrRemoveNS$1(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant$1(name2, value) {
    return function() {
      this.setAttribute(name2, value);
    };
  }
  function attrConstantNS$1(fullname, value) {
    return function() {
      this.setAttributeNS(fullname.space, fullname.local, value);
    };
  }
  function attrFunction$1(name2, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        this.removeAttribute(name2);
      else
        this.setAttribute(name2, v);
    };
  }
  function attrFunctionNS$1(fullname, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        this.removeAttributeNS(fullname.space, fullname.local);
      else
        this.setAttributeNS(fullname.space, fullname.local, v);
    };
  }
  function selection_attr(name2, value) {
    var fullname = namespace(name2);
    if (arguments.length < 2) {
      var node2 = this.node();
      return fullname.local ? node2.getAttributeNS(fullname.space, fullname.local) : node2.getAttribute(fullname);
    }
    return this.each((value == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value));
  }
  function defaultView(node2) {
    return node2.ownerDocument && node2.ownerDocument.defaultView || node2.document && node2 || node2.defaultView;
  }
  function styleRemove$1(name2) {
    return function() {
      this.style.removeProperty(name2);
    };
  }
  function styleConstant$1(name2, value, priority) {
    return function() {
      this.style.setProperty(name2, value, priority);
    };
  }
  function styleFunction$1(name2, value, priority) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        this.style.removeProperty(name2);
      else
        this.style.setProperty(name2, v, priority);
    };
  }
  function selection_style(name2, value, priority) {
    return arguments.length > 1 ? this.each((value == null ? styleRemove$1 : typeof value === "function" ? styleFunction$1 : styleConstant$1)(name2, value, priority == null ? "" : priority)) : styleValue(this.node(), name2);
  }
  function styleValue(node2, name2) {
    return node2.style.getPropertyValue(name2) || defaultView(node2).getComputedStyle(node2, null).getPropertyValue(name2);
  }
  function propertyRemove(name2) {
    return function() {
      delete this[name2];
    };
  }
  function propertyConstant(name2, value) {
    return function() {
      this[name2] = value;
    };
  }
  function propertyFunction(name2, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        delete this[name2];
      else
        this[name2] = v;
    };
  }
  function selection_property(name2, value) {
    return arguments.length > 1 ? this.each((value == null ? propertyRemove : typeof value === "function" ? propertyFunction : propertyConstant)(name2, value)) : this.node()[name2];
  }
  function classArray(string2) {
    return string2.trim().split(/^|\s+/);
  }
  function classList(node2) {
    return node2.classList || new ClassList(node2);
  }
  function ClassList(node2) {
    this._node = node2;
    this._names = classArray(node2.getAttribute("class") || "");
  }
  ClassList.prototype = {
    add: function(name2) {
      var i2 = this._names.indexOf(name2);
      if (i2 < 0) {
        this._names.push(name2);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    remove: function(name2) {
      var i2 = this._names.indexOf(name2);
      if (i2 >= 0) {
        this._names.splice(i2, 1);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    contains: function(name2) {
      return this._names.indexOf(name2) >= 0;
    }
  };
  function classedAdd(node2, names) {
    var list = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list.add(names[i2]);
  }
  function classedRemove(node2, names) {
    var list = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list.remove(names[i2]);
  }
  function classedTrue(names) {
    return function() {
      classedAdd(this, names);
    };
  }
  function classedFalse(names) {
    return function() {
      classedRemove(this, names);
    };
  }
  function classedFunction(names, value) {
    return function() {
      (value.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
    };
  }
  function selection_classed(name2, value) {
    var names = classArray(name2 + "");
    if (arguments.length < 2) {
      var list = classList(this.node()), i2 = -1, n = names.length;
      while (++i2 < n)
        if (!list.contains(names[i2]))
          return false;
      return true;
    }
    return this.each((typeof value === "function" ? classedFunction : value ? classedTrue : classedFalse)(names, value));
  }
  function textRemove() {
    this.textContent = "";
  }
  function textConstant$1(value) {
    return function() {
      this.textContent = value;
    };
  }
  function textFunction$1(value) {
    return function() {
      var v = value.apply(this, arguments);
      this.textContent = v == null ? "" : v;
    };
  }
  function selection_text(value) {
    return arguments.length ? this.each(value == null ? textRemove : (typeof value === "function" ? textFunction$1 : textConstant$1)(value)) : this.node().textContent;
  }
  function htmlRemove() {
    this.innerHTML = "";
  }
  function htmlConstant(value) {
    return function() {
      this.innerHTML = value;
    };
  }
  function htmlFunction(value) {
    return function() {
      var v = value.apply(this, arguments);
      this.innerHTML = v == null ? "" : v;
    };
  }
  function selection_html(value) {
    return arguments.length ? this.each(value == null ? htmlRemove : (typeof value === "function" ? htmlFunction : htmlConstant)(value)) : this.node().innerHTML;
  }
  function raise() {
    if (this.nextSibling)
      this.parentNode.appendChild(this);
  }
  function selection_raise() {
    return this.each(raise);
  }
  function lower() {
    if (this.previousSibling)
      this.parentNode.insertBefore(this, this.parentNode.firstChild);
  }
  function selection_lower() {
    return this.each(lower);
  }
  function selection_append(name2) {
    var create2 = typeof name2 === "function" ? name2 : creator(name2);
    return this.select(function() {
      return this.appendChild(create2.apply(this, arguments));
    });
  }
  function constantNull() {
    return null;
  }
  function selection_insert(name2, before) {
    var create2 = typeof name2 === "function" ? name2 : creator(name2), select2 = before == null ? constantNull : typeof before === "function" ? before : selector(before);
    return this.select(function() {
      return this.insertBefore(create2.apply(this, arguments), select2.apply(this, arguments) || null);
    });
  }
  function remove() {
    var parent = this.parentNode;
    if (parent)
      parent.removeChild(this);
  }
  function selection_remove() {
    return this.each(remove);
  }
  function selection_cloneShallow() {
    var clone2 = this.cloneNode(false), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_cloneDeep() {
    var clone2 = this.cloneNode(true), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_clone(deep) {
    return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
  }
  function selection_datum(value) {
    return arguments.length ? this.property("__data__", value) : this.node().__data__;
  }
  function contextListener(listener) {
    return function(event2) {
      listener.call(this, event2, this.__data__);
    };
  }
  function parseTypenames(typenames) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name2 = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name2 = t.slice(i2 + 1), t = t.slice(0, i2);
      return { type: t, name: name2 };
    });
  }
  function onRemove(typename) {
    return function() {
      var on = this.__on;
      if (!on)
        return;
      for (var j = 0, i2 = -1, m = on.length, o; j < m; ++j) {
        if (o = on[j], (!typename.type || o.type === typename.type) && o.name === typename.name) {
          this.removeEventListener(o.type, o.listener, o.options);
        } else {
          on[++i2] = o;
        }
      }
      if (++i2)
        on.length = i2;
      else
        delete this.__on;
    };
  }
  function onAdd(typename, value, options2) {
    return function() {
      var on = this.__on, o, listener = contextListener(value);
      if (on)
        for (var j = 0, m = on.length; j < m; ++j) {
          if ((o = on[j]).type === typename.type && o.name === typename.name) {
            this.removeEventListener(o.type, o.listener, o.options);
            this.addEventListener(o.type, o.listener = listener, o.options = options2);
            o.value = value;
            return;
          }
        }
      this.addEventListener(typename.type, listener, options2);
      o = { type: typename.type, name: typename.name, value, listener, options: options2 };
      if (!on)
        this.__on = [o];
      else
        on.push(o);
    };
  }
  function selection_on(typename, value, options2) {
    var typenames = parseTypenames(typename + ""), i2, n = typenames.length, t;
    if (arguments.length < 2) {
      var on = this.node().__on;
      if (on)
        for (var j = 0, m = on.length, o; j < m; ++j) {
          for (i2 = 0, o = on[j]; i2 < n; ++i2) {
            if ((t = typenames[i2]).type === o.type && t.name === o.name) {
              return o.value;
            }
          }
        }
      return;
    }
    on = value ? onAdd : onRemove;
    for (i2 = 0; i2 < n; ++i2)
      this.each(on(typenames[i2], value, options2));
    return this;
  }
  function dispatchEvent(node2, type2, params) {
    var window2 = defaultView(node2), event2 = window2.CustomEvent;
    if (typeof event2 === "function") {
      event2 = new event2(type2, params);
    } else {
      event2 = window2.document.createEvent("Event");
      if (params)
        event2.initEvent(type2, params.bubbles, params.cancelable), event2.detail = params.detail;
      else
        event2.initEvent(type2, false, false);
    }
    node2.dispatchEvent(event2);
  }
  function dispatchConstant(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params);
    };
  }
  function dispatchFunction(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params.apply(this, arguments));
    };
  }
  function selection_dispatch(type2, params) {
    return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type2, params));
  }
  function* selection_iterator() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          yield node2;
      }
    }
  }
  var root$7 = [null];
  function Selection$1(groups, parents2) {
    this._groups = groups;
    this._parents = parents2;
  }
  function selection() {
    return new Selection$1([[document.documentElement]], root$7);
  }
  function selection_selection() {
    return this;
  }
  Selection$1.prototype = selection.prototype = {
    constructor: Selection$1,
    select: selection_select,
    selectAll: selection_selectAll,
    selectChild: selection_selectChild,
    selectChildren: selection_selectChildren,
    filter: selection_filter,
    data: selection_data,
    enter: selection_enter,
    exit: selection_exit,
    join: selection_join,
    merge: selection_merge,
    selection: selection_selection,
    order: selection_order,
    sort: selection_sort,
    call: selection_call,
    nodes: selection_nodes,
    node: selection_node,
    size: selection_size,
    empty: selection_empty,
    each: selection_each,
    attr: selection_attr,
    style: selection_style,
    property: selection_property,
    classed: selection_classed,
    text: selection_text,
    html: selection_html,
    raise: selection_raise,
    lower: selection_lower,
    append: selection_append,
    insert: selection_insert,
    remove: selection_remove,
    clone: selection_clone,
    datum: selection_datum,
    on: selection_on,
    dispatch: selection_dispatch,
    [Symbol.iterator]: selection_iterator
  };
  function select(selector2) {
    return typeof selector2 === "string" ? new Selection$1([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$1([[selector2]], root$7);
  }
  function selectAll(selector2) {
    return typeof selector2 === "string" ? new Selection$1([document.querySelectorAll(selector2)], [document.documentElement]) : new Selection$1([array$2(selector2)], root$7);
  }
  function define$4(constructor, factory, prototype) {
    constructor.prototype = factory.prototype = prototype;
    prototype.constructor = constructor;
  }
  function extend$2(parent, definition) {
    var prototype = Object.create(parent.prototype);
    for (var key in definition)
      prototype[key] = definition[key];
    return prototype;
  }
  function Color$2() {
  }
  var darker = 0.7;
  var brighter = 1 / darker;
  var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
  var named = {
    aliceblue: 15792383,
    antiquewhite: 16444375,
    aqua: 65535,
    aquamarine: 8388564,
    azure: 15794175,
    beige: 16119260,
    bisque: 16770244,
    black: 0,
    blanchedalmond: 16772045,
    blue: 255,
    blueviolet: 9055202,
    brown: 10824234,
    burlywood: 14596231,
    cadetblue: 6266528,
    chartreuse: 8388352,
    chocolate: 13789470,
    coral: 16744272,
    cornflowerblue: 6591981,
    cornsilk: 16775388,
    crimson: 14423100,
    cyan: 65535,
    darkblue: 139,
    darkcyan: 35723,
    darkgoldenrod: 12092939,
    darkgray: 11119017,
    darkgreen: 25600,
    darkgrey: 11119017,
    darkkhaki: 12433259,
    darkmagenta: 9109643,
    darkolivegreen: 5597999,
    darkorange: 16747520,
    darkorchid: 10040012,
    darkred: 9109504,
    darksalmon: 15308410,
    darkseagreen: 9419919,
    darkslateblue: 4734347,
    darkslategray: 3100495,
    darkslategrey: 3100495,
    darkturquoise: 52945,
    darkviolet: 9699539,
    deeppink: 16716947,
    deepskyblue: 49151,
    dimgray: 6908265,
    dimgrey: 6908265,
    dodgerblue: 2003199,
    firebrick: 11674146,
    floralwhite: 16775920,
    forestgreen: 2263842,
    fuchsia: 16711935,
    gainsboro: 14474460,
    ghostwhite: 16316671,
    gold: 16766720,
    goldenrod: 14329120,
    gray: 8421504,
    green: 32768,
    greenyellow: 11403055,
    grey: 8421504,
    honeydew: 15794160,
    hotpink: 16738740,
    indianred: 13458524,
    indigo: 4915330,
    ivory: 16777200,
    khaki: 15787660,
    lavender: 15132410,
    lavenderblush: 16773365,
    lawngreen: 8190976,
    lemonchiffon: 16775885,
    lightblue: 11393254,
    lightcoral: 15761536,
    lightcyan: 14745599,
    lightgoldenrodyellow: 16448210,
    lightgray: 13882323,
    lightgreen: 9498256,
    lightgrey: 13882323,
    lightpink: 16758465,
    lightsalmon: 16752762,
    lightseagreen: 2142890,
    lightskyblue: 8900346,
    lightslategray: 7833753,
    lightslategrey: 7833753,
    lightsteelblue: 11584734,
    lightyellow: 16777184,
    lime: 65280,
    limegreen: 3329330,
    linen: 16445670,
    magenta: 16711935,
    maroon: 8388608,
    mediumaquamarine: 6737322,
    mediumblue: 205,
    mediumorchid: 12211667,
    mediumpurple: 9662683,
    mediumseagreen: 3978097,
    mediumslateblue: 8087790,
    mediumspringgreen: 64154,
    mediumturquoise: 4772300,
    mediumvioletred: 13047173,
    midnightblue: 1644912,
    mintcream: 16121850,
    mistyrose: 16770273,
    moccasin: 16770229,
    navajowhite: 16768685,
    navy: 128,
    oldlace: 16643558,
    olive: 8421376,
    olivedrab: 7048739,
    orange: 16753920,
    orangered: 16729344,
    orchid: 14315734,
    palegoldenrod: 15657130,
    palegreen: 10025880,
    paleturquoise: 11529966,
    palevioletred: 14381203,
    papayawhip: 16773077,
    peachpuff: 16767673,
    peru: 13468991,
    pink: 16761035,
    plum: 14524637,
    powderblue: 11591910,
    purple: 8388736,
    rebeccapurple: 6697881,
    red: 16711680,
    rosybrown: 12357519,
    royalblue: 4286945,
    saddlebrown: 9127187,
    salmon: 16416882,
    sandybrown: 16032864,
    seagreen: 3050327,
    seashell: 16774638,
    sienna: 10506797,
    silver: 12632256,
    skyblue: 8900331,
    slateblue: 6970061,
    slategray: 7372944,
    slategrey: 7372944,
    snow: 16775930,
    springgreen: 65407,
    steelblue: 4620980,
    tan: 13808780,
    teal: 32896,
    thistle: 14204888,
    tomato: 16737095,
    turquoise: 4251856,
    violet: 15631086,
    wheat: 16113331,
    white: 16777215,
    whitesmoke: 16119285,
    yellow: 16776960,
    yellowgreen: 10145074
  };
  define$4(Color$2, color, {
    copy(channels2) {
      return Object.assign(new this.constructor(), this, channels2);
    },
    displayable() {
      return this.rgb().displayable();
    },
    hex: color_formatHex,
    formatHex: color_formatHex,
    formatHex8: color_formatHex8,
    formatHsl: color_formatHsl,
    formatRgb: color_formatRgb,
    toString: color_formatRgb
  });
  function color_formatHex() {
    return this.rgb().formatHex();
  }
  function color_formatHex8() {
    return this.rgb().formatHex8();
  }
  function color_formatHsl() {
    return hslConvert(this).formatHsl();
  }
  function color_formatRgb() {
    return this.rgb().formatRgb();
  }
  function color(format2) {
    var m, l;
    format2 = (format2 + "").trim().toLowerCase();
    return (m = reHex.exec(format2)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) : l === 3 ? new Rgb(m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, (m & 15) << 4 | m & 15, 1) : l === 8 ? rgba$3(m >> 24 & 255, m >> 16 & 255, m >> 8 & 255, (m & 255) / 255) : l === 4 ? rgba$3(m >> 12 & 15 | m >> 8 & 240, m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, ((m & 15) << 4 | m & 15) / 255) : null) : (m = reRgbInteger.exec(format2)) ? new Rgb(m[1], m[2], m[3], 1) : (m = reRgbPercent.exec(format2)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) : (m = reRgbaInteger.exec(format2)) ? rgba$3(m[1], m[2], m[3], m[4]) : (m = reRgbaPercent.exec(format2)) ? rgba$3(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) : (m = reHslPercent.exec(format2)) ? hsla$1(m[1], m[2] / 100, m[3] / 100, 1) : (m = reHslaPercent.exec(format2)) ? hsla$1(m[1], m[2] / 100, m[3] / 100, m[4]) : named.hasOwnProperty(format2) ? rgbn(named[format2]) : format2 === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
  }
  function rgbn(n) {
    return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
  }
  function rgba$3(r, g, b, a) {
    if (a <= 0)
      r = g = b = NaN;
    return new Rgb(r, g, b, a);
  }
  function rgbConvert(o) {
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Rgb();
    o = o.rgb();
    return new Rgb(o.r, o.g, o.b, o.opacity);
  }
  function rgb(r, g, b, opacity) {
    return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
  }
  function Rgb(r, g, b, opacity) {
    this.r = +r;
    this.g = +g;
    this.b = +b;
    this.opacity = +opacity;
  }
  define$4(Rgb, rgb, extend$2(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    rgb() {
      return this;
    },
    clamp() {
      return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
    },
    displayable() {
      return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
    },
    hex: rgb_formatHex,
    formatHex: rgb_formatHex,
    formatHex8: rgb_formatHex8,
    formatRgb: rgb_formatRgb,
    toString: rgb_formatRgb
  }));
  function rgb_formatHex() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
  }
  function rgb_formatHex8() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
  }
  function rgb_formatRgb() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
  }
  function clampa(opacity) {
    return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
  }
  function clampi(value) {
    return Math.max(0, Math.min(255, Math.round(value) || 0));
  }
  function hex(value) {
    value = clampi(value);
    return (value < 16 ? "0" : "") + value.toString(16);
  }
  function hsla$1(h, s, l, a) {
    if (a <= 0)
      h = s = l = NaN;
    else if (l <= 0 || l >= 1)
      h = s = NaN;
    else if (s <= 0)
      h = NaN;
    return new Hsl(h, s, l, a);
  }
  function hslConvert(o) {
    if (o instanceof Hsl)
      return new Hsl(o.h, o.s, o.l, o.opacity);
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Hsl();
    if (o instanceof Hsl)
      return o;
    o = o.rgb();
    var r = o.r / 255, g = o.g / 255, b = o.b / 255, min2 = Math.min(r, g, b), max2 = Math.max(r, g, b), h = NaN, s = max2 - min2, l = (max2 + min2) / 2;
    if (s) {
      if (r === max2)
        h = (g - b) / s + (g < b) * 6;
      else if (g === max2)
        h = (b - r) / s + 2;
      else
        h = (r - g) / s + 4;
      s /= l < 0.5 ? max2 + min2 : 2 - max2 - min2;
      h *= 60;
    } else {
      s = l > 0 && l < 1 ? 0 : h;
    }
    return new Hsl(h, s, l, o.opacity);
  }
  function hsl(h, s, l, opacity) {
    return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
  }
  function Hsl(h, s, l, opacity) {
    this.h = +h;
    this.s = +s;
    this.l = +l;
    this.opacity = +opacity;
  }
  define$4(Hsl, hsl, extend$2(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    rgb() {
      var h = this.h % 360 + (this.h < 0) * 360, s = isNaN(h) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
      return new Rgb(
        hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
        hsl2rgb(h, m1, m2),
        hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
        this.opacity
      );
    },
    clamp() {
      return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
    },
    displayable() {
      return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
    },
    formatHsl() {
      const a = clampa(this.opacity);
      return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
    }
  }));
  function clamph(value) {
    value = (value || 0) % 360;
    return value < 0 ? value + 360 : value;
  }
  function clampt(value) {
    return Math.max(0, Math.min(1, value || 0));
  }
  function hsl2rgb(h, m1, m2) {
    return (h < 60 ? m1 + (m2 - m1) * h / 60 : h < 180 ? m2 : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60 : m1) * 255;
  }
  const radians = Math.PI / 180;
  const degrees$1 = 180 / Math.PI;
  const K$1 = 18, Xn = 0.96422, Yn = 1, Zn = 0.82521, t0$1 = 4 / 29, t1$1 = 6 / 29, t2 = 3 * t1$1 * t1$1, t3 = t1$1 * t1$1 * t1$1;
  function labConvert(o) {
    if (o instanceof Lab)
      return new Lab(o.l, o.a, o.b, o.opacity);
    if (o instanceof Hcl)
      return hcl2lab(o);
    if (!(o instanceof Rgb))
      o = rgbConvert(o);
    var r = rgb2lrgb(o.r), g = rgb2lrgb(o.g), b = rgb2lrgb(o.b), y2 = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn), x2, z;
    if (r === g && g === b)
      x2 = z = y2;
    else {
      x2 = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
      z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b) / Zn);
    }
    return new Lab(116 * y2 - 16, 500 * (x2 - y2), 200 * (y2 - z), o.opacity);
  }
  function lab(l, a, b, opacity) {
    return arguments.length === 1 ? labConvert(l) : new Lab(l, a, b, opacity == null ? 1 : opacity);
  }
  function Lab(l, a, b, opacity) {
    this.l = +l;
    this.a = +a;
    this.b = +b;
    this.opacity = +opacity;
  }
  define$4(Lab, lab, extend$2(Color$2, {
    brighter(k) {
      return new Lab(this.l + K$1 * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    darker(k) {
      return new Lab(this.l - K$1 * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    rgb() {
      var y2 = (this.l + 16) / 116, x2 = isNaN(this.a) ? y2 : y2 + this.a / 500, z = isNaN(this.b) ? y2 : y2 - this.b / 200;
      x2 = Xn * lab2xyz(x2);
      y2 = Yn * lab2xyz(y2);
      z = Zn * lab2xyz(z);
      return new Rgb(
        lrgb2rgb(3.1338561 * x2 - 1.6168667 * y2 - 0.4906146 * z),
        lrgb2rgb(-0.9787684 * x2 + 1.9161415 * y2 + 0.033454 * z),
        lrgb2rgb(0.0719453 * x2 - 0.2289914 * y2 + 1.4052427 * z),
        this.opacity
      );
    }
  }));
  function xyz2lab(t) {
    return t > t3 ? Math.pow(t, 1 / 3) : t / t2 + t0$1;
  }
  function lab2xyz(t) {
    return t > t1$1 ? t * t * t : t2 * (t - t0$1);
  }
  function lrgb2rgb(x2) {
    return 255 * (x2 <= 31308e-7 ? 12.92 * x2 : 1.055 * Math.pow(x2, 1 / 2.4) - 0.055);
  }
  function rgb2lrgb(x2) {
    return (x2 /= 255) <= 0.04045 ? x2 / 12.92 : Math.pow((x2 + 0.055) / 1.055, 2.4);
  }
  function hclConvert(o) {
    if (o instanceof Hcl)
      return new Hcl(o.h, o.c, o.l, o.opacity);
    if (!(o instanceof Lab))
      o = labConvert(o);
    if (o.a === 0 && o.b === 0)
      return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
    var h = Math.atan2(o.b, o.a) * degrees$1;
    return new Hcl(h < 0 ? h + 360 : h, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
  }
  function hcl$1(h, c2, l, opacity) {
    return arguments.length === 1 ? hclConvert(h) : new Hcl(h, c2, l, opacity == null ? 1 : opacity);
  }
  function Hcl(h, c2, l, opacity) {
    this.h = +h;
    this.c = +c2;
    this.l = +l;
    this.opacity = +opacity;
  }
  function hcl2lab(o) {
    if (isNaN(o.h))
      return new Lab(o.l, 0, 0, o.opacity);
    var h = o.h * radians;
    return new Lab(o.l, Math.cos(h) * o.c, Math.sin(h) * o.c, o.opacity);
  }
  define$4(Hcl, hcl$1, extend$2(Color$2, {
    brighter(k) {
      return new Hcl(this.h, this.c, this.l + K$1 * (k == null ? 1 : k), this.opacity);
    },
    darker(k) {
      return new Hcl(this.h, this.c, this.l - K$1 * (k == null ? 1 : k), this.opacity);
    },
    rgb() {
      return hcl2lab(this).rgb();
    }
  }));
  const constant$2 = (x2) => () => x2;
  function linear$1(a, d) {
    return function(t) {
      return a + t * d;
    };
  }
  function exponential(a, b, y2) {
    return a = Math.pow(a, y2), b = Math.pow(b, y2) - a, y2 = 1 / y2, function(t) {
      return Math.pow(a + t * b, y2);
    };
  }
  function hue(a, b) {
    var d = b - a;
    return d ? linear$1(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : constant$2(isNaN(a) ? b : a);
  }
  function gamma(y2) {
    return (y2 = +y2) === 1 ? nogamma : function(a, b) {
      return b - a ? exponential(a, b, y2) : constant$2(isNaN(a) ? b : a);
    };
  }
  function nogamma(a, b) {
    var d = b - a;
    return d ? linear$1(a, d) : constant$2(isNaN(a) ? b : a);
  }
  const interpolateRgb = function rgbGamma(y2) {
    var color2 = gamma(y2);
    function rgb$1(start2, end2) {
      var r = color2((start2 = rgb(start2)).r, (end2 = rgb(end2)).r), g = color2(start2.g, end2.g), b = color2(start2.b, end2.b), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.r = r(t);
        start2.g = g(t);
        start2.b = b(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    }
    rgb$1.gamma = rgbGamma;
    return rgb$1;
  }(1);
  function numberArray(a, b) {
    if (!b)
      b = [];
    var n = a ? Math.min(b.length, a.length) : 0, c2 = b.slice(), i2;
    return function(t) {
      for (i2 = 0; i2 < n; ++i2)
        c2[i2] = a[i2] * (1 - t) + b[i2] * t;
      return c2;
    };
  }
  function isNumberArray(x2) {
    return ArrayBuffer.isView(x2) && !(x2 instanceof DataView);
  }
  function genericArray(a, b) {
    var nb = b ? b.length : 0, na = a ? Math.min(nb, a.length) : 0, x2 = new Array(na), c2 = new Array(nb), i2;
    for (i2 = 0; i2 < na; ++i2)
      x2[i2] = interpolate$1(a[i2], b[i2]);
    for (; i2 < nb; ++i2)
      c2[i2] = b[i2];
    return function(t) {
      for (i2 = 0; i2 < na; ++i2)
        c2[i2] = x2[i2](t);
      return c2;
    };
  }
  function date$1(a, b) {
    var d = new Date();
    return a = +a, b = +b, function(t) {
      return d.setTime(a * (1 - t) + b * t), d;
    };
  }
  function interpolateNumber(a, b) {
    return a = +a, b = +b, function(t) {
      return a * (1 - t) + b * t;
    };
  }
  function object$1(a, b) {
    var i2 = {}, c2 = {}, k;
    if (a === null || typeof a !== "object")
      a = {};
    if (b === null || typeof b !== "object")
      b = {};
    for (k in b) {
      if (k in a) {
        i2[k] = interpolate$1(a[k], b[k]);
      } else {
        c2[k] = b[k];
      }
    }
    return function(t) {
      for (k in i2)
        c2[k] = i2[k](t);
      return c2;
    };
  }
  var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
  function zero(b) {
    return function() {
      return b;
    };
  }
  function one(b) {
    return function(t) {
      return b(t) + "";
    };
  }
  function interpolateString(a, b) {
    var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i2 = -1, s = [], q = [];
    a = a + "", b = b + "";
    while ((am = reA.exec(a)) && (bm = reB.exec(b))) {
      if ((bs = bm.index) > bi) {
        bs = b.slice(bi, bs);
        if (s[i2])
          s[i2] += bs;
        else
          s[++i2] = bs;
      }
      if ((am = am[0]) === (bm = bm[0])) {
        if (s[i2])
          s[i2] += bm;
        else
          s[++i2] = bm;
      } else {
        s[++i2] = null;
        q.push({ i: i2, x: interpolateNumber(am, bm) });
      }
      bi = reB.lastIndex;
    }
    if (bi < b.length) {
      bs = b.slice(bi);
      if (s[i2])
        s[i2] += bs;
      else
        s[++i2] = bs;
    }
    return s.length < 2 ? q[0] ? one(q[0].x) : zero(b) : (b = q.length, function(t) {
      for (var i3 = 0, o; i3 < b; ++i3)
        s[(o = q[i3]).i] = o.x(t);
      return s.join("");
    });
  }
  function interpolate$1(a, b) {
    var t = typeof b, c2;
    return b == null || t === "boolean" ? constant$2(b) : (t === "number" ? interpolateNumber : t === "string" ? (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString : b instanceof color ? interpolateRgb : b instanceof Date ? date$1 : isNumberArray(b) ? numberArray : Array.isArray(b) ? genericArray : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object$1 : interpolateNumber)(a, b);
  }
  function interpolateRound(a, b) {
    return a = +a, b = +b, function(t) {
      return Math.round(a * (1 - t) + b * t);
    };
  }
  var degrees = 180 / Math.PI;
  var identity$5 = {
    translateX: 0,
    translateY: 0,
    rotate: 0,
    skewX: 0,
    scaleX: 1,
    scaleY: 1
  };
  function decompose(a, b, c2, d, e, f2) {
    var scaleX, scaleY, skewX;
    if (scaleX = Math.sqrt(a * a + b * b))
      a /= scaleX, b /= scaleX;
    if (skewX = a * c2 + b * d)
      c2 -= a * skewX, d -= b * skewX;
    if (scaleY = Math.sqrt(c2 * c2 + d * d))
      c2 /= scaleY, d /= scaleY, skewX /= scaleY;
    if (a * d < b * c2)
      a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
    return {
      translateX: e,
      translateY: f2,
      rotate: Math.atan2(b, a) * degrees,
      skewX: Math.atan(skewX) * degrees,
      scaleX,
      scaleY
    };
  }
  var svgNode;
  function parseCss(value) {
    const m = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value + "");
    return m.isIdentity ? identity$5 : decompose(m.a, m.b, m.c, m.d, m.e, m.f);
  }
  function parseSvg(value) {
    if (value == null)
      return identity$5;
    if (!svgNode)
      svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
    svgNode.setAttribute("transform", value);
    if (!(value = svgNode.transform.baseVal.consolidate()))
      return identity$5;
    value = value.matrix;
    return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
  }
  function interpolateTransform(parse2, pxComma, pxParen, degParen) {
    function pop(s) {
      return s.length ? s.pop() + " " : "";
    }
    function translate(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push("translate(", null, pxComma, null, pxParen);
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb || yb) {
        s.push("translate(" + xb + pxComma + yb + pxParen);
      }
    }
    function rotate(a, b, s, q) {
      if (a !== b) {
        if (a - b > 180)
          b += 360;
        else if (b - a > 180)
          a += 360;
        q.push({ i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "rotate(" + b + degParen);
      }
    }
    function skewX(a, b, s, q) {
      if (a !== b) {
        q.push({ i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "skewX(" + b + degParen);
      }
    }
    function scale(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push(pop(s) + "scale(", null, ",", null, ")");
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb !== 1 || yb !== 1) {
        s.push(pop(s) + "scale(" + xb + "," + yb + ")");
      }
    }
    return function(a, b) {
      var s = [], q = [];
      a = parse2(a), b = parse2(b);
      translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
      rotate(a.rotate, b.rotate, s, q);
      skewX(a.skewX, b.skewX, s, q);
      scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
      a = b = null;
      return function(t) {
        var i2 = -1, n = q.length, o;
        while (++i2 < n)
          s[(o = q[i2]).i] = o.x(t);
        return s.join("");
      };
    };
  }
  var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
  var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
  function hcl(hue2) {
    return function(start2, end2) {
      var h = hue2((start2 = hcl$1(start2)).h, (end2 = hcl$1(end2)).h), c2 = nogamma(start2.c, end2.c), l = nogamma(start2.l, end2.l), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.h = h(t);
        start2.c = c2(t);
        start2.l = l(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    };
  }
  const interpolateHcl = hcl(hue);
  var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f2) {
    setTimeout(f2, 17);
  };
  function now$4() {
    return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
  }
  function clearNow() {
    clockNow = 0;
  }
  function Timer() {
    this._call = this._time = this._next = null;
  }
  Timer.prototype = timer.prototype = {
    constructor: Timer,
    restart: function(callback, delay, time2) {
      if (typeof callback !== "function")
        throw new TypeError("callback is not a function");
      time2 = (time2 == null ? now$4() : +time2) + (delay == null ? 0 : +delay);
      if (!this._next && taskTail !== this) {
        if (taskTail)
          taskTail._next = this;
        else
          taskHead = this;
        taskTail = this;
      }
      this._call = callback;
      this._time = time2;
      sleep();
    },
    stop: function() {
      if (this._call) {
        this._call = null;
        this._time = Infinity;
        sleep();
      }
    }
  };
  function timer(callback, delay, time2) {
    var t = new Timer();
    t.restart(callback, delay, time2);
    return t;
  }
  function timerFlush() {
    now$4();
    ++frame;
    var t = taskHead, e;
    while (t) {
      if ((e = clockNow - t._time) >= 0)
        t._call.call(void 0, e);
      t = t._next;
    }
    --frame;
  }
  function wake() {
    clockNow = (clockLast = clock.now()) + clockSkew;
    frame = timeout$1 = 0;
    try {
      timerFlush();
    } finally {
      frame = 0;
      nap();
      clockNow = 0;
    }
  }
  function poke() {
    var now2 = clock.now(), delay = now2 - clockLast;
    if (delay > pokeDelay)
      clockSkew -= delay, clockLast = now2;
  }
  function nap() {
    var t02, t12 = taskHead, t22, time2 = Infinity;
    while (t12) {
      if (t12._call) {
        if (time2 > t12._time)
          time2 = t12._time;
        t02 = t12, t12 = t12._next;
      } else {
        t22 = t12._next, t12._next = null;
        t12 = t02 ? t02._next = t22 : taskHead = t22;
      }
    }
    taskTail = t02;
    sleep(time2);
  }
  function sleep(time2) {
    if (frame)
      return;
    if (timeout$1)
      timeout$1 = clearTimeout(timeout$1);
    var delay = time2 - clockNow;
    if (delay > 24) {
      if (time2 < Infinity)
        timeout$1 = setTimeout(wake, time2 - clock.now() - clockSkew);
      if (interval)
        interval = clearInterval(interval);
    } else {
      if (!interval)
        clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
      frame = 1, setFrame(wake);
    }
  }
  function timeout(callback, delay, time2) {
    var t = new Timer();
    delay = delay == null ? 0 : +delay;
    t.restart((elapsed) => {
      t.stop();
      callback(elapsed + delay);
    }, delay, time2);
    return t;
  }
  var emptyOn = dispatch("start", "end", "cancel", "interrupt");
  var emptyTween = [];
  var CREATED = 0;
  var SCHEDULED = 1;
  var STARTING = 2;
  var STARTED = 3;
  var RUNNING = 4;
  var ENDING = 5;
  var ENDED = 6;
  function schedule(node2, name2, id2, index, group, timing) {
    var schedules = node2.__transition;
    if (!schedules)
      node2.__transition = {};
    else if (id2 in schedules)
      return;
    create$1(node2, id2, {
      name: name2,
      index,
      group,
      on: emptyOn,
      tween: emptyTween,
      time: timing.time,
      delay: timing.delay,
      duration: timing.duration,
      ease: timing.ease,
      timer: null,
      state: CREATED
    });
  }
  function init$1(node2, id2) {
    var schedule2 = get$4(node2, id2);
    if (schedule2.state > CREATED)
      throw new Error("too late; already scheduled");
    return schedule2;
  }
  function set$4(node2, id2) {
    var schedule2 = get$4(node2, id2);
    if (schedule2.state > STARTED)
      throw new Error("too late; already running");
    return schedule2;
  }
  function get$4(node2, id2) {
    var schedule2 = node2.__transition;
    if (!schedule2 || !(schedule2 = schedule2[id2]))
      throw new Error("transition not found");
    return schedule2;
  }
  function create$1(node2, id2, self2) {
    var schedules = node2.__transition, tween;
    schedules[id2] = self2;
    self2.timer = timer(schedule2, 0, self2.time);
    function schedule2(elapsed) {
      self2.state = SCHEDULED;
      self2.timer.restart(start2, self2.delay, self2.time);
      if (self2.delay <= elapsed)
        start2(elapsed - self2.delay);
    }
    function start2(elapsed) {
      var i2, j, n, o;
      if (self2.state !== SCHEDULED)
        return stop();
      for (i2 in schedules) {
        o = schedules[i2];
        if (o.name !== self2.name)
          continue;
        if (o.state === STARTED)
          return timeout(start2);
        if (o.state === RUNNING) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("interrupt", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        } else if (+i2 < id2) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("cancel", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        }
      }
      timeout(function() {
        if (self2.state === STARTED) {
          self2.state = RUNNING;
          self2.timer.restart(tick, self2.delay, self2.time);
          tick(elapsed);
        }
      });
      self2.state = STARTING;
      self2.on.call("start", node2, node2.__data__, self2.index, self2.group);
      if (self2.state !== STARTING)
        return;
      self2.state = STARTED;
      tween = new Array(n = self2.tween.length);
      for (i2 = 0, j = -1; i2 < n; ++i2) {
        if (o = self2.tween[i2].value.call(node2, node2.__data__, self2.index, self2.group)) {
          tween[++j] = o;
        }
      }
      tween.length = j + 1;
    }
    function tick(elapsed) {
      var t = elapsed < self2.duration ? self2.ease.call(null, elapsed / self2.duration) : (self2.timer.restart(stop), self2.state = ENDING, 1), i2 = -1, n = tween.length;
      while (++i2 < n) {
        tween[i2].call(node2, t);
      }
      if (self2.state === ENDING) {
        self2.on.call("end", node2, node2.__data__, self2.index, self2.group);
        stop();
      }
    }
    function stop() {
      self2.state = ENDED;
      self2.timer.stop();
      delete schedules[id2];
      for (var i2 in schedules)
        return;
      delete node2.__transition;
    }
  }
  function interrupt(node2, name2) {
    var schedules = node2.__transition, schedule2, active, empty2 = true, i2;
    if (!schedules)
      return;
    name2 = name2 == null ? null : name2 + "";
    for (i2 in schedules) {
      if ((schedule2 = schedules[i2]).name !== name2) {
        empty2 = false;
        continue;
      }
      active = schedule2.state > STARTING && schedule2.state < ENDING;
      schedule2.state = ENDED;
      schedule2.timer.stop();
      schedule2.on.call(active ? "interrupt" : "cancel", node2, node2.__data__, schedule2.index, schedule2.group);
      delete schedules[i2];
    }
    if (empty2)
      delete node2.__transition;
  }
  function selection_interrupt(name2) {
    return this.each(function() {
      interrupt(this, name2);
    });
  }
  function tweenRemove(id2, name2) {
    var tween0, tween1;
    return function() {
      var schedule2 = set$4(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = tween0 = tween;
        for (var i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name2) {
            tween1 = tween1.slice();
            tween1.splice(i2, 1);
            break;
          }
        }
      }
      schedule2.tween = tween1;
    };
  }
  function tweenFunction(id2, name2, value) {
    var tween0, tween1;
    if (typeof value !== "function")
      throw new Error();
    return function() {
      var schedule2 = set$4(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = (tween0 = tween).slice();
        for (var t = { name: name2, value }, i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name2) {
            tween1[i2] = t;
            break;
          }
        }
        if (i2 === n)
          tween1.push(t);
      }
      schedule2.tween = tween1;
    };
  }
  function transition_tween(name2, value) {
    var id2 = this._id;
    name2 += "";
    if (arguments.length < 2) {
      var tween = get$4(this.node(), id2).tween;
      for (var i2 = 0, n = tween.length, t; i2 < n; ++i2) {
        if ((t = tween[i2]).name === name2) {
          return t.value;
        }
      }
      return null;
    }
    return this.each((value == null ? tweenRemove : tweenFunction)(id2, name2, value));
  }
  function tweenValue(transition, name2, value) {
    var id2 = transition._id;
    transition.each(function() {
      var schedule2 = set$4(this, id2);
      (schedule2.value || (schedule2.value = {}))[name2] = value.apply(this, arguments);
    });
    return function(node2) {
      return get$4(node2, id2).value[name2];
    };
  }
  function interpolate(a, b) {
    var c2;
    return (typeof b === "number" ? interpolateNumber : b instanceof color ? interpolateRgb : (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString)(a, b);
  }
  function attrRemove(name2) {
    return function() {
      this.removeAttribute(name2);
    };
  }
  function attrRemoveNS(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant(name2, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttribute(name2);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrConstantNS(fullname, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttributeNS(fullname.space, fullname.local);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrFunction(name2, interpolate2, value) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value(this), string1;
      if (value1 == null)
        return void this.removeAttribute(name2);
      string0 = this.getAttribute(name2);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function attrFunctionNS(fullname, interpolate2, value) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value(this), string1;
      if (value1 == null)
        return void this.removeAttributeNS(fullname.space, fullname.local);
      string0 = this.getAttributeNS(fullname.space, fullname.local);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function transition_attr(name2, value) {
    var fullname = namespace(name2), i2 = fullname === "transform" ? interpolateTransformSvg : interpolate;
    return this.attrTween(name2, typeof value === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i2, tweenValue(this, "attr." + name2, value)) : value == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i2, value));
  }
  function attrInterpolate(name2, i2) {
    return function(t) {
      this.setAttribute(name2, i2.call(this, t));
    };
  }
  function attrInterpolateNS(fullname, i2) {
    return function(t) {
      this.setAttributeNS(fullname.space, fullname.local, i2.call(this, t));
    };
  }
  function attrTweenNS(fullname, value) {
    var t02, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolateNS(fullname, i2);
      return t02;
    }
    tween._value = value;
    return tween;
  }
  function attrTween(name2, value) {
    var t02, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolate(name2, i2);
      return t02;
    }
    tween._value = value;
    return tween;
  }
  function transition_attrTween(name2, value) {
    var key = "attr." + name2;
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value == null)
      return this.tween(key, null);
    if (typeof value !== "function")
      throw new Error();
    var fullname = namespace(name2);
    return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value));
  }
  function delayFunction(id2, value) {
    return function() {
      init$1(this, id2).delay = +value.apply(this, arguments);
    };
  }
  function delayConstant(id2, value) {
    return value = +value, function() {
      init$1(this, id2).delay = value;
    };
  }
  function transition_delay(value) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value === "function" ? delayFunction : delayConstant)(id2, value)) : get$4(this.node(), id2).delay;
  }
  function durationFunction(id2, value) {
    return function() {
      set$4(this, id2).duration = +value.apply(this, arguments);
    };
  }
  function durationConstant(id2, value) {
    return value = +value, function() {
      set$4(this, id2).duration = value;
    };
  }
  function transition_duration(value) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value === "function" ? durationFunction : durationConstant)(id2, value)) : get$4(this.node(), id2).duration;
  }
  function easeConstant(id2, value) {
    if (typeof value !== "function")
      throw new Error();
    return function() {
      set$4(this, id2).ease = value;
    };
  }
  function transition_ease(value) {
    var id2 = this._id;
    return arguments.length ? this.each(easeConstant(id2, value)) : get$4(this.node(), id2).ease;
  }
  function easeVarying(id2, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (typeof v !== "function")
        throw new Error();
      set$4(this, id2).ease = v;
    };
  }
  function transition_easeVarying(value) {
    if (typeof value !== "function")
      throw new Error();
    return this.each(easeVarying(this._id, value));
  }
  function transition_filter(match5) {
    if (typeof match5 !== "function")
      match5 = matcher(match5);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match5.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Transition(subgroups, this._parents, this._name, this._id);
  }
  function transition_merge(transition) {
    if (transition._id !== this._id)
      throw new Error();
    for (var groups0 = this._groups, groups1 = transition._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Transition(merges, this._parents, this._name, this._id);
  }
  function start$1(name2) {
    return (name2 + "").trim().split(/^|\s+/).every(function(t) {
      var i2 = t.indexOf(".");
      if (i2 >= 0)
        t = t.slice(0, i2);
      return !t || t === "start";
    });
  }
  function onFunction(id2, name2, listener) {
    var on0, on1, sit = start$1(name2) ? init$1 : set$4;
    return function() {
      var schedule2 = sit(this, id2), on = schedule2.on;
      if (on !== on0)
        (on1 = (on0 = on).copy()).on(name2, listener);
      schedule2.on = on1;
    };
  }
  function transition_on(name2, listener) {
    var id2 = this._id;
    return arguments.length < 2 ? get$4(this.node(), id2).on.on(name2) : this.each(onFunction(id2, name2, listener));
  }
  function removeFunction(id2) {
    return function() {
      var parent = this.parentNode;
      for (var i2 in this.__transition)
        if (+i2 !== id2)
          return;
      if (parent)
        parent.removeChild(this);
    };
  }
  function transition_remove() {
    return this.on("end.remove", removeFunction(this._id));
  }
  function transition_select(select2) {
    var name2 = this._name, id2 = this._id;
    if (typeof select2 !== "function")
      select2 = selector(select2);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select2.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
          schedule(subgroup[i2], name2, id2, i2, subgroup, get$4(node2, id2));
        }
      }
    }
    return new Transition(subgroups, this._parents, name2, id2);
  }
  function transition_selectAll(select2) {
    var name2 = this._name, id2 = this._id;
    if (typeof select2 !== "function")
      select2 = selectorAll(select2);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          for (var children2 = select2.call(node2, node2.__data__, i2, group), child, inherit2 = get$4(node2, id2), k = 0, l = children2.length; k < l; ++k) {
            if (child = children2[k]) {
              schedule(child, name2, id2, k, children2, inherit2);
            }
          }
          subgroups.push(children2);
          parents2.push(node2);
        }
      }
    }
    return new Transition(subgroups, parents2, name2, id2);
  }
  var Selection = selection.prototype.constructor;
  function transition_selection() {
    return new Selection(this._groups, this._parents);
  }
  function styleNull(name2, interpolate2) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name2), string1 = (this.style.removeProperty(name2), styleValue(this, name2));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
    };
  }
  function styleRemove(name2) {
    return function() {
      this.style.removeProperty(name2);
    };
  }
  function styleConstant(name2, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = styleValue(this, name2);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function styleFunction(name2, interpolate2, value) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name2), value1 = value(this), string1 = value1 + "";
      if (value1 == null)
        string1 = value1 = (this.style.removeProperty(name2), styleValue(this, name2));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function styleMaybeRemove(id2, name2) {
    var on0, on1, listener0, key = "style." + name2, event2 = "end." + key, remove2;
    return function() {
      var schedule2 = set$4(this, id2), on = schedule2.on, listener = schedule2.value[key] == null ? remove2 || (remove2 = styleRemove(name2)) : void 0;
      if (on !== on0 || listener0 !== listener)
        (on1 = (on0 = on).copy()).on(event2, listener0 = listener);
      schedule2.on = on1;
    };
  }
  function transition_style(name2, value, priority) {
    var i2 = (name2 += "") === "transform" ? interpolateTransformCss : interpolate;
    return value == null ? this.styleTween(name2, styleNull(name2, i2)).on("end.style." + name2, styleRemove(name2)) : typeof value === "function" ? this.styleTween(name2, styleFunction(name2, i2, tweenValue(this, "style." + name2, value))).each(styleMaybeRemove(this._id, name2)) : this.styleTween(name2, styleConstant(name2, i2, value), priority).on("end.style." + name2, null);
  }
  function styleInterpolate(name2, i2, priority) {
    return function(t) {
      this.style.setProperty(name2, i2.call(this, t), priority);
    };
  }
  function styleTween(name2, value, priority) {
    var t, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t = (i0 = i2) && styleInterpolate(name2, i2, priority);
      return t;
    }
    tween._value = value;
    return tween;
  }
  function transition_styleTween(name2, value, priority) {
    var key = "style." + (name2 += "");
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value == null)
      return this.tween(key, null);
    if (typeof value !== "function")
      throw new Error();
    return this.tween(key, styleTween(name2, value, priority == null ? "" : priority));
  }
  function textConstant(value) {
    return function() {
      this.textContent = value;
    };
  }
  function textFunction(value) {
    return function() {
      var value1 = value(this);
      this.textContent = value1 == null ? "" : value1;
    };
  }
  function transition_text(value) {
    return this.tween("text", typeof value === "function" ? textFunction(tweenValue(this, "text", value)) : textConstant(value == null ? "" : value + ""));
  }
  function textInterpolate(i2) {
    return function(t) {
      this.textContent = i2.call(this, t);
    };
  }
  function textTween(value) {
    var t02, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && textInterpolate(i2);
      return t02;
    }
    tween._value = value;
    return tween;
  }
  function transition_textTween(value) {
    var key = "text";
    if (arguments.length < 1)
      return (key = this.tween(key)) && key._value;
    if (value == null)
      return this.tween(key, null);
    if (typeof value !== "function")
      throw new Error();
    return this.tween(key, textTween(value));
  }
  function transition_transition() {
    var name2 = this._name, id0 = this._id, id1 = newId();
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          var inherit2 = get$4(node2, id0);
          schedule(node2, name2, id1, i2, group, {
            time: inherit2.time + inherit2.delay + inherit2.duration,
            delay: 0,
            duration: inherit2.duration,
            ease: inherit2.ease
          });
        }
      }
    }
    return new Transition(groups, this._parents, name2, id1);
  }
  function transition_end() {
    var on0, on1, that = this, id2 = that._id, size2 = that.size();
    return new Promise(function(resolve2, reject) {
      var cancel = { value: reject }, end2 = { value: function() {
        if (--size2 === 0)
          resolve2();
      } };
      that.each(function() {
        var schedule2 = set$4(this, id2), on = schedule2.on;
        if (on !== on0) {
          on1 = (on0 = on).copy();
          on1._.cancel.push(cancel);
          on1._.interrupt.push(cancel);
          on1._.end.push(end2);
        }
        schedule2.on = on1;
      });
      if (size2 === 0)
        resolve2();
    });
  }
  var id$3 = 0;
  function Transition(groups, parents2, name2, id2) {
    this._groups = groups;
    this._parents = parents2;
    this._name = name2;
    this._id = id2;
  }
  function newId() {
    return ++id$3;
  }
  var selection_prototype = selection.prototype;
  Transition.prototype = {
    constructor: Transition,
    select: transition_select,
    selectAll: transition_selectAll,
    selectChild: selection_prototype.selectChild,
    selectChildren: selection_prototype.selectChildren,
    filter: transition_filter,
    merge: transition_merge,
    selection: transition_selection,
    transition: transition_transition,
    call: selection_prototype.call,
    nodes: selection_prototype.nodes,
    node: selection_prototype.node,
    size: selection_prototype.size,
    empty: selection_prototype.empty,
    each: selection_prototype.each,
    on: transition_on,
    attr: transition_attr,
    attrTween: transition_attrTween,
    style: transition_style,
    styleTween: transition_styleTween,
    text: transition_text,
    textTween: transition_textTween,
    remove: transition_remove,
    tween: transition_tween,
    delay: transition_delay,
    duration: transition_duration,
    ease: transition_ease,
    easeVarying: transition_easeVarying,
    end: transition_end,
    [Symbol.iterator]: selection_prototype[Symbol.iterator]
  };
  function cubicInOut(t) {
    return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
  }
  var defaultTiming = {
    time: null,
    delay: 0,
    duration: 250,
    ease: cubicInOut
  };
  function inherit(node2, id2) {
    var timing;
    while (!(timing = node2.__transition) || !(timing = timing[id2])) {
      if (!(node2 = node2.parentNode)) {
        throw new Error(`transition ${id2} not found`);
      }
    }
    return timing;
  }
  function selection_transition(name2) {
    var id2, timing;
    if (name2 instanceof Transition) {
      id2 = name2._id, name2 = name2._name;
    } else {
      id2 = newId(), (timing = defaultTiming).time = now$4(), name2 = name2 == null ? null : name2 + "";
    }
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          schedule(node2, name2, id2, i2, group, timing || inherit(node2, id2));
        }
      }
    }
    return new Transition(groups, this._parents, name2, id2);
  }
  selection.prototype.interrupt = selection_interrupt;
  selection.prototype.transition = selection_transition;
  const pi$1 = Math.PI, tau$1 = 2 * pi$1, epsilon$1 = 1e-6, tauEpsilon = tau$1 - epsilon$1;
  function Path() {
    this._x0 = this._y0 = this._x1 = this._y1 = null;
    this._ = "";
  }
  function path() {
    return new Path();
  }
  Path.prototype = path.prototype = {
    constructor: Path,
    moveTo: function(x2, y2) {
      this._ += "M" + (this._x0 = this._x1 = +x2) + "," + (this._y0 = this._y1 = +y2);
    },
    closePath: function() {
      if (this._x1 !== null) {
        this._x1 = this._x0, this._y1 = this._y0;
        this._ += "Z";
      }
    },
    lineTo: function(x2, y2) {
      this._ += "L" + (this._x1 = +x2) + "," + (this._y1 = +y2);
    },
    quadraticCurveTo: function(x1, y1, x2, y2) {
      this._ += "Q" + +x1 + "," + +y1 + "," + (this._x1 = +x2) + "," + (this._y1 = +y2);
    },
    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
      this._ += "C" + +x1 + "," + +y1 + "," + +x2 + "," + +y2 + "," + (this._x1 = +x3) + "," + (this._y1 = +y3);
    },
    arcTo: function(x1, y1, x2, y2, r) {
      x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
      var x0 = this._x1, y0 = this._y1, x21 = x2 - x1, y21 = y2 - y1, x01 = x0 - x1, y01 = y0 - y1, l01_2 = x01 * x01 + y01 * y01;
      if (r < 0)
        throw new Error("negative radius: " + r);
      if (this._x1 === null) {
        this._ += "M" + (this._x1 = x1) + "," + (this._y1 = y1);
      } else if (!(l01_2 > epsilon$1))
        ;
      else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon$1) || !r) {
        this._ += "L" + (this._x1 = x1) + "," + (this._y1 = y1);
      } else {
        var x20 = x2 - x0, y20 = y2 - y0, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi$1 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
        if (Math.abs(t01 - 1) > epsilon$1) {
          this._ += "L" + (x1 + t01 * x01) + "," + (y1 + t01 * y01);
        }
        this._ += "A" + r + "," + r + ",0,0," + +(y01 * x20 > x01 * y20) + "," + (this._x1 = x1 + t21 * x21) + "," + (this._y1 = y1 + t21 * y21);
      }
    },
    arc: function(x2, y2, r, a0, a1, ccw) {
      x2 = +x2, y2 = +y2, r = +r, ccw = !!ccw;
      var dx = r * Math.cos(a0), dy = r * Math.sin(a0), x0 = x2 + dx, y0 = y2 + dy, cw = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
      if (r < 0)
        throw new Error("negative radius: " + r);
      if (this._x1 === null) {
        this._ += "M" + x0 + "," + y0;
      } else if (Math.abs(this._x1 - x0) > epsilon$1 || Math.abs(this._y1 - y0) > epsilon$1) {
        this._ += "L" + x0 + "," + y0;
      }
      if (!r)
        return;
      if (da < 0)
        da = da % tau$1 + tau$1;
      if (da > tauEpsilon) {
        this._ += "A" + r + "," + r + ",0,1," + cw + "," + (x2 - dx) + "," + (y2 - dy) + "A" + r + "," + r + ",0,1," + cw + "," + (this._x1 = x0) + "," + (this._y1 = y0);
      } else if (da > epsilon$1) {
        this._ += "A" + r + "," + r + ",0," + +(da >= pi$1) + "," + cw + "," + (this._x1 = x2 + r * Math.cos(a1)) + "," + (this._y1 = y2 + r * Math.sin(a1));
      }
    },
    rect: function(x2, y2, w2, h) {
      this._ += "M" + (this._x0 = this._x1 = +x2) + "," + (this._y0 = this._y1 = +y2) + "h" + +w2 + "v" + +h + "h" + -w2 + "Z";
    },
    toString: function() {
      return this._;
    }
  };
  function responseText(response) {
    if (!response.ok)
      throw new Error(response.status + " " + response.statusText);
    return response.text();
  }
  function text$1(input, init2) {
    return fetch(input, init2).then(responseText);
  }
  function parser$g(type2) {
    return (input, init2) => text$1(input, init2).then((text2) => new DOMParser().parseFromString(text2, type2));
  }
  var svg$2 = parser$g("image/svg+xml");
  function formatDecimal(x2) {
    return Math.abs(x2 = Math.round(x2)) >= 1e21 ? x2.toLocaleString("en").replace(/,/g, "") : x2.toString(10);
  }
  function formatDecimalParts(x2, p2) {
    if ((i2 = (x2 = p2 ? x2.toExponential(p2 - 1) : x2.toExponential()).indexOf("e")) < 0)
      return null;
    var i2, coefficient = x2.slice(0, i2);
    return [
      coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
      +x2.slice(i2 + 1)
    ];
  }
  function exponent(x2) {
    return x2 = formatDecimalParts(Math.abs(x2)), x2 ? x2[1] : NaN;
  }
  function formatGroup(grouping, thousands) {
    return function(value, width2) {
      var i2 = value.length, t = [], j = 0, g = grouping[0], length2 = 0;
      while (i2 > 0 && g > 0) {
        if (length2 + g + 1 > width2)
          g = Math.max(1, width2 - length2);
        t.push(value.substring(i2 -= g, i2 + g));
        if ((length2 += g + 1) > width2)
          break;
        g = grouping[j = (j + 1) % grouping.length];
      }
      return t.reverse().join(thousands);
    };
  }
  function formatNumerals(numerals) {
    return function(value) {
      return value.replace(/[0-9]/g, function(i2) {
        return numerals[+i2];
      });
    };
  }
  var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
  function formatSpecifier(specifier) {
    if (!(match5 = re.exec(specifier)))
      throw new Error("invalid format: " + specifier);
    var match5;
    return new FormatSpecifier({
      fill: match5[1],
      align: match5[2],
      sign: match5[3],
      symbol: match5[4],
      zero: match5[5],
      width: match5[6],
      comma: match5[7],
      precision: match5[8] && match5[8].slice(1),
      trim: match5[9],
      type: match5[10]
    });
  }
  formatSpecifier.prototype = FormatSpecifier.prototype;
  function FormatSpecifier(specifier) {
    this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
    this.align = specifier.align === void 0 ? ">" : specifier.align + "";
    this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
    this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
    this.zero = !!specifier.zero;
    this.width = specifier.width === void 0 ? void 0 : +specifier.width;
    this.comma = !!specifier.comma;
    this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
    this.trim = !!specifier.trim;
    this.type = specifier.type === void 0 ? "" : specifier.type + "";
  }
  FormatSpecifier.prototype.toString = function() {
    return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
  };
  function formatTrim(s) {
    out:
      for (var n = s.length, i2 = 1, i0 = -1, i1; i2 < n; ++i2) {
        switch (s[i2]) {
          case ".":
            i0 = i1 = i2;
            break;
          case "0":
            if (i0 === 0)
              i0 = i2;
            i1 = i2;
            break;
          default:
            if (!+s[i2])
              break out;
            if (i0 > 0)
              i0 = 0;
            break;
        }
      }
    return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
  }
  var prefixExponent;
  function formatPrefixAuto(x2, p2) {
    var d = formatDecimalParts(x2, p2);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1], i2 = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
    return i2 === n ? coefficient : i2 > n ? coefficient + new Array(i2 - n + 1).join("0") : i2 > 0 ? coefficient.slice(0, i2) + "." + coefficient.slice(i2) : "0." + new Array(1 - i2).join("0") + formatDecimalParts(x2, Math.max(0, p2 + i2 - 1))[0];
  }
  function formatRounded(x2, p2) {
    var d = formatDecimalParts(x2, p2);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1];
    return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
  }
  const formatTypes = {
    "%": (x2, p2) => (x2 * 100).toFixed(p2),
    "b": (x2) => Math.round(x2).toString(2),
    "c": (x2) => x2 + "",
    "d": formatDecimal,
    "e": (x2, p2) => x2.toExponential(p2),
    "f": (x2, p2) => x2.toFixed(p2),
    "g": (x2, p2) => x2.toPrecision(p2),
    "o": (x2) => Math.round(x2).toString(8),
    "p": (x2, p2) => formatRounded(x2 * 100, p2),
    "r": formatRounded,
    "s": formatPrefixAuto,
    "X": (x2) => Math.round(x2).toString(16).toUpperCase(),
    "x": (x2) => Math.round(x2).toString(16)
  };
  function identity$4(x2) {
    return x2;
  }
  var map$2 = Array.prototype.map, prefixes = ["y", "z", "a", "f", "p", "n", "\xB5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
  function formatLocale$1(locale2) {
    var group = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity$4 : formatGroup(map$2.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity$4 : formatNumerals(map$2.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "\u2212" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
    function newFormat(specifier) {
      specifier = formatSpecifier(specifier);
      var fill = specifier.fill, align = specifier.align, sign2 = specifier.sign, symbol = specifier.symbol, zero2 = specifier.zero, width2 = specifier.width, comma = specifier.comma, precision = specifier.precision, trim2 = specifier.trim, type2 = specifier.type;
      if (type2 === "n")
        comma = true, type2 = "g";
      else if (!formatTypes[type2])
        precision === void 0 && (precision = 12), trim2 = true, type2 = "g";
      if (zero2 || fill === "0" && align === "=")
        zero2 = true, fill = "0", align = "=";
      var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
      var formatType = formatTypes[type2], maybeSuffix = /[defgprs%]/.test(type2);
      precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
      function format2(value) {
        var valuePrefix = prefix, valueSuffix = suffix, i2, n, c2;
        if (type2 === "c") {
          valueSuffix = formatType(value) + valueSuffix;
          value = "";
        } else {
          value = +value;
          var valueNegative = value < 0 || 1 / value < 0;
          value = isNaN(value) ? nan : formatType(Math.abs(value), precision);
          if (trim2)
            value = formatTrim(value);
          if (valueNegative && +value === 0 && sign2 !== "+")
            valueNegative = false;
          valuePrefix = (valueNegative ? sign2 === "(" ? sign2 : minus : sign2 === "-" || sign2 === "(" ? "" : sign2) + valuePrefix;
          valueSuffix = (type2 === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign2 === "(" ? ")" : "");
          if (maybeSuffix) {
            i2 = -1, n = value.length;
            while (++i2 < n) {
              if (c2 = value.charCodeAt(i2), 48 > c2 || c2 > 57) {
                valueSuffix = (c2 === 46 ? decimal + value.slice(i2 + 1) : value.slice(i2)) + valueSuffix;
                value = value.slice(0, i2);
                break;
              }
            }
          }
        }
        if (comma && !zero2)
          value = group(value, Infinity);
        var length2 = valuePrefix.length + value.length + valueSuffix.length, padding2 = length2 < width2 ? new Array(width2 - length2 + 1).join(fill) : "";
        if (comma && zero2)
          value = group(padding2 + value, padding2.length ? width2 - valueSuffix.length : Infinity), padding2 = "";
        switch (align) {
          case "<":
            value = valuePrefix + value + valueSuffix + padding2;
            break;
          case "=":
            value = valuePrefix + padding2 + value + valueSuffix;
            break;
          case "^":
            value = padding2.slice(0, length2 = padding2.length >> 1) + valuePrefix + value + valueSuffix + padding2.slice(length2);
            break;
          default:
            value = padding2 + valuePrefix + value + valueSuffix;
            break;
        }
        return numerals(value);
      }
      format2.toString = function() {
        return specifier + "";
      };
      return format2;
    }
    function formatPrefix2(specifier, value) {
      var f2 = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
      return function(value2) {
        return f2(k * value2) + prefix;
      };
    }
    return {
      format: newFormat,
      formatPrefix: formatPrefix2
    };
  }
  var locale$1;
  var format;
  var formatPrefix;
  defaultLocale$1({
    thousands: ",",
    grouping: [3],
    currency: ["$", ""]
  });
  function defaultLocale$1(definition) {
    locale$1 = formatLocale$1(definition);
    format = locale$1.format;
    formatPrefix = locale$1.formatPrefix;
    return locale$1;
  }
  function precisionFixed(step2) {
    return Math.max(0, -exponent(Math.abs(step2)));
  }
  function precisionPrefix(step2, value) {
    return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3 - exponent(Math.abs(step2)));
  }
  function precisionRound(step2, max2) {
    step2 = Math.abs(step2), max2 = Math.abs(max2) - step2;
    return Math.max(0, exponent(max2) - exponent(step2)) + 1;
  }
  function initRange(domain, range2) {
    switch (arguments.length) {
      case 0:
        break;
      case 1:
        this.range(domain);
        break;
      default:
        this.range(range2).domain(domain);
        break;
    }
    return this;
  }
  const implicit = Symbol("implicit");
  function ordinal() {
    var index = new InternMap(), domain = [], range2 = [], unknown = implicit;
    function scale(d) {
      let i2 = index.get(d);
      if (i2 === void 0) {
        if (unknown !== implicit)
          return unknown;
        index.set(d, i2 = domain.push(d) - 1);
      }
      return range2[i2 % range2.length];
    }
    scale.domain = function(_2) {
      if (!arguments.length)
        return domain.slice();
      domain = [], index = new InternMap();
      for (const value of _2) {
        if (index.has(value))
          continue;
        index.set(value, domain.push(value) - 1);
      }
      return scale;
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), scale) : range2.slice();
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    scale.copy = function() {
      return ordinal(domain, range2).unknown(unknown);
    };
    initRange.apply(scale, arguments);
    return scale;
  }
  function constants(x2) {
    return function() {
      return x2;
    };
  }
  function number$3(x2) {
    return +x2;
  }
  var unit$1 = [0, 1];
  function identity$3(x2) {
    return x2;
  }
  function normalize$1(a, b) {
    return (b -= a = +a) ? function(x2) {
      return (x2 - a) / b;
    } : constants(isNaN(b) ? NaN : 0.5);
  }
  function clamper(a, b) {
    var t;
    if (a > b)
      t = a, a = b, b = t;
    return function(x2) {
      return Math.max(a, Math.min(b, x2));
    };
  }
  function bimap(domain, range2, interpolate2) {
    var d0 = domain[0], d1 = domain[1], r0 = range2[0], r1 = range2[1];
    if (d1 < d0)
      d0 = normalize$1(d1, d0), r0 = interpolate2(r1, r0);
    else
      d0 = normalize$1(d0, d1), r0 = interpolate2(r0, r1);
    return function(x2) {
      return r0(d0(x2));
    };
  }
  function polymap(domain, range2, interpolate2) {
    var j = Math.min(domain.length, range2.length) - 1, d = new Array(j), r = new Array(j), i2 = -1;
    if (domain[j] < domain[0]) {
      domain = domain.slice().reverse();
      range2 = range2.slice().reverse();
    }
    while (++i2 < j) {
      d[i2] = normalize$1(domain[i2], domain[i2 + 1]);
      r[i2] = interpolate2(range2[i2], range2[i2 + 1]);
    }
    return function(x2) {
      var i3 = bisect(domain, x2, 1, j) - 1;
      return r[i3](d[i3](x2));
    };
  }
  function copy$2(source, target) {
    return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp()).unknown(source.unknown());
  }
  function transformer() {
    var domain = unit$1, range2 = unit$1, interpolate2 = interpolate$1, transform, untransform, unknown, clamp = identity$3, piecewise, output2, input;
    function rescale() {
      var n = Math.min(domain.length, range2.length);
      if (clamp !== identity$3)
        clamp = clamper(domain[0], domain[n - 1]);
      piecewise = n > 2 ? polymap : bimap;
      output2 = input = null;
      return scale;
    }
    function scale(x2) {
      return x2 == null || isNaN(x2 = +x2) ? unknown : (output2 || (output2 = piecewise(domain.map(transform), range2, interpolate2)))(transform(clamp(x2)));
    }
    scale.invert = function(y2) {
      return clamp(untransform((input || (input = piecewise(range2, domain.map(transform), interpolateNumber)))(y2)));
    };
    scale.domain = function(_2) {
      return arguments.length ? (domain = Array.from(_2, number$3), rescale()) : domain.slice();
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), rescale()) : range2.slice();
    };
    scale.rangeRound = function(_2) {
      return range2 = Array.from(_2), interpolate2 = interpolateRound, rescale();
    };
    scale.clamp = function(_2) {
      return arguments.length ? (clamp = _2 ? true : identity$3, rescale()) : clamp !== identity$3;
    };
    scale.interpolate = function(_2) {
      return arguments.length ? (interpolate2 = _2, rescale()) : interpolate2;
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    return function(t, u) {
      transform = t, untransform = u;
      return rescale();
    };
  }
  function continuous() {
    return transformer()(identity$3, identity$3);
  }
  function tickFormat(start2, stop, count, specifier) {
    var step2 = tickStep(start2, stop, count), precision;
    specifier = formatSpecifier(specifier == null ? ",f" : specifier);
    switch (specifier.type) {
      case "s": {
        var value = Math.max(Math.abs(start2), Math.abs(stop));
        if (specifier.precision == null && !isNaN(precision = precisionPrefix(step2, value)))
          specifier.precision = precision;
        return formatPrefix(specifier, value);
      }
      case "":
      case "e":
      case "g":
      case "p":
      case "r": {
        if (specifier.precision == null && !isNaN(precision = precisionRound(step2, Math.max(Math.abs(start2), Math.abs(stop)))))
          specifier.precision = precision - (specifier.type === "e");
        break;
      }
      case "f":
      case "%": {
        if (specifier.precision == null && !isNaN(precision = precisionFixed(step2)))
          specifier.precision = precision - (specifier.type === "%") * 2;
        break;
      }
    }
    return format(specifier);
  }
  function linearish(scale) {
    var domain = scale.domain;
    scale.ticks = function(count) {
      var d = domain();
      return ticks(d[0], d[d.length - 1], count == null ? 10 : count);
    };
    scale.tickFormat = function(count, specifier) {
      var d = domain();
      return tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
    };
    scale.nice = function(count) {
      if (count == null)
        count = 10;
      var d = domain();
      var i0 = 0;
      var i1 = d.length - 1;
      var start2 = d[i0];
      var stop = d[i1];
      var prestep;
      var step2;
      var maxIter = 10;
      if (stop < start2) {
        step2 = start2, start2 = stop, stop = step2;
        step2 = i0, i0 = i1, i1 = step2;
      }
      while (maxIter-- > 0) {
        step2 = tickIncrement(start2, stop, count);
        if (step2 === prestep) {
          d[i0] = start2;
          d[i1] = stop;
          return domain(d);
        } else if (step2 > 0) {
          start2 = Math.floor(start2 / step2) * step2;
          stop = Math.ceil(stop / step2) * step2;
        } else if (step2 < 0) {
          start2 = Math.ceil(start2 * step2) / step2;
          stop = Math.floor(stop * step2) / step2;
        } else {
          break;
        }
        prestep = step2;
      }
      return scale;
    };
    return scale;
  }
  function linear() {
    var scale = continuous();
    scale.copy = function() {
      return copy$2(scale, linear());
    };
    initRange.apply(scale, arguments);
    return linearish(scale);
  }
  function nice(domain, interval2) {
    domain = domain.slice();
    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], t;
    if (x1 < x0) {
      t = i0, i0 = i1, i1 = t;
      t = x0, x0 = x1, x1 = t;
    }
    domain[i0] = interval2.floor(x0);
    domain[i1] = interval2.ceil(x1);
    return domain;
  }
  var t0 = new Date(), t1 = new Date();
  function newInterval(floori, offseti, count, field) {
    function interval2(date2) {
      return floori(date2 = arguments.length === 0 ? new Date() : new Date(+date2)), date2;
    }
    interval2.floor = function(date2) {
      return floori(date2 = new Date(+date2)), date2;
    };
    interval2.ceil = function(date2) {
      return floori(date2 = new Date(date2 - 1)), offseti(date2, 1), floori(date2), date2;
    };
    interval2.round = function(date2) {
      var d0 = interval2(date2), d1 = interval2.ceil(date2);
      return date2 - d0 < d1 - date2 ? d0 : d1;
    };
    interval2.offset = function(date2, step2) {
      return offseti(date2 = new Date(+date2), step2 == null ? 1 : Math.floor(step2)), date2;
    };
    interval2.range = function(start2, stop, step2) {
      var range2 = [], previous;
      start2 = interval2.ceil(start2);
      step2 = step2 == null ? 1 : Math.floor(step2);
      if (!(start2 < stop) || !(step2 > 0))
        return range2;
      do
        range2.push(previous = new Date(+start2)), offseti(start2, step2), floori(start2);
      while (previous < start2 && start2 < stop);
      return range2;
    };
    interval2.filter = function(test) {
      return newInterval(function(date2) {
        if (date2 >= date2)
          while (floori(date2), !test(date2))
            date2.setTime(date2 - 1);
      }, function(date2, step2) {
        if (date2 >= date2) {
          if (step2 < 0)
            while (++step2 <= 0) {
              while (offseti(date2, -1), !test(date2)) {
              }
            }
          else
            while (--step2 >= 0) {
              while (offseti(date2, 1), !test(date2)) {
              }
            }
        }
      });
    };
    if (count) {
      interval2.count = function(start2, end2) {
        t0.setTime(+start2), t1.setTime(+end2);
        floori(t0), floori(t1);
        return Math.floor(count(t0, t1));
      };
      interval2.every = function(step2) {
        step2 = Math.floor(step2);
        return !isFinite(step2) || !(step2 > 0) ? null : !(step2 > 1) ? interval2 : interval2.filter(field ? function(d) {
          return field(d) % step2 === 0;
        } : function(d) {
          return interval2.count(0, d) % step2 === 0;
        });
      };
    }
    return interval2;
  }
  var millisecond = newInterval(function() {
  }, function(date2, step2) {
    date2.setTime(+date2 + step2);
  }, function(start2, end2) {
    return end2 - start2;
  });
  millisecond.every = function(k) {
    k = Math.floor(k);
    if (!isFinite(k) || !(k > 0))
      return null;
    if (!(k > 1))
      return millisecond;
    return newInterval(function(date2) {
      date2.setTime(Math.floor(date2 / k) * k);
    }, function(date2, step2) {
      date2.setTime(+date2 + step2 * k);
    }, function(start2, end2) {
      return (end2 - start2) / k;
    });
  };
  const millisecond$1 = millisecond;
  millisecond.range;
  const durationSecond = 1e3;
  const durationMinute = durationSecond * 60;
  const durationHour = durationMinute * 60;
  const durationDay = durationHour * 24;
  const durationWeek = durationDay * 7;
  const durationMonth = durationDay * 30;
  const durationYear = durationDay * 365;
  var second = newInterval(function(date2) {
    date2.setTime(date2 - date2.getMilliseconds());
  }, function(date2, step2) {
    date2.setTime(+date2 + step2 * durationSecond);
  }, function(start2, end2) {
    return (end2 - start2) / durationSecond;
  }, function(date2) {
    return date2.getUTCSeconds();
  });
  const utcSecond = second;
  second.range;
  var minute = newInterval(function(date2) {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond);
  }, function(date2, step2) {
    date2.setTime(+date2 + step2 * durationMinute);
  }, function(start2, end2) {
    return (end2 - start2) / durationMinute;
  }, function(date2) {
    return date2.getMinutes();
  });
  const timeMinute = minute;
  minute.range;
  var hour = newInterval(function(date2) {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond - date2.getMinutes() * durationMinute);
  }, function(date2, step2) {
    date2.setTime(+date2 + step2 * durationHour);
  }, function(start2, end2) {
    return (end2 - start2) / durationHour;
  }, function(date2) {
    return date2.getHours();
  });
  const timeHour = hour;
  hour.range;
  var day = newInterval(
    (date2) => date2.setHours(0, 0, 0, 0),
    (date2, step2) => date2.setDate(date2.getDate() + step2),
    (start2, end2) => (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationDay,
    (date2) => date2.getDate() - 1
  );
  const timeDay = day;
  day.range;
  function weekday(i2) {
    return newInterval(function(date2) {
      date2.setDate(date2.getDate() - (date2.getDay() + 7 - i2) % 7);
      date2.setHours(0, 0, 0, 0);
    }, function(date2, step2) {
      date2.setDate(date2.getDate() + step2 * 7);
    }, function(start2, end2) {
      return (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationWeek;
    });
  }
  var sunday = weekday(0);
  var monday = weekday(1);
  var tuesday = weekday(2);
  var wednesday = weekday(3);
  var thursday = weekday(4);
  var friday = weekday(5);
  var saturday = weekday(6);
  sunday.range;
  monday.range;
  tuesday.range;
  wednesday.range;
  thursday.range;
  friday.range;
  saturday.range;
  var month = newInterval(function(date2) {
    date2.setDate(1);
    date2.setHours(0, 0, 0, 0);
  }, function(date2, step2) {
    date2.setMonth(date2.getMonth() + step2);
  }, function(start2, end2) {
    return end2.getMonth() - start2.getMonth() + (end2.getFullYear() - start2.getFullYear()) * 12;
  }, function(date2) {
    return date2.getMonth();
  });
  const timeMonth = month;
  month.range;
  var year = newInterval(function(date2) {
    date2.setMonth(0, 1);
    date2.setHours(0, 0, 0, 0);
  }, function(date2, step2) {
    date2.setFullYear(date2.getFullYear() + step2);
  }, function(start2, end2) {
    return end2.getFullYear() - start2.getFullYear();
  }, function(date2) {
    return date2.getFullYear();
  });
  year.every = function(k) {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date2) {
      date2.setFullYear(Math.floor(date2.getFullYear() / k) * k);
      date2.setMonth(0, 1);
      date2.setHours(0, 0, 0, 0);
    }, function(date2, step2) {
      date2.setFullYear(date2.getFullYear() + step2 * k);
    });
  };
  const timeYear = year;
  year.range;
  var utcMinute = newInterval(function(date2) {
    date2.setUTCSeconds(0, 0);
  }, function(date2, step2) {
    date2.setTime(+date2 + step2 * durationMinute);
  }, function(start2, end2) {
    return (end2 - start2) / durationMinute;
  }, function(date2) {
    return date2.getUTCMinutes();
  });
  const utcMinute$1 = utcMinute;
  utcMinute.range;
  var utcHour = newInterval(function(date2) {
    date2.setUTCMinutes(0, 0, 0);
  }, function(date2, step2) {
    date2.setTime(+date2 + step2 * durationHour);
  }, function(start2, end2) {
    return (end2 - start2) / durationHour;
  }, function(date2) {
    return date2.getUTCHours();
  });
  const utcHour$1 = utcHour;
  utcHour.range;
  var utcDay = newInterval(function(date2) {
    date2.setUTCHours(0, 0, 0, 0);
  }, function(date2, step2) {
    date2.setUTCDate(date2.getUTCDate() + step2);
  }, function(start2, end2) {
    return (end2 - start2) / durationDay;
  }, function(date2) {
    return date2.getUTCDate() - 1;
  });
  const utcDay$1 = utcDay;
  utcDay.range;
  function utcWeekday(i2) {
    return newInterval(function(date2) {
      date2.setUTCDate(date2.getUTCDate() - (date2.getUTCDay() + 7 - i2) % 7);
      date2.setUTCHours(0, 0, 0, 0);
    }, function(date2, step2) {
      date2.setUTCDate(date2.getUTCDate() + step2 * 7);
    }, function(start2, end2) {
      return (end2 - start2) / durationWeek;
    });
  }
  var utcSunday = utcWeekday(0);
  var utcMonday = utcWeekday(1);
  var utcTuesday = utcWeekday(2);
  var utcWednesday = utcWeekday(3);
  var utcThursday = utcWeekday(4);
  var utcFriday = utcWeekday(5);
  var utcSaturday = utcWeekday(6);
  utcSunday.range;
  utcMonday.range;
  utcTuesday.range;
  utcWednesday.range;
  utcThursday.range;
  utcFriday.range;
  utcSaturday.range;
  var utcMonth = newInterval(function(date2) {
    date2.setUTCDate(1);
    date2.setUTCHours(0, 0, 0, 0);
  }, function(date2, step2) {
    date2.setUTCMonth(date2.getUTCMonth() + step2);
  }, function(start2, end2) {
    return end2.getUTCMonth() - start2.getUTCMonth() + (end2.getUTCFullYear() - start2.getUTCFullYear()) * 12;
  }, function(date2) {
    return date2.getUTCMonth();
  });
  const utcMonth$1 = utcMonth;
  utcMonth.range;
  var utcYear = newInterval(function(date2) {
    date2.setUTCMonth(0, 1);
    date2.setUTCHours(0, 0, 0, 0);
  }, function(date2, step2) {
    date2.setUTCFullYear(date2.getUTCFullYear() + step2);
  }, function(start2, end2) {
    return end2.getUTCFullYear() - start2.getUTCFullYear();
  }, function(date2) {
    return date2.getUTCFullYear();
  });
  utcYear.every = function(k) {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date2) {
      date2.setUTCFullYear(Math.floor(date2.getUTCFullYear() / k) * k);
      date2.setUTCMonth(0, 1);
      date2.setUTCHours(0, 0, 0, 0);
    }, function(date2, step2) {
      date2.setUTCFullYear(date2.getUTCFullYear() + step2 * k);
    });
  };
  const utcYear$1 = utcYear;
  utcYear.range;
  function ticker(year2, month2, week, day2, hour2, minute2) {
    const tickIntervals = [
      [utcSecond, 1, durationSecond],
      [utcSecond, 5, 5 * durationSecond],
      [utcSecond, 15, 15 * durationSecond],
      [utcSecond, 30, 30 * durationSecond],
      [minute2, 1, durationMinute],
      [minute2, 5, 5 * durationMinute],
      [minute2, 15, 15 * durationMinute],
      [minute2, 30, 30 * durationMinute],
      [hour2, 1, durationHour],
      [hour2, 3, 3 * durationHour],
      [hour2, 6, 6 * durationHour],
      [hour2, 12, 12 * durationHour],
      [day2, 1, durationDay],
      [day2, 2, 2 * durationDay],
      [week, 1, durationWeek],
      [month2, 1, durationMonth],
      [month2, 3, 3 * durationMonth],
      [year2, 1, durationYear]
    ];
    function ticks2(start2, stop, count) {
      const reverse = stop < start2;
      if (reverse)
        [start2, stop] = [stop, start2];
      const interval2 = count && typeof count.range === "function" ? count : tickInterval2(start2, stop, count);
      const ticks3 = interval2 ? interval2.range(start2, +stop + 1) : [];
      return reverse ? ticks3.reverse() : ticks3;
    }
    function tickInterval2(start2, stop, count) {
      const target = Math.abs(stop - start2) / count;
      const i2 = bisector(([, , step3]) => step3).right(tickIntervals, target);
      if (i2 === tickIntervals.length)
        return year2.every(tickStep(start2 / durationYear, stop / durationYear, count));
      if (i2 === 0)
        return millisecond$1.every(Math.max(tickStep(start2, stop, count), 1));
      const [t, step2] = tickIntervals[target / tickIntervals[i2 - 1][2] < tickIntervals[i2][2] / target ? i2 - 1 : i2];
      return t.every(step2);
    }
    return [ticks2, tickInterval2];
  }
  ticker(utcYear$1, utcMonth$1, utcSunday, utcDay$1, utcHour$1, utcMinute$1);
  const [timeTicks, timeTickInterval] = ticker(timeYear, timeMonth, sunday, timeDay, timeHour, timeMinute);
  function localDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
      date2.setFullYear(d.y);
      return date2;
    }
    return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
  }
  function utcDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
      date2.setUTCFullYear(d.y);
      return date2;
    }
    return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
  }
  function newDate(y2, m, d) {
    return { y: y2, m, d, H: 0, M: 0, S: 0, L: 0 };
  }
  function formatLocale(locale2) {
    var locale_dateTime = locale2.dateTime, locale_date = locale2.date, locale_time = locale2.time, locale_periods = locale2.periods, locale_weekdays = locale2.days, locale_shortWeekdays = locale2.shortDays, locale_months = locale2.months, locale_shortMonths = locale2.shortMonths;
    var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
    var formats = {
      "a": formatShortWeekday,
      "A": formatWeekday,
      "b": formatShortMonth,
      "B": formatMonth,
      "c": null,
      "d": formatDayOfMonth,
      "e": formatDayOfMonth,
      "f": formatMicroseconds,
      "g": formatYearISO,
      "G": formatFullYearISO,
      "H": formatHour24,
      "I": formatHour12,
      "j": formatDayOfYear,
      "L": formatMilliseconds,
      "m": formatMonthNumber,
      "M": formatMinutes,
      "p": formatPeriod,
      "q": formatQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatSeconds,
      "u": formatWeekdayNumberMonday,
      "U": formatWeekNumberSunday,
      "V": formatWeekNumberISO,
      "w": formatWeekdayNumberSunday,
      "W": formatWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatYear,
      "Y": formatFullYear,
      "Z": formatZone,
      "%": formatLiteralPercent
    };
    var utcFormats = {
      "a": formatUTCShortWeekday,
      "A": formatUTCWeekday,
      "b": formatUTCShortMonth,
      "B": formatUTCMonth,
      "c": null,
      "d": formatUTCDayOfMonth,
      "e": formatUTCDayOfMonth,
      "f": formatUTCMicroseconds,
      "g": formatUTCYearISO,
      "G": formatUTCFullYearISO,
      "H": formatUTCHour24,
      "I": formatUTCHour12,
      "j": formatUTCDayOfYear,
      "L": formatUTCMilliseconds,
      "m": formatUTCMonthNumber,
      "M": formatUTCMinutes,
      "p": formatUTCPeriod,
      "q": formatUTCQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatUTCSeconds,
      "u": formatUTCWeekdayNumberMonday,
      "U": formatUTCWeekNumberSunday,
      "V": formatUTCWeekNumberISO,
      "w": formatUTCWeekdayNumberSunday,
      "W": formatUTCWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatUTCYear,
      "Y": formatUTCFullYear,
      "Z": formatUTCZone,
      "%": formatLiteralPercent
    };
    var parses = {
      "a": parseShortWeekday,
      "A": parseWeekday2,
      "b": parseShortMonth,
      "B": parseMonth,
      "c": parseLocaleDateTime,
      "d": parseDayOfMonth,
      "e": parseDayOfMonth,
      "f": parseMicroseconds,
      "g": parseYear,
      "G": parseFullYear,
      "H": parseHour24,
      "I": parseHour24,
      "j": parseDayOfYear,
      "L": parseMilliseconds,
      "m": parseMonthNumber,
      "M": parseMinutes,
      "p": parsePeriod,
      "q": parseQuarter,
      "Q": parseUnixTimestamp,
      "s": parseUnixTimestampSeconds,
      "S": parseSeconds,
      "u": parseWeekdayNumberMonday,
      "U": parseWeekNumberSunday,
      "V": parseWeekNumberISO,
      "w": parseWeekdayNumberSunday,
      "W": parseWeekNumberMonday,
      "x": parseLocaleDate,
      "X": parseLocaleTime,
      "y": parseYear,
      "Y": parseFullYear,
      "Z": parseZone,
      "%": parseLiteralPercent
    };
    formats.x = newFormat(locale_date, formats);
    formats.X = newFormat(locale_time, formats);
    formats.c = newFormat(locale_dateTime, formats);
    utcFormats.x = newFormat(locale_date, utcFormats);
    utcFormats.X = newFormat(locale_time, utcFormats);
    utcFormats.c = newFormat(locale_dateTime, utcFormats);
    function newFormat(specifier, formats2) {
      return function(date2) {
        var string2 = [], i2 = -1, j = 0, n = specifier.length, c2, pad2, format2;
        if (!(date2 instanceof Date))
          date2 = new Date(+date2);
        while (++i2 < n) {
          if (specifier.charCodeAt(i2) === 37) {
            string2.push(specifier.slice(j, i2));
            if ((pad2 = pads[c2 = specifier.charAt(++i2)]) != null)
              c2 = specifier.charAt(++i2);
            else
              pad2 = c2 === "e" ? " " : "0";
            if (format2 = formats2[c2])
              c2 = format2(date2, pad2);
            string2.push(c2);
            j = i2 + 1;
          }
        }
        string2.push(specifier.slice(j, i2));
        return string2.join("");
      };
    }
    function newParse(specifier, Z) {
      return function(string2) {
        var d = newDate(1900, void 0, 1), i2 = parseSpecifier(d, specifier, string2 += "", 0), week, day2;
        if (i2 != string2.length)
          return null;
        if ("Q" in d)
          return new Date(d.Q);
        if ("s" in d)
          return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
        if (Z && !("Z" in d))
          d.Z = 0;
        if ("p" in d)
          d.H = d.H % 12 + d.p * 12;
        if (d.m === void 0)
          d.m = "q" in d ? d.q : 0;
        if ("V" in d) {
          if (d.V < 1 || d.V > 53)
            return null;
          if (!("w" in d))
            d.w = 1;
          if ("Z" in d) {
            week = utcDate(newDate(d.y, 0, 1)), day2 = week.getUTCDay();
            week = day2 > 4 || day2 === 0 ? utcMonday.ceil(week) : utcMonday(week);
            week = utcDay$1.offset(week, (d.V - 1) * 7);
            d.y = week.getUTCFullYear();
            d.m = week.getUTCMonth();
            d.d = week.getUTCDate() + (d.w + 6) % 7;
          } else {
            week = localDate(newDate(d.y, 0, 1)), day2 = week.getDay();
            week = day2 > 4 || day2 === 0 ? monday.ceil(week) : monday(week);
            week = timeDay.offset(week, (d.V - 1) * 7);
            d.y = week.getFullYear();
            d.m = week.getMonth();
            d.d = week.getDate() + (d.w + 6) % 7;
          }
        } else if ("W" in d || "U" in d) {
          if (!("w" in d))
            d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
          day2 = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
          d.m = 0;
          d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day2 + 5) % 7 : d.w + d.U * 7 - (day2 + 6) % 7;
        }
        if ("Z" in d) {
          d.H += d.Z / 100 | 0;
          d.M += d.Z % 100;
          return utcDate(d);
        }
        return localDate(d);
      };
    }
    function parseSpecifier(d, specifier, string2, j) {
      var i2 = 0, n = specifier.length, m = string2.length, c2, parse2;
      while (i2 < n) {
        if (j >= m)
          return -1;
        c2 = specifier.charCodeAt(i2++);
        if (c2 === 37) {
          c2 = specifier.charAt(i2++);
          parse2 = parses[c2 in pads ? specifier.charAt(i2++) : c2];
          if (!parse2 || (j = parse2(d, string2, j)) < 0)
            return -1;
        } else if (c2 != string2.charCodeAt(j++)) {
          return -1;
        }
      }
      return j;
    }
    function parsePeriod(d, string2, i2) {
      var n = periodRe.exec(string2.slice(i2));
      return n ? (d.p = periodLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortWeekday(d, string2, i2) {
      var n = shortWeekdayRe.exec(string2.slice(i2));
      return n ? (d.w = shortWeekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseWeekday2(d, string2, i2) {
      var n = weekdayRe.exec(string2.slice(i2));
      return n ? (d.w = weekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortMonth(d, string2, i2) {
      var n = shortMonthRe.exec(string2.slice(i2));
      return n ? (d.m = shortMonthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseMonth(d, string2, i2) {
      var n = monthRe.exec(string2.slice(i2));
      return n ? (d.m = monthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseLocaleDateTime(d, string2, i2) {
      return parseSpecifier(d, locale_dateTime, string2, i2);
    }
    function parseLocaleDate(d, string2, i2) {
      return parseSpecifier(d, locale_date, string2, i2);
    }
    function parseLocaleTime(d, string2, i2) {
      return parseSpecifier(d, locale_time, string2, i2);
    }
    function formatShortWeekday(d) {
      return locale_shortWeekdays[d.getDay()];
    }
    function formatWeekday(d) {
      return locale_weekdays[d.getDay()];
    }
    function formatShortMonth(d) {
      return locale_shortMonths[d.getMonth()];
    }
    function formatMonth(d) {
      return locale_months[d.getMonth()];
    }
    function formatPeriod(d) {
      return locale_periods[+(d.getHours() >= 12)];
    }
    function formatQuarter(d) {
      return 1 + ~~(d.getMonth() / 3);
    }
    function formatUTCShortWeekday(d) {
      return locale_shortWeekdays[d.getUTCDay()];
    }
    function formatUTCWeekday(d) {
      return locale_weekdays[d.getUTCDay()];
    }
    function formatUTCShortMonth(d) {
      return locale_shortMonths[d.getUTCMonth()];
    }
    function formatUTCMonth(d) {
      return locale_months[d.getUTCMonth()];
    }
    function formatUTCPeriod(d) {
      return locale_periods[+(d.getUTCHours() >= 12)];
    }
    function formatUTCQuarter(d) {
      return 1 + ~~(d.getUTCMonth() / 3);
    }
    return {
      format: function(specifier) {
        var f2 = newFormat(specifier += "", formats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      parse: function(specifier) {
        var p2 = newParse(specifier += "", false);
        p2.toString = function() {
          return specifier;
        };
        return p2;
      },
      utcFormat: function(specifier) {
        var f2 = newFormat(specifier += "", utcFormats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      utcParse: function(specifier) {
        var p2 = newParse(specifier += "", true);
        p2.toString = function() {
          return specifier;
        };
        return p2;
      }
    };
  }
  var pads = { "-": "", "_": " ", "0": "0" }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
  function pad(value, fill, width2) {
    var sign2 = value < 0 ? "-" : "", string2 = (sign2 ? -value : value) + "", length2 = string2.length;
    return sign2 + (length2 < width2 ? new Array(width2 - length2 + 1).join(fill) + string2 : string2);
  }
  function requote(s) {
    return s.replace(requoteRe, "\\$&");
  }
  function formatRe(names) {
    return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
  }
  function formatLookup(names) {
    return new Map(names.map((name2, i2) => [name2.toLowerCase(), i2]));
  }
  function parseWeekdayNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.w = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekdayNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.u = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.U = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberISO(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.V = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.W = +n[0], i2 + n[0].length) : -1;
  }
  function parseFullYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 4));
    return n ? (d.y = +n[0], i2 + n[0].length) : -1;
  }
  function parseYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i2 + n[0].length) : -1;
  }
  function parseZone(d, string2, i2) {
    var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string2.slice(i2, i2 + 6));
    return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i2 + n[0].length) : -1;
  }
  function parseQuarter(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.q = n[0] * 3 - 3, i2 + n[0].length) : -1;
  }
  function parseMonthNumber(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.m = n[0] - 1, i2 + n[0].length) : -1;
  }
  function parseDayOfMonth(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseDayOfYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.m = 0, d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseHour24(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.H = +n[0], i2 + n[0].length) : -1;
  }
  function parseMinutes(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.M = +n[0], i2 + n[0].length) : -1;
  }
  function parseSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.S = +n[0], i2 + n[0].length) : -1;
  }
  function parseMilliseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.L = +n[0], i2 + n[0].length) : -1;
  }
  function parseMicroseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 6));
    return n ? (d.L = Math.floor(n[0] / 1e3), i2 + n[0].length) : -1;
  }
  function parseLiteralPercent(d, string2, i2) {
    var n = percentRe.exec(string2.slice(i2, i2 + 1));
    return n ? i2 + n[0].length : -1;
  }
  function parseUnixTimestamp(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.Q = +n[0], i2 + n[0].length) : -1;
  }
  function parseUnixTimestampSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.s = +n[0], i2 + n[0].length) : -1;
  }
  function formatDayOfMonth(d, p2) {
    return pad(d.getDate(), p2, 2);
  }
  function formatHour24(d, p2) {
    return pad(d.getHours(), p2, 2);
  }
  function formatHour12(d, p2) {
    return pad(d.getHours() % 12 || 12, p2, 2);
  }
  function formatDayOfYear(d, p2) {
    return pad(1 + timeDay.count(timeYear(d), d), p2, 3);
  }
  function formatMilliseconds(d, p2) {
    return pad(d.getMilliseconds(), p2, 3);
  }
  function formatMicroseconds(d, p2) {
    return formatMilliseconds(d, p2) + "000";
  }
  function formatMonthNumber(d, p2) {
    return pad(d.getMonth() + 1, p2, 2);
  }
  function formatMinutes(d, p2) {
    return pad(d.getMinutes(), p2, 2);
  }
  function formatSeconds(d, p2) {
    return pad(d.getSeconds(), p2, 2);
  }
  function formatWeekdayNumberMonday(d) {
    var day2 = d.getDay();
    return day2 === 0 ? 7 : day2;
  }
  function formatWeekNumberSunday(d, p2) {
    return pad(sunday.count(timeYear(d) - 1, d), p2, 2);
  }
  function dISO(d) {
    var day2 = d.getDay();
    return day2 >= 4 || day2 === 0 ? thursday(d) : thursday.ceil(d);
  }
  function formatWeekNumberISO(d, p2) {
    d = dISO(d);
    return pad(thursday.count(timeYear(d), d) + (timeYear(d).getDay() === 4), p2, 2);
  }
  function formatWeekdayNumberSunday(d) {
    return d.getDay();
  }
  function formatWeekNumberMonday(d, p2) {
    return pad(monday.count(timeYear(d) - 1, d), p2, 2);
  }
  function formatYear(d, p2) {
    return pad(d.getFullYear() % 100, p2, 2);
  }
  function formatYearISO(d, p2) {
    d = dISO(d);
    return pad(d.getFullYear() % 100, p2, 2);
  }
  function formatFullYear(d, p2) {
    return pad(d.getFullYear() % 1e4, p2, 4);
  }
  function formatFullYearISO(d, p2) {
    var day2 = d.getDay();
    d = day2 >= 4 || day2 === 0 ? thursday(d) : thursday.ceil(d);
    return pad(d.getFullYear() % 1e4, p2, 4);
  }
  function formatZone(d) {
    var z = d.getTimezoneOffset();
    return (z > 0 ? "-" : (z *= -1, "+")) + pad(z / 60 | 0, "0", 2) + pad(z % 60, "0", 2);
  }
  function formatUTCDayOfMonth(d, p2) {
    return pad(d.getUTCDate(), p2, 2);
  }
  function formatUTCHour24(d, p2) {
    return pad(d.getUTCHours(), p2, 2);
  }
  function formatUTCHour12(d, p2) {
    return pad(d.getUTCHours() % 12 || 12, p2, 2);
  }
  function formatUTCDayOfYear(d, p2) {
    return pad(1 + utcDay$1.count(utcYear$1(d), d), p2, 3);
  }
  function formatUTCMilliseconds(d, p2) {
    return pad(d.getUTCMilliseconds(), p2, 3);
  }
  function formatUTCMicroseconds(d, p2) {
    return formatUTCMilliseconds(d, p2) + "000";
  }
  function formatUTCMonthNumber(d, p2) {
    return pad(d.getUTCMonth() + 1, p2, 2);
  }
  function formatUTCMinutes(d, p2) {
    return pad(d.getUTCMinutes(), p2, 2);
  }
  function formatUTCSeconds(d, p2) {
    return pad(d.getUTCSeconds(), p2, 2);
  }
  function formatUTCWeekdayNumberMonday(d) {
    var dow = d.getUTCDay();
    return dow === 0 ? 7 : dow;
  }
  function formatUTCWeekNumberSunday(d, p2) {
    return pad(utcSunday.count(utcYear$1(d) - 1, d), p2, 2);
  }
  function UTCdISO(d) {
    var day2 = d.getUTCDay();
    return day2 >= 4 || day2 === 0 ? utcThursday(d) : utcThursday.ceil(d);
  }
  function formatUTCWeekNumberISO(d, p2) {
    d = UTCdISO(d);
    return pad(utcThursday.count(utcYear$1(d), d) + (utcYear$1(d).getUTCDay() === 4), p2, 2);
  }
  function formatUTCWeekdayNumberSunday(d) {
    return d.getUTCDay();
  }
  function formatUTCWeekNumberMonday(d, p2) {
    return pad(utcMonday.count(utcYear$1(d) - 1, d), p2, 2);
  }
  function formatUTCYear(d, p2) {
    return pad(d.getUTCFullYear() % 100, p2, 2);
  }
  function formatUTCYearISO(d, p2) {
    d = UTCdISO(d);
    return pad(d.getUTCFullYear() % 100, p2, 2);
  }
  function formatUTCFullYear(d, p2) {
    return pad(d.getUTCFullYear() % 1e4, p2, 4);
  }
  function formatUTCFullYearISO(d, p2) {
    var day2 = d.getUTCDay();
    d = day2 >= 4 || day2 === 0 ? utcThursday(d) : utcThursday.ceil(d);
    return pad(d.getUTCFullYear() % 1e4, p2, 4);
  }
  function formatUTCZone() {
    return "+0000";
  }
  function formatLiteralPercent() {
    return "%";
  }
  function formatUnixTimestamp(d) {
    return +d;
  }
  function formatUnixTimestampSeconds(d) {
    return Math.floor(+d / 1e3);
  }
  var locale;
  var timeFormat;
  defaultLocale({
    dateTime: "%x, %X",
    date: "%-m/%-d/%Y",
    time: "%-I:%M:%S %p",
    periods: ["AM", "PM"],
    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
  });
  function defaultLocale(definition) {
    locale = formatLocale(definition);
    timeFormat = locale.format;
    locale.parse;
    locale.utcFormat;
    locale.utcParse;
    return locale;
  }
  function date(t) {
    return new Date(t);
  }
  function number$2(t) {
    return t instanceof Date ? +t : +new Date(+t);
  }
  function calendar(ticks2, tickInterval2, year2, month2, week, day2, hour2, minute2, second2, format2) {
    var scale = continuous(), invert2 = scale.invert, domain = scale.domain;
    var formatMillisecond = format2(".%L"), formatSecond = format2(":%S"), formatMinute = format2("%I:%M"), formatHour = format2("%I %p"), formatDay = format2("%a %d"), formatWeek = format2("%b %d"), formatMonth = format2("%B"), formatYear2 = format2("%Y");
    function tickFormat2(date2) {
      return (second2(date2) < date2 ? formatMillisecond : minute2(date2) < date2 ? formatSecond : hour2(date2) < date2 ? formatMinute : day2(date2) < date2 ? formatHour : month2(date2) < date2 ? week(date2) < date2 ? formatDay : formatWeek : year2(date2) < date2 ? formatMonth : formatYear2)(date2);
    }
    scale.invert = function(y2) {
      return new Date(invert2(y2));
    };
    scale.domain = function(_2) {
      return arguments.length ? domain(Array.from(_2, number$2)) : domain().map(date);
    };
    scale.ticks = function(interval2) {
      var d = domain();
      return ticks2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
    };
    scale.tickFormat = function(count, specifier) {
      return specifier == null ? tickFormat2 : format2(specifier);
    };
    scale.nice = function(interval2) {
      var d = domain();
      if (!interval2 || typeof interval2.range !== "function")
        interval2 = tickInterval2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
      return interval2 ? domain(nice(d, interval2)) : scale;
    };
    scale.copy = function() {
      return copy$2(scale, calendar(ticks2, tickInterval2, year2, month2, week, day2, hour2, minute2, second2, format2));
    };
    return scale;
  }
  function time$1() {
    return initRange.apply(calendar(timeTicks, timeTickInterval, timeYear, timeMonth, sunday, timeDay, timeHour, timeMinute, utcSecond, timeFormat).domain([new Date(2e3, 0, 1), new Date(2e3, 0, 2)]), arguments);
  }
  function constant$1(x2) {
    return function constant2() {
      return x2;
    };
  }
  const abs$1 = Math.abs;
  const atan2 = Math.atan2;
  const cos$1 = Math.cos;
  const max$2 = Math.max;
  const min$2 = Math.min;
  const sin$1 = Math.sin;
  const sqrt$1 = Math.sqrt;
  const epsilon = 1e-12;
  const pi = Math.PI;
  const halfPi = pi / 2;
  const tau = 2 * pi;
  function acos(x2) {
    return x2 > 1 ? 0 : x2 < -1 ? pi : Math.acos(x2);
  }
  function asin(x2) {
    return x2 >= 1 ? halfPi : x2 <= -1 ? -halfPi : Math.asin(x2);
  }
  function arcInnerRadius(d) {
    return d.innerRadius;
  }
  function arcOuterRadius(d) {
    return d.outerRadius;
  }
  function arcStartAngle(d) {
    return d.startAngle;
  }
  function arcEndAngle(d) {
    return d.endAngle;
  }
  function arcPadAngle(d) {
    return d && d.padAngle;
  }
  function intersect$1(x0, y0, x1, y1, x2, y2, x3, y3) {
    var x10 = x1 - x0, y10 = y1 - y0, x32 = x3 - x2, y32 = y3 - y2, t = y32 * x10 - x32 * y10;
    if (t * t < epsilon)
      return;
    t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;
    return [x0 + t * x10, y0 + t * y10];
  }
  function cornerTangents(x0, y0, x1, y1, r1, rc, cw) {
    var x01 = x0 - x1, y01 = y0 - y1, lo = (cw ? rc : -rc) / sqrt$1(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x11 = x0 + ox, y11 = y0 + oy, x10 = x1 + ox, y10 = y1 + oy, x00 = (x11 + x10) / 2, y00 = (y11 + y10) / 2, dx = x10 - x11, dy = y10 - y11, d2 = dx * dx + dy * dy, r = r1 - rc, D = x11 * y10 - x10 * y11, d = (dy < 0 ? -1 : 1) * sqrt$1(max$2(0, r * r * d2 - D * D)), cx0 = (D * dy - dx * d) / d2, cy0 = (-D * dx - dy * d) / d2, cx1 = (D * dy + dx * d) / d2, cy1 = (-D * dx + dy * d) / d2, dx0 = cx0 - x00, dy0 = cy0 - y00, dx1 = cx1 - x00, dy1 = cy1 - y00;
    if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1)
      cx0 = cx1, cy0 = cy1;
    return {
      cx: cx0,
      cy: cy0,
      x01: -ox,
      y01: -oy,
      x11: cx0 * (r1 / r - 1),
      y11: cy0 * (r1 / r - 1)
    };
  }
  function d3arc() {
    var innerRadius = arcInnerRadius, outerRadius = arcOuterRadius, cornerRadius = constant$1(0), padRadius = null, startAngle = arcStartAngle, endAngle = arcEndAngle, padAngle = arcPadAngle, context = null;
    function arc() {
      var buffer, r, r0 = +innerRadius.apply(this, arguments), r1 = +outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) - halfPi, a1 = endAngle.apply(this, arguments) - halfPi, da = abs$1(a1 - a0), cw = a1 > a0;
      if (!context)
        context = buffer = path();
      if (r1 < r0)
        r = r1, r1 = r0, r0 = r;
      if (!(r1 > epsilon))
        context.moveTo(0, 0);
      else if (da > tau - epsilon) {
        context.moveTo(r1 * cos$1(a0), r1 * sin$1(a0));
        context.arc(0, 0, r1, a0, a1, !cw);
        if (r0 > epsilon) {
          context.moveTo(r0 * cos$1(a1), r0 * sin$1(a1));
          context.arc(0, 0, r0, a1, a0, cw);
        }
      } else {
        var a01 = a0, a11 = a1, a00 = a0, a10 = a1, da0 = da, da1 = da, ap = padAngle.apply(this, arguments) / 2, rp = ap > epsilon && (padRadius ? +padRadius.apply(this, arguments) : sqrt$1(r0 * r0 + r1 * r1)), rc = min$2(abs$1(r1 - r0) / 2, +cornerRadius.apply(this, arguments)), rc0 = rc, rc1 = rc, t02, t12;
        if (rp > epsilon) {
          var p0 = asin(rp / r0 * sin$1(ap)), p1 = asin(rp / r1 * sin$1(ap));
          if ((da0 -= p0 * 2) > epsilon)
            p0 *= cw ? 1 : -1, a00 += p0, a10 -= p0;
          else
            da0 = 0, a00 = a10 = (a0 + a1) / 2;
          if ((da1 -= p1 * 2) > epsilon)
            p1 *= cw ? 1 : -1, a01 += p1, a11 -= p1;
          else
            da1 = 0, a01 = a11 = (a0 + a1) / 2;
        }
        var x01 = r1 * cos$1(a01), y01 = r1 * sin$1(a01), x10 = r0 * cos$1(a10), y10 = r0 * sin$1(a10);
        if (rc > epsilon) {
          var x11 = r1 * cos$1(a11), y11 = r1 * sin$1(a11), x00 = r0 * cos$1(a00), y00 = r0 * sin$1(a00), oc;
          if (da < pi && (oc = intersect$1(x01, y01, x00, y00, x11, y11, x10, y10))) {
            var ax = x01 - oc[0], ay = y01 - oc[1], bx = x11 - oc[0], by = y11 - oc[1], kc = 1 / sin$1(acos((ax * bx + ay * by) / (sqrt$1(ax * ax + ay * ay) * sqrt$1(bx * bx + by * by))) / 2), lc = sqrt$1(oc[0] * oc[0] + oc[1] * oc[1]);
            rc0 = min$2(rc, (r0 - lc) / (kc - 1));
            rc1 = min$2(rc, (r1 - lc) / (kc + 1));
          }
        }
        if (!(da1 > epsilon))
          context.moveTo(x01, y01);
        else if (rc1 > epsilon) {
          t02 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
          t12 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);
          context.moveTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc1 < rc)
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r1, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), !cw);
            context.arc(t12.cx, t12.cy, rc1, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);
        if (!(r0 > epsilon) || !(da0 > epsilon))
          context.lineTo(x10, y10);
        else if (rc0 > epsilon) {
          t02 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
          t12 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);
          context.lineTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc0 < rc)
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r0, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), cw);
            context.arc(t12.cx, t12.cy, rc0, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.arc(0, 0, r0, a10, a00, cw);
      }
      context.closePath();
      if (buffer)
        return context = null, buffer + "" || null;
    }
    arc.centroid = function() {
      var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi / 2;
      return [cos$1(a) * r, sin$1(a) * r];
    };
    arc.innerRadius = function(_2) {
      return arguments.length ? (innerRadius = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : innerRadius;
    };
    arc.outerRadius = function(_2) {
      return arguments.length ? (outerRadius = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : outerRadius;
    };
    arc.cornerRadius = function(_2) {
      return arguments.length ? (cornerRadius = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : cornerRadius;
    };
    arc.padRadius = function(_2) {
      return arguments.length ? (padRadius = _2 == null ? null : typeof _2 === "function" ? _2 : constant$1(+_2), arc) : padRadius;
    };
    arc.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : startAngle;
    };
    arc.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : endAngle;
    };
    arc.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : padAngle;
    };
    arc.context = function(_2) {
      return arguments.length ? (context = _2 == null ? null : _2, arc) : context;
    };
    return arc;
  }
  function array$1(x2) {
    return typeof x2 === "object" && "length" in x2 ? x2 : Array.from(x2);
  }
  function Linear(context) {
    this._context = context;
  }
  Linear.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default:
          this._context.lineTo(x2, y2);
          break;
      }
    }
  };
  function curveLinear(context) {
    return new Linear(context);
  }
  function x(p2) {
    return p2[0];
  }
  function y(p2) {
    return p2[1];
  }
  function line$1(x$1, y$1) {
    var defined = constant$1(true), context = null, curve = curveLinear, output2 = null;
    x$1 = typeof x$1 === "function" ? x$1 : x$1 === void 0 ? x : constant$1(x$1);
    y$1 = typeof y$1 === "function" ? y$1 : y$1 === void 0 ? y : constant$1(y$1);
    function line2(data2) {
      var i2, n = (data2 = array$1(data2)).length, d, defined0 = false, buffer;
      if (context == null)
        output2 = curve(buffer = path());
      for (i2 = 0; i2 <= n; ++i2) {
        if (!(i2 < n && defined(d = data2[i2], i2, data2)) === defined0) {
          if (defined0 = !defined0)
            output2.lineStart();
          else
            output2.lineEnd();
        }
        if (defined0)
          output2.point(+x$1(d, i2, data2), +y$1(d, i2, data2));
      }
      if (buffer)
        return output2 = null, buffer + "" || null;
    }
    line2.x = function(_2) {
      return arguments.length ? (x$1 = typeof _2 === "function" ? _2 : constant$1(+_2), line2) : x$1;
    };
    line2.y = function(_2) {
      return arguments.length ? (y$1 = typeof _2 === "function" ? _2 : constant$1(+_2), line2) : y$1;
    };
    line2.defined = function(_2) {
      return arguments.length ? (defined = typeof _2 === "function" ? _2 : constant$1(!!_2), line2) : defined;
    };
    line2.curve = function(_2) {
      return arguments.length ? (curve = _2, context != null && (output2 = curve(context)), line2) : curve;
    };
    line2.context = function(_2) {
      return arguments.length ? (_2 == null ? context = output2 = null : output2 = curve(context = _2), line2) : context;
    };
    return line2;
  }
  function descending$1(a, b) {
    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function identity$2(d) {
    return d;
  }
  function d3pie() {
    var value = identity$2, sortValues = descending$1, sort2 = null, startAngle = constant$1(0), endAngle = constant$1(tau), padAngle = constant$1(0);
    function pie(data2) {
      var i2, n = (data2 = array$1(data2)).length, j, k, sum = 0, index = new Array(n), arcs = new Array(n), a0 = +startAngle.apply(this, arguments), da = Math.min(tau, Math.max(-tau, endAngle.apply(this, arguments) - a0)), a1, p2 = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)), pa = p2 * (da < 0 ? -1 : 1), v;
      for (i2 = 0; i2 < n; ++i2) {
        if ((v = arcs[index[i2] = i2] = +value(data2[i2], i2, data2)) > 0) {
          sum += v;
        }
      }
      if (sortValues != null)
        index.sort(function(i3, j2) {
          return sortValues(arcs[i3], arcs[j2]);
        });
      else if (sort2 != null)
        index.sort(function(i3, j2) {
          return sort2(data2[i3], data2[j2]);
        });
      for (i2 = 0, k = sum ? (da - n * pa) / sum : 0; i2 < n; ++i2, a0 = a1) {
        j = index[i2], v = arcs[j], a1 = a0 + (v > 0 ? v * k : 0) + pa, arcs[j] = {
          data: data2[j],
          index: i2,
          value: v,
          startAngle: a0,
          endAngle: a1,
          padAngle: p2
        };
      }
      return arcs;
    }
    pie.value = function(_2) {
      return arguments.length ? (value = typeof _2 === "function" ? _2 : constant$1(+_2), pie) : value;
    };
    pie.sortValues = function(_2) {
      return arguments.length ? (sortValues = _2, sort2 = null, pie) : sortValues;
    };
    pie.sort = function(_2) {
      return arguments.length ? (sort2 = _2, sortValues = null, pie) : sort2;
    };
    pie.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$1(+_2), pie) : startAngle;
    };
    pie.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$1(+_2), pie) : endAngle;
    };
    pie.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$1(+_2), pie) : padAngle;
    };
    return pie;
  }
  class Bump {
    constructor(context, x2) {
      this._context = context;
      this._x = x2;
    }
    areaStart() {
      this._line = 0;
    }
    areaEnd() {
      this._line = NaN;
    }
    lineStart() {
      this._point = 0;
    }
    lineEnd() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    }
    point(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0: {
          this._point = 1;
          if (this._line)
            this._context.lineTo(x2, y2);
          else
            this._context.moveTo(x2, y2);
          break;
        }
        case 1:
          this._point = 2;
        default: {
          if (this._x)
            this._context.bezierCurveTo(this._x0 = (this._x0 + x2) / 2, this._y0, this._x0, y2, x2, y2);
          else
            this._context.bezierCurveTo(this._x0, this._y0 = (this._y0 + y2) / 2, x2, this._y0, x2, y2);
          break;
        }
      }
      this._x0 = x2, this._y0 = y2;
    }
  }
  function bumpX(context) {
    return new Bump(context, true);
  }
  function bumpY(context) {
    return new Bump(context, false);
  }
  function noop$3() {
  }
  function point$4(that, x2, y2) {
    that._context.bezierCurveTo(
      (2 * that._x0 + that._x1) / 3,
      (2 * that._y0 + that._y1) / 3,
      (that._x0 + 2 * that._x1) / 3,
      (that._y0 + 2 * that._y1) / 3,
      (that._x0 + 4 * that._x1 + x2) / 6,
      (that._y0 + 4 * that._y1 + y2) / 6
    );
  }
  function Basis(context) {
    this._context = context;
  }
  Basis.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 3:
          point$4(this, this._x1, this._y1);
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
        default:
          point$4(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasis(context) {
    return new Basis(context);
  }
  function BasisClosed(context) {
    this._context = context;
  }
  BasisClosed.prototype = {
    areaStart: noop$3,
    areaEnd: noop$3,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x2, this._y2);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
          this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x2, this._y2);
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x2 = x2, this._y2 = y2;
          break;
        case 1:
          this._point = 2;
          this._x3 = x2, this._y3 = y2;
          break;
        case 2:
          this._point = 3;
          this._x4 = x2, this._y4 = y2;
          this._context.moveTo((this._x0 + 4 * this._x1 + x2) / 6, (this._y0 + 4 * this._y1 + y2) / 6);
          break;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisClosed(context) {
    return new BasisClosed(context);
  }
  function BasisOpen(context) {
    this._context = context;
  }
  BasisOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          var x0 = (this._x0 + 4 * this._x1 + x2) / 6, y0 = (this._y0 + 4 * this._y1 + y2) / 6;
          this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0);
          break;
        case 3:
          this._point = 4;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisOpen(context) {
    return new BasisOpen(context);
  }
  function Bundle(context, beta) {
    this._basis = new Basis(context);
    this._beta = beta;
  }
  Bundle.prototype = {
    lineStart: function() {
      this._x = [];
      this._y = [];
      this._basis.lineStart();
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, j = x2.length - 1;
      if (j > 0) {
        var x0 = x2[0], y0 = y2[0], dx = x2[j] - x0, dy = y2[j] - y0, i2 = -1, t;
        while (++i2 <= j) {
          t = i2 / j;
          this._basis.point(
            this._beta * x2[i2] + (1 - this._beta) * (x0 + t * dx),
            this._beta * y2[i2] + (1 - this._beta) * (y0 + t * dy)
          );
        }
      }
      this._x = this._y = null;
      this._basis.lineEnd();
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  const curveBundle = function custom(beta) {
    function bundle(context) {
      return beta === 1 ? new Basis(context) : new Bundle(context, beta);
    }
    bundle.beta = function(beta2) {
      return custom(+beta2);
    };
    return bundle;
  }(0.85);
  function point$3(that, x2, y2) {
    that._context.bezierCurveTo(
      that._x1 + that._k * (that._x2 - that._x0),
      that._y1 + that._k * (that._y2 - that._y0),
      that._x2 + that._k * (that._x1 - x2),
      that._y2 + that._k * (that._y1 - y2),
      that._x2,
      that._y2
    );
  }
  function Cardinal(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  Cardinal.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          point$3(this, this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          this._x1 = x2, this._y1 = y2;
          break;
        case 2:
          this._point = 3;
        default:
          point$3(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinal = function custom(tension) {
    function cardinal(context) {
      return new Cardinal(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalClosed(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalClosed.prototype = {
    areaStart: noop$3,
    areaEnd: noop$3,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$3(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalClosed = function custom(tension) {
    function cardinal(context) {
      return new CardinalClosed(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalOpen(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$3(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalOpen = function custom(tension) {
    function cardinal(context) {
      return new CardinalOpen(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function point$2(that, x2, y2) {
    var x1 = that._x1, y1 = that._y1, x22 = that._x2, y22 = that._y2;
    if (that._l01_a > epsilon) {
      var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
      x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
      y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
    }
    if (that._l23_a > epsilon) {
      var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m = 3 * that._l23_a * (that._l23_a + that._l12_a);
      x22 = (x22 * b + that._x1 * that._l23_2a - x2 * that._l12_2a) / m;
      y22 = (y22 * b + that._y1 * that._l23_2a - y2 * that._l12_2a) / m;
    }
    that._context.bezierCurveTo(x1, y1, x22, y22, that._x2, that._y2);
  }
  function CatmullRom(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRom.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          this.point(this._x2, this._y2);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
        default:
          point$2(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRom = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRom(context, alpha) : new Cardinal(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomClosed(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomClosed.prototype = {
    areaStart: noop$3,
    areaEnd: noop$3,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$2(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomClosed = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomClosed(context, alpha) : new CardinalClosed(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomOpen(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$2(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomOpen = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomOpen(context, alpha) : new CardinalOpen(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function LinearClosed(context) {
    this._context = context;
  }
  LinearClosed.prototype = {
    areaStart: noop$3,
    areaEnd: noop$3,
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._point)
        this._context.closePath();
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point)
        this._context.lineTo(x2, y2);
      else
        this._point = 1, this._context.moveTo(x2, y2);
    }
  };
  function curveLinearClosed(context) {
    return new LinearClosed(context);
  }
  function sign(x2) {
    return x2 < 0 ? -1 : 1;
  }
  function slope3(that, x2, y2) {
    var h0 = that._x1 - that._x0, h1 = x2 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0), p2 = (s0 * h1 + s1 * h0) / (h0 + h1);
    return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p2)) || 0;
  }
  function slope2(that, t) {
    var h = that._x1 - that._x0;
    return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
  }
  function point$1(that, t02, t12) {
    var x0 = that._x0, y0 = that._y0, x1 = that._x1, y1 = that._y1, dx = (x1 - x0) / 3;
    that._context.bezierCurveTo(x0 + dx, y0 + dx * t02, x1 - dx, y1 - dx * t12, x1, y1);
  }
  function MonotoneX(context) {
    this._context = context;
  }
  MonotoneX.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
        case 3:
          point$1(this, this._t0, slope2(this, this._t0));
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      var t12 = NaN;
      x2 = +x2, y2 = +y2;
      if (x2 === this._x1 && y2 === this._y1)
        return;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          point$1(this, slope2(this, t12 = slope3(this, x2, y2)), t12);
          break;
        default:
          point$1(this, this._t0, t12 = slope3(this, x2, y2));
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
      this._t0 = t12;
    }
  };
  function MonotoneY(context) {
    this._context = new ReflectContext(context);
  }
  (MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x2, y2) {
    MonotoneX.prototype.point.call(this, y2, x2);
  };
  function ReflectContext(context) {
    this._context = context;
  }
  ReflectContext.prototype = {
    moveTo: function(x2, y2) {
      this._context.moveTo(y2, x2);
    },
    closePath: function() {
      this._context.closePath();
    },
    lineTo: function(x2, y2) {
      this._context.lineTo(y2, x2);
    },
    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
      this._context.bezierCurveTo(y1, x1, y2, x2, y3, x3);
    }
  };
  function monotoneX(context) {
    return new MonotoneX(context);
  }
  function monotoneY(context) {
    return new MonotoneY(context);
  }
  function Natural(context) {
    this._context = context;
  }
  Natural.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = [];
      this._y = [];
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, n = x2.length;
      if (n) {
        this._line ? this._context.lineTo(x2[0], y2[0]) : this._context.moveTo(x2[0], y2[0]);
        if (n === 2) {
          this._context.lineTo(x2[1], y2[1]);
        } else {
          var px = controlPoints$1(x2), py = controlPoints$1(y2);
          for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
            this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x2[i1], y2[i1]);
          }
        }
      }
      if (this._line || this._line !== 0 && n === 1)
        this._context.closePath();
      this._line = 1 - this._line;
      this._x = this._y = null;
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  function controlPoints$1(x2) {
    var i2, n = x2.length - 1, m, a = new Array(n), b = new Array(n), r = new Array(n);
    a[0] = 0, b[0] = 2, r[0] = x2[0] + 2 * x2[1];
    for (i2 = 1; i2 < n - 1; ++i2)
      a[i2] = 1, b[i2] = 4, r[i2] = 4 * x2[i2] + 2 * x2[i2 + 1];
    a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x2[n - 1] + x2[n];
    for (i2 = 1; i2 < n; ++i2)
      m = a[i2] / b[i2 - 1], b[i2] -= m, r[i2] -= m * r[i2 - 1];
    a[n - 1] = r[n - 1] / b[n - 1];
    for (i2 = n - 2; i2 >= 0; --i2)
      a[i2] = (r[i2] - a[i2 + 1]) / b[i2];
    b[n - 1] = (x2[n] + a[n - 1]) / 2;
    for (i2 = 0; i2 < n - 1; ++i2)
      b[i2] = 2 * x2[i2 + 1] - a[i2 + 1];
    return [a, b];
  }
  function curveNatural(context) {
    return new Natural(context);
  }
  function Step(context, t) {
    this._context = context;
    this._t = t;
  }
  Step.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = this._y = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (0 < this._t && this._t < 1 && this._point === 2)
        this._context.lineTo(this._x, this._y);
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      if (this._line >= 0)
        this._t = 1 - this._t, this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default: {
          if (this._t <= 0) {
            this._context.lineTo(this._x, y2);
            this._context.lineTo(x2, y2);
          } else {
            var x1 = this._x * (1 - this._t) + x2 * this._t;
            this._context.lineTo(x1, this._y);
            this._context.lineTo(x1, y2);
          }
          break;
        }
      }
      this._x = x2, this._y = y2;
    }
  };
  function curveStep(context) {
    return new Step(context, 0.5);
  }
  function stepBefore(context) {
    return new Step(context, 0);
  }
  function stepAfter(context) {
    return new Step(context, 1);
  }
  function Transform(k, x2, y2) {
    this.k = k;
    this.x = x2;
    this.y = y2;
  }
  Transform.prototype = {
    constructor: Transform,
    scale: function(k) {
      return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
    },
    translate: function(x2, y2) {
      return x2 === 0 & y2 === 0 ? this : new Transform(this.k, this.x + this.k * x2, this.y + this.k * y2);
    },
    apply: function(point2) {
      return [point2[0] * this.k + this.x, point2[1] * this.k + this.y];
    },
    applyX: function(x2) {
      return x2 * this.k + this.x;
    },
    applyY: function(y2) {
      return y2 * this.k + this.y;
    },
    invert: function(location2) {
      return [(location2[0] - this.x) / this.k, (location2[1] - this.y) / this.k];
    },
    invertX: function(x2) {
      return (x2 - this.x) / this.k;
    },
    invertY: function(y2) {
      return (y2 - this.y) / this.k;
    },
    rescaleX: function(x2) {
      return x2.copy().domain(x2.range().map(this.invertX, this).map(x2.invert, x2));
    },
    rescaleY: function(y2) {
      return y2.copy().domain(y2.range().map(this.invertY, this).map(y2.invert, y2));
    },
    toString: function() {
      return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
    }
  };
  new Transform(1, 0, 0);
  Transform.prototype;
  /*! @license DOMPurify 2.4.3 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.4.3/LICENSE */
  function _typeof$1(obj) {
    "@babel/helpers - typeof";
    return _typeof$1 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof$1(obj);
  }
  function _setPrototypeOf(o, p2) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p3) {
      o2.__proto__ = p3;
      return o2;
    };
    return _setPrototypeOf(o, p2);
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e) {
      return false;
    }
  }
  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct;
    } else {
      _construct = function _construct2(Parent2, args2, Class2) {
        var a = [null];
        a.push.apply(a, args2);
        var Constructor = Function.bind.apply(Parent2, a);
        var instance2 = new Constructor();
        if (Class2)
          _setPrototypeOf(instance2, Class2.prototype);
        return instance2;
      };
    }
    return _construct.apply(null, arguments);
  }
  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$1(arr) || _nonIterableSpread();
  }
  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr))
      return _arrayLikeToArray$1(arr);
  }
  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
      return Array.from(iter);
  }
  function _unsupportedIterableToArray$1(o, minLen) {
    if (!o)
      return;
    if (typeof o === "string")
      return _arrayLikeToArray$1(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor)
      n = o.constructor.name;
    if (n === "Map" || n === "Set")
      return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
      return _arrayLikeToArray$1(o, minLen);
  }
  function _arrayLikeToArray$1(arr, len) {
    if (len == null || len > arr.length)
      len = arr.length;
    for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
      arr2[i2] = arr[i2];
    return arr2;
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var hasOwnProperty$l = Object.hasOwnProperty, setPrototypeOf = Object.setPrototypeOf, isFrozen = Object.isFrozen, getPrototypeOf = Object.getPrototypeOf, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
  var freeze = Object.freeze, seal = Object.seal, create = Object.create;
  var _ref = typeof Reflect !== "undefined" && Reflect, apply$2 = _ref.apply, construct = _ref.construct;
  if (!apply$2) {
    apply$2 = function apply2(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }
  if (!freeze) {
    freeze = function freeze2(x2) {
      return x2;
    };
  }
  if (!seal) {
    seal = function seal2(x2) {
      return x2;
    };
  }
  if (!construct) {
    construct = function construct2(Func, args) {
      return _construct(Func, _toConsumableArray(args));
    };
  }
  var arrayForEach = unapply(Array.prototype.forEach);
  var arrayPop = unapply(Array.prototype.pop);
  var arrayPush$1 = unapply(Array.prototype.push);
  var stringToLowerCase = unapply(String.prototype.toLowerCase);
  var stringToString = unapply(String.prototype.toString);
  var stringMatch = unapply(String.prototype.match);
  var stringReplace = unapply(String.prototype.replace);
  var stringIndexOf = unapply(String.prototype.indexOf);
  var stringTrim = unapply(String.prototype.trim);
  var regExpTest = unapply(RegExp.prototype.test);
  var typeErrorCreate = unconstruct(TypeError);
  function unapply(func) {
    return function(thisArg) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return apply$2(func, thisArg, args);
    };
  }
  function unconstruct(func) {
    return function() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return construct(func, args);
    };
  }
  function addToSet(set2, array2, transformCaseFunc) {
    transformCaseFunc = transformCaseFunc ? transformCaseFunc : stringToLowerCase;
    if (setPrototypeOf) {
      setPrototypeOf(set2, null);
    }
    var l = array2.length;
    while (l--) {
      var element2 = array2[l];
      if (typeof element2 === "string") {
        var lcElement = transformCaseFunc(element2);
        if (lcElement !== element2) {
          if (!isFrozen(array2)) {
            array2[l] = lcElement;
          }
          element2 = lcElement;
        }
      }
      set2[element2] = true;
    }
    return set2;
  }
  function clone$3(object2) {
    var newObject = create(null);
    var property2;
    for (property2 in object2) {
      if (apply$2(hasOwnProperty$l, object2, [property2]) === true) {
        newObject[property2] = object2[property2];
      }
    }
    return newObject;
  }
  function lookupGetter(object2, prop) {
    while (object2 !== null) {
      var desc = getOwnPropertyDescriptor(object2, prop);
      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }
        if (typeof desc.value === "function") {
          return unapply(desc.value);
        }
      }
      object2 = getPrototypeOf(object2);
    }
    function fallbackValue(element2) {
      console.warn("fallback value for", element2);
      return null;
    }
    return fallbackValue;
  }
  var html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
  var svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
  var svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
  var svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "fedropshadow", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
  var mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover"]);
  var mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
  var text = freeze(["#text"]);
  var html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
  var svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
  var mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
  var xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
  var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
  var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
  var TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
  var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
  var ARIA_ATTR = seal(/^aria-[\-\w]+$/);
  var IS_ALLOWED_URI = seal(
    /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
  );
  var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
  var ATTR_WHITESPACE = seal(
    /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
  );
  var DOCTYPE_NAME = seal(/^html$/i);
  var getGlobal = function getGlobal2() {
    return typeof window === "undefined" ? null : window;
  };
  var _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, document2) {
    if (_typeof$1(trustedTypes) !== "object" || typeof trustedTypes.createPolicy !== "function") {
      return null;
    }
    var suffix = null;
    var ATTR_NAME = "data-tt-policy-suffix";
    if (document2.currentScript && document2.currentScript.hasAttribute(ATTR_NAME)) {
      suffix = document2.currentScript.getAttribute(ATTR_NAME);
    }
    var policyName = "dompurify" + (suffix ? "#" + suffix : "");
    try {
      return trustedTypes.createPolicy(policyName, {
        createHTML: function createHTML(html2) {
          return html2;
        },
        createScriptURL: function createScriptURL(scriptUrl) {
          return scriptUrl;
        }
      });
    } catch (_2) {
      console.warn("TrustedTypes policy " + policyName + " could not be created.");
      return null;
    }
  };
  function createDOMPurify() {
    var window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
    var DOMPurify = function DOMPurify2(root2) {
      return createDOMPurify(root2);
    };
    DOMPurify.version = "2.4.3";
    DOMPurify.removed = [];
    if (!window2 || !window2.document || window2.document.nodeType !== 9) {
      DOMPurify.isSupported = false;
      return DOMPurify;
    }
    var originalDocument = window2.document;
    var document2 = window2.document;
    var DocumentFragment = window2.DocumentFragment, HTMLTemplateElement = window2.HTMLTemplateElement, Node = window2.Node, Element2 = window2.Element, NodeFilter = window2.NodeFilter, _window$NamedNodeMap = window2.NamedNodeMap, NamedNodeMap = _window$NamedNodeMap === void 0 ? window2.NamedNodeMap || window2.MozNamedAttrMap : _window$NamedNodeMap, HTMLFormElement = window2.HTMLFormElement, DOMParser2 = window2.DOMParser, trustedTypes = window2.trustedTypes;
    var ElementPrototype = Element2.prototype;
    var cloneNode = lookupGetter(ElementPrototype, "cloneNode");
    var getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
    var getChildNodes = lookupGetter(ElementPrototype, "childNodes");
    var getParentNode = lookupGetter(ElementPrototype, "parentNode");
    if (typeof HTMLTemplateElement === "function") {
      var template = document2.createElement("template");
      if (template.content && template.content.ownerDocument) {
        document2 = template.content.ownerDocument;
      }
    }
    var trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, originalDocument);
    var emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML("") : "";
    var _document = document2, implementation = _document.implementation, createNodeIterator = _document.createNodeIterator, createDocumentFragment = _document.createDocumentFragment, getElementsByTagName = _document.getElementsByTagName;
    var importNode = originalDocument.importNode;
    var documentMode = {};
    try {
      documentMode = clone$3(document2).documentMode ? document2.documentMode : {};
    } catch (_2) {
    }
    var hooks2 = {};
    DOMPurify.isSupported = typeof getParentNode === "function" && implementation && typeof implementation.createHTMLDocument !== "undefined" && documentMode !== 9;
    var MUSTACHE_EXPR$1 = MUSTACHE_EXPR, ERB_EXPR$1 = ERB_EXPR, TMPLIT_EXPR$1 = TMPLIT_EXPR, DATA_ATTR$1 = DATA_ATTR, ARIA_ATTR$1 = ARIA_ATTR, IS_SCRIPT_OR_DATA$1 = IS_SCRIPT_OR_DATA, ATTR_WHITESPACE$1 = ATTR_WHITESPACE;
    var IS_ALLOWED_URI$1 = IS_ALLOWED_URI;
    var ALLOWED_TAGS = null;
    var DEFAULT_ALLOWED_TAGS = addToSet({}, [].concat(_toConsumableArray(html$1), _toConsumableArray(svg$1), _toConsumableArray(svgFilters), _toConsumableArray(mathMl$1), _toConsumableArray(text)));
    var ALLOWED_ATTR = null;
    var DEFAULT_ALLOWED_ATTR = addToSet({}, [].concat(_toConsumableArray(html), _toConsumableArray(svg), _toConsumableArray(mathMl), _toConsumableArray(xml)));
    var CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
      tagNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      attributeNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      allowCustomizedBuiltInElements: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: false
      }
    }));
    var FORBID_TAGS = null;
    var FORBID_ATTR = null;
    var ALLOW_ARIA_ATTR = true;
    var ALLOW_DATA_ATTR = true;
    var ALLOW_UNKNOWN_PROTOCOLS = false;
    var SAFE_FOR_TEMPLATES = false;
    var WHOLE_DOCUMENT = false;
    var SET_CONFIG = false;
    var FORCE_BODY = false;
    var RETURN_DOM = false;
    var RETURN_DOM_FRAGMENT = false;
    var RETURN_TRUSTED_TYPE = false;
    var SANITIZE_DOM = true;
    var SANITIZE_NAMED_PROPS = false;
    var SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
    var KEEP_CONTENT = true;
    var IN_PLACE = false;
    var USE_PROFILES = {};
    var FORBID_CONTENTS = null;
    var DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
    var DATA_URI_TAGS = null;
    var DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
    var URI_SAFE_ATTRIBUTES = null;
    var DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
    var MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    var SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    var HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    var NAMESPACE = HTML_NAMESPACE;
    var IS_EMPTY_INPUT = false;
    var ALLOWED_NAMESPACES = null;
    var DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
    var PARSER_MEDIA_TYPE;
    var SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
    var DEFAULT_PARSER_MEDIA_TYPE = "text/html";
    var transformCaseFunc;
    var CONFIG = null;
    var formElement = document2.createElement("form");
    var isRegexOrFunction = function isRegexOrFunction2(testValue) {
      return testValue instanceof RegExp || testValue instanceof Function;
    };
    var _parseConfig = function _parseConfig2(cfg) {
      if (CONFIG && CONFIG === cfg) {
        return;
      }
      if (!cfg || _typeof$1(cfg) !== "object") {
        cfg = {};
      }
      cfg = clone$3(cfg);
      PARSER_MEDIA_TYPE = SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
      transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
      ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
      ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
      ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
      URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
        clone$3(DEFAULT_URI_SAFE_ATTRIBUTES),
        cfg.ADD_URI_SAFE_ATTR,
        transformCaseFunc
      ) : DEFAULT_URI_SAFE_ATTRIBUTES;
      DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
        clone$3(DEFAULT_DATA_URI_TAGS),
        cfg.ADD_DATA_URI_TAGS,
        transformCaseFunc
      ) : DEFAULT_DATA_URI_TAGS;
      FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
      FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
      FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
      USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
      ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
      ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
      ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
      SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
      WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
      RETURN_DOM = cfg.RETURN_DOM || false;
      RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
      RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
      FORCE_BODY = cfg.FORCE_BODY || false;
      SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
      SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
      KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
      IN_PLACE = cfg.IN_PLACE || false;
      IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI$1;
      NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
        CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
      }
      if (SAFE_FOR_TEMPLATES) {
        ALLOW_DATA_ATTR = false;
      }
      if (RETURN_DOM_FRAGMENT) {
        RETURN_DOM = true;
      }
      if (USE_PROFILES) {
        ALLOWED_TAGS = addToSet({}, _toConsumableArray(text));
        ALLOWED_ATTR = [];
        if (USE_PROFILES.html === true) {
          addToSet(ALLOWED_TAGS, html$1);
          addToSet(ALLOWED_ATTR, html);
        }
        if (USE_PROFILES.svg === true) {
          addToSet(ALLOWED_TAGS, svg$1);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.svgFilters === true) {
          addToSet(ALLOWED_TAGS, svgFilters);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.mathMl === true) {
          addToSet(ALLOWED_TAGS, mathMl$1);
          addToSet(ALLOWED_ATTR, mathMl);
          addToSet(ALLOWED_ATTR, xml);
        }
      }
      if (cfg.ADD_TAGS) {
        if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
          ALLOWED_TAGS = clone$3(ALLOWED_TAGS);
        }
        addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
      }
      if (cfg.ADD_ATTR) {
        if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
          ALLOWED_ATTR = clone$3(ALLOWED_ATTR);
        }
        addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
      }
      if (cfg.ADD_URI_SAFE_ATTR) {
        addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
      }
      if (cfg.FORBID_CONTENTS) {
        if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
          FORBID_CONTENTS = clone$3(FORBID_CONTENTS);
        }
        addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
      }
      if (KEEP_CONTENT) {
        ALLOWED_TAGS["#text"] = true;
      }
      if (WHOLE_DOCUMENT) {
        addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
      }
      if (ALLOWED_TAGS.table) {
        addToSet(ALLOWED_TAGS, ["tbody"]);
        delete FORBID_TAGS.tbody;
      }
      if (freeze) {
        freeze(cfg);
      }
      CONFIG = cfg;
    };
    var MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
    var HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
    var COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
    var ALL_SVG_TAGS = addToSet({}, svg$1);
    addToSet(ALL_SVG_TAGS, svgFilters);
    addToSet(ALL_SVG_TAGS, svgDisallowed);
    var ALL_MATHML_TAGS = addToSet({}, mathMl$1);
    addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
    var _checkValidNamespace = function _checkValidNamespace2(element2) {
      var parent = getParentNode(element2);
      if (!parent || !parent.tagName) {
        parent = {
          namespaceURI: NAMESPACE,
          tagName: "template"
        };
      }
      var tagName = stringToLowerCase(element2.tagName);
      var parentTagName = stringToLowerCase(parent.tagName);
      if (!ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return false;
      }
      if (element2.namespaceURI === SVG_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "svg";
        }
        if (parent.namespaceURI === MATHML_NAMESPACE) {
          return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
        }
        return Boolean(ALL_SVG_TAGS[tagName]);
      }
      if (element2.namespaceURI === MATHML_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "math";
        }
        if (parent.namespaceURI === SVG_NAMESPACE) {
          return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
        }
        return Boolean(ALL_MATHML_TAGS[tagName]);
      }
      if (element2.namespaceURI === HTML_NAMESPACE) {
        if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return true;
      }
      return false;
    };
    var _forceRemove = function _forceRemove2(node2) {
      arrayPush$1(DOMPurify.removed, {
        element: node2
      });
      try {
        node2.parentNode.removeChild(node2);
      } catch (_2) {
        try {
          node2.outerHTML = emptyHTML;
        } catch (_3) {
          node2.remove();
        }
      }
    };
    var _removeAttribute = function _removeAttribute2(name2, node2) {
      try {
        arrayPush$1(DOMPurify.removed, {
          attribute: node2.getAttributeNode(name2),
          from: node2
        });
      } catch (_2) {
        arrayPush$1(DOMPurify.removed, {
          attribute: null,
          from: node2
        });
      }
      node2.removeAttribute(name2);
      if (name2 === "is" && !ALLOWED_ATTR[name2]) {
        if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
          try {
            _forceRemove(node2);
          } catch (_2) {
          }
        } else {
          try {
            node2.setAttribute(name2, "");
          } catch (_2) {
          }
        }
      }
    };
    var _initDocument = function _initDocument2(dirty) {
      var doc;
      var leadingWhitespace;
      if (FORCE_BODY) {
        dirty = "<remove></remove>" + dirty;
      } else {
        var matches2 = stringMatch(dirty, /^[\r\n\t ]+/);
        leadingWhitespace = matches2 && matches2[0];
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
        dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
      }
      var dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
      if (NAMESPACE === HTML_NAMESPACE) {
        try {
          doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
        } catch (_2) {
        }
      }
      if (!doc || !doc.documentElement) {
        doc = implementation.createDocument(NAMESPACE, "template", null);
        try {
          doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
        } catch (_2) {
        }
      }
      var body = doc.body || doc.documentElement;
      if (dirty && leadingWhitespace) {
        body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
      }
      if (NAMESPACE === HTML_NAMESPACE) {
        return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
      }
      return WHOLE_DOCUMENT ? doc.documentElement : body;
    };
    var _createIterator = function _createIterator2(root2) {
      return createNodeIterator.call(
        root2.ownerDocument || root2,
        root2,
        NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
        null,
        false
      );
    };
    var _isClobbered = function _isClobbered2(elm) {
      return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
    };
    var _isNode = function _isNode2(object2) {
      return _typeof$1(Node) === "object" ? object2 instanceof Node : object2 && _typeof$1(object2) === "object" && typeof object2.nodeType === "number" && typeof object2.nodeName === "string";
    };
    var _executeHook = function _executeHook2(entryPoint, currentNode, data2) {
      if (!hooks2[entryPoint]) {
        return;
      }
      arrayForEach(hooks2[entryPoint], function(hook) {
        hook.call(DOMPurify, currentNode, data2, CONFIG);
      });
    };
    var _sanitizeElements = function _sanitizeElements2(currentNode) {
      var content;
      _executeHook("beforeSanitizeElements", currentNode, null);
      if (_isClobbered(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      if (regExpTest(/[\u0080-\uFFFF]/, currentNode.nodeName)) {
        _forceRemove(currentNode);
        return true;
      }
      var tagName = transformCaseFunc(currentNode.nodeName);
      _executeHook("uponSanitizeElement", currentNode, {
        tagName,
        allowedTags: ALLOWED_TAGS
      });
      if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
        _forceRemove(currentNode);
        return true;
      }
      if (tagName === "select" && regExpTest(/<template/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);
        return true;
      }
      if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
        if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName))
            return false;
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName))
            return false;
        }
        if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
          var parentNode = getParentNode(currentNode) || currentNode.parentNode;
          var childNodes = getChildNodes(currentNode) || currentNode.childNodes;
          if (childNodes && parentNode) {
            var childCount = childNodes.length;
            for (var i2 = childCount - 1; i2 >= 0; --i2) {
              parentNode.insertBefore(cloneNode(childNodes[i2], true), getNextSibling(currentNode));
            }
          }
        }
        _forceRemove(currentNode);
        return true;
      }
      if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      if ((tagName === "noscript" || tagName === "noembed") && regExpTest(/<\/no(script|embed)/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);
        return true;
      }
      if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
        content = currentNode.textContent;
        content = stringReplace(content, MUSTACHE_EXPR$1, " ");
        content = stringReplace(content, ERB_EXPR$1, " ");
        content = stringReplace(content, TMPLIT_EXPR$1, " ");
        if (currentNode.textContent !== content) {
          arrayPush$1(DOMPurify.removed, {
            element: currentNode.cloneNode()
          });
          currentNode.textContent = content;
        }
      }
      _executeHook("afterSanitizeElements", currentNode, null);
      return false;
    };
    var _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value) {
      if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value in document2 || value in formElement)) {
        return false;
      }
      if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR$1, lcName))
        ;
      else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR$1, lcName))
        ;
      else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
        if (_basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value)))
          ;
        else {
          return false;
        }
      } else if (URI_SAFE_ATTRIBUTES[lcName])
        ;
      else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
        ;
      else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value, "data:") === 0 && DATA_URI_TAGS[lcTag])
        ;
      else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
        ;
      else if (!value)
        ;
      else {
        return false;
      }
      return true;
    };
    var _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
      return tagName.indexOf("-") > 0;
    };
    var _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
      var attr;
      var value;
      var lcName;
      var l;
      _executeHook("beforeSanitizeAttributes", currentNode, null);
      var attributes = currentNode.attributes;
      if (!attributes) {
        return;
      }
      var hookEvent = {
        attrName: "",
        attrValue: "",
        keepAttr: true,
        allowedAttributes: ALLOWED_ATTR
      };
      l = attributes.length;
      while (l--) {
        attr = attributes[l];
        var _attr = attr, name2 = _attr.name, namespaceURI = _attr.namespaceURI;
        value = name2 === "value" ? attr.value : stringTrim(attr.value);
        lcName = transformCaseFunc(name2);
        hookEvent.attrName = lcName;
        hookEvent.attrValue = value;
        hookEvent.keepAttr = true;
        hookEvent.forceKeepAttr = void 0;
        _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
        value = hookEvent.attrValue;
        if (hookEvent.forceKeepAttr) {
          continue;
        }
        _removeAttribute(name2, currentNode);
        if (!hookEvent.keepAttr) {
          continue;
        }
        if (regExpTest(/\/>/i, value)) {
          _removeAttribute(name2, currentNode);
          continue;
        }
        if (SAFE_FOR_TEMPLATES) {
          value = stringReplace(value, MUSTACHE_EXPR$1, " ");
          value = stringReplace(value, ERB_EXPR$1, " ");
          value = stringReplace(value, TMPLIT_EXPR$1, " ");
        }
        var lcTag = transformCaseFunc(currentNode.nodeName);
        if (!_isValidAttribute(lcTag, lcName, value)) {
          continue;
        }
        if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
          _removeAttribute(name2, currentNode);
          value = SANITIZE_NAMED_PROPS_PREFIX + value;
        }
        if (trustedTypesPolicy && _typeof$1(trustedTypes) === "object" && typeof trustedTypes.getAttributeType === "function") {
          if (namespaceURI)
            ;
          else {
            switch (trustedTypes.getAttributeType(lcTag, lcName)) {
              case "TrustedHTML":
                value = trustedTypesPolicy.createHTML(value);
                break;
              case "TrustedScriptURL":
                value = trustedTypesPolicy.createScriptURL(value);
                break;
            }
          }
        }
        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name2, value);
          } else {
            currentNode.setAttribute(name2, value);
          }
          arrayPop(DOMPurify.removed);
        } catch (_2) {
        }
      }
      _executeHook("afterSanitizeAttributes", currentNode, null);
    };
    var _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
      var shadowNode;
      var shadowIterator = _createIterator(fragment);
      _executeHook("beforeSanitizeShadowDOM", fragment, null);
      while (shadowNode = shadowIterator.nextNode()) {
        _executeHook("uponSanitizeShadowNode", shadowNode, null);
        if (_sanitizeElements(shadowNode)) {
          continue;
        }
        if (shadowNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM2(shadowNode.content);
        }
        _sanitizeAttributes(shadowNode);
      }
      _executeHook("afterSanitizeShadowDOM", fragment, null);
    };
    DOMPurify.sanitize = function(dirty) {
      var cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      var body;
      var importedNode;
      var currentNode;
      var oldNode;
      var returnNode;
      IS_EMPTY_INPUT = !dirty;
      if (IS_EMPTY_INPUT) {
        dirty = "<!-->";
      }
      if (typeof dirty !== "string" && !_isNode(dirty)) {
        if (typeof dirty.toString !== "function") {
          throw typeErrorCreate("toString is not a function");
        } else {
          dirty = dirty.toString();
          if (typeof dirty !== "string") {
            throw typeErrorCreate("dirty is not a string, aborting");
          }
        }
      }
      if (!DOMPurify.isSupported) {
        if (_typeof$1(window2.toStaticHTML) === "object" || typeof window2.toStaticHTML === "function") {
          if (typeof dirty === "string") {
            return window2.toStaticHTML(dirty);
          }
          if (_isNode(dirty)) {
            return window2.toStaticHTML(dirty.outerHTML);
          }
        }
        return dirty;
      }
      if (!SET_CONFIG) {
        _parseConfig(cfg);
      }
      DOMPurify.removed = [];
      if (typeof dirty === "string") {
        IN_PLACE = false;
      }
      if (IN_PLACE) {
        if (dirty.nodeName) {
          var tagName = transformCaseFunc(dirty.nodeName);
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
          }
        }
      } else if (dirty instanceof Node) {
        body = _initDocument("<!---->");
        importedNode = body.ownerDocument.importNode(dirty, true);
        if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
          body = importedNode;
        } else if (importedNode.nodeName === "HTML") {
          body = importedNode;
        } else {
          body.appendChild(importedNode);
        }
      } else {
        if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && dirty.indexOf("<") === -1) {
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
        }
        body = _initDocument(dirty);
        if (!body) {
          return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
        }
      }
      if (body && FORCE_BODY) {
        _forceRemove(body.firstChild);
      }
      var nodeIterator = _createIterator(IN_PLACE ? dirty : body);
      while (currentNode = nodeIterator.nextNode()) {
        if (currentNode.nodeType === 3 && currentNode === oldNode) {
          continue;
        }
        if (_sanitizeElements(currentNode)) {
          continue;
        }
        if (currentNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(currentNode.content);
        }
        _sanitizeAttributes(currentNode);
        oldNode = currentNode;
      }
      oldNode = null;
      if (IN_PLACE) {
        return dirty;
      }
      if (RETURN_DOM) {
        if (RETURN_DOM_FRAGMENT) {
          returnNode = createDocumentFragment.call(body.ownerDocument);
          while (body.firstChild) {
            returnNode.appendChild(body.firstChild);
          }
        } else {
          returnNode = body;
        }
        if (ALLOWED_ATTR.shadowroot) {
          returnNode = importNode.call(originalDocument, returnNode, true);
        }
        return returnNode;
      }
      var serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
      if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
        serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
      }
      if (SAFE_FOR_TEMPLATES) {
        serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR$1, " ");
        serializedHTML = stringReplace(serializedHTML, ERB_EXPR$1, " ");
        serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR$1, " ");
      }
      return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
    };
    DOMPurify.setConfig = function(cfg) {
      _parseConfig(cfg);
      SET_CONFIG = true;
    };
    DOMPurify.clearConfig = function() {
      CONFIG = null;
      SET_CONFIG = false;
    };
    DOMPurify.isValidAttribute = function(tag, attr, value) {
      if (!CONFIG) {
        _parseConfig({});
      }
      var lcTag = transformCaseFunc(tag);
      var lcName = transformCaseFunc(attr);
      return _isValidAttribute(lcTag, lcName, value);
    };
    DOMPurify.addHook = function(entryPoint, hookFunction) {
      if (typeof hookFunction !== "function") {
        return;
      }
      hooks2[entryPoint] = hooks2[entryPoint] || [];
      arrayPush$1(hooks2[entryPoint], hookFunction);
    };
    DOMPurify.removeHook = function(entryPoint) {
      if (hooks2[entryPoint]) {
        return arrayPop(hooks2[entryPoint]);
      }
    };
    DOMPurify.removeHooks = function(entryPoint) {
      if (hooks2[entryPoint]) {
        hooks2[entryPoint] = [];
      }
    };
    DOMPurify.removeAllHooks = function() {
      hooks2 = {};
    };
    return DOMPurify;
  }
  var purify = createDOMPurify();
  const getRows = (s) => {
    if (!s) {
      return [""];
    }
    const str2 = breakToPlaceholder(s).replace(/\\n/g, "#br#");
    return str2.split("#br#");
  };
  const removeScript = (txt) => {
    return purify.sanitize(txt);
  };
  const sanitizeMore = (text2, config2) => {
    var _a;
    if (((_a = config2.flowchart) == null ? void 0 : _a.htmlLabels) !== false) {
      const level = config2.securityLevel;
      if (level === "antiscript" || level === "strict") {
        text2 = removeScript(text2);
      } else if (level !== "loose") {
        text2 = breakToPlaceholder(text2);
        text2 = text2.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        text2 = text2.replace(/=/g, "&equals;");
        text2 = placeholderToBreak(text2);
      }
    }
    return text2;
  };
  const sanitizeText$6 = (text2, config2) => {
    if (!text2) {
      return text2;
    }
    if (config2.dompurifyConfig) {
      text2 = purify.sanitize(sanitizeMore(text2, config2), config2.dompurifyConfig).toString();
    } else {
      text2 = purify.sanitize(sanitizeMore(text2, config2), {
        FORBID_TAGS: ["style"]
      }).toString();
    }
    return text2;
  };
  const sanitizeTextOrArray = (a, config2) => {
    if (typeof a === "string") {
      return sanitizeText$6(a, config2);
    }
    return a.flat().map((x2) => sanitizeText$6(x2, config2));
  };
  const lineBreakRegex = /<br\s*\/?>/gi;
  const hasBreaks = (text2) => {
    return lineBreakRegex.test(text2);
  };
  const splitBreaks = (text2) => {
    return text2.split(lineBreakRegex);
  };
  const placeholderToBreak = (s) => {
    return s.replace(/#br#/g, "<br/>");
  };
  const breakToPlaceholder = (s) => {
    return s.replace(lineBreakRegex, "#br#");
  };
  const getUrl = (useAbsolute) => {
    let url = "";
    if (useAbsolute) {
      url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
      url = url.replaceAll(/\(/g, "\\(");
      url = url.replaceAll(/\)/g, "\\)");
    }
    return url;
  };
  const evaluate = (val) => val === false || ["false", "null", "0"].includes(String(val).trim().toLowerCase()) ? false : true;
  const parseGenericTypes = function(text2) {
    let cleanedText = text2;
    if (text2.split("~").length - 1 >= 2) {
      let newCleanedText = cleanedText;
      do {
        cleanedText = newCleanedText;
        newCleanedText = cleanedText.replace(/~([^\s,:;]+)~/, "<$1>");
      } while (newCleanedText != cleanedText);
      return parseGenericTypes(newCleanedText);
    } else {
      return cleanedText;
    }
  };
  const common$1 = {
    getRows,
    sanitizeText: sanitizeText$6,
    sanitizeTextOrArray,
    hasBreaks,
    splitBreaks,
    lineBreakRegex,
    removeScript,
    getUrl,
    evaluate
  };
  const Channel = {
    min: {
      r: 0,
      g: 0,
      b: 0,
      s: 0,
      l: 0,
      a: 0
    },
    max: {
      r: 255,
      g: 255,
      b: 255,
      h: 360,
      s: 100,
      l: 100,
      a: 1
    },
    clamp: {
      r: (r) => r >= 255 ? 255 : r < 0 ? 0 : r,
      g: (g) => g >= 255 ? 255 : g < 0 ? 0 : g,
      b: (b) => b >= 255 ? 255 : b < 0 ? 0 : b,
      h: (h) => h % 360,
      s: (s) => s >= 100 ? 100 : s < 0 ? 0 : s,
      l: (l) => l >= 100 ? 100 : l < 0 ? 0 : l,
      a: (a) => a >= 1 ? 1 : a < 0 ? 0 : a
    },
    toLinear: (c2) => {
      const n = c2 / 255;
      return c2 > 0.03928 ? Math.pow((n + 0.055) / 1.055, 2.4) : n / 12.92;
    },
    hue2rgb: (p2, q, t) => {
      if (t < 0)
        t += 1;
      if (t > 1)
        t -= 1;
      if (t < 1 / 6)
        return p2 + (q - p2) * 6 * t;
      if (t < 1 / 2)
        return q;
      if (t < 2 / 3)
        return p2 + (q - p2) * (2 / 3 - t) * 6;
      return p2;
    },
    hsl2rgb: ({ h, s, l }, channel2) => {
      if (!s)
        return l * 2.55;
      h /= 360;
      s /= 100;
      l /= 100;
      const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      const p2 = 2 * l - q;
      switch (channel2) {
        case "r":
          return Channel.hue2rgb(p2, q, h + 1 / 3) * 255;
        case "g":
          return Channel.hue2rgb(p2, q, h) * 255;
        case "b":
          return Channel.hue2rgb(p2, q, h - 1 / 3) * 255;
      }
    },
    rgb2hsl: ({ r, g, b }, channel2) => {
      r /= 255;
      g /= 255;
      b /= 255;
      const max2 = Math.max(r, g, b);
      const min2 = Math.min(r, g, b);
      const l = (max2 + min2) / 2;
      if (channel2 === "l")
        return l * 100;
      if (max2 === min2)
        return 0;
      const d = max2 - min2;
      const s = l > 0.5 ? d / (2 - max2 - min2) : d / (max2 + min2);
      if (channel2 === "s")
        return s * 100;
      switch (max2) {
        case r:
          return ((g - b) / d + (g < b ? 6 : 0)) * 60;
        case g:
          return ((b - r) / d + 2) * 60;
        case b:
          return ((r - g) / d + 4) * 60;
        default:
          return -1;
      }
    }
  };
  const channel = Channel;
  const Lang = {
    clamp: (number2, lower2, upper) => {
      if (lower2 > upper)
        return Math.min(lower2, Math.max(upper, number2));
      return Math.min(upper, Math.max(lower2, number2));
    },
    round: (number2) => {
      return Math.round(number2 * 1e10) / 1e10;
    }
  };
  const lang = Lang;
  const Unit = {
    dec2hex: (dec) => {
      const hex2 = Math.round(dec).toString(16);
      return hex2.length > 1 ? hex2 : `0${hex2}`;
    }
  };
  const unit = Unit;
  const Utils = {
    channel,
    lang,
    unit
  };
  const _ = Utils;
  const DEC2HEX = {};
  for (let i2 = 0; i2 <= 255; i2++)
    DEC2HEX[i2] = _.unit.dec2hex(i2);
  const TYPE = {
    ALL: 0,
    RGB: 1,
    HSL: 2
  };
  class Type$2 {
    constructor() {
      this.type = TYPE.ALL;
    }
    get() {
      return this.type;
    }
    set(type2) {
      if (this.type && this.type !== type2)
        throw new Error("Cannot change both RGB and HSL channels at the same time");
      this.type = type2;
    }
    reset() {
      this.type = TYPE.ALL;
    }
    is(type2) {
      return this.type === type2;
    }
  }
  const Type$3 = Type$2;
  class Channels {
    constructor(data2, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data2;
      this.type = new Type$3();
    }
    set(data2, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data2;
      this.type.type = TYPE.ALL;
      return this;
    }
    _ensureHSL() {
      const data2 = this.data;
      const { h, s, l } = data2;
      if (h === void 0)
        data2.h = _.channel.rgb2hsl(data2, "h");
      if (s === void 0)
        data2.s = _.channel.rgb2hsl(data2, "s");
      if (l === void 0)
        data2.l = _.channel.rgb2hsl(data2, "l");
    }
    _ensureRGB() {
      const data2 = this.data;
      const { r, g, b } = data2;
      if (r === void 0)
        data2.r = _.channel.hsl2rgb(data2, "r");
      if (g === void 0)
        data2.g = _.channel.hsl2rgb(data2, "g");
      if (b === void 0)
        data2.b = _.channel.hsl2rgb(data2, "b");
    }
    get r() {
      const data2 = this.data;
      const r = data2.r;
      if (!this.type.is(TYPE.HSL) && r !== void 0)
        return r;
      this._ensureHSL();
      return _.channel.hsl2rgb(data2, "r");
    }
    get g() {
      const data2 = this.data;
      const g = data2.g;
      if (!this.type.is(TYPE.HSL) && g !== void 0)
        return g;
      this._ensureHSL();
      return _.channel.hsl2rgb(data2, "g");
    }
    get b() {
      const data2 = this.data;
      const b = data2.b;
      if (!this.type.is(TYPE.HSL) && b !== void 0)
        return b;
      this._ensureHSL();
      return _.channel.hsl2rgb(data2, "b");
    }
    get h() {
      const data2 = this.data;
      const h = data2.h;
      if (!this.type.is(TYPE.RGB) && h !== void 0)
        return h;
      this._ensureRGB();
      return _.channel.rgb2hsl(data2, "h");
    }
    get s() {
      const data2 = this.data;
      const s = data2.s;
      if (!this.type.is(TYPE.RGB) && s !== void 0)
        return s;
      this._ensureRGB();
      return _.channel.rgb2hsl(data2, "s");
    }
    get l() {
      const data2 = this.data;
      const l = data2.l;
      if (!this.type.is(TYPE.RGB) && l !== void 0)
        return l;
      this._ensureRGB();
      return _.channel.rgb2hsl(data2, "l");
    }
    get a() {
      return this.data.a;
    }
    set r(r) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.r = r;
    }
    set g(g) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.g = g;
    }
    set b(b) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.b = b;
    }
    set h(h) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.h = h;
    }
    set s(s) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.s = s;
    }
    set l(l) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.l = l;
    }
    set a(a) {
      this.changed = true;
      this.data.a = a;
    }
  }
  const Channels$1 = Channels;
  const channels = new Channels$1({ r: 0, g: 0, b: 0, a: 0 }, "transparent");
  const ChannelsReusable = channels;
  const Hex = {
    re: /^#((?:[a-f0-9]{2}){2,4}|[a-f0-9]{3})$/i,
    parse: (color2) => {
      if (color2.charCodeAt(0) !== 35)
        return;
      const match5 = color2.match(Hex.re);
      if (!match5)
        return;
      const hex2 = match5[1];
      const dec = parseInt(hex2, 16);
      const length2 = hex2.length;
      const hasAlpha = length2 % 4 === 0;
      const isFullLength = length2 > 4;
      const multiplier = isFullLength ? 1 : 17;
      const bits = isFullLength ? 8 : 4;
      const bitsOffset = hasAlpha ? 0 : -1;
      const mask = isFullLength ? 255 : 15;
      return ChannelsReusable.set({
        r: (dec >> bits * (bitsOffset + 3) & mask) * multiplier,
        g: (dec >> bits * (bitsOffset + 2) & mask) * multiplier,
        b: (dec >> bits * (bitsOffset + 1) & mask) * multiplier,
        a: hasAlpha ? (dec & mask) * multiplier / 255 : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}${DEC2HEX[Math.round(a * 255)]}`;
      } else {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}`;
      }
    }
  };
  const Hex$1 = Hex;
  const HSL = {
    re: /^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,
    hueRe: /^(.+?)(deg|grad|rad|turn)$/i,
    _hue2deg: (hue2) => {
      const match5 = hue2.match(HSL.hueRe);
      if (match5) {
        const [, number2, unit2] = match5;
        switch (unit2) {
          case "grad":
            return _.channel.clamp.h(parseFloat(number2) * 0.9);
          case "rad":
            return _.channel.clamp.h(parseFloat(number2) * 180 / Math.PI);
          case "turn":
            return _.channel.clamp.h(parseFloat(number2) * 360);
        }
      }
      return _.channel.clamp.h(parseFloat(hue2));
    },
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 104 && charCode !== 72)
        return;
      const match5 = color2.match(HSL.re);
      if (!match5)
        return;
      const [, h, s, l, a, isAlphaPercentage] = match5;
      return ChannelsReusable.set({
        h: HSL._hue2deg(h),
        s: _.channel.clamp.s(parseFloat(s)),
        l: _.channel.clamp.l(parseFloat(l)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { h, s, l, a } = channels2;
      if (a < 1) {
        return `hsla(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%, ${a})`;
      } else {
        return `hsl(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%)`;
      }
    }
  };
  const HSL$1 = HSL;
  const Keyword = {
    colors: {
      aliceblue: "#f0f8ff",
      antiquewhite: "#faebd7",
      aqua: "#00ffff",
      aquamarine: "#7fffd4",
      azure: "#f0ffff",
      beige: "#f5f5dc",
      bisque: "#ffe4c4",
      black: "#000000",
      blanchedalmond: "#ffebcd",
      blue: "#0000ff",
      blueviolet: "#8a2be2",
      brown: "#a52a2a",
      burlywood: "#deb887",
      cadetblue: "#5f9ea0",
      chartreuse: "#7fff00",
      chocolate: "#d2691e",
      coral: "#ff7f50",
      cornflowerblue: "#6495ed",
      cornsilk: "#fff8dc",
      crimson: "#dc143c",
      cyanaqua: "#00ffff",
      darkblue: "#00008b",
      darkcyan: "#008b8b",
      darkgoldenrod: "#b8860b",
      darkgray: "#a9a9a9",
      darkgreen: "#006400",
      darkgrey: "#a9a9a9",
      darkkhaki: "#bdb76b",
      darkmagenta: "#8b008b",
      darkolivegreen: "#556b2f",
      darkorange: "#ff8c00",
      darkorchid: "#9932cc",
      darkred: "#8b0000",
      darksalmon: "#e9967a",
      darkseagreen: "#8fbc8f",
      darkslateblue: "#483d8b",
      darkslategray: "#2f4f4f",
      darkslategrey: "#2f4f4f",
      darkturquoise: "#00ced1",
      darkviolet: "#9400d3",
      deeppink: "#ff1493",
      deepskyblue: "#00bfff",
      dimgray: "#696969",
      dimgrey: "#696969",
      dodgerblue: "#1e90ff",
      firebrick: "#b22222",
      floralwhite: "#fffaf0",
      forestgreen: "#228b22",
      fuchsia: "#ff00ff",
      gainsboro: "#dcdcdc",
      ghostwhite: "#f8f8ff",
      gold: "#ffd700",
      goldenrod: "#daa520",
      gray: "#808080",
      green: "#008000",
      greenyellow: "#adff2f",
      grey: "#808080",
      honeydew: "#f0fff0",
      hotpink: "#ff69b4",
      indianred: "#cd5c5c",
      indigo: "#4b0082",
      ivory: "#fffff0",
      khaki: "#f0e68c",
      lavender: "#e6e6fa",
      lavenderblush: "#fff0f5",
      lawngreen: "#7cfc00",
      lemonchiffon: "#fffacd",
      lightblue: "#add8e6",
      lightcoral: "#f08080",
      lightcyan: "#e0ffff",
      lightgoldenrodyellow: "#fafad2",
      lightgray: "#d3d3d3",
      lightgreen: "#90ee90",
      lightgrey: "#d3d3d3",
      lightpink: "#ffb6c1",
      lightsalmon: "#ffa07a",
      lightseagreen: "#20b2aa",
      lightskyblue: "#87cefa",
      lightslategray: "#778899",
      lightslategrey: "#778899",
      lightsteelblue: "#b0c4de",
      lightyellow: "#ffffe0",
      lime: "#00ff00",
      limegreen: "#32cd32",
      linen: "#faf0e6",
      magenta: "#ff00ff",
      maroon: "#800000",
      mediumaquamarine: "#66cdaa",
      mediumblue: "#0000cd",
      mediumorchid: "#ba55d3",
      mediumpurple: "#9370db",
      mediumseagreen: "#3cb371",
      mediumslateblue: "#7b68ee",
      mediumspringgreen: "#00fa9a",
      mediumturquoise: "#48d1cc",
      mediumvioletred: "#c71585",
      midnightblue: "#191970",
      mintcream: "#f5fffa",
      mistyrose: "#ffe4e1",
      moccasin: "#ffe4b5",
      navajowhite: "#ffdead",
      navy: "#000080",
      oldlace: "#fdf5e6",
      olive: "#808000",
      olivedrab: "#6b8e23",
      orange: "#ffa500",
      orangered: "#ff4500",
      orchid: "#da70d6",
      palegoldenrod: "#eee8aa",
      palegreen: "#98fb98",
      paleturquoise: "#afeeee",
      palevioletred: "#db7093",
      papayawhip: "#ffefd5",
      peachpuff: "#ffdab9",
      peru: "#cd853f",
      pink: "#ffc0cb",
      plum: "#dda0dd",
      powderblue: "#b0e0e6",
      purple: "#800080",
      rebeccapurple: "#663399",
      red: "#ff0000",
      rosybrown: "#bc8f8f",
      royalblue: "#4169e1",
      saddlebrown: "#8b4513",
      salmon: "#fa8072",
      sandybrown: "#f4a460",
      seagreen: "#2e8b57",
      seashell: "#fff5ee",
      sienna: "#a0522d",
      silver: "#c0c0c0",
      skyblue: "#87ceeb",
      slateblue: "#6a5acd",
      slategray: "#708090",
      slategrey: "#708090",
      snow: "#fffafa",
      springgreen: "#00ff7f",
      tan: "#d2b48c",
      teal: "#008080",
      thistle: "#d8bfd8",
      transparent: "#00000000",
      turquoise: "#40e0d0",
      violet: "#ee82ee",
      wheat: "#f5deb3",
      white: "#ffffff",
      whitesmoke: "#f5f5f5",
      yellow: "#ffff00",
      yellowgreen: "#9acd32"
    },
    parse: (color2) => {
      color2 = color2.toLowerCase();
      const hex2 = Keyword.colors[color2];
      if (!hex2)
        return;
      return Hex$1.parse(hex2);
    },
    stringify: (channels2) => {
      const hex2 = Hex$1.stringify(channels2);
      for (const name2 in Keyword.colors) {
        if (Keyword.colors[name2] === hex2)
          return name2;
      }
      return;
    }
  };
  const Keyword$1 = Keyword;
  const RGB = {
    re: /^rgba?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?)))?\s*?\)$/i,
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 114 && charCode !== 82)
        return;
      const match5 = color2.match(RGB.re);
      if (!match5)
        return;
      const [, r, isRedPercentage, g, isGreenPercentage, b, isBluePercentage, a, isAlphaPercentage] = match5;
      return ChannelsReusable.set({
        r: _.channel.clamp.r(isRedPercentage ? parseFloat(r) * 2.55 : parseFloat(r)),
        g: _.channel.clamp.g(isGreenPercentage ? parseFloat(g) * 2.55 : parseFloat(g)),
        b: _.channel.clamp.b(isBluePercentage ? parseFloat(b) * 2.55 : parseFloat(b)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `rgba(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)}, ${_.lang.round(a)})`;
      } else {
        return `rgb(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)})`;
      }
    }
  };
  const RGB$1 = RGB;
  const Color = {
    format: {
      keyword: Keyword$1,
      hex: Hex$1,
      rgb: RGB$1,
      rgba: RGB$1,
      hsl: HSL$1,
      hsla: HSL$1
    },
    parse: (color2) => {
      if (typeof color2 !== "string")
        return color2;
      const channels2 = Hex$1.parse(color2) || RGB$1.parse(color2) || HSL$1.parse(color2) || Keyword$1.parse(color2);
      if (channels2)
        return channels2;
      throw new Error(`Unsupported color format: "${color2}"`);
    },
    stringify: (channels2) => {
      if (!channels2.changed && channels2.color)
        return channels2.color;
      if (channels2.type.is(TYPE.HSL) || channels2.data.r === void 0) {
        return HSL$1.stringify(channels2);
      } else if (channels2.a < 1 || !Number.isInteger(channels2.r) || !Number.isInteger(channels2.g) || !Number.isInteger(channels2.b)) {
        return RGB$1.stringify(channels2);
      } else {
        return Hex$1.stringify(channels2);
      }
    }
  };
  const Color$1 = Color;
  const change = (color2, channels2) => {
    const ch = Color$1.parse(color2);
    for (const c2 in channels2) {
      ch[c2] = _.channel.clamp[c2](channels2[c2]);
    }
    return Color$1.stringify(ch);
  };
  const change$1 = change;
  const rgba$1 = (r, g, b = 0, a = 1) => {
    if (typeof r !== "number")
      return change$1(r, { a: g });
    const channels2 = ChannelsReusable.set({
      r: _.channel.clamp.r(r),
      g: _.channel.clamp.g(g),
      b: _.channel.clamp.b(b),
      a: _.channel.clamp.a(a)
    });
    return Color$1.stringify(channels2);
  };
  const rgba$2 = rgba$1;
  const luminance = (color2) => {
    const { r, g, b } = Color$1.parse(color2);
    const luminance2 = 0.2126 * _.channel.toLinear(r) + 0.7152 * _.channel.toLinear(g) + 0.0722 * _.channel.toLinear(b);
    return _.lang.round(luminance2);
  };
  const luminance$1 = luminance;
  const isLight = (color2) => {
    return luminance$1(color2) >= 0.5;
  };
  const isLight$1 = isLight;
  const isDark = (color2) => {
    return !isLight$1(color2);
  };
  const isDark$1 = isDark;
  const adjustChannel = (color2, channel2, amount) => {
    const channels2 = Color$1.parse(color2);
    const amountCurrent = channels2[channel2];
    const amountNext = _.channel.clamp[channel2](amountCurrent + amount);
    if (amountCurrent !== amountNext)
      channels2[channel2] = amountNext;
    return Color$1.stringify(channels2);
  };
  const adjustChannel$1 = adjustChannel;
  const lighten = (color2, amount) => {
    return adjustChannel$1(color2, "l", amount);
  };
  const lighten$1 = lighten;
  const darken = (color2, amount) => {
    return adjustChannel$1(color2, "l", -amount);
  };
  const darken$1 = darken;
  const adjust$1 = (color2, channels2) => {
    const ch = Color$1.parse(color2);
    const changes = {};
    for (const c2 in channels2) {
      if (!channels2[c2])
        continue;
      changes[c2] = ch[c2] + channels2[c2];
    }
    return change$1(color2, changes);
  };
  const adjust$2 = adjust$1;
  const mix = (color1, color2, weight = 50) => {
    const { r: r1, g: g1, b: b1, a: a1 } = Color$1.parse(color1);
    const { r: r2, g: g2, b: b2, a: a2 } = Color$1.parse(color2);
    const weightScale = weight / 100;
    const weightNormalized = weightScale * 2 - 1;
    const alphaDelta = a1 - a2;
    const weight1combined = weightNormalized * alphaDelta === -1 ? weightNormalized : (weightNormalized + alphaDelta) / (1 + weightNormalized * alphaDelta);
    const weight1 = (weight1combined + 1) / 2;
    const weight2 = 1 - weight1;
    const r = r1 * weight1 + r2 * weight2;
    const g = g1 * weight1 + g2 * weight2;
    const b = b1 * weight1 + b2 * weight2;
    const a = a1 * weightScale + a2 * (1 - weightScale);
    return rgba$2(r, g, b, a);
  };
  const mix$1 = mix;
  const invert = (color2, weight = 100) => {
    const inverse = Color$1.parse(color2);
    inverse.r = 255 - inverse.r;
    inverse.g = 255 - inverse.g;
    inverse.b = 255 - inverse.b;
    return mix$1(inverse, color2, weight);
  };
  const invert$1 = invert;
  const mkBorder = (col, darkMode) => darkMode ? adjust$2(col, { s: -40, l: 10 }) : adjust$2(col, { s: -40, l: -10 });
  const oldAttributeBackgroundColorOdd = "#ffffff";
  const oldAttributeBackgroundColorEven = "#f2f2f2";
  class Theme$4 {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#fff4dd";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
    }
    updateColors() {
      this.primaryTextColor = this.primaryTextColor || (this.darkMode ? "#eee" : "#333");
      this.secondaryColor = this.secondaryColor || adjust$2(this.primaryColor, { h: -120 });
      this.tertiaryColor = this.tertiaryColor || adjust$2(this.primaryColor, { h: 180, l: 5 });
      this.primaryBorderColor = this.primaryBorderColor || mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = this.secondaryBorderColor || mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = this.tertiaryBorderColor || mkBorder(this.tertiaryColor, this.darkMode);
      this.noteBorderColor = this.noteBorderColor || mkBorder(this.noteBkgColor, this.darkMode);
      this.noteBkgColor = this.noteBkgColor || "#fff5ad";
      this.noteTextColor = this.noteTextColor || "#333";
      this.secondaryTextColor = this.secondaryTextColor || invert$1(this.secondaryColor);
      this.tertiaryTextColor = this.tertiaryTextColor || invert$1(this.tertiaryColor);
      this.lineColor = this.lineColor || invert$1(this.background);
      this.textColor = this.textColor || this.primaryTextColor;
      this.nodeBkg = this.nodeBkg || this.primaryColor;
      this.mainBkg = this.mainBkg || this.primaryColor;
      this.nodeBorder = this.nodeBorder || this.primaryBorderColor;
      this.clusterBkg = this.clusterBkg || this.tertiaryColor;
      this.clusterBorder = this.clusterBorder || this.tertiaryBorderColor;
      this.defaultLinkColor = this.defaultLinkColor || this.lineColor;
      this.titleColor = this.titleColor || this.tertiaryTextColor;
      this.edgeLabelBackground = this.edgeLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.nodeTextColor = this.nodeTextColor || this.primaryTextColor;
      this.actorBorder = this.actorBorder || this.primaryBorderColor;
      this.actorBkg = this.actorBkg || this.mainBkg;
      this.actorTextColor = this.actorTextColor || this.primaryTextColor;
      this.actorLineColor = this.actorLineColor || "grey";
      this.labelBoxBkgColor = this.labelBoxBkgColor || this.actorBkg;
      this.signalColor = this.signalColor || this.textColor;
      this.signalTextColor = this.signalTextColor || this.textColor;
      this.labelBoxBorderColor = this.labelBoxBorderColor || this.actorBorder;
      this.labelTextColor = this.labelTextColor || this.actorTextColor;
      this.loopTextColor = this.loopTextColor || this.actorTextColor;
      this.activationBorderColor = this.activationBorderColor || darken$1(this.secondaryColor, 10);
      this.activationBkgColor = this.activationBkgColor || this.secondaryColor;
      this.sequenceNumberColor = this.sequenceNumberColor || invert$1(this.lineColor);
      this.sectionBkgColor = this.sectionBkgColor || this.tertiaryColor;
      this.altSectionBkgColor = this.altSectionBkgColor || "white";
      this.sectionBkgColor = this.sectionBkgColor || this.secondaryColor;
      this.sectionBkgColor2 = this.sectionBkgColor2 || this.primaryColor;
      this.excludeBkgColor = this.excludeBkgColor || "#eeeeee";
      this.taskBorderColor = this.taskBorderColor || this.primaryBorderColor;
      this.taskBkgColor = this.taskBkgColor || this.primaryColor;
      this.activeTaskBorderColor = this.activeTaskBorderColor || this.primaryColor;
      this.activeTaskBkgColor = this.activeTaskBkgColor || lighten$1(this.primaryColor, 23);
      this.gridColor = this.gridColor || "lightgrey";
      this.doneTaskBkgColor = this.doneTaskBkgColor || "lightgrey";
      this.doneTaskBorderColor = this.doneTaskBorderColor || "grey";
      this.critBorderColor = this.critBorderColor || "#ff8888";
      this.critBkgColor = this.critBkgColor || "red";
      this.todayLineColor = this.todayLineColor || "red";
      this.taskTextColor = this.taskTextColor || this.textColor;
      this.taskTextOutsideColor = this.taskTextOutsideColor || this.textColor;
      this.taskTextLightColor = this.taskTextLightColor || this.textColor;
      this.taskTextColor = this.taskTextColor || this.primaryTextColor;
      this.taskTextDarkColor = this.taskTextDarkColor || this.textColor;
      this.taskTextClickableColor = this.taskTextClickableColor || "#003163";
      this.personBorder = this.personBorder || this.primaryBorderColor;
      this.personBkg = this.personBkg || this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || this.tertiaryColor;
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.specialStateColor = this.lineColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210, l: 150 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      if (this.darkMode) {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 75);
        }
      } else {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 25);
        }
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      const multiplier = this.darkMode ? -4 : -1;
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (5 + i2 * 3) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (8 + i2 * 3) });
      }
      this.classText = this.classText || this.textColor;
      this.fillType0 = this.fillType0 || this.primaryColor;
      this.fillType1 = this.fillType1 || this.secondaryColor;
      this.fillType2 = this.fillType2 || adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = this.fillType3 || adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = this.fillType4 || adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = this.fillType5 || adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = this.fillType6 || adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = this.fillType7 || adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -10 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -10 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -20 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -10 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this.gitBranchLabel0 = this.gitBranchLabel0 || this.branchLabelColor;
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.branchLabelColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.branchLabelColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || this.branchLabelColor;
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.branchLabelColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.branchLabelColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.branchLabelColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables$4 = (userOverrides) => {
    const theme2 = new Theme$4();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme$3 {
    constructor() {
      this.background = "#333";
      this.primaryColor = "#1f2020";
      this.secondaryColor = lighten$1(this.primaryColor, 16);
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = invert$1(this.background);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#1f2020";
      this.secondBkg = "calculated";
      this.mainContrastColor = "lightgrey";
      this.darkTextColor = lighten$1(invert$1("#323D47"), 10);
      this.lineColor = "calculated";
      this.border1 = "#81B1DB";
      this.border2 = rgba$2(255, 255, 255, 0.25);
      this.arrowheadColor = "calculated";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#181818";
      this.textColor = "#ccc";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#F9FFFE";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "calculated";
      this.activationBkgColor = "calculated";
      this.sequenceNumberColor = "black";
      this.sectionBkgColor = darken$1("#EAE8D9", 30);
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "#EAE8D9";
      this.taskBorderColor = rgba$2(255, 255, 255, 70);
      this.taskBkgColor = "calculated";
      this.taskTextColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = rgba$2(255, 255, 255, 50);
      this.activeTaskBkgColor = "#81B1DB";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#E83737";
      this.critBkgColor = "#E83737";
      this.taskTextDarkColor = "calculated";
      this.todayLineColor = "#DB5757";
      this.personBorder = "calculated";
      this.personBkg = "calculated";
      this.labelColor = "calculated";
      this.errorBkgColor = "#a44141";
      this.errorTextColor = "#ddd";
    }
    updateColors() {
      this.secondBkg = lighten$1(this.mainBkg, 16);
      this.lineColor = this.mainContrastColor;
      this.arrowheadColor = this.mainContrastColor;
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.edgeLabelBackground = lighten$1(this.labelBackground, 25);
      this.actorBorder = this.border1;
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.mainContrastColor;
      this.actorLineColor = this.mainContrastColor;
      this.signalColor = this.mainContrastColor;
      this.signalTextColor = this.mainContrastColor;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.mainContrastColor;
      this.loopTextColor = this.mainContrastColor;
      this.noteBorderColor = this.secondaryBorderColor;
      this.noteBkgColor = this.secondBkg;
      this.noteTextColor = this.secondaryTextColor;
      this.activationBorderColor = this.border1;
      this.activationBkgColor = this.secondBkg;
      this.altSectionBkgColor = this.background;
      this.taskBkgColor = lighten$1(this.mainBkg, 23);
      this.taskTextColor = this.darkTextColor;
      this.taskTextLightColor = this.mainContrastColor;
      this.taskTextOutsideColor = this.taskTextLightColor;
      this.gridColor = this.mainContrastColor;
      this.doneTaskBkgColor = this.mainContrastColor;
      this.taskTextDarkColor = this.darkTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#555";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#f4f4f4";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.cScale1 = this.cScale1 || "#0b0000";
      this.cScale2 = this.cScale2 || "#4d1037";
      this.cScale3 = this.cScale3 || "#3f5258";
      this.cScale4 = this.cScale4 || "#4f2f1b";
      this.cScale5 = this.cScale5 || "#6e0a0a";
      this.cScale6 = this.cScale6 || "#3b0048";
      this.cScale7 = this.cScale7 || "#995a01";
      this.cScale8 = this.cScale8 || "#154706";
      this.cScale9 = this.cScale9 || "#161722";
      this.cScale10 = this.cScale10 || "#00296f";
      this.cScale11 = this.cScale11 || "#01629c";
      this.cScale12 = this.cScale12 || "#010029";
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-10 + i2 * 4) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-7 + i2 * 4) });
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.classText = this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = lighten$1(this.secondaryColor, 20);
      this.git1 = lighten$1(this.pie2 || this.secondaryColor, 20);
      this.git2 = lighten$1(this.pie3 || this.tertiaryColor, 20);
      this.git3 = lighten$1(this.pie4 || adjust$2(this.primaryColor, { h: -30 }), 20);
      this.git4 = lighten$1(this.pie5 || adjust$2(this.primaryColor, { h: -60 }), 20);
      this.git5 = lighten$1(this.pie6 || adjust$2(this.primaryColor, { h: -90 }), 10);
      this.git6 = lighten$1(this.pie7 || adjust$2(this.primaryColor, { h: 60 }), 10);
      this.git7 = lighten$1(this.pie8 || adjust$2(this.primaryColor, { h: 120 }), 20);
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || lighten$1(this.background, 12);
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || lighten$1(this.background, 2);
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables$3 = (userOverrides) => {
    const theme2 = new Theme$3();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme$2 {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#ECECFF";
      this.secondaryColor = adjust$2(this.primaryColor, { h: 120 });
      this.secondaryColor = "#ffffde";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.background = "white";
      this.mainBkg = "#ECECFF";
      this.secondBkg = "#ffffde";
      this.lineColor = "#333333";
      this.border1 = "#9370DB";
      this.border2 = "#aaaa33";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#e8e8e8";
      this.textColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.taskTextClickableColor = "calculated";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.todayLineColor = "calculated";
      this.sectionBkgColor = rgba$2(102, 102, 255, 0.49);
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#fff400";
      this.taskBorderColor = "#534fbc";
      this.taskBkgColor = "#8a90dd";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "#534fbc";
      this.activeTaskBkgColor = "#bfc7ff";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = "calculated";
      this.personBkg = "calculated";
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
      this.updateColors();
    }
    updateColors() {
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer" + 1] = this["cScalePeer" + 1] || darken$1(this.secondaryColor, 45);
      this["cScalePeer" + 2] = this["cScalePeer" + 2] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(7 + i2 * 5) });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      if (this.labelTextColor !== "calculated") {
        this.cScaleLabel0 = this.cScaleLabel0 || invert$1(this.labelTextColor);
        this.cScaleLabel3 = this.cScaleLabel3 || invert$1(this.labelTextColor);
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.labelTextColor;
        }
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.textColor;
      this.edgeLabelBackground = this.labelBackground;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.signalColor = this.textColor;
      this.signalTextColor = this.textColor;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || adjust$2(this.tertiaryColor, { l: -40 });
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -20 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -40 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: -40 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -40 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -90, l: -40 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -30 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.labelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || darken$1(invert$1(this.git0), 25);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables$2 = (userOverrides) => {
    const theme2 = new Theme$2();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme$1 {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#cde498";
      this.secondaryColor = "#cdffb2";
      this.background = "white";
      this.mainBkg = "#cde498";
      this.secondBkg = "#cdffb2";
      this.lineColor = "green";
      this.border1 = "#13540c";
      this.border2 = "#6eaa49";
      this.arrowheadColor = "green";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.tertiaryColor = lighten$1("#cde498", 10);
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.primaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#333";
      this.edgeLabelBackground = "#e8e8e8";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "#333";
      this.signalTextColor = "#333";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "#326932";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "#6eaa49";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#6eaa49";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "#487e3a";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = "calculated";
      this.personBkg = "calculated";
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer" + 1] = this["cScalePeer" + 1] || darken$1(this.secondaryColor, 45);
      this["cScalePeer" + 2] = this["cScalePeer" + 2] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.actorBorder = darken$1(this.mainBkg, 20);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.taskBorderColor = this.border1;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -30 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { h: 40, l: -40 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -50 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -50 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -50 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables$1 = (userOverrides) => {
    const theme2 = new Theme$1();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme {
    constructor() {
      this.primaryColor = "#eee";
      this.contrast = "#707070";
      this.secondaryColor = lighten$1(this.contrast, 55);
      this.background = "#ffffff";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#eee";
      this.secondBkg = "calculated";
      this.lineColor = "#666";
      this.border1 = "#999";
      this.border2 = "calculated";
      this.note = "#ffa";
      this.text = "#333";
      this.critical = "#d42";
      this.done = "#bbb";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "white";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "calculated";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.critBorderColor = "calculated";
      this.todayLineColor = "calculated";
      this.personBorder = "calculated";
      this.personBkg = "calculated";
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      this.secondBkg = lighten$1(this.contrast, 55);
      this.border2 = this.contrast;
      this.cScale0 = this.cScale0 || "#555";
      this.cScale1 = this.cScale1 || "#F4F4F4";
      this.cScale2 = this.cScale2 || "#555";
      this.cScale3 = this.cScale3 || "#BBB";
      this.cScale4 = this.cScale4 || "#777";
      this.cScale5 = this.cScale5 || "#999";
      this.cScale6 = this.cScale6 || "#DDD";
      this.cScale7 = this.cScale7 || "#FFF";
      this.cScale8 = this.cScale8 || "#DDD";
      this.cScale9 = this.cScale9 || "#BBB";
      this.cScale10 = this.cScale10 || "#999";
      this.cScale11 = this.cScale11 || "#777";
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this["cScaleLabel0"] = this["cScaleLabel0"] || this.cScale1;
      this["cScaleLabel2"] = this["cScaleLabel2"] || this.cScale1;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.text;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.text;
      this.actorLineColor = this.lineColor;
      this.signalColor = this.text;
      this.signalTextColor = this.text;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.text;
      this.loopTextColor = this.text;
      this.noteBorderColor = "#999";
      this.noteBkgColor = "#666";
      this.noteTextColor = "#fff";
      this.sectionBkgColor = lighten$1(this.contrast, 30);
      this.sectionBkgColor2 = lighten$1(this.contrast, 30);
      this.taskBorderColor = darken$1(this.contrast, 10);
      this.taskBkgColor = this.contrast;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = this.text;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.gridColor = lighten$1(this.border1, 30);
      this.doneTaskBkgColor = this.done;
      this.doneTaskBorderColor = this.lineColor;
      this.critBkgColor = this.critical;
      this.critBorderColor = darken$1(this.critBkgColor, 10);
      this.todayLineColor = this.critBkgColor;
      this.transitionColor = this.transitionColor || "#000";
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f4f4f4";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.stateBorder = this.stateBorder || "#000";
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#222";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pie12 = this.pie0;
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = darken$1(this.pie1, 25) || this.primaryColor;
      this.git1 = this.pie2 || this.secondaryColor;
      this.git2 = this.pie3 || this.tertiaryColor;
      this.git3 = this.pie4 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.pie5 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.pie6 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.pie7 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.pie8 || adjust$2(this.primaryColor, { h: 120 });
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || this.labelTextColor;
      this.gitBranchLabel0 = this.branchLabelColor;
      this.gitBranchLabel1 = "white";
      this.gitBranchLabel2 = this.branchLabelColor;
      this.gitBranchLabel3 = "white";
      this.gitBranchLabel4 = this.branchLabelColor;
      this.gitBranchLabel5 = this.branchLabelColor;
      this.gitBranchLabel6 = this.branchLabelColor;
      this.gitBranchLabel7 = this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables = (userOverrides) => {
    const theme2 = new Theme();
    theme2.calculate(userOverrides);
    return theme2;
  };
  const theme = {
    base: {
      getThemeVariables: getThemeVariables$4
    },
    dark: {
      getThemeVariables: getThemeVariables$3
    },
    default: {
      getThemeVariables: getThemeVariables$2
    },
    forest: {
      getThemeVariables: getThemeVariables$1
    },
    neutral: {
      getThemeVariables
    }
  };
  const config$1 = {
    theme: "default",
    themeVariables: theme["default"].getThemeVariables(),
    themeCSS: void 0,
    maxTextSize: 5e4,
    darkMode: false,
    fontFamily: '"trebuchet ms", verdana, arial, sans-serif;',
    logLevel: 5,
    securityLevel: "strict",
    startOnLoad: true,
    arrowMarkerAbsolute: false,
    secure: ["secure", "securityLevel", "startOnLoad", "maxTextSize"],
    deterministicIds: false,
    deterministicIDSeed: void 0,
    flowchart: {
      titleTopMargin: 25,
      diagramPadding: 8,
      htmlLabels: true,
      nodeSpacing: 50,
      rankSpacing: 50,
      curve: "basis",
      padding: 15,
      useMaxWidth: true,
      defaultRenderer: "dagre-wrapper"
    },
    sequence: {
      hideUnusedParticipants: false,
      activationWidth: 10,
      diagramMarginX: 50,
      diagramMarginY: 10,
      actorMargin: 50,
      width: 150,
      height: 65,
      boxMargin: 10,
      boxTextMargin: 5,
      noteMargin: 10,
      messageMargin: 35,
      messageAlign: "center",
      mirrorActors: true,
      forceMenus: false,
      bottomMarginAdj: 1,
      useMaxWidth: true,
      rightAngles: false,
      showSequenceNumbers: false,
      actorFontSize: 14,
      actorFontFamily: '"Open Sans", sans-serif',
      actorFontWeight: 400,
      noteFontSize: 14,
      noteFontFamily: '"trebuchet ms", verdana, arial, sans-serif',
      noteFontWeight: 400,
      noteAlign: "center",
      messageFontSize: 16,
      messageFontFamily: '"trebuchet ms", verdana, arial, sans-serif',
      messageFontWeight: 400,
      wrap: false,
      wrapPadding: 10,
      labelBoxWidth: 50,
      labelBoxHeight: 20,
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      },
      noteFont: function() {
        return {
          fontFamily: this.noteFontFamily,
          fontSize: this.noteFontSize,
          fontWeight: this.noteFontWeight
        };
      },
      actorFont: function() {
        return {
          fontFamily: this.actorFontFamily,
          fontSize: this.actorFontSize,
          fontWeight: this.actorFontWeight
        };
      }
    },
    gantt: {
      titleTopMargin: 25,
      barHeight: 20,
      barGap: 4,
      topPadding: 50,
      rightPadding: 75,
      leftPadding: 75,
      gridLineStartPadding: 35,
      fontSize: 11,
      sectionFontSize: 11,
      numberSectionStyles: 4,
      axisFormat: "%Y-%m-%d",
      tickInterval: void 0,
      useMaxWidth: true,
      topAxis: false,
      useWidth: void 0
    },
    journey: {
      diagramMarginX: 50,
      diagramMarginY: 10,
      leftMargin: 150,
      width: 150,
      height: 50,
      boxMargin: 10,
      boxTextMargin: 5,
      noteMargin: 10,
      messageMargin: 35,
      messageAlign: "center",
      bottomMarginAdj: 1,
      useMaxWidth: true,
      rightAngles: false,
      taskFontSize: 14,
      taskFontFamily: '"Open Sans", sans-serif',
      taskMargin: 50,
      activationWidth: 10,
      textPlacement: "fo",
      actorColours: ["#8FBC8F", "#7CFC00", "#00FFFF", "#20B2AA", "#B0E0E6", "#FFFFE0"],
      sectionFills: ["#191970", "#8B008B", "#4B0082", "#2F4F4F", "#800000", "#8B4513", "#00008B"],
      sectionColours: ["#fff"]
    },
    timeline: {
      diagramMarginX: 50,
      diagramMarginY: 10,
      leftMargin: 150,
      width: 150,
      height: 50,
      boxMargin: 10,
      boxTextMargin: 5,
      noteMargin: 10,
      messageMargin: 35,
      messageAlign: "center",
      bottomMarginAdj: 1,
      useMaxWidth: true,
      rightAngles: false,
      taskFontSize: 14,
      taskFontFamily: '"Open Sans", sans-serif',
      taskMargin: 50,
      activationWidth: 10,
      textPlacement: "fo",
      actorColours: ["#8FBC8F", "#7CFC00", "#00FFFF", "#20B2AA", "#B0E0E6", "#FFFFE0"],
      sectionFills: ["#191970", "#8B008B", "#4B0082", "#2F4F4F", "#800000", "#8B4513", "#00008B"],
      sectionColours: ["#fff"],
      disableMulticolor: false
    },
    class: {
      titleTopMargin: 25,
      arrowMarkerAbsolute: false,
      dividerMargin: 10,
      padding: 5,
      textHeight: 10,
      useMaxWidth: true,
      defaultRenderer: "dagre-wrapper"
    },
    state: {
      titleTopMargin: 25,
      dividerMargin: 10,
      sizeUnit: 5,
      padding: 8,
      textHeight: 10,
      titleShift: -15,
      noteMargin: 10,
      forkWidth: 70,
      forkHeight: 7,
      miniPadding: 2,
      fontSizeFactor: 5.02,
      fontSize: 24,
      labelHeight: 16,
      edgeLengthFactor: "20",
      compositTitleSize: 35,
      radius: 5,
      useMaxWidth: true,
      defaultRenderer: "dagre-wrapper"
    },
    er: {
      titleTopMargin: 25,
      diagramPadding: 20,
      layoutDirection: "TB",
      minEntityWidth: 100,
      minEntityHeight: 75,
      entityPadding: 15,
      stroke: "gray",
      fill: "honeydew",
      fontSize: 12,
      useMaxWidth: true
    },
    pie: {
      useWidth: void 0,
      useMaxWidth: true
    },
    requirement: {
      useWidth: void 0,
      useMaxWidth: true,
      rect_fill: "#f9f9f9",
      text_color: "#333",
      rect_border_size: "0.5px",
      rect_border_color: "#bbb",
      rect_min_width: 200,
      rect_min_height: 200,
      fontSize: 14,
      rect_padding: 10,
      line_height: 20
    },
    gitGraph: {
      titleTopMargin: 25,
      diagramPadding: 8,
      nodeLabel: {
        width: 75,
        height: 100,
        x: -25,
        y: 0
      },
      mainBranchName: "main",
      mainBranchOrder: 0,
      showCommitLabel: true,
      showBranches: true,
      rotateCommitLabel: true
    },
    c4: {
      useWidth: void 0,
      diagramMarginX: 50,
      diagramMarginY: 10,
      c4ShapeMargin: 50,
      c4ShapePadding: 20,
      width: 216,
      height: 60,
      boxMargin: 10,
      useMaxWidth: true,
      c4ShapeInRow: 4,
      nextLinePaddingX: 0,
      c4BoundaryInRow: 2,
      personFontSize: 14,
      personFontFamily: '"Open Sans", sans-serif',
      personFontWeight: "normal",
      external_personFontSize: 14,
      external_personFontFamily: '"Open Sans", sans-serif',
      external_personFontWeight: "normal",
      systemFontSize: 14,
      systemFontFamily: '"Open Sans", sans-serif',
      systemFontWeight: "normal",
      external_systemFontSize: 14,
      external_systemFontFamily: '"Open Sans", sans-serif',
      external_systemFontWeight: "normal",
      system_dbFontSize: 14,
      system_dbFontFamily: '"Open Sans", sans-serif',
      system_dbFontWeight: "normal",
      external_system_dbFontSize: 14,
      external_system_dbFontFamily: '"Open Sans", sans-serif',
      external_system_dbFontWeight: "normal",
      system_queueFontSize: 14,
      system_queueFontFamily: '"Open Sans", sans-serif',
      system_queueFontWeight: "normal",
      external_system_queueFontSize: 14,
      external_system_queueFontFamily: '"Open Sans", sans-serif',
      external_system_queueFontWeight: "normal",
      boundaryFontSize: 14,
      boundaryFontFamily: '"Open Sans", sans-serif',
      boundaryFontWeight: "normal",
      messageFontSize: 12,
      messageFontFamily: '"Open Sans", sans-serif',
      messageFontWeight: "normal",
      containerFontSize: 14,
      containerFontFamily: '"Open Sans", sans-serif',
      containerFontWeight: "normal",
      external_containerFontSize: 14,
      external_containerFontFamily: '"Open Sans", sans-serif',
      external_containerFontWeight: "normal",
      container_dbFontSize: 14,
      container_dbFontFamily: '"Open Sans", sans-serif',
      container_dbFontWeight: "normal",
      external_container_dbFontSize: 14,
      external_container_dbFontFamily: '"Open Sans", sans-serif',
      external_container_dbFontWeight: "normal",
      container_queueFontSize: 14,
      container_queueFontFamily: '"Open Sans", sans-serif',
      container_queueFontWeight: "normal",
      external_container_queueFontSize: 14,
      external_container_queueFontFamily: '"Open Sans", sans-serif',
      external_container_queueFontWeight: "normal",
      componentFontSize: 14,
      componentFontFamily: '"Open Sans", sans-serif',
      componentFontWeight: "normal",
      external_componentFontSize: 14,
      external_componentFontFamily: '"Open Sans", sans-serif',
      external_componentFontWeight: "normal",
      component_dbFontSize: 14,
      component_dbFontFamily: '"Open Sans", sans-serif',
      component_dbFontWeight: "normal",
      external_component_dbFontSize: 14,
      external_component_dbFontFamily: '"Open Sans", sans-serif',
      external_component_dbFontWeight: "normal",
      component_queueFontSize: 14,
      component_queueFontFamily: '"Open Sans", sans-serif',
      component_queueFontWeight: "normal",
      external_component_queueFontSize: 14,
      external_component_queueFontFamily: '"Open Sans", sans-serif',
      external_component_queueFontWeight: "normal",
      wrap: true,
      wrapPadding: 10,
      personFont: function() {
        return {
          fontFamily: this.personFontFamily,
          fontSize: this.personFontSize,
          fontWeight: this.personFontWeight
        };
      },
      external_personFont: function() {
        return {
          fontFamily: this.external_personFontFamily,
          fontSize: this.external_personFontSize,
          fontWeight: this.external_personFontWeight
        };
      },
      systemFont: function() {
        return {
          fontFamily: this.systemFontFamily,
          fontSize: this.systemFontSize,
          fontWeight: this.systemFontWeight
        };
      },
      external_systemFont: function() {
        return {
          fontFamily: this.external_systemFontFamily,
          fontSize: this.external_systemFontSize,
          fontWeight: this.external_systemFontWeight
        };
      },
      system_dbFont: function() {
        return {
          fontFamily: this.system_dbFontFamily,
          fontSize: this.system_dbFontSize,
          fontWeight: this.system_dbFontWeight
        };
      },
      external_system_dbFont: function() {
        return {
          fontFamily: this.external_system_dbFontFamily,
          fontSize: this.external_system_dbFontSize,
          fontWeight: this.external_system_dbFontWeight
        };
      },
      system_queueFont: function() {
        return {
          fontFamily: this.system_queueFontFamily,
          fontSize: this.system_queueFontSize,
          fontWeight: this.system_queueFontWeight
        };
      },
      external_system_queueFont: function() {
        return {
          fontFamily: this.external_system_queueFontFamily,
          fontSize: this.external_system_queueFontSize,
          fontWeight: this.external_system_queueFontWeight
        };
      },
      containerFont: function() {
        return {
          fontFamily: this.containerFontFamily,
          fontSize: this.containerFontSize,
          fontWeight: this.containerFontWeight
        };
      },
      external_containerFont: function() {
        return {
          fontFamily: this.external_containerFontFamily,
          fontSize: this.external_containerFontSize,
          fontWeight: this.external_containerFontWeight
        };
      },
      container_dbFont: function() {
        return {
          fontFamily: this.container_dbFontFamily,
          fontSize: this.container_dbFontSize,
          fontWeight: this.container_dbFontWeight
        };
      },
      external_container_dbFont: function() {
        return {
          fontFamily: this.external_container_dbFontFamily,
          fontSize: this.external_container_dbFontSize,
          fontWeight: this.external_container_dbFontWeight
        };
      },
      container_queueFont: function() {
        return {
          fontFamily: this.container_queueFontFamily,
          fontSize: this.container_queueFontSize,
          fontWeight: this.container_queueFontWeight
        };
      },
      external_container_queueFont: function() {
        return {
          fontFamily: this.external_container_queueFontFamily,
          fontSize: this.external_container_queueFontSize,
          fontWeight: this.external_container_queueFontWeight
        };
      },
      componentFont: function() {
        return {
          fontFamily: this.componentFontFamily,
          fontSize: this.componentFontSize,
          fontWeight: this.componentFontWeight
        };
      },
      external_componentFont: function() {
        return {
          fontFamily: this.external_componentFontFamily,
          fontSize: this.external_componentFontSize,
          fontWeight: this.external_componentFontWeight
        };
      },
      component_dbFont: function() {
        return {
          fontFamily: this.component_dbFontFamily,
          fontSize: this.component_dbFontSize,
          fontWeight: this.component_dbFontWeight
        };
      },
      external_component_dbFont: function() {
        return {
          fontFamily: this.external_component_dbFontFamily,
          fontSize: this.external_component_dbFontSize,
          fontWeight: this.external_component_dbFontWeight
        };
      },
      component_queueFont: function() {
        return {
          fontFamily: this.component_queueFontFamily,
          fontSize: this.component_queueFontSize,
          fontWeight: this.component_queueFontWeight
        };
      },
      external_component_queueFont: function() {
        return {
          fontFamily: this.external_component_queueFontFamily,
          fontSize: this.external_component_queueFontSize,
          fontWeight: this.external_component_queueFontWeight
        };
      },
      boundaryFont: function() {
        return {
          fontFamily: this.boundaryFontFamily,
          fontSize: this.boundaryFontSize,
          fontWeight: this.boundaryFontWeight
        };
      },
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      },
      person_bg_color: "#08427B",
      person_border_color: "#073B6F",
      external_person_bg_color: "#686868",
      external_person_border_color: "#8A8A8A",
      system_bg_color: "#1168BD",
      system_border_color: "#3C7FC0",
      system_db_bg_color: "#1168BD",
      system_db_border_color: "#3C7FC0",
      system_queue_bg_color: "#1168BD",
      system_queue_border_color: "#3C7FC0",
      external_system_bg_color: "#999999",
      external_system_border_color: "#8A8A8A",
      external_system_db_bg_color: "#999999",
      external_system_db_border_color: "#8A8A8A",
      external_system_queue_bg_color: "#999999",
      external_system_queue_border_color: "#8A8A8A",
      container_bg_color: "#438DD5",
      container_border_color: "#3C7FC0",
      container_db_bg_color: "#438DD5",
      container_db_border_color: "#3C7FC0",
      container_queue_bg_color: "#438DD5",
      container_queue_border_color: "#3C7FC0",
      external_container_bg_color: "#B3B3B3",
      external_container_border_color: "#A6A6A6",
      external_container_db_bg_color: "#B3B3B3",
      external_container_db_border_color: "#A6A6A6",
      external_container_queue_bg_color: "#B3B3B3",
      external_container_queue_border_color: "#A6A6A6",
      component_bg_color: "#85BBF0",
      component_border_color: "#78A8D8",
      component_db_bg_color: "#85BBF0",
      component_db_border_color: "#78A8D8",
      component_queue_bg_color: "#85BBF0",
      component_queue_border_color: "#78A8D8",
      external_component_bg_color: "#CCCCCC",
      external_component_border_color: "#BFBFBF",
      external_component_db_bg_color: "#CCCCCC",
      external_component_db_border_color: "#BFBFBF",
      external_component_queue_bg_color: "#CCCCCC",
      external_component_queue_border_color: "#BFBFBF"
    },
    mindmap: {
      useMaxWidth: true,
      padding: 10,
      maxNodeWidth: 200
    },
    fontSize: 16
  };
  if (config$1.class) {
    config$1.class.arrowMarkerAbsolute = config$1.arrowMarkerAbsolute;
  }
  if (config$1.gitGraph) {
    config$1.gitGraph.arrowMarkerAbsolute = config$1.arrowMarkerAbsolute;
  }
  const keyify = (obj, prefix = "") => Object.keys(obj).reduce((res, el) => {
    if (Array.isArray(obj[el])) {
      return res;
    } else if (typeof obj[el] === "object" && obj[el] !== null) {
      return [...res, prefix + el, ...keyify(obj[el], "")];
    }
    return [...res, prefix + el];
  }, []);
  const configKeys = keyify(config$1, "");
  const config$2 = config$1;
  /*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
  function isNothing(subject) {
    return typeof subject === "undefined" || subject === null;
  }
  function isObject$7(subject) {
    return typeof subject === "object" && subject !== null;
  }
  function toArray(sequence) {
    if (Array.isArray(sequence))
      return sequence;
    else if (isNothing(sequence))
      return [];
    return [sequence];
  }
  function extend$1(target, source) {
    var index, length2, key, sourceKeys;
    if (source) {
      sourceKeys = Object.keys(source);
      for (index = 0, length2 = sourceKeys.length; index < length2; index += 1) {
        key = sourceKeys[index];
        target[key] = source[key];
      }
    }
    return target;
  }
  function repeat(string2, count) {
    var result = "", cycle;
    for (cycle = 0; cycle < count; cycle += 1) {
      result += string2;
    }
    return result;
  }
  function isNegativeZero(number2) {
    return number2 === 0 && Number.NEGATIVE_INFINITY === 1 / number2;
  }
  var isNothing_1 = isNothing;
  var isObject_1$1 = isObject$7;
  var toArray_1 = toArray;
  var repeat_1 = repeat;
  var isNegativeZero_1 = isNegativeZero;
  var extend_1 = extend$1;
  var common = {
    isNothing: isNothing_1,
    isObject: isObject_1$1,
    toArray: toArray_1,
    repeat: repeat_1,
    isNegativeZero: isNegativeZero_1,
    extend: extend_1
  };
  function formatError(exception2, compact) {
    var where = "", message2 = exception2.reason || "(unknown reason)";
    if (!exception2.mark)
      return message2;
    if (exception2.mark.name) {
      where += 'in "' + exception2.mark.name + '" ';
    }
    where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
    if (!compact && exception2.mark.snippet) {
      where += "\n\n" + exception2.mark.snippet;
    }
    return message2 + " " + where;
  }
  function YAMLException$1(reason, mark) {
    Error.call(this);
    this.name = "YAMLException";
    this.reason = reason;
    this.mark = mark;
    this.message = formatError(this, false);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error().stack || "";
    }
  }
  YAMLException$1.prototype = Object.create(Error.prototype);
  YAMLException$1.prototype.constructor = YAMLException$1;
  YAMLException$1.prototype.toString = function toString2(compact) {
    return this.name + ": " + formatError(this, compact);
  };
  var exception = YAMLException$1;
  function getLine(buffer, lineStart, lineEnd, position2, maxLineLength) {
    var head2 = "";
    var tail = "";
    var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
    if (position2 - lineStart > maxHalfLength) {
      head2 = " ... ";
      lineStart = position2 - maxHalfLength + head2.length;
    }
    if (lineEnd - position2 > maxHalfLength) {
      tail = " ...";
      lineEnd = position2 + maxHalfLength - tail.length;
    }
    return {
      str: head2 + buffer.slice(lineStart, lineEnd).replace(/\t/g, "\u2192") + tail,
      pos: position2 - lineStart + head2.length
    };
  }
  function padStart(string2, max2) {
    return common.repeat(" ", max2 - string2.length) + string2;
  }
  function makeSnippet(mark, options2) {
    options2 = Object.create(options2 || null);
    if (!mark.buffer)
      return null;
    if (!options2.maxLength)
      options2.maxLength = 79;
    if (typeof options2.indent !== "number")
      options2.indent = 1;
    if (typeof options2.linesBefore !== "number")
      options2.linesBefore = 3;
    if (typeof options2.linesAfter !== "number")
      options2.linesAfter = 2;
    var re2 = /\r?\n|\r|\0/g;
    var lineStarts = [0];
    var lineEnds = [];
    var match5;
    var foundLineNo = -1;
    while (match5 = re2.exec(mark.buffer)) {
      lineEnds.push(match5.index);
      lineStarts.push(match5.index + match5[0].length);
      if (mark.position <= match5.index && foundLineNo < 0) {
        foundLineNo = lineStarts.length - 2;
      }
    }
    if (foundLineNo < 0)
      foundLineNo = lineStarts.length - 1;
    var result = "", i2, line2;
    var lineNoLength = Math.min(mark.line + options2.linesAfter, lineEnds.length).toString().length;
    var maxLineLength = options2.maxLength - (options2.indent + lineNoLength + 3);
    for (i2 = 1; i2 <= options2.linesBefore; i2++) {
      if (foundLineNo - i2 < 0)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo - i2],
        lineEnds[foundLineNo - i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i2]),
        maxLineLength
      );
      result = common.repeat(" ", options2.indent) + padStart((mark.line - i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n" + result;
    }
    line2 = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
    result += common.repeat(" ", options2.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    result += common.repeat("-", options2.indent + lineNoLength + 3 + line2.pos) + "^\n";
    for (i2 = 1; i2 <= options2.linesAfter; i2++) {
      if (foundLineNo + i2 >= lineEnds.length)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo + i2],
        lineEnds[foundLineNo + i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i2]),
        maxLineLength
      );
      result += common.repeat(" ", options2.indent) + padStart((mark.line + i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    }
    return result.replace(/\n$/, "");
  }
  var snippet = makeSnippet;
  var TYPE_CONSTRUCTOR_OPTIONS = [
    "kind",
    "multi",
    "resolve",
    "construct",
    "instanceOf",
    "predicate",
    "represent",
    "representName",
    "defaultStyle",
    "styleAliases"
  ];
  var YAML_NODE_KINDS = [
    "scalar",
    "sequence",
    "mapping"
  ];
  function compileStyleAliases(map2) {
    var result = {};
    if (map2 !== null) {
      Object.keys(map2).forEach(function(style) {
        map2[style].forEach(function(alias) {
          result[String(alias)] = style;
        });
      });
    }
    return result;
  }
  function Type$1(tag, options2) {
    options2 = options2 || {};
    Object.keys(options2).forEach(function(name2) {
      if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name2) === -1) {
        throw new exception('Unknown option "' + name2 + '" is met in definition of "' + tag + '" YAML type.');
      }
    });
    this.options = options2;
    this.tag = tag;
    this.kind = options2["kind"] || null;
    this.resolve = options2["resolve"] || function() {
      return true;
    };
    this.construct = options2["construct"] || function(data2) {
      return data2;
    };
    this.instanceOf = options2["instanceOf"] || null;
    this.predicate = options2["predicate"] || null;
    this.represent = options2["represent"] || null;
    this.representName = options2["representName"] || null;
    this.defaultStyle = options2["defaultStyle"] || null;
    this.multi = options2["multi"] || false;
    this.styleAliases = compileStyleAliases(options2["styleAliases"] || null);
    if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
      throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
    }
  }
  var type = Type$1;
  function compileList(schema2, name2) {
    var result = [];
    schema2[name2].forEach(function(currentType) {
      var newIndex = result.length;
      result.forEach(function(previousType, previousIndex) {
        if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
          newIndex = previousIndex;
        }
      });
      result[newIndex] = currentType;
    });
    return result;
  }
  function compileMap() {
    var result = {
      scalar: {},
      sequence: {},
      mapping: {},
      fallback: {},
      multi: {
        scalar: [],
        sequence: [],
        mapping: [],
        fallback: []
      }
    }, index, length2;
    function collectType(type2) {
      if (type2.multi) {
        result.multi[type2.kind].push(type2);
        result.multi["fallback"].push(type2);
      } else {
        result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
      }
    }
    for (index = 0, length2 = arguments.length; index < length2; index += 1) {
      arguments[index].forEach(collectType);
    }
    return result;
  }
  function Schema$1(definition) {
    return this.extend(definition);
  }
  Schema$1.prototype.extend = function extend2(definition) {
    var implicit2 = [];
    var explicit = [];
    if (definition instanceof type) {
      explicit.push(definition);
    } else if (Array.isArray(definition)) {
      explicit = explicit.concat(definition);
    } else if (definition && (Array.isArray(definition.implicit) || Array.isArray(definition.explicit))) {
      if (definition.implicit)
        implicit2 = implicit2.concat(definition.implicit);
      if (definition.explicit)
        explicit = explicit.concat(definition.explicit);
    } else {
      throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
    }
    implicit2.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
      if (type$1.loadKind && type$1.loadKind !== "scalar") {
        throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
      }
      if (type$1.multi) {
        throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
      }
    });
    explicit.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
    });
    var result = Object.create(Schema$1.prototype);
    result.implicit = (this.implicit || []).concat(implicit2);
    result.explicit = (this.explicit || []).concat(explicit);
    result.compiledImplicit = compileList(result, "implicit");
    result.compiledExplicit = compileList(result, "explicit");
    result.compiledTypeMap = compileMap(result.compiledImplicit, result.compiledExplicit);
    return result;
  };
  var schema = Schema$1;
  var str = new type("tag:yaml.org,2002:str", {
    kind: "scalar",
    construct: function(data2) {
      return data2 !== null ? data2 : "";
    }
  });
  var seq$1 = new type("tag:yaml.org,2002:seq", {
    kind: "sequence",
    construct: function(data2) {
      return data2 !== null ? data2 : [];
    }
  });
  var map$1 = new type("tag:yaml.org,2002:map", {
    kind: "mapping",
    construct: function(data2) {
      return data2 !== null ? data2 : {};
    }
  });
  var failsafe = new schema({
    explicit: [
      str,
      seq$1,
      map$1
    ]
  });
  function resolveYamlNull(data2) {
    if (data2 === null)
      return true;
    var max2 = data2.length;
    return max2 === 1 && data2 === "~" || max2 === 4 && (data2 === "null" || data2 === "Null" || data2 === "NULL");
  }
  function constructYamlNull() {
    return null;
  }
  function isNull(object2) {
    return object2 === null;
  }
  var _null = new type("tag:yaml.org,2002:null", {
    kind: "scalar",
    resolve: resolveYamlNull,
    construct: constructYamlNull,
    predicate: isNull,
    represent: {
      canonical: function() {
        return "~";
      },
      lowercase: function() {
        return "null";
      },
      uppercase: function() {
        return "NULL";
      },
      camelcase: function() {
        return "Null";
      },
      empty: function() {
        return "";
      }
    },
    defaultStyle: "lowercase"
  });
  function resolveYamlBoolean(data2) {
    if (data2 === null)
      return false;
    var max2 = data2.length;
    return max2 === 4 && (data2 === "true" || data2 === "True" || data2 === "TRUE") || max2 === 5 && (data2 === "false" || data2 === "False" || data2 === "FALSE");
  }
  function constructYamlBoolean(data2) {
    return data2 === "true" || data2 === "True" || data2 === "TRUE";
  }
  function isBoolean(object2) {
    return Object.prototype.toString.call(object2) === "[object Boolean]";
  }
  var bool = new type("tag:yaml.org,2002:bool", {
    kind: "scalar",
    resolve: resolveYamlBoolean,
    construct: constructYamlBoolean,
    predicate: isBoolean,
    represent: {
      lowercase: function(object2) {
        return object2 ? "true" : "false";
      },
      uppercase: function(object2) {
        return object2 ? "TRUE" : "FALSE";
      },
      camelcase: function(object2) {
        return object2 ? "True" : "False";
      }
    },
    defaultStyle: "lowercase"
  });
  function isHexCode(c2) {
    return 48 <= c2 && c2 <= 57 || 65 <= c2 && c2 <= 70 || 97 <= c2 && c2 <= 102;
  }
  function isOctCode(c2) {
    return 48 <= c2 && c2 <= 55;
  }
  function isDecCode(c2) {
    return 48 <= c2 && c2 <= 57;
  }
  function resolveYamlInteger(data2) {
    if (data2 === null)
      return false;
    var max2 = data2.length, index = 0, hasDigits = false, ch;
    if (!max2)
      return false;
    ch = data2[index];
    if (ch === "-" || ch === "+") {
      ch = data2[++index];
    }
    if (ch === "0") {
      if (index + 1 === max2)
        return true;
      ch = data2[++index];
      if (ch === "b") {
        index++;
        for (; index < max2; index++) {
          ch = data2[index];
          if (ch === "_")
            continue;
          if (ch !== "0" && ch !== "1")
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
      if (ch === "x") {
        index++;
        for (; index < max2; index++) {
          ch = data2[index];
          if (ch === "_")
            continue;
          if (!isHexCode(data2.charCodeAt(index)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
      if (ch === "o") {
        index++;
        for (; index < max2; index++) {
          ch = data2[index];
          if (ch === "_")
            continue;
          if (!isOctCode(data2.charCodeAt(index)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
    }
    if (ch === "_")
      return false;
    for (; index < max2; index++) {
      ch = data2[index];
      if (ch === "_")
        continue;
      if (!isDecCode(data2.charCodeAt(index))) {
        return false;
      }
      hasDigits = true;
    }
    if (!hasDigits || ch === "_")
      return false;
    return true;
  }
  function constructYamlInteger(data2) {
    var value = data2, sign2 = 1, ch;
    if (value.indexOf("_") !== -1) {
      value = value.replace(/_/g, "");
    }
    ch = value[0];
    if (ch === "-" || ch === "+") {
      if (ch === "-")
        sign2 = -1;
      value = value.slice(1);
      ch = value[0];
    }
    if (value === "0")
      return 0;
    if (ch === "0") {
      if (value[1] === "b")
        return sign2 * parseInt(value.slice(2), 2);
      if (value[1] === "x")
        return sign2 * parseInt(value.slice(2), 16);
      if (value[1] === "o")
        return sign2 * parseInt(value.slice(2), 8);
    }
    return sign2 * parseInt(value, 10);
  }
  function isInteger(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 === 0 && !common.isNegativeZero(object2));
  }
  var int = new type("tag:yaml.org,2002:int", {
    kind: "scalar",
    resolve: resolveYamlInteger,
    construct: constructYamlInteger,
    predicate: isInteger,
    represent: {
      binary: function(obj) {
        return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
      },
      octal: function(obj) {
        return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
      },
      decimal: function(obj) {
        return obj.toString(10);
      },
      hexadecimal: function(obj) {
        return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
      }
    },
    defaultStyle: "decimal",
    styleAliases: {
      binary: [2, "bin"],
      octal: [8, "oct"],
      decimal: [10, "dec"],
      hexadecimal: [16, "hex"]
    }
  });
  var YAML_FLOAT_PATTERN = new RegExp(
    "^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"
  );
  function resolveYamlFloat(data2) {
    if (data2 === null)
      return false;
    if (!YAML_FLOAT_PATTERN.test(data2) || data2[data2.length - 1] === "_") {
      return false;
    }
    return true;
  }
  function constructYamlFloat(data2) {
    var value, sign2;
    value = data2.replace(/_/g, "").toLowerCase();
    sign2 = value[0] === "-" ? -1 : 1;
    if ("+-".indexOf(value[0]) >= 0) {
      value = value.slice(1);
    }
    if (value === ".inf") {
      return sign2 === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    } else if (value === ".nan") {
      return NaN;
    }
    return sign2 * parseFloat(value, 10);
  }
  var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
  function representYamlFloat(object2, style) {
    var res;
    if (isNaN(object2)) {
      switch (style) {
        case "lowercase":
          return ".nan";
        case "uppercase":
          return ".NAN";
        case "camelcase":
          return ".NaN";
      }
    } else if (Number.POSITIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return ".inf";
        case "uppercase":
          return ".INF";
        case "camelcase":
          return ".Inf";
      }
    } else if (Number.NEGATIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return "-.inf";
        case "uppercase":
          return "-.INF";
        case "camelcase":
          return "-.Inf";
      }
    } else if (common.isNegativeZero(object2)) {
      return "-0.0";
    }
    res = object2.toString(10);
    return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
  }
  function isFloat(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 !== 0 || common.isNegativeZero(object2));
  }
  var float = new type("tag:yaml.org,2002:float", {
    kind: "scalar",
    resolve: resolveYamlFloat,
    construct: constructYamlFloat,
    predicate: isFloat,
    represent: representYamlFloat,
    defaultStyle: "lowercase"
  });
  var json = failsafe.extend({
    implicit: [
      _null,
      bool,
      int,
      float
    ]
  });
  var core$1 = json;
  var YAML_DATE_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"
  );
  var YAML_TIMESTAMP_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$"
  );
  function resolveYamlTimestamp(data2) {
    if (data2 === null)
      return false;
    if (YAML_DATE_REGEXP.exec(data2) !== null)
      return true;
    if (YAML_TIMESTAMP_REGEXP.exec(data2) !== null)
      return true;
    return false;
  }
  function constructYamlTimestamp(data2) {
    var match5, year2, month2, day2, hour2, minute2, second2, fraction = 0, delta = null, tz_hour, tz_minute, date2;
    match5 = YAML_DATE_REGEXP.exec(data2);
    if (match5 === null)
      match5 = YAML_TIMESTAMP_REGEXP.exec(data2);
    if (match5 === null)
      throw new Error("Date resolve error");
    year2 = +match5[1];
    month2 = +match5[2] - 1;
    day2 = +match5[3];
    if (!match5[4]) {
      return new Date(Date.UTC(year2, month2, day2));
    }
    hour2 = +match5[4];
    minute2 = +match5[5];
    second2 = +match5[6];
    if (match5[7]) {
      fraction = match5[7].slice(0, 3);
      while (fraction.length < 3) {
        fraction += "0";
      }
      fraction = +fraction;
    }
    if (match5[9]) {
      tz_hour = +match5[10];
      tz_minute = +(match5[11] || 0);
      delta = (tz_hour * 60 + tz_minute) * 6e4;
      if (match5[9] === "-")
        delta = -delta;
    }
    date2 = new Date(Date.UTC(year2, month2, day2, hour2, minute2, second2, fraction));
    if (delta)
      date2.setTime(date2.getTime() - delta);
    return date2;
  }
  function representYamlTimestamp(object2) {
    return object2.toISOString();
  }
  var timestamp = new type("tag:yaml.org,2002:timestamp", {
    kind: "scalar",
    resolve: resolveYamlTimestamp,
    construct: constructYamlTimestamp,
    instanceOf: Date,
    represent: representYamlTimestamp
  });
  function resolveYamlMerge(data2) {
    return data2 === "<<" || data2 === null;
  }
  var merge$3 = new type("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge
  });
  var BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
  function resolveYamlBinary(data2) {
    if (data2 === null)
      return false;
    var code, idx, bitlen = 0, max2 = data2.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      code = map2.indexOf(data2.charAt(idx));
      if (code > 64)
        continue;
      if (code < 0)
        return false;
      bitlen += 6;
    }
    return bitlen % 8 === 0;
  }
  function constructYamlBinary(data2) {
    var idx, tailbits, input = data2.replace(/[\r\n=]/g, ""), max2 = input.length, map2 = BASE64_MAP, bits = 0, result = [];
    for (idx = 0; idx < max2; idx++) {
      if (idx % 4 === 0 && idx) {
        result.push(bits >> 16 & 255);
        result.push(bits >> 8 & 255);
        result.push(bits & 255);
      }
      bits = bits << 6 | map2.indexOf(input.charAt(idx));
    }
    tailbits = max2 % 4 * 6;
    if (tailbits === 0) {
      result.push(bits >> 16 & 255);
      result.push(bits >> 8 & 255);
      result.push(bits & 255);
    } else if (tailbits === 18) {
      result.push(bits >> 10 & 255);
      result.push(bits >> 2 & 255);
    } else if (tailbits === 12) {
      result.push(bits >> 4 & 255);
    }
    return new Uint8Array(result);
  }
  function representYamlBinary(object2) {
    var result = "", bits = 0, idx, tail, max2 = object2.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      if (idx % 3 === 0 && idx) {
        result += map2[bits >> 18 & 63];
        result += map2[bits >> 12 & 63];
        result += map2[bits >> 6 & 63];
        result += map2[bits & 63];
      }
      bits = (bits << 8) + object2[idx];
    }
    tail = max2 % 3;
    if (tail === 0) {
      result += map2[bits >> 18 & 63];
      result += map2[bits >> 12 & 63];
      result += map2[bits >> 6 & 63];
      result += map2[bits & 63];
    } else if (tail === 2) {
      result += map2[bits >> 10 & 63];
      result += map2[bits >> 4 & 63];
      result += map2[bits << 2 & 63];
      result += map2[64];
    } else if (tail === 1) {
      result += map2[bits >> 2 & 63];
      result += map2[bits << 4 & 63];
      result += map2[64];
      result += map2[64];
    }
    return result;
  }
  function isBinary(obj) {
    return Object.prototype.toString.call(obj) === "[object Uint8Array]";
  }
  var binary = new type("tag:yaml.org,2002:binary", {
    kind: "scalar",
    resolve: resolveYamlBinary,
    construct: constructYamlBinary,
    predicate: isBinary,
    represent: representYamlBinary
  });
  var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
  var _toString$2 = Object.prototype.toString;
  function resolveYamlOmap(data2) {
    if (data2 === null)
      return true;
    var objectKeys = [], index, length2, pair, pairKey, pairHasKey, object2 = data2;
    for (index = 0, length2 = object2.length; index < length2; index += 1) {
      pair = object2[index];
      pairHasKey = false;
      if (_toString$2.call(pair) !== "[object Object]")
        return false;
      for (pairKey in pair) {
        if (_hasOwnProperty$3.call(pair, pairKey)) {
          if (!pairHasKey)
            pairHasKey = true;
          else
            return false;
        }
      }
      if (!pairHasKey)
        return false;
      if (objectKeys.indexOf(pairKey) === -1)
        objectKeys.push(pairKey);
      else
        return false;
    }
    return true;
  }
  function constructYamlOmap(data2) {
    return data2 !== null ? data2 : [];
  }
  var omap = new type("tag:yaml.org,2002:omap", {
    kind: "sequence",
    resolve: resolveYamlOmap,
    construct: constructYamlOmap
  });
  var _toString$1 = Object.prototype.toString;
  function resolveYamlPairs(data2) {
    if (data2 === null)
      return true;
    var index, length2, pair, keys2, result, object2 = data2;
    result = new Array(object2.length);
    for (index = 0, length2 = object2.length; index < length2; index += 1) {
      pair = object2[index];
      if (_toString$1.call(pair) !== "[object Object]")
        return false;
      keys2 = Object.keys(pair);
      if (keys2.length !== 1)
        return false;
      result[index] = [keys2[0], pair[keys2[0]]];
    }
    return true;
  }
  function constructYamlPairs(data2) {
    if (data2 === null)
      return [];
    var index, length2, pair, keys2, result, object2 = data2;
    result = new Array(object2.length);
    for (index = 0, length2 = object2.length; index < length2; index += 1) {
      pair = object2[index];
      keys2 = Object.keys(pair);
      result[index] = [keys2[0], pair[keys2[0]]];
    }
    return result;
  }
  var pairs = new type("tag:yaml.org,2002:pairs", {
    kind: "sequence",
    resolve: resolveYamlPairs,
    construct: constructYamlPairs
  });
  var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
  function resolveYamlSet(data2) {
    if (data2 === null)
      return true;
    var key, object2 = data2;
    for (key in object2) {
      if (_hasOwnProperty$2.call(object2, key)) {
        if (object2[key] !== null)
          return false;
      }
    }
    return true;
  }
  function constructYamlSet(data2) {
    return data2 !== null ? data2 : {};
  }
  var set$3 = new type("tag:yaml.org,2002:set", {
    kind: "mapping",
    resolve: resolveYamlSet,
    construct: constructYamlSet
  });
  var _default = core$1.extend({
    implicit: [
      timestamp,
      merge$3
    ],
    explicit: [
      binary,
      omap,
      pairs,
      set$3
    ]
  });
  var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  var CONTEXT_FLOW_IN = 1;
  var CONTEXT_FLOW_OUT = 2;
  var CONTEXT_BLOCK_IN = 3;
  var CONTEXT_BLOCK_OUT = 4;
  var CHOMPING_CLIP = 1;
  var CHOMPING_STRIP = 2;
  var CHOMPING_KEEP = 3;
  var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
  var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
  var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
  var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
  var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
  function _class(obj) {
    return Object.prototype.toString.call(obj);
  }
  function is_EOL(c2) {
    return c2 === 10 || c2 === 13;
  }
  function is_WHITE_SPACE(c2) {
    return c2 === 9 || c2 === 32;
  }
  function is_WS_OR_EOL(c2) {
    return c2 === 9 || c2 === 32 || c2 === 10 || c2 === 13;
  }
  function is_FLOW_INDICATOR(c2) {
    return c2 === 44 || c2 === 91 || c2 === 93 || c2 === 123 || c2 === 125;
  }
  function fromHexCode(c2) {
    var lc;
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    lc = c2 | 32;
    if (97 <= lc && lc <= 102) {
      return lc - 97 + 10;
    }
    return -1;
  }
  function escapedHexLen(c2) {
    if (c2 === 120) {
      return 2;
    }
    if (c2 === 117) {
      return 4;
    }
    if (c2 === 85) {
      return 8;
    }
    return 0;
  }
  function fromDecimalCode(c2) {
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    return -1;
  }
  function simpleEscapeSequence(c2) {
    return c2 === 48 ? "\0" : c2 === 97 ? "\x07" : c2 === 98 ? "\b" : c2 === 116 ? "	" : c2 === 9 ? "	" : c2 === 110 ? "\n" : c2 === 118 ? "\v" : c2 === 102 ? "\f" : c2 === 114 ? "\r" : c2 === 101 ? "\x1B" : c2 === 32 ? " " : c2 === 34 ? '"' : c2 === 47 ? "/" : c2 === 92 ? "\\" : c2 === 78 ? "\x85" : c2 === 95 ? "\xA0" : c2 === 76 ? "\u2028" : c2 === 80 ? "\u2029" : "";
  }
  function charFromCodepoint(c2) {
    if (c2 <= 65535) {
      return String.fromCharCode(c2);
    }
    return String.fromCharCode(
      (c2 - 65536 >> 10) + 55296,
      (c2 - 65536 & 1023) + 56320
    );
  }
  var simpleEscapeCheck = new Array(256);
  var simpleEscapeMap = new Array(256);
  for (var i$1 = 0; i$1 < 256; i$1++) {
    simpleEscapeCheck[i$1] = simpleEscapeSequence(i$1) ? 1 : 0;
    simpleEscapeMap[i$1] = simpleEscapeSequence(i$1);
  }
  function State$1(input, options2) {
    this.input = input;
    this.filename = options2["filename"] || null;
    this.schema = options2["schema"] || _default;
    this.onWarning = options2["onWarning"] || null;
    this.legacy = options2["legacy"] || false;
    this.json = options2["json"] || false;
    this.listener = options2["listener"] || null;
    this.implicitTypes = this.schema.compiledImplicit;
    this.typeMap = this.schema.compiledTypeMap;
    this.length = input.length;
    this.position = 0;
    this.line = 0;
    this.lineStart = 0;
    this.lineIndent = 0;
    this.firstTabInLine = -1;
    this.documents = [];
  }
  function generateError(state, message2) {
    var mark = {
      name: state.filename,
      buffer: state.input.slice(0, -1),
      position: state.position,
      line: state.line,
      column: state.position - state.lineStart
    };
    mark.snippet = snippet(mark);
    return new exception(message2, mark);
  }
  function throwError(state, message2) {
    throw generateError(state, message2);
  }
  function throwWarning(state, message2) {
    if (state.onWarning) {
      state.onWarning.call(null, generateError(state, message2));
    }
  }
  var directiveHandlers = {
    YAML: function handleYamlDirective(state, name2, args) {
      var match5, major, minor;
      if (state.version !== null) {
        throwError(state, "duplication of %YAML directive");
      }
      if (args.length !== 1) {
        throwError(state, "YAML directive accepts exactly one argument");
      }
      match5 = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
      if (match5 === null) {
        throwError(state, "ill-formed argument of the YAML directive");
      }
      major = parseInt(match5[1], 10);
      minor = parseInt(match5[2], 10);
      if (major !== 1) {
        throwError(state, "unacceptable YAML version of the document");
      }
      state.version = args[0];
      state.checkLineBreaks = minor < 2;
      if (minor !== 1 && minor !== 2) {
        throwWarning(state, "unsupported YAML version of the document");
      }
    },
    TAG: function handleTagDirective(state, name2, args) {
      var handle, prefix;
      if (args.length !== 2) {
        throwError(state, "TAG directive accepts exactly two arguments");
      }
      handle = args[0];
      prefix = args[1];
      if (!PATTERN_TAG_HANDLE.test(handle)) {
        throwError(state, "ill-formed tag handle (first argument) of the TAG directive");
      }
      if (_hasOwnProperty$1.call(state.tagMap, handle)) {
        throwError(state, 'there is a previously declared suffix for "' + handle + '" tag handle');
      }
      if (!PATTERN_TAG_URI.test(prefix)) {
        throwError(state, "ill-formed tag prefix (second argument) of the TAG directive");
      }
      try {
        prefix = decodeURIComponent(prefix);
      } catch (err) {
        throwError(state, "tag prefix is malformed: " + prefix);
      }
      state.tagMap[handle] = prefix;
    }
  };
  function captureSegment(state, start2, end2, checkJson) {
    var _position, _length, _character, _result;
    if (start2 < end2) {
      _result = state.input.slice(start2, end2);
      if (checkJson) {
        for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
          _character = _result.charCodeAt(_position);
          if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
            throwError(state, "expected valid JSON character");
          }
        }
      } else if (PATTERN_NON_PRINTABLE.test(_result)) {
        throwError(state, "the stream contains non-printable characters");
      }
      state.result += _result;
    }
  }
  function mergeMappings(state, destination, source, overridableKeys) {
    var sourceKeys, key, index, quantity;
    if (!common.isObject(source)) {
      throwError(state, "cannot merge mappings; the provided source object is unacceptable");
    }
    sourceKeys = Object.keys(source);
    for (index = 0, quantity = sourceKeys.length; index < quantity; index += 1) {
      key = sourceKeys[index];
      if (!_hasOwnProperty$1.call(destination, key)) {
        destination[key] = source[key];
        overridableKeys[key] = true;
      }
    }
  }
  function storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
    var index, quantity;
    if (Array.isArray(keyNode)) {
      keyNode = Array.prototype.slice.call(keyNode);
      for (index = 0, quantity = keyNode.length; index < quantity; index += 1) {
        if (Array.isArray(keyNode[index])) {
          throwError(state, "nested arrays are not supported inside keys");
        }
        if (typeof keyNode === "object" && _class(keyNode[index]) === "[object Object]") {
          keyNode[index] = "[object Object]";
        }
      }
    }
    if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
      keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (_result === null) {
      _result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
      if (Array.isArray(valueNode)) {
        for (index = 0, quantity = valueNode.length; index < quantity; index += 1) {
          mergeMappings(state, _result, valueNode[index], overridableKeys);
        }
      } else {
        mergeMappings(state, _result, valueNode, overridableKeys);
      }
    } else {
      if (!state.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
        state.line = startLine || state.line;
        state.lineStart = startLineStart || state.lineStart;
        state.position = startPos || state.position;
        throwError(state, "duplicated mapping key");
      }
      if (keyNode === "__proto__") {
        Object.defineProperty(_result, keyNode, {
          configurable: true,
          enumerable: true,
          writable: true,
          value: valueNode
        });
      } else {
        _result[keyNode] = valueNode;
      }
      delete overridableKeys[keyNode];
    }
    return _result;
  }
  function readLineBreak(state) {
    var ch;
    ch = state.input.charCodeAt(state.position);
    if (ch === 10) {
      state.position++;
    } else if (ch === 13) {
      state.position++;
      if (state.input.charCodeAt(state.position) === 10) {
        state.position++;
      }
    } else {
      throwError(state, "a line break is expected");
    }
    state.line += 1;
    state.lineStart = state.position;
    state.firstTabInLine = -1;
  }
  function skipSeparationSpace(state, allowComments, checkIndent) {
    var lineBreaks = 0, ch = state.input.charCodeAt(state.position);
    while (ch !== 0) {
      while (is_WHITE_SPACE(ch)) {
        if (ch === 9 && state.firstTabInLine === -1) {
          state.firstTabInLine = state.position;
        }
        ch = state.input.charCodeAt(++state.position);
      }
      if (allowComments && ch === 35) {
        do {
          ch = state.input.charCodeAt(++state.position);
        } while (ch !== 10 && ch !== 13 && ch !== 0);
      }
      if (is_EOL(ch)) {
        readLineBreak(state);
        ch = state.input.charCodeAt(state.position);
        lineBreaks++;
        state.lineIndent = 0;
        while (ch === 32) {
          state.lineIndent++;
          ch = state.input.charCodeAt(++state.position);
        }
      } else {
        break;
      }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state.lineIndent < checkIndent) {
      throwWarning(state, "deficient indentation");
    }
    return lineBreaks;
  }
  function testDocumentSeparator(state) {
    var _position = state.position, ch;
    ch = state.input.charCodeAt(_position);
    if ((ch === 45 || ch === 46) && ch === state.input.charCodeAt(_position + 1) && ch === state.input.charCodeAt(_position + 2)) {
      _position += 3;
      ch = state.input.charCodeAt(_position);
      if (ch === 0 || is_WS_OR_EOL(ch)) {
        return true;
      }
    }
    return false;
  }
  function writeFoldedLines(state, count) {
    if (count === 1) {
      state.result += " ";
    } else if (count > 1) {
      state.result += common.repeat("\n", count - 1);
    }
  }
  function readPlainScalar(state, nodeIndent, withinFlowCollection) {
    var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state.kind, _result = state.result, ch;
    ch = state.input.charCodeAt(state.position);
    if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
      return false;
    }
    if (ch === 63 || ch === 45) {
      following = state.input.charCodeAt(state.position + 1);
      if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
        return false;
      }
    }
    state.kind = "scalar";
    state.result = "";
    captureStart = captureEnd = state.position;
    hasPendingContent = false;
    while (ch !== 0) {
      if (ch === 58) {
        following = state.input.charCodeAt(state.position + 1);
        if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
          break;
        }
      } else if (ch === 35) {
        preceding = state.input.charCodeAt(state.position - 1);
        if (is_WS_OR_EOL(preceding)) {
          break;
        }
      } else if (state.position === state.lineStart && testDocumentSeparator(state) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
        break;
      } else if (is_EOL(ch)) {
        _line = state.line;
        _lineStart = state.lineStart;
        _lineIndent = state.lineIndent;
        skipSeparationSpace(state, false, -1);
        if (state.lineIndent >= nodeIndent) {
          hasPendingContent = true;
          ch = state.input.charCodeAt(state.position);
          continue;
        } else {
          state.position = captureEnd;
          state.line = _line;
          state.lineStart = _lineStart;
          state.lineIndent = _lineIndent;
          break;
        }
      }
      if (hasPendingContent) {
        captureSegment(state, captureStart, captureEnd, false);
        writeFoldedLines(state, state.line - _line);
        captureStart = captureEnd = state.position;
        hasPendingContent = false;
      }
      if (!is_WHITE_SPACE(ch)) {
        captureEnd = state.position + 1;
      }
      ch = state.input.charCodeAt(++state.position);
    }
    captureSegment(state, captureStart, captureEnd, false);
    if (state.result) {
      return true;
    }
    state.kind = _kind;
    state.result = _result;
    return false;
  }
  function readSingleQuotedScalar(state, nodeIndent) {
    var ch, captureStart, captureEnd;
    ch = state.input.charCodeAt(state.position);
    if (ch !== 39) {
      return false;
    }
    state.kind = "scalar";
    state.result = "";
    state.position++;
    captureStart = captureEnd = state.position;
    while ((ch = state.input.charCodeAt(state.position)) !== 0) {
      if (ch === 39) {
        captureSegment(state, captureStart, state.position, true);
        ch = state.input.charCodeAt(++state.position);
        if (ch === 39) {
          captureStart = state.position;
          state.position++;
          captureEnd = state.position;
        } else {
          return true;
        }
      } else if (is_EOL(ch)) {
        captureSegment(state, captureStart, captureEnd, true);
        writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
        captureStart = captureEnd = state.position;
      } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
        throwError(state, "unexpected end of the document within a single quoted scalar");
      } else {
        state.position++;
        captureEnd = state.position;
      }
    }
    throwError(state, "unexpected end of the stream within a single quoted scalar");
  }
  function readDoubleQuotedScalar(state, nodeIndent) {
    var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
    ch = state.input.charCodeAt(state.position);
    if (ch !== 34) {
      return false;
    }
    state.kind = "scalar";
    state.result = "";
    state.position++;
    captureStart = captureEnd = state.position;
    while ((ch = state.input.charCodeAt(state.position)) !== 0) {
      if (ch === 34) {
        captureSegment(state, captureStart, state.position, true);
        state.position++;
        return true;
      } else if (ch === 92) {
        captureSegment(state, captureStart, state.position, true);
        ch = state.input.charCodeAt(++state.position);
        if (is_EOL(ch)) {
          skipSeparationSpace(state, false, nodeIndent);
        } else if (ch < 256 && simpleEscapeCheck[ch]) {
          state.result += simpleEscapeMap[ch];
          state.position++;
        } else if ((tmp = escapedHexLen(ch)) > 0) {
          hexLength = tmp;
          hexResult = 0;
          for (; hexLength > 0; hexLength--) {
            ch = state.input.charCodeAt(++state.position);
            if ((tmp = fromHexCode(ch)) >= 0) {
              hexResult = (hexResult << 4) + tmp;
            } else {
              throwError(state, "expected hexadecimal character");
            }
          }
          state.result += charFromCodepoint(hexResult);
          state.position++;
        } else {
          throwError(state, "unknown escape sequence");
        }
        captureStart = captureEnd = state.position;
      } else if (is_EOL(ch)) {
        captureSegment(state, captureStart, captureEnd, true);
        writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
        captureStart = captureEnd = state.position;
      } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
        throwError(state, "unexpected end of the document within a double quoted scalar");
      } else {
        state.position++;
        captureEnd = state.position;
      }
    }
    throwError(state, "unexpected end of the stream within a double quoted scalar");
  }
  function readFlowCollection(state, nodeIndent) {
    var readNext = true, _line, _lineStart, _pos, _tag = state.tag, _result, _anchor = state.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = /* @__PURE__ */ Object.create(null), keyNode, keyTag, valueNode, ch;
    ch = state.input.charCodeAt(state.position);
    if (ch === 91) {
      terminator = 93;
      isMapping = false;
      _result = [];
    } else if (ch === 123) {
      terminator = 125;
      isMapping = true;
      _result = {};
    } else {
      return false;
    }
    if (state.anchor !== null) {
      state.anchorMap[state.anchor] = _result;
    }
    ch = state.input.charCodeAt(++state.position);
    while (ch !== 0) {
      skipSeparationSpace(state, true, nodeIndent);
      ch = state.input.charCodeAt(state.position);
      if (ch === terminator) {
        state.position++;
        state.tag = _tag;
        state.anchor = _anchor;
        state.kind = isMapping ? "mapping" : "sequence";
        state.result = _result;
        return true;
      } else if (!readNext) {
        throwError(state, "missed comma between flow collection entries");
      } else if (ch === 44) {
        throwError(state, "expected the node content, but found ','");
      }
      keyTag = keyNode = valueNode = null;
      isPair = isExplicitPair = false;
      if (ch === 63) {
        following = state.input.charCodeAt(state.position + 1);
        if (is_WS_OR_EOL(following)) {
          isPair = isExplicitPair = true;
          state.position++;
          skipSeparationSpace(state, true, nodeIndent);
        }
      }
      _line = state.line;
      _lineStart = state.lineStart;
      _pos = state.position;
      composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
      keyTag = state.tag;
      keyNode = state.result;
      skipSeparationSpace(state, true, nodeIndent);
      ch = state.input.charCodeAt(state.position);
      if ((isExplicitPair || state.line === _line) && ch === 58) {
        isPair = true;
        ch = state.input.charCodeAt(++state.position);
        skipSeparationSpace(state, true, nodeIndent);
        composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
        valueNode = state.result;
      }
      if (isMapping) {
        storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
      } else if (isPair) {
        _result.push(storeMappingPair(state, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
      } else {
        _result.push(keyNode);
      }
      skipSeparationSpace(state, true, nodeIndent);
      ch = state.input.charCodeAt(state.position);
      if (ch === 44) {
        readNext = true;
        ch = state.input.charCodeAt(++state.position);
      } else {
        readNext = false;
      }
    }
    throwError(state, "unexpected end of the stream within a flow collection");
  }
  function readBlockScalar(state, nodeIndent) {
    var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch;
    ch = state.input.charCodeAt(state.position);
    if (ch === 124) {
      folding = false;
    } else if (ch === 62) {
      folding = true;
    } else {
      return false;
    }
    state.kind = "scalar";
    state.result = "";
    while (ch !== 0) {
      ch = state.input.charCodeAt(++state.position);
      if (ch === 43 || ch === 45) {
        if (CHOMPING_CLIP === chomping) {
          chomping = ch === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
        } else {
          throwError(state, "repeat of a chomping mode identifier");
        }
      } else if ((tmp = fromDecimalCode(ch)) >= 0) {
        if (tmp === 0) {
          throwError(state, "bad explicit indentation width of a block scalar; it cannot be less than one");
        } else if (!detectedIndent) {
          textIndent = nodeIndent + tmp - 1;
          detectedIndent = true;
        } else {
          throwError(state, "repeat of an indentation width identifier");
        }
      } else {
        break;
      }
    }
    if (is_WHITE_SPACE(ch)) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (is_WHITE_SPACE(ch));
      if (ch === 35) {
        do {
          ch = state.input.charCodeAt(++state.position);
        } while (!is_EOL(ch) && ch !== 0);
      }
    }
    while (ch !== 0) {
      readLineBreak(state);
      state.lineIndent = 0;
      ch = state.input.charCodeAt(state.position);
      while ((!detectedIndent || state.lineIndent < textIndent) && ch === 32) {
        state.lineIndent++;
        ch = state.input.charCodeAt(++state.position);
      }
      if (!detectedIndent && state.lineIndent > textIndent) {
        textIndent = state.lineIndent;
      }
      if (is_EOL(ch)) {
        emptyLines++;
        continue;
      }
      if (state.lineIndent < textIndent) {
        if (chomping === CHOMPING_KEEP) {
          state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (chomping === CHOMPING_CLIP) {
          if (didReadContent) {
            state.result += "\n";
          }
        }
        break;
      }
      if (folding) {
        if (is_WHITE_SPACE(ch)) {
          atMoreIndented = true;
          state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (atMoreIndented) {
          atMoreIndented = false;
          state.result += common.repeat("\n", emptyLines + 1);
        } else if (emptyLines === 0) {
          if (didReadContent) {
            state.result += " ";
          }
        } else {
          state.result += common.repeat("\n", emptyLines);
        }
      } else {
        state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      }
      didReadContent = true;
      detectedIndent = true;
      emptyLines = 0;
      captureStart = state.position;
      while (!is_EOL(ch) && ch !== 0) {
        ch = state.input.charCodeAt(++state.position);
      }
      captureSegment(state, captureStart, state.position, false);
    }
    return true;
  }
  function readBlockSequence(state, nodeIndent) {
    var _line, _tag = state.tag, _anchor = state.anchor, _result = [], following, detected = false, ch;
    if (state.firstTabInLine !== -1)
      return false;
    if (state.anchor !== null) {
      state.anchorMap[state.anchor] = _result;
    }
    ch = state.input.charCodeAt(state.position);
    while (ch !== 0) {
      if (state.firstTabInLine !== -1) {
        state.position = state.firstTabInLine;
        throwError(state, "tab characters must not be used in indentation");
      }
      if (ch !== 45) {
        break;
      }
      following = state.input.charCodeAt(state.position + 1);
      if (!is_WS_OR_EOL(following)) {
        break;
      }
      detected = true;
      state.position++;
      if (skipSeparationSpace(state, true, -1)) {
        if (state.lineIndent <= nodeIndent) {
          _result.push(null);
          ch = state.input.charCodeAt(state.position);
          continue;
        }
      }
      _line = state.line;
      composeNode(state, nodeIndent, CONTEXT_BLOCK_IN, false, true);
      _result.push(state.result);
      skipSeparationSpace(state, true, -1);
      ch = state.input.charCodeAt(state.position);
      if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
        throwError(state, "bad indentation of a sequence entry");
      } else if (state.lineIndent < nodeIndent) {
        break;
      }
    }
    if (detected) {
      state.tag = _tag;
      state.anchor = _anchor;
      state.kind = "sequence";
      state.result = _result;
      return true;
    }
    return false;
  }
  function readBlockMapping(state, nodeIndent, flowIndent) {
    var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state.tag, _anchor = state.anchor, _result = {}, overridableKeys = /* @__PURE__ */ Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
    if (state.firstTabInLine !== -1)
      return false;
    if (state.anchor !== null) {
      state.anchorMap[state.anchor] = _result;
    }
    ch = state.input.charCodeAt(state.position);
    while (ch !== 0) {
      if (!atExplicitKey && state.firstTabInLine !== -1) {
        state.position = state.firstTabInLine;
        throwError(state, "tab characters must not be used in indentation");
      }
      following = state.input.charCodeAt(state.position + 1);
      _line = state.line;
      if ((ch === 63 || ch === 58) && is_WS_OR_EOL(following)) {
        if (ch === 63) {
          if (atExplicitKey) {
            storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }
          detected = true;
          atExplicitKey = true;
          allowCompact = true;
        } else if (atExplicitKey) {
          atExplicitKey = false;
          allowCompact = true;
        } else {
          throwError(state, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
        }
        state.position += 1;
        ch = following;
      } else {
        _keyLine = state.line;
        _keyLineStart = state.lineStart;
        _keyPos = state.position;
        if (!composeNode(state, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
          break;
        }
        if (state.line === _line) {
          ch = state.input.charCodeAt(state.position);
          while (is_WHITE_SPACE(ch)) {
            ch = state.input.charCodeAt(++state.position);
          }
          if (ch === 58) {
            ch = state.input.charCodeAt(++state.position);
            if (!is_WS_OR_EOL(ch)) {
              throwError(state, "a whitespace character is expected after the key-value separator within a block mapping");
            }
            if (atExplicitKey) {
              storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
              keyTag = keyNode = valueNode = null;
            }
            detected = true;
            atExplicitKey = false;
            allowCompact = false;
            keyTag = state.tag;
            keyNode = state.result;
          } else if (detected) {
            throwError(state, "can not read an implicit mapping pair; a colon is missed");
          } else {
            state.tag = _tag;
            state.anchor = _anchor;
            return true;
          }
        } else if (detected) {
          throwError(state, "can not read a block mapping entry; a multiline key may not be an implicit key");
        } else {
          state.tag = _tag;
          state.anchor = _anchor;
          return true;
        }
      }
      if (state.line === _line || state.lineIndent > nodeIndent) {
        if (atExplicitKey) {
          _keyLine = state.line;
          _keyLineStart = state.lineStart;
          _keyPos = state.position;
        }
        if (composeNode(state, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
          if (atExplicitKey) {
            keyNode = state.result;
          } else {
            valueNode = state.result;
          }
        }
        if (!atExplicitKey) {
          storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }
        skipSeparationSpace(state, true, -1);
        ch = state.input.charCodeAt(state.position);
      }
      if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
        throwError(state, "bad indentation of a mapping entry");
      } else if (state.lineIndent < nodeIndent) {
        break;
      }
    }
    if (atExplicitKey) {
      storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
    }
    if (detected) {
      state.tag = _tag;
      state.anchor = _anchor;
      state.kind = "mapping";
      state.result = _result;
    }
    return detected;
  }
  function readTagProperty(state) {
    var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch;
    ch = state.input.charCodeAt(state.position);
    if (ch !== 33)
      return false;
    if (state.tag !== null) {
      throwError(state, "duplication of a tag property");
    }
    ch = state.input.charCodeAt(++state.position);
    if (ch === 60) {
      isVerbatim = true;
      ch = state.input.charCodeAt(++state.position);
    } else if (ch === 33) {
      isNamed = true;
      tagHandle = "!!";
      ch = state.input.charCodeAt(++state.position);
    } else {
      tagHandle = "!";
    }
    _position = state.position;
    if (isVerbatim) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (ch !== 0 && ch !== 62);
      if (state.position < state.length) {
        tagName = state.input.slice(_position, state.position);
        ch = state.input.charCodeAt(++state.position);
      } else {
        throwError(state, "unexpected end of the stream within a verbatim tag");
      }
    } else {
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        if (ch === 33) {
          if (!isNamed) {
            tagHandle = state.input.slice(_position - 1, state.position + 1);
            if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
              throwError(state, "named tag handle cannot contain such characters");
            }
            isNamed = true;
            _position = state.position + 1;
          } else {
            throwError(state, "tag suffix cannot contain exclamation marks");
          }
        }
        ch = state.input.charCodeAt(++state.position);
      }
      tagName = state.input.slice(_position, state.position);
      if (PATTERN_FLOW_INDICATORS.test(tagName)) {
        throwError(state, "tag suffix cannot contain flow indicator characters");
      }
    }
    if (tagName && !PATTERN_TAG_URI.test(tagName)) {
      throwError(state, "tag name cannot contain such characters: " + tagName);
    }
    try {
      tagName = decodeURIComponent(tagName);
    } catch (err) {
      throwError(state, "tag name is malformed: " + tagName);
    }
    if (isVerbatim) {
      state.tag = tagName;
    } else if (_hasOwnProperty$1.call(state.tagMap, tagHandle)) {
      state.tag = state.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
      state.tag = "!" + tagName;
    } else if (tagHandle === "!!") {
      state.tag = "tag:yaml.org,2002:" + tagName;
    } else {
      throwError(state, 'undeclared tag handle "' + tagHandle + '"');
    }
    return true;
  }
  function readAnchorProperty(state) {
    var _position, ch;
    ch = state.input.charCodeAt(state.position);
    if (ch !== 38)
      return false;
    if (state.anchor !== null) {
      throwError(state, "duplication of an anchor property");
    }
    ch = state.input.charCodeAt(++state.position);
    _position = state.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
      ch = state.input.charCodeAt(++state.position);
    }
    if (state.position === _position) {
      throwError(state, "name of an anchor node must contain at least one character");
    }
    state.anchor = state.input.slice(_position, state.position);
    return true;
  }
  function readAlias(state) {
    var _position, alias, ch;
    ch = state.input.charCodeAt(state.position);
    if (ch !== 42)
      return false;
    ch = state.input.charCodeAt(++state.position);
    _position = state.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
      ch = state.input.charCodeAt(++state.position);
    }
    if (state.position === _position) {
      throwError(state, "name of an alias node must contain at least one character");
    }
    alias = state.input.slice(_position, state.position);
    if (!_hasOwnProperty$1.call(state.anchorMap, alias)) {
      throwError(state, 'unidentified alias "' + alias + '"');
    }
    state.result = state.anchorMap[alias];
    skipSeparationSpace(state, true, -1);
    return true;
  }
  function composeNode(state, parentIndent, nodeContext, allowToSeek, allowCompact) {
    var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
    if (state.listener !== null) {
      state.listener("open", state);
    }
    state.tag = null;
    state.anchor = null;
    state.kind = null;
    state.result = null;
    allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
    if (allowToSeek) {
      if (skipSeparationSpace(state, true, -1)) {
        atNewLine = true;
        if (state.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      }
    }
    if (indentStatus === 1) {
      while (readTagProperty(state) || readAnchorProperty(state)) {
        if (skipSeparationSpace(state, true, -1)) {
          atNewLine = true;
          allowBlockCollections = allowBlockStyles;
          if (state.lineIndent > parentIndent) {
            indentStatus = 1;
          } else if (state.lineIndent === parentIndent) {
            indentStatus = 0;
          } else if (state.lineIndent < parentIndent) {
            indentStatus = -1;
          }
        } else {
          allowBlockCollections = false;
        }
      }
    }
    if (allowBlockCollections) {
      allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
      if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
        flowIndent = parentIndent;
      } else {
        flowIndent = parentIndent + 1;
      }
      blockIndent = state.position - state.lineStart;
      if (indentStatus === 1) {
        if (allowBlockCollections && (readBlockSequence(state, blockIndent) || readBlockMapping(state, blockIndent, flowIndent)) || readFlowCollection(state, flowIndent)) {
          hasContent = true;
        } else {
          if (allowBlockScalars && readBlockScalar(state, flowIndent) || readSingleQuotedScalar(state, flowIndent) || readDoubleQuotedScalar(state, flowIndent)) {
            hasContent = true;
          } else if (readAlias(state)) {
            hasContent = true;
            if (state.tag !== null || state.anchor !== null) {
              throwError(state, "alias node should not have any properties");
            }
          } else if (readPlainScalar(state, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
            hasContent = true;
            if (state.tag === null) {
              state.tag = "?";
            }
          }
          if (state.anchor !== null) {
            state.anchorMap[state.anchor] = state.result;
          }
        }
      } else if (indentStatus === 0) {
        hasContent = allowBlockCollections && readBlockSequence(state, blockIndent);
      }
    }
    if (state.tag === null) {
      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = state.result;
      }
    } else if (state.tag === "?") {
      if (state.result !== null && state.kind !== "scalar") {
        throwError(state, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state.kind + '"');
      }
      for (typeIndex = 0, typeQuantity = state.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
        type2 = state.implicitTypes[typeIndex];
        if (type2.resolve(state.result)) {
          state.result = type2.construct(state.result);
          state.tag = type2.tag;
          if (state.anchor !== null) {
            state.anchorMap[state.anchor] = state.result;
          }
          break;
        }
      }
    } else if (state.tag !== "!") {
      if (_hasOwnProperty$1.call(state.typeMap[state.kind || "fallback"], state.tag)) {
        type2 = state.typeMap[state.kind || "fallback"][state.tag];
      } else {
        type2 = null;
        typeList = state.typeMap.multi[state.kind || "fallback"];
        for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
          if (state.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
            type2 = typeList[typeIndex];
            break;
          }
        }
      }
      if (!type2) {
        throwError(state, "unknown tag !<" + state.tag + ">");
      }
      if (state.result !== null && type2.kind !== state.kind) {
        throwError(state, "unacceptable node kind for !<" + state.tag + '> tag; it should be "' + type2.kind + '", not "' + state.kind + '"');
      }
      if (!type2.resolve(state.result, state.tag)) {
        throwError(state, "cannot resolve a node with !<" + state.tag + "> explicit tag");
      } else {
        state.result = type2.construct(state.result, state.tag);
        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
      }
    }
    if (state.listener !== null) {
      state.listener("close", state);
    }
    return state.tag !== null || state.anchor !== null || hasContent;
  }
  function readDocument(state) {
    var documentStart = state.position, _position, directiveName, directiveArgs, hasDirectives = false, ch;
    state.version = null;
    state.checkLineBreaks = state.legacy;
    state.tagMap = /* @__PURE__ */ Object.create(null);
    state.anchorMap = /* @__PURE__ */ Object.create(null);
    while ((ch = state.input.charCodeAt(state.position)) !== 0) {
      skipSeparationSpace(state, true, -1);
      ch = state.input.charCodeAt(state.position);
      if (state.lineIndent > 0 || ch !== 37) {
        break;
      }
      hasDirectives = true;
      ch = state.input.charCodeAt(++state.position);
      _position = state.position;
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }
      directiveName = state.input.slice(_position, state.position);
      directiveArgs = [];
      if (directiveName.length < 1) {
        throwError(state, "directive name must not be less than one character in length");
      }
      while (ch !== 0) {
        while (is_WHITE_SPACE(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }
        if (ch === 35) {
          do {
            ch = state.input.charCodeAt(++state.position);
          } while (ch !== 0 && !is_EOL(ch));
          break;
        }
        if (is_EOL(ch))
          break;
        _position = state.position;
        while (ch !== 0 && !is_WS_OR_EOL(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }
        directiveArgs.push(state.input.slice(_position, state.position));
      }
      if (ch !== 0)
        readLineBreak(state);
      if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
        directiveHandlers[directiveName](state, directiveName, directiveArgs);
      } else {
        throwWarning(state, 'unknown document directive "' + directiveName + '"');
      }
    }
    skipSeparationSpace(state, true, -1);
    if (state.lineIndent === 0 && state.input.charCodeAt(state.position) === 45 && state.input.charCodeAt(state.position + 1) === 45 && state.input.charCodeAt(state.position + 2) === 45) {
      state.position += 3;
      skipSeparationSpace(state, true, -1);
    } else if (hasDirectives) {
      throwError(state, "directives end mark is expected");
    }
    composeNode(state, state.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
    skipSeparationSpace(state, true, -1);
    if (state.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart, state.position))) {
      throwWarning(state, "non-ASCII line breaks are interpreted as content");
    }
    state.documents.push(state.result);
    if (state.position === state.lineStart && testDocumentSeparator(state)) {
      if (state.input.charCodeAt(state.position) === 46) {
        state.position += 3;
        skipSeparationSpace(state, true, -1);
      }
      return;
    }
    if (state.position < state.length - 1) {
      throwError(state, "end of the stream or a document separator is expected");
    } else {
      return;
    }
  }
  function loadDocuments(input, options2) {
    input = String(input);
    options2 = options2 || {};
    if (input.length !== 0) {
      if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
        input += "\n";
      }
      if (input.charCodeAt(0) === 65279) {
        input = input.slice(1);
      }
    }
    var state = new State$1(input, options2);
    var nullpos = input.indexOf("\0");
    if (nullpos !== -1) {
      state.position = nullpos;
      throwError(state, "null byte is not allowed in input");
    }
    state.input += "\0";
    while (state.input.charCodeAt(state.position) === 32) {
      state.lineIndent += 1;
      state.position += 1;
    }
    while (state.position < state.length - 1) {
      readDocument(state);
    }
    return state.documents;
  }
  function loadAll$1(input, iterator, options2) {
    if (iterator !== null && typeof iterator === "object" && typeof options2 === "undefined") {
      options2 = iterator;
      iterator = null;
    }
    var documents2 = loadDocuments(input, options2);
    if (typeof iterator !== "function") {
      return documents2;
    }
    for (var index = 0, length2 = documents2.length; index < length2; index += 1) {
      iterator(documents2[index]);
    }
  }
  function load$1(input, options2) {
    var documents2 = loadDocuments(input, options2);
    if (documents2.length === 0) {
      return void 0;
    } else if (documents2.length === 1) {
      return documents2[0];
    }
    throw new exception("expected a single document in the stream, but found more");
  }
  var loadAll_1 = loadAll$1;
  var load_1 = load$1;
  var loader$3 = {
    loadAll: loadAll_1,
    load: load_1
  };
  var FAILSAFE_SCHEMA = failsafe;
  var load = loader$3.load;
  const frontMatterRegex = /^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s;
  function extractFrontMatter(text2, db2) {
    var _a;
    const matches2 = text2.match(frontMatterRegex);
    if (matches2) {
      const parsed = load(matches2[1], {
        schema: FAILSAFE_SCHEMA
      });
      if (parsed == null ? void 0 : parsed.title) {
        (_a = db2.setDiagramTitle) == null ? void 0 : _a.call(db2, parsed.title);
      }
      return text2.slice(matches2[0].length);
    } else {
      return text2;
    }
  }
  const directive$1 = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const anyComment = /\s*%%.*\n/gm;
  const detectors = {};
  const detectType = function(text2, config2) {
    text2 = text2.replace(frontMatterRegex, "").replace(directive$1, "").replace(anyComment, "\n");
    for (const [key, { detector: detector2 }] of Object.entries(detectors)) {
      const diagram2 = detector2(text2, config2);
      if (diagram2) {
        return key;
      }
    }
    throw new Error(`No diagram type detected for text: ${text2}`);
  };
  const registerLazyLoadedDiagrams = (...diagrams2) => {
    for (const { id: id2, detector: detector2, loader: loader2 } of diagrams2) {
      addDetector(id2, detector2, loader2);
    }
  };
  const addDetector = (key, detector2, loader2) => {
    if (detectors[key]) {
      log$1.error(`Detector with key ${key} already exists`);
    } else {
      detectors[key] = { detector: detector2, loader: loader2 };
    }
    log$1.debug(`Detector with key ${key} added${loader2 ? " with loader" : ""}`);
  };
  const getDiagramLoader = (key) => detectors[key].loader;
  const assignWithDepth = function(dst, src, config2) {
    const { depth, clobber } = Object.assign({ depth: 2, clobber: false }, config2);
    if (Array.isArray(src) && !Array.isArray(dst)) {
      src.forEach((s) => assignWithDepth(dst, s, config2));
      return dst;
    } else if (Array.isArray(src) && Array.isArray(dst)) {
      src.forEach((s) => {
        if (!dst.includes(s)) {
          dst.push(s);
        }
      });
      return dst;
    }
    if (dst === void 0 || depth <= 0) {
      if (dst !== void 0 && dst !== null && typeof dst === "object" && typeof src === "object") {
        return Object.assign(dst, src);
      } else {
        return src;
      }
    }
    if (src !== void 0 && typeof dst === "object" && typeof src === "object") {
      Object.keys(src).forEach((key) => {
        if (typeof src[key] === "object" && (dst[key] === void 0 || typeof dst[key] === "object")) {
          if (dst[key] === void 0) {
            dst[key] = Array.isArray(src[key]) ? [] : {};
          }
          dst[key] = assignWithDepth(dst[key], src[key], { depth: depth - 1, clobber });
        } else if (clobber || typeof dst[key] !== "object" && typeof src[key] !== "object") {
          dst[key] = src[key];
        }
      });
    }
    return dst;
  };
  const assignWithDepth$1 = assignWithDepth;
  var freeGlobal$2 = typeof global == "object" && global && global.Object === Object && global;
  const freeGlobal$3 = freeGlobal$2;
  var freeSelf$1 = typeof self == "object" && self && self.Object === Object && self;
  var root$5 = freeGlobal$3 || freeSelf$1 || Function("return this")();
  const root$6 = root$5;
  var Symbol$5 = root$6.Symbol;
  const Symbol$6 = Symbol$5;
  var objectProto$o = Object.prototype;
  var hasOwnProperty$k = objectProto$o.hasOwnProperty;
  var nativeObjectToString$3 = objectProto$o.toString;
  var symToStringTag$3 = Symbol$6 ? Symbol$6.toStringTag : void 0;
  function getRawTag$2(value) {
    var isOwn = hasOwnProperty$k.call(value, symToStringTag$3), tag = value[symToStringTag$3];
    try {
      value[symToStringTag$3] = void 0;
      var unmasked = true;
    } catch (e) {
    }
    var result = nativeObjectToString$3.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag$3] = tag;
      } else {
        delete value[symToStringTag$3];
      }
    }
    return result;
  }
  var objectProto$n = Object.prototype;
  var nativeObjectToString$2 = objectProto$n.toString;
  function objectToString$2(value) {
    return nativeObjectToString$2.call(value);
  }
  var nullTag$1 = "[object Null]", undefinedTag$1 = "[object Undefined]";
  var symToStringTag$2 = Symbol$6 ? Symbol$6.toStringTag : void 0;
  function baseGetTag$3(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag$1 : nullTag$1;
    }
    return symToStringTag$2 && symToStringTag$2 in Object(value) ? getRawTag$2(value) : objectToString$2(value);
  }
  function isObject$6(value) {
    var type2 = typeof value;
    return value != null && (type2 == "object" || type2 == "function");
  }
  var asyncTag$1 = "[object AsyncFunction]", funcTag$3 = "[object Function]", genTag$2 = "[object GeneratorFunction]", proxyTag$1 = "[object Proxy]";
  function isFunction$2(value) {
    if (!isObject$6(value)) {
      return false;
    }
    var tag = baseGetTag$3(value);
    return tag == funcTag$3 || tag == genTag$2 || tag == asyncTag$1 || tag == proxyTag$1;
  }
  var coreJsData$2 = root$6["__core-js_shared__"];
  const coreJsData$3 = coreJsData$2;
  var maskSrcKey$1 = function() {
    var uid = /[^.]+$/.exec(coreJsData$3 && coreJsData$3.keys && coreJsData$3.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
  }();
  function isMasked$2(func) {
    return !!maskSrcKey$1 && maskSrcKey$1 in func;
  }
  var funcProto$4 = Function.prototype;
  var funcToString$4 = funcProto$4.toString;
  function toSource$2(func) {
    if (func != null) {
      try {
        return funcToString$4.call(func);
      } catch (e) {
      }
      try {
        return func + "";
      } catch (e) {
      }
    }
    return "";
  }
  var reRegExpChar$1 = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor$1 = /^\[object .+?Constructor\]$/;
  var funcProto$3 = Function.prototype, objectProto$m = Object.prototype;
  var funcToString$3 = funcProto$3.toString;
  var hasOwnProperty$j = objectProto$m.hasOwnProperty;
  var reIsNative$1 = RegExp(
    "^" + funcToString$3.call(hasOwnProperty$j).replace(reRegExpChar$1, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative$2(value) {
    if (!isObject$6(value) || isMasked$2(value)) {
      return false;
    }
    var pattern = isFunction$2(value) ? reIsNative$1 : reIsHostCtor$1;
    return pattern.test(toSource$2(value));
  }
  function getValue$3(object2, key) {
    return object2 == null ? void 0 : object2[key];
  }
  function getNative$4(object2, key) {
    var value = getValue$3(object2, key);
    return baseIsNative$2(value) ? value : void 0;
  }
  var nativeCreate$5 = getNative$4(Object, "create");
  const nativeCreate$6 = nativeCreate$5;
  function hashClear$2() {
    this.__data__ = nativeCreate$6 ? nativeCreate$6(null) : {};
    this.size = 0;
  }
  function hashDelete$2(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  var HASH_UNDEFINED$4 = "__lodash_hash_undefined__";
  var objectProto$l = Object.prototype;
  var hasOwnProperty$i = objectProto$l.hasOwnProperty;
  function hashGet$2(key) {
    var data2 = this.__data__;
    if (nativeCreate$6) {
      var result = data2[key];
      return result === HASH_UNDEFINED$4 ? void 0 : result;
    }
    return hasOwnProperty$i.call(data2, key) ? data2[key] : void 0;
  }
  var objectProto$k = Object.prototype;
  var hasOwnProperty$h = objectProto$k.hasOwnProperty;
  function hashHas$2(key) {
    var data2 = this.__data__;
    return nativeCreate$6 ? data2[key] !== void 0 : hasOwnProperty$h.call(data2, key);
  }
  var HASH_UNDEFINED$3 = "__lodash_hash_undefined__";
  function hashSet$2(key, value) {
    var data2 = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data2[key] = nativeCreate$6 && value === void 0 ? HASH_UNDEFINED$3 : value;
    return this;
  }
  function Hash$2(entries) {
    var index = -1, length2 = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length2) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  Hash$2.prototype.clear = hashClear$2;
  Hash$2.prototype["delete"] = hashDelete$2;
  Hash$2.prototype.get = hashGet$2;
  Hash$2.prototype.has = hashHas$2;
  Hash$2.prototype.set = hashSet$2;
  function listCacheClear$2() {
    this.__data__ = [];
    this.size = 0;
  }
  function eq$3(value, other) {
    return value === other || value !== value && other !== other;
  }
  function assocIndexOf$5(array2, key) {
    var length2 = array2.length;
    while (length2--) {
      if (eq$3(array2[length2][0], key)) {
        return length2;
      }
    }
    return -1;
  }
  var arrayProto$1 = Array.prototype;
  var splice$1 = arrayProto$1.splice;
  function listCacheDelete$2(key) {
    var data2 = this.__data__, index = assocIndexOf$5(data2, key);
    if (index < 0) {
      return false;
    }
    var lastIndex = data2.length - 1;
    if (index == lastIndex) {
      data2.pop();
    } else {
      splice$1.call(data2, index, 1);
    }
    --this.size;
    return true;
  }
  function listCacheGet$2(key) {
    var data2 = this.__data__, index = assocIndexOf$5(data2, key);
    return index < 0 ? void 0 : data2[index][1];
  }
  function listCacheHas$2(key) {
    return assocIndexOf$5(this.__data__, key) > -1;
  }
  function listCacheSet$2(key, value) {
    var data2 = this.__data__, index = assocIndexOf$5(data2, key);
    if (index < 0) {
      ++this.size;
      data2.push([key, value]);
    } else {
      data2[index][1] = value;
    }
    return this;
  }
  function ListCache$2(entries) {
    var index = -1, length2 = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length2) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache$2.prototype.clear = listCacheClear$2;
  ListCache$2.prototype["delete"] = listCacheDelete$2;
  ListCache$2.prototype.get = listCacheGet$2;
  ListCache$2.prototype.has = listCacheHas$2;
  ListCache$2.prototype.set = listCacheSet$2;
  var Map$4 = getNative$4(root$6, "Map");
  const Map$5 = Map$4;
  function mapCacheClear$2() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash$2(),
      "map": new (Map$5 || ListCache$2)(),
      "string": new Hash$2()
    };
  }
  function isKeyable$2(value) {
    var type2 = typeof value;
    return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
  }
  function getMapData$5(map2, key) {
    var data2 = map2.__data__;
    return isKeyable$2(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
  }
  function mapCacheDelete$2(key) {
    var result = getMapData$5(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  function mapCacheGet$2(key) {
    return getMapData$5(this, key).get(key);
  }
  function mapCacheHas$2(key) {
    return getMapData$5(this, key).has(key);
  }
  function mapCacheSet$2(key, value) {
    var data2 = getMapData$5(this, key), size2 = data2.size;
    data2.set(key, value);
    this.size += data2.size == size2 ? 0 : 1;
    return this;
  }
  function MapCache$2(entries) {
    var index = -1, length2 = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length2) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache$2.prototype.clear = mapCacheClear$2;
  MapCache$2.prototype["delete"] = mapCacheDelete$2;
  MapCache$2.prototype.get = mapCacheGet$2;
  MapCache$2.prototype.has = mapCacheHas$2;
  MapCache$2.prototype.set = mapCacheSet$2;
  var FUNC_ERROR_TEXT$2 = "Expected a function";
  function memoize$3(func, resolver2) {
    if (typeof func != "function" || resolver2 != null && typeof resolver2 != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$2);
    }
    var memoized = function() {
      var args = arguments, key = resolver2 ? resolver2.apply(this, args) : args[0], cache2 = memoized.cache;
      if (cache2.has(key)) {
        return cache2.get(key);
      }
      var result = func.apply(this, args);
      memoized.cache = cache2.set(key, result) || cache2;
      return result;
    };
    memoized.cache = new (memoize$3.Cache || MapCache$2)();
    return memoized;
  }
  memoize$3.Cache = MapCache$2;
  const d3CurveTypes = {
    curveBasis,
    curveBasisClosed,
    curveBasisOpen,
    curveBumpX: bumpX,
    curveBumpY: bumpY,
    curveBundle,
    curveCardinalClosed,
    curveCardinalOpen,
    curveCardinal,
    curveCatmullRomClosed,
    curveCatmullRomOpen,
    curveCatmullRom,
    curveLinear,
    curveLinearClosed,
    curveMonotoneX: monotoneX,
    curveMonotoneY: monotoneY,
    curveNatural,
    curveStep,
    curveStepAfter: stepAfter,
    curveStepBefore: stepBefore
  };
  const directive = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const directiveWithoutOpen = /\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const detectInit = function(text2, config2) {
    const inits = detectDirective(text2, /(?:init\b)|(?:initialize\b)/);
    let results = {};
    if (Array.isArray(inits)) {
      const args = inits.map((init2) => init2.args);
      directiveSanitizer(args);
      results = assignWithDepth$1(results, [...args]);
    } else {
      results = inits.args;
    }
    if (results) {
      let type2 = detectType(text2, config2);
      ["config"].forEach((prop) => {
        if (results[prop] !== void 0) {
          if (type2 === "flowchart-v2") {
            type2 = "flowchart";
          }
          results[type2] = results[prop];
          delete results[prop];
        }
      });
    }
    return results;
  };
  const detectDirective = function(text2, type2 = null) {
    try {
      const commentWithoutDirectives = new RegExp(
        `[%]{2}(?![{]${directiveWithoutOpen.source})(?=[}][%]{2}).*
`,
        "ig"
      );
      text2 = text2.trim().replace(commentWithoutDirectives, "").replace(/'/gm, '"');
      log$1.debug(
        `Detecting diagram directive${type2 !== null ? " type:" + type2 : ""} based on the text:${text2}`
      );
      let match5;
      const result = [];
      while ((match5 = directive.exec(text2)) !== null) {
        if (match5.index === directive.lastIndex) {
          directive.lastIndex++;
        }
        if (match5 && !type2 || type2 && match5[1] && match5[1].match(type2) || type2 && match5[2] && match5[2].match(type2)) {
          const type22 = match5[1] ? match5[1] : match5[2];
          const args = match5[3] ? match5[3].trim() : match5[4] ? JSON.parse(match5[4].trim()) : null;
          result.push({ type: type22, args });
        }
      }
      if (result.length === 0) {
        result.push({ type: text2, args: null });
      }
      return result.length === 1 ? result[0] : result;
    } catch (error2) {
      log$1.error(
        `ERROR: ${error2.message} - Unable to parse directive
      ${type2 !== null ? " type:" + type2 : ""} based on the text:${text2}`
      );
      return { type: null, args: null };
    }
  };
  const isSubstringInArray = function(str2, arr) {
    for (const [i2, element2] of arr.entries()) {
      if (element2.match(str2)) {
        return i2;
      }
    }
    return -1;
  };
  function interpolateToCurve(interpolate2, defaultCurve) {
    if (!interpolate2) {
      return defaultCurve;
    }
    const curveName = `curve${interpolate2.charAt(0).toUpperCase() + interpolate2.slice(1)}`;
    return d3CurveTypes[curveName] || defaultCurve;
  }
  function formatUrl(linkStr, config2) {
    const url = linkStr.trim();
    if (url) {
      if (config2.securityLevel !== "loose") {
        return sanitizeUrl_1(url);
      }
      return url;
    }
  }
  const runFunc = (functionName, ...params) => {
    const arrPaths = functionName.split(".");
    const len = arrPaths.length - 1;
    const fnName = arrPaths[len];
    let obj = window;
    for (let i2 = 0; i2 < len; i2++) {
      obj = obj[arrPaths[i2]];
      if (!obj) {
        return;
      }
    }
    obj[fnName](...params);
  };
  function distance(p1, p2) {
    return p1 && p2 ? Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2)) : 0;
  }
  function traverseEdge(points) {
    let prevPoint;
    let totalDistance = 0;
    points.forEach((point2) => {
      totalDistance += distance(point2, prevPoint);
      prevPoint = point2;
    });
    let remainingDistance = totalDistance / 2;
    let center2 = void 0;
    prevPoint = void 0;
    points.forEach((point2) => {
      if (prevPoint && !center2) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            center2 = prevPoint;
          }
          if (distanceRatio >= 1) {
            center2 = { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            center2 = {
              x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
              y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
            };
          }
        }
      }
      prevPoint = point2;
    });
    return center2;
  }
  function calcLabelPosition(points) {
    if (points.length === 1) {
      return points[0];
    }
    return traverseEdge(points);
  }
  const calcCardinalityPosition = (isRelationTypePresent, points, initialPosition) => {
    let prevPoint;
    log$1.info(`our points ${JSON.stringify(points)}`);
    if (points[0] !== initialPosition) {
      points = points.reverse();
    }
    const distanceToCardinalityPoint = 25;
    let remainingDistance = distanceToCardinalityPoint;
    let center2;
    prevPoint = void 0;
    points.forEach((point2) => {
      if (prevPoint && !center2) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            center2 = prevPoint;
          }
          if (distanceRatio >= 1) {
            center2 = { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            center2 = {
              x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
              y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
            };
          }
        }
      }
      prevPoint = point2;
    });
    const d = isRelationTypePresent ? 10 : 5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    return cardinalityPosition;
  };
  function calcTerminalLabelPosition(terminalMarkerSize, position2, _points) {
    let points = JSON.parse(JSON.stringify(_points));
    let prevPoint;
    log$1.info("our points", points);
    if (position2 !== "start_left" && position2 !== "start_right") {
      points = points.reverse();
    }
    points.forEach((point2) => {
      prevPoint = point2;
    });
    const distanceToCardinalityPoint = 25 + terminalMarkerSize;
    let remainingDistance = distanceToCardinalityPoint;
    let center2;
    prevPoint = void 0;
    points.forEach((point2) => {
      if (prevPoint && !center2) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            center2 = prevPoint;
          }
          if (distanceRatio >= 1) {
            center2 = { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            center2 = {
              x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
              y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
            };
          }
        }
      }
      prevPoint = point2;
    });
    const d = 10 + terminalMarkerSize * 0.5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    if (position2 === "start_left") {
      cardinalityPosition.x = Math.sin(angle + Math.PI) * d + (points[0].x + center2.x) / 2;
      cardinalityPosition.y = -Math.cos(angle + Math.PI) * d + (points[0].y + center2.y) / 2;
    }
    if (position2 === "end_right") {
      cardinalityPosition.x = Math.sin(angle - Math.PI) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle - Math.PI) * d + (points[0].y + center2.y) / 2 - 5;
    }
    if (position2 === "end_left") {
      cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2 - 5;
    }
    return cardinalityPosition;
  }
  function getStylesFromArray(arr) {
    let style = "";
    let labelStyle = "";
    for (const element2 of arr) {
      if (element2 !== void 0) {
        if (element2.startsWith("color:") || element2.startsWith("text-align:")) {
          labelStyle = labelStyle + element2 + ";";
        } else {
          style = style + element2 + ";";
        }
      }
    }
    return { style, labelStyle };
  }
  let cnt$1 = 0;
  const generateId$1 = () => {
    cnt$1++;
    return "id-" + Math.random().toString(36).substr(2, 12) + "-" + cnt$1;
  };
  function makeid(length2) {
    let result = "";
    const characters2 = "0123456789abcdef";
    const charactersLength = characters2.length;
    for (let i2 = 0; i2 < length2; i2++) {
      result += characters2.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
  }
  const random = (options2) => {
    return makeid(options2.length);
  };
  const getTextObj$3 = function() {
    return {
      x: 0,
      y: 0,
      fill: void 0,
      anchor: "start",
      style: "#666",
      width: 100,
      height: 100,
      textMargin: 0,
      rx: 0,
      ry: 0,
      valign: void 0
    };
  };
  const drawSimpleText = function(elem, textData) {
    const nText = textData.text.replace(common$1.lineBreakRegex, " ");
    const [, _fontSizePx] = parseFontSize(textData.fontSize);
    const textElem = elem.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", textData.y);
    textElem.style("text-anchor", textData.anchor);
    textElem.style("font-family", textData.fontFamily);
    textElem.style("font-size", _fontSizePx);
    textElem.style("font-weight", textData.fontWeight);
    textElem.attr("fill", textData.fill);
    if (textData.class !== void 0) {
      textElem.attr("class", textData.class);
    }
    const span = textElem.append("tspan");
    span.attr("x", textData.x + textData.textMargin * 2);
    span.attr("fill", textData.fill);
    span.text(nText);
    return textElem;
  };
  const wrapLabel = memoize$3(
    (label, maxWidth, config2) => {
      if (!label) {
        return label;
      }
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", joinWith: "<br/>" },
        config2
      );
      if (common$1.lineBreakRegex.test(label)) {
        return label;
      }
      const words = label.split(" ");
      const completedLines = [];
      let nextLine = "";
      words.forEach((word, index) => {
        const wordLength = calculateTextWidth(`${word} `, config2);
        const nextLineLength = calculateTextWidth(nextLine, config2);
        if (wordLength > maxWidth) {
          const { hyphenatedStrings, remainingWord } = breakString(word, maxWidth, "-", config2);
          completedLines.push(nextLine, ...hyphenatedStrings);
          nextLine = remainingWord;
        } else if (nextLineLength + wordLength >= maxWidth) {
          completedLines.push(nextLine);
          nextLine = word;
        } else {
          nextLine = [nextLine, word].filter(Boolean).join(" ");
        }
        const currentWord = index + 1;
        const isLastWord = currentWord === words.length;
        if (isLastWord) {
          completedLines.push(nextLine);
        }
      });
      return completedLines.filter((line2) => line2 !== "").join(config2.joinWith);
    },
    (label, maxWidth, config2) => `${label}${maxWidth}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}${config2.joinWith}`
  );
  const breakString = memoize$3(
    (word, maxWidth, hyphenCharacter = "-", config2) => {
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 0 },
        config2
      );
      const characters2 = [...word];
      const lines = [];
      let currentLine = "";
      characters2.forEach((character2, index) => {
        const nextLine = `${currentLine}${character2}`;
        const lineWidth = calculateTextWidth(nextLine, config2);
        if (lineWidth >= maxWidth) {
          const currentCharacter = index + 1;
          const isLastLine = characters2.length === currentCharacter;
          const hyphenatedNextLine = `${nextLine}${hyphenCharacter}`;
          lines.push(isLastLine ? nextLine : hyphenatedNextLine);
          currentLine = "";
        } else {
          currentLine = nextLine;
        }
      });
      return { hyphenatedStrings: lines, remainingWord: currentLine };
    },
    (word, maxWidth, hyphenCharacter = "-", config2) => `${word}${maxWidth}${hyphenCharacter}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  function calculateTextHeight(text2, config2) {
    config2 = Object.assign(
      { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 15 },
      config2
    );
    return calculateTextDimensions(text2, config2).height;
  }
  function calculateTextWidth(text2, config2) {
    config2 = Object.assign({ fontSize: 12, fontWeight: 400, fontFamily: "Arial" }, config2);
    return calculateTextDimensions(text2, config2).width;
  }
  const calculateTextDimensions = memoize$3(
    (text2, config2) => {
      config2 = Object.assign({ fontSize: 12, fontWeight: 400, fontFamily: "Arial" }, config2);
      const { fontSize, fontFamily, fontWeight } = config2;
      if (!text2) {
        return { width: 0, height: 0 };
      }
      const [, _fontSizePx] = parseFontSize(fontSize);
      const fontFamilies = ["sans-serif", fontFamily];
      const lines = text2.split(common$1.lineBreakRegex);
      const dims = [];
      const body = select("body");
      if (!body.remove) {
        return { width: 0, height: 0, lineHeight: 0 };
      }
      const g = body.append("svg");
      for (const fontFamily2 of fontFamilies) {
        let cheight = 0;
        const dim = { width: 0, height: 0, lineHeight: 0 };
        for (const line2 of lines) {
          const textObj = getTextObj$3();
          textObj.text = line2;
          const textElem = drawSimpleText(g, textObj).style("font-size", _fontSizePx).style("font-weight", fontWeight).style("font-family", fontFamily2);
          const bBox = (textElem._groups || textElem)[0][0].getBBox();
          dim.width = Math.round(Math.max(dim.width, bBox.width));
          cheight = Math.round(bBox.height);
          dim.height += cheight;
          dim.lineHeight = Math.round(Math.max(dim.lineHeight, cheight));
        }
        dims.push(dim);
      }
      g.remove();
      const index = isNaN(dims[1].height) || isNaN(dims[1].width) || isNaN(dims[1].lineHeight) || dims[0].height > dims[1].height && dims[0].width > dims[1].width && dims[0].lineHeight > dims[1].lineHeight ? 0 : 1;
      return dims[index];
    },
    (text2, config2) => `${text2}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  const initIdGenerator = class iterator {
    constructor(deterministic, seed) {
      this.deterministic = deterministic;
      this.seed = seed;
      this.count = seed ? seed.length : 0;
    }
    next() {
      if (!this.deterministic) {
        return Date.now();
      }
      return this.count++;
    }
  };
  let decoder;
  const entityDecode = function(html2) {
    decoder = decoder || document.createElement("div");
    html2 = escape(html2).replace(/%26/g, "&").replace(/%23/g, "#").replace(/%3B/g, ";");
    decoder.innerHTML = html2;
    return unescape(decoder.textContent);
  };
  const directiveSanitizer = (args) => {
    log$1.debug("directiveSanitizer called with", args);
    if (typeof args === "object") {
      if (args.length) {
        args.forEach((arg) => directiveSanitizer(arg));
      } else {
        Object.keys(args).forEach((key) => {
          log$1.debug("Checking key", key);
          if (key.startsWith("__")) {
            log$1.debug("sanitize deleting __ option", key);
            delete args[key];
          }
          if (key.includes("proto")) {
            log$1.debug("sanitize deleting proto option", key);
            delete args[key];
          }
          if (key.includes("constr")) {
            log$1.debug("sanitize deleting constr option", key);
            delete args[key];
          }
          if (key.includes("themeCSS")) {
            log$1.debug("sanitizing themeCss option");
            args[key] = sanitizeCss(args[key]);
          }
          if (key.includes("fontFamily")) {
            log$1.debug("sanitizing fontFamily option");
            args[key] = sanitizeCss(args[key]);
          }
          if (key.includes("altFontFamily")) {
            log$1.debug("sanitizing altFontFamily option");
            args[key] = sanitizeCss(args[key]);
          }
          if (!configKeys.includes(key)) {
            log$1.debug("sanitize deleting option", key);
            delete args[key];
          } else {
            if (typeof args[key] === "object") {
              log$1.debug("sanitize deleting object", key);
              directiveSanitizer(args[key]);
            }
          }
        });
      }
    }
    if (args.themeVariables) {
      const kArr = Object.keys(args.themeVariables);
      for (const k of kArr) {
        const val = args.themeVariables[k];
        if (val && val.match && !val.match(/^[\d "#%(),.;A-Za-z]+$/)) {
          args.themeVariables[k] = "";
        }
      }
    }
    log$1.debug("After sanitization", args);
  };
  const sanitizeCss = (str2) => {
    let startCnt = 0;
    let endCnt = 0;
    for (const element2 of str2) {
      if (startCnt < endCnt) {
        return "{ /* ERROR: Unbalanced CSS */ }";
      }
      if (element2 === "{") {
        startCnt++;
      } else if (element2 === "}") {
        endCnt++;
      }
    }
    if (startCnt !== endCnt) {
      return "{ /* ERROR: Unbalanced CSS */ }";
    }
    return str2;
  };
  function isDetailedError(error2) {
    return "str" in error2;
  }
  function getErrorMessage(error2) {
    if (error2 instanceof Error) {
      return error2.message;
    }
    return String(error2);
  }
  const insertTitle = (parent, cssClass, titleTopMargin, title2) => {
    if (!title2) {
      return;
    }
    const bounds2 = parent.node().getBBox();
    parent.append("text").text(title2).attr("x", bounds2.x + bounds2.width / 2).attr("y", -titleTopMargin).attr("class", cssClass);
  };
  const parseFontSize = (fontSize) => {
    if (typeof fontSize === "number") {
      return [fontSize, fontSize + "px"];
    }
    const fontSizeNumber = parseInt(fontSize, 10);
    if (Number.isNaN(fontSizeNumber)) {
      return [void 0, void 0];
    } else if (fontSize === String(fontSizeNumber)) {
      return [fontSizeNumber, fontSize + "px"];
    } else {
      return [fontSizeNumber, fontSize];
    }
  };
  const utils = {
    assignWithDepth: assignWithDepth$1,
    wrapLabel,
    calculateTextHeight,
    calculateTextWidth,
    calculateTextDimensions,
    detectInit,
    detectDirective,
    isSubstringInArray,
    interpolateToCurve,
    calcLabelPosition,
    calcCardinalityPosition,
    calcTerminalLabelPosition,
    formatUrl,
    getStylesFromArray,
    generateId: generateId$1,
    random,
    runFunc,
    entityDecode,
    initIdGenerator,
    directiveSanitizer,
    sanitizeCss,
    insertTitle,
    parseFontSize
  };
  var COMMENT = "comm";
  var RULESET = "rule";
  var DECLARATION = "decl";
  var IMPORT = "@import";
  var KEYFRAMES = "@keyframes";
  var abs = Math.abs;
  var from = String.fromCharCode;
  function trim(value) {
    return value.trim();
  }
  function replace(value, pattern, replacement) {
    return value.replace(pattern, replacement);
  }
  function indexof(value, search) {
    return value.indexOf(search);
  }
  function charat(value, index) {
    return value.charCodeAt(index) | 0;
  }
  function substr(value, begin, end2) {
    return value.slice(begin, end2);
  }
  function strlen(value) {
    return value.length;
  }
  function sizeof(value) {
    return value.length;
  }
  function append(value, array2) {
    return array2.push(value), value;
  }
  var line = 1;
  var column = 1;
  var length = 0;
  var position$2 = 0;
  var character = 0;
  var characters = "";
  function node(value, root2, parent, type2, props, children2, length2) {
    return { value, root: root2, parent, type: type2, props, children: children2, line, column, length: length2, return: "" };
  }
  function char() {
    return character;
  }
  function prev() {
    character = position$2 > 0 ? charat(characters, --position$2) : 0;
    if (column--, character === 10)
      column = 1, line--;
    return character;
  }
  function next$1() {
    character = position$2 < length ? charat(characters, position$2++) : 0;
    if (column++, character === 10)
      column = 1, line++;
    return character;
  }
  function peek() {
    return charat(characters, position$2);
  }
  function caret() {
    return position$2;
  }
  function slice(begin, end2) {
    return substr(characters, begin, end2);
  }
  function token(type2) {
    switch (type2) {
      case 0:
      case 9:
      case 10:
      case 13:
      case 32:
        return 5;
      case 33:
      case 43:
      case 44:
      case 47:
      case 62:
      case 64:
      case 126:
      case 59:
      case 123:
      case 125:
        return 4;
      case 58:
        return 3;
      case 34:
      case 39:
      case 40:
      case 91:
        return 2;
      case 41:
      case 93:
        return 1;
    }
    return 0;
  }
  function alloc(value) {
    return line = column = 1, length = strlen(characters = value), position$2 = 0, [];
  }
  function dealloc(value) {
    return characters = "", value;
  }
  function delimit(type2) {
    return trim(slice(position$2 - 1, delimiter(type2 === 91 ? type2 + 2 : type2 === 40 ? type2 + 1 : type2)));
  }
  function whitespace(type2) {
    while (character = peek())
      if (character < 33)
        next$1();
      else
        break;
    return token(type2) > 2 || token(character) > 3 ? "" : " ";
  }
  function escaping(index, count) {
    while (--count && next$1())
      if (character < 48 || character > 102 || character > 57 && character < 65 || character > 70 && character < 97)
        break;
    return slice(index, caret() + (count < 6 && peek() == 32 && next$1() == 32));
  }
  function delimiter(type2) {
    while (next$1())
      switch (character) {
        case type2:
          return position$2;
        case 34:
        case 39:
          if (type2 !== 34 && type2 !== 39)
            delimiter(character);
          break;
        case 40:
          if (type2 === 41)
            delimiter(type2);
          break;
        case 92:
          next$1();
          break;
      }
    return position$2;
  }
  function commenter(type2, index) {
    while (next$1())
      if (type2 + character === 47 + 10)
        break;
      else if (type2 + character === 42 + 42 && peek() === 47)
        break;
    return "/*" + slice(index, position$2 - 1) + "*" + from(type2 === 47 ? type2 : next$1());
  }
  function identifier(index) {
    while (!token(peek()))
      next$1();
    return slice(index, position$2);
  }
  function compile(value) {
    return dealloc(parse$5("", null, null, null, [""], value = alloc(value), 0, [0], value));
  }
  function parse$5(value, root2, parent, rule, rules, rulesets, pseudo, points, declarations) {
    var index = 0;
    var offset2 = 0;
    var length2 = pseudo;
    var atrule = 0;
    var property2 = 0;
    var previous = 0;
    var variable = 1;
    var scanning = 1;
    var ampersand = 1;
    var character2 = 0;
    var type2 = "";
    var props = rules;
    var children2 = rulesets;
    var reference = rule;
    var characters2 = type2;
    while (scanning)
      switch (previous = character2, character2 = next$1()) {
        case 40:
          if (previous != 108 && charat(characters2, length2 - 1) == 58) {
            if (indexof(characters2 += replace(delimit(character2), "&", "&\f"), "&\f") != -1)
              ampersand = -1;
            break;
          }
        case 34:
        case 39:
        case 91:
          characters2 += delimit(character2);
          break;
        case 9:
        case 10:
        case 13:
        case 32:
          characters2 += whitespace(previous);
          break;
        case 92:
          characters2 += escaping(caret() - 1, 7);
          continue;
        case 47:
          switch (peek()) {
            case 42:
            case 47:
              append(comment(commenter(next$1(), caret()), root2, parent), declarations);
              break;
            default:
              characters2 += "/";
          }
          break;
        case 123 * variable:
          points[index++] = strlen(characters2) * ampersand;
        case 125 * variable:
        case 59:
        case 0:
          switch (character2) {
            case 0:
            case 125:
              scanning = 0;
            case 59 + offset2:
              if (property2 > 0 && strlen(characters2) - length2)
                append(property2 > 32 ? declaration(characters2 + ";", rule, parent, length2 - 1) : declaration(replace(characters2, " ", "") + ";", rule, parent, length2 - 2), declarations);
              break;
            case 59:
              characters2 += ";";
            default:
              append(reference = ruleset(characters2, root2, parent, index, offset2, rules, points, type2, props = [], children2 = [], length2), rulesets);
              if (character2 === 123)
                if (offset2 === 0)
                  parse$5(characters2, root2, reference, reference, props, rulesets, length2, points, children2);
                else
                  switch (atrule) {
                    case 100:
                    case 109:
                    case 115:
                      parse$5(value, reference, reference, rule && append(ruleset(value, reference, reference, 0, 0, rules, points, type2, rules, props = [], length2), children2), rules, children2, length2, points, rule ? props : children2);
                      break;
                    default:
                      parse$5(characters2, reference, reference, reference, [""], children2, 0, points, children2);
                  }
          }
          index = offset2 = property2 = 0, variable = ampersand = 1, type2 = characters2 = "", length2 = pseudo;
          break;
        case 58:
          length2 = 1 + strlen(characters2), property2 = previous;
        default:
          if (variable < 1) {
            if (character2 == 123)
              --variable;
            else if (character2 == 125 && variable++ == 0 && prev() == 125)
              continue;
          }
          switch (characters2 += from(character2), character2 * variable) {
            case 38:
              ampersand = offset2 > 0 ? 1 : (characters2 += "\f", -1);
              break;
            case 44:
              points[index++] = (strlen(characters2) - 1) * ampersand, ampersand = 1;
              break;
            case 64:
              if (peek() === 45)
                characters2 += delimit(next$1());
              atrule = peek(), offset2 = length2 = strlen(type2 = characters2 += identifier(caret())), character2++;
              break;
            case 45:
              if (previous === 45 && strlen(characters2) == 2)
                variable = 0;
          }
      }
    return rulesets;
  }
  function ruleset(value, root2, parent, index, offset2, rules, points, type2, props, children2, length2) {
    var post = offset2 - 1;
    var rule = offset2 === 0 ? rules : [""];
    var size2 = sizeof(rule);
    for (var i2 = 0, j = 0, k = 0; i2 < index; ++i2)
      for (var x2 = 0, y2 = substr(value, post + 1, post = abs(j = points[i2])), z = value; x2 < size2; ++x2)
        if (z = trim(j > 0 ? rule[x2] + " " + y2 : replace(y2, /&\f/g, rule[x2])))
          props[k++] = z;
    return node(value, root2, parent, offset2 === 0 ? RULESET : type2, props, children2, length2);
  }
  function comment(value, root2, parent) {
    return node(value, root2, parent, COMMENT, from(char()), substr(value, 2, -2), 0);
  }
  function declaration(value, root2, parent, length2) {
    return node(value, root2, parent, DECLARATION, substr(value, 0, length2), substr(value, length2 + 1, -1), length2);
  }
  function serialize(children2, callback) {
    var output2 = "";
    var length2 = sizeof(children2);
    for (var i2 = 0; i2 < length2; i2++)
      output2 += callback(children2[i2], i2, children2, callback) || "";
    return output2;
  }
  function stringify(element2, index, children2, callback) {
    switch (element2.type) {
      case IMPORT:
      case DECLARATION:
        return element2.return = element2.return || element2.value;
      case COMMENT:
        return "";
      case KEYFRAMES:
        return element2.return = element2.value + "{" + serialize(element2.children, callback) + "}";
      case RULESET:
        element2.value = element2.props.join(",");
    }
    return strlen(children2 = serialize(element2.children, callback)) ? element2.return = element2.value + "{" + children2 + "}" : "";
  }
  const name$1 = "mermaid";
  const version$2 = "9.4.0";
  const description$1 = "Markdown-ish syntax for generating flowcharts, sequence diagrams, class diagrams, gantt charts and git graphs.";
  const main = "./dist/mermaid.min.js";
  const module$1 = "./dist/mermaid.core.mjs";
  const types = "./dist/mermaid.d.ts";
  const exports$1 = {
    ".": {
      require: "./dist/mermaid.min.js",
      "import": "./dist/mermaid.core.mjs",
      types: "./dist/mermaid.d.ts"
    },
    "./*": "./*"
  };
  const keywords = [
    "diagram",
    "markdown",
    "flowchart",
    "sequence diagram",
    "gantt",
    "class diagram",
    "git graph"
  ];
  const scripts = {
    clean: "rimraf dist",
    "docs:code": "typedoc src/defaultConfig.ts src/config.ts src/mermaidAPI.ts && prettier --write ./src/docs/config/setup",
    "docs:build": "rimraf ../../docs && pnpm docs:spellcheck && pnpm docs:code && ts-node-esm src/docs.mts",
    "docs:verify": "pnpm docs:spellcheck && pnpm docs:code && ts-node-esm src/docs.mts --verify",
    "docs:pre:vitepress": "rimraf src/vitepress && pnpm docs:code && ts-node-esm src/docs.mts --vitepress",
    "docs:build:vitepress": "pnpm docs:pre:vitepress && vitepress build src/vitepress && cpy --flat src/docs/landing/ ./src/vitepress/.vitepress/dist/landing",
    "docs:dev": 'pnpm docs:pre:vitepress && concurrently "vitepress dev src/vitepress" "ts-node-esm src/docs.mts --watch --vitepress"',
    "docs:serve": "pnpm docs:build:vitepress && vitepress serve src/vitepress",
    "docs:spellcheck": 'cspell --config ../../cSpell.json "src/docs/**/*.md"',
    release: "pnpm build",
    prepublishOnly: "pnpm -w run build"
  };
  const repository = {
    type: "git",
    url: "https://github.com/mermaid-js/mermaid"
  };
  const author = "Knut Sveidqvist";
  const license = "MIT";
  const standard = {
    ignore: [
      "**/parser/*.js",
      "dist/**/*.js",
      "cypress/**/*.js"
    ],
    globals: [
      "page"
    ]
  };
  const dependencies = {
    "@braintree/sanitize-url": "^6.0.0",
    cytoscape: "^3.23.0",
    "cytoscape-cose-bilkent": "^4.1.0",
    "cytoscape-fcose": "^2.1.0",
    d3: "^7.0.0",
    "dagre-d3-es": "7.0.8",
    dompurify: "2.4.3",
    elkjs: "^0.8.2",
    khroma: "^2.0.0",
    "lodash-es": "^4.17.21",
    moment: "^2.29.4",
    "non-layered-tidy-tree-layout": "^2.0.2",
    stylis: "^4.1.2",
    "ts-dedent": "^2.2.0",
    uuid: "^9.0.0"
  };
  const devDependencies = {
    "@types/cytoscape": "^3.19.9",
    "@types/d3": "^7.4.0",
    "@types/dompurify": "^2.4.0",
    "@types/jsdom": "^20.0.1",
    "@types/lodash-es": "^4.17.6",
    "@types/micromatch": "^4.0.2",
    "@types/prettier": "^2.7.1",
    "@types/stylis": "^4.0.2",
    "@types/uuid": "^8.3.4",
    "@typescript-eslint/eslint-plugin": "^5.42.1",
    "@typescript-eslint/parser": "^5.42.1",
    chokidar: "^3.5.3",
    concurrently: "^7.5.0",
    coveralls: "^3.1.1",
    "cpy-cli": "^4.2.0",
    cspell: "^6.14.3",
    globby: "^13.1.2",
    jison: "^0.4.18",
    "js-base64": "^3.7.2",
    jsdom: "^20.0.2",
    micromatch: "^4.0.5",
    "path-browserify": "^1.0.1",
    prettier: "^2.7.1",
    remark: "^14.0.2",
    "remark-frontmatter": "^4.0.1",
    "remark-gfm": "^3.0.1",
    rimraf: "^3.0.2",
    "start-server-and-test": "^1.14.0",
    typedoc: "^0.23.18",
    "typedoc-plugin-markdown": "^3.13.6",
    typescript: "^4.8.4",
    "unist-util-flatmap": "^1.0.0",
    vitepress: "^1.0.0-alpha.31",
    "vitepress-plugin-search": "^1.0.4-alpha.16"
  };
  const files = [
    "dist",
    "README.md"
  ];
  const sideEffects = [
    "**/*.css",
    "**/*.scss"
  ];
  const pkg = {
    name: name$1,
    version: version$2,
    description: description$1,
    main,
    module: module$1,
    types,
    exports: exports$1,
    keywords,
    scripts,
    repository,
    author,
    license,
    standard,
    dependencies,
    devDependencies,
    files,
    sideEffects
  };
  const defaultConfig = Object.freeze(config$2);
  let siteConfig = assignWithDepth$1({}, defaultConfig);
  let configFromInitialize;
  let directives = [];
  let currentConfig = assignWithDepth$1({}, defaultConfig);
  const updateCurrentConfig = (siteCfg, _directives) => {
    let cfg = assignWithDepth$1({}, siteCfg);
    let sumOfDirectives = {};
    for (const d of _directives) {
      sanitize(d);
      sumOfDirectives = assignWithDepth$1(sumOfDirectives, d);
    }
    cfg = assignWithDepth$1(cfg, sumOfDirectives);
    if (sumOfDirectives.theme && sumOfDirectives.theme in theme) {
      const tmpConfigFromInitialize = assignWithDepth$1({}, configFromInitialize);
      const themeVariables = assignWithDepth$1(
        tmpConfigFromInitialize.themeVariables || {},
        sumOfDirectives.themeVariables
      );
      if (cfg.theme && cfg.theme in theme) {
        cfg.themeVariables = theme[cfg.theme].getThemeVariables(themeVariables);
      }
    }
    currentConfig = cfg;
    checkConfig(currentConfig);
    return currentConfig;
  };
  const setSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1({}, defaultConfig);
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    if (conf2.theme && theme[conf2.theme]) {
      siteConfig.themeVariables = theme[conf2.theme].getThemeVariables(conf2.themeVariables);
    }
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const saveConfigFromInitialize = (conf2) => {
    configFromInitialize = assignWithDepth$1({}, conf2);
  };
  const updateSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const getSiteConfig = () => {
    return assignWithDepth$1({}, siteConfig);
  };
  const setConfig = (conf2) => {
    checkConfig(conf2);
    assignWithDepth$1(currentConfig, conf2);
    return getConfig$1();
  };
  const getConfig$1 = () => {
    return assignWithDepth$1({}, currentConfig);
  };
  const sanitize = (options2) => {
    var _a;
    ["secure", ...(_a = siteConfig.secure) != null ? _a : []].forEach((key) => {
      if (options2[key] !== void 0) {
        log$1.debug(`Denied attempt to modify a secure key ${key}`, options2[key]);
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (key.indexOf("__") === 0) {
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (typeof options2[key] === "string" && (options2[key].includes("<") || options2[key].includes(">") || options2[key].includes("url(data:"))) {
        delete options2[key];
      }
      if (typeof options2[key] === "object") {
        sanitize(options2[key]);
      }
    });
  };
  const addDirective = (directive2) => {
    if (directive2.fontFamily) {
      if (!directive2.themeVariables) {
        directive2.themeVariables = { fontFamily: directive2.fontFamily };
      } else {
        if (!directive2.themeVariables.fontFamily) {
          directive2.themeVariables = { fontFamily: directive2.fontFamily };
        }
      }
    }
    directives.push(directive2);
    updateCurrentConfig(siteConfig, directives);
  };
  const reset = (config2 = siteConfig) => {
    directives = [];
    updateCurrentConfig(config2, directives);
  };
  var ConfigWarning = /* @__PURE__ */ ((ConfigWarning2) => {
    ConfigWarning2["LAZY_LOAD_DEPRECATED"] = "The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead.";
    return ConfigWarning2;
  })(ConfigWarning || {});
  const issuedWarnings = {};
  const issueWarning = (warning) => {
    if (issuedWarnings[warning]) {
      return;
    }
    log$1.warn(ConfigWarning[warning]);
    issuedWarnings[warning] = true;
  };
  const checkConfig = (config2) => {
    if (!config2) {
      return;
    }
    if (config2.lazyLoadedDiagrams || config2.loadExternalDiagramsAtStartup) {
      issueWarning("LAZY_LOAD_DEPRECATED");
    }
  };
  const d3Attrs = function(d3Elem, attrs) {
    for (let attr of attrs) {
      d3Elem.attr(attr[0], attr[1]);
    }
  };
  const calculateSvgSizeAttrs = function(height2, width2, useMaxWidth) {
    let attrs = /* @__PURE__ */ new Map();
    if (useMaxWidth) {
      attrs.set("width", "100%");
      attrs.set("style", `max-width: ${width2}px;`);
    } else {
      attrs.set("height", height2);
      attrs.set("width", width2);
    }
    return attrs;
  };
  const configureSvgSize = function(svgElem, height2, width2, useMaxWidth) {
    const attrs = calculateSvgSizeAttrs(height2, width2, useMaxWidth);
    d3Attrs(svgElem, attrs);
  };
  const setupGraphViewbox$1 = function(graph, svgElem, padding2, useMaxWidth) {
    const svgBounds = svgElem.node().getBBox();
    const sWidth = svgBounds.width;
    const sHeight = svgBounds.height;
    log$1.info(`SVG bounds: ${sWidth}x${sHeight}`, svgBounds);
    let width2 = 0;
    let height2 = 0;
    log$1.info(`Graph bounds: ${width2}x${height2}`, graph);
    width2 = sWidth + padding2 * 2;
    height2 = sHeight + padding2 * 2;
    log$1.info(`Calculated bounds: ${width2}x${height2}`);
    configureSvgSize(svgElem, height2, width2, useMaxWidth);
    const vBox = `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${svgBounds.width + 2 * padding2} ${svgBounds.height + 2 * padding2}`;
    svgElem.attr("viewBox", vBox);
  };
  const getStyles$h = (options2) => `g.classGroup text {
  fill: ${options2.nodeBorder};
  fill: ${options2.classText};
  stroke: none;
  font-family: ${options2.fontFamily};
  font-size: 10px;

  .title {
    font-weight: bolder;
  }

}

.nodeLabel, .edgeLabel {
  color: ${options2.classText};
}
.edgeLabel .label rect {
  fill: ${options2.mainBkg};
}
.label text {
  fill: ${options2.classText};
}
.edgeLabel .label span {
  background: ${options2.mainBkg};
}

.classTitle {
  font-weight: bolder;
}
.node rect,
  .node circle,
  .node ellipse,
  .node polygon,
  .node path {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
    stroke-width: 1px;
  }


.divider {
  stroke: ${options2.nodeBorder};
  stroke: 1;
}

g.clickable {
  cursor: pointer;
}

g.classGroup rect {
  fill: ${options2.mainBkg};
  stroke: ${options2.nodeBorder};
}

g.classGroup line {
  stroke: ${options2.nodeBorder};
  stroke-width: 1;
}

.classLabel .box {
  stroke: none;
  stroke-width: 0;
  fill: ${options2.mainBkg};
  opacity: 0.5;
}

.classLabel .label {
  fill: ${options2.nodeBorder};
  font-size: 10px;
}

.relation {
  stroke: ${options2.lineColor};
  stroke-width: 1;
  fill: none;
}

.dashed-line{
  stroke-dasharray: 3;
}

.dotted-line{
  stroke-dasharray: 1 2;
}

#compositionStart, .composition {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#compositionEnd, .composition {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#dependencyStart, .dependency {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#dependencyStart, .dependency {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#extensionStart, .extension {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#extensionEnd, .extension {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#aggregationStart, .aggregation {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#aggregationEnd, .aggregation {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#lollipopStart, .lollipop {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#lollipopEnd, .lollipop {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

.edgeTerminals {
  font-size: 11px;
}

.classTitleText {
  text-anchor: middle;
  font-size: 18px;
  fill: ${options2.textColor};
}
`;
  const classStyles = getStyles$h;
  const getStyles$g = (options2) => `
  .entityBox {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
  }

  .attributeBoxOdd {
    fill: ${options2.attributeBackgroundColorOdd};
    stroke: ${options2.nodeBorder};
  }

  .attributeBoxEven {
    fill:  ${options2.attributeBackgroundColorEven};
    stroke: ${options2.nodeBorder};
  }

  .relationshipLabelBox {
    fill: ${options2.tertiaryColor};
    opacity: 0.7;
    background-color: ${options2.tertiaryColor};
      rect {
        opacity: 0.5;
      }
  }

    .relationshipLine {
      stroke: ${options2.lineColor};
    }

  .entityTitleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor};
  }    
`;
  const erStyles = getStyles$g;
  const getStyles$f = () => ``;
  const errorStyles = getStyles$f;
  const getStyles$e = (options2) => `.label {
    font-family: ${options2.fontFamily};
    color: ${options2.nodeTextColor || options2.textColor};
  }
  .cluster-label text {
    fill: ${options2.titleColor};
  }
  .cluster-label span {
    color: ${options2.titleColor};
  }

  .label text,span {
    fill: ${options2.nodeTextColor || options2.textColor};
    color: ${options2.nodeTextColor || options2.textColor};
  }

  .node rect,
  .node circle,
  .node ellipse,
  .node polygon,
  .node path {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
    stroke-width: 1px;
  }

  .node .label {
    text-align: center;
  }
  .node.clickable {
    cursor: pointer;
  }

  .arrowheadPath {
    fill: ${options2.arrowheadColor};
  }

  .edgePath .path {
    stroke: ${options2.lineColor};
    stroke-width: 2.0px;
  }

  .flowchart-link {
    stroke: ${options2.lineColor};
    fill: none;
  }

  .edgeLabel {
    background-color: ${options2.edgeLabelBackground};
    rect {
      opacity: 0.5;
      background-color: ${options2.edgeLabelBackground};
      fill: ${options2.edgeLabelBackground};
    }
    text-align: center;
  }

  .cluster rect {
    fill: ${options2.clusterBkg};
    stroke: ${options2.clusterBorder};
    stroke-width: 1px;
  }

  .cluster text {
    fill: ${options2.titleColor};
  }

  .cluster span {
    color: ${options2.titleColor};
  }
  /* .cluster div {
    color: ${options2.titleColor};
  } */

  div.mermaidTooltip {
    position: absolute;
    text-align: center;
    max-width: 200px;
    padding: 2px;
    font-family: ${options2.fontFamily};
    font-size: 12px;
    background: ${options2.tertiaryColor};
    border: 1px solid ${options2.border2};
    border-radius: 2px;
    pointer-events: none;
    z-index: 100;
  }

  .flowchartTitleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor};
  }
`;
  const flowStyles = getStyles$e;
  const getStyles$d = (options2) => `
  .mermaid-main-font {
    font-family: "trebuchet ms", verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }
  .exclude-range {
    fill: ${options2.excludeBkgColor};
  }

  .section {
    stroke: none;
    opacity: 0.2;
  }

  .section0 {
    fill: ${options2.sectionBkgColor};
  }

  .section2 {
    fill: ${options2.sectionBkgColor2};
  }

  .section1,
  .section3 {
    fill: ${options2.altSectionBkgColor};
    opacity: 0.2;
  }

  .sectionTitle0 {
    fill: ${options2.titleColor};
  }

  .sectionTitle1 {
    fill: ${options2.titleColor};
  }

  .sectionTitle2 {
    fill: ${options2.titleColor};
  }

  .sectionTitle3 {
    fill: ${options2.titleColor};
  }

  .sectionTitle {
    text-anchor: start;
    // font-size: ${options2.ganttFontSize};
    // text-height: 14px;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);

  }


  /* Grid and axis */

  .grid .tick {
    stroke: ${options2.gridColor};
    opacity: 0.8;
    shape-rendering: crispEdges;
    text {
      font-family: ${options2.fontFamily};
      fill: ${options2.textColor};
    }
  }

  .grid path {
    stroke-width: 0;
  }


  /* Today line */

  .today {
    fill: none;
    stroke: ${options2.todayLineColor};
    stroke-width: 2px;
  }


  /* Task styling */

  /* Default task */

  .task {
    stroke-width: 2;
  }

  .taskText {
    text-anchor: middle;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }

  // .taskText:not([font-size]) {
  //   font-size: ${options2.ganttFontSize};
  // }

  .taskTextOutsideRight {
    fill: ${options2.taskTextDarkColor};
    text-anchor: start;
    // font-size: ${options2.ganttFontSize};
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);

  }

  .taskTextOutsideLeft {
    fill: ${options2.taskTextDarkColor};
    text-anchor: end;
    // font-size: ${options2.ganttFontSize};
  }

  /* Special case clickable */
  .task.clickable {
    cursor: pointer;
  }
  .taskText.clickable {
    cursor: pointer;
    fill: ${options2.taskTextClickableColor} !important;
    font-weight: bold;
  }

  .taskTextOutsideLeft.clickable {
    cursor: pointer;
    fill: ${options2.taskTextClickableColor} !important;
    font-weight: bold;
  }

  .taskTextOutsideRight.clickable {
    cursor: pointer;
    fill: ${options2.taskTextClickableColor} !important;
    font-weight: bold;
  }

  /* Specific task settings for the sections*/

  .taskText0,
  .taskText1,
  .taskText2,
  .taskText3 {
    fill: ${options2.taskTextColor};
  }

  .task0,
  .task1,
  .task2,
  .task3 {
    fill: ${options2.taskBkgColor};
    stroke: ${options2.taskBorderColor};
  }

  .taskTextOutside0,
  .taskTextOutside2
  {
    fill: ${options2.taskTextOutsideColor};
  }

  .taskTextOutside1,
  .taskTextOutside3 {
    fill: ${options2.taskTextOutsideColor};
  }


  /* Active task */

  .active0,
  .active1,
  .active2,
  .active3 {
    fill: ${options2.activeTaskBkgColor};
    stroke: ${options2.activeTaskBorderColor};
  }

  .activeText0,
  .activeText1,
  .activeText2,
  .activeText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }


  /* Completed task */

  .done0,
  .done1,
  .done2,
  .done3 {
    stroke: ${options2.doneTaskBorderColor};
    fill: ${options2.doneTaskBkgColor};
    stroke-width: 2;
  }

  .doneText0,
  .doneText1,
  .doneText2,
  .doneText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }


  /* Tasks on the critical line */

  .crit0,
  .crit1,
  .crit2,
  .crit3 {
    stroke: ${options2.critBorderColor};
    fill: ${options2.critBkgColor};
    stroke-width: 2;
  }

  .activeCrit0,
  .activeCrit1,
  .activeCrit2,
  .activeCrit3 {
    stroke: ${options2.critBorderColor};
    fill: ${options2.activeTaskBkgColor};
    stroke-width: 2;
  }

  .doneCrit0,
  .doneCrit1,
  .doneCrit2,
  .doneCrit3 {
    stroke: ${options2.critBorderColor};
    fill: ${options2.doneTaskBkgColor};
    stroke-width: 2;
    cursor: pointer;
    shape-rendering: crispEdges;
  }

  .milestone {
    transform: rotate(45deg) scale(0.8,0.8);
  }

  .milestoneText {
    font-style: italic;
  }
  .doneCritText0,
  .doneCritText1,
  .doneCritText2,
  .doneCritText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }

  .activeCritText0,
  .activeCritText1,
  .activeCritText2,
  .activeCritText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }

  .titleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor}    ;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }
`;
  const ganttStyles = getStyles$d;
  const getStyles$c = () => ``;
  const infoStyles = getStyles$c;
  const getStyles$b = (options2) => `
  .pieCircle{
    stroke: ${options2.pieStrokeColor};
    stroke-width : ${options2.pieStrokeWidth};
    opacity : ${options2.pieOpacity};
  }
  .pieTitleText {
    text-anchor: middle;
    font-size: ${options2.pieTitleTextSize};
    fill: ${options2.pieTitleTextColor};
    font-family: ${options2.fontFamily};
  }
  .slice {
    font-family: ${options2.fontFamily};
    fill: ${options2.pieSectionTextColor};
    font-size:${options2.pieSectionTextSize};
    // fill: white;
  }
  .legend text {
    fill: ${options2.pieLegendTextColor};
    font-family: ${options2.fontFamily};
    font-size: ${options2.pieLegendTextSize};
  }
`;
  const pieStyles = getStyles$b;
  const getStyles$a = (options2) => `

  marker {
    fill: ${options2.relationColor};
    stroke: ${options2.relationColor};
  }

  marker.cross {
    stroke: ${options2.lineColor};
  }

  svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  .reqBox {
    fill: ${options2.requirementBackground};
    fill-opacity: 100%;
    stroke: ${options2.requirementBorderColor};
    stroke-width: ${options2.requirementBorderSize};
  }
  
  .reqTitle, .reqLabel{
    fill:  ${options2.requirementTextColor};
  }
  .reqLabelBox {
    fill: ${options2.relationLabelBackground};
    fill-opacity: 100%;
  }

  .req-title-line {
    stroke: ${options2.requirementBorderColor};
    stroke-width: ${options2.requirementBorderSize};
  }
  .relationshipLine {
    stroke: ${options2.relationColor};
    stroke-width: 1;
  }
  .relationshipLabel {
    fill: ${options2.relationLabelColor};
  }

`;
  const requirementStyles = getStyles$a;
  const getStyles$9 = (options2) => `.actor {
    stroke: ${options2.actorBorder};
    fill: ${options2.actorBkg};
  }

  text.actor > tspan {
    fill: ${options2.actorTextColor};
    stroke: none;
  }

  .actor-line {
    stroke: ${options2.actorLineColor};
  }

  .messageLine0 {
    stroke-width: 1.5;
    stroke-dasharray: none;
    stroke: ${options2.signalColor};
  }

  .messageLine1 {
    stroke-width: 1.5;
    stroke-dasharray: 2, 2;
    stroke: ${options2.signalColor};
  }

  #arrowhead path {
    fill: ${options2.signalColor};
    stroke: ${options2.signalColor};
  }

  .sequenceNumber {
    fill: ${options2.sequenceNumberColor};
  }

  #sequencenumber {
    fill: ${options2.signalColor};
  }

  #crosshead path {
    fill: ${options2.signalColor};
    stroke: ${options2.signalColor};
  }

  .messageText {
    fill: ${options2.signalTextColor};
    stroke: none;
  }

  .labelBox {
    stroke: ${options2.labelBoxBorderColor};
    fill: ${options2.labelBoxBkgColor};
  }

  .labelText, .labelText > tspan {
    fill: ${options2.labelTextColor};
    stroke: none;
  }

  .loopText, .loopText > tspan {
    fill: ${options2.loopTextColor};
    stroke: none;
  }

  .loopLine {
    stroke-width: 2px;
    stroke-dasharray: 2, 2;
    stroke: ${options2.labelBoxBorderColor};
    fill: ${options2.labelBoxBorderColor};
  }

  .note {
    //stroke: #decc93;
    stroke: ${options2.noteBorderColor};
    fill: ${options2.noteBkgColor};
  }

  .noteText, .noteText > tspan {
    fill: ${options2.noteTextColor};
    stroke: none;
  }

  .activation0 {
    fill: ${options2.activationBkgColor};
    stroke: ${options2.activationBorderColor};
  }

  .activation1 {
    fill: ${options2.activationBkgColor};
    stroke: ${options2.activationBorderColor};
  }

  .activation2 {
    fill: ${options2.activationBkgColor};
    stroke: ${options2.activationBorderColor};
  }

  .actorPopupMenu {
    position: absolute;
  }

  .actorPopupMenuPanel {
    position: absolute;
    fill: ${options2.actorBkg};
    box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
    filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0.4));
}
  .actor-man line {
    stroke: ${options2.actorBorder};
    fill: ${options2.actorBkg};
  }
  .actor-man circle, line {
    stroke: ${options2.actorBorder};
    fill: ${options2.actorBkg};
    stroke-width: 2px;
  }
`;
  const sequenceStyles = getStyles$9;
  const getStyles$8 = (options2) => `
defs #statediagram-barbEnd {
    fill: ${options2.transitionColor};
    stroke: ${options2.transitionColor};
  }
g.stateGroup text {
  fill: ${options2.nodeBorder};
  stroke: none;
  font-size: 10px;
}
g.stateGroup text {
  fill: ${options2.textColor};
  stroke: none;
  font-size: 10px;

}
g.stateGroup .state-title {
  font-weight: bolder;
  fill: ${options2.stateLabelColor};
}

g.stateGroup rect {
  fill: ${options2.mainBkg};
  stroke: ${options2.nodeBorder};
}

g.stateGroup line {
  stroke: ${options2.lineColor};
  stroke-width: 1;
}

.transition {
  stroke: ${options2.transitionColor};
  stroke-width: 1;
  fill: none;
}

.stateGroup .composit {
  fill: ${options2.background};
  border-bottom: 1px
}

.stateGroup .alt-composit {
  fill: #e0e0e0;
  border-bottom: 1px
}

.state-note {
  stroke: ${options2.noteBorderColor};
  fill: ${options2.noteBkgColor};

  text {
    fill: ${options2.noteTextColor};
    stroke: none;
    font-size: 10px;
  }
}

.stateLabel .box {
  stroke: none;
  stroke-width: 0;
  fill: ${options2.mainBkg};
  opacity: 0.5;
}

.edgeLabel .label rect {
  fill: ${options2.labelBackgroundColor};
  opacity: 0.5;
}
.edgeLabel .label text {
  fill: ${options2.transitionLabelColor || options2.tertiaryTextColor};
}
.label div .edgeLabel {
  color: ${options2.transitionLabelColor || options2.tertiaryTextColor};
}

.stateLabel text {
  fill: ${options2.stateLabelColor};
  font-size: 10px;
  font-weight: bold;
}

.node circle.state-start {
  fill: ${options2.specialStateColor};
  stroke: ${options2.specialStateColor};
}

.node .fork-join {
  fill: ${options2.specialStateColor};
  stroke: ${options2.specialStateColor};
}

.node circle.state-end {
  fill: ${options2.innerEndBackground};
  stroke: ${options2.background};
  stroke-width: 1.5
}
.end-state-inner {
  fill: ${options2.compositeBackground || options2.background};
  // stroke: ${options2.background};
  stroke-width: 1.5
}

.node rect {
  fill: ${options2.stateBkg || options2.mainBkg};
  stroke: ${options2.stateBorder || options2.nodeBorder};
  stroke-width: 1px;
}
.node polygon {
  fill: ${options2.mainBkg};
  stroke: ${options2.stateBorder || options2.nodeBorder};;
  stroke-width: 1px;
}
#statediagram-barbEnd {
  fill: ${options2.lineColor};
}

.statediagram-cluster rect {
  fill: ${options2.compositeTitleBackground};
  stroke: ${options2.stateBorder || options2.nodeBorder};
  stroke-width: 1px;
}

.cluster-label, .nodeLabel {
  color: ${options2.stateLabelColor};
}

.statediagram-cluster rect.outer {
  rx: 5px;
  ry: 5px;
}
.statediagram-state .divider {
  stroke: ${options2.stateBorder || options2.nodeBorder};
}

.statediagram-state .title-state {
  rx: 5px;
  ry: 5px;
}
.statediagram-cluster.statediagram-cluster .inner {
  fill: ${options2.compositeBackground || options2.background};
}
.statediagram-cluster.statediagram-cluster-alt .inner {
  fill: ${options2.altBackground ? options2.altBackground : "#efefef"};
}

.statediagram-cluster .inner {
  rx:0;
  ry:0;
}

.statediagram-state rect.basic {
  rx: 5px;
  ry: 5px;
}
.statediagram-state rect.divider {
  stroke-dasharray: 10,10;
  fill: ${options2.altBackground ? options2.altBackground : "#efefef"};
}

.note-edge {
  stroke-dasharray: 5;
}

.statediagram-note rect {
  fill: ${options2.noteBkgColor};
  stroke: ${options2.noteBorderColor};
  stroke-width: 1px;
  rx: 0;
  ry: 0;
}
.statediagram-note rect {
  fill: ${options2.noteBkgColor};
  stroke: ${options2.noteBorderColor};
  stroke-width: 1px;
  rx: 0;
  ry: 0;
}

.statediagram-note text {
  fill: ${options2.noteTextColor};
}

.statediagram-note .nodeLabel {
  color: ${options2.noteTextColor};
}
.statediagram .edgeLabel {
  color: red; // ${options2.noteTextColor};
}

#dependencyStart, #dependencyEnd {
  fill: ${options2.lineColor};
  stroke: ${options2.lineColor};
  stroke-width: 1;
}

.statediagramTitleText {
  text-anchor: middle;
  font-size: 18px;
  fill: ${options2.textColor};
}
`;
  const stateStyles = getStyles$8;
  const getStyles$7 = (options2) => `.label {
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
    color: ${options2.textColor};
  }
  .mouth {
    stroke: #666;
  }

  line {
    stroke: ${options2.textColor}
  }

  .legend {
    fill: ${options2.textColor};
  }

  .label text {
    fill: #333;
  }
  .label {
    color: ${options2.textColor}
  }

  .face {
    ${options2.faceColor ? `fill: ${options2.faceColor}` : "fill: #FFF8DC"};
    stroke: #999;
  }

  .node rect,
  .node circle,
  .node ellipse,
  .node polygon,
  .node path {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
    stroke-width: 1px;
  }

  .node .label {
    text-align: center;
  }
  .node.clickable {
    cursor: pointer;
  }

  .arrowheadPath {
    fill: ${options2.arrowheadColor};
  }

  .edgePath .path {
    stroke: ${options2.lineColor};
    stroke-width: 1.5px;
  }

  .flowchart-link {
    stroke: ${options2.lineColor};
    fill: none;
  }

  .edgeLabel {
    background-color: ${options2.edgeLabelBackground};
    rect {
      opacity: 0.5;
    }
    text-align: center;
  }

  .cluster rect {
  }

  .cluster text {
    fill: ${options2.titleColor};
  }

  div.mermaidTooltip {
    position: absolute;
    text-align: center;
    max-width: 200px;
    padding: 2px;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
    font-size: 12px;
    background: ${options2.tertiaryColor};
    border: 1px solid ${options2.border2};
    border-radius: 2px;
    pointer-events: none;
    z-index: 100;
  }

  .task-type-0, .section-type-0  {
    ${options2.fillType0 ? `fill: ${options2.fillType0}` : ""};
  }
  .task-type-1, .section-type-1  {
    ${options2.fillType0 ? `fill: ${options2.fillType1}` : ""};
  }
  .task-type-2, .section-type-2  {
    ${options2.fillType0 ? `fill: ${options2.fillType2}` : ""};
  }
  .task-type-3, .section-type-3  {
    ${options2.fillType0 ? `fill: ${options2.fillType3}` : ""};
  }
  .task-type-4, .section-type-4  {
    ${options2.fillType0 ? `fill: ${options2.fillType4}` : ""};
  }
  .task-type-5, .section-type-5  {
    ${options2.fillType0 ? `fill: ${options2.fillType5}` : ""};
  }
  .task-type-6, .section-type-6  {
    ${options2.fillType0 ? `fill: ${options2.fillType6}` : ""};
  }
  .task-type-7, .section-type-7  {
    ${options2.fillType0 ? `fill: ${options2.fillType7}` : ""};
  }

  .actor-0 {
    ${options2.actor0 ? `fill: ${options2.actor0}` : ""};
  }
  .actor-1 {
    ${options2.actor1 ? `fill: ${options2.actor1}` : ""};
  }
  .actor-2 {
    ${options2.actor2 ? `fill: ${options2.actor2}` : ""};
  }
  .actor-3 {
    ${options2.actor3 ? `fill: ${options2.actor3}` : ""};
  }
  .actor-4 {
    ${options2.actor4 ? `fill: ${options2.actor4}` : ""};
  }
  .actor-5 {
    ${options2.actor5 ? `fill: ${options2.actor5}` : ""};
  }
`;
  const journeyStyles = getStyles$7;
  const getStyles$6 = (options2) => `.person {
    stroke: ${options2.personBorder};
    fill: ${options2.personBkg};
  }
`;
  const c4Styles = getStyles$6;
  const themes = {
    flowchart: flowStyles,
    "flowchart-v2": flowStyles,
    sequence: sequenceStyles,
    gantt: ganttStyles,
    classDiagram: classStyles,
    "classDiagram-v2": classStyles,
    class: classStyles,
    stateDiagram: stateStyles,
    state: stateStyles,
    info: infoStyles,
    pie: pieStyles,
    er: erStyles,
    error: errorStyles,
    journey: journeyStyles,
    requirement: requirementStyles,
    c4: c4Styles
  };
  const getStyles$4 = (type2, userStyles, options2) => {
    let diagramStyles = "";
    if (type2 in themes && themes[type2]) {
      diagramStyles = themes[type2](options2);
    } else {
      log$1.warn(`No theme found for ${type2}`);
    }
    return ` & {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
    fill: ${options2.textColor}
  }

  /* Classes common for multiple diagrams */

  & .error-icon {
    fill: ${options2.errorBkgColor};
  }
  & .error-text {
    fill: ${options2.errorTextColor};
    stroke: ${options2.errorTextColor};
  }

  & .edge-thickness-normal {
    stroke-width: 2px;
  }
  & .edge-thickness-thick {
    stroke-width: 3.5px
  }
  & .edge-pattern-solid {
    stroke-dasharray: 0;
  }

  & .edge-pattern-dashed{
    stroke-dasharray: 3;
  }
  .edge-pattern-dotted {
    stroke-dasharray: 2;
  }

  & .marker {
    fill: ${options2.lineColor};
    stroke: ${options2.lineColor};
  }
  & .marker.cross {
    stroke: ${options2.lineColor};
  }

  & svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  ${diagramStyles}

  ${userStyles}
`;
  };
  const addStylesForDiagram = (type2, diagramTheme) => {
    themes[type2] = diagramTheme;
  };
  const getStyles$5 = getStyles$4;
  let title$1 = "";
  let diagramTitle = "";
  let description = "";
  const sanitizeText$5 = (txt) => sanitizeText$6(txt, getConfig$1());
  const clear$i = function() {
    title$1 = "";
    description = "";
    diagramTitle = "";
  };
  const setAccTitle = function(txt) {
    title$1 = sanitizeText$5(txt).replace(/^\s+/g, "");
  };
  const getAccTitle = function() {
    return title$1 || diagramTitle;
  };
  const setAccDescription = function(txt) {
    description = sanitizeText$5(txt).replace(/\n\s+/g, "\n");
  };
  const getAccDescription = function() {
    return description;
  };
  const setDiagramTitle = function(txt) {
    diagramTitle = sanitizeText$5(txt);
  };
  const getDiagramTitle = function() {
    return diagramTitle;
  };
  const commonDb = {
    setAccTitle,
    getAccTitle,
    setDiagramTitle,
    getDiagramTitle,
    getAccDescription,
    setAccDescription,
    clear: clear$i
  };
  const commonDb$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    clear: clear$i,
    setAccTitle,
    getAccTitle,
    setAccDescription,
    getAccDescription,
    setDiagramTitle,
    getDiagramTitle,
    default: commonDb
  }, Symbol.toStringTag, { value: "Module" }));
  let currentDirective = {};
  const parseDirective$d = function(p2, statement, context, type2) {
    log$1.debug("parseDirective is being called", statement, context, type2);
    try {
      if (statement !== void 0) {
        statement = statement.trim();
        switch (context) {
          case "open_directive":
            currentDirective = {};
            break;
          case "type_directive":
            if (!currentDirective) {
              throw new Error("currentDirective is undefined");
            }
            currentDirective.type = statement.toLowerCase();
            break;
          case "arg_directive":
            if (!currentDirective) {
              throw new Error("currentDirective is undefined");
            }
            currentDirective.args = JSON.parse(statement);
            break;
          case "close_directive":
            handleDirective(p2, currentDirective, type2);
            currentDirective = void 0;
            break;
        }
      }
    } catch (error2) {
      log$1.error(
        `Error while rendering sequenceDiagram directive: ${statement} jison context: ${context}`
      );
      log$1.error(error2.message);
    }
  };
  const handleDirective = function(p2, directive2, type2) {
    log$1.info(`Directive type=${directive2.type} with args:`, directive2.args);
    switch (directive2.type) {
      case "init":
      case "initialize": {
        ["config"].forEach((prop) => {
          if (directive2.args[prop] !== void 0) {
            if (type2 === "flowchart-v2") {
              type2 = "flowchart";
            }
            directive2.args[type2] = directive2.args[prop];
            delete directive2.args[prop];
          }
        });
        log$1.info("sanitize in handleDirective", directive2.args);
        directiveSanitizer(directive2.args);
        log$1.info("sanitize in handleDirective (done)", directive2.args);
        addDirective(directive2.args);
        break;
      }
      case "wrap":
      case "nowrap":
        if (p2 && p2["setWrap"]) {
          p2.setWrap(directive2.type === "wrap");
        }
        break;
      case "themeCss":
        log$1.warn("themeCss encountered");
        break;
      default:
        log$1.warn(
          `Unhandled directive: source: '%%{${directive2.type}: ${JSON.stringify(
            directive2.args ? directive2.args : {}
          )}}%%`,
          directive2
        );
        break;
    }
  };
  const log = log$1;
  const setLogLevel = setLogLevel$1;
  const getConfig = getConfig$1;
  const sanitizeText$4 = (text2) => sanitizeText$6(text2, getConfig());
  const setupGraphViewbox = setupGraphViewbox$1;
  const getCommonDb$1 = () => {
    return commonDb$1;
  };
  const parseDirective$c = (p2, statement, context, type2) => parseDirective$d(p2, statement, context, type2);
  const diagrams = {};
  const registerDiagram = (id2, diagram2, detector2) => {
    if (diagrams[id2]) {
      throw new Error(`Diagram ${id2} already registered.`);
    }
    diagrams[id2] = diagram2;
    if (detector2) {
      addDetector(id2, detector2);
    }
    addStylesForDiagram(id2, diagram2.styles);
    if (diagram2.injectUtils) {
      diagram2.injectUtils(
        log,
        setLogLevel,
        getConfig,
        sanitizeText$4,
        setupGraphViewbox,
        getCommonDb$1(),
        parseDirective$c
      );
    }
  };
  const getDiagram = (name2) => {
    if (name2 in diagrams) {
      return diagrams[name2];
    }
    throw new Error(`Diagram ${name2} not found.`);
  };
  var parser$f = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 4], $V1 = [1, 7], $V2 = [1, 5], $V3 = [1, 9], $V4 = [1, 6], $V5 = [2, 6], $V6 = [1, 16], $V7 = [6, 8, 14, 20, 22, 24, 25, 27, 29, 32, 37, 40, 50, 55], $V8 = [8, 14, 20, 22, 24, 25, 27, 29, 32, 37, 40], $V9 = [8, 13, 14, 20, 22, 24, 25, 27, 29, 32, 37, 40], $Va = [1, 26], $Vb = [6, 8, 14, 50, 55], $Vc = [8, 14, 55], $Vd = [1, 53], $Ve = [1, 52], $Vf = [8, 14, 30, 33, 35, 38, 55], $Vg = [1, 67], $Vh = [1, 68], $Vi = [1, 69], $Vj = [8, 14, 33, 35, 42, 55];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "eol": 4, "directive": 5, "GG": 6, "document": 7, "EOF": 8, ":": 9, "DIR": 10, "options": 11, "body": 12, "OPT": 13, "NL": 14, "line": 15, "statement": 16, "commitStatement": 17, "mergeStatement": 18, "cherryPickStatement": 19, "acc_title": 20, "acc_title_value": 21, "acc_descr": 22, "acc_descr_value": 23, "acc_descr_multiline_value": 24, "section": 25, "branchStatement": 26, "CHECKOUT": 27, "ref": 28, "BRANCH": 29, "ORDER": 30, "NUM": 31, "CHERRY_PICK": 32, "COMMIT_ID": 33, "STR": 34, "COMMIT_TAG": 35, "EMPTYSTR": 36, "MERGE": 37, "COMMIT_TYPE": 38, "commitType": 39, "COMMIT": 40, "commit_arg": 41, "COMMIT_MSG": 42, "NORMAL": 43, "REVERSE": 44, "HIGHLIGHT": 45, "openDirective": 46, "typeDirective": 47, "closeDirective": 48, "argDirective": 49, "open_directive": 50, "type_directive": 51, "arg_directive": 52, "close_directive": 53, "ID": 54, ";": 55, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 6: "GG", 8: "EOF", 9: ":", 10: "DIR", 13: "OPT", 14: "NL", 20: "acc_title", 21: "acc_title_value", 22: "acc_descr", 23: "acc_descr_value", 24: "acc_descr_multiline_value", 25: "section", 27: "CHECKOUT", 29: "BRANCH", 30: "ORDER", 31: "NUM", 32: "CHERRY_PICK", 33: "COMMIT_ID", 34: "STR", 35: "COMMIT_TAG", 36: "EMPTYSTR", 37: "MERGE", 38: "COMMIT_TYPE", 40: "COMMIT", 42: "COMMIT_MSG", 43: "NORMAL", 44: "REVERSE", 45: "HIGHLIGHT", 50: "open_directive", 51: "type_directive", 52: "arg_directive", 53: "close_directive", 54: "ID", 55: ";" },
      productions_: [0, [3, 2], [3, 2], [3, 3], [3, 4], [3, 5], [7, 0], [7, 2], [11, 2], [11, 1], [12, 0], [12, 2], [15, 2], [15, 1], [16, 1], [16, 1], [16, 1], [16, 2], [16, 2], [16, 1], [16, 1], [16, 1], [16, 2], [26, 2], [26, 4], [19, 3], [19, 5], [19, 5], [19, 5], [19, 5], [18, 2], [18, 4], [18, 4], [18, 4], [18, 6], [18, 6], [18, 6], [18, 6], [18, 6], [18, 6], [18, 8], [18, 8], [18, 8], [18, 8], [18, 8], [18, 8], [17, 2], [17, 3], [17, 3], [17, 5], [17, 5], [17, 3], [17, 5], [17, 5], [17, 5], [17, 5], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 3], [17, 5], [17, 5], [17, 5], [17, 5], [17, 5], [17, 5], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [41, 0], [41, 1], [39, 1], [39, 1], [39, 1], [5, 3], [5, 5], [46, 1], [47, 1], [49, 1], [48, 1], [28, 1], [28, 1], [4, 1], [4, 1], [4, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 3:
            return $$[$0];
          case 4:
            return $$[$0 - 1];
          case 5:
            yy.setDirection($$[$0 - 3]);
            return $$[$0 - 1];
          case 7:
            yy.setOptions($$[$0 - 1]);
            this.$ = $$[$0];
            break;
          case 8:
            $$[$0 - 1] += $$[$0];
            this.$ = $$[$0 - 1];
            break;
          case 10:
            this.$ = [];
            break;
          case 11:
            $$[$0 - 1].push($$[$0]);
            this.$ = $$[$0 - 1];
            break;
          case 12:
            this.$ = $$[$0 - 1];
            break;
          case 17:
            this.$ = $$[$0].trim();
            yy.setAccTitle(this.$);
            break;
          case 18:
          case 19:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 20:
            yy.addSection($$[$0].substr(8));
            this.$ = $$[$0].substr(8);
            break;
          case 22:
            yy.checkout($$[$0]);
            break;
          case 23:
            yy.branch($$[$0]);
            break;
          case 24:
            yy.branch($$[$0 - 2], $$[$0]);
            break;
          case 25:
            yy.cherryPick($$[$0], "", void 0);
            break;
          case 26:
            yy.cherryPick($$[$0 - 2], "", $$[$0]);
            break;
          case 27:
          case 29:
            yy.cherryPick($$[$0 - 2], "", "");
            break;
          case 28:
            yy.cherryPick($$[$0], "", $$[$0 - 2]);
            break;
          case 30:
            yy.merge($$[$0], "", "", "");
            break;
          case 31:
            yy.merge($$[$0 - 2], $$[$0], "", "");
            break;
          case 32:
            yy.merge($$[$0 - 2], "", $$[$0], "");
            break;
          case 33:
            yy.merge($$[$0 - 2], "", "", $$[$0]);
            break;
          case 34:
            yy.merge($$[$0 - 4], $$[$0], "", $$[$0 - 2]);
            break;
          case 35:
            yy.merge($$[$0 - 4], "", $$[$0], $$[$0 - 2]);
            break;
          case 36:
            yy.merge($$[$0 - 4], "", $$[$0 - 2], $$[$0]);
            break;
          case 37:
            yy.merge($$[$0 - 4], $$[$0 - 2], $$[$0], "");
            break;
          case 38:
            yy.merge($$[$0 - 4], $$[$0 - 2], "", $$[$0]);
            break;
          case 39:
            yy.merge($$[$0 - 4], $$[$0], $$[$0 - 2], "");
            break;
          case 40:
            yy.merge($$[$0 - 6], $$[$0 - 4], $$[$0 - 2], $$[$0]);
            break;
          case 41:
            yy.merge($$[$0 - 6], $$[$0], $$[$0 - 4], $$[$0 - 2]);
            break;
          case 42:
            yy.merge($$[$0 - 6], $$[$0 - 4], $$[$0], $$[$0 - 2]);
            break;
          case 43:
            yy.merge($$[$0 - 6], $$[$0 - 2], $$[$0 - 4], $$[$0]);
            break;
          case 44:
            yy.merge($$[$0 - 6], $$[$0], $$[$0 - 2], $$[$0 - 4]);
            break;
          case 45:
            yy.merge($$[$0 - 6], $$[$0 - 2], $$[$0], $$[$0 - 4]);
            break;
          case 46:
            yy.commit($$[$0]);
            break;
          case 47:
            yy.commit("", "", yy.commitType.NORMAL, $$[$0]);
            break;
          case 48:
            yy.commit("", "", $$[$0], "");
            break;
          case 49:
            yy.commit("", "", $$[$0], $$[$0 - 2]);
            break;
          case 50:
            yy.commit("", "", $$[$0 - 2], $$[$0]);
            break;
          case 51:
            yy.commit("", $$[$0], yy.commitType.NORMAL, "");
            break;
          case 52:
            yy.commit("", $$[$0 - 2], yy.commitType.NORMAL, $$[$0]);
            break;
          case 53:
            yy.commit("", $$[$0], yy.commitType.NORMAL, $$[$0 - 2]);
            break;
          case 54:
            yy.commit("", $$[$0 - 2], $$[$0], "");
            break;
          case 55:
            yy.commit("", $$[$0], $$[$0 - 2], "");
            break;
          case 56:
            yy.commit("", $$[$0 - 4], $$[$0 - 2], $$[$0]);
            break;
          case 57:
            yy.commit("", $$[$0 - 4], $$[$0], $$[$0 - 2]);
            break;
          case 58:
            yy.commit("", $$[$0 - 2], $$[$0 - 4], $$[$0]);
            break;
          case 59:
            yy.commit("", $$[$0], $$[$0 - 4], $$[$0 - 2]);
            break;
          case 60:
            yy.commit("", $$[$0], $$[$0 - 2], $$[$0 - 4]);
            break;
          case 61:
            yy.commit("", $$[$0 - 2], $$[$0], $$[$0 - 4]);
            break;
          case 62:
            yy.commit($$[$0], "", yy.commitType.NORMAL, "");
            break;
          case 63:
            yy.commit($$[$0], "", yy.commitType.NORMAL, $$[$0 - 2]);
            break;
          case 64:
            yy.commit($$[$0 - 2], "", yy.commitType.NORMAL, $$[$0]);
            break;
          case 65:
            yy.commit($$[$0 - 2], "", $$[$0], "");
            break;
          case 66:
            yy.commit($$[$0], "", $$[$0 - 2], "");
            break;
          case 67:
            yy.commit($$[$0], $$[$0 - 2], yy.commitType.NORMAL, "");
            break;
          case 68:
            yy.commit($$[$0 - 2], $$[$0], yy.commitType.NORMAL, "");
            break;
          case 69:
            yy.commit($$[$0 - 4], "", $$[$0 - 2], $$[$0]);
            break;
          case 70:
            yy.commit($$[$0 - 4], "", $$[$0], $$[$0 - 2]);
            break;
          case 71:
            yy.commit($$[$0 - 2], "", $$[$0 - 4], $$[$0]);
            break;
          case 72:
            yy.commit($$[$0], "", $$[$0 - 4], $$[$0 - 2]);
            break;
          case 73:
            yy.commit($$[$0], "", $$[$0 - 2], $$[$0 - 4]);
            break;
          case 74:
            yy.commit($$[$0 - 2], "", $$[$0], $$[$0 - 4]);
            break;
          case 75:
            yy.commit($$[$0 - 4], $$[$0], $$[$0 - 2], "");
            break;
          case 76:
            yy.commit($$[$0 - 4], $$[$0 - 2], $$[$0], "");
            break;
          case 77:
            yy.commit($$[$0 - 2], $$[$0], $$[$0 - 4], "");
            break;
          case 78:
            yy.commit($$[$0], $$[$0 - 2], $$[$0 - 4], "");
            break;
          case 79:
            yy.commit($$[$0], $$[$0 - 4], $$[$0 - 2], "");
            break;
          case 80:
            yy.commit($$[$0 - 2], $$[$0 - 4], $$[$0], "");
            break;
          case 81:
            yy.commit($$[$0 - 4], $$[$0], yy.commitType.NORMAL, $$[$0 - 2]);
            break;
          case 82:
            yy.commit($$[$0 - 4], $$[$0 - 2], yy.commitType.NORMAL, $$[$0]);
            break;
          case 83:
            yy.commit($$[$0 - 2], $$[$0], yy.commitType.NORMAL, $$[$0 - 4]);
            break;
          case 84:
            yy.commit($$[$0], $$[$0 - 2], yy.commitType.NORMAL, $$[$0 - 4]);
            break;
          case 85:
            yy.commit($$[$0], $$[$0 - 4], yy.commitType.NORMAL, $$[$0 - 2]);
            break;
          case 86:
            yy.commit($$[$0 - 2], $$[$0 - 4], yy.commitType.NORMAL, $$[$0]);
            break;
          case 87:
            yy.commit($$[$0 - 6], $$[$0 - 4], $$[$0 - 2], $$[$0]);
            break;
          case 88:
            yy.commit($$[$0 - 6], $$[$0 - 4], $$[$0], $$[$0 - 2]);
            break;
          case 89:
            yy.commit($$[$0 - 6], $$[$0 - 2], $$[$0 - 4], $$[$0]);
            break;
          case 90:
            yy.commit($$[$0 - 6], $$[$0], $$[$0 - 4], $$[$0 - 2]);
            break;
          case 91:
            yy.commit($$[$0 - 6], $$[$0 - 2], $$[$0], $$[$0 - 4]);
            break;
          case 92:
            yy.commit($$[$0 - 6], $$[$0], $$[$0 - 2], $$[$0 - 4]);
            break;
          case 93:
            yy.commit($$[$0 - 4], $$[$0 - 6], $$[$0 - 2], $$[$0]);
            break;
          case 94:
            yy.commit($$[$0 - 4], $$[$0 - 6], $$[$0], $$[$0 - 2]);
            break;
          case 95:
            yy.commit($$[$0 - 2], $$[$0 - 6], $$[$0 - 4], $$[$0]);
            break;
          case 96:
            yy.commit($$[$0], $$[$0 - 6], $$[$0 - 4], $$[$0 - 2]);
            break;
          case 97:
            yy.commit($$[$0 - 2], $$[$0 - 6], $$[$0], $$[$0 - 4]);
            break;
          case 98:
            yy.commit($$[$0], $$[$0 - 6], $$[$0 - 2], $$[$0 - 4]);
            break;
          case 99:
            yy.commit($$[$0], $$[$0 - 4], $$[$0 - 2], $$[$0 - 6]);
            break;
          case 100:
            yy.commit($$[$0 - 2], $$[$0 - 4], $$[$0], $$[$0 - 6]);
            break;
          case 101:
            yy.commit($$[$0], $$[$0 - 2], $$[$0 - 4], $$[$0 - 6]);
            break;
          case 102:
            yy.commit($$[$0 - 2], $$[$0], $$[$0 - 4], $$[$0 - 6]);
            break;
          case 103:
            yy.commit($$[$0 - 4], $$[$0 - 2], $$[$0], $$[$0 - 6]);
            break;
          case 104:
            yy.commit($$[$0 - 4], $$[$0], $$[$0 - 2], $$[$0 - 6]);
            break;
          case 105:
            yy.commit($$[$0 - 2], $$[$0 - 4], $$[$0 - 6], $$[$0]);
            break;
          case 106:
            yy.commit($$[$0], $$[$0 - 4], $$[$0 - 6], $$[$0 - 2]);
            break;
          case 107:
            yy.commit($$[$0 - 2], $$[$0], $$[$0 - 6], $$[$0 - 4]);
            break;
          case 108:
            yy.commit($$[$0], $$[$0 - 2], $$[$0 - 6], $$[$0 - 4]);
            break;
          case 109:
            yy.commit($$[$0 - 4], $$[$0 - 2], $$[$0 - 6], $$[$0]);
            break;
          case 110:
            yy.commit($$[$0 - 4], $$[$0], $$[$0 - 6], $$[$0 - 2]);
            break;
          case 111:
            this.$ = "";
            break;
          case 112:
            this.$ = $$[$0];
            break;
          case 113:
            this.$ = yy.commitType.NORMAL;
            break;
          case 114:
            this.$ = yy.commitType.REVERSE;
            break;
          case 115:
            this.$ = yy.commitType.HIGHLIGHT;
            break;
          case 118:
            yy.parseDirective("%%{", "open_directive");
            break;
          case 119:
            yy.parseDirective($$[$0], "type_directive");
            break;
          case 120:
            $$[$0] = $$[$0].trim().replace(/'/g, '"');
            yy.parseDirective($$[$0], "arg_directive");
            break;
          case 121:
            yy.parseDirective("}%%", "close_directive", "gitGraph");
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 5: 3, 6: $V0, 8: $V1, 14: $V2, 46: 8, 50: $V3, 55: $V4 }, { 1: [3] }, { 3: 10, 4: 2, 5: 3, 6: $V0, 8: $V1, 14: $V2, 46: 8, 50: $V3, 55: $V4 }, { 3: 11, 4: 2, 5: 3, 6: $V0, 8: $V1, 14: $V2, 46: 8, 50: $V3, 55: $V4 }, { 7: 12, 8: $V5, 9: [1, 13], 10: [1, 14], 11: 15, 14: $V6 }, o($V7, [2, 124]), o($V7, [2, 125]), o($V7, [2, 126]), { 47: 17, 51: [1, 18] }, { 51: [2, 118] }, { 1: [2, 1] }, { 1: [2, 2] }, { 8: [1, 19] }, { 7: 20, 8: $V5, 11: 15, 14: $V6 }, { 9: [1, 21] }, o($V8, [2, 10], { 12: 22, 13: [1, 23] }), o($V9, [2, 9]), { 9: [1, 25], 48: 24, 53: $Va }, o([9, 53], [2, 119]), { 1: [2, 3] }, { 8: [1, 27] }, { 7: 28, 8: $V5, 11: 15, 14: $V6 }, { 8: [2, 7], 14: [1, 31], 15: 29, 16: 30, 17: 32, 18: 33, 19: 34, 20: [1, 35], 22: [1, 36], 24: [1, 37], 25: [1, 38], 26: 39, 27: [1, 40], 29: [1, 44], 32: [1, 43], 37: [1, 42], 40: [1, 41] }, o($V9, [2, 8]), o($Vb, [2, 116]), { 49: 45, 52: [1, 46] }, o($Vb, [2, 121]), { 1: [2, 4] }, { 8: [1, 47] }, o($V8, [2, 11]), { 4: 48, 8: $V1, 14: $V2, 55: $V4 }, o($V8, [2, 13]), o($Vc, [2, 14]), o($Vc, [2, 15]), o($Vc, [2, 16]), { 21: [1, 49] }, { 23: [1, 50] }, o($Vc, [2, 19]), o($Vc, [2, 20]), o($Vc, [2, 21]), { 28: 51, 34: $Vd, 54: $Ve }, o($Vc, [2, 111], { 41: 54, 33: [1, 57], 34: [1, 59], 35: [1, 55], 38: [1, 56], 42: [1, 58] }), { 28: 60, 34: $Vd, 54: $Ve }, { 33: [1, 61], 35: [1, 62] }, { 28: 63, 34: $Vd, 54: $Ve }, { 48: 64, 53: $Va }, { 53: [2, 120] }, { 1: [2, 5] }, o($V8, [2, 12]), o($Vc, [2, 17]), o($Vc, [2, 18]), o($Vc, [2, 22]), o($Vf, [2, 122]), o($Vf, [2, 123]), o($Vc, [2, 46]), { 34: [1, 65] }, { 39: 66, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 70] }, { 34: [1, 71] }, o($Vc, [2, 112]), o($Vc, [2, 30], { 33: [1, 72], 35: [1, 74], 38: [1, 73] }), { 34: [1, 75] }, { 34: [1, 76], 36: [1, 77] }, o($Vc, [2, 23], { 30: [1, 78] }), o($Vb, [2, 117]), o($Vc, [2, 47], { 33: [1, 80], 38: [1, 79], 42: [1, 81] }), o($Vc, [2, 48], { 33: [1, 83], 35: [1, 82], 42: [1, 84] }), o($Vj, [2, 113]), o($Vj, [2, 114]), o($Vj, [2, 115]), o($Vc, [2, 51], { 35: [1, 85], 38: [1, 86], 42: [1, 87] }), o($Vc, [2, 62], { 33: [1, 90], 35: [1, 88], 38: [1, 89] }), { 34: [1, 91] }, { 39: 92, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 93] }, o($Vc, [2, 25], { 35: [1, 94] }), { 33: [1, 95] }, { 33: [1, 96] }, { 31: [1, 97] }, { 39: 98, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 99] }, { 34: [1, 100] }, { 34: [1, 101] }, { 34: [1, 102] }, { 34: [1, 103] }, { 34: [1, 104] }, { 39: 105, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 106] }, { 34: [1, 107] }, { 39: 108, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 109] }, o($Vc, [2, 31], { 35: [1, 111], 38: [1, 110] }), o($Vc, [2, 32], { 33: [1, 113], 35: [1, 112] }), o($Vc, [2, 33], { 33: [1, 114], 38: [1, 115] }), { 34: [1, 116], 36: [1, 117] }, { 34: [1, 118] }, { 34: [1, 119] }, o($Vc, [2, 24]), o($Vc, [2, 49], { 33: [1, 120], 42: [1, 121] }), o($Vc, [2, 53], { 38: [1, 122], 42: [1, 123] }), o($Vc, [2, 63], { 33: [1, 125], 38: [1, 124] }), o($Vc, [2, 50], { 33: [1, 126], 42: [1, 127] }), o($Vc, [2, 55], { 35: [1, 128], 42: [1, 129] }), o($Vc, [2, 66], { 33: [1, 131], 35: [1, 130] }), o($Vc, [2, 52], { 38: [1, 132], 42: [1, 133] }), o($Vc, [2, 54], { 35: [1, 134], 42: [1, 135] }), o($Vc, [2, 67], { 35: [1, 137], 38: [1, 136] }), o($Vc, [2, 64], { 33: [1, 139], 38: [1, 138] }), o($Vc, [2, 65], { 33: [1, 141], 35: [1, 140] }), o($Vc, [2, 68], { 35: [1, 143], 38: [1, 142] }), { 39: 144, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 145] }, { 34: [1, 146] }, { 34: [1, 147] }, { 34: [1, 148] }, { 39: 149, 43: $Vg, 44: $Vh, 45: $Vi }, o($Vc, [2, 26]), o($Vc, [2, 27]), o($Vc, [2, 28]), o($Vc, [2, 29]), { 34: [1, 150] }, { 34: [1, 151] }, { 39: 152, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 153] }, { 39: 154, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 155] }, { 34: [1, 156] }, { 34: [1, 157] }, { 34: [1, 158] }, { 34: [1, 159] }, { 34: [1, 160] }, { 34: [1, 161] }, { 39: 162, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 163] }, { 34: [1, 164] }, { 34: [1, 165] }, { 39: 166, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 167] }, { 39: 168, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 169] }, { 34: [1, 170] }, { 34: [1, 171] }, { 39: 172, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 173] }, o($Vc, [2, 37], { 35: [1, 174] }), o($Vc, [2, 38], { 38: [1, 175] }), o($Vc, [2, 36], { 33: [1, 176] }), o($Vc, [2, 39], { 35: [1, 177] }), o($Vc, [2, 34], { 38: [1, 178] }), o($Vc, [2, 35], { 33: [1, 179] }), o($Vc, [2, 60], { 42: [1, 180] }), o($Vc, [2, 73], { 33: [1, 181] }), o($Vc, [2, 61], { 42: [1, 182] }), o($Vc, [2, 84], { 38: [1, 183] }), o($Vc, [2, 74], { 33: [1, 184] }), o($Vc, [2, 83], { 38: [1, 185] }), o($Vc, [2, 59], { 42: [1, 186] }), o($Vc, [2, 72], { 33: [1, 187] }), o($Vc, [2, 58], { 42: [1, 188] }), o($Vc, [2, 78], { 35: [1, 189] }), o($Vc, [2, 71], { 33: [1, 190] }), o($Vc, [2, 77], { 35: [1, 191] }), o($Vc, [2, 57], { 42: [1, 192] }), o($Vc, [2, 85], { 38: [1, 193] }), o($Vc, [2, 56], { 42: [1, 194] }), o($Vc, [2, 79], { 35: [1, 195] }), o($Vc, [2, 80], { 35: [1, 196] }), o($Vc, [2, 86], { 38: [1, 197] }), o($Vc, [2, 70], { 33: [1, 198] }), o($Vc, [2, 81], { 38: [1, 199] }), o($Vc, [2, 69], { 33: [1, 200] }), o($Vc, [2, 75], { 35: [1, 201] }), o($Vc, [2, 76], { 35: [1, 202] }), o($Vc, [2, 82], { 38: [1, 203] }), { 34: [1, 204] }, { 39: 205, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 206] }, { 34: [1, 207] }, { 39: 208, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 209] }, { 34: [1, 210] }, { 34: [1, 211] }, { 34: [1, 212] }, { 39: 213, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 214] }, { 39: 215, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 216] }, { 34: [1, 217] }, { 34: [1, 218] }, { 34: [1, 219] }, { 34: [1, 220] }, { 34: [1, 221] }, { 34: [1, 222] }, { 39: 223, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 224] }, { 34: [1, 225] }, { 34: [1, 226] }, { 39: 227, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 228] }, { 39: 229, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 230] }, { 34: [1, 231] }, { 34: [1, 232] }, { 39: 233, 43: $Vg, 44: $Vh, 45: $Vi }, o($Vc, [2, 40]), o($Vc, [2, 42]), o($Vc, [2, 41]), o($Vc, [2, 43]), o($Vc, [2, 45]), o($Vc, [2, 44]), o($Vc, [2, 101]), o($Vc, [2, 102]), o($Vc, [2, 99]), o($Vc, [2, 100]), o($Vc, [2, 104]), o($Vc, [2, 103]), o($Vc, [2, 108]), o($Vc, [2, 107]), o($Vc, [2, 106]), o($Vc, [2, 105]), o($Vc, [2, 110]), o($Vc, [2, 109]), o($Vc, [2, 98]), o($Vc, [2, 97]), o($Vc, [2, 96]), o($Vc, [2, 95]), o($Vc, [2, 93]), o($Vc, [2, 94]), o($Vc, [2, 92]), o($Vc, [2, 91]), o($Vc, [2, 90]), o($Vc, [2, 89]), o($Vc, [2, 87]), o($Vc, [2, 88])],
      defaultActions: { 9: [2, 118], 10: [2, 1], 11: [2, 2], 19: [2, 3], 27: [2, 4], 46: [2, 120], 47: [2, 5] },
      parseError: function parseError2(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error2 = new Error(str2);
          error2.hash = hash;
          throw error2;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state, action, r, yyval = {}, p2, len, newState, expected;
        while (true) {
          state = stack[stack.length - 1];
          if (this.defaultActions[state]) {
            action = this.defaultActions[state];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state] && table[state][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p2 in table[state]) {
              if (this.terminals_[p2] && p2 > TERROR) {
                expected.push("'" + this.terminals_[p2] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError2(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        more: function() {
          this._more = true;
          return this;
        },
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        test_match: function(match5, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match5[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match5[0].length
          };
          this.yytext += match5[0];
          this.match += match5[0];
          this.matches = match5;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match5[0].length);
          this.matched += match5[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match5, tempMatch, index;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match5 || tempMatch[0].length > match5[0].length)) {
              match5 = tempMatch;
              index = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match5 = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match5) {
            token2 = this.test_match(match5, rules[index]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: { "case-insensitive": true },
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              this.begin("open_directive");
              return 50;
            case 1:
              this.begin("type_directive");
              return 51;
            case 2:
              this.popState();
              this.begin("arg_directive");
              return 9;
            case 3:
              this.popState();
              this.popState();
              return 53;
            case 4:
              return 52;
            case 5:
              this.begin("acc_title");
              return 20;
            case 6:
              this.popState();
              return "acc_title_value";
            case 7:
              this.begin("acc_descr");
              return 22;
            case 8:
              this.popState();
              return "acc_descr_value";
            case 9:
              this.begin("acc_descr_multiline");
              break;
            case 10:
              this.popState();
              break;
            case 11:
              return "acc_descr_multiline_value";
            case 12:
              return 14;
            case 13:
              break;
            case 14:
              break;
            case 15:
              return 6;
            case 16:
              return 40;
            case 17:
              return 33;
            case 18:
              return 38;
            case 19:
              return 42;
            case 20:
              return 43;
            case 21:
              return 44;
            case 22:
              return 45;
            case 23:
              return 35;
            case 24:
              return 29;
            case 25:
              return 30;
            case 26:
              return 37;
            case 27:
              return 32;
            case 28:
              return 27;
            case 29:
              return 10;
            case 30:
              return 10;
            case 31:
              return 9;
            case 32:
              return "CARET";
            case 33:
              this.begin("options");
              break;
            case 34:
              this.popState();
              break;
            case 35:
              return 13;
            case 36:
              return 36;
            case 37:
              this.begin("string");
              break;
            case 38:
              this.popState();
              break;
            case 39:
              return 34;
            case 40:
              return 31;
            case 41:
              return 54;
            case 42:
              return 8;
          }
        },
        rules: [/^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:(\r?\n)+)/i, /^(?:#[^\n]*)/i, /^(?:%[^\n]*)/i, /^(?:gitGraph\b)/i, /^(?:commit(?=\s|$))/i, /^(?:id:)/i, /^(?:type:)/i, /^(?:msg:)/i, /^(?:NORMAL\b)/i, /^(?:REVERSE\b)/i, /^(?:HIGHLIGHT\b)/i, /^(?:tag:)/i, /^(?:branch(?=\s|$))/i, /^(?:order:)/i, /^(?:merge(?=\s|$))/i, /^(?:cherry-pick(?=\s|$))/i, /^(?:checkout(?=\s|$))/i, /^(?:LR\b)/i, /^(?:BT\b)/i, /^(?::)/i, /^(?:\^)/i, /^(?:options\r?\n)/i, /^(?:[ \r\n\t]+end\b)/i, /^(?:[\s\S]+(?=[ \r\n\t]+end))/i, /^(?:["]["])/i, /^(?:["])/i, /^(?:["])/i, /^(?:[^"]*)/i, /^(?:[0-9]+(?=\s|$))/i, /^(?:\w([-\./\w]*[-\w])?)/i, /^(?:$)/i, /^(?:\s+)/i],
        conditions: { "acc_descr_multiline": { "rules": [10, 11], "inclusive": false }, "acc_descr": { "rules": [8], "inclusive": false }, "acc_title": { "rules": [6], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "options": { "rules": [34, 35], "inclusive": false }, "string": { "rules": [38, 39], "inclusive": false }, "INITIAL": { "rules": [0, 5, 7, 9, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 36, 37, 40, 41, 42, 43], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$f.parser = parser$f;
  const gitGraphParser = parser$f;
  const gitGraphDetector = (txt) => {
    return txt.match(/^\s*gitGraph/) !== null;
  };
  let mainBranchName = getConfig$1().gitGraph.mainBranchName;
  let mainBranchOrder = getConfig$1().gitGraph.mainBranchOrder;
  let commits = {};
  let head = null;
  let branchesConfig = {};
  branchesConfig[mainBranchName] = { name: mainBranchName, order: mainBranchOrder };
  let branches = {};
  branches[mainBranchName] = head;
  let curBranch = mainBranchName;
  let direction$3 = "LR";
  let seq = 0;
  function getId() {
    return random({ length: 7 });
  }
  const parseDirective$b = function(statement, context, type2) {
    mermaidAPI.parseDirective(this, statement, context, type2);
  };
  function uniqBy(list, fn2) {
    const recordMap = /* @__PURE__ */ Object.create(null);
    return list.reduce((out, item) => {
      const key = fn2(item);
      if (!recordMap[key]) {
        recordMap[key] = true;
        out.push(item);
      }
      return out;
    }, []);
  }
  const setDirection$3 = function(dir) {
    direction$3 = dir;
  };
  let options = {};
  const setOptions$4 = function(rawOptString) {
    log$1.debug("options str", rawOptString);
    rawOptString = rawOptString && rawOptString.trim();
    rawOptString = rawOptString || "{}";
    try {
      options = JSON.parse(rawOptString);
    } catch (e) {
      log$1.error("error while parsing gitGraph options", e.message);
    }
  };
  const getOptions = function() {
    return options;
  };
  const commit = function(msg, id2, type2, tag) {
    log$1.debug("Entering commit:", msg, id2, type2, tag);
    id2 = common$1.sanitizeText(id2, getConfig$1());
    msg = common$1.sanitizeText(msg, getConfig$1());
    tag = common$1.sanitizeText(tag, getConfig$1());
    const commit2 = {
      id: id2 ? id2 : seq + "-" + getId(),
      message: msg,
      seq: seq++,
      type: type2 ? type2 : commitType$1.NORMAL,
      tag: tag ? tag : "",
      parents: head == null ? [] : [head.id],
      branch: curBranch
    };
    head = commit2;
    commits[commit2.id] = commit2;
    branches[curBranch] = commit2.id;
    log$1.debug("in pushCommit " + commit2.id);
  };
  const branch = function(name2, order2) {
    name2 = common$1.sanitizeText(name2, getConfig$1());
    if (branches[name2] === void 0) {
      branches[name2] = head != null ? head.id : null;
      branchesConfig[name2] = { name: name2, order: order2 ? parseInt(order2, 10) : null };
      checkout(name2);
      log$1.debug("in createBranch");
    } else {
      let error2 = new Error(
        'Trying to create an existing branch. (Help: Either use a new name if you want create a new branch or try using "checkout ' + name2 + '")'
      );
      error2.hash = {
        text: "branch " + name2,
        token: "branch " + name2,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ['"checkout ' + name2 + '"']
      };
      throw error2;
    }
  };
  const merge$2 = function(otherBranch, custom_id, override_type, custom_tag) {
    otherBranch = common$1.sanitizeText(otherBranch, getConfig$1());
    custom_id = common$1.sanitizeText(custom_id, getConfig$1());
    const currentCommit = commits[branches[curBranch]];
    const otherCommit = commits[branches[otherBranch]];
    if (curBranch === otherBranch) {
      let error2 = new Error('Incorrect usage of "merge". Cannot merge a branch to itself');
      error2.hash = {
        text: "merge " + otherBranch,
        token: "merge " + otherBranch,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["branch abc"]
      };
      throw error2;
    } else if (currentCommit === void 0 || !currentCommit) {
      let error2 = new Error(
        'Incorrect usage of "merge". Current branch (' + curBranch + ")has no commits"
      );
      error2.hash = {
        text: "merge " + otherBranch,
        token: "merge " + otherBranch,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["commit"]
      };
      throw error2;
    } else if (branches[otherBranch] === void 0) {
      let error2 = new Error(
        'Incorrect usage of "merge". Branch to be merged (' + otherBranch + ") does not exist"
      );
      error2.hash = {
        text: "merge " + otherBranch,
        token: "merge " + otherBranch,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["branch " + otherBranch]
      };
      throw error2;
    } else if (otherCommit === void 0 || !otherCommit) {
      let error2 = new Error(
        'Incorrect usage of "merge". Branch to be merged (' + otherBranch + ") has no commits"
      );
      error2.hash = {
        text: "merge " + otherBranch,
        token: "merge " + otherBranch,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ['"commit"']
      };
      throw error2;
    } else if (currentCommit === otherCommit) {
      let error2 = new Error('Incorrect usage of "merge". Both branches have same head');
      error2.hash = {
        text: "merge " + otherBranch,
        token: "merge " + otherBranch,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["branch abc"]
      };
      throw error2;
    } else if (custom_id && commits[custom_id] !== void 0) {
      let error2 = new Error(
        'Incorrect usage of "merge". Commit with id:' + custom_id + " already exists, use different custom Id"
      );
      error2.hash = {
        text: "merge " + otherBranch + custom_id + override_type + custom_tag,
        token: "merge " + otherBranch + custom_id + override_type + custom_tag,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: [
          "merge " + otherBranch + " " + custom_id + "_UNIQUE " + override_type + " " + custom_tag
        ]
      };
      throw error2;
    }
    const commit2 = {
      id: custom_id ? custom_id : seq + "-" + getId(),
      message: "merged branch " + otherBranch + " into " + curBranch,
      seq: seq++,
      parents: [head == null ? null : head.id, branches[otherBranch]],
      branch: curBranch,
      type: commitType$1.MERGE,
      customType: override_type,
      customId: custom_id ? true : false,
      tag: custom_tag ? custom_tag : ""
    };
    head = commit2;
    commits[commit2.id] = commit2;
    branches[curBranch] = commit2.id;
    log$1.debug(branches);
    log$1.debug("in mergeBranch");
  };
  const cherryPick = function(sourceId, targetId, tag) {
    log$1.debug("Entering cherryPick:", sourceId, targetId, tag);
    sourceId = common$1.sanitizeText(sourceId, getConfig$1());
    targetId = common$1.sanitizeText(targetId, getConfig$1());
    tag = common$1.sanitizeText(tag, getConfig$1());
    if (!sourceId || commits[sourceId] === void 0) {
      let error2 = new Error(
        'Incorrect usage of "cherryPick". Source commit id should exist and provided'
      );
      error2.hash = {
        text: "cherryPick " + sourceId + " " + targetId,
        token: "cherryPick " + sourceId + " " + targetId,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["cherry-pick abc"]
      };
      throw error2;
    }
    let sourceCommit = commits[sourceId];
    let sourceCommitBranch = sourceCommit.branch;
    if (sourceCommit.type === commitType$1.MERGE) {
      let error2 = new Error(
        'Incorrect usage of "cherryPick". Source commit should not be a merge commit'
      );
      error2.hash = {
        text: "cherryPick " + sourceId + " " + targetId,
        token: "cherryPick " + sourceId + " " + targetId,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["cherry-pick abc"]
      };
      throw error2;
    }
    if (!targetId || commits[targetId] === void 0) {
      if (sourceCommitBranch === curBranch) {
        let error2 = new Error(
          'Incorrect usage of "cherryPick". Source commit is already on current branch'
        );
        error2.hash = {
          text: "cherryPick " + sourceId + " " + targetId,
          token: "cherryPick " + sourceId + " " + targetId,
          line: "1",
          loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
          expected: ["cherry-pick abc"]
        };
        throw error2;
      }
      const currentCommit = commits[branches[curBranch]];
      if (currentCommit === void 0 || !currentCommit) {
        let error2 = new Error(
          'Incorrect usage of "cherry-pick". Current branch (' + curBranch + ")has no commits"
        );
        error2.hash = {
          text: "cherryPick " + sourceId + " " + targetId,
          token: "cherryPick " + sourceId + " " + targetId,
          line: "1",
          loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
          expected: ["cherry-pick abc"]
        };
        throw error2;
      }
      const commit2 = {
        id: seq + "-" + getId(),
        message: "cherry-picked " + sourceCommit + " into " + curBranch,
        seq: seq++,
        parents: [head == null ? null : head.id, sourceCommit.id],
        branch: curBranch,
        type: commitType$1.CHERRY_PICK,
        tag: tag != null ? tag : "cherry-pick:" + sourceCommit.id
      };
      head = commit2;
      commits[commit2.id] = commit2;
      branches[curBranch] = commit2.id;
      log$1.debug(branches);
      log$1.debug("in cherryPick");
    }
  };
  const checkout = function(branch2) {
    branch2 = common$1.sanitizeText(branch2, getConfig$1());
    if (branches[branch2] === void 0) {
      let error2 = new Error(
        'Trying to checkout branch which is not yet created. (Help try using "branch ' + branch2 + '")'
      );
      error2.hash = {
        text: "checkout " + branch2,
        token: "checkout " + branch2,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ['"branch ' + branch2 + '"']
      };
      throw error2;
    } else {
      curBranch = branch2;
      const id2 = branches[curBranch];
      head = commits[id2];
    }
  };
  function upsert(arr, key, newVal) {
    const index = arr.indexOf(key);
    if (index === -1) {
      arr.push(newVal);
    } else {
      arr.splice(index, 1, newVal);
    }
  }
  function prettyPrintCommitHistory(commitArr) {
    const commit2 = commitArr.reduce((out, commit3) => {
      if (out.seq > commit3.seq) {
        return out;
      }
      return commit3;
    }, commitArr[0]);
    let line2 = "";
    commitArr.forEach(function(c2) {
      if (c2 === commit2) {
        line2 += "	*";
      } else {
        line2 += "	|";
      }
    });
    const label = [line2, commit2.id, commit2.seq];
    for (let branch2 in branches) {
      if (branches[branch2] === commit2.id) {
        label.push(branch2);
      }
    }
    log$1.debug(label.join(" "));
    if (commit2.parents && commit2.parents.length == 2) {
      const newCommit = commits[commit2.parents[0]];
      upsert(commitArr, commit2, newCommit);
      commitArr.push(commits[commit2.parents[1]]);
    } else if (commit2.parents.length == 0) {
      return;
    } else {
      const nextCommit = commits[commit2.parents];
      upsert(commitArr, commit2, nextCommit);
    }
    commitArr = uniqBy(commitArr, (c2) => c2.id);
    prettyPrintCommitHistory(commitArr);
  }
  const prettyPrint = function() {
    log$1.debug(commits);
    const node2 = getCommitsArray()[0];
    prettyPrintCommitHistory([node2]);
  };
  const clear$h = function() {
    commits = {};
    head = null;
    let mainBranch = getConfig$1().gitGraph.mainBranchName;
    let mainBranchOrder2 = getConfig$1().gitGraph.mainBranchOrder;
    branches = {};
    branches[mainBranch] = null;
    branchesConfig = {};
    branchesConfig[mainBranch] = { name: mainBranch, order: mainBranchOrder2 };
    curBranch = mainBranch;
    seq = 0;
    clear$i();
  };
  const getBranchesAsObjArray = function() {
    const branchesArray = Object.values(branchesConfig).map((branchConfig, i2) => {
      if (branchConfig.order !== null) {
        return branchConfig;
      }
      return {
        ...branchConfig,
        order: parseFloat(`0.${i2}`, 10)
      };
    }).sort((a, b) => a.order - b.order).map(({ name: name2 }) => ({ name: name2 }));
    return branchesArray;
  };
  const getBranches = function() {
    return branches;
  };
  const getCommits = function() {
    return commits;
  };
  const getCommitsArray = function() {
    const commitArr = Object.keys(commits).map(function(key) {
      return commits[key];
    });
    commitArr.forEach(function(o) {
      log$1.debug(o.id);
    });
    commitArr.sort((a, b) => a.seq - b.seq);
    return commitArr;
  };
  const getCurrentBranch = function() {
    return curBranch;
  };
  const getDirection$3 = function() {
    return direction$3;
  };
  const getHead = function() {
    return head;
  };
  const commitType$1 = {
    NORMAL: 0,
    REVERSE: 1,
    HIGHLIGHT: 2,
    MERGE: 3,
    CHERRY_PICK: 4
  };
  const gitGraphDb = {
    parseDirective: parseDirective$b,
    getConfig: () => getConfig$1().gitGraph,
    setDirection: setDirection$3,
    setOptions: setOptions$4,
    getOptions,
    commit,
    branch,
    merge: merge$2,
    cherryPick,
    checkout,
    prettyPrint,
    clear: clear$h,
    getBranchesAsObjArray,
    getBranches,
    getCommits,
    getCommitsArray,
    getCurrentBranch,
    getDirection: getDirection$3,
    getHead,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    setDiagramTitle,
    getDiagramTitle,
    commitType: commitType$1
  };
  let allCommitsDict = {};
  const commitType = {
    NORMAL: 0,
    REVERSE: 1,
    HIGHLIGHT: 2,
    MERGE: 3,
    CHERRY_PICK: 4
  };
  const THEME_COLOR_LIMIT = 8;
  let branchPos = {};
  let commitPos = {};
  let lanes = [];
  let maxPos = 0;
  const clear$g = () => {
    branchPos = {};
    commitPos = {};
    allCommitsDict = {};
    maxPos = 0;
    lanes = [];
  };
  const drawText$3 = (txt) => {
    const svgLabel = document.createElementNS("http://www.w3.org/2000/svg", "text");
    let rows = [];
    if (typeof txt === "string") {
      rows = txt.split(/\\n|\n|<br\s*\/?>/gi);
    } else if (Array.isArray(txt)) {
      rows = txt;
    } else {
      rows = [];
    }
    for (const row of rows) {
      const tspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
      tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
      tspan.setAttribute("dy", "1em");
      tspan.setAttribute("x", "0");
      tspan.setAttribute("class", "row");
      tspan.textContent = row.trim();
      svgLabel.appendChild(tspan);
    }
    return svgLabel;
  };
  const drawCommits = (svg2, commits2, modifyGraph) => {
    const gitGraphConfig = getConfig().gitGraph;
    const gBullets = svg2.append("g").attr("class", "commit-bullets");
    const gLabels = svg2.append("g").attr("class", "commit-labels");
    let pos = 0;
    const keys2 = Object.keys(commits2);
    const sortedKeys = keys2.sort((a, b) => {
      return commits2[a].seq - commits2[b].seq;
    });
    sortedKeys.forEach((key) => {
      const commit2 = commits2[key];
      const y2 = branchPos[commit2.branch].pos;
      const x2 = pos + 10;
      if (modifyGraph) {
        let typeClass;
        let commitSymbolType = commit2.customType !== void 0 && commit2.customType !== "" ? commit2.customType : commit2.type;
        switch (commitSymbolType) {
          case commitType.NORMAL:
            typeClass = "commit-normal";
            break;
          case commitType.REVERSE:
            typeClass = "commit-reverse";
            break;
          case commitType.HIGHLIGHT:
            typeClass = "commit-highlight";
            break;
          case commitType.MERGE:
            typeClass = "commit-merge";
            break;
          case commitType.CHERRY_PICK:
            typeClass = "commit-cherry-pick";
            break;
          default:
            typeClass = "commit-normal";
        }
        if (commitSymbolType === commitType.HIGHLIGHT) {
          const circle2 = gBullets.append("rect");
          circle2.attr("x", x2 - 10);
          circle2.attr("y", y2 - 10);
          circle2.attr("height", 20);
          circle2.attr("width", 20);
          circle2.attr(
            "class",
            `commit ${commit2.id} commit-highlight${branchPos[commit2.branch].index % THEME_COLOR_LIMIT} ${typeClass}-outer`
          );
          gBullets.append("rect").attr("x", x2 - 6).attr("y", y2 - 6).attr("height", 12).attr("width", 12).attr(
            "class",
            `commit ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT} ${typeClass}-inner`
          );
        } else if (commitSymbolType === commitType.CHERRY_PICK) {
          gBullets.append("circle").attr("cx", x2).attr("cy", y2).attr("r", 10).attr("class", `commit ${commit2.id} ${typeClass}`);
          gBullets.append("circle").attr("cx", x2 - 3).attr("cy", y2 + 2).attr("r", 2.75).attr("fill", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
          gBullets.append("circle").attr("cx", x2 + 3).attr("cy", y2 + 2).attr("r", 2.75).attr("fill", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
          gBullets.append("line").attr("x1", x2 + 3).attr("y1", y2 + 1).attr("x2", x2).attr("y2", y2 - 5).attr("stroke", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
          gBullets.append("line").attr("x1", x2 - 3).attr("y1", y2 + 1).attr("x2", x2).attr("y2", y2 - 5).attr("stroke", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
        } else {
          const circle2 = gBullets.append("circle");
          circle2.attr("cx", x2);
          circle2.attr("cy", y2);
          circle2.attr("r", commit2.type === commitType.MERGE ? 9 : 10);
          circle2.attr(
            "class",
            `commit ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT}`
          );
          if (commitSymbolType === commitType.MERGE) {
            const circle22 = gBullets.append("circle");
            circle22.attr("cx", x2);
            circle22.attr("cy", y2);
            circle22.attr("r", 6);
            circle22.attr(
              "class",
              `commit ${typeClass} ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT}`
            );
          }
          if (commitSymbolType === commitType.REVERSE) {
            const cross2 = gBullets.append("path");
            cross2.attr("d", `M ${x2 - 5},${y2 - 5}L${x2 + 5},${y2 + 5}M${x2 - 5},${y2 + 5}L${x2 + 5},${y2 - 5}`).attr(
              "class",
              `commit ${typeClass} ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT}`
            );
          }
        }
      }
      commitPos[commit2.id] = { x: pos + 10, y: y2 };
      if (modifyGraph) {
        const px = 4;
        const py = 2;
        if (commit2.type !== commitType.CHERRY_PICK && (commit2.customId && commit2.type === commitType.MERGE || commit2.type !== commitType.MERGE) && gitGraphConfig.showCommitLabel) {
          const wrapper = gLabels.append("g");
          const labelBkg = wrapper.insert("rect").attr("class", "commit-label-bkg");
          const text2 = wrapper.append("text").attr("x", pos).attr("y", y2 + 25).attr("class", "commit-label").text(commit2.id);
          let bbox = text2.node().getBBox();
          labelBkg.attr("x", pos + 10 - bbox.width / 2 - py).attr("y", y2 + 13.5).attr("width", bbox.width + 2 * py).attr("height", bbox.height + 2 * py);
          text2.attr("x", pos + 10 - bbox.width / 2);
          if (gitGraphConfig.rotateCommitLabel) {
            let r_x = -7.5 - (bbox.width + 10) / 25 * 9.5;
            let r_y = 10 + bbox.width / 25 * 8.5;
            wrapper.attr(
              "transform",
              "translate(" + r_x + ", " + r_y + ") rotate(" + -45 + ", " + pos + ", " + y2 + ")"
            );
          }
        }
        if (commit2.tag) {
          const rect2 = gLabels.insert("polygon");
          const hole = gLabels.append("circle");
          const tag = gLabels.append("text").attr("y", y2 - 16).attr("class", "tag-label").text(commit2.tag);
          let tagBbox = tag.node().getBBox();
          tag.attr("x", pos + 10 - tagBbox.width / 2);
          const h2 = tagBbox.height / 2;
          const ly = y2 - 19.2;
          rect2.attr("class", "tag-label-bkg").attr(
            "points",
            `
          ${pos - tagBbox.width / 2 - px / 2},${ly + py}
          ${pos - tagBbox.width / 2 - px / 2},${ly - py}
          ${pos + 10 - tagBbox.width / 2 - px},${ly - h2 - py}
          ${pos + 10 + tagBbox.width / 2 + px},${ly - h2 - py}
          ${pos + 10 + tagBbox.width / 2 + px},${ly + h2 + py}
          ${pos + 10 - tagBbox.width / 2 - px},${ly + h2 + py}`
          );
          hole.attr("cx", pos - tagBbox.width / 2 + px / 2).attr("cy", ly).attr("r", 1.5).attr("class", "tag-hole");
        }
      }
      pos += 50;
      if (pos > maxPos) {
        maxPos = pos;
      }
    });
  };
  const hasOverlappingCommits = (commit1, commit2, allCommits) => {
    const keys2 = Object.keys(allCommits);
    const overlappingComits = keys2.filter((key) => {
      return allCommits[key].branch === commit2.branch && allCommits[key].seq > commit1.seq && allCommits[key].seq < commit2.seq;
    });
    return overlappingComits.length > 0;
  };
  const findLane = (y1, y2, depth = 0) => {
    const candidate = y1 + Math.abs(y1 - y2) / 2;
    if (depth > 5) {
      return candidate;
    }
    let ok = lanes.every((lane) => Math.abs(lane - candidate) >= 10);
    if (ok) {
      lanes.push(candidate);
      return candidate;
    }
    const diff2 = Math.abs(y1 - y2);
    return findLane(y1, y2 - diff2 / 5, depth + 1);
  };
  const drawArrow = (svg2, commit1, commit2, allCommits) => {
    const p1 = commitPos[commit1.id];
    const p2 = commitPos[commit2.id];
    const overlappingCommits = hasOverlappingCommits(commit1, commit2, allCommits);
    let arc = "";
    let arc2 = "";
    let radius = 0;
    let offset2 = 0;
    let colorClassNum = branchPos[commit2.branch].index;
    let lineDef;
    if (overlappingCommits) {
      arc = "A 10 10, 0, 0, 0,";
      arc2 = "A 10 10, 0, 0, 1,";
      radius = 10;
      offset2 = 10;
      colorClassNum = branchPos[commit2.branch].index;
      const lineY = p1.y < p2.y ? findLane(p1.y, p2.y) : findLane(p2.y, p1.y);
      if (p1.y < p2.y) {
        lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${lineY - radius} ${arc} ${p1.x + offset2} ${lineY} L ${p2.x - radius} ${lineY} ${arc2} ${p2.x} ${lineY + offset2} L ${p2.x} ${p2.y}`;
      } else {
        lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${lineY + radius} ${arc2} ${p1.x + offset2} ${lineY} L ${p2.x - radius} ${lineY} ${arc} ${p2.x} ${lineY - offset2} L ${p2.x} ${p2.y}`;
      }
    } else {
      if (p1.y < p2.y) {
        arc = "A 20 20, 0, 0, 0,";
        radius = 20;
        offset2 = 20;
        colorClassNum = branchPos[commit2.branch].index;
        lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${p2.y - radius} ${arc} ${p1.x + offset2} ${p2.y} L ${p2.x} ${p2.y}`;
      }
      if (p1.y > p2.y) {
        arc = "A 20 20, 0, 0, 0,";
        radius = 20;
        offset2 = 20;
        colorClassNum = branchPos[commit1.branch].index;
        lineDef = `M ${p1.x} ${p1.y} L ${p2.x - radius} ${p1.y} ${arc} ${p2.x} ${p1.y - offset2} L ${p2.x} ${p2.y}`;
      }
      if (p1.y === p2.y) {
        colorClassNum = branchPos[commit1.branch].index;
        lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${p2.y - radius} ${arc} ${p1.x + offset2} ${p2.y} L ${p2.x} ${p2.y}`;
      }
    }
    svg2.append("path").attr("d", lineDef).attr("class", "arrow arrow" + colorClassNum % THEME_COLOR_LIMIT);
  };
  const drawArrows = (svg2, commits2) => {
    const gArrows = svg2.append("g").attr("class", "commit-arrows");
    Object.keys(commits2).forEach((key) => {
      const commit2 = commits2[key];
      if (commit2.parents && commit2.parents.length > 0) {
        commit2.parents.forEach((parent) => {
          drawArrow(gArrows, commits2[parent], commit2, commits2);
        });
      }
    });
  };
  const drawBranches = (svg2, branches2) => {
    const gitGraphConfig = getConfig().gitGraph;
    const g = svg2.append("g");
    branches2.forEach((branch2, index) => {
      const adjustIndexForTheme = index % THEME_COLOR_LIMIT;
      const pos = branchPos[branch2.name].pos;
      const line2 = g.append("line");
      line2.attr("x1", 0);
      line2.attr("y1", pos);
      line2.attr("x2", maxPos);
      line2.attr("y2", pos);
      line2.attr("class", "branch branch" + adjustIndexForTheme);
      lanes.push(pos);
      let name2 = branch2.name;
      const labelElement = drawText$3(name2);
      const bkg = g.insert("rect");
      const branchLabel = g.insert("g").attr("class", "branchLabel");
      const label = branchLabel.insert("g").attr("class", "label branch-label" + adjustIndexForTheme);
      label.node().appendChild(labelElement);
      let bbox = labelElement.getBBox();
      bkg.attr("class", "branchLabelBkg label" + adjustIndexForTheme).attr("rx", 4).attr("ry", 4).attr("x", -bbox.width - 4 - (gitGraphConfig.rotateCommitLabel === true ? 30 : 0)).attr("y", -bbox.height / 2 + 8).attr("width", bbox.width + 18).attr("height", bbox.height + 4);
      label.attr(
        "transform",
        "translate(" + (-bbox.width - 14 - (gitGraphConfig.rotateCommitLabel === true ? 30 : 0)) + ", " + (pos - bbox.height / 2 - 1) + ")"
      );
      bkg.attr("transform", "translate(" + -19 + ", " + (pos - bbox.height / 2) + ")");
    });
  };
  const draw$i = function(txt, id2, ver, diagObj) {
    var _a;
    clear$g();
    const conf2 = getConfig();
    const gitGraphConfig = conf2.gitGraph;
    log$1.debug("in gitgraph renderer", txt + "\n", "id:", id2, ver);
    allCommitsDict = diagObj.db.getCommits();
    const branches2 = diagObj.db.getBranchesAsObjArray();
    let pos = 0;
    branches2.forEach((branch2, index) => {
      branchPos[branch2.name] = { pos, index };
      pos += 50 + (gitGraphConfig.rotateCommitLabel ? 40 : 0);
    });
    const diagram2 = select(`[id="${id2}"]`);
    drawCommits(diagram2, allCommitsDict, false);
    if (gitGraphConfig.showBranches) {
      drawBranches(diagram2, branches2);
    }
    drawArrows(diagram2, allCommitsDict);
    drawCommits(diagram2, allCommitsDict, true);
    utils.insertTitle(
      diagram2,
      "gitTitleText",
      gitGraphConfig.titleTopMargin,
      diagObj.db.getDiagramTitle()
    );
    setupGraphViewbox(
      void 0,
      diagram2,
      gitGraphConfig.diagramPadding,
      (_a = gitGraphConfig.useMaxWidth) != null ? _a : conf2.useMaxWidth
    );
  };
  const gitGraphRenderer = {
    draw: draw$i
  };
  const getStyles$3 = (options2) => `
  .commit-id,
  .commit-msg,
  .branch-label {
    fill: lightgrey;
    color: lightgrey;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }
  ${[0, 1, 2, 3, 4, 5, 6, 7].map(
    (i2) => `
        .branch-label${i2} { fill: ${options2["gitBranchLabel" + i2]}; }
        .commit${i2} { stroke: ${options2["git" + i2]}; fill: ${options2["git" + i2]}; }
        .commit-highlight${i2} { stroke: ${options2["gitInv" + i2]}; fill: ${options2["gitInv" + i2]}; }
        .label${i2}  { fill: ${options2["git" + i2]}; }
        .arrow${i2} { stroke: ${options2["git" + i2]}; }
        `
  ).join("\n")}

  .branch {
    stroke-width: 1;
    stroke: ${options2.lineColor};
    stroke-dasharray: 2;
  }
  .commit-label { font-size: ${options2.commitLabelFontSize}; fill: ${options2.commitLabelColor};}
  .commit-label-bkg { font-size: ${options2.commitLabelFontSize}; fill: ${options2.commitLabelBackground}; opacity: 0.5; }
  .tag-label { font-size: ${options2.tagLabelFontSize}; fill: ${options2.tagLabelColor};}
  .tag-label-bkg { fill: ${options2.tagLabelBackground}; stroke: ${options2.tagLabelBorder}; }
  .tag-hole { fill: ${options2.textColor}; }

  .commit-merge {
    stroke: ${options2.primaryColor};
    fill: ${options2.primaryColor};
  }
  .commit-reverse {
    stroke: ${options2.primaryColor};
    fill: ${options2.primaryColor};
    stroke-width: 3;
  }
  .commit-highlight-outer {
  }
  .commit-highlight-inner {
    stroke: ${options2.primaryColor};
    fill: ${options2.primaryColor};
  }

  .arrow { stroke-width: 8; stroke-linecap: round; fill: none}
  .gitTitleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor};
  }
  }
`;
  const gitGraphStyles = getStyles$3;
  var parser$e = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 6], $V1 = [1, 7], $V2 = [1, 8], $V3 = [1, 9], $V4 = [1, 16], $V5 = [1, 11], $V6 = [1, 12], $V7 = [1, 13], $V8 = [1, 14], $V9 = [1, 15], $Va = [1, 27], $Vb = [1, 33], $Vc = [1, 34], $Vd = [1, 35], $Ve = [1, 36], $Vf = [1, 37], $Vg = [1, 72], $Vh = [1, 73], $Vi = [1, 74], $Vj = [1, 75], $Vk = [1, 76], $Vl = [1, 77], $Vm = [1, 78], $Vn = [1, 38], $Vo = [1, 39], $Vp = [1, 40], $Vq = [1, 41], $Vr = [1, 42], $Vs = [1, 43], $Vt = [1, 44], $Vu = [1, 45], $Vv = [1, 46], $Vw = [1, 47], $Vx = [1, 48], $Vy = [1, 49], $Vz = [1, 50], $VA = [1, 51], $VB = [1, 52], $VC = [1, 53], $VD = [1, 54], $VE = [1, 55], $VF = [1, 56], $VG = [1, 57], $VH = [1, 59], $VI = [1, 60], $VJ = [1, 61], $VK = [1, 62], $VL = [1, 63], $VM = [1, 64], $VN = [1, 65], $VO = [1, 66], $VP = [1, 67], $VQ = [1, 68], $VR = [1, 69], $VS = [24, 52], $VT = [24, 44, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], $VU = [15, 24, 44, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], $VV = [1, 94], $VW = [1, 95], $VX = [1, 96], $VY = [1, 97], $VZ = [15, 24, 52], $V_ = [7, 8, 9, 10, 18, 22, 25, 26, 27, 28], $V$ = [15, 24, 43, 52], $V01 = [15, 24, 43, 52, 86, 87, 89, 90], $V11 = [15, 43], $V21 = [44, 46, 47, 48, 49, 50, 51, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "direction": 5, "directive": 6, "direction_tb": 7, "direction_bt": 8, "direction_rl": 9, "direction_lr": 10, "graphConfig": 11, "openDirective": 12, "typeDirective": 13, "closeDirective": 14, "NEWLINE": 15, ":": 16, "argDirective": 17, "open_directive": 18, "type_directive": 19, "arg_directive": 20, "close_directive": 21, "C4_CONTEXT": 22, "statements": 23, "EOF": 24, "C4_CONTAINER": 25, "C4_COMPONENT": 26, "C4_DYNAMIC": 27, "C4_DEPLOYMENT": 28, "otherStatements": 29, "diagramStatements": 30, "otherStatement": 31, "title": 32, "accDescription": 33, "acc_title": 34, "acc_title_value": 35, "acc_descr": 36, "acc_descr_value": 37, "acc_descr_multiline_value": 38, "boundaryStatement": 39, "boundaryStartStatement": 40, "boundaryStopStatement": 41, "boundaryStart": 42, "LBRACE": 43, "ENTERPRISE_BOUNDARY": 44, "attributes": 45, "SYSTEM_BOUNDARY": 46, "BOUNDARY": 47, "CONTAINER_BOUNDARY": 48, "NODE": 49, "NODE_L": 50, "NODE_R": 51, "RBRACE": 52, "diagramStatement": 53, "PERSON": 54, "PERSON_EXT": 55, "SYSTEM": 56, "SYSTEM_DB": 57, "SYSTEM_QUEUE": 58, "SYSTEM_EXT": 59, "SYSTEM_EXT_DB": 60, "SYSTEM_EXT_QUEUE": 61, "CONTAINER": 62, "CONTAINER_DB": 63, "CONTAINER_QUEUE": 64, "CONTAINER_EXT": 65, "CONTAINER_EXT_DB": 66, "CONTAINER_EXT_QUEUE": 67, "COMPONENT": 68, "COMPONENT_DB": 69, "COMPONENT_QUEUE": 70, "COMPONENT_EXT": 71, "COMPONENT_EXT_DB": 72, "COMPONENT_EXT_QUEUE": 73, "REL": 74, "BIREL": 75, "REL_U": 76, "REL_D": 77, "REL_L": 78, "REL_R": 79, "REL_B": 80, "REL_INDEX": 81, "UPDATE_EL_STYLE": 82, "UPDATE_REL_STYLE": 83, "UPDATE_LAYOUT_CONFIG": 84, "attribute": 85, "STR": 86, "STR_KEY": 87, "STR_VALUE": 88, "ATTRIBUTE": 89, "ATTRIBUTE_EMPTY": 90, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 7: "direction_tb", 8: "direction_bt", 9: "direction_rl", 10: "direction_lr", 15: "NEWLINE", 16: ":", 18: "open_directive", 19: "type_directive", 20: "arg_directive", 21: "close_directive", 22: "C4_CONTEXT", 24: "EOF", 25: "C4_CONTAINER", 26: "C4_COMPONENT", 27: "C4_DYNAMIC", 28: "C4_DEPLOYMENT", 32: "title", 33: "accDescription", 34: "acc_title", 35: "acc_title_value", 36: "acc_descr", 37: "acc_descr_value", 38: "acc_descr_multiline_value", 43: "LBRACE", 44: "ENTERPRISE_BOUNDARY", 46: "SYSTEM_BOUNDARY", 47: "BOUNDARY", 48: "CONTAINER_BOUNDARY", 49: "NODE", 50: "NODE_L", 51: "NODE_R", 52: "RBRACE", 54: "PERSON", 55: "PERSON_EXT", 56: "SYSTEM", 57: "SYSTEM_DB", 58: "SYSTEM_QUEUE", 59: "SYSTEM_EXT", 60: "SYSTEM_EXT_DB", 61: "SYSTEM_EXT_QUEUE", 62: "CONTAINER", 63: "CONTAINER_DB", 64: "CONTAINER_QUEUE", 65: "CONTAINER_EXT", 66: "CONTAINER_EXT_DB", 67: "CONTAINER_EXT_QUEUE", 68: "COMPONENT", 69: "COMPONENT_DB", 70: "COMPONENT_QUEUE", 71: "COMPONENT_EXT", 72: "COMPONENT_EXT_DB", 73: "COMPONENT_EXT_QUEUE", 74: "REL", 75: "BIREL", 76: "REL_U", 77: "REL_D", 78: "REL_L", 79: "REL_R", 80: "REL_B", 81: "REL_INDEX", 82: "UPDATE_EL_STYLE", 83: "UPDATE_REL_STYLE", 84: "UPDATE_LAYOUT_CONFIG", 86: "STR", 87: "STR_KEY", 88: "STR_VALUE", 89: "ATTRIBUTE", 90: "ATTRIBUTE_EMPTY" },
      productions_: [0, [3, 1], [3, 1], [3, 2], [5, 1], [5, 1], [5, 1], [5, 1], [4, 1], [6, 4], [6, 6], [12, 1], [13, 1], [17, 1], [14, 1], [11, 4], [11, 4], [11, 4], [11, 4], [11, 4], [23, 1], [23, 1], [23, 2], [29, 1], [29, 2], [29, 3], [31, 1], [31, 1], [31, 2], [31, 2], [31, 1], [39, 3], [40, 3], [40, 3], [40, 4], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [41, 1], [30, 1], [30, 2], [30, 3], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 1], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [45, 1], [45, 2], [85, 1], [85, 2], [85, 1], [85, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 4:
            yy.setDirection("TB");
            break;
          case 5:
            yy.setDirection("BT");
            break;
          case 6:
            yy.setDirection("RL");
            break;
          case 7:
            yy.setDirection("LR");
            break;
          case 11:
            yy.parseDirective("%%{", "open_directive");
            break;
          case 12:
            break;
          case 13:
            $$[$0] = $$[$0].trim().replace(/'/g, '"');
            yy.parseDirective($$[$0], "arg_directive");
            break;
          case 14:
            yy.parseDirective("}%%", "close_directive", "c4Context");
            break;
          case 15:
          case 16:
          case 17:
          case 18:
          case 19:
            yy.setC4Type($$[$0 - 3]);
            break;
          case 26:
            yy.setTitle($$[$0].substring(6));
            this.$ = $$[$0].substring(6);
            break;
          case 27:
            yy.setAccDescription($$[$0].substring(15));
            this.$ = $$[$0].substring(15);
            break;
          case 28:
            this.$ = $$[$0].trim();
            yy.setTitle(this.$);
            break;
          case 29:
          case 30:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 35:
          case 36:
            $$[$0].splice(2, 0, "ENTERPRISE");
            yy.addPersonOrSystemBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 37:
            yy.addPersonOrSystemBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 38:
            $$[$0].splice(2, 0, "CONTAINER");
            yy.addContainerBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 39:
            yy.addDeploymentNode("node", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 40:
            yy.addDeploymentNode("nodeL", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 41:
            yy.addDeploymentNode("nodeR", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 42:
            yy.popBoundaryParseStack();
            break;
          case 46:
            yy.addPersonOrSystem("person", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 47:
            yy.addPersonOrSystem("external_person", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 48:
            yy.addPersonOrSystem("system", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 49:
            yy.addPersonOrSystem("system_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 50:
            yy.addPersonOrSystem("system_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 51:
            yy.addPersonOrSystem("external_system", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 52:
            yy.addPersonOrSystem("external_system_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 53:
            yy.addPersonOrSystem("external_system_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 54:
            yy.addContainer("container", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 55:
            yy.addContainer("container_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 56:
            yy.addContainer("container_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 57:
            yy.addContainer("external_container", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 58:
            yy.addContainer("external_container_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 59:
            yy.addContainer("external_container_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 60:
            yy.addComponent("component", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 61:
            yy.addComponent("component_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 62:
            yy.addComponent("component_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 63:
            yy.addComponent("external_component", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 64:
            yy.addComponent("external_component_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 65:
            yy.addComponent("external_component_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 67:
            yy.addRel("rel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 68:
            yy.addRel("birel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 69:
            yy.addRel("rel_u", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 70:
            yy.addRel("rel_d", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 71:
            yy.addRel("rel_l", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 72:
            yy.addRel("rel_r", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 73:
            yy.addRel("rel_b", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 74:
            $$[$0].splice(0, 1);
            yy.addRel("rel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 75:
            yy.updateElStyle("update_el_style", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 76:
            yy.updateRelStyle("update_rel_style", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 77:
            yy.updateLayoutConfig("update_layout_config", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 78:
            this.$ = [$$[$0]];
            break;
          case 79:
            $$[$0].unshift($$[$0 - 1]);
            this.$ = $$[$0];
            break;
          case 80:
          case 82:
            this.$ = $$[$0].trim();
            break;
          case 81:
            let kv = {};
            kv[$$[$0 - 1].trim()] = $$[$0].trim();
            this.$ = kv;
            break;
          case 83:
            this.$ = "";
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 5: 3, 6: 4, 7: $V0, 8: $V1, 9: $V2, 10: $V3, 11: 5, 12: 10, 18: $V4, 22: $V5, 25: $V6, 26: $V7, 27: $V8, 28: $V9 }, { 1: [3] }, { 1: [2, 1] }, { 1: [2, 2] }, { 3: 17, 4: 2, 5: 3, 6: 4, 7: $V0, 8: $V1, 9: $V2, 10: $V3, 11: 5, 12: 10, 18: $V4, 22: $V5, 25: $V6, 26: $V7, 27: $V8, 28: $V9 }, { 1: [2, 8] }, { 1: [2, 4] }, { 1: [2, 5] }, { 1: [2, 6] }, { 1: [2, 7] }, { 13: 18, 19: [1, 19] }, { 15: [1, 20] }, { 15: [1, 21] }, { 15: [1, 22] }, { 15: [1, 23] }, { 15: [1, 24] }, { 19: [2, 11] }, { 1: [2, 3] }, { 14: 25, 16: [1, 26], 21: $Va }, o([16, 21], [2, 12]), { 23: 28, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 79, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 80, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 81, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 82, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 15: [1, 83] }, { 17: 84, 20: [1, 85] }, { 15: [2, 14] }, { 24: [1, 86] }, o($VS, [2, 20], { 53: 32, 39: 58, 40: 70, 42: 71, 30: 87, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }), o($VS, [2, 21]), o($VT, [2, 23], { 15: [1, 88] }), o($VS, [2, 43], { 15: [1, 89] }), o($VU, [2, 26]), o($VU, [2, 27]), { 35: [1, 90] }, { 37: [1, 91] }, o($VU, [2, 30]), { 45: 92, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 98, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 99, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 100, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 101, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 102, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 103, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 104, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 105, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 106, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 107, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 108, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 109, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 110, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 111, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 112, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 113, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 114, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 115, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 116, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, o($VZ, [2, 66]), { 45: 117, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 118, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 119, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 120, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 121, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 122, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 123, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 124, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 125, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 126, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 127, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 30: 128, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 15: [1, 130], 43: [1, 129] }, { 45: 131, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 132, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 133, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 134, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 135, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 136, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 137, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 24: [1, 138] }, { 24: [1, 139] }, { 24: [1, 140] }, { 24: [1, 141] }, o($V_, [2, 9]), { 14: 142, 21: $Va }, { 21: [2, 13] }, { 1: [2, 15] }, o($VS, [2, 22]), o($VT, [2, 24], { 31: 31, 29: 143, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf }), o($VS, [2, 44], { 29: 29, 30: 30, 31: 31, 53: 32, 39: 58, 40: 70, 42: 71, 23: 144, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }), o($VU, [2, 28]), o($VU, [2, 29]), o($VZ, [2, 46]), o($V$, [2, 78], { 85: 93, 45: 145, 86: $VV, 87: $VW, 89: $VX, 90: $VY }), o($V01, [2, 80]), { 88: [1, 146] }, o($V01, [2, 82]), o($V01, [2, 83]), o($VZ, [2, 47]), o($VZ, [2, 48]), o($VZ, [2, 49]), o($VZ, [2, 50]), o($VZ, [2, 51]), o($VZ, [2, 52]), o($VZ, [2, 53]), o($VZ, [2, 54]), o($VZ, [2, 55]), o($VZ, [2, 56]), o($VZ, [2, 57]), o($VZ, [2, 58]), o($VZ, [2, 59]), o($VZ, [2, 60]), o($VZ, [2, 61]), o($VZ, [2, 62]), o($VZ, [2, 63]), o($VZ, [2, 64]), o($VZ, [2, 65]), o($VZ, [2, 67]), o($VZ, [2, 68]), o($VZ, [2, 69]), o($VZ, [2, 70]), o($VZ, [2, 71]), o($VZ, [2, 72]), o($VZ, [2, 73]), o($VZ, [2, 74]), o($VZ, [2, 75]), o($VZ, [2, 76]), o($VZ, [2, 77]), { 41: 147, 52: [1, 148] }, { 15: [1, 149] }, { 43: [1, 150] }, o($V11, [2, 35]), o($V11, [2, 36]), o($V11, [2, 37]), o($V11, [2, 38]), o($V11, [2, 39]), o($V11, [2, 40]), o($V11, [2, 41]), { 1: [2, 16] }, { 1: [2, 17] }, { 1: [2, 18] }, { 1: [2, 19] }, { 15: [1, 151] }, o($VT, [2, 25]), o($VS, [2, 45]), o($V$, [2, 79]), o($V01, [2, 81]), o($VZ, [2, 31]), o($VZ, [2, 42]), o($V21, [2, 32]), o($V21, [2, 33], { 15: [1, 152] }), o($V_, [2, 10]), o($V21, [2, 34])],
      defaultActions: { 2: [2, 1], 3: [2, 2], 5: [2, 8], 6: [2, 4], 7: [2, 5], 8: [2, 6], 9: [2, 7], 16: [2, 11], 17: [2, 3], 27: [2, 14], 85: [2, 13], 86: [2, 15], 138: [2, 16], 139: [2, 17], 140: [2, 18], 141: [2, 19] },
      parseError: function parseError2(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error2 = new Error(str2);
          error2.hash = hash;
          throw error2;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state, action, r, yyval = {}, p2, len, newState, expected;
        while (true) {
          state = stack[stack.length - 1];
          if (this.defaultActions[state]) {
            action = this.defaultActions[state];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state] && table[state][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p2 in table[state]) {
              if (this.terminals_[p2] && p2 > TERROR) {
                expected.push("'" + this.terminals_[p2] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError2(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        more: function() {
          this._more = true;
          return this;
        },
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        test_match: function(match5, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match5[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match5[0].length
          };
          this.yytext += match5[0];
          this.match += match5[0];
          this.matches = match5;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match5[0].length);
          this.matched += match5[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match5, tempMatch, index;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match5 || tempMatch[0].length > match5[0].length)) {
              match5 = tempMatch;
              index = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match5 = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match5) {
            token2 = this.test_match(match5, rules[index]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: {},
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              this.begin("open_directive");
              return 18;
            case 1:
              return 7;
            case 2:
              return 8;
            case 3:
              return 9;
            case 4:
              return 10;
            case 5:
              this.begin("type_directive");
              return 19;
            case 6:
              this.popState();
              this.begin("arg_directive");
              return 16;
            case 7:
              this.popState();
              this.popState();
              return 21;
            case 8:
              return 20;
            case 9:
              return 32;
            case 10:
              return 33;
            case 11:
              this.begin("acc_title");
              return 34;
            case 12:
              this.popState();
              return "acc_title_value";
            case 13:
              this.begin("acc_descr");
              return 36;
            case 14:
              this.popState();
              return "acc_descr_value";
            case 15:
              this.begin("acc_descr_multiline");
              break;
            case 16:
              this.popState();
              break;
            case 17:
              return "acc_descr_multiline_value";
            case 18:
              break;
            case 19:
              c;
              break;
            case 20:
              return 15;
            case 21:
              break;
            case 22:
              return 22;
            case 23:
              return 25;
            case 24:
              return 26;
            case 25:
              return 27;
            case 26:
              return 28;
            case 27:
              this.begin("person_ext");
              return 55;
            case 28:
              this.begin("person");
              return 54;
            case 29:
              this.begin("system_ext_queue");
              return 61;
            case 30:
              this.begin("system_ext_db");
              return 60;
            case 31:
              this.begin("system_ext");
              return 59;
            case 32:
              this.begin("system_queue");
              return 58;
            case 33:
              this.begin("system_db");
              return 57;
            case 34:
              this.begin("system");
              return 56;
            case 35:
              this.begin("boundary");
              return 47;
            case 36:
              this.begin("enterprise_boundary");
              return 44;
            case 37:
              this.begin("system_boundary");
              return 46;
            case 38:
              this.begin("container_ext_queue");
              return 67;
            case 39:
              this.begin("container_ext_db");
              return 66;
            case 40:
              this.begin("container_ext");
              return 65;
            case 41:
              this.begin("container_queue");
              return 64;
            case 42:
              this.begin("container_db");
              return 63;
            case 43:
              this.begin("container");
              return 62;
            case 44:
              this.begin("container_boundary");
              return 48;
            case 45:
              this.begin("component_ext_queue");
              return 73;
            case 46:
              this.begin("component_ext_db");
              return 72;
            case 47:
              this.begin("component_ext");
              return 71;
            case 48:
              this.begin("component_queue");
              return 70;
            case 49:
              this.begin("component_db");
              return 69;
            case 50:
              this.begin("component");
              return 68;
            case 51:
              this.begin("node");
              return 49;
            case 52:
              this.begin("node");
              return 49;
            case 53:
              this.begin("node_l");
              return 50;
            case 54:
              this.begin("node_r");
              return 51;
            case 55:
              this.begin("rel");
              return 74;
            case 56:
              this.begin("birel");
              return 75;
            case 57:
              this.begin("rel_u");
              return 76;
            case 58:
              this.begin("rel_u");
              return 76;
            case 59:
              this.begin("rel_d");
              return 77;
            case 60:
              this.begin("rel_d");
              return 77;
            case 61:
              this.begin("rel_l");
              return 78;
            case 62:
              this.begin("rel_l");
              return 78;
            case 63:
              this.begin("rel_r");
              return 79;
            case 64:
              this.begin("rel_r");
              return 79;
            case 65:
              this.begin("rel_b");
              return 80;
            case 66:
              this.begin("rel_index");
              return 81;
            case 67:
              this.begin("update_el_style");
              return 82;
            case 68:
              this.begin("update_rel_style");
              return 83;
            case 69:
              this.begin("update_layout_config");
              return 84;
            case 70:
              return "EOF_IN_STRUCT";
            case 71:
              this.begin("attribute");
              return "ATTRIBUTE_EMPTY";
            case 72:
              this.begin("attribute");
              break;
            case 73:
              this.popState();
              this.popState();
              break;
            case 74:
              return 90;
            case 75:
              break;
            case 76:
              return 90;
            case 77:
              this.begin("string");
              break;
            case 78:
              this.popState();
              break;
            case 79:
              return "STR";
            case 80:
              this.begin("string_kv");
              break;
            case 81:
              this.begin("string_kv_key");
              return "STR_KEY";
            case 82:
              this.popState();
              this.begin("string_kv_value");
              break;
            case 83:
              return "STR_VALUE";
            case 84:
              this.popState();
              this.popState();
              break;
            case 85:
              return "STR";
            case 86:
              return "LBRACE";
            case 87:
              return "RBRACE";
            case 88:
              return "SPACE";
            case 89:
              return "EOL";
            case 90:
              return 24;
          }
        },
        rules: [/^(?:%%\{)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:title\s[^#\n;]+)/, /^(?:accDescription\s[^#\n;]+)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:%%(?!\{)*[^\n]*(\r?\n?)+)/, /^(?:%%[^\n]*(\r?\n)*)/, /^(?:\s*(\r?\n)+)/, /^(?:\s+)/, /^(?:C4Context\b)/, /^(?:C4Container\b)/, /^(?:C4Component\b)/, /^(?:C4Dynamic\b)/, /^(?:C4Deployment\b)/, /^(?:Person_Ext\b)/, /^(?:Person\b)/, /^(?:SystemQueue_Ext\b)/, /^(?:SystemDb_Ext\b)/, /^(?:System_Ext\b)/, /^(?:SystemQueue\b)/, /^(?:SystemDb\b)/, /^(?:System\b)/, /^(?:Boundary\b)/, /^(?:Enterprise_Boundary\b)/, /^(?:System_Boundary\b)/, /^(?:ContainerQueue_Ext\b)/, /^(?:ContainerDb_Ext\b)/, /^(?:Container_Ext\b)/, /^(?:ContainerQueue\b)/, /^(?:ContainerDb\b)/, /^(?:Container\b)/, /^(?:Container_Boundary\b)/, /^(?:ComponentQueue_Ext\b)/, /^(?:ComponentDb_Ext\b)/, /^(?:Component_Ext\b)/, /^(?:ComponentQueue\b)/, /^(?:ComponentDb\b)/, /^(?:Component\b)/, /^(?:Deployment_Node\b)/, /^(?:Node\b)/, /^(?:Node_L\b)/, /^(?:Node_R\b)/, /^(?:Rel\b)/, /^(?:BiRel\b)/, /^(?:Rel_Up\b)/, /^(?:Rel_U\b)/, /^(?:Rel_Down\b)/, /^(?:Rel_D\b)/, /^(?:Rel_Left\b)/, /^(?:Rel_L\b)/, /^(?:Rel_Right\b)/, /^(?:Rel_R\b)/, /^(?:Rel_Back\b)/, /^(?:RelIndex\b)/, /^(?:UpdateElementStyle\b)/, /^(?:UpdateRelStyle\b)/, /^(?:UpdateLayoutConfig\b)/, /^(?:$)/, /^(?:[(][ ]*[,])/, /^(?:[(])/, /^(?:[)])/, /^(?:,,)/, /^(?:,)/, /^(?:[ ]*["]["])/, /^(?:[ ]*["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:[ ]*[\$])/, /^(?:[^=]*)/, /^(?:[=][ ]*["])/, /^(?:[^"]+)/, /^(?:["])/, /^(?:[^,]+)/, /^(?:\{)/, /^(?:\})/, /^(?:[\s]+)/, /^(?:[\n\r]+)/, /^(?:$)/],
        conditions: { "acc_descr_multiline": { "rules": [16, 17], "inclusive": false }, "acc_descr": { "rules": [14], "inclusive": false }, "acc_title": { "rules": [12], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [7, 8], "inclusive": false }, "type_directive": { "rules": [6, 7], "inclusive": false }, "open_directive": { "rules": [5], "inclusive": false }, "string_kv_value": { "rules": [83, 84], "inclusive": false }, "string_kv_key": { "rules": [82], "inclusive": false }, "string_kv": { "rules": [81], "inclusive": false }, "string": { "rules": [78, 79], "inclusive": false }, "attribute": { "rules": [73, 74, 75, 76, 77, 80, 85], "inclusive": false }, "update_layout_config": { "rules": [70, 71, 72, 73], "inclusive": false }, "update_rel_style": { "rules": [70, 71, 72, 73], "inclusive": false }, "update_el_style": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_b": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_r": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_l": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_d": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_u": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_bi": { "rules": [], "inclusive": false }, "rel": { "rules": [70, 71, 72, 73], "inclusive": false }, "node_r": { "rules": [70, 71, 72, 73], "inclusive": false }, "node_l": { "rules": [70, 71, 72, 73], "inclusive": false }, "node": { "rules": [70, 71, 72, 73], "inclusive": false }, "index": { "rules": [], "inclusive": false }, "rel_index": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_ext_queue": { "rules": [], "inclusive": false }, "component_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "component": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_ext_queue": { "rules": [], "inclusive": false }, "container_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "container": { "rules": [70, 71, 72, 73], "inclusive": false }, "birel": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "enterprise_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "system": { "rules": [70, 71, 72, 73], "inclusive": false }, "person_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "person": { "rules": [70, 71, 72, 73], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 3, 4, 9, 10, 11, 13, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 86, 87, 88, 89, 90], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$e.parser = parser$e;
  const c4Parser = parser$e;
  const c4Detector = (txt) => {
    return txt.match(/^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/) !== null;
  };
  let c4ShapeArray = [];
  let boundaryParseStack = [""];
  let currentBoundaryParse = "global";
  let parentBoundaryParse = "";
  let boundarys = [
    {
      alias: "global",
      label: { text: "global" },
      type: { text: "global" },
      tags: null,
      link: null,
      parentBoundary: ""
    }
  ];
  let rels = [];
  let title = "";
  let wrapEnabled$1 = false;
  let c4ShapeInRow$1 = 4;
  let c4BoundaryInRow$1 = 2;
  var c4Type;
  const getC4Type = function() {
    return c4Type;
  };
  const setC4Type = function(c4TypeParam) {
    let sanitizedText = sanitizeText$6(c4TypeParam, getConfig$1());
    c4Type = sanitizedText;
  };
  const parseDirective$a = function(statement, context, type2) {
    mermaidAPI.parseDirective(this, statement, context, type2);
  };
  const addRel = function(type2, from2, to2, label, techn, descr, sprite, tags2, link) {
    if (type2 === void 0 || type2 === null || from2 === void 0 || from2 === null || to2 === void 0 || to2 === null || label === void 0 || label === null) {
      return;
    }
    let rel = {};
    const old = rels.find((rel2) => rel2.from === from2 && rel2.to === to2);
    if (old) {
      rel = old;
    } else {
      rels.push(rel);
    }
    rel.type = type2;
    rel.from = from2;
    rel.to = to2;
    rel.label = { text: label };
    if (techn === void 0 || techn === null) {
      rel.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        rel[key] = { text: value };
      } else {
        rel.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      rel.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        rel[key] = { text: value };
      } else {
        rel.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      rel[key] = value;
    } else {
      rel.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      rel[key] = value;
    } else {
      rel.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      rel[key] = value;
    } else {
      rel.link = link;
    }
    rel.wrap = autoWrap$1();
  };
  const addPersonOrSystem = function(typeC4Shape, alias, label, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let personOrSystem = {};
    const old = c4ShapeArray.find((personOrSystem2) => personOrSystem2.alias === alias);
    if (old && alias === old.alias) {
      personOrSystem = old;
    } else {
      personOrSystem.alias = alias;
      c4ShapeArray.push(personOrSystem);
    }
    if (label === void 0 || label === null) {
      personOrSystem.label = { text: "" };
    } else {
      personOrSystem.label = { text: label };
    }
    if (descr === void 0 || descr === null) {
      personOrSystem.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        personOrSystem[key] = { text: value };
      } else {
        personOrSystem.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      personOrSystem[key] = value;
    } else {
      personOrSystem.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      personOrSystem[key] = value;
    } else {
      personOrSystem.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      personOrSystem[key] = value;
    } else {
      personOrSystem.link = link;
    }
    personOrSystem.typeC4Shape = { text: typeC4Shape };
    personOrSystem.parentBoundary = currentBoundaryParse;
    personOrSystem.wrap = autoWrap$1();
  };
  const addContainer = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let container = {};
    const old = c4ShapeArray.find((container2) => container2.alias === alias);
    if (old && alias === old.alias) {
      container = old;
    } else {
      container.alias = alias;
      c4ShapeArray.push(container);
    }
    if (label === void 0 || label === null) {
      container.label = { text: "" };
    } else {
      container.label = { text: label };
    }
    if (techn === void 0 || techn === null) {
      container.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        container[key] = { text: value };
      } else {
        container.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      container.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        container[key] = { text: value };
      } else {
        container.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      container[key] = value;
    } else {
      container.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      container[key] = value;
    } else {
      container.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      container[key] = value;
    } else {
      container.link = link;
    }
    container.wrap = autoWrap$1();
    container.typeC4Shape = { text: typeC4Shape };
    container.parentBoundary = currentBoundaryParse;
  };
  const addComponent = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let component = {};
    const old = c4ShapeArray.find((component2) => component2.alias === alias);
    if (old && alias === old.alias) {
      component = old;
    } else {
      component.alias = alias;
      c4ShapeArray.push(component);
    }
    if (label === void 0 || label === null) {
      component.label = { text: "" };
    } else {
      component.label = { text: label };
    }
    if (techn === void 0 || techn === null) {
      component.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        component[key] = { text: value };
      } else {
        component.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      component.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        component[key] = { text: value };
      } else {
        component.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      component[key] = value;
    } else {
      component.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      component[key] = value;
    } else {
      component.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      component[key] = value;
    } else {
      component.link = link;
    }
    component.wrap = autoWrap$1();
    component.typeC4Shape = { text: typeC4Shape };
    component.parentBoundary = currentBoundaryParse;
  };
  const addPersonOrSystemBoundary = function(alias, label, type2, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "system" };
    } else {
      if (typeof type2 === "object") {
        let [key, value] = Object.entries(type2)[0];
        boundary[key] = { text: value };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      boundary[key] = value;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      boundary[key] = value;
    } else {
      boundary.link = link;
    }
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const addContainerBoundary = function(alias, label, type2, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "container" };
    } else {
      if (typeof type2 === "object") {
        let [key, value] = Object.entries(type2)[0];
        boundary[key] = { text: value };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      boundary[key] = value;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      boundary[key] = value;
    } else {
      boundary.link = link;
    }
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const addDeploymentNode = function(nodeType2, alias, label, type2, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "node" };
    } else {
      if (typeof type2 === "object") {
        let [key, value] = Object.entries(type2)[0];
        boundary[key] = { text: value };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (descr === void 0 || descr === null) {
      boundary.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        boundary[key] = { text: value };
      } else {
        boundary.descr = { text: descr };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      boundary[key] = value;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      boundary[key] = value;
    } else {
      boundary.link = link;
    }
    boundary.nodeType = nodeType2;
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const popBoundaryParseStack = function() {
    currentBoundaryParse = parentBoundaryParse;
    boundaryParseStack.pop();
    parentBoundaryParse = boundaryParseStack.pop();
    boundaryParseStack.push(parentBoundaryParse);
  };
  const updateElStyle = function(typeC4Shape, elementName, bgColor, fontColor, borderColor, shadowing, shape, sprite, techn, legendText, legendSprite) {
    let old = c4ShapeArray.find((element2) => element2.alias === elementName);
    if (old === void 0) {
      old = boundarys.find((element2) => element2.alias === elementName);
      if (old === void 0) {
        return;
      }
    }
    if (bgColor !== void 0 && bgColor !== null) {
      if (typeof bgColor === "object") {
        let [key, value] = Object.entries(bgColor)[0];
        old[key] = value;
      } else {
        old.bgColor = bgColor;
      }
    }
    if (fontColor !== void 0 && fontColor !== null) {
      if (typeof fontColor === "object") {
        let [key, value] = Object.entries(fontColor)[0];
        old[key] = value;
      } else {
        old.fontColor = fontColor;
      }
    }
    if (borderColor !== void 0 && borderColor !== null) {
      if (typeof borderColor === "object") {
        let [key, value] = Object.entries(borderColor)[0];
        old[key] = value;
      } else {
        old.borderColor = borderColor;
      }
    }
    if (shadowing !== void 0 && shadowing !== null) {
      if (typeof shadowing === "object") {
        let [key, value] = Object.entries(shadowing)[0];
        old[key] = value;
      } else {
        old.shadowing = shadowing;
      }
    }
    if (shape !== void 0 && shape !== null) {
      if (typeof shape === "object") {
        let [key, value] = Object.entries(shape)[0];
        old[key] = value;
      } else {
        old.shape = shape;
      }
    }
    if (sprite !== void 0 && sprite !== null) {
      if (typeof sprite === "object") {
        let [key, value] = Object.entries(sprite)[0];
        old[key] = value;
      } else {
        old.sprite = sprite;
      }
    }
    if (techn !== void 0 && techn !== null) {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        old[key] = value;
      } else {
        old.techn = techn;
      }
    }
    if (legendText !== void 0 && legendText !== null) {
      if (typeof legendText === "object") {
        let [key, value] = Object.entries(legendText)[0];
        old[key] = value;
      } else {
        old.legendText = legendText;
      }
    }
    if (legendSprite !== void 0 && legendSprite !== null) {
      if (typeof legendSprite === "object") {
        let [key, value] = Object.entries(legendSprite)[0];
        old[key] = value;
      } else {
        old.legendSprite = legendSprite;
      }
    }
  };
  const updateRelStyle = function(typeC4Shape, from2, to2, textColor, lineColor, offsetX, offsetY) {
    const old = rels.find((rel) => rel.from === from2 && rel.to === to2);
    if (old === void 0) {
      return;
    }
    if (textColor !== void 0 && textColor !== null) {
      if (typeof textColor === "object") {
        let [key, value] = Object.entries(textColor)[0];
        old[key] = value;
      } else {
        old.textColor = textColor;
      }
    }
    if (lineColor !== void 0 && lineColor !== null) {
      if (typeof lineColor === "object") {
        let [key, value] = Object.entries(lineColor)[0];
        old[key] = value;
      } else {
        old.lineColor = lineColor;
      }
    }
    if (offsetX !== void 0 && offsetX !== null) {
      if (typeof offsetX === "object") {
        let [key, value] = Object.entries(offsetX)[0];
        old[key] = parseInt(value);
      } else {
        old.offsetX = parseInt(offsetX);
      }
    }
    if (offsetY !== void 0 && offsetY !== null) {
      if (typeof offsetY === "object") {
        let [key, value] = Object.entries(offsetY)[0];
        old[key] = parseInt(value);
      } else {
        old.offsetY = parseInt(offsetY);
      }
    }
  };
  const updateLayoutConfig = function(typeC4Shape, c4ShapeInRowParam, c4BoundaryInRowParam) {
    let c4ShapeInRowValue = c4ShapeInRow$1;
    let c4BoundaryInRowValue = c4BoundaryInRow$1;
    if (typeof c4ShapeInRowParam === "object") {
      const value = Object.values(c4ShapeInRowParam)[0];
      c4ShapeInRowValue = parseInt(value);
    } else {
      c4ShapeInRowValue = parseInt(c4ShapeInRowParam);
    }
    if (typeof c4BoundaryInRowParam === "object") {
      const value = Object.values(c4BoundaryInRowParam)[0];
      c4BoundaryInRowValue = parseInt(value);
    } else {
      c4BoundaryInRowValue = parseInt(c4BoundaryInRowParam);
    }
    if (c4ShapeInRowValue >= 1) {
      c4ShapeInRow$1 = c4ShapeInRowValue;
    }
    if (c4BoundaryInRowValue >= 1) {
      c4BoundaryInRow$1 = c4BoundaryInRowValue;
    }
  };
  const getC4ShapeInRow = function() {
    return c4ShapeInRow$1;
  };
  const getC4BoundaryInRow = function() {
    return c4BoundaryInRow$1;
  };
  const getCurrentBoundaryParse = function() {
    return currentBoundaryParse;
  };
  const getParentBoundaryParse = function() {
    return parentBoundaryParse;
  };
  const getC4ShapeArray = function(parentBoundary) {
    if (parentBoundary === void 0 || parentBoundary === null) {
      return c4ShapeArray;
    } else {
      return c4ShapeArray.filter((personOrSystem) => {
        return personOrSystem.parentBoundary === parentBoundary;
      });
    }
  };
  const getC4Shape = function(alias) {
    return c4ShapeArray.find((personOrSystem) => personOrSystem.alias === alias);
  };
  const getC4ShapeKeys = function(parentBoundary) {
    return Object.keys(getC4ShapeArray(parentBoundary));
  };
  const getBoundarys = function(parentBoundary) {
    if (parentBoundary === void 0 || parentBoundary === null) {
      return boundarys;
    } else {
      return boundarys.filter((boundary) => boundary.parentBoundary === parentBoundary);
    }
  };
  const getRels = function() {
    return rels;
  };
  const getTitle = function() {
    return title;
  };
  const setWrap$1 = function(wrapSetting) {
    wrapEnabled$1 = wrapSetting;
  };
  const autoWrap$1 = function() {
    return wrapEnabled$1;
  };
  const clear$f = function() {
    c4ShapeArray = [];
    boundarys = [
      {
        alias: "global",
        label: { text: "global" },
        type: { text: "global" },
        tags: null,
        link: null,
        parentBoundary: ""
      }
    ];
    parentBoundaryParse = "";
    currentBoundaryParse = "global";
    boundaryParseStack = [""];
    rels = [];
    boundaryParseStack = [""];
    title = "";
    wrapEnabled$1 = false;
    c4ShapeInRow$1 = 4;
    c4BoundaryInRow$1 = 2;
  };
  const LINETYPE$1 = {
    SOLID: 0,
    DOTTED: 1,
    NOTE: 2,
    SOLID_CROSS: 3,
    DOTTED_CROSS: 4,
    SOLID_OPEN: 5,
    DOTTED_OPEN: 6,
    LOOP_START: 10,
    LOOP_END: 11,
    ALT_START: 12,
    ALT_ELSE: 13,
    ALT_END: 14,
    OPT_START: 15,
    OPT_END: 16,
    ACTIVE_START: 17,
    ACTIVE_END: 18,
    PAR_START: 19,
    PAR_AND: 20,
    PAR_END: 21,
    RECT_START: 22,
    RECT_END: 23,
    SOLID_POINT: 24,
    DOTTED_POINT: 25
  };
  const ARROWTYPE$1 = {
    FILLED: 0,
    OPEN: 1
  };
  const PLACEMENT$1 = {
    LEFTOF: 0,
    RIGHTOF: 1,
    OVER: 2
  };
  const setTitle = function(txt) {
    let sanitizedText = sanitizeText$6(txt, getConfig$1());
    title = sanitizedText;
  };
  const c4Db = {
    addPersonOrSystem,
    addPersonOrSystemBoundary,
    addContainer,
    addContainerBoundary,
    addComponent,
    addDeploymentNode,
    popBoundaryParseStack,
    addRel,
    updateElStyle,
    updateRelStyle,
    updateLayoutConfig,
    autoWrap: autoWrap$1,
    setWrap: setWrap$1,
    getC4ShapeArray,
    getC4Shape,
    getC4ShapeKeys,
    getBoundarys,
    getCurrentBoundaryParse,
    getParentBoundaryParse,
    getRels,
    getTitle,
    getC4Type,
    getC4ShapeInRow,
    getC4BoundaryInRow,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    parseDirective: parseDirective$a,
    getConfig: () => getConfig$1().c4,
    clear: clear$f,
    LINETYPE: LINETYPE$1,
    ARROWTYPE: ARROWTYPE$1,
    PLACEMENT: PLACEMENT$1,
    setTitle,
    setC4Type
  };
  const drawRect$3 = function(elem, rectData) {
    const rectElem = elem.append("rect");
    rectElem.attr("x", rectData.x);
    rectElem.attr("y", rectData.y);
    rectElem.attr("fill", rectData.fill);
    rectElem.attr("stroke", rectData.stroke);
    rectElem.attr("width", rectData.width);
    rectElem.attr("height", rectData.height);
    rectElem.attr("rx", rectData.rx);
    rectElem.attr("ry", rectData.ry);
    if (rectData.attrs !== "undefined" && rectData.attrs !== null) {
      for (let attrKey in rectData.attrs) {
        rectElem.attr(attrKey, rectData.attrs[attrKey]);
      }
    }
    if (rectData.class !== "undefined") {
      rectElem.attr("class", rectData.class);
    }
    return rectElem;
  };
  const drawImage$1 = function(elem, width2, height2, x2, y2, link) {
    const imageElem = elem.append("image");
    imageElem.attr("width", width2);
    imageElem.attr("height", height2);
    imageElem.attr("x", x2);
    imageElem.attr("y", y2);
    let sanitizedLink = link.startsWith("data:image/png;base64") ? link : sanitizeUrl_1(link);
    imageElem.attr("xlink:href", sanitizedLink);
  };
  const drawRels$1 = (elem, rels2, conf2) => {
    const relsElem = elem.append("g");
    let i2 = 0;
    for (let rel of rels2) {
      let textColor = rel.textColor ? rel.textColor : "#444444";
      let strokeColor = rel.lineColor ? rel.lineColor : "#444444";
      let offsetX = rel.offsetX ? parseInt(rel.offsetX) : 0;
      let offsetY = rel.offsetY ? parseInt(rel.offsetY) : 0;
      let url = "";
      if (i2 === 0) {
        let line2 = relsElem.append("line");
        line2.attr("x1", rel.startPoint.x);
        line2.attr("y1", rel.startPoint.y);
        line2.attr("x2", rel.endPoint.x);
        line2.attr("y2", rel.endPoint.y);
        line2.attr("stroke-width", "1");
        line2.attr("stroke", strokeColor);
        line2.style("fill", "none");
        if (rel.type !== "rel_b") {
          line2.attr("marker-end", "url(" + url + "#arrowhead)");
        }
        if (rel.type === "birel" || rel.type === "rel_b") {
          line2.attr("marker-start", "url(" + url + "#arrowend)");
        }
        i2 = -1;
      } else {
        let line2 = relsElem.append("path");
        line2.attr("fill", "none").attr("stroke-width", "1").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,starty Qcontrolx,controly stopx,stopy ".replaceAll("startx", rel.startPoint.x).replaceAll("starty", rel.startPoint.y).replaceAll(
            "controlx",
            rel.startPoint.x + (rel.endPoint.x - rel.startPoint.x) / 2 - (rel.endPoint.x - rel.startPoint.x) / 4
          ).replaceAll("controly", rel.startPoint.y + (rel.endPoint.y - rel.startPoint.y) / 2).replaceAll("stopx", rel.endPoint.x).replaceAll("stopy", rel.endPoint.y)
        );
        if (rel.type !== "rel_b") {
          line2.attr("marker-end", "url(" + url + "#arrowhead)");
        }
        if (rel.type === "birel" || rel.type === "rel_b") {
          line2.attr("marker-start", "url(" + url + "#arrowend)");
        }
      }
      let messageConf = conf2.messageFont();
      _drawTextCandidateFunc$3(conf2)(
        rel.label.text,
        relsElem,
        Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
        Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + offsetY,
        rel.label.width,
        rel.label.height,
        { fill: textColor },
        messageConf
      );
      if (rel.techn && rel.techn.text !== "") {
        messageConf = conf2.messageFont();
        _drawTextCandidateFunc$3(conf2)(
          "[" + rel.techn.text + "]",
          relsElem,
          Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
          Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + conf2.messageFontSize + 5 + offsetY,
          Math.max(rel.label.width, rel.techn.width),
          rel.techn.height,
          { fill: textColor, "font-style": "italic" },
          messageConf
        );
      }
    }
  };
  const drawBoundary$1 = function(elem, boundary, conf2) {
    const boundaryElem = elem.append("g");
    let fillColor = boundary.bgColor ? boundary.bgColor : "none";
    let strokeColor = boundary.borderColor ? boundary.borderColor : "#444444";
    let fontColor = boundary.fontColor ? boundary.fontColor : "black";
    let attrsValue = { "stroke-width": 1, "stroke-dasharray": "7.0,7.0" };
    if (boundary.nodeType) {
      attrsValue = { "stroke-width": 1 };
    }
    let rectData = {
      x: boundary.x,
      y: boundary.y,
      fill: fillColor,
      stroke: strokeColor,
      width: boundary.width,
      height: boundary.height,
      rx: 2.5,
      ry: 2.5,
      attrs: attrsValue
    };
    drawRect$3(boundaryElem, rectData);
    let boundaryConf = conf2.boundaryFont();
    boundaryConf.fontWeight = "bold";
    boundaryConf.fontSize = boundaryConf.fontSize + 2;
    boundaryConf.fontColor = fontColor;
    _drawTextCandidateFunc$3(conf2)(
      boundary.label.text,
      boundaryElem,
      boundary.x,
      boundary.y + boundary.label.Y,
      boundary.width,
      boundary.height,
      { fill: "#444444" },
      boundaryConf
    );
    if (boundary.type && boundary.type.text !== "") {
      boundaryConf = conf2.boundaryFont();
      boundaryConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        boundary.type.text,
        boundaryElem,
        boundary.x,
        boundary.y + boundary.type.Y,
        boundary.width,
        boundary.height,
        { fill: "#444444" },
        boundaryConf
      );
    }
    if (boundary.descr && boundary.descr.text !== "") {
      boundaryConf = conf2.boundaryFont();
      boundaryConf.fontSize = boundaryConf.fontSize - 2;
      boundaryConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        boundary.descr.text,
        boundaryElem,
        boundary.x,
        boundary.y + boundary.descr.Y,
        boundary.width,
        boundary.height,
        { fill: "#444444" },
        boundaryConf
      );
    }
  };
  const drawC4Shape = function(elem, c4Shape, conf2) {
    var _a;
    let fillColor = c4Shape.bgColor ? c4Shape.bgColor : conf2[c4Shape.typeC4Shape.text + "_bg_color"];
    let strokeColor = c4Shape.borderColor ? c4Shape.borderColor : conf2[c4Shape.typeC4Shape.text + "_border_color"];
    let fontColor = c4Shape.fontColor ? c4Shape.fontColor : "#FFFFFF";
    let personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
    switch (c4Shape.typeC4Shape.text) {
      case "person":
        personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
        break;
      case "external_person":
        personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAAB6ElEQVR4Xu2YLY+EMBCG9+dWr0aj0Wg0Go1Go0+j8Xdv2uTCvv1gpt0ebHKPuhDaeW4605Z9mJvx4AdXUyTUdd08z+u6flmWZRnHsWkafk9DptAwDPu+f0eAYtu2PEaGWuj5fCIZrBAC2eLBAnRCsEkkxmeaJp7iDJ2QMDdHsLg8SxKFEJaAo8lAXnmuOFIhTMpxxKATebo4UiFknuNo4OniSIXQyRxEA3YsnjGCVEjVXD7yLUAqxBGUyPv/Y4W2beMgGuS7kVQIBycH0fD+oi5pezQETxdHKmQKGk1eQEYldK+jw5GxPfZ9z7Mk0Qnhf1W1m3w//EUn5BDmSZsbR44QQLBEqrBHqOrmSKaQAxdnLArCrxZcM7A7ZKs4ioRq8LFC+NpC3WCBJsvpVw5edm9iEXFuyNfxXAgSwfrFQ1c0iNda8AdejvUgnktOtJQQxmcfFzGglc5WVCj7oDgFqU18boeFSs52CUh8LE8BIVQDT1ABrB0HtgSEYlX5doJnCwv9TXocKCaKbnwhdDKPq4lf3SwU3HLq4V/+WYhHVMa/3b4IlfyikAduCkcBc7mQ3/z/Qq/cTuikhkzB12Ae/mcJC9U+Vo8Ej1gWAtgbeGgFsAMHr50BIWOLCbezvhpBFUdY6EJuJ/QDW0XoMX60zZ0AAAAASUVORK5CYII=";
        break;
    }
    const c4ShapeElem = elem.append("g");
    c4ShapeElem.attr("class", "person-man");
    const rect2 = getNoteRect$3();
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
      case "system":
      case "external_system":
      case "container":
      case "external_container":
      case "component":
      case "external_component":
        rect2.x = c4Shape.x;
        rect2.y = c4Shape.y;
        rect2.fill = fillColor;
        rect2.width = c4Shape.width;
        rect2.height = c4Shape.height;
        rect2.stroke = strokeColor;
        rect2.rx = 2.5;
        rect2.ry = 2.5;
        rect2.attrs = { "stroke-width": 0.5 };
        drawRect$3(c4ShapeElem, rect2);
        break;
      case "system_db":
      case "external_system_db":
      case "container_db":
      case "external_container_db":
      case "component_db":
      case "external_component_db":
        c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc0,-10 half,-10 half,-10c0,0 half,0 half,10l0,heightc0,10 -half,10 -half,10c0,0 -half,0 -half,-10l0,-height".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2).replaceAll("height", c4Shape.height)
        );
        c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc0,10 half,10 half,10c0,0 half,0 half,-10".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2)
        );
        break;
      case "system_queue":
      case "external_system_queue":
      case "container_queue":
      case "external_container_queue":
      case "component_queue":
      case "external_component_queue":
        c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startylwidth,0c5,0 5,half 5,halfc0,0 0,half -5,halfl-width,0c-5,0 -5,-half -5,-halfc0,0 0,-half 5,-half".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("width", c4Shape.width).replaceAll("half", c4Shape.height / 2)
        );
        c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc-5,0 -5,half -5,halfc0,half 5,half 5,half".replaceAll("startx", c4Shape.x + c4Shape.width).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.height / 2)
        );
        break;
    }
    let c4ShapeFontConf = getC4ShapeFont(conf2, c4Shape.typeC4Shape.text);
    c4ShapeElem.append("text").attr("fill", fontColor).attr("font-family", c4ShapeFontConf.fontFamily).attr("font-size", c4ShapeFontConf.fontSize - 2).attr("font-style", "italic").attr("lengthAdjust", "spacing").attr("textLength", c4Shape.typeC4Shape.width).attr("x", c4Shape.x + c4Shape.width / 2 - c4Shape.typeC4Shape.width / 2).attr("y", c4Shape.y + c4Shape.typeC4Shape.Y).text("<<" + c4Shape.typeC4Shape.text + ">>");
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
        drawImage$1(
          c4ShapeElem,
          48,
          48,
          c4Shape.x + c4Shape.width / 2 - 24,
          c4Shape.y + c4Shape.image.Y,
          personImg
        );
        break;
    }
    let textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
    textFontConf.fontWeight = "bold";
    textFontConf.fontSize = textFontConf.fontSize + 2;
    textFontConf.fontColor = fontColor;
    _drawTextCandidateFunc$3(conf2)(
      c4Shape.label.text,
      c4ShapeElem,
      c4Shape.x,
      c4Shape.y + c4Shape.label.Y,
      c4Shape.width,
      c4Shape.height,
      { fill: fontColor },
      textFontConf
    );
    textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
    textFontConf.fontColor = fontColor;
    if (c4Shape.techn && ((_a = c4Shape.techn) == null ? void 0 : _a.text) !== "") {
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.techn.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.techn.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor, "font-style": "italic" },
        textFontConf
      );
    } else if (c4Shape.type && c4Shape.type.text !== "") {
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.type.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.type.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor, "font-style": "italic" },
        textFontConf
      );
    }
    if (c4Shape.descr && c4Shape.descr.text !== "") {
      textFontConf = conf2.personFont();
      textFontConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.descr.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.descr.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor },
        textFontConf
      );
    }
    return c4Shape.height;
  };
  const insertDatabaseIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "database").attr("fill-rule", "evenodd").attr("clip-rule", "evenodd").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M12.258.001l.256.004.255.005.253.008.251.01.249.012.247.015.246.016.242.019.241.02.239.023.236.024.233.027.231.028.229.031.225.032.223.034.22.036.217.038.214.04.211.041.208.043.205.045.201.046.198.048.194.05.191.051.187.053.183.054.18.056.175.057.172.059.168.06.163.061.16.063.155.064.15.066.074.033.073.033.071.034.07.034.069.035.068.035.067.035.066.035.064.036.064.036.062.036.06.036.06.037.058.037.058.037.055.038.055.038.053.038.052.038.051.039.05.039.048.039.047.039.045.04.044.04.043.04.041.04.04.041.039.041.037.041.036.041.034.041.033.042.032.042.03.042.029.042.027.042.026.043.024.043.023.043.021.043.02.043.018.044.017.043.015.044.013.044.012.044.011.045.009.044.007.045.006.045.004.045.002.045.001.045v17l-.001.045-.002.045-.004.045-.006.045-.007.045-.009.044-.011.045-.012.044-.013.044-.015.044-.017.043-.018.044-.02.043-.021.043-.023.043-.024.043-.026.043-.027.042-.029.042-.03.042-.032.042-.033.042-.034.041-.036.041-.037.041-.039.041-.04.041-.041.04-.043.04-.044.04-.045.04-.047.039-.048.039-.05.039-.051.039-.052.038-.053.038-.055.038-.055.038-.058.037-.058.037-.06.037-.06.036-.062.036-.064.036-.064.036-.066.035-.067.035-.068.035-.069.035-.07.034-.071.034-.073.033-.074.033-.15.066-.155.064-.16.063-.163.061-.168.06-.172.059-.175.057-.18.056-.183.054-.187.053-.191.051-.194.05-.198.048-.201.046-.205.045-.208.043-.211.041-.214.04-.217.038-.22.036-.223.034-.225.032-.229.031-.231.028-.233.027-.236.024-.239.023-.241.02-.242.019-.246.016-.247.015-.249.012-.251.01-.253.008-.255.005-.256.004-.258.001-.258-.001-.256-.004-.255-.005-.253-.008-.251-.01-.249-.012-.247-.015-.245-.016-.243-.019-.241-.02-.238-.023-.236-.024-.234-.027-.231-.028-.228-.031-.226-.032-.223-.034-.22-.036-.217-.038-.214-.04-.211-.041-.208-.043-.204-.045-.201-.046-.198-.048-.195-.05-.19-.051-.187-.053-.184-.054-.179-.056-.176-.057-.172-.059-.167-.06-.164-.061-.159-.063-.155-.064-.151-.066-.074-.033-.072-.033-.072-.034-.07-.034-.069-.035-.068-.035-.067-.035-.066-.035-.064-.036-.063-.036-.062-.036-.061-.036-.06-.037-.058-.037-.057-.037-.056-.038-.055-.038-.053-.038-.052-.038-.051-.039-.049-.039-.049-.039-.046-.039-.046-.04-.044-.04-.043-.04-.041-.04-.04-.041-.039-.041-.037-.041-.036-.041-.034-.041-.033-.042-.032-.042-.03-.042-.029-.042-.027-.042-.026-.043-.024-.043-.023-.043-.021-.043-.02-.043-.018-.044-.017-.043-.015-.044-.013-.044-.012-.044-.011-.045-.009-.044-.007-.045-.006-.045-.004-.045-.002-.045-.001-.045v-17l.001-.045.002-.045.004-.045.006-.045.007-.045.009-.044.011-.045.012-.044.013-.044.015-.044.017-.043.018-.044.02-.043.021-.043.023-.043.024-.043.026-.043.027-.042.029-.042.03-.042.032-.042.033-.042.034-.041.036-.041.037-.041.039-.041.04-.041.041-.04.043-.04.044-.04.046-.04.046-.039.049-.039.049-.039.051-.039.052-.038.053-.038.055-.038.056-.038.057-.037.058-.037.06-.037.061-.036.062-.036.063-.036.064-.036.066-.035.067-.035.068-.035.069-.035.07-.034.072-.034.072-.033.074-.033.151-.066.155-.064.159-.063.164-.061.167-.06.172-.059.176-.057.179-.056.184-.054.187-.053.19-.051.195-.05.198-.048.201-.046.204-.045.208-.043.211-.041.214-.04.217-.038.22-.036.223-.034.226-.032.228-.031.231-.028.234-.027.236-.024.238-.023.241-.02.243-.019.245-.016.247-.015.249-.012.251-.01.253-.008.255-.005.256-.004.258-.001.258.001zm-9.258 20.499v.01l.001.021.003.021.004.022.005.021.006.022.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.023.018.024.019.024.021.024.022.025.023.024.024.025.052.049.056.05.061.051.066.051.07.051.075.051.079.052.084.052.088.052.092.052.097.052.102.051.105.052.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.048.144.049.147.047.152.047.155.047.16.045.163.045.167.043.171.043.176.041.178.041.183.039.187.039.19.037.194.035.197.035.202.033.204.031.209.03.212.029.216.027.219.025.222.024.226.021.23.02.233.018.236.016.24.015.243.012.246.01.249.008.253.005.256.004.259.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.021.224-.024.22-.026.216-.027.212-.028.21-.031.205-.031.202-.034.198-.034.194-.036.191-.037.187-.039.183-.04.179-.04.175-.042.172-.043.168-.044.163-.045.16-.046.155-.046.152-.047.148-.048.143-.049.139-.049.136-.05.131-.05.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.053.083-.051.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.05.023-.024.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.023.01-.022.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.127l-.077.055-.08.053-.083.054-.085.053-.087.052-.09.052-.093.051-.095.05-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.045-.118.044-.12.043-.122.042-.124.042-.126.041-.128.04-.13.04-.132.038-.134.038-.135.037-.138.037-.139.035-.142.035-.143.034-.144.033-.147.032-.148.031-.15.03-.151.03-.153.029-.154.027-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.01-.179.008-.179.008-.181.006-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.006-.179-.008-.179-.008-.178-.01-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.027-.153-.029-.151-.03-.15-.03-.148-.031-.146-.032-.145-.033-.143-.034-.141-.035-.14-.035-.137-.037-.136-.037-.134-.038-.132-.038-.13-.04-.128-.04-.126-.041-.124-.042-.122-.042-.12-.044-.117-.043-.116-.045-.113-.045-.112-.046-.109-.047-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.05-.093-.052-.09-.051-.087-.052-.085-.053-.083-.054-.08-.054-.077-.054v4.127zm0-5.654v.011l.001.021.003.021.004.021.005.022.006.022.007.022.009.022.01.022.011.023.012.023.013.023.015.024.016.023.017.024.018.024.019.024.021.024.022.024.023.025.024.024.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.052.11.051.114.051.119.052.123.05.127.051.131.05.135.049.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.044.171.042.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.022.23.02.233.018.236.016.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.012.241-.015.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.048.139-.05.136-.049.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.051.051-.049.023-.025.023-.024.021-.025.02-.024.019-.024.018-.024.017-.024.015-.023.014-.023.013-.024.012-.022.01-.023.01-.023.008-.022.006-.022.006-.022.004-.021.004-.022.001-.021.001-.021v-4.139l-.077.054-.08.054-.083.054-.085.052-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.044-.118.044-.12.044-.122.042-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.035-.143.033-.144.033-.147.033-.148.031-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.009-.179.009-.179.007-.181.007-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.007-.179-.007-.179-.009-.178-.009-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.031-.146-.033-.145-.033-.143-.033-.141-.035-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.04-.126-.041-.124-.042-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.051-.093-.051-.09-.051-.087-.053-.085-.052-.083-.054-.08-.054-.077-.054v4.139zm0-5.666v.011l.001.02.003.022.004.021.005.022.006.021.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.024.018.023.019.024.021.025.022.024.023.024.024.025.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.051.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.043.171.043.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.021.23.02.233.018.236.017.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.013.241-.014.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.049.139-.049.136-.049.131-.051.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.049.023-.025.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.022.01-.023.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.153l-.077.054-.08.054-.083.053-.085.053-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.048-.105.048-.106.048-.109.046-.111.046-.114.046-.115.044-.118.044-.12.043-.122.043-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.034-.143.034-.144.033-.147.032-.148.032-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.024-.161.024-.162.023-.163.023-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.01-.178.01-.179.009-.179.007-.181.006-.182.006-.182.004-.184.003-.184.001-.185.001-.185-.001-.184-.001-.184-.003-.182-.004-.182-.006-.181-.006-.179-.007-.179-.009-.178-.01-.176-.01-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.023-.162-.023-.161-.024-.159-.024-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.032-.146-.032-.145-.033-.143-.034-.141-.034-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.041-.126-.041-.124-.041-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.048-.105-.048-.102-.048-.1-.05-.097-.049-.095-.051-.093-.051-.09-.052-.087-.052-.085-.053-.083-.053-.08-.054-.077-.054v4.153zm8.74-8.179l-.257.004-.254.005-.25.008-.247.011-.244.012-.241.014-.237.016-.233.018-.231.021-.226.022-.224.023-.22.026-.216.027-.212.028-.21.031-.205.032-.202.033-.198.034-.194.036-.191.038-.187.038-.183.04-.179.041-.175.042-.172.043-.168.043-.163.045-.16.046-.155.046-.152.048-.148.048-.143.048-.139.049-.136.05-.131.05-.126.051-.123.051-.118.051-.114.052-.11.052-.106.052-.101.052-.096.052-.092.052-.088.052-.083.052-.079.052-.074.051-.07.052-.065.051-.06.05-.056.05-.051.05-.023.025-.023.024-.021.024-.02.025-.019.024-.018.024-.017.023-.015.024-.014.023-.013.023-.012.023-.01.023-.01.022-.008.022-.006.023-.006.021-.004.022-.004.021-.001.021-.001.021.001.021.001.021.004.021.004.022.006.021.006.023.008.022.01.022.01.023.012.023.013.023.014.023.015.024.017.023.018.024.019.024.02.025.021.024.023.024.023.025.051.05.056.05.06.05.065.051.07.052.074.051.079.052.083.052.088.052.092.052.096.052.101.052.106.052.11.052.114.052.118.051.123.051.126.051.131.05.136.05.139.049.143.048.148.048.152.048.155.046.16.046.163.045.168.043.172.043.175.042.179.041.183.04.187.038.191.038.194.036.198.034.202.033.205.032.21.031.212.028.216.027.22.026.224.023.226.022.231.021.233.018.237.016.241.014.244.012.247.011.25.008.254.005.257.004.26.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.022.224-.023.22-.026.216-.027.212-.028.21-.031.205-.032.202-.033.198-.034.194-.036.191-.038.187-.038.183-.04.179-.041.175-.042.172-.043.168-.043.163-.045.16-.046.155-.046.152-.048.148-.048.143-.048.139-.049.136-.05.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.05.051-.05.023-.025.023-.024.021-.024.02-.025.019-.024.018-.024.017-.023.015-.024.014-.023.013-.023.012-.023.01-.023.01-.022.008-.022.006-.023.006-.021.004-.022.004-.021.001-.021.001-.021-.001-.021-.001-.021-.004-.021-.004-.022-.006-.021-.006-.023-.008-.022-.01-.022-.01-.023-.012-.023-.013-.023-.014-.023-.015-.024-.017-.023-.018-.024-.019-.024-.02-.025-.021-.024-.023-.024-.023-.025-.051-.05-.056-.05-.06-.05-.065-.051-.07-.052-.074-.051-.079-.052-.083-.052-.088-.052-.092-.052-.096-.052-.101-.052-.106-.052-.11-.052-.114-.052-.118-.051-.123-.051-.126-.051-.131-.05-.136-.05-.139-.049-.143-.048-.148-.048-.152-.048-.155-.046-.16-.046-.163-.045-.168-.043-.172-.043-.175-.042-.179-.041-.183-.04-.187-.038-.191-.038-.194-.036-.198-.034-.202-.033-.205-.032-.21-.031-.212-.028-.216-.027-.22-.026-.224-.023-.226-.022-.231-.021-.233-.018-.237-.016-.241-.014-.244-.012-.247-.011-.25-.008-.254-.005-.257-.004-.26-.001-.26.001z"
    );
  };
  const insertComputerIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "computer").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M2 2v13h20v-13h-20zm18 11h-16v-9h16v9zm-10.228 6l.466-1h3.524l.467 1h-4.457zm14.228 3h-24l2-6h2.104l-1.33 4h18.45l-1.297-4h2.073l2 6zm-5-10h-14v-7h14v7z"
    );
  };
  const insertClockIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "clock").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm5.848 12.459c.202.038.202.333.001.372-1.907.361-6.045 1.111-6.547 1.111-.719 0-1.301-.582-1.301-1.301 0-.512.77-5.447 1.125-7.445.034-.192.312-.181.343.014l.985 6.238 5.394 1.011z"
    );
  };
  const insertArrowHead$1 = function(elem) {
    elem.append("defs").append("marker").attr("id", "arrowhead").attr("refX", 9).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z");
  };
  const insertArrowEnd = function(elem) {
    elem.append("defs").append("marker").attr("id", "arrowend").attr("refX", 1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 10 0 L 0 5 L 10 10 z");
  };
  const insertArrowFilledHead$1 = function(elem) {
    elem.append("defs").append("marker").attr("id", "filled-head").attr("refX", 18).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
  };
  const insertDynamicNumber = function(elem) {
    elem.append("defs").append("marker").attr("id", "sequencenumber").attr("refX", 15).attr("refY", 15).attr("markerWidth", 60).attr("markerHeight", 40).attr("orient", "auto").append("circle").attr("cx", 15).attr("cy", 15).attr("r", 6);
  };
  const insertArrowCrossHead$1 = function(elem) {
    const defs2 = elem.append("defs");
    const marker = defs2.append("marker").attr("id", "crosshead").attr("markerWidth", 15).attr("markerHeight", 8).attr("orient", "auto").attr("refX", 16).attr("refY", 4);
    marker.append("path").attr("fill", "black").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 9,2 V 6 L16,4 Z");
    marker.append("path").attr("fill", "none").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 0,1 L 6,7 M 6,1 L 0,7");
  };
  const getNoteRect$3 = function() {
    return {
      x: 0,
      y: 0,
      fill: "#EDF2AE",
      stroke: "#666",
      width: 100,
      anchor: "start",
      height: 100,
      rx: 0,
      ry: 0
    };
  };
  const getC4ShapeFont = (cnf, typeC4Shape) => {
    return {
      fontFamily: cnf[typeC4Shape + "FontFamily"],
      fontSize: cnf[typeC4Shape + "FontSize"],
      fontWeight: cnf[typeC4Shape + "FontWeight"]
    };
  };
  const _drawTextCandidateFunc$3 = function() {
    function byText(content, g, x2, y2, width2, height2, textAttrs) {
      const text2 = g.append("text").attr("x", x2 + width2 / 2).attr("y", y2 + height2 / 2 + 5).style("text-anchor", "middle").text(content);
      _setTextAttrs(text2, textAttrs);
    }
    function byTspan(content, g, x2, y2, width2, height2, textAttrs, conf2) {
      const { fontSize, fontFamily, fontWeight } = conf2;
      const lines = content.split(common$1.lineBreakRegex);
      for (let i2 = 0; i2 < lines.length; i2++) {
        const dy = i2 * fontSize - fontSize * (lines.length - 1) / 2;
        const text2 = g.append("text").attr("x", x2 + width2 / 2).attr("y", y2).style("text-anchor", "middle").attr("dominant-baseline", "middle").style("font-size", fontSize).style("font-weight", fontWeight).style("font-family", fontFamily);
        text2.append("tspan").attr("dy", dy).text(lines[i2]).attr("alignment-baseline", "mathematical");
        _setTextAttrs(text2, textAttrs);
      }
    }
    function byFo(content, g, x2, y2, width2, height2, textAttrs, conf2) {
      const s = g.append("switch");
      const f2 = s.append("foreignObject").attr("x", x2).attr("y", y2).attr("width", width2).attr("height", height2);
      const text2 = f2.append("xhtml:div").style("display", "table").style("height", "100%").style("width", "100%");
      text2.append("div").style("display", "table-cell").style("text-align", "center").style("vertical-align", "middle").text(content);
      byTspan(content, s, x2, y2, width2, height2, textAttrs, conf2);
      _setTextAttrs(text2, textAttrs);
    }
    function _setTextAttrs(toText, fromTextAttrsDict) {
      for (const key in fromTextAttrsDict) {
        if (fromTextAttrsDict.hasOwnProperty(key)) {
          toText.attr(key, fromTextAttrsDict[key]);
        }
      }
    }
    return function(conf2) {
      return conf2.textPlacement === "fo" ? byFo : conf2.textPlacement === "old" ? byText : byTspan;
    };
  }();
  const svgDraw$5 = {
    drawRect: drawRect$3,
    drawBoundary: drawBoundary$1,
    drawC4Shape,
    drawRels: drawRels$1,
    drawImage: drawImage$1,
    insertArrowHead: insertArrowHead$1,
    insertArrowEnd,
    insertArrowFilledHead: insertArrowFilledHead$1,
    insertDynamicNumber,
    insertArrowCrossHead: insertArrowCrossHead$1,
    insertDatabaseIcon: insertDatabaseIcon$1,
    insertComputerIcon: insertComputerIcon$1,
    insertClockIcon: insertClockIcon$1,
    getNoteRect: getNoteRect$3,
    sanitizeUrl: sanitizeUrl_1
  };
  let globalBoundaryMaxX = 0, globalBoundaryMaxY = 0;
  let c4ShapeInRow = 4;
  let c4BoundaryInRow = 2;
  parser$e.yy = c4Db;
  let conf$c = {};
  class Bounds {
    constructor(diagObj) {
      this.name = "";
      this.data = {};
      this.data.startx = void 0;
      this.data.stopx = void 0;
      this.data.starty = void 0;
      this.data.stopy = void 0;
      this.data.widthLimit = void 0;
      this.nextData = {};
      this.nextData.startx = void 0;
      this.nextData.stopx = void 0;
      this.nextData.starty = void 0;
      this.nextData.stopy = void 0;
      this.nextData.cnt = 0;
      setConf$b(diagObj.db.getConfig());
    }
    setData(startx, stopx, starty, stopy) {
      this.nextData.startx = this.data.startx = startx;
      this.nextData.stopx = this.data.stopx = stopx;
      this.nextData.starty = this.data.starty = starty;
      this.nextData.stopy = this.data.stopy = stopy;
    }
    updateVal(obj, key, val, fun) {
      if (obj[key] === void 0) {
        obj[key] = val;
      } else {
        obj[key] = fun(val, obj[key]);
      }
    }
    insert(c4Shape) {
      this.nextData.cnt = this.nextData.cnt + 1;
      let _startx = this.nextData.startx === this.nextData.stopx ? this.nextData.stopx + c4Shape.margin : this.nextData.stopx + c4Shape.margin * 2;
      let _stopx = _startx + c4Shape.width;
      let _starty = this.nextData.starty + c4Shape.margin * 2;
      let _stopy = _starty + c4Shape.height;
      if (_startx >= this.data.widthLimit || _stopx >= this.data.widthLimit || this.nextData.cnt > c4ShapeInRow) {
        _startx = this.nextData.startx + c4Shape.margin + conf$c.nextLinePaddingX;
        _starty = this.nextData.stopy + c4Shape.margin * 2;
        this.nextData.stopx = _stopx = _startx + c4Shape.width;
        this.nextData.starty = this.nextData.stopy;
        this.nextData.stopy = _stopy = _starty + c4Shape.height;
        this.nextData.cnt = 1;
      }
      c4Shape.x = _startx;
      c4Shape.y = _starty;
      this.updateVal(this.data, "startx", _startx, Math.min);
      this.updateVal(this.data, "starty", _starty, Math.min);
      this.updateVal(this.data, "stopx", _stopx, Math.max);
      this.updateVal(this.data, "stopy", _stopy, Math.max);
      this.updateVal(this.nextData, "startx", _startx, Math.min);
      this.updateVal(this.nextData, "starty", _starty, Math.min);
      this.updateVal(this.nextData, "stopx", _stopx, Math.max);
      this.updateVal(this.nextData, "stopy", _stopy, Math.max);
    }
    init(diagObj) {
      this.name = "";
      this.data = {
        startx: void 0,
        stopx: void 0,
        starty: void 0,
        stopy: void 0,
        widthLimit: void 0
      };
      this.nextData = {
        startx: void 0,
        stopx: void 0,
        starty: void 0,
        stopy: void 0,
        cnt: 0
      };
      setConf$b(diagObj.db.getConfig());
    }
    bumpLastMargin(margin) {
      this.data.stopx += margin;
      this.data.stopy += margin;
    }
  }
  const setConf$b = function(cnf) {
    assignWithDepth$1(conf$c, cnf);
    if (cnf.fontFamily) {
      conf$c.personFontFamily = conf$c.systemFontFamily = conf$c.messageFontFamily = cnf.fontFamily;
    }
    if (cnf.fontSize) {
      conf$c.personFontSize = conf$c.systemFontSize = conf$c.messageFontSize = cnf.fontSize;
    }
    if (cnf.fontWeight) {
      conf$c.personFontWeight = conf$c.systemFontWeight = conf$c.messageFontWeight = cnf.fontWeight;
    }
  };
  const c4ShapeFont = (cnf, typeC4Shape) => {
    return {
      fontFamily: cnf[typeC4Shape + "FontFamily"],
      fontSize: cnf[typeC4Shape + "FontSize"],
      fontWeight: cnf[typeC4Shape + "FontWeight"]
    };
  };
  const boundaryFont = (cnf) => {
    return {
      fontFamily: cnf.boundaryFontFamily,
      fontSize: cnf.boundaryFontSize,
      fontWeight: cnf.boundaryFontWeight
    };
  };
  const messageFont$1 = (cnf) => {
    return {
      fontFamily: cnf.messageFontFamily,
      fontSize: cnf.messageFontSize,
      fontWeight: cnf.messageFontWeight
    };
  };
  function calcC4ShapeTextWH(textType, c4Shape, c4ShapeTextWrap, textConf, textLimitWidth) {
    if (!c4Shape[textType].width) {
      if (c4ShapeTextWrap) {
        c4Shape[textType].text = wrapLabel(c4Shape[textType].text, textLimitWidth, textConf);
        c4Shape[textType].textLines = c4Shape[textType].text.split(common$1.lineBreakRegex).length;
        c4Shape[textType].width = textLimitWidth;
        c4Shape[textType].height = calculateTextHeight(c4Shape[textType].text, textConf);
      } else {
        let lines = c4Shape[textType].text.split(common$1.lineBreakRegex);
        c4Shape[textType].textLines = lines.length;
        let lineHeight = 0;
        c4Shape[textType].height = 0;
        c4Shape[textType].width = 0;
        for (const line2 of lines) {
          c4Shape[textType].width = Math.max(
            calculateTextWidth(line2, textConf),
            c4Shape[textType].width
          );
          lineHeight = calculateTextHeight(line2, textConf);
          c4Shape[textType].height = c4Shape[textType].height + lineHeight;
        }
      }
    }
  }
  const drawBoundary = function(diagram2, boundary, bounds2) {
    boundary.x = bounds2.data.startx;
    boundary.y = bounds2.data.starty;
    boundary.width = bounds2.data.stopx - bounds2.data.startx;
    boundary.height = bounds2.data.stopy - bounds2.data.starty;
    boundary.label.y = conf$c.c4ShapeMargin - 35;
    let boundaryTextWrap = boundary.wrap && conf$c.wrap;
    let boundaryLabelConf = boundaryFont(conf$c);
    boundaryLabelConf.fontSize = boundaryLabelConf.fontSize + 2;
    boundaryLabelConf.fontWeight = "bold";
    let textLimitWidth = calculateTextWidth(boundary.label.text, boundaryLabelConf);
    calcC4ShapeTextWH("label", boundary, boundaryTextWrap, boundaryLabelConf, textLimitWidth);
    svgDraw$5.drawBoundary(diagram2, boundary, conf$c);
  };
  const drawC4ShapeArray = function(currentBounds, diagram2, c4ShapeArray2, c4ShapeKeys) {
    let Y = 0;
    for (const c4ShapeKey of c4ShapeKeys) {
      Y = 0;
      const c4Shape = c4ShapeArray2[c4ShapeKey];
      let c4ShapeTypeConf = c4ShapeFont(conf$c, c4Shape.typeC4Shape.text);
      c4ShapeTypeConf.fontSize = c4ShapeTypeConf.fontSize - 2;
      c4Shape.typeC4Shape.width = calculateTextWidth(
        "<<" + c4Shape.typeC4Shape.text + ">>",
        c4ShapeTypeConf
      );
      c4Shape.typeC4Shape.height = c4ShapeTypeConf.fontSize + 2;
      c4Shape.typeC4Shape.Y = conf$c.c4ShapePadding;
      Y = c4Shape.typeC4Shape.Y + c4Shape.typeC4Shape.height - 4;
      c4Shape.image = { width: 0, height: 0, Y: 0 };
      switch (c4Shape.typeC4Shape.text) {
        case "person":
        case "external_person":
          c4Shape.image.width = 48;
          c4Shape.image.height = 48;
          c4Shape.image.Y = Y;
          Y = c4Shape.image.Y + c4Shape.image.height;
          break;
      }
      if (c4Shape.sprite) {
        c4Shape.image.width = 48;
        c4Shape.image.height = 48;
        c4Shape.image.Y = Y;
        Y = c4Shape.image.Y + c4Shape.image.height;
      }
      let c4ShapeTextWrap = c4Shape.wrap && conf$c.wrap;
      let textLimitWidth = conf$c.width - conf$c.c4ShapePadding * 2;
      let c4ShapeLabelConf = c4ShapeFont(conf$c, c4Shape.typeC4Shape.text);
      c4ShapeLabelConf.fontSize = c4ShapeLabelConf.fontSize + 2;
      c4ShapeLabelConf.fontWeight = "bold";
      calcC4ShapeTextWH("label", c4Shape, c4ShapeTextWrap, c4ShapeLabelConf, textLimitWidth);
      c4Shape["label"].Y = Y + 8;
      Y = c4Shape["label"].Y + c4Shape["label"].height;
      if (c4Shape.type && c4Shape.type.text !== "") {
        c4Shape.type.text = "[" + c4Shape.type.text + "]";
        let c4ShapeTypeConf2 = c4ShapeFont(conf$c, c4Shape.typeC4Shape.text);
        calcC4ShapeTextWH("type", c4Shape, c4ShapeTextWrap, c4ShapeTypeConf2, textLimitWidth);
        c4Shape["type"].Y = Y + 5;
        Y = c4Shape["type"].Y + c4Shape["type"].height;
      } else if (c4Shape.techn && c4Shape.techn.text !== "") {
        c4Shape.techn.text = "[" + c4Shape.techn.text + "]";
        let c4ShapeTechnConf = c4ShapeFont(conf$c, c4Shape.techn.text);
        calcC4ShapeTextWH("techn", c4Shape, c4ShapeTextWrap, c4ShapeTechnConf, textLimitWidth);
        c4Shape["techn"].Y = Y + 5;
        Y = c4Shape["techn"].Y + c4Shape["techn"].height;
      }
      let rectHeight = Y;
      let rectWidth = c4Shape.label.width;
      if (c4Shape.descr && c4Shape.descr.text !== "") {
        let c4ShapeDescrConf = c4ShapeFont(conf$c, c4Shape.typeC4Shape.text);
        calcC4ShapeTextWH("descr", c4Shape, c4ShapeTextWrap, c4ShapeDescrConf, textLimitWidth);
        c4Shape["descr"].Y = Y + 20;
        Y = c4Shape["descr"].Y + c4Shape["descr"].height;
        rectWidth = Math.max(c4Shape.label.width, c4Shape.descr.width);
        rectHeight = Y - c4Shape["descr"].textLines * 5;
      }
      rectWidth = rectWidth + conf$c.c4ShapePadding;
      c4Shape.width = Math.max(c4Shape.width || conf$c.width, rectWidth, conf$c.width);
      c4Shape.height = Math.max(c4Shape.height || conf$c.height, rectHeight, conf$c.height);
      c4Shape.margin = c4Shape.margin || conf$c.c4ShapeMargin;
      currentBounds.insert(c4Shape);
      svgDraw$5.drawC4Shape(diagram2, c4Shape, conf$c);
    }
    currentBounds.bumpLastMargin(conf$c.c4ShapeMargin);
  };
  class Point$1 {
    constructor(x2, y2) {
      this.x = x2;
      this.y = y2;
    }
  }
  let getIntersectPoint = function(fromNode, endPoint) {
    let x1 = fromNode.x;
    let y1 = fromNode.y;
    let x2 = endPoint.x;
    let y2 = endPoint.y;
    let fromCenterX = x1 + fromNode.width / 2;
    let fromCenterY = y1 + fromNode.height / 2;
    let dx = Math.abs(x1 - x2);
    let dy = Math.abs(y1 - y2);
    let tanDYX = dy / dx;
    let fromDYX = fromNode.height / fromNode.width;
    let returnPoint = null;
    if (y1 == y2 && x1 < x2) {
      returnPoint = new Point$1(x1 + fromNode.width, fromCenterY);
    } else if (y1 == y2 && x1 > x2) {
      returnPoint = new Point$1(x1, fromCenterY);
    } else if (x1 == x2 && y1 < y2) {
      returnPoint = new Point$1(fromCenterX, y1 + fromNode.height);
    } else if (x1 == x2 && y1 > y2) {
      returnPoint = new Point$1(fromCenterX, y1);
    }
    if (x1 > x2 && y1 < y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1, fromCenterY + tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(
          fromCenterX - dx / dy * fromNode.height / 2,
          y1 + fromNode.height
        );
      }
    } else if (x1 < x2 && y1 < y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1 + fromNode.width, fromCenterY + tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(
          fromCenterX + dx / dy * fromNode.height / 2,
          y1 + fromNode.height
        );
      }
    } else if (x1 < x2 && y1 > y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1 + fromNode.width, fromCenterY - tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(fromCenterX + fromNode.height / 2 * dx / dy, y1);
      }
    } else if (x1 > x2 && y1 > y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1, fromCenterY - fromNode.width / 2 * tanDYX);
      } else {
        returnPoint = new Point$1(fromCenterX - fromNode.height / 2 * dx / dy, y1);
      }
    }
    return returnPoint;
  };
  let getIntersectPoints = function(fromNode, endNode) {
    let endIntersectPoint = { x: 0, y: 0 };
    endIntersectPoint.x = endNode.x + endNode.width / 2;
    endIntersectPoint.y = endNode.y + endNode.height / 2;
    let startPoint = getIntersectPoint(fromNode, endIntersectPoint);
    endIntersectPoint.x = fromNode.x + fromNode.width / 2;
    endIntersectPoint.y = fromNode.y + fromNode.height / 2;
    let endPoint = getIntersectPoint(endNode, endIntersectPoint);
    return { startPoint, endPoint };
  };
  const drawRels = function(diagram2, rels2, getC4ShapeObj, diagObj) {
    let i2 = 0;
    for (let rel of rels2) {
      i2 = i2 + 1;
      let relTextWrap = rel.wrap && conf$c.wrap;
      let relConf = messageFont$1(conf$c);
      let diagramType = diagObj.db.getC4Type();
      if (diagramType === "C4Dynamic") {
        rel.label.text = i2 + ": " + rel.label.text;
      }
      let textLimitWidth = calculateTextWidth(rel.label.text, relConf);
      calcC4ShapeTextWH("label", rel, relTextWrap, relConf, textLimitWidth);
      if (rel.techn && rel.techn.text !== "") {
        textLimitWidth = calculateTextWidth(rel.techn.text, relConf);
        calcC4ShapeTextWH("techn", rel, relTextWrap, relConf, textLimitWidth);
      }
      if (rel.descr && rel.descr.text !== "") {
        textLimitWidth = calculateTextWidth(rel.descr.text, relConf);
        calcC4ShapeTextWH("descr", rel, relTextWrap, relConf, textLimitWidth);
      }
      let fromNode = getC4ShapeObj(rel.from);
      let endNode = getC4ShapeObj(rel.to);
      let points = getIntersectPoints(fromNode, endNode);
      rel.startPoint = points.startPoint;
      rel.endPoint = points.endPoint;
    }
    svgDraw$5.drawRels(diagram2, rels2, conf$c);
  };
  function drawInsideBoundary(diagram2, parentBoundaryAlias, parentBounds, currentBoundaries, diagObj) {
    let currentBounds = new Bounds(diagObj);
    currentBounds.data.widthLimit = parentBounds.data.widthLimit / Math.min(c4BoundaryInRow, currentBoundaries.length);
    for (let [i2, currentBoundary] of currentBoundaries.entries()) {
      let Y = 0;
      currentBoundary.image = { width: 0, height: 0, Y: 0 };
      if (currentBoundary.sprite) {
        currentBoundary.image.width = 48;
        currentBoundary.image.height = 48;
        currentBoundary.image.Y = Y;
        Y = currentBoundary.image.Y + currentBoundary.image.height;
      }
      let currentBoundaryTextWrap = currentBoundary.wrap && conf$c.wrap;
      let currentBoundaryLabelConf = boundaryFont(conf$c);
      currentBoundaryLabelConf.fontSize = currentBoundaryLabelConf.fontSize + 2;
      currentBoundaryLabelConf.fontWeight = "bold";
      calcC4ShapeTextWH(
        "label",
        currentBoundary,
        currentBoundaryTextWrap,
        currentBoundaryLabelConf,
        currentBounds.data.widthLimit
      );
      currentBoundary["label"].Y = Y + 8;
      Y = currentBoundary["label"].Y + currentBoundary["label"].height;
      if (currentBoundary.type && currentBoundary.type.text !== "") {
        currentBoundary.type.text = "[" + currentBoundary.type.text + "]";
        let currentBoundaryTypeConf = boundaryFont(conf$c);
        calcC4ShapeTextWH(
          "type",
          currentBoundary,
          currentBoundaryTextWrap,
          currentBoundaryTypeConf,
          currentBounds.data.widthLimit
        );
        currentBoundary["type"].Y = Y + 5;
        Y = currentBoundary["type"].Y + currentBoundary["type"].height;
      }
      if (currentBoundary.descr && currentBoundary.descr.text !== "") {
        let currentBoundaryDescrConf = boundaryFont(conf$c);
        currentBoundaryDescrConf.fontSize = currentBoundaryDescrConf.fontSize - 2;
        calcC4ShapeTextWH(
          "descr",
          currentBoundary,
          currentBoundaryTextWrap,
          currentBoundaryDescrConf,
          currentBounds.data.widthLimit
        );
        currentBoundary["descr"].Y = Y + 20;
        Y = currentBoundary["descr"].Y + currentBoundary["descr"].height;
      }
      if (i2 == 0 || i2 % c4BoundaryInRow === 0) {
        let _x = parentBounds.data.startx + conf$c.diagramMarginX;
        let _y = parentBounds.data.stopy + conf$c.diagramMarginY + Y;
        currentBounds.setData(_x, _x, _y, _y);
      } else {
        let _x = currentBounds.data.stopx !== currentBounds.data.startx ? currentBounds.data.stopx + conf$c.diagramMarginX : currentBounds.data.startx;
        let _y = currentBounds.data.starty;
        currentBounds.setData(_x, _x, _y, _y);
      }
      currentBounds.name = currentBoundary.alias;
      let currentPersonOrSystemArray = diagObj.db.getC4ShapeArray(currentBoundary.alias);
      let currentPersonOrSystemKeys = diagObj.db.getC4ShapeKeys(currentBoundary.alias);
      if (currentPersonOrSystemKeys.length > 0) {
        drawC4ShapeArray(
          currentBounds,
          diagram2,
          currentPersonOrSystemArray,
          currentPersonOrSystemKeys
        );
      }
      parentBoundaryAlias = currentBoundary.alias;
      let nextCurrentBoundarys = diagObj.db.getBoundarys(parentBoundaryAlias);
      if (nextCurrentBoundarys.length > 0) {
        drawInsideBoundary(
          diagram2,
          parentBoundaryAlias,
          currentBounds,
          nextCurrentBoundarys,
          diagObj
        );
      }
      if (currentBoundary.alias !== "global") {
        drawBoundary(diagram2, currentBoundary, currentBounds);
      }
      parentBounds.data.stopy = Math.max(
        currentBounds.data.stopy + conf$c.c4ShapeMargin,
        parentBounds.data.stopy
      );
      parentBounds.data.stopx = Math.max(
        currentBounds.data.stopx + conf$c.c4ShapeMargin,
        parentBounds.data.stopx
      );
      globalBoundaryMaxX = Math.max(globalBoundaryMaxX, parentBounds.data.stopx);
      globalBoundaryMaxY = Math.max(globalBoundaryMaxY, parentBounds.data.stopy);
    }
  }
  const draw$h = function(_text, id2, _version, diagObj) {
    conf$c = getConfig$1().c4;
    const securityLevel = getConfig$1().securityLevel;
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = select("#i" + id2);
    }
    const root2 = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
    let db2 = diagObj.db;
    diagObj.db.setWrap(conf$c.wrap);
    c4ShapeInRow = db2.getC4ShapeInRow();
    c4BoundaryInRow = db2.getC4BoundaryInRow();
    log$1.debug(`C:${JSON.stringify(conf$c, null, 2)}`);
    const diagram2 = securityLevel === "sandbox" ? root2.select(`[id="${id2}"]`) : select(`[id="${id2}"]`);
    svgDraw$5.insertComputerIcon(diagram2);
    svgDraw$5.insertDatabaseIcon(diagram2);
    svgDraw$5.insertClockIcon(diagram2);
    let screenBounds = new Bounds(diagObj);
    screenBounds.setData(
      conf$c.diagramMarginX,
      conf$c.diagramMarginX,
      conf$c.diagramMarginY,
      conf$c.diagramMarginY
    );
    screenBounds.data.widthLimit = screen.availWidth;
    globalBoundaryMaxX = conf$c.diagramMarginX;
    globalBoundaryMaxY = conf$c.diagramMarginY;
    const title2 = diagObj.db.getTitle();
    let currentBoundaries = diagObj.db.getBoundarys("");
    drawInsideBoundary(diagram2, "", screenBounds, currentBoundaries, diagObj);
    svgDraw$5.insertArrowHead(diagram2);
    svgDraw$5.insertArrowEnd(diagram2);
    svgDraw$5.insertArrowCrossHead(diagram2);
    svgDraw$5.insertArrowFilledHead(diagram2);
    drawRels(diagram2, diagObj.db.getRels(), diagObj.db.getC4Shape, diagObj);
    screenBounds.data.stopx = globalBoundaryMaxX;
    screenBounds.data.stopy = globalBoundaryMaxY;
    const box = screenBounds.data;
    let boxHeight = box.stopy - box.starty;
    let height2 = boxHeight + 2 * conf$c.diagramMarginY;
    let boxWidth = box.stopx - box.startx;
    const width2 = boxWidth + 2 * conf$c.diagramMarginX;
    if (title2) {
      diagram2.append("text").text(title2).attr("x", (box.stopx - box.startx) / 2 - 4 * conf$c.diagramMarginX).attr("y", box.starty + conf$c.diagramMarginY);
    }
    configureSvgSize(diagram2, height2, width2, conf$c.useMaxWidth);
    const extraVertForTitle = title2 ? 60 : 0;
    diagram2.attr(
      "viewBox",
      box.startx - conf$c.diagramMarginX + " -" + (conf$c.diagramMarginY + extraVertForTitle) + " " + width2 + " " + (height2 + extraVertForTitle)
    );
    log$1.debug(`models:`, box);
  };
  const c4Renderer = {
    drawPersonOrSystemArray: drawC4ShapeArray,
    drawBoundary,
    setConf: setConf$b,
    draw: draw$h
  };
  var parser$d = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 3], $V1 = [1, 7], $V2 = [1, 8], $V3 = [1, 9], $V4 = [1, 10], $V5 = [1, 13], $V6 = [1, 12], $V7 = [1, 16, 25], $V8 = [1, 20], $V9 = [1, 32], $Va = [1, 33], $Vb = [1, 34], $Vc = [1, 36], $Vd = [1, 39], $Ve = [1, 37], $Vf = [1, 38], $Vg = [1, 44], $Vh = [1, 45], $Vi = [1, 40], $Vj = [1, 41], $Vk = [1, 42], $Vl = [1, 43], $Vm = [1, 48], $Vn = [1, 49], $Vo = [1, 50], $Vp = [1, 51], $Vq = [16, 25], $Vr = [1, 65], $Vs = [1, 66], $Vt = [1, 67], $Vu = [1, 68], $Vv = [1, 69], $Vw = [1, 70], $Vx = [1, 71], $Vy = [1, 80], $Vz = [16, 25, 32, 45, 46, 54, 60, 61, 62, 63, 64, 65, 66, 71, 73], $VA = [16, 25, 30, 32, 45, 46, 50, 54, 60, 61, 62, 63, 64, 65, 66, 71, 73, 88, 89, 90, 91], $VB = [5, 8, 9, 10, 11, 16, 19, 23, 25], $VC = [54, 88, 89, 90, 91], $VD = [54, 65, 66, 88, 89, 90, 91], $VE = [54, 60, 61, 62, 63, 64, 88, 89, 90, 91], $VF = [16, 25, 32], $VG = [1, 107];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "statments": 5, "direction": 6, "directive": 7, "direction_tb": 8, "direction_bt": 9, "direction_rl": 10, "direction_lr": 11, "graphConfig": 12, "openDirective": 13, "typeDirective": 14, "closeDirective": 15, "NEWLINE": 16, ":": 17, "argDirective": 18, "open_directive": 19, "type_directive": 20, "arg_directive": 21, "close_directive": 22, "CLASS_DIAGRAM": 23, "statements": 24, "EOF": 25, "statement": 26, "className": 27, "alphaNumToken": 28, "classLiteralName": 29, "GENERICTYPE": 30, "relationStatement": 31, "LABEL": 32, "classStatement": 33, "methodStatement": 34, "annotationStatement": 35, "clickStatement": 36, "cssClassStatement": 37, "noteStatement": 38, "acc_title": 39, "acc_title_value": 40, "acc_descr": 41, "acc_descr_value": 42, "acc_descr_multiline_value": 43, "CLASS": 44, "STYLE_SEPARATOR": 45, "STRUCT_START": 46, "members": 47, "STRUCT_STOP": 48, "ANNOTATION_START": 49, "ANNOTATION_END": 50, "MEMBER": 51, "SEPARATOR": 52, "relation": 53, "STR": 54, "NOTE_FOR": 55, "noteText": 56, "NOTE": 57, "relationType": 58, "lineType": 59, "AGGREGATION": 60, "EXTENSION": 61, "COMPOSITION": 62, "DEPENDENCY": 63, "LOLLIPOP": 64, "LINE": 65, "DOTTED_LINE": 66, "CALLBACK": 67, "LINK": 68, "LINK_TARGET": 69, "CLICK": 70, "CALLBACK_NAME": 71, "CALLBACK_ARGS": 72, "HREF": 73, "CSSCLASS": 74, "commentToken": 75, "textToken": 76, "graphCodeTokens": 77, "textNoTagsToken": 78, "TAGSTART": 79, "TAGEND": 80, "==": 81, "--": 82, "PCT": 83, "DEFAULT": 84, "SPACE": 85, "MINUS": 86, "keywords": 87, "UNICODE_TEXT": 88, "NUM": 89, "ALPHA": 90, "BQUOTE_STR": 91, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 5: "statments", 8: "direction_tb", 9: "direction_bt", 10: "direction_rl", 11: "direction_lr", 16: "NEWLINE", 17: ":", 19: "open_directive", 20: "type_directive", 21: "arg_directive", 22: "close_directive", 23: "CLASS_DIAGRAM", 25: "EOF", 30: "GENERICTYPE", 32: "LABEL", 39: "acc_title", 40: "acc_title_value", 41: "acc_descr", 42: "acc_descr_value", 43: "acc_descr_multiline_value", 44: "CLASS", 45: "STYLE_SEPARATOR", 46: "STRUCT_START", 48: "STRUCT_STOP", 49: "ANNOTATION_START", 50: "ANNOTATION_END", 51: "MEMBER", 52: "SEPARATOR", 54: "STR", 55: "NOTE_FOR", 57: "NOTE", 60: "AGGREGATION", 61: "EXTENSION", 62: "COMPOSITION", 63: "DEPENDENCY", 64: "LOLLIPOP", 65: "LINE", 66: "DOTTED_LINE", 67: "CALLBACK", 68: "LINK", 69: "LINK_TARGET", 70: "CLICK", 71: "CALLBACK_NAME", 72: "CALLBACK_ARGS", 73: "HREF", 74: "CSSCLASS", 77: "graphCodeTokens", 79: "TAGSTART", 80: "TAGEND", 81: "==", 82: "--", 83: "PCT", 84: "DEFAULT", 85: "SPACE", 86: "MINUS", 87: "keywords", 88: "UNICODE_TEXT", 89: "NUM", 90: "ALPHA", 91: "BQUOTE_STR" },
      productions_: [0, [3, 1], [3, 1], [3, 1], [3, 2], [6, 1], [6, 1], [6, 1], [6, 1], [4, 1], [7, 4], [7, 6], [13, 1], [14, 1], [18, 1], [15, 1], [12, 4], [24, 1], [24, 2], [24, 3], [27, 1], [27, 1], [27, 2], [27, 2], [27, 2], [26, 1], [26, 2], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 2], [26, 2], [26, 1], [33, 2], [33, 4], [33, 5], [33, 7], [35, 4], [47, 1], [47, 2], [34, 1], [34, 2], [34, 1], [34, 1], [31, 3], [31, 4], [31, 4], [31, 5], [38, 3], [38, 2], [53, 3], [53, 2], [53, 2], [53, 1], [58, 1], [58, 1], [58, 1], [58, 1], [58, 1], [59, 1], [59, 1], [36, 3], [36, 4], [36, 3], [36, 4], [36, 4], [36, 5], [36, 3], [36, 4], [36, 4], [36, 5], [36, 3], [36, 4], [36, 4], [36, 5], [37, 3], [75, 1], [75, 1], [76, 1], [76, 1], [76, 1], [76, 1], [76, 1], [76, 1], [76, 1], [78, 1], [78, 1], [78, 1], [78, 1], [28, 1], [28, 1], [28, 1], [29, 1], [56, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 5:
            yy.setDirection("TB");
            break;
          case 6:
            yy.setDirection("BT");
            break;
          case 7:
            yy.setDirection("RL");
            break;
          case 8:
            yy.setDirection("LR");
            break;
          case 12:
            yy.parseDirective("%%{", "open_directive");
            break;
          case 13:
            yy.parseDirective($$[$0], "type_directive");
            break;
          case 14:
            $$[$0] = $$[$0].trim().replace(/'/g, '"');
            yy.parseDirective($$[$0], "arg_directive");
            break;
          case 15:
            yy.parseDirective("}%%", "close_directive", "class");
            break;
          case 20:
          case 21:
            this.$ = $$[$0];
            break;
          case 22:
            this.$ = $$[$0 - 1] + $$[$0];
            break;
          case 23:
          case 24:
            this.$ = $$[$0 - 1] + "~" + $$[$0];
            break;
          case 25:
            yy.addRelation($$[$0]);
            break;
          case 26:
            $$[$0 - 1].title = yy.cleanupLabel($$[$0]);
            yy.addRelation($$[$0 - 1]);
            break;
          case 35:
            this.$ = $$[$0].trim();
            yy.setAccTitle(this.$);
            break;
          case 36:
          case 37:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 38:
            yy.addClass($$[$0]);
            break;
          case 39:
            yy.addClass($$[$0 - 2]);
            yy.setCssClass($$[$0 - 2], $$[$0]);
            break;
          case 40:
            yy.addClass($$[$0 - 3]);
            yy.addMembers($$[$0 - 3], $$[$0 - 1]);
            break;
          case 41:
            yy.addClass($$[$0 - 5]);
            yy.setCssClass($$[$0 - 5], $$[$0 - 3]);
            yy.addMembers($$[$0 - 5], $$[$0 - 1]);
            break;
          case 42:
            yy.addAnnotation($$[$0], $$[$0 - 2]);
            break;
          case 43:
            this.$ = [$$[$0]];
            break;
          case 44:
            $$[$0].push($$[$0 - 1]);
            this.$ = $$[$0];
            break;
          case 45:
            break;
          case 46:
            yy.addMember($$[$0 - 1], yy.cleanupLabel($$[$0]));
            break;
          case 47:
            break;
          case 48:
            break;
          case 49:
            this.$ = { "id1": $$[$0 - 2], "id2": $$[$0], relation: $$[$0 - 1], relationTitle1: "none", relationTitle2: "none" };
            break;
          case 50:
            this.$ = { id1: $$[$0 - 3], id2: $$[$0], relation: $$[$0 - 1], relationTitle1: $$[$0 - 2], relationTitle2: "none" };
            break;
          case 51:
            this.$ = { id1: $$[$0 - 3], id2: $$[$0], relation: $$[$0 - 2], relationTitle1: "none", relationTitle2: $$[$0 - 1] };
            break;
          case 52:
            this.$ = { id1: $$[$0 - 4], id2: $$[$0], relation: $$[$0 - 2], relationTitle1: $$[$0 - 3], relationTitle2: $$[$0 - 1] };
            break;
          case 53:
            yy.addNote($$[$0], $$[$0 - 1]);
            break;
          case 54:
            yy.addNote($$[$0]);
            break;
          case 55:
            this.$ = { type1: $$[$0 - 2], type2: $$[$0], lineType: $$[$0 - 1] };
            break;
          case 56:
            this.$ = { type1: "none", type2: $$[$0], lineType: $$[$0 - 1] };
            break;
          case 57:
            this.$ = { type1: $$[$0 - 1], type2: "none", lineType: $$[$0] };
            break;
          case 58:
            this.$ = { type1: "none", type2: "none", lineType: $$[$0] };
            break;
          case 59:
            this.$ = yy.relationType.AGGREGATION;
            break;
          case 60:
            this.$ = yy.relationType.EXTENSION;
            break;
          case 61:
            this.$ = yy.relationType.COMPOSITION;
            break;
          case 62:
            this.$ = yy.relationType.DEPENDENCY;
            break;
          case 63:
            this.$ = yy.relationType.LOLLIPOP;
            break;
          case 64:
            this.$ = yy.lineType.LINE;
            break;
          case 65:
            this.$ = yy.lineType.DOTTED_LINE;
            break;
          case 66:
          case 72:
            this.$ = $$[$0 - 2];
            yy.setClickEvent($$[$0 - 1], $$[$0]);
            break;
          case 67:
          case 73:
            this.$ = $$[$0 - 3];
            yy.setClickEvent($$[$0 - 2], $$[$0 - 1]);
            yy.setTooltip($$[$0 - 2], $$[$0]);
            break;
          case 68:
          case 76:
            this.$ = $$[$0 - 2];
            yy.setLink($$[$0 - 1], $$[$0]);
            break;
          case 69:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 2], $$[$0 - 1], $$[$0]);
            break;
          case 70:
          case 78:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 2], $$[$0 - 1]);
            yy.setTooltip($$[$0 - 2], $$[$0]);
            break;
          case 71:
          case 79:
            this.$ = $$[$0 - 4];
            yy.setLink($$[$0 - 3], $$[$0 - 2], $$[$0]);
            yy.setTooltip($$[$0 - 3], $$[$0 - 1]);
            break;
          case 74:
            this.$ = $$[$0 - 3];
            yy.setClickEvent($$[$0 - 2], $$[$0 - 1], $$[$0]);
            break;
          case 75:
            this.$ = $$[$0 - 4];
            yy.setClickEvent($$[$0 - 3], $$[$0 - 2], $$[$0 - 1]);
            yy.setTooltip($$[$0 - 3], $$[$0]);
            break;
          case 77:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 2], $$[$0 - 1], $$[$0]);
            break;
          case 80:
            yy.setCssClass($$[$0 - 1], $$[$0]);
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 5: $V0, 6: 4, 7: 5, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 12: 6, 13: 11, 19: $V5, 23: $V6 }, { 1: [3] }, { 1: [2, 1] }, { 1: [2, 2] }, { 1: [2, 3] }, { 3: 14, 4: 2, 5: $V0, 6: 4, 7: 5, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 12: 6, 13: 11, 19: $V5, 23: $V6 }, { 1: [2, 9] }, o($V7, [2, 5]), o($V7, [2, 6]), o($V7, [2, 7]), o($V7, [2, 8]), { 14: 15, 20: [1, 16] }, { 16: [1, 17] }, { 20: [2, 12] }, { 1: [2, 4] }, { 15: 18, 17: [1, 19], 22: $V8 }, o([17, 22], [2, 13]), { 6: 31, 7: 30, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 13: 11, 19: $V5, 24: 21, 26: 22, 27: 35, 28: 46, 29: 47, 31: 23, 33: 24, 34: 25, 35: 26, 36: 27, 37: 28, 38: 29, 39: $V9, 41: $Va, 43: $Vb, 44: $Vc, 49: $Vd, 51: $Ve, 52: $Vf, 55: $Vg, 57: $Vh, 67: $Vi, 68: $Vj, 70: $Vk, 74: $Vl, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 16: [1, 52] }, { 18: 53, 21: [1, 54] }, { 16: [2, 15] }, { 25: [1, 55] }, { 16: [1, 56], 25: [2, 17] }, o($Vq, [2, 25], { 32: [1, 57] }), o($Vq, [2, 27]), o($Vq, [2, 28]), o($Vq, [2, 29]), o($Vq, [2, 30]), o($Vq, [2, 31]), o($Vq, [2, 32]), o($Vq, [2, 33]), o($Vq, [2, 34]), { 40: [1, 58] }, { 42: [1, 59] }, o($Vq, [2, 37]), o($Vq, [2, 45], { 53: 60, 58: 63, 59: 64, 32: [1, 62], 54: [1, 61], 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv, 65: $Vw, 66: $Vx }), { 27: 72, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($Vq, [2, 47]), o($Vq, [2, 48]), { 28: 73, 88: $Vm, 89: $Vn, 90: $Vo }, { 27: 74, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 27: 75, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 27: 76, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 54: [1, 77] }, { 27: 78, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 54: $Vy, 56: 79 }, o($Vz, [2, 20], { 28: 46, 29: 47, 27: 81, 30: [1, 82], 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }), o($Vz, [2, 21], { 30: [1, 83] }), o($VA, [2, 94]), o($VA, [2, 95]), o($VA, [2, 96]), o([16, 25, 30, 32, 45, 46, 54, 60, 61, 62, 63, 64, 65, 66, 71, 73], [2, 97]), o($VB, [2, 10]), { 15: 84, 22: $V8 }, { 22: [2, 14] }, { 1: [2, 16] }, { 6: 31, 7: 30, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 13: 11, 19: $V5, 24: 85, 25: [2, 18], 26: 22, 27: 35, 28: 46, 29: 47, 31: 23, 33: 24, 34: 25, 35: 26, 36: 27, 37: 28, 38: 29, 39: $V9, 41: $Va, 43: $Vb, 44: $Vc, 49: $Vd, 51: $Ve, 52: $Vf, 55: $Vg, 57: $Vh, 67: $Vi, 68: $Vj, 70: $Vk, 74: $Vl, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($Vq, [2, 26]), o($Vq, [2, 35]), o($Vq, [2, 36]), { 27: 86, 28: 46, 29: 47, 54: [1, 87], 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 53: 88, 58: 63, 59: 64, 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv, 65: $Vw, 66: $Vx }, o($Vq, [2, 46]), { 59: 89, 65: $Vw, 66: $Vx }, o($VC, [2, 58], { 58: 90, 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv }), o($VD, [2, 59]), o($VD, [2, 60]), o($VD, [2, 61]), o($VD, [2, 62]), o($VD, [2, 63]), o($VE, [2, 64]), o($VE, [2, 65]), o($Vq, [2, 38], { 45: [1, 91], 46: [1, 92] }), { 50: [1, 93] }, { 54: [1, 94] }, { 54: [1, 95] }, { 71: [1, 96], 73: [1, 97] }, { 28: 98, 88: $Vm, 89: $Vn, 90: $Vo }, { 54: $Vy, 56: 99 }, o($Vq, [2, 54]), o($Vq, [2, 98]), o($Vz, [2, 22]), o($Vz, [2, 23]), o($Vz, [2, 24]), { 16: [1, 100] }, { 25: [2, 19] }, o($VF, [2, 49]), { 27: 101, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 27: 102, 28: 46, 29: 47, 54: [1, 103], 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($VC, [2, 57], { 58: 104, 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv }), o($VC, [2, 56]), { 28: 105, 88: $Vm, 89: $Vn, 90: $Vo }, { 47: 106, 51: $VG }, { 27: 108, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($Vq, [2, 66], { 54: [1, 109] }), o($Vq, [2, 68], { 54: [1, 111], 69: [1, 110] }), o($Vq, [2, 72], { 54: [1, 112], 72: [1, 113] }), o($Vq, [2, 76], { 54: [1, 115], 69: [1, 114] }), o($Vq, [2, 80]), o($Vq, [2, 53]), o($VB, [2, 11]), o($VF, [2, 51]), o($VF, [2, 50]), { 27: 116, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($VC, [2, 55]), o($Vq, [2, 39], { 46: [1, 117] }), { 48: [1, 118] }, { 47: 119, 48: [2, 43], 51: $VG }, o($Vq, [2, 42]), o($Vq, [2, 67]), o($Vq, [2, 69]), o($Vq, [2, 70], { 69: [1, 120] }), o($Vq, [2, 73]), o($Vq, [2, 74], { 54: [1, 121] }), o($Vq, [2, 77]), o($Vq, [2, 78], { 69: [1, 122] }), o($VF, [2, 52]), { 47: 123, 51: $VG }, o($Vq, [2, 40]), { 48: [2, 44] }, o($Vq, [2, 71]), o($Vq, [2, 75]), o($Vq, [2, 79]), { 48: [1, 124] }, o($Vq, [2, 41])],
      defaultActions: { 2: [2, 1], 3: [2, 2], 4: [2, 3], 6: [2, 9], 13: [2, 12], 14: [2, 4], 20: [2, 15], 54: [2, 14], 55: [2, 16], 85: [2, 19], 119: [2, 44] },
      parseError: function parseError2(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error2 = new Error(str2);
          error2.hash = hash;
          throw error2;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state, action, r, yyval = {}, p2, len, newState, expected;
        while (true) {
          state = stack[stack.length - 1];
          if (this.defaultActions[state]) {
            action = this.defaultActions[state];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state] && table[state][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p2 in table[state]) {
              if (this.terminals_[p2] && p2 > TERROR) {
                expected.push("'" + this.terminals_[p2] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError2(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        more: function() {
          this._more = true;
          return this;
        },
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        test_match: function(match5, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match5[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match5[0].length
          };
          this.yytext += match5[0];
          this.match += match5[0];
          this.matches = match5;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match5[0].length);
          this.matched += match5[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match5, tempMatch, index;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match5 || tempMatch[0].length > match5[0].length)) {
              match5 = tempMatch;
              index = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match5 = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match5) {
            token2 = this.test_match(match5, rules[index]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: {},
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              this.begin("open_directive");
              return 19;
            case 1:
              return 8;
            case 2:
              return 9;
            case 3:
              return 10;
            case 4:
              return 11;
            case 5:
              this.begin("type_directive");
              return 20;
            case 6:
              this.popState();
              this.begin("arg_directive");
              return 17;
            case 7:
              this.popState();
              this.popState();
              return 22;
            case 8:
              return 21;
            case 9:
              break;
            case 10:
              break;
            case 11:
              this.begin("acc_title");
              return 39;
            case 12:
              this.popState();
              return "acc_title_value";
            case 13:
              this.begin("acc_descr");
              return 41;
            case 14:
              this.popState();
              return "acc_descr_value";
            case 15:
              this.begin("acc_descr_multiline");
              break;
            case 16:
              this.popState();
              break;
            case 17:
              return "acc_descr_multiline_value";
            case 18:
              return 16;
            case 19:
              break;
            case 20:
              return 23;
            case 21:
              return 23;
            case 22:
              this.begin("struct");
              return 46;
            case 23:
              return "EDGE_STATE";
            case 24:
              return "EOF_IN_STRUCT";
            case 25:
              return "OPEN_IN_STRUCT";
            case 26:
              this.popState();
              return 48;
            case 27:
              break;
            case 28:
              return "MEMBER";
            case 29:
              return 44;
            case 30:
              return 74;
            case 31:
              return 67;
            case 32:
              return 68;
            case 33:
              return 70;
            case 34:
              return 55;
            case 35:
              return 57;
            case 36:
              return 49;
            case 37:
              return 50;
            case 38:
              this.begin("generic");
              break;
            case 39:
              this.popState();
              break;
            case 40:
              return "GENERICTYPE";
            case 41:
              this.begin("string");
              break;
            case 42:
              this.popState();
              break;
            case 43:
              return "STR";
            case 44:
              this.begin("bqstring");
              break;
            case 45:
              this.popState();
              break;
            case 46:
              return "BQUOTE_STR";
            case 47:
              this.begin("href");
              break;
            case 48:
              this.popState();
              break;
            case 49:
              return 73;
            case 50:
              this.begin("callback_name");
              break;
            case 51:
              this.popState();
              break;
            case 52:
              this.popState();
              this.begin("callback_args");
              break;
            case 53:
              return 71;
            case 54:
              this.popState();
              break;
            case 55:
              return 72;
            case 56:
              return 69;
            case 57:
              return 69;
            case 58:
              return 69;
            case 59:
              return 69;
            case 60:
              return 61;
            case 61:
              return 61;
            case 62:
              return 63;
            case 63:
              return 63;
            case 64:
              return 62;
            case 65:
              return 60;
            case 66:
              return 64;
            case 67:
              return 65;
            case 68:
              return 66;
            case 69:
              return 32;
            case 70:
              return 45;
            case 71:
              return 86;
            case 72:
              return "DOT";
            case 73:
              return "PLUS";
            case 74:
              return 83;
            case 75:
              return "EQUALS";
            case 76:
              return "EQUALS";
            case 77:
              return 90;
            case 78:
              return "PUNCTUATION";
            case 79:
              return 89;
            case 80:
              return 88;
            case 81:
              return 85;
            case 82:
              return 25;
          }
        },
        rules: [/^(?:%%\{)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:%%(?!\{)*[^\n]*(\r?\n?)+)/, /^(?:%%[^\n]*(\r?\n)*)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:\s*(\r?\n)+)/, /^(?:\s+)/, /^(?:classDiagram-v2\b)/, /^(?:classDiagram\b)/, /^(?:[{])/, /^(?:\[\*\])/, /^(?:$)/, /^(?:[{])/, /^(?:[}])/, /^(?:[\n])/, /^(?:[^{}\n]*)/, /^(?:class\b)/, /^(?:cssClass\b)/, /^(?:callback\b)/, /^(?:link\b)/, /^(?:click\b)/, /^(?:note for\b)/, /^(?:note\b)/, /^(?:<<)/, /^(?:>>)/, /^(?:[~])/, /^(?:[~])/, /^(?:[^~]*)/, /^(?:["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:[`])/, /^(?:[`])/, /^(?:[^`]+)/, /^(?:href[\s]+["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:call[\s]+)/, /^(?:\([\s]*\))/, /^(?:\()/, /^(?:[^(]*)/, /^(?:\))/, /^(?:[^)]*)/, /^(?:_self\b)/, /^(?:_blank\b)/, /^(?:_parent\b)/, /^(?:_top\b)/, /^(?:\s*<\|)/, /^(?:\s*\|>)/, /^(?:\s*>)/, /^(?:\s*<)/, /^(?:\s*\*)/, /^(?:\s*o\b)/, /^(?:\s*\(\))/, /^(?:--)/, /^(?:\.\.)/, /^(?::{1}[^:\n;]+)/, /^(?::{3})/, /^(?:-)/, /^(?:\.)/, /^(?:\+)/, /^(?:%)/, /^(?:=)/, /^(?:=)/, /^(?:\w+)/, /^(?:[!"#$%&'*+,-.`?\\/])/, /^(?:[0-9]+)/, /^(?:[\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6]|[\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377]|[\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5]|[\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA]|[\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE]|[\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA]|[\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0]|[\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977]|[\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2]|[\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A]|[\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39]|[\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8]|[\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C]|[\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C]|[\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99]|[\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0]|[\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D]|[\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3]|[\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10]|[\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1]|[\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81]|[\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3]|[\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6]|[\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A]|[\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081]|[\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D]|[\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0]|[\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310]|[\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C]|[\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711]|[\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7]|[\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C]|[\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16]|[\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF]|[\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC]|[\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D]|[\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D]|[\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3]|[\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F]|[\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128]|[\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184]|[\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3]|[\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6]|[\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE]|[\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C]|[\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D]|[\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC]|[\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B]|[\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788]|[\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805]|[\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB]|[\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28]|[\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5]|[\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4]|[\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E]|[\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D]|[\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36]|[\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D]|[\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC]|[\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF]|[\uFFD2-\uFFD7\uFFDA-\uFFDC])/, /^(?:\s)/, /^(?:$)/],
        conditions: { "acc_descr_multiline": { "rules": [16, 17], "inclusive": false }, "acc_descr": { "rules": [14], "inclusive": false }, "acc_title": { "rules": [12], "inclusive": false }, "arg_directive": { "rules": [7, 8], "inclusive": false }, "type_directive": { "rules": [6, 7], "inclusive": false }, "open_directive": { "rules": [5], "inclusive": false }, "callback_args": { "rules": [54, 55], "inclusive": false }, "callback_name": { "rules": [51, 52, 53], "inclusive": false }, "href": { "rules": [48, 49], "inclusive": false }, "struct": { "rules": [23, 24, 25, 26, 27, 28], "inclusive": false }, "generic": { "rules": [39, 40], "inclusive": false }, "bqstring": { "rules": [45, 46], "inclusive": false }, "string": { "rules": [42, 43], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 3, 4, 9, 10, 11, 13, 15, 18, 19, 20, 21, 22, 23, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 41, 44, 47, 50, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$d.parser = parser$d;
  const classParser = parser$d;
  const classDetector = (txt, config2) => {
    var _a;
    if (((_a = config2 == null ? void 0 : config2.class) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return txt.match(/^\s*classDiagram/) !== null;
  };
  const classDetectorV2 = (txt, config2) => {
    var _a;
    if (txt.match(/^\s*classDiagram/) !== null && ((_a = config2 == null ? void 0 : config2.class) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return txt.match(/^\s*classDiagram-v2/) !== null;
  };
  const MERMAID_DOM_ID_PREFIX$1 = "classid-";
  let relations$1 = [];
  let classes$2 = {};
  let notes = [];
  let classCounter = 0;
  let funs$2 = [];
  const sanitizeText$3 = (txt) => common$1.sanitizeText(txt, getConfig$1());
  const parseDirective$9 = function(statement, context, type2) {
    mermaidAPI.parseDirective(this, statement, context, type2);
  };
  const splitClassNameAndType = function(id2) {
    let genericType = "";
    let className = id2;
    if (id2.indexOf("~") > 0) {
      let split = id2.split("~");
      className = split[0];
      genericType = common$1.sanitizeText(split[1], getConfig$1());
    }
    return { className, type: genericType };
  };
  const addClass$1 = function(id2) {
    let classId = splitClassNameAndType(id2);
    if (classes$2[classId.className] !== void 0) {
      return;
    }
    classes$2[classId.className] = {
      id: classId.className,
      type: classId.type,
      cssClasses: [],
      methods: [],
      members: [],
      annotations: [],
      domId: MERMAID_DOM_ID_PREFIX$1 + classId.className + "-" + classCounter
    };
    classCounter++;
  };
  const lookUpDomId$1 = function(id2) {
    const classKeys = Object.keys(classes$2);
    for (const classKey of classKeys) {
      if (classes$2[classKey].id === id2) {
        return classes$2[classKey].domId;
      }
    }
  };
  const clear$e = function() {
    relations$1 = [];
    classes$2 = {};
    notes = [];
    funs$2 = [];
    funs$2.push(setupToolTips$1);
    clear$i();
  };
  const getClass = function(id2) {
    return classes$2[id2];
  };
  const getClasses$6 = function() {
    return classes$2;
  };
  const getRelations$1 = function() {
    return relations$1;
  };
  const getNotes = function() {
    return notes;
  };
  const addRelation$1 = function(relation) {
    log$1.debug("Adding relation: " + JSON.stringify(relation));
    addClass$1(relation.id1);
    addClass$1(relation.id2);
    relation.id1 = splitClassNameAndType(relation.id1).className;
    relation.id2 = splitClassNameAndType(relation.id2).className;
    relation.relationTitle1 = common$1.sanitizeText(
      relation.relationTitle1.trim(),
      getConfig$1()
    );
    relation.relationTitle2 = common$1.sanitizeText(
      relation.relationTitle2.trim(),
      getConfig$1()
    );
    relations$1.push(relation);
  };
  const addAnnotation = function(className, annotation) {
    const validatedClassName = splitClassNameAndType(className).className;
    classes$2[validatedClassName].annotations.push(annotation);
  };
  const addMember = function(className, member) {
    const validatedClassName = splitClassNameAndType(className).className;
    const theClass = classes$2[validatedClassName];
    if (typeof member === "string") {
      const memberString = member.trim();
      if (memberString.startsWith("<<") && memberString.endsWith(">>")) {
        theClass.annotations.push(sanitizeText$3(memberString.substring(2, memberString.length - 2)));
      } else if (memberString.indexOf(")") > 0) {
        theClass.methods.push(sanitizeText$3(memberString));
      } else if (memberString) {
        theClass.members.push(sanitizeText$3(memberString));
      }
    }
  };
  const addMembers = function(className, members) {
    if (Array.isArray(members)) {
      members.reverse();
      members.forEach((member) => addMember(className, member));
    }
  };
  const addNote$1 = function(text2, className) {
    const note2 = {
      id: `note${notes.length}`,
      class: className,
      text: text2
    };
    notes.push(note2);
  };
  const cleanupLabel$1 = function(label) {
    if (label.substring(0, 1) === ":") {
      return common$1.sanitizeText(label.substr(1).trim(), getConfig$1());
    } else {
      return sanitizeText$3(label.trim());
    }
  };
  const setCssClass$1 = function(ids, className) {
    ids.split(",").forEach(function(_id) {
      let id2 = _id;
      if (_id[0].match(/\d/)) {
        id2 = MERMAID_DOM_ID_PREFIX$1 + id2;
      }
      if (classes$2[id2] !== void 0) {
        classes$2[id2].cssClasses.push(className);
      }
    });
  };
  const setTooltip$1 = function(ids, tooltip) {
    const config2 = getConfig$1();
    ids.split(",").forEach(function(id2) {
      if (tooltip !== void 0) {
        classes$2[id2].tooltip = common$1.sanitizeText(tooltip, config2);
      }
    });
  };
  const getTooltip$1 = function(id2) {
    return classes$2[id2].tooltip;
  };
  const setLink$2 = function(ids, linkStr, target) {
    const config2 = getConfig$1();
    ids.split(",").forEach(function(_id) {
      let id2 = _id;
      if (_id[0].match(/\d/)) {
        id2 = MERMAID_DOM_ID_PREFIX$1 + id2;
      }
      if (classes$2[id2] !== void 0) {
        classes$2[id2].link = utils.formatUrl(linkStr, config2);
        if (config2.securityLevel === "sandbox") {
          classes$2[id2].linkTarget = "_top";
        } else if (typeof target === "string") {
          classes$2[id2].linkTarget = sanitizeText$3(target);
        } else {
          classes$2[id2].linkTarget = "_blank";
        }
      }
    });
    setCssClass$1(ids, "clickable");
  };
  const setClickEvent$2 = function(ids, functionName, functionArgs) {
    ids.split(",").forEach(function(id2) {
      setClickFunc(id2, functionName, functionArgs);
      classes$2[id2].haveCallback = true;
    });
    setCssClass$1(ids, "clickable");
  };
  const setClickFunc = function(domId, functionName, functionArgs) {
    const config2 = getConfig$1();
    let id2 = domId;
    let elemId = lookUpDomId$1(id2);
    if (config2.securityLevel !== "loose") {
      return;
    }
    if (functionName === void 0) {
      return;
    }
    if (classes$2[id2] !== void 0) {
      let argList = [];
      if (typeof functionArgs === "string") {
        argList = functionArgs.split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
        for (let i2 = 0; i2 < argList.length; i2++) {
          let item = argList[i2].trim();
          if (item.charAt(0) === '"' && item.charAt(item.length - 1) === '"') {
            item = item.substr(1, item.length - 2);
          }
          argList[i2] = item;
        }
      }
      if (argList.length === 0) {
        argList.push(elemId);
      }
      funs$2.push(function() {
        const elem = document.querySelector(`[id="${elemId}"]`);
        if (elem !== null) {
          elem.addEventListener(
            "click",
            function() {
              utils.runFunc(functionName, ...argList);
            },
            false
          );
        }
      });
    }
  };
  const bindFunctions$2 = function(element2) {
    funs$2.forEach(function(fun) {
      fun(element2);
    });
  };
  const lineType$1 = {
    LINE: 0,
    DOTTED_LINE: 1
  };
  const relationType$1 = {
    AGGREGATION: 0,
    EXTENSION: 1,
    COMPOSITION: 2,
    DEPENDENCY: 3,
    LOLLIPOP: 4
  };
  const setupToolTips$1 = function(element2) {
    let tooltipElem = select(".mermaidTooltip");
    if ((tooltipElem._groups || tooltipElem)[0][0] === null) {
      tooltipElem = select("body").append("div").attr("class", "mermaidTooltip").style("opacity", 0);
    }
    const svg2 = select(element2).select("svg");
    const nodes2 = svg2.selectAll("g.node");
    nodes2.on("mouseover", function() {
      const el = select(this);
      const title2 = el.attr("title");
      if (title2 === null) {
        return;
      }
      const rect2 = this.getBoundingClientRect();
      tooltipElem.transition().duration(200).style("opacity", ".9");
      tooltipElem.text(el.attr("title")).style("left", window.scrollX + rect2.left + (rect2.right - rect2.left) / 2 + "px").style("top", window.scrollY + rect2.top - 14 + document.body.scrollTop + "px");
      tooltipElem.html(tooltipElem.html().replace(/&lt;br\/&gt;/g, "<br/>"));
      el.classed("hover", true);
    }).on("mouseout", function() {
      tooltipElem.transition().duration(500).style("opacity", 0);
      const el = select(this);
      el.classed("hover", false);
    });
  };
  funs$2.push(setupToolTips$1);
  let direction$2 = "TB";
  const getDirection$2 = () => direction$2;
  const setDirection$2 = (dir) => {
    direction$2 = dir;
  };
  const classDb = {
    parseDirective: parseDirective$9,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    getConfig: () => getConfig$1().class,
    addClass: addClass$1,
    bindFunctions: bindFunctions$2,
    clear: clear$e,
    getClass,
    getClasses: getClasses$6,
    getNotes,
    addAnnotation,
    addNote: addNote$1,
    getRelations: getRelations$1,
    addRelation: addRelation$1,
    getDirection: getDirection$2,
    setDirection: setDirection$2,
    addMember,
    addMembers,
    cleanupLabel: cleanupLabel$1,
    lineType: lineType$1,
    relationType: relationType$1,
    setClickEvent: setClickEvent$2,
    setCssClass: setCssClass$1,
    setLink: setLink$2,
    getTooltip: getTooltip$1,
    setTooltip: setTooltip$1,
    lookUpDomId: lookUpDomId$1,
    setDiagramTitle,
    getDiagramTitle
  };
  function isObjectLike$2(value) {
    return value != null && typeof value == "object";
  }
  var symbolTag$4 = "[object Symbol]";
  function isSymbol$6(value) {
    return typeof value == "symbol" || isObjectLike$2(value) && baseGetTag$3(value) == symbolTag$4;
  }
  function arrayMap$3(array2, iteratee) {
    var index = -1, length2 = array2 == null ? 0 : array2.length, result = Array(length2);
    while (++index < length2) {
      result[index] = iteratee(array2[index], index, array2);
    }
    return result;
  }
  var isArray$5 = Array.isArray;
  const isArray$6 = isArray$5;
  var INFINITY$5 = 1 / 0;
  var symbolProto$3 = Symbol$6 ? Symbol$6.prototype : void 0, symbolToString$1 = symbolProto$3 ? symbolProto$3.toString : void 0;
  function baseToString$2(value) {
    if (typeof value == "string") {
      return value;
    }
    if (isArray$6(value)) {
      return arrayMap$3(value, baseToString$2) + "";
    }
    if (isSymbol$6(value)) {
      return symbolToString$1 ? symbolToString$1.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY$5 ? "-0" : result;
  }
  var reWhitespace$1 = /\s/;
  function trimmedEndIndex$2(string2) {
    var index = string2.length;
    while (index-- && reWhitespace$1.test(string2.charAt(index))) {
    }
    return index;
  }
  var reTrimStart$1 = /^\s+/;
  function baseTrim$2(string2) {
    return string2 ? string2.slice(0, trimmedEndIndex$2(string2) + 1).replace(reTrimStart$1, "") : string2;
  }
  var NAN$1 = 0 / 0;
  var reIsBadHex$1 = /^[-+]0x[0-9a-f]+$/i;
  var reIsBinary$1 = /^0b[01]+$/i;
  var reIsOctal$1 = /^0o[0-7]+$/i;
  var freeParseInt$1 = parseInt;
  function toNumber$2(value) {
    if (typeof value == "number") {
      return value;
    }
    if (isSymbol$6(value)) {
      return NAN$1;
    }
    if (isObject$6(value)) {
      var other = typeof value.valueOf == "function" ? value.valueOf() : value;
      value = isObject$6(other) ? other + "" : other;
    }
    if (typeof value != "string") {
      return value === 0 ? value : +value;
    }
    value = baseTrim$2(value);
    var isBinary2 = reIsBinary$1.test(value);
    return isBinary2 || reIsOctal$1.test(value) ? freeParseInt$1(value.slice(2), isBinary2 ? 2 : 8) : reIsBadHex$1.test(value) ? NAN$1 : +value;
  }
  var INFINITY$4 = 1 / 0, MAX_INTEGER = 17976931348623157e292;
  function toFinite(value) {
    if (!value) {
      return value === 0 ? value : 0;
    }
    value = toNumber$2(value);
    if (value === INFINITY$4 || value === -INFINITY$4) {
      var sign2 = value < 0 ? -1 : 1;
      return sign2 * MAX_INTEGER;
    }
    return value === value ? value : 0;
  }
  function toInteger(value) {
    var result = toFinite(value), remainder = result % 1;
    return result === result ? remainder ? result - remainder : result : 0;
  }
  function identity$1(value) {
    return value;
  }
  var WeakMap = getNative$4(root$6, "WeakMap");
  const WeakMap$1 = WeakMap;
  var objectCreate = Object.create;
  var baseCreate = function() {
    function object2() {
    }
    return function(proto2) {
      if (!isObject$6(proto2)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto2);
      }
      object2.prototype = proto2;
      var result = new object2();
      object2.prototype = void 0;
      return result;
    };
  }();
  const baseCreate$1 = baseCreate;
  function apply$1(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }
  function noop$2() {
  }
  function copyArray$3(source, array2) {
    var index = -1, length2 = source.length;
    array2 || (array2 = Array(length2));
    while (++index < length2) {
      array2[index] = source[index];
    }
    return array2;
  }
  var HOT_COUNT = 800, HOT_SPAN = 16;
  var nativeNow = Date.now;
  function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
      var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
      lastCalled = stamp;
      if (remaining > 0) {
        if (++count >= HOT_COUNT) {
          return arguments[0];
        }
      } else {
        count = 0;
      }
      return func.apply(void 0, arguments);
    };
  }
  function constant(value) {
    return function() {
      return value;
    };
  }
  var defineProperty$2 = function() {
    try {
      var func = getNative$4(Object, "defineProperty");
      func({}, "", {});
      return func;
    } catch (e) {
    }
  }();
  const defineProperty$3 = defineProperty$2;
  var baseSetToString = !defineProperty$3 ? identity$1 : function(func, string2) {
    return defineProperty$3(func, "toString", {
      "configurable": true,
      "enumerable": false,
      "value": constant(string2),
      "writable": true
    });
  };
  const baseSetToString$1 = baseSetToString;
  var setToString = shortOut(baseSetToString$1);
  const setToString$1 = setToString;
  function arrayEach(array2, iteratee) {
    var index = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index < length2) {
      if (iteratee(array2[index], index, array2) === false) {
        break;
      }
    }
    return array2;
  }
  function baseFindIndex(array2, predicate, fromIndex, fromRight) {
    var length2 = array2.length, index = fromIndex + (fromRight ? 1 : -1);
    while (fromRight ? index-- : ++index < length2) {
      if (predicate(array2[index], index, array2)) {
        return index;
      }
    }
    return -1;
  }
  function baseIsNaN(value) {
    return value !== value;
  }
  function strictIndexOf(array2, value, fromIndex) {
    var index = fromIndex - 1, length2 = array2.length;
    while (++index < length2) {
      if (array2[index] === value) {
        return index;
      }
    }
    return -1;
  }
  function baseIndexOf(array2, value, fromIndex) {
    return value === value ? strictIndexOf(array2, value, fromIndex) : baseFindIndex(array2, baseIsNaN, fromIndex);
  }
  function arrayIncludes(array2, value) {
    var length2 = array2 == null ? 0 : array2.length;
    return !!length2 && baseIndexOf(array2, value, 0) > -1;
  }
  var MAX_SAFE_INTEGER$2 = 9007199254740991;
  var reIsUint$1 = /^(?:0|[1-9]\d*)$/;
  function isIndex$2(value, length2) {
    var type2 = typeof value;
    length2 = length2 == null ? MAX_SAFE_INTEGER$2 : length2;
    return !!length2 && (type2 == "number" || type2 != "symbol" && reIsUint$1.test(value)) && (value > -1 && value % 1 == 0 && value < length2);
  }
  function baseAssignValue$2(object2, key, value) {
    if (key == "__proto__" && defineProperty$3) {
      defineProperty$3(object2, key, {
        "configurable": true,
        "enumerable": true,
        "value": value,
        "writable": true
      });
    } else {
      object2[key] = value;
    }
  }
  var objectProto$j = Object.prototype;
  var hasOwnProperty$g = objectProto$j.hasOwnProperty;
  function assignValue$2(object2, key, value) {
    var objValue = object2[key];
    if (!(hasOwnProperty$g.call(object2, key) && eq$3(objValue, value)) || value === void 0 && !(key in object2)) {
      baseAssignValue$2(object2, key, value);
    }
  }
  function copyObject(source, props, object2, customizer) {
    var isNew = !object2;
    object2 || (object2 = {});
    var index = -1, length2 = props.length;
    while (++index < length2) {
      var key = props[index];
      var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : void 0;
      if (newValue === void 0) {
        newValue = source[key];
      }
      if (isNew) {
        baseAssignValue$2(object2, key, newValue);
      } else {
        assignValue$2(object2, key, newValue);
      }
    }
    return object2;
  }
  var nativeMax$3 = Math.max;
  function overRest(func, start2, transform) {
    start2 = nativeMax$3(start2 === void 0 ? func.length - 1 : start2, 0);
    return function() {
      var args = arguments, index = -1, length2 = nativeMax$3(args.length - start2, 0), array2 = Array(length2);
      while (++index < length2) {
        array2[index] = args[start2 + index];
      }
      index = -1;
      var otherArgs = Array(start2 + 1);
      while (++index < start2) {
        otherArgs[index] = args[index];
      }
      otherArgs[start2] = transform(array2);
      return apply$1(func, this, otherArgs);
    };
  }
  function baseRest(func, start2) {
    return setToString$1(overRest(func, start2, identity$1), func + "");
  }
  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER$1;
  }
  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction$2(value);
  }
  function isIterateeCall(value, index, object2) {
    if (!isObject$6(object2)) {
      return false;
    }
    var type2 = typeof index;
    if (type2 == "number" ? isArrayLike(object2) && isIndex$2(index, object2.length) : type2 == "string" && index in object2) {
      return eq$3(object2[index], value);
    }
    return false;
  }
  function createAssigner(assigner) {
    return baseRest(function(object2, sources) {
      var index = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : void 0, guard = length2 > 2 ? sources[2] : void 0;
      customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        customizer = length2 < 3 ? void 0 : customizer;
        length2 = 1;
      }
      object2 = Object(object2);
      while (++index < length2) {
        var source = sources[index];
        if (source) {
          assigner(object2, source, index, customizer);
        }
      }
      return object2;
    });
  }
  var objectProto$i = Object.prototype;
  function isPrototype(value) {
    var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto$i;
    return value === proto2;
  }
  function baseTimes(n, iteratee) {
    var index = -1, result = Array(n);
    while (++index < n) {
      result[index] = iteratee(index);
    }
    return result;
  }
  var argsTag$3 = "[object Arguments]";
  function baseIsArguments(value) {
    return isObjectLike$2(value) && baseGetTag$3(value) == argsTag$3;
  }
  var objectProto$h = Object.prototype;
  var hasOwnProperty$f = objectProto$h.hasOwnProperty;
  var propertyIsEnumerable$1 = objectProto$h.propertyIsEnumerable;
  var isArguments = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value) {
    return isObjectLike$2(value) && hasOwnProperty$f.call(value, "callee") && !propertyIsEnumerable$1.call(value, "callee");
  };
  const isArguments$1 = isArguments;
  function stubFalse() {
    return false;
  }
  var freeExports$2 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$2 = freeExports$2 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
  var Buffer$1 = moduleExports$2 ? root$6.Buffer : void 0;
  var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : void 0;
  var isBuffer = nativeIsBuffer || stubFalse;
  const isBuffer$1 = isBuffer;
  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", funcTag$2 = "[object Function]", mapTag$6 = "[object Map]", numberTag$3 = "[object Number]", objectTag$4 = "[object Object]", regexpTag$3 = "[object RegExp]", setTag$6 = "[object Set]", stringTag$3 = "[object String]", weakMapTag$2 = "[object WeakMap]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$3] = typedArrayTags[boolTag$3] = typedArrayTags[dataViewTag$4] = typedArrayTags[dateTag$3] = typedArrayTags[errorTag$2] = typedArrayTags[funcTag$2] = typedArrayTags[mapTag$6] = typedArrayTags[numberTag$3] = typedArrayTags[objectTag$4] = typedArrayTags[regexpTag$3] = typedArrayTags[setTag$6] = typedArrayTags[stringTag$3] = typedArrayTags[weakMapTag$2] = false;
  function baseIsTypedArray(value) {
    return isObjectLike$2(value) && isLength(value.length) && !!typedArrayTags[baseGetTag$3(value)];
  }
  function baseUnary(func) {
    return function(value) {
      return func(value);
    };
  }
  var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
  var freeProcess = moduleExports$1 && freeGlobal$3.process;
  var nodeUtil = function() {
    try {
      var types2 = freeModule$1 && freeModule$1.require && freeModule$1.require("util").types;
      if (types2) {
        return types2;
      }
      return freeProcess && freeProcess.binding && freeProcess.binding("util");
    } catch (e) {
    }
  }();
  const nodeUtil$1 = nodeUtil;
  var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
  var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
  const isTypedArray$1 = isTypedArray;
  var objectProto$g = Object.prototype;
  var hasOwnProperty$e = objectProto$g.hasOwnProperty;
  function arrayLikeKeys(value, inherited) {
    var isArr = isArray$6(value), isArg = !isArr && isArguments$1(value), isBuff = !isArr && !isArg && isBuffer$1(value), isType = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length2 = result.length;
    for (var key in value) {
      if ((inherited || hasOwnProperty$e.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex$2(key, length2)))) {
        result.push(key);
      }
    }
    return result;
  }
  function overArg(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  var nativeKeys = overArg(Object.keys, Object);
  const nativeKeys$1 = nativeKeys;
  var objectProto$f = Object.prototype;
  var hasOwnProperty$d = objectProto$f.hasOwnProperty;
  function baseKeys(object2) {
    if (!isPrototype(object2)) {
      return nativeKeys$1(object2);
    }
    var result = [];
    for (var key in Object(object2)) {
      if (hasOwnProperty$d.call(object2, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  function keys$1(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2) : baseKeys(object2);
  }
  function nativeKeysIn(object2) {
    var result = [];
    if (object2 != null) {
      for (var key in Object(object2)) {
        result.push(key);
      }
    }
    return result;
  }
  var objectProto$e = Object.prototype;
  var hasOwnProperty$c = objectProto$e.hasOwnProperty;
  function baseKeysIn(object2) {
    if (!isObject$6(object2)) {
      return nativeKeysIn(object2);
    }
    var isProto = isPrototype(object2), result = [];
    for (var key in object2) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty$c.call(object2, key)))) {
        result.push(key);
      }
    }
    return result;
  }
  function keysIn(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2, true) : baseKeysIn(object2);
  }
  var reIsDeepProp$1 = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp$1 = /^\w*$/;
  function isKey$2(value, object2) {
    if (isArray$6(value)) {
      return false;
    }
    var type2 = typeof value;
    if (type2 == "number" || type2 == "symbol" || type2 == "boolean" || value == null || isSymbol$6(value)) {
      return true;
    }
    return reIsPlainProp$1.test(value) || !reIsDeepProp$1.test(value) || object2 != null && value in Object(object2);
  }
  var MAX_MEMOIZE_SIZE$1 = 500;
  function memoizeCapped$2(func) {
    var result = memoize$3(func, function(key) {
      if (cache2.size === MAX_MEMOIZE_SIZE$1) {
        cache2.clear();
      }
      return key;
    });
    var cache2 = result.cache;
    return result;
  }
  var rePropName$1 = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
  var reEscapeChar$1 = /\\(\\)?/g;
  var stringToPath$3 = memoizeCapped$2(function(string2) {
    var result = [];
    if (string2.charCodeAt(0) === 46) {
      result.push("");
    }
    string2.replace(rePropName$1, function(match5, number2, quote, subString) {
      result.push(quote ? subString.replace(reEscapeChar$1, "$1") : number2 || match5);
    });
    return result;
  });
  const stringToPath$4 = stringToPath$3;
  function toString$4(value) {
    return value == null ? "" : baseToString$2(value);
  }
  function castPath$3(value, object2) {
    if (isArray$6(value)) {
      return value;
    }
    return isKey$2(value, object2) ? [value] : stringToPath$4(toString$4(value));
  }
  var INFINITY$3 = 1 / 0;
  function toKey$4(value) {
    if (typeof value == "string" || isSymbol$6(value)) {
      return value;
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY$3 ? "-0" : result;
  }
  function baseGet$2(object2, path2) {
    path2 = castPath$3(path2, object2);
    var index = 0, length2 = path2.length;
    while (object2 != null && index < length2) {
      object2 = object2[toKey$4(path2[index++])];
    }
    return index && index == length2 ? object2 : void 0;
  }
  function get$3(object2, path2, defaultValue) {
    var result = object2 == null ? void 0 : baseGet$2(object2, path2);
    return result === void 0 ? defaultValue : result;
  }
  function arrayPush(array2, values2) {
    var index = -1, length2 = values2.length, offset2 = array2.length;
    while (++index < length2) {
      array2[offset2 + index] = values2[index];
    }
    return array2;
  }
  var spreadableSymbol = Symbol$6 ? Symbol$6.isConcatSpreadable : void 0;
  function isFlattenable(value) {
    return isArray$6(value) || isArguments$1(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }
  function baseFlatten(array2, depth, predicate, isStrict, result) {
    var index = -1, length2 = array2.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);
    while (++index < length2) {
      var value = array2[index];
      if (depth > 0 && predicate(value)) {
        if (depth > 1) {
          baseFlatten(value, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush(result, value);
        }
      } else if (!isStrict) {
        result[result.length] = value;
      }
    }
    return result;
  }
  function flatten(array2) {
    var length2 = array2 == null ? 0 : array2.length;
    return length2 ? baseFlatten(array2, 1) : [];
  }
  function flatRest(func) {
    return setToString$1(overRest(func, void 0, flatten), func + "");
  }
  var getPrototype = overArg(Object.getPrototypeOf, Object);
  const getPrototype$1 = getPrototype;
  var objectTag$3 = "[object Object]";
  var funcProto$2 = Function.prototype, objectProto$d = Object.prototype;
  var funcToString$2 = funcProto$2.toString;
  var hasOwnProperty$b = objectProto$d.hasOwnProperty;
  var objectCtorString = funcToString$2.call(Object);
  function isPlainObject(value) {
    if (!isObjectLike$2(value) || baseGetTag$3(value) != objectTag$3) {
      return false;
    }
    var proto2 = getPrototype$1(value);
    if (proto2 === null) {
      return true;
    }
    var Ctor = hasOwnProperty$b.call(proto2, "constructor") && proto2.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString$2.call(Ctor) == objectCtorString;
  }
  function arrayReduce(array2, iteratee, accumulator, initAccum) {
    var index = -1, length2 = array2 == null ? 0 : array2.length;
    if (initAccum && length2) {
      accumulator = array2[++index];
    }
    while (++index < length2) {
      accumulator = iteratee(accumulator, array2[index], index, array2);
    }
    return accumulator;
  }
  function stackClear() {
    this.__data__ = new ListCache$2();
    this.size = 0;
  }
  function stackDelete(key) {
    var data2 = this.__data__, result = data2["delete"](key);
    this.size = data2.size;
    return result;
  }
  function stackGet(key) {
    return this.__data__.get(key);
  }
  function stackHas(key) {
    return this.__data__.has(key);
  }
  var LARGE_ARRAY_SIZE$1 = 200;
  function stackSet(key, value) {
    var data2 = this.__data__;
    if (data2 instanceof ListCache$2) {
      var pairs2 = data2.__data__;
      if (!Map$5 || pairs2.length < LARGE_ARRAY_SIZE$1 - 1) {
        pairs2.push([key, value]);
        this.size = ++data2.size;
        return this;
      }
      data2 = this.__data__ = new MapCache$2(pairs2);
    }
    data2.set(key, value);
    this.size = data2.size;
    return this;
  }
  function Stack(entries) {
    var data2 = this.__data__ = new ListCache$2(entries);
    this.size = data2.size;
  }
  Stack.prototype.clear = stackClear;
  Stack.prototype["delete"] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;
  function baseAssign(object2, source) {
    return object2 && copyObject(source, keys$1(source), object2);
  }
  function baseAssignIn(object2, source) {
    return object2 && copyObject(source, keysIn(source), object2);
  }
  var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports = freeModule && freeModule.exports === freeExports;
  var Buffer2 = moduleExports ? root$6.Buffer : void 0, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : void 0;
  function cloneBuffer(buffer, isDeep) {
    if (isDeep) {
      return buffer.slice();
    }
    var length2 = buffer.length, result = allocUnsafe ? allocUnsafe(length2) : new buffer.constructor(length2);
    buffer.copy(result);
    return result;
  }
  function arrayFilter(array2, predicate) {
    var index = -1, length2 = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
    while (++index < length2) {
      var value = array2[index];
      if (predicate(value, index, array2)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }
  function stubArray() {
    return [];
  }
  var objectProto$c = Object.prototype;
  var propertyIsEnumerable = objectProto$c.propertyIsEnumerable;
  var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
  var getSymbols = !nativeGetSymbols$1 ? stubArray : function(object2) {
    if (object2 == null) {
      return [];
    }
    object2 = Object(object2);
    return arrayFilter(nativeGetSymbols$1(object2), function(symbol) {
      return propertyIsEnumerable.call(object2, symbol);
    });
  };
  const getSymbols$1 = getSymbols;
  function copySymbols(source, object2) {
    return copyObject(source, getSymbols$1(source), object2);
  }
  var nativeGetSymbols = Object.getOwnPropertySymbols;
  var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object2) {
    var result = [];
    while (object2) {
      arrayPush(result, getSymbols$1(object2));
      object2 = getPrototype$1(object2);
    }
    return result;
  };
  const getSymbolsIn$1 = getSymbolsIn;
  function copySymbolsIn(source, object2) {
    return copyObject(source, getSymbolsIn$1(source), object2);
  }
  function baseGetAllKeys(object2, keysFunc, symbolsFunc) {
    var result = keysFunc(object2);
    return isArray$6(object2) ? result : arrayPush(result, symbolsFunc(object2));
  }
  function getAllKeys(object2) {
    return baseGetAllKeys(object2, keys$1, getSymbols$1);
  }
  function getAllKeysIn(object2) {
    return baseGetAllKeys(object2, keysIn, getSymbolsIn$1);
  }
  var DataView$1 = getNative$4(root$6, "DataView");
  const DataView$2 = DataView$1;
  var Promise$2 = getNative$4(root$6, "Promise");
  const Promise$3 = Promise$2;
  var Set$2 = getNative$4(root$6, "Set");
  const Set$3 = Set$2;
  var mapTag$5 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$5 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
  var dataViewTag$3 = "[object DataView]";
  var dataViewCtorString = toSource$2(DataView$2), mapCtorString = toSource$2(Map$5), promiseCtorString = toSource$2(Promise$3), setCtorString = toSource$2(Set$3), weakMapCtorString = toSource$2(WeakMap$1);
  var getTag = baseGetTag$3;
  if (DataView$2 && getTag(new DataView$2(new ArrayBuffer(1))) != dataViewTag$3 || Map$5 && getTag(new Map$5()) != mapTag$5 || Promise$3 && getTag(Promise$3.resolve()) != promiseTag || Set$3 && getTag(new Set$3()) != setTag$5 || WeakMap$1 && getTag(new WeakMap$1()) != weakMapTag$1) {
    getTag = function(value) {
      var result = baseGetTag$3(value), Ctor = result == objectTag$2 ? value.constructor : void 0, ctorString = Ctor ? toSource$2(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$3;
          case mapCtorString:
            return mapTag$5;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$5;
          case weakMapCtorString:
            return weakMapTag$1;
        }
      }
      return result;
    };
  }
  const getTag$1 = getTag;
  var objectProto$b = Object.prototype;
  var hasOwnProperty$a = objectProto$b.hasOwnProperty;
  function initCloneArray(array2) {
    var length2 = array2.length, result = new array2.constructor(length2);
    if (length2 && typeof array2[0] == "string" && hasOwnProperty$a.call(array2, "index")) {
      result.index = array2.index;
      result.input = array2.input;
    }
    return result;
  }
  var Uint8Array$1 = root$6.Uint8Array;
  const Uint8Array$2 = Uint8Array$1;
  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$2(result).set(new Uint8Array$2(arrayBuffer));
    return result;
  }
  function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
  }
  var reFlags = /\w*$/;
  function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
  }
  var symbolProto$2 = Symbol$6 ? Symbol$6.prototype : void 0, symbolValueOf$1 = symbolProto$2 ? symbolProto$2.valueOf : void 0;
  function cloneSymbol(symbol) {
    return symbolValueOf$1 ? Object(symbolValueOf$1.call(symbol)) : {};
  }
  function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  }
  var boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", mapTag$4 = "[object Map]", numberTag$2 = "[object Number]", regexpTag$2 = "[object RegExp]", setTag$4 = "[object Set]", stringTag$2 = "[object String]", symbolTag$3 = "[object Symbol]";
  var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]", float32Tag$1 = "[object Float32Array]", float64Tag$1 = "[object Float64Array]", int8Tag$1 = "[object Int8Array]", int16Tag$1 = "[object Int16Array]", int32Tag$1 = "[object Int32Array]", uint8Tag$1 = "[object Uint8Array]", uint8ClampedTag$1 = "[object Uint8ClampedArray]", uint16Tag$1 = "[object Uint16Array]", uint32Tag$1 = "[object Uint32Array]";
  function initCloneByTag(object2, tag, isDeep) {
    var Ctor = object2.constructor;
    switch (tag) {
      case arrayBufferTag$2:
        return cloneArrayBuffer(object2);
      case boolTag$2:
      case dateTag$2:
        return new Ctor(+object2);
      case dataViewTag$2:
        return cloneDataView(object2, isDeep);
      case float32Tag$1:
      case float64Tag$1:
      case int8Tag$1:
      case int16Tag$1:
      case int32Tag$1:
      case uint8Tag$1:
      case uint8ClampedTag$1:
      case uint16Tag$1:
      case uint32Tag$1:
        return cloneTypedArray(object2, isDeep);
      case mapTag$4:
        return new Ctor();
      case numberTag$2:
      case stringTag$2:
        return new Ctor(object2);
      case regexpTag$2:
        return cloneRegExp(object2);
      case setTag$4:
        return new Ctor();
      case symbolTag$3:
        return cloneSymbol(object2);
    }
  }
  function initCloneObject(object2) {
    return typeof object2.constructor == "function" && !isPrototype(object2) ? baseCreate$1(getPrototype$1(object2)) : {};
  }
  var mapTag$3 = "[object Map]";
  function baseIsMap(value) {
    return isObjectLike$2(value) && getTag$1(value) == mapTag$3;
  }
  var nodeIsMap = nodeUtil$1 && nodeUtil$1.isMap;
  var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
  const isMap$1 = isMap;
  var setTag$3 = "[object Set]";
  function baseIsSet(value) {
    return isObjectLike$2(value) && getTag$1(value) == setTag$3;
  }
  var nodeIsSet = nodeUtil$1 && nodeUtil$1.isSet;
  var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
  const isSet$1 = isSet;
  var CLONE_DEEP_FLAG$1 = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG$2 = 4;
  var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", funcTag$1 = "[object Function]", genTag$1 = "[object GeneratorFunction]", mapTag$2 = "[object Map]", numberTag$1 = "[object Number]", objectTag$1 = "[object Object]", regexpTag$1 = "[object RegExp]", setTag$2 = "[object Set]", stringTag$1 = "[object String]", symbolTag$2 = "[object Symbol]", weakMapTag = "[object WeakMap]";
  var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
  var cloneableTags = {};
  cloneableTags[argsTag$1] = cloneableTags[arrayTag$1] = cloneableTags[arrayBufferTag$1] = cloneableTags[dataViewTag$1] = cloneableTags[boolTag$1] = cloneableTags[dateTag$1] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag$2] = cloneableTags[numberTag$1] = cloneableTags[objectTag$1] = cloneableTags[regexpTag$1] = cloneableTags[setTag$2] = cloneableTags[stringTag$1] = cloneableTags[symbolTag$2] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag$1] = cloneableTags[funcTag$1] = cloneableTags[weakMapTag] = false;
  function baseClone(value, bitmask, customizer, key, object2, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG$1, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG$2;
    if (customizer) {
      result = object2 ? customizer(value, key, object2, stack) : customizer(value);
    }
    if (result !== void 0) {
      return result;
    }
    if (!isObject$6(value)) {
      return value;
    }
    var isArr = isArray$6(value);
    if (isArr) {
      result = initCloneArray(value);
      if (!isDeep) {
        return copyArray$3(value, result);
      }
    } else {
      var tag = getTag$1(value), isFunc = tag == funcTag$1 || tag == genTag$1;
      if (isBuffer$1(value)) {
        return cloneBuffer(value, isDeep);
      }
      if (tag == objectTag$1 || tag == argsTag$1 || isFunc && !object2) {
        result = isFlat || isFunc ? {} : initCloneObject(value);
        if (!isDeep) {
          return isFlat ? copySymbolsIn(value, baseAssignIn(result, value)) : copySymbols(value, baseAssign(result, value));
        }
      } else {
        if (!cloneableTags[tag]) {
          return object2 ? value : {};
        }
        result = initCloneByTag(value, tag, isDeep);
      }
    }
    stack || (stack = new Stack());
    var stacked = stack.get(value);
    if (stacked) {
      return stacked;
    }
    stack.set(value, result);
    if (isSet$1(value)) {
      value.forEach(function(subValue) {
        result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
      });
    } else if (isMap$1(value)) {
      value.forEach(function(subValue, key2) {
        result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
      });
    }
    var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys$1;
    var props = isArr ? void 0 : keysFunc(value);
    arrayEach(props || value, function(subValue, key2) {
      if (props) {
        key2 = subValue;
        subValue = value[key2];
      }
      assignValue$2(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
  }
  var CLONE_SYMBOLS_FLAG$1 = 4;
  function clone$2(value) {
    return baseClone(value, CLONE_SYMBOLS_FLAG$1);
  }
  var CLONE_DEEP_FLAG = 1, CLONE_SYMBOLS_FLAG = 4;
  function cloneDeep(value) {
    return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
  }
  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED$2);
    return this;
  }
  function setCacheHas(value) {
    return this.__data__.has(value);
  }
  function SetCache(values2) {
    var index = -1, length2 = values2 == null ? 0 : values2.length;
    this.__data__ = new MapCache$2();
    while (++index < length2) {
      this.add(values2[index]);
    }
  }
  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;
  function arraySome(array2, predicate) {
    var index = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index < length2) {
      if (predicate(array2[index], index, array2)) {
        return true;
      }
    }
    return false;
  }
  function cacheHas(cache2, key) {
    return cache2.has(key);
  }
  var COMPARE_PARTIAL_FLAG$5 = 1, COMPARE_UNORDERED_FLAG$3 = 2;
  function equalArrays(array2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$5, arrLength = array2.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array2);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array2;
    }
    var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$3 ? new SetCache() : void 0;
    stack.set(array2, other);
    stack.set(other, array2);
    while (++index < arrLength) {
      var arrValue = array2[index], othValue = other[index];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index, other, array2, stack) : customizer(arrValue, othValue, index, array2, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome(other, function(othValue2, othIndex) {
          if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array2);
    stack["delete"](other);
    return result;
  }
  function mapToArray(map2) {
    var index = -1, result = Array(map2.size);
    map2.forEach(function(value, key) {
      result[++index] = [key, value];
    });
    return result;
  }
  function setToArray(set2) {
    var index = -1, result = Array(set2.size);
    set2.forEach(function(value) {
      result[++index] = value;
    });
    return result;
  }
  var COMPARE_PARTIAL_FLAG$4 = 1, COMPARE_UNORDERED_FLAG$2 = 2;
  var boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", mapTag$1 = "[object Map]", numberTag = "[object Number]", regexpTag = "[object RegExp]", setTag$1 = "[object Set]", stringTag = "[object String]", symbolTag$1 = "[object Symbol]";
  var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]";
  var symbolProto$1 = Symbol$6 ? Symbol$6.prototype : void 0, symbolValueOf = symbolProto$1 ? symbolProto$1.valueOf : void 0;
  function equalByTag(object2, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag:
        if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
          return false;
        }
        object2 = object2.buffer;
        other = other.buffer;
      case arrayBufferTag:
        if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array$2(object2), new Uint8Array$2(other))) {
          return false;
        }
        return true;
      case boolTag:
      case dateTag:
      case numberTag:
        return eq$3(+object2, +other);
      case errorTag:
        return object2.name == other.name && object2.message == other.message;
      case regexpTag:
      case stringTag:
        return object2 == other + "";
      case mapTag$1:
        var convert = mapToArray;
      case setTag$1:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG$4;
        convert || (convert = setToArray);
        if (object2.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object2);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG$2;
        stack.set(object2, other);
        var result = equalArrays(convert(object2), convert(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object2);
        return result;
      case symbolTag$1:
        if (symbolValueOf) {
          return symbolValueOf.call(object2) == symbolValueOf.call(other);
        }
    }
    return false;
  }
  var COMPARE_PARTIAL_FLAG$3 = 1;
  var objectProto$a = Object.prototype;
  var hasOwnProperty$9 = objectProto$a.hasOwnProperty;
  function equalObjects(object2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, objProps = getAllKeys(object2), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index = objLength;
    while (index--) {
      var key = objProps[index];
      if (!(isPartial ? key in other : hasOwnProperty$9.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object2);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object2;
    }
    var result = true;
    stack.set(object2, other);
    stack.set(other, object2);
    var skipCtor = isPartial;
    while (++index < objLength) {
      key = objProps[index];
      var objValue = object2[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object2.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object2);
    stack["delete"](other);
    return result;
  }
  var COMPARE_PARTIAL_FLAG$2 = 1;
  var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
  var objectProto$9 = Object.prototype;
  var hasOwnProperty$8 = objectProto$9.hasOwnProperty;
  function baseIsEqualDeep(object2, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$6(object2), othIsArr = isArray$6(other), objTag = objIsArr ? arrayTag : getTag$1(object2), othTag = othIsArr ? arrayTag : getTag$1(other);
    objTag = objTag == argsTag ? objectTag : objTag;
    othTag = othTag == argsTag ? objectTag : othTag;
    var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$1(object2)) {
      if (!isBuffer$1(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack());
      return objIsArr || isTypedArray$1(object2) ? equalArrays(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag(object2, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG$2)) {
      var objIsWrapped = objIsObj && hasOwnProperty$8.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$8.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack());
    return equalObjects(object2, other, bitmask, customizer, equalFunc, stack);
  }
  function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || !isObjectLike$2(value) && !isObjectLike$2(other)) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
  }
  var COMPARE_PARTIAL_FLAG$1 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
  function baseIsMatch(object2, source, matchData, customizer) {
    var index = matchData.length, length2 = index, noCustomizer = !customizer;
    if (object2 == null) {
      return !length2;
    }
    object2 = Object(object2);
    while (index--) {
      var data2 = matchData[index];
      if (noCustomizer && data2[2] ? data2[1] !== object2[data2[0]] : !(data2[0] in object2)) {
        return false;
      }
    }
    while (++index < length2) {
      data2 = matchData[index];
      var key = data2[0], objValue = object2[key], srcValue = data2[1];
      if (noCustomizer && data2[2]) {
        if (objValue === void 0 && !(key in object2)) {
          return false;
        }
      } else {
        var stack = new Stack();
        if (customizer) {
          var result = customizer(objValue, srcValue, key, object2, source, stack);
        }
        if (!(result === void 0 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG$1 | COMPARE_UNORDERED_FLAG$1, customizer, stack) : result)) {
          return false;
        }
      }
    }
    return true;
  }
  function isStrictComparable(value) {
    return value === value && !isObject$6(value);
  }
  function getMatchData(object2) {
    var result = keys$1(object2), length2 = result.length;
    while (length2--) {
      var key = result[length2], value = object2[key];
      result[length2] = [key, value, isStrictComparable(value)];
    }
    return result;
  }
  function matchesStrictComparable(key, srcValue) {
    return function(object2) {
      if (object2 == null) {
        return false;
      }
      return object2[key] === srcValue && (srcValue !== void 0 || key in Object(object2));
    };
  }
  function baseMatches(source) {
    var matchData = getMatchData(source);
    if (matchData.length == 1 && matchData[0][2]) {
      return matchesStrictComparable(matchData[0][0], matchData[0][1]);
    }
    return function(object2) {
      return object2 === source || baseIsMatch(object2, source, matchData);
    };
  }
  function baseHasIn(object2, key) {
    return object2 != null && key in Object(object2);
  }
  function hasPath(object2, path2, hasFunc) {
    path2 = castPath$3(path2, object2);
    var index = -1, length2 = path2.length, result = false;
    while (++index < length2) {
      var key = toKey$4(path2[index]);
      if (!(result = object2 != null && hasFunc(object2, key))) {
        break;
      }
      object2 = object2[key];
    }
    if (result || ++index != length2) {
      return result;
    }
    length2 = object2 == null ? 0 : object2.length;
    return !!length2 && isLength(length2) && isIndex$2(key, length2) && (isArray$6(object2) || isArguments$1(object2));
  }
  function hasIn(object2, path2) {
    return object2 != null && hasPath(object2, path2, baseHasIn);
  }
  var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
  function baseMatchesProperty(path2, srcValue) {
    if (isKey$2(path2) && isStrictComparable(srcValue)) {
      return matchesStrictComparable(toKey$4(path2), srcValue);
    }
    return function(object2) {
      var objValue = get$3(object2, path2);
      return objValue === void 0 && objValue === srcValue ? hasIn(object2, path2) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
    };
  }
  function baseProperty(key) {
    return function(object2) {
      return object2 == null ? void 0 : object2[key];
    };
  }
  function basePropertyDeep(path2) {
    return function(object2) {
      return baseGet$2(object2, path2);
    };
  }
  function property(path2) {
    return isKey$2(path2) ? baseProperty(toKey$4(path2)) : basePropertyDeep(path2);
  }
  function baseIteratee(value) {
    if (typeof value == "function") {
      return value;
    }
    if (value == null) {
      return identity$1;
    }
    if (typeof value == "object") {
      return isArray$6(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
    }
    return property(value);
  }
  function createBaseFor(fromRight) {
    return function(object2, iteratee, keysFunc) {
      var index = -1, iterable = Object(object2), props = keysFunc(object2), length2 = props.length;
      while (length2--) {
        var key = props[fromRight ? length2 : ++index];
        if (iteratee(iterable[key], key, iterable) === false) {
          break;
        }
      }
      return object2;
    };
  }
  var baseFor = createBaseFor();
  const baseFor$1 = baseFor;
  function baseForOwn(object2, iteratee) {
    return object2 && baseFor$1(object2, iteratee, keys$1);
  }
  function createBaseEach(eachFunc, fromRight) {
    return function(collection2, iteratee) {
      if (collection2 == null) {
        return collection2;
      }
      if (!isArrayLike(collection2)) {
        return eachFunc(collection2, iteratee);
      }
      var length2 = collection2.length, index = fromRight ? length2 : -1, iterable = Object(collection2);
      while (fromRight ? index-- : ++index < length2) {
        if (iteratee(iterable[index], index, iterable) === false) {
          break;
        }
      }
      return collection2;
    };
  }
  var baseEach = createBaseEach(baseForOwn);
  const baseEach$1 = baseEach;
  var now$2 = function() {
    return root$6.Date.now();
  };
  const now$3 = now$2;
  var objectProto$8 = Object.prototype;
  var hasOwnProperty$7 = objectProto$8.hasOwnProperty;
  var defaults$h = baseRest(function(object2, sources) {
    object2 = Object(object2);
    var index = -1;
    var length2 = sources.length;
    var guard = length2 > 2 ? sources[2] : void 0;
    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      length2 = 1;
    }
    while (++index < length2) {
      var source = sources[index];
      var props = keysIn(source);
      var propsIndex = -1;
      var propsLength = props.length;
      while (++propsIndex < propsLength) {
        var key = props[propsIndex];
        var value = object2[key];
        if (value === void 0 || eq$3(value, objectProto$8[key]) && !hasOwnProperty$7.call(object2, key)) {
          object2[key] = source[key];
        }
      }
    }
    return object2;
  });
  const defaults$i = defaults$h;
  function assignMergeValue(object2, key, value) {
    if (value !== void 0 && !eq$3(object2[key], value) || value === void 0 && !(key in object2)) {
      baseAssignValue$2(object2, key, value);
    }
  }
  function isArrayLikeObject(value) {
    return isObjectLike$2(value) && isArrayLike(value);
  }
  function safeGet(object2, key) {
    if (key === "constructor" && typeof object2[key] === "function") {
      return;
    }
    if (key == "__proto__") {
      return;
    }
    return object2[key];
  }
  function toPlainObject(value) {
    return copyObject(value, keysIn(value));
  }
  function baseMergeDeep(object2, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = safeGet(object2, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
    if (stacked) {
      assignMergeValue(object2, key, stacked);
      return;
    }
    var newValue = customizer ? customizer(objValue, srcValue, key + "", object2, source, stack) : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
      var isArr = isArray$6(srcValue), isBuff = !isArr && isBuffer$1(srcValue), isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);
      newValue = srcValue;
      if (isArr || isBuff || isTyped) {
        if (isArray$6(objValue)) {
          newValue = objValue;
        } else if (isArrayLikeObject(objValue)) {
          newValue = copyArray$3(objValue);
        } else if (isBuff) {
          isCommon = false;
          newValue = cloneBuffer(srcValue, true);
        } else if (isTyped) {
          isCommon = false;
          newValue = cloneTypedArray(srcValue, true);
        } else {
          newValue = [];
        }
      } else if (isPlainObject(srcValue) || isArguments$1(srcValue)) {
        newValue = objValue;
        if (isArguments$1(objValue)) {
          newValue = toPlainObject(objValue);
        } else if (!isObject$6(objValue) || isFunction$2(objValue)) {
          newValue = initCloneObject(srcValue);
        }
      } else {
        isCommon = false;
      }
    }
    if (isCommon) {
      stack.set(srcValue, newValue);
      mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
      stack["delete"](srcValue);
    }
    assignMergeValue(object2, key, newValue);
  }
  function baseMerge(object2, source, srcIndex, customizer, stack) {
    if (object2 === source) {
      return;
    }
    baseFor$1(source, function(srcValue, key) {
      stack || (stack = new Stack());
      if (isObject$6(srcValue)) {
        baseMergeDeep(object2, source, key, srcIndex, baseMerge, customizer, stack);
      } else {
        var newValue = customizer ? customizer(safeGet(object2, key), srcValue, key + "", object2, source, stack) : void 0;
        if (newValue === void 0) {
          newValue = srcValue;
        }
        assignMergeValue(object2, key, newValue);
      }
    }, keysIn);
  }
  function arrayIncludesWith(array2, value, comparator) {
    var index = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index < length2) {
      if (comparator(value, array2[index])) {
        return true;
      }
    }
    return false;
  }
  function last(array2) {
    var length2 = array2 == null ? 0 : array2.length;
    return length2 ? array2[length2 - 1] : void 0;
  }
  function castFunction(value) {
    return typeof value == "function" ? value : identity$1;
  }
  function forEach(collection2, iteratee) {
    var func = isArray$6(collection2) ? arrayEach : baseEach$1;
    return func(collection2, castFunction(iteratee));
  }
  function baseFilter(collection2, predicate) {
    var result = [];
    baseEach$1(collection2, function(value, index, collection3) {
      if (predicate(value, index, collection3)) {
        result.push(value);
      }
    });
    return result;
  }
  function filter$1(collection2, predicate) {
    var func = isArray$6(collection2) ? arrayFilter : baseFilter;
    return func(collection2, baseIteratee(predicate));
  }
  function createFind(findIndexFunc) {
    return function(collection2, predicate, fromIndex) {
      var iterable = Object(collection2);
      if (!isArrayLike(collection2)) {
        var iteratee = baseIteratee(predicate);
        collection2 = keys$1(collection2);
        predicate = function(key) {
          return iteratee(iterable[key], key, iterable);
        };
      }
      var index = findIndexFunc(collection2, predicate, fromIndex);
      return index > -1 ? iterable[iteratee ? collection2[index] : index] : void 0;
    };
  }
  var nativeMax$2 = Math.max;
  function findIndex(array2, predicate, fromIndex) {
    var length2 = array2 == null ? 0 : array2.length;
    if (!length2) {
      return -1;
    }
    var index = fromIndex == null ? 0 : toInteger(fromIndex);
    if (index < 0) {
      index = nativeMax$2(length2 + index, 0);
    }
    return baseFindIndex(array2, baseIteratee(predicate), index);
  }
  var find = createFind(findIndex);
  const find$1 = find;
  function baseMap(collection2, iteratee) {
    var index = -1, result = isArrayLike(collection2) ? Array(collection2.length) : [];
    baseEach$1(collection2, function(value, key, collection3) {
      result[++index] = iteratee(value, key, collection3);
    });
    return result;
  }
  function map(collection2, iteratee) {
    var func = isArray$6(collection2) ? arrayMap$3 : baseMap;
    return func(collection2, baseIteratee(iteratee));
  }
  function forIn(object2, iteratee) {
    return object2 == null ? object2 : baseFor$1(object2, castFunction(iteratee), keysIn);
  }
  function baseGt(value, other) {
    return value > other;
  }
  var objectProto$7 = Object.prototype;
  var hasOwnProperty$6 = objectProto$7.hasOwnProperty;
  function baseHas(object2, key) {
    return object2 != null && hasOwnProperty$6.call(object2, key);
  }
  function has(object2, path2) {
    return object2 != null && hasPath(object2, path2, baseHas);
  }
  function baseValues(object2, props) {
    return arrayMap$3(props, function(key) {
      return object2[key];
    });
  }
  function values(object2) {
    return object2 == null ? [] : baseValues(object2, keys$1(object2));
  }
  var mapTag = "[object Map]", setTag = "[object Set]";
  var objectProto$6 = Object.prototype;
  var hasOwnProperty$5 = objectProto$6.hasOwnProperty;
  function isEmpty(value) {
    if (value == null) {
      return true;
    }
    if (isArrayLike(value) && (isArray$6(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer$1(value) || isTypedArray$1(value) || isArguments$1(value))) {
      return !value.length;
    }
    var tag = getTag$1(value);
    if (tag == mapTag || tag == setTag) {
      return !value.size;
    }
    if (isPrototype(value)) {
      return !baseKeys(value).length;
    }
    for (var key in value) {
      if (hasOwnProperty$5.call(value, key)) {
        return false;
      }
    }
    return true;
  }
  function isUndefined(value) {
    return value === void 0;
  }
  function baseLt(value, other) {
    return value < other;
  }
  function mapValues(object2, iteratee) {
    var result = {};
    iteratee = baseIteratee(iteratee);
    baseForOwn(object2, function(value, key, object3) {
      baseAssignValue$2(result, key, iteratee(value, key, object3));
    });
    return result;
  }
  function baseExtremum(array2, iteratee, comparator) {
    var index = -1, length2 = array2.length;
    while (++index < length2) {
      var value = array2[index], current = iteratee(value);
      if (current != null && (computed === void 0 ? current === current && !isSymbol$6(current) : comparator(current, computed))) {
        var computed = current, result = value;
      }
    }
    return result;
  }
  function max$1(array2) {
    return array2 && array2.length ? baseExtremum(array2, identity$1, baseGt) : void 0;
  }
  var merge = createAssigner(function(object2, source, srcIndex) {
    baseMerge(object2, source, srcIndex);
  });
  const merge$1 = merge;
  function min$1(array2) {
    return array2 && array2.length ? baseExtremum(array2, identity$1, baseLt) : void 0;
  }
  function minBy(array2, iteratee) {
    return array2 && array2.length ? baseExtremum(array2, baseIteratee(iteratee), baseLt) : void 0;
  }
  function baseSet$2(object2, path2, value, customizer) {
    if (!isObject$6(object2)) {
      return object2;
    }
    path2 = castPath$3(path2, object2);
    var index = -1, length2 = path2.length, lastIndex = length2 - 1, nested = object2;
    while (nested != null && ++index < length2) {
      var key = toKey$4(path2[index]), newValue = value;
      if (key === "__proto__" || key === "constructor" || key === "prototype") {
        return object2;
      }
      if (index != lastIndex) {
        var objValue = nested[key];
        newValue = customizer ? customizer(objValue, key, nested) : void 0;
        if (newValue === void 0) {
          newValue = isObject$6(objValue) ? objValue : isIndex$2(path2[index + 1]) ? [] : {};
        }
      }
      assignValue$2(nested, key, newValue);
      nested = nested[key];
    }
    return object2;
  }
  function basePickBy(object2, paths, predicate) {
    var index = -1, length2 = paths.length, result = {};
    while (++index < length2) {
      var path2 = paths[index], value = baseGet$2(object2, path2);
      if (predicate(value, path2)) {
        baseSet$2(result, castPath$3(path2, object2), value);
      }
    }
    return result;
  }
  function baseSortBy(array2, comparer) {
    var length2 = array2.length;
    array2.sort(comparer);
    while (length2--) {
      array2[length2] = array2[length2].value;
    }
    return array2;
  }
  function compareAscending(value, other) {
    if (value !== other) {
      var valIsDefined = value !== void 0, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol$6(value);
      var othIsDefined = other !== void 0, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol$6(other);
      if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
        return 1;
      }
      if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
        return -1;
      }
    }
    return 0;
  }
  function compareMultiple(object2, other, orders) {
    var index = -1, objCriteria = object2.criteria, othCriteria = other.criteria, length2 = objCriteria.length, ordersLength = orders.length;
    while (++index < length2) {
      var result = compareAscending(objCriteria[index], othCriteria[index]);
      if (result) {
        if (index >= ordersLength) {
          return result;
        }
        var order2 = orders[index];
        return result * (order2 == "desc" ? -1 : 1);
      }
    }
    return object2.index - other.index;
  }
  function baseOrderBy(collection2, iteratees, orders) {
    if (iteratees.length) {
      iteratees = arrayMap$3(iteratees, function(iteratee) {
        if (isArray$6(iteratee)) {
          return function(value) {
            return baseGet$2(value, iteratee.length === 1 ? iteratee[0] : iteratee);
          };
        }
        return iteratee;
      });
    } else {
      iteratees = [identity$1];
    }
    var index = -1;
    iteratees = arrayMap$3(iteratees, baseUnary(baseIteratee));
    var result = baseMap(collection2, function(value, key, collection3) {
      var criteria = arrayMap$3(iteratees, function(iteratee) {
        return iteratee(value);
      });
      return { "criteria": criteria, "index": ++index, "value": value };
    });
    return baseSortBy(result, function(object2, other) {
      return compareMultiple(object2, other, orders);
    });
  }
  function basePick(object2, paths) {
    return basePickBy(object2, paths, function(value, path2) {
      return hasIn(object2, path2);
    });
  }
  var pick = flatRest(function(object2, paths) {
    return object2 == null ? {} : basePick(object2, paths);
  });
  const pick$1 = pick;
  var nativeCeil = Math.ceil, nativeMax$1 = Math.max;
  function baseRange(start2, end2, step2, fromRight) {
    var index = -1, length2 = nativeMax$1(nativeCeil((end2 - start2) / (step2 || 1)), 0), result = Array(length2);
    while (length2--) {
      result[fromRight ? length2 : ++index] = start2;
      start2 += step2;
    }
    return result;
  }
  function createRange(fromRight) {
    return function(start2, end2, step2) {
      if (step2 && typeof step2 != "number" && isIterateeCall(start2, end2, step2)) {
        end2 = step2 = void 0;
      }
      start2 = toFinite(start2);
      if (end2 === void 0) {
        end2 = start2;
        start2 = 0;
      } else {
        end2 = toFinite(end2);
      }
      step2 = step2 === void 0 ? start2 < end2 ? 1 : -1 : toFinite(step2);
      return baseRange(start2, end2, step2, fromRight);
    };
  }
  var range = createRange();
  const range$1 = range;
  function baseReduce(collection2, iteratee, accumulator, initAccum, eachFunc) {
    eachFunc(collection2, function(value, index, collection3) {
      accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index, collection3);
    });
    return accumulator;
  }
  function reduce(collection2, iteratee, accumulator) {
    var func = isArray$6(collection2) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
    return func(collection2, baseIteratee(iteratee), accumulator, initAccum, baseEach$1);
  }
  var sortBy = baseRest(function(collection2, iteratees) {
    if (collection2 == null) {
      return [];
    }
    var length2 = iteratees.length;
    if (length2 > 1 && isIterateeCall(collection2, iteratees[0], iteratees[1])) {
      iteratees = [];
    } else if (length2 > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
      iteratees = [iteratees[0]];
    }
    return baseOrderBy(collection2, baseFlatten(iteratees, 1), []);
  });
  const sortBy$1 = sortBy;
  var INFINITY$2 = 1 / 0;
  var createSet = !(Set$3 && 1 / setToArray(new Set$3([, -0]))[1] == INFINITY$2) ? noop$2 : function(values2) {
    return new Set$3(values2);
  };
  const createSet$1 = createSet;
  var LARGE_ARRAY_SIZE = 200;
  function baseUniq(array2, iteratee, comparator) {
    var index = -1, includes2 = arrayIncludes, length2 = array2.length, isCommon = true, result = [], seen = result;
    if (comparator) {
      isCommon = false;
      includes2 = arrayIncludesWith;
    } else if (length2 >= LARGE_ARRAY_SIZE) {
      var set2 = iteratee ? null : createSet$1(array2);
      if (set2) {
        return setToArray(set2);
      }
      isCommon = false;
      includes2 = cacheHas;
      seen = new SetCache();
    } else {
      seen = iteratee ? [] : result;
    }
    outer:
      while (++index < length2) {
        var value = array2[index], computed = iteratee ? iteratee(value) : value;
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        } else if (!includes2(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
    return result;
  }
  var union = baseRest(function(arrays) {
    return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
  });
  const union$1 = union;
  var idCounter = 0;
  function uniqueId(prefix) {
    var id2 = ++idCounter;
    return toString$4(prefix) + id2;
  }
  function baseZipObject(props, values2, assignFunc) {
    var index = -1, length2 = props.length, valsLength = values2.length, result = {};
    while (++index < length2) {
      var value = index < valsLength ? values2[index] : void 0;
      assignFunc(result, props[index], value);
    }
    return result;
  }
  function zipObject(props, values2) {
    return baseZipObject(props || [], values2 || [], assignValue$2);
  }
  var DEFAULT_EDGE_NAME = "\0";
  var GRAPH_NODE = "\0";
  var EDGE_KEY_DELIM = "";
  class Graph {
    constructor(opts = {}) {
      this._isDirected = has(opts, "directed") ? opts.directed : true;
      this._isMultigraph = has(opts, "multigraph") ? opts.multigraph : false;
      this._isCompound = has(opts, "compound") ? opts.compound : false;
      this._label = void 0;
      this._defaultNodeLabelFn = constant(void 0);
      this._defaultEdgeLabelFn = constant(void 0);
      this._nodes = {};
      if (this._isCompound) {
        this._parent = {};
        this._children = {};
        this._children[GRAPH_NODE] = {};
      }
      this._in = {};
      this._preds = {};
      this._out = {};
      this._sucs = {};
      this._edgeObjs = {};
      this._edgeLabels = {};
    }
    isDirected() {
      return this._isDirected;
    }
    isMultigraph() {
      return this._isMultigraph;
    }
    isCompound() {
      return this._isCompound;
    }
    setGraph(label) {
      this._label = label;
      return this;
    }
    graph() {
      return this._label;
    }
    setDefaultNodeLabel(newDefault) {
      if (!isFunction$2(newDefault)) {
        newDefault = constant(newDefault);
      }
      this._defaultNodeLabelFn = newDefault;
      return this;
    }
    nodeCount() {
      return this._nodeCount;
    }
    nodes() {
      return keys$1(this._nodes);
    }
    sources() {
      var self2 = this;
      return filter$1(this.nodes(), function(v) {
        return isEmpty(self2._in[v]);
      });
    }
    sinks() {
      var self2 = this;
      return filter$1(this.nodes(), function(v) {
        return isEmpty(self2._out[v]);
      });
    }
    setNodes(vs, value) {
      var args = arguments;
      var self2 = this;
      forEach(vs, function(v) {
        if (args.length > 1) {
          self2.setNode(v, value);
        } else {
          self2.setNode(v);
        }
      });
      return this;
    }
    setNode(v, value) {
      if (has(this._nodes, v)) {
        if (arguments.length > 1) {
          this._nodes[v] = value;
        }
        return this;
      }
      this._nodes[v] = arguments.length > 1 ? value : this._defaultNodeLabelFn(v);
      if (this._isCompound) {
        this._parent[v] = GRAPH_NODE;
        this._children[v] = {};
        this._children[GRAPH_NODE][v] = true;
      }
      this._in[v] = {};
      this._preds[v] = {};
      this._out[v] = {};
      this._sucs[v] = {};
      ++this._nodeCount;
      return this;
    }
    node(v) {
      return this._nodes[v];
    }
    hasNode(v) {
      return has(this._nodes, v);
    }
    removeNode(v) {
      var self2 = this;
      if (has(this._nodes, v)) {
        var removeEdge = function(e) {
          self2.removeEdge(self2._edgeObjs[e]);
        };
        delete this._nodes[v];
        if (this._isCompound) {
          this._removeFromParentsChildList(v);
          delete this._parent[v];
          forEach(this.children(v), function(child) {
            self2.setParent(child);
          });
          delete this._children[v];
        }
        forEach(keys$1(this._in[v]), removeEdge);
        delete this._in[v];
        delete this._preds[v];
        forEach(keys$1(this._out[v]), removeEdge);
        delete this._out[v];
        delete this._sucs[v];
        --this._nodeCount;
      }
      return this;
    }
    setParent(v, parent) {
      if (!this._isCompound) {
        throw new Error("Cannot set parent in a non-compound graph");
      }
      if (isUndefined(parent)) {
        parent = GRAPH_NODE;
      } else {
        parent += "";
        for (var ancestor = parent; !isUndefined(ancestor); ancestor = this.parent(ancestor)) {
          if (ancestor === v) {
            throw new Error("Setting " + parent + " as parent of " + v + " would create a cycle");
          }
        }
        this.setNode(parent);
      }
      this.setNode(v);
      this._removeFromParentsChildList(v);
      this._parent[v] = parent;
      this._children[parent][v] = true;
      return this;
    }
    _removeFromParentsChildList(v) {
      delete this._children[this._parent[v]][v];
    }
    parent(v) {
      if (this._isCompound) {
        var parent = this._parent[v];
        if (parent !== GRAPH_NODE) {
          return parent;
        }
      }
    }
    children(v) {
      if (isUndefined(v)) {
        v = GRAPH_NODE;
      }
      if (this._isCompound) {
        var children2 = this._children[v];
        if (children2) {
          return keys$1(children2);
        }
      } else if (v === GRAPH_NODE) {
        return this.nodes();
      } else if (this.hasNode(v)) {
        return [];
      }
    }
    predecessors(v) {
      var predsV = this._preds[v];
      if (predsV) {
        return keys$1(predsV);
      }
    }
    successors(v) {
      var sucsV = this._sucs[v];
      if (sucsV) {
        return keys$1(sucsV);
      }
    }
    neighbors(v) {
      var preds = this.predecessors(v);
      if (preds) {
        return union$1(preds, this.successors(v));
      }
    }
    isLeaf(v) {
      var neighbors;
      if (this.isDirected()) {
        neighbors = this.successors(v);
      } else {
        neighbors = this.neighbors(v);
      }
      return neighbors.length === 0;
    }
    filterNodes(filter2) {
      var copy2 = new this.constructor({
        directed: this._isDirected,
        multigraph: this._isMultigraph,
        compound: this._isCompound
      });
      copy2.setGraph(this.graph());
      var self2 = this;
      forEach(this._nodes, function(value, v) {
        if (filter2(v)) {
          copy2.setNode(v, value);
        }
      });
      forEach(this._edgeObjs, function(e) {
        if (copy2.hasNode(e.v) && copy2.hasNode(e.w)) {
          copy2.setEdge(e, self2.edge(e));
        }
      });
      var parents2 = {};
      function findParent(v) {
        var parent = self2.parent(v);
        if (parent === void 0 || copy2.hasNode(parent)) {
          parents2[v] = parent;
          return parent;
        } else if (parent in parents2) {
          return parents2[parent];
        } else {
          return findParent(parent);
        }
      }
      if (this._isCompound) {
        forEach(copy2.nodes(), function(v) {
          copy2.setParent(v, findParent(v));
        });
      }
      return copy2;
    }
    setDefaultEdgeLabel(newDefault) {
      if (!isFunction$2(newDefault)) {
        newDefault = constant(newDefault);
      }
      this._defaultEdgeLabelFn = newDefault;
      return this;
    }
    edgeCount() {
      return this._edgeCount;
    }
    edges() {
      return values(this._edgeObjs);
    }
    setPath(vs, value) {
      var self2 = this;
      var args = arguments;
      reduce(vs, function(v, w2) {
        if (args.length > 1) {
          self2.setEdge(v, w2, value);
        } else {
          self2.setEdge(v, w2);
        }
        return w2;
      });
      return this;
    }
    setEdge() {
      var v, w2, name2, value;
      var valueSpecified = false;
      var arg0 = arguments[0];
      if (typeof arg0 === "object" && arg0 !== null && "v" in arg0) {
        v = arg0.v;
        w2 = arg0.w;
        name2 = arg0.name;
        if (arguments.length === 2) {
          value = arguments[1];
          valueSpecified = true;
        }
      } else {
        v = arg0;
        w2 = arguments[1];
        name2 = arguments[3];
        if (arguments.length > 2) {
          value = arguments[2];
          valueSpecified = true;
        }
      }
      v = "" + v;
      w2 = "" + w2;
      if (!isUndefined(name2)) {
        name2 = "" + name2;
      }
      var e = edgeArgsToId(this._isDirected, v, w2, name2);
      if (has(this._edgeLabels, e)) {
        if (valueSpecified) {
          this._edgeLabels[e] = value;
        }
        return this;
      }
      if (!isUndefined(name2) && !this._isMultigraph) {
        throw new Error("Cannot set a named edge when isMultigraph = false");
      }
      this.setNode(v);
      this.setNode(w2);
      this._edgeLabels[e] = valueSpecified ? value : this._defaultEdgeLabelFn(v, w2, name2);
      var edgeObj = edgeArgsToObj(this._isDirected, v, w2, name2);
      v = edgeObj.v;
      w2 = edgeObj.w;
      Object.freeze(edgeObj);
      this._edgeObjs[e] = edgeObj;
      incrementOrInitEntry(this._preds[w2], v);
      incrementOrInitEntry(this._sucs[v], w2);
      this._in[w2][e] = edgeObj;
      this._out[v][e] = edgeObj;
      this._edgeCount++;
      return this;
    }
    edge(v, w2, name2) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name2);
      return this._edgeLabels[e];
    }
    hasEdge(v, w2, name2) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name2);
      return has(this._edgeLabels, e);
    }
    removeEdge(v, w2, name2) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name2);
      var edge = this._edgeObjs[e];
      if (edge) {
        v = edge.v;
        w2 = edge.w;
        delete this._edgeLabels[e];
        delete this._edgeObjs[e];
        decrementOrRemoveEntry(this._preds[w2], v);
        decrementOrRemoveEntry(this._sucs[v], w2);
        delete this._in[w2][e];
        delete this._out[v][e];
        this._edgeCount--;
      }
      return this;
    }
    inEdges(v, u) {
      var inV = this._in[v];
      if (inV) {
        var edges2 = values(inV);
        if (!u) {
          return edges2;
        }
        return filter$1(edges2, function(edge) {
          return edge.v === u;
        });
      }
    }
    outEdges(v, w2) {
      var outV = this._out[v];
      if (outV) {
        var edges2 = values(outV);
        if (!w2) {
          return edges2;
        }
        return filter$1(edges2, function(edge) {
          return edge.w === w2;
        });
      }
    }
    nodeEdges(v, w2) {
      var inEdges = this.inEdges(v, w2);
      if (inEdges) {
        return inEdges.concat(this.outEdges(v, w2));
      }
    }
  }
  Graph.prototype._nodeCount = 0;
  Graph.prototype._edgeCount = 0;
  function incrementOrInitEntry(map2, k) {
    if (map2[k]) {
      map2[k]++;
    } else {
      map2[k] = 1;
    }
  }
  function decrementOrRemoveEntry(map2, k) {
    if (!--map2[k]) {
      delete map2[k];
    }
  }
  function edgeArgsToId(isDirected, v_, w_, name2) {
    var v = "" + v_;
    var w2 = "" + w_;
    if (!isDirected && v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    return v + EDGE_KEY_DELIM + w2 + EDGE_KEY_DELIM + (isUndefined(name2) ? DEFAULT_EDGE_NAME : name2);
  }
  function edgeArgsToObj(isDirected, v_, w_, name2) {
    var v = "" + v_;
    var w2 = "" + w_;
    if (!isDirected && v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    var edgeObj = { v, w: w2 };
    if (name2) {
      edgeObj.name = name2;
    }
    return edgeObj;
  }
  function edgeObjToId(isDirected, edgeObj) {
    return edgeArgsToId(isDirected, edgeObj.v, edgeObj.w, edgeObj.name);
  }
  class List {
    constructor() {
      var sentinel = {};
      sentinel._next = sentinel._prev = sentinel;
      this._sentinel = sentinel;
    }
    dequeue() {
      var sentinel = this._sentinel;
      var entry = sentinel._prev;
      if (entry !== sentinel) {
        unlink(entry);
        return entry;
      }
    }
    enqueue(entry) {
      var sentinel = this._sentinel;
      if (entry._prev && entry._next) {
        unlink(entry);
      }
      entry._next = sentinel._next;
      sentinel._next._prev = entry;
      sentinel._next = entry;
      entry._prev = sentinel;
    }
    toString() {
      var strs = [];
      var sentinel = this._sentinel;
      var curr = sentinel._prev;
      while (curr !== sentinel) {
        strs.push(JSON.stringify(curr, filterOutLinks));
        curr = curr._prev;
      }
      return "[" + strs.join(", ") + "]";
    }
  }
  function unlink(entry) {
    entry._prev._next = entry._next;
    entry._next._prev = entry._prev;
    delete entry._next;
    delete entry._prev;
  }
  function filterOutLinks(k, v) {
    if (k !== "_next" && k !== "_prev") {
      return v;
    }
  }
  var DEFAULT_WEIGHT_FN = constant(1);
  function greedyFAS(g, weightFn) {
    if (g.nodeCount() <= 1) {
      return [];
    }
    var state = buildState(g, weightFn || DEFAULT_WEIGHT_FN);
    var results = doGreedyFAS(state.graph, state.buckets, state.zeroIdx);
    return flatten(
      map(results, function(e) {
        return g.outEdges(e.v, e.w);
      })
    );
  }
  function doGreedyFAS(g, buckets, zeroIdx) {
    var results = [];
    var sources = buckets[buckets.length - 1];
    var sinks = buckets[0];
    var entry;
    while (g.nodeCount()) {
      while (entry = sinks.dequeue()) {
        removeNode(g, buckets, zeroIdx, entry);
      }
      while (entry = sources.dequeue()) {
        removeNode(g, buckets, zeroIdx, entry);
      }
      if (g.nodeCount()) {
        for (var i2 = buckets.length - 2; i2 > 0; --i2) {
          entry = buckets[i2].dequeue();
          if (entry) {
            results = results.concat(removeNode(g, buckets, zeroIdx, entry, true));
            break;
          }
        }
      }
    }
    return results;
  }
  function removeNode(g, buckets, zeroIdx, entry, collectPredecessors) {
    var results = collectPredecessors ? [] : void 0;
    forEach(g.inEdges(entry.v), function(edge) {
      var weight = g.edge(edge);
      var uEntry = g.node(edge.v);
      if (collectPredecessors) {
        results.push({ v: edge.v, w: edge.w });
      }
      uEntry.out -= weight;
      assignBucket(buckets, zeroIdx, uEntry);
    });
    forEach(g.outEdges(entry.v), function(edge) {
      var weight = g.edge(edge);
      var w2 = edge.w;
      var wEntry = g.node(w2);
      wEntry["in"] -= weight;
      assignBucket(buckets, zeroIdx, wEntry);
    });
    g.removeNode(entry.v);
    return results;
  }
  function buildState(g, weightFn) {
    var fasGraph = new Graph();
    var maxIn = 0;
    var maxOut = 0;
    forEach(g.nodes(), function(v) {
      fasGraph.setNode(v, { v, in: 0, out: 0 });
    });
    forEach(g.edges(), function(e) {
      var prevWeight = fasGraph.edge(e.v, e.w) || 0;
      var weight = weightFn(e);
      var edgeWeight = prevWeight + weight;
      fasGraph.setEdge(e.v, e.w, edgeWeight);
      maxOut = Math.max(maxOut, fasGraph.node(e.v).out += weight);
      maxIn = Math.max(maxIn, fasGraph.node(e.w)["in"] += weight);
    });
    var buckets = range$1(maxOut + maxIn + 3).map(function() {
      return new List();
    });
    var zeroIdx = maxIn + 1;
    forEach(fasGraph.nodes(), function(v) {
      assignBucket(buckets, zeroIdx, fasGraph.node(v));
    });
    return { graph: fasGraph, buckets, zeroIdx };
  }
  function assignBucket(buckets, zeroIdx, entry) {
    if (!entry.out) {
      buckets[0].enqueue(entry);
    } else if (!entry["in"]) {
      buckets[buckets.length - 1].enqueue(entry);
    } else {
      buckets[entry.out - entry["in"] + zeroIdx].enqueue(entry);
    }
  }
  function run$2(g) {
    var fas = g.graph().acyclicer === "greedy" ? greedyFAS(g, weightFn(g)) : dfsFAS(g);
    forEach(fas, function(e) {
      var label = g.edge(e);
      g.removeEdge(e);
      label.forwardName = e.name;
      label.reversed = true;
      g.setEdge(e.w, e.v, label, uniqueId("rev"));
    });
    function weightFn(g2) {
      return function(e) {
        return g2.edge(e).weight;
      };
    }
  }
  function dfsFAS(g) {
    var fas = [];
    var stack = {};
    var visited = {};
    function dfs2(v) {
      if (has(visited, v)) {
        return;
      }
      visited[v] = true;
      stack[v] = true;
      forEach(g.outEdges(v), function(e) {
        if (has(stack, e.w)) {
          fas.push(e);
        } else {
          dfs2(e.w);
        }
      });
      delete stack[v];
    }
    forEach(g.nodes(), dfs2);
    return fas;
  }
  function undo$2(g) {
    forEach(g.edges(), function(e) {
      var label = g.edge(e);
      if (label.reversed) {
        g.removeEdge(e);
        var forwardName = label.forwardName;
        delete label.reversed;
        delete label.forwardName;
        g.setEdge(e.w, e.v, label, forwardName);
      }
    });
  }
  function addDummyNode(g, type2, attrs, name2) {
    var v;
    do {
      v = uniqueId(name2);
    } while (g.hasNode(v));
    attrs.dummy = type2;
    g.setNode(v, attrs);
    return v;
  }
  function simplify(g) {
    var simplified = new Graph().setGraph(g.graph());
    forEach(g.nodes(), function(v) {
      simplified.setNode(v, g.node(v));
    });
    forEach(g.edges(), function(e) {
      var simpleLabel = simplified.edge(e.v, e.w) || { weight: 0, minlen: 1 };
      var label = g.edge(e);
      simplified.setEdge(e.v, e.w, {
        weight: simpleLabel.weight + label.weight,
        minlen: Math.max(simpleLabel.minlen, label.minlen)
      });
    });
    return simplified;
  }
  function asNonCompoundGraph(g) {
    var simplified = new Graph({ multigraph: g.isMultigraph() }).setGraph(g.graph());
    forEach(g.nodes(), function(v) {
      if (!g.children(v).length) {
        simplified.setNode(v, g.node(v));
      }
    });
    forEach(g.edges(), function(e) {
      simplified.setEdge(e, g.edge(e));
    });
    return simplified;
  }
  function intersectRect$3(rect2, point2) {
    var x2 = rect2.x;
    var y2 = rect2.y;
    var dx = point2.x - x2;
    var dy = point2.y - y2;
    var w2 = rect2.width / 2;
    var h = rect2.height / 2;
    if (!dx && !dy) {
      throw new Error("Not possible to find intersection inside of the rectangle");
    }
    var sx, sy;
    if (Math.abs(dy) * w2 > Math.abs(dx) * h) {
      if (dy < 0) {
        h = -h;
      }
      sx = h * dx / dy;
      sy = h;
    } else {
      if (dx < 0) {
        w2 = -w2;
      }
      sx = w2;
      sy = w2 * dy / dx;
    }
    return { x: x2 + sx, y: y2 + sy };
  }
  function buildLayerMatrix(g) {
    var layering = map(range$1(maxRank(g) + 1), function() {
      return [];
    });
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      var rank2 = node2.rank;
      if (!isUndefined(rank2)) {
        layering[rank2][node2.order] = v;
      }
    });
    return layering;
  }
  function normalizeRanks(g) {
    var min2 = min$1(
      map(g.nodes(), function(v) {
        return g.node(v).rank;
      })
    );
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (has(node2, "rank")) {
        node2.rank -= min2;
      }
    });
  }
  function removeEmptyRanks(g) {
    var offset2 = min$1(
      map(g.nodes(), function(v) {
        return g.node(v).rank;
      })
    );
    var layers = [];
    forEach(g.nodes(), function(v) {
      var rank2 = g.node(v).rank - offset2;
      if (!layers[rank2]) {
        layers[rank2] = [];
      }
      layers[rank2].push(v);
    });
    var delta = 0;
    var nodeRankFactor = g.graph().nodeRankFactor;
    forEach(layers, function(vs, i2) {
      if (isUndefined(vs) && i2 % nodeRankFactor !== 0) {
        --delta;
      } else if (delta) {
        forEach(vs, function(v) {
          g.node(v).rank += delta;
        });
      }
    });
  }
  function addBorderNode$1(g, prefix, rank2, order2) {
    var node2 = {
      width: 0,
      height: 0
    };
    if (arguments.length >= 4) {
      node2.rank = rank2;
      node2.order = order2;
    }
    return addDummyNode(g, "border", node2, prefix);
  }
  function maxRank(g) {
    return max$1(
      map(g.nodes(), function(v) {
        var rank2 = g.node(v).rank;
        if (!isUndefined(rank2)) {
          return rank2;
        }
      })
    );
  }
  function partition(collection2, fn2) {
    var result = { lhs: [], rhs: [] };
    forEach(collection2, function(value) {
      if (fn2(value)) {
        result.lhs.push(value);
      } else {
        result.rhs.push(value);
      }
    });
    return result;
  }
  function time(name2, fn2) {
    var start2 = now$3();
    try {
      return fn2();
    } finally {
      console.log(name2 + " time: " + (now$3() - start2) + "ms");
    }
  }
  function notime(name2, fn2) {
    return fn2();
  }
  function addBorderSegments(g) {
    function dfs2(v) {
      var children2 = g.children(v);
      var node2 = g.node(v);
      if (children2.length) {
        forEach(children2, dfs2);
      }
      if (has(node2, "minRank")) {
        node2.borderLeft = [];
        node2.borderRight = [];
        for (var rank2 = node2.minRank, maxRank2 = node2.maxRank + 1; rank2 < maxRank2; ++rank2) {
          addBorderNode(g, "borderLeft", "_bl", v, node2, rank2);
          addBorderNode(g, "borderRight", "_br", v, node2, rank2);
        }
      }
    }
    forEach(g.children(), dfs2);
  }
  function addBorderNode(g, prop, prefix, sg, sgNode, rank2) {
    var label = { width: 0, height: 0, rank: rank2, borderType: prop };
    var prev2 = sgNode[prop][rank2 - 1];
    var curr = addDummyNode(g, "border", label, prefix);
    sgNode[prop][rank2] = curr;
    g.setParent(curr, sg);
    if (prev2) {
      g.setEdge(prev2, curr, { weight: 1 });
    }
  }
  function adjust(g) {
    var rankDir = g.graph().rankdir.toLowerCase();
    if (rankDir === "lr" || rankDir === "rl") {
      swapWidthHeight(g);
    }
  }
  function undo$1(g) {
    var rankDir = g.graph().rankdir.toLowerCase();
    if (rankDir === "bt" || rankDir === "rl") {
      reverseY(g);
    }
    if (rankDir === "lr" || rankDir === "rl") {
      swapXY(g);
      swapWidthHeight(g);
    }
  }
  function swapWidthHeight(g) {
    forEach(g.nodes(), function(v) {
      swapWidthHeightOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      swapWidthHeightOne(g.edge(e));
    });
  }
  function swapWidthHeightOne(attrs) {
    var w2 = attrs.width;
    attrs.width = attrs.height;
    attrs.height = w2;
  }
  function reverseY(g) {
    forEach(g.nodes(), function(v) {
      reverseYOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, reverseYOne);
      if (has(edge, "y")) {
        reverseYOne(edge);
      }
    });
  }
  function reverseYOne(attrs) {
    attrs.y = -attrs.y;
  }
  function swapXY(g) {
    forEach(g.nodes(), function(v) {
      swapXYOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, swapXYOne);
      if (has(edge, "x")) {
        swapXYOne(edge);
      }
    });
  }
  function swapXYOne(attrs) {
    var x2 = attrs.x;
    attrs.x = attrs.y;
    attrs.y = x2;
  }
  function run$1(g) {
    var root2 = addDummyNode(g, "root", {}, "_root");
    var depths = treeDepths(g);
    var height2 = max$1(values(depths)) - 1;
    var nodeSep = 2 * height2 + 1;
    g.graph().nestingRoot = root2;
    forEach(g.edges(), function(e) {
      g.edge(e).minlen *= nodeSep;
    });
    var weight = sumWeights(g) + 1;
    forEach(g.children(), function(child) {
      dfs$1(g, root2, nodeSep, weight, height2, depths, child);
    });
    g.graph().nodeRankFactor = nodeSep;
  }
  function dfs$1(g, root2, nodeSep, weight, height2, depths, v) {
    var children2 = g.children(v);
    if (!children2.length) {
      if (v !== root2) {
        g.setEdge(root2, v, { weight: 0, minlen: nodeSep });
      }
      return;
    }
    var top2 = addBorderNode$1(g, "_bt");
    var bottom2 = addBorderNode$1(g, "_bb");
    var label = g.node(v);
    g.setParent(top2, v);
    label.borderTop = top2;
    g.setParent(bottom2, v);
    label.borderBottom = bottom2;
    forEach(children2, function(child) {
      dfs$1(g, root2, nodeSep, weight, height2, depths, child);
      var childNode = g.node(child);
      var childTop = childNode.borderTop ? childNode.borderTop : child;
      var childBottom = childNode.borderBottom ? childNode.borderBottom : child;
      var thisWeight = childNode.borderTop ? weight : 2 * weight;
      var minlen = childTop !== childBottom ? 1 : height2 - depths[v] + 1;
      g.setEdge(top2, childTop, {
        weight: thisWeight,
        minlen,
        nestingEdge: true
      });
      g.setEdge(childBottom, bottom2, {
        weight: thisWeight,
        minlen,
        nestingEdge: true
      });
    });
    if (!g.parent(v)) {
      g.setEdge(root2, top2, { weight: 0, minlen: height2 + depths[v] });
    }
  }
  function treeDepths(g) {
    var depths = {};
    function dfs2(v, depth) {
      var children2 = g.children(v);
      if (children2 && children2.length) {
        forEach(children2, function(child) {
          dfs2(child, depth + 1);
        });
      }
      depths[v] = depth;
    }
    forEach(g.children(), function(v) {
      dfs2(v, 1);
    });
    return depths;
  }
  function sumWeights(g) {
    return reduce(
      g.edges(),
      function(acc, e) {
        return acc + g.edge(e).weight;
      },
      0
    );
  }
  function cleanup(g) {
    var graphLabel = g.graph();
    g.removeNode(graphLabel.nestingRoot);
    delete graphLabel.nestingRoot;
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.nestingEdge) {
        g.removeEdge(e);
      }
    });
  }
  function addSubgraphConstraints(g, cg, vs) {
    var prev2 = {}, rootPrev;
    forEach(vs, function(v) {
      var child = g.parent(v), parent, prevChild;
      while (child) {
        parent = g.parent(child);
        if (parent) {
          prevChild = prev2[parent];
          prev2[parent] = child;
        } else {
          prevChild = rootPrev;
          rootPrev = child;
        }
        if (prevChild && prevChild !== child) {
          cg.setEdge(prevChild, child);
          return;
        }
        child = parent;
      }
    });
  }
  function buildLayerGraph(g, rank2, relationship) {
    var root2 = createRootNode(g), result = new Graph({ compound: true }).setGraph({ root: root2 }).setDefaultNodeLabel(function(v) {
      return g.node(v);
    });
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v), parent = g.parent(v);
      if (node2.rank === rank2 || node2.minRank <= rank2 && rank2 <= node2.maxRank) {
        result.setNode(v);
        result.setParent(v, parent || root2);
        forEach(g[relationship](v), function(e) {
          var u = e.v === v ? e.w : e.v, edge = result.edge(u, v), weight = !isUndefined(edge) ? edge.weight : 0;
          result.setEdge(u, v, { weight: g.edge(e).weight + weight });
        });
        if (has(node2, "minRank")) {
          result.setNode(v, {
            borderLeft: node2.borderLeft[rank2],
            borderRight: node2.borderRight[rank2]
          });
        }
      }
    });
    return result;
  }
  function createRootNode(g) {
    var v;
    while (g.hasNode(v = uniqueId("_root")))
      ;
    return v;
  }
  function crossCount(g, layering) {
    var cc = 0;
    for (var i2 = 1; i2 < layering.length; ++i2) {
      cc += twoLayerCrossCount(g, layering[i2 - 1], layering[i2]);
    }
    return cc;
  }
  function twoLayerCrossCount(g, northLayer, southLayer) {
    var southPos = zipObject(
      southLayer,
      map(southLayer, function(v, i2) {
        return i2;
      })
    );
    var southEntries = flatten(
      map(northLayer, function(v) {
        return sortBy$1(
          map(g.outEdges(v), function(e) {
            return { pos: southPos[e.w], weight: g.edge(e).weight };
          }),
          "pos"
        );
      })
    );
    var firstIndex = 1;
    while (firstIndex < southLayer.length)
      firstIndex <<= 1;
    var treeSize = 2 * firstIndex - 1;
    firstIndex -= 1;
    var tree = map(new Array(treeSize), function() {
      return 0;
    });
    var cc = 0;
    forEach(
      southEntries.forEach(function(entry) {
        var index = entry.pos + firstIndex;
        tree[index] += entry.weight;
        var weightSum = 0;
        while (index > 0) {
          if (index % 2) {
            weightSum += tree[index + 1];
          }
          index = index - 1 >> 1;
          tree[index] += entry.weight;
        }
        cc += entry.weight * weightSum;
      })
    );
    return cc;
  }
  function initOrder(g) {
    var visited = {};
    var simpleNodes = filter$1(g.nodes(), function(v) {
      return !g.children(v).length;
    });
    var maxRank2 = max$1(
      map(simpleNodes, function(v) {
        return g.node(v).rank;
      })
    );
    var layers = map(range$1(maxRank2 + 1), function() {
      return [];
    });
    function dfs2(v) {
      if (has(visited, v))
        return;
      visited[v] = true;
      var node2 = g.node(v);
      layers[node2.rank].push(v);
      forEach(g.successors(v), dfs2);
    }
    var orderedVs = sortBy$1(simpleNodes, function(v) {
      return g.node(v).rank;
    });
    forEach(orderedVs, dfs2);
    return layers;
  }
  function barycenter(g, movable) {
    return map(movable, function(v) {
      var inV = g.inEdges(v);
      if (!inV.length) {
        return { v };
      } else {
        var result = reduce(
          inV,
          function(acc, e) {
            var edge = g.edge(e), nodeU = g.node(e.v);
            return {
              sum: acc.sum + edge.weight * nodeU.order,
              weight: acc.weight + edge.weight
            };
          },
          { sum: 0, weight: 0 }
        );
        return {
          v,
          barycenter: result.sum / result.weight,
          weight: result.weight
        };
      }
    });
  }
  function resolveConflicts(entries, cg) {
    var mappedEntries = {};
    forEach(entries, function(entry, i2) {
      var tmp = mappedEntries[entry.v] = {
        indegree: 0,
        in: [],
        out: [],
        vs: [entry.v],
        i: i2
      };
      if (!isUndefined(entry.barycenter)) {
        tmp.barycenter = entry.barycenter;
        tmp.weight = entry.weight;
      }
    });
    forEach(cg.edges(), function(e) {
      var entryV = mappedEntries[e.v];
      var entryW = mappedEntries[e.w];
      if (!isUndefined(entryV) && !isUndefined(entryW)) {
        entryW.indegree++;
        entryV.out.push(mappedEntries[e.w]);
      }
    });
    var sourceSet = filter$1(mappedEntries, function(entry) {
      return !entry.indegree;
    });
    return doResolveConflicts(sourceSet);
  }
  function doResolveConflicts(sourceSet) {
    var entries = [];
    function handleIn(vEntry) {
      return function(uEntry) {
        if (uEntry.merged) {
          return;
        }
        if (isUndefined(uEntry.barycenter) || isUndefined(vEntry.barycenter) || uEntry.barycenter >= vEntry.barycenter) {
          mergeEntries(vEntry, uEntry);
        }
      };
    }
    function handleOut(vEntry) {
      return function(wEntry) {
        wEntry["in"].push(vEntry);
        if (--wEntry.indegree === 0) {
          sourceSet.push(wEntry);
        }
      };
    }
    while (sourceSet.length) {
      var entry = sourceSet.pop();
      entries.push(entry);
      forEach(entry["in"].reverse(), handleIn(entry));
      forEach(entry.out, handleOut(entry));
    }
    return map(
      filter$1(entries, function(entry2) {
        return !entry2.merged;
      }),
      function(entry2) {
        return pick$1(entry2, ["vs", "i", "barycenter", "weight"]);
      }
    );
  }
  function mergeEntries(target, source) {
    var sum = 0;
    var weight = 0;
    if (target.weight) {
      sum += target.barycenter * target.weight;
      weight += target.weight;
    }
    if (source.weight) {
      sum += source.barycenter * source.weight;
      weight += source.weight;
    }
    target.vs = source.vs.concat(target.vs);
    target.barycenter = sum / weight;
    target.weight = weight;
    target.i = Math.min(source.i, target.i);
    source.merged = true;
  }
  function sort(entries, biasRight) {
    var parts = partition(entries, function(entry) {
      return has(entry, "barycenter");
    });
    var sortable = parts.lhs, unsortable = sortBy$1(parts.rhs, function(entry) {
      return -entry.i;
    }), vs = [], sum = 0, weight = 0, vsIndex = 0;
    sortable.sort(compareWithBias(!!biasRight));
    vsIndex = consumeUnsortable(vs, unsortable, vsIndex);
    forEach(sortable, function(entry) {
      vsIndex += entry.vs.length;
      vs.push(entry.vs);
      sum += entry.barycenter * entry.weight;
      weight += entry.weight;
      vsIndex = consumeUnsortable(vs, unsortable, vsIndex);
    });
    var result = { vs: flatten(vs) };
    if (weight) {
      result.barycenter = sum / weight;
      result.weight = weight;
    }
    return result;
  }
  function consumeUnsortable(vs, unsortable, index) {
    var last$1;
    while (unsortable.length && (last$1 = last(unsortable)).i <= index) {
      unsortable.pop();
      vs.push(last$1.vs);
      index++;
    }
    return index;
  }
  function compareWithBias(bias) {
    return function(entryV, entryW) {
      if (entryV.barycenter < entryW.barycenter) {
        return -1;
      } else if (entryV.barycenter > entryW.barycenter) {
        return 1;
      }
      return !bias ? entryV.i - entryW.i : entryW.i - entryV.i;
    };
  }
  function sortSubgraph(g, v, cg, biasRight) {
    var movable = g.children(v);
    var node2 = g.node(v);
    var bl = node2 ? node2.borderLeft : void 0;
    var br = node2 ? node2.borderRight : void 0;
    var subgraphs = {};
    if (bl) {
      movable = filter$1(movable, function(w2) {
        return w2 !== bl && w2 !== br;
      });
    }
    var barycenters = barycenter(g, movable);
    forEach(barycenters, function(entry) {
      if (g.children(entry.v).length) {
        var subgraphResult = sortSubgraph(g, entry.v, cg, biasRight);
        subgraphs[entry.v] = subgraphResult;
        if (has(subgraphResult, "barycenter")) {
          mergeBarycenters(entry, subgraphResult);
        }
      }
    });
    var entries = resolveConflicts(barycenters, cg);
    expandSubgraphs(entries, subgraphs);
    var result = sort(entries, biasRight);
    if (bl) {
      result.vs = flatten([bl, result.vs, br]);
      if (g.predecessors(bl).length) {
        var blPred = g.node(g.predecessors(bl)[0]), brPred = g.node(g.predecessors(br)[0]);
        if (!has(result, "barycenter")) {
          result.barycenter = 0;
          result.weight = 0;
        }
        result.barycenter = (result.barycenter * result.weight + blPred.order + brPred.order) / (result.weight + 2);
        result.weight += 2;
      }
    }
    return result;
  }
  function expandSubgraphs(entries, subgraphs) {
    forEach(entries, function(entry) {
      entry.vs = flatten(
        entry.vs.map(function(v) {
          if (subgraphs[v]) {
            return subgraphs[v].vs;
          }
          return v;
        })
      );
    });
  }
  function mergeBarycenters(target, other) {
    if (!isUndefined(target.barycenter)) {
      target.barycenter = (target.barycenter * target.weight + other.barycenter * other.weight) / (target.weight + other.weight);
      target.weight += other.weight;
    } else {
      target.barycenter = other.barycenter;
      target.weight = other.weight;
    }
  }
  function order(g) {
    var maxRank$1 = maxRank(g), downLayerGraphs = buildLayerGraphs(g, range$1(1, maxRank$1 + 1), "inEdges"), upLayerGraphs = buildLayerGraphs(g, range$1(maxRank$1 - 1, -1, -1), "outEdges");
    var layering = initOrder(g);
    assignOrder(g, layering);
    var bestCC = Number.POSITIVE_INFINITY, best;
    for (var i2 = 0, lastBest = 0; lastBest < 4; ++i2, ++lastBest) {
      sweepLayerGraphs(i2 % 2 ? downLayerGraphs : upLayerGraphs, i2 % 4 >= 2);
      layering = buildLayerMatrix(g);
      var cc = crossCount(g, layering);
      if (cc < bestCC) {
        lastBest = 0;
        best = cloneDeep(layering);
        bestCC = cc;
      }
    }
    assignOrder(g, best);
  }
  function buildLayerGraphs(g, ranks, relationship) {
    return map(ranks, function(rank2) {
      return buildLayerGraph(g, rank2, relationship);
    });
  }
  function sweepLayerGraphs(layerGraphs, biasRight) {
    var cg = new Graph();
    forEach(layerGraphs, function(lg) {
      var root2 = lg.graph().root;
      var sorted = sortSubgraph(lg, root2, cg, biasRight);
      forEach(sorted.vs, function(v, i2) {
        lg.node(v).order = i2;
      });
      addSubgraphConstraints(lg, cg, sorted.vs);
    });
  }
  function assignOrder(g, layering) {
    forEach(layering, function(layer) {
      forEach(layer, function(v, i2) {
        g.node(v).order = i2;
      });
    });
  }
  function parentDummyChains(g) {
    var postorderNums = postorder$1(g);
    forEach(g.graph().dummyChains, function(v) {
      var node2 = g.node(v);
      var edgeObj = node2.edgeObj;
      var pathData = findPath(g, postorderNums, edgeObj.v, edgeObj.w);
      var path2 = pathData.path;
      var lca = pathData.lca;
      var pathIdx = 0;
      var pathV = path2[pathIdx];
      var ascending2 = true;
      while (v !== edgeObj.w) {
        node2 = g.node(v);
        if (ascending2) {
          while ((pathV = path2[pathIdx]) !== lca && g.node(pathV).maxRank < node2.rank) {
            pathIdx++;
          }
          if (pathV === lca) {
            ascending2 = false;
          }
        }
        if (!ascending2) {
          while (pathIdx < path2.length - 1 && g.node(pathV = path2[pathIdx + 1]).minRank <= node2.rank) {
            pathIdx++;
          }
          pathV = path2[pathIdx];
        }
        g.setParent(v, pathV);
        v = g.successors(v)[0];
      }
    });
  }
  function findPath(g, postorderNums, v, w2) {
    var vPath = [];
    var wPath = [];
    var low = Math.min(postorderNums[v].low, postorderNums[w2].low);
    var lim = Math.max(postorderNums[v].lim, postorderNums[w2].lim);
    var parent;
    var lca;
    parent = v;
    do {
      parent = g.parent(parent);
      vPath.push(parent);
    } while (parent && (postorderNums[parent].low > low || lim > postorderNums[parent].lim));
    lca = parent;
    parent = w2;
    while ((parent = g.parent(parent)) !== lca) {
      wPath.push(parent);
    }
    return { path: vPath.concat(wPath.reverse()), lca };
  }
  function postorder$1(g) {
    var result = {};
    var lim = 0;
    function dfs2(v) {
      var low = lim;
      forEach(g.children(v), dfs2);
      result[v] = { low, lim: lim++ };
    }
    forEach(g.children(), dfs2);
    return result;
  }
  function findType1Conflicts(g, layering) {
    var conflicts = {};
    function visitLayer(prevLayer, layer) {
      var k0 = 0, scanPos = 0, prevLayerLength = prevLayer.length, lastNode = last(layer);
      forEach(layer, function(v, i2) {
        var w2 = findOtherInnerSegmentNode(g, v), k1 = w2 ? g.node(w2).order : prevLayerLength;
        if (w2 || v === lastNode) {
          forEach(layer.slice(scanPos, i2 + 1), function(scanNode) {
            forEach(g.predecessors(scanNode), function(u) {
              var uLabel = g.node(u), uPos = uLabel.order;
              if ((uPos < k0 || k1 < uPos) && !(uLabel.dummy && g.node(scanNode).dummy)) {
                addConflict(conflicts, u, scanNode);
              }
            });
          });
          scanPos = i2 + 1;
          k0 = k1;
        }
      });
      return layer;
    }
    reduce(layering, visitLayer);
    return conflicts;
  }
  function findType2Conflicts(g, layering) {
    var conflicts = {};
    function scan(south, southPos, southEnd, prevNorthBorder, nextNorthBorder) {
      var v;
      forEach(range$1(southPos, southEnd), function(i2) {
        v = south[i2];
        if (g.node(v).dummy) {
          forEach(g.predecessors(v), function(u) {
            var uNode = g.node(u);
            if (uNode.dummy && (uNode.order < prevNorthBorder || uNode.order > nextNorthBorder)) {
              addConflict(conflicts, u, v);
            }
          });
        }
      });
    }
    function visitLayer(north, south) {
      var prevNorthPos = -1, nextNorthPos, southPos = 0;
      forEach(south, function(v, southLookahead) {
        if (g.node(v).dummy === "border") {
          var predecessors = g.predecessors(v);
          if (predecessors.length) {
            nextNorthPos = g.node(predecessors[0]).order;
            scan(south, southPos, southLookahead, prevNorthPos, nextNorthPos);
            southPos = southLookahead;
            prevNorthPos = nextNorthPos;
          }
        }
        scan(south, southPos, south.length, nextNorthPos, north.length);
      });
      return south;
    }
    reduce(layering, visitLayer);
    return conflicts;
  }
  function findOtherInnerSegmentNode(g, v) {
    if (g.node(v).dummy) {
      return find$1(g.predecessors(v), function(u) {
        return g.node(u).dummy;
      });
    }
  }
  function addConflict(conflicts, v, w2) {
    if (v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    var conflictsV = conflicts[v];
    if (!conflictsV) {
      conflicts[v] = conflictsV = {};
    }
    conflictsV[w2] = true;
  }
  function hasConflict(conflicts, v, w2) {
    if (v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    return has(conflicts[v], w2);
  }
  function verticalAlignment(g, layering, conflicts, neighborFn) {
    var root2 = {}, align = {}, pos = {};
    forEach(layering, function(layer) {
      forEach(layer, function(v, order2) {
        root2[v] = v;
        align[v] = v;
        pos[v] = order2;
      });
    });
    forEach(layering, function(layer) {
      var prevIdx = -1;
      forEach(layer, function(v) {
        var ws = neighborFn(v);
        if (ws.length) {
          ws = sortBy$1(ws, function(w3) {
            return pos[w3];
          });
          var mp = (ws.length - 1) / 2;
          for (var i2 = Math.floor(mp), il = Math.ceil(mp); i2 <= il; ++i2) {
            var w2 = ws[i2];
            if (align[v] === v && prevIdx < pos[w2] && !hasConflict(conflicts, v, w2)) {
              align[w2] = v;
              align[v] = root2[v] = root2[w2];
              prevIdx = pos[w2];
            }
          }
        }
      });
    });
    return { root: root2, align };
  }
  function horizontalCompaction(g, layering, root2, align, reverseSep) {
    var xs = {}, blockG = buildBlockGraph(g, layering, root2, reverseSep), borderType = reverseSep ? "borderLeft" : "borderRight";
    function iterate(setXsFunc, nextNodesFunc) {
      var stack = blockG.nodes();
      var elem = stack.pop();
      var visited = {};
      while (elem) {
        if (visited[elem]) {
          setXsFunc(elem);
        } else {
          visited[elem] = true;
          stack.push(elem);
          stack = stack.concat(nextNodesFunc(elem));
        }
        elem = stack.pop();
      }
    }
    function pass1(elem) {
      xs[elem] = blockG.inEdges(elem).reduce(function(acc, e) {
        return Math.max(acc, xs[e.v] + blockG.edge(e));
      }, 0);
    }
    function pass2(elem) {
      var min2 = blockG.outEdges(elem).reduce(function(acc, e) {
        return Math.min(acc, xs[e.w] - blockG.edge(e));
      }, Number.POSITIVE_INFINITY);
      var node2 = g.node(elem);
      if (min2 !== Number.POSITIVE_INFINITY && node2.borderType !== borderType) {
        xs[elem] = Math.max(xs[elem], min2);
      }
    }
    iterate(pass1, blockG.predecessors.bind(blockG));
    iterate(pass2, blockG.successors.bind(blockG));
    forEach(align, function(v) {
      xs[v] = xs[root2[v]];
    });
    return xs;
  }
  function buildBlockGraph(g, layering, root2, reverseSep) {
    var blockGraph = new Graph(), graphLabel = g.graph(), sepFn = sep(graphLabel.nodesep, graphLabel.edgesep, reverseSep);
    forEach(layering, function(layer) {
      var u;
      forEach(layer, function(v) {
        var vRoot = root2[v];
        blockGraph.setNode(vRoot);
        if (u) {
          var uRoot = root2[u], prevMax = blockGraph.edge(uRoot, vRoot);
          blockGraph.setEdge(uRoot, vRoot, Math.max(sepFn(g, v, u), prevMax || 0));
        }
        u = v;
      });
    });
    return blockGraph;
  }
  function findSmallestWidthAlignment(g, xss) {
    return minBy(values(xss), function(xs) {
      var max2 = Number.NEGATIVE_INFINITY;
      var min2 = Number.POSITIVE_INFINITY;
      forIn(xs, function(x2, v) {
        var halfWidth = width$1(g, v) / 2;
        max2 = Math.max(x2 + halfWidth, max2);
        min2 = Math.min(x2 - halfWidth, min2);
      });
      return max2 - min2;
    });
  }
  function alignCoordinates(xss, alignTo) {
    var alignToVals = values(alignTo), alignToMin = min$1(alignToVals), alignToMax = max$1(alignToVals);
    forEach(["u", "d"], function(vert) {
      forEach(["l", "r"], function(horiz) {
        var alignment = vert + horiz, xs = xss[alignment], delta;
        if (xs === alignTo)
          return;
        var xsVals = values(xs);
        delta = horiz === "l" ? alignToMin - min$1(xsVals) : alignToMax - max$1(xsVals);
        if (delta) {
          xss[alignment] = mapValues(xs, function(x2) {
            return x2 + delta;
          });
        }
      });
    });
  }
  function balance(xss, align) {
    return mapValues(xss.ul, function(ignore, v) {
      if (align) {
        return xss[align.toLowerCase()][v];
      } else {
        var xs = sortBy$1(map(xss, v));
        return (xs[1] + xs[2]) / 2;
      }
    });
  }
  function positionX(g) {
    var layering = buildLayerMatrix(g);
    var conflicts = merge$1(findType1Conflicts(g, layering), findType2Conflicts(g, layering));
    var xss = {};
    var adjustedLayering;
    forEach(["u", "d"], function(vert) {
      adjustedLayering = vert === "u" ? layering : values(layering).reverse();
      forEach(["l", "r"], function(horiz) {
        if (horiz === "r") {
          adjustedLayering = map(adjustedLayering, function(inner) {
            return values(inner).reverse();
          });
        }
        var neighborFn = (vert === "u" ? g.predecessors : g.successors).bind(g);
        var align = verticalAlignment(g, adjustedLayering, conflicts, neighborFn);
        var xs = horizontalCompaction(g, adjustedLayering, align.root, align.align, horiz === "r");
        if (horiz === "r") {
          xs = mapValues(xs, function(x2) {
            return -x2;
          });
        }
        xss[vert + horiz] = xs;
      });
    });
    var smallestWidth = findSmallestWidthAlignment(g, xss);
    alignCoordinates(xss, smallestWidth);
    return balance(xss, g.graph().align);
  }
  function sep(nodeSep, edgeSep, reverseSep) {
    return function(g, v, w2) {
      var vLabel = g.node(v);
      var wLabel = g.node(w2);
      var sum = 0;
      var delta;
      sum += vLabel.width / 2;
      if (has(vLabel, "labelpos")) {
        switch (vLabel.labelpos.toLowerCase()) {
          case "l":
            delta = -vLabel.width / 2;
            break;
          case "r":
            delta = vLabel.width / 2;
            break;
        }
      }
      if (delta) {
        sum += reverseSep ? delta : -delta;
      }
      delta = 0;
      sum += (vLabel.dummy ? edgeSep : nodeSep) / 2;
      sum += (wLabel.dummy ? edgeSep : nodeSep) / 2;
      sum += wLabel.width / 2;
      if (has(wLabel, "labelpos")) {
        switch (wLabel.labelpos.toLowerCase()) {
          case "l":
            delta = wLabel.width / 2;
            break;
          case "r":
            delta = -wLabel.width / 2;
            break;
        }
      }
      if (delta) {
        sum += reverseSep ? delta : -delta;
      }
      delta = 0;
      return sum;
    };
  }
  function width$1(g, v) {
    return g.node(v).width;
  }
  function position$1(g) {
    g = asNonCompoundGraph(g);
    positionY(g);
    forEach(positionX(g), function(x2, v) {
      g.node(v).x = x2;
    });
  }
  function positionY(g) {
    var layering = buildLayerMatrix(g);
    var rankSep = g.graph().ranksep;
    var prevY = 0;
    forEach(layering, function(layer) {
      var maxHeight = max$1(
        map(layer, function(v) {
          return g.node(v).height;
        })
      );
      forEach(layer, function(v) {
        g.node(v).y = prevY + maxHeight / 2;
      });
      prevY += maxHeight + rankSep;
    });
  }
  function layout$1(g, opts) {
    var time$12 = opts && opts.debugTiming ? time : notime;
    time$12("layout", function() {
      var layoutGraph = time$12("  buildLayoutGraph", function() {
        return buildLayoutGraph(g);
      });
      time$12("  runLayout", function() {
        runLayout(layoutGraph, time$12);
      });
      time$12("  updateInputGraph", function() {
        updateInputGraph(g, layoutGraph);
      });
    });
  }
  function runLayout(g, time2) {
    time2("    makeSpaceForEdgeLabels", function() {
      makeSpaceForEdgeLabels(g);
    });
    time2("    removeSelfEdges", function() {
      removeSelfEdges(g);
    });
    time2("    acyclic", function() {
      run$2(g);
    });
    time2("    nestingGraph.run", function() {
      run$1(g);
    });
    time2("    rank", function() {
      rank(asNonCompoundGraph(g));
    });
    time2("    injectEdgeLabelProxies", function() {
      injectEdgeLabelProxies(g);
    });
    time2("    removeEmptyRanks", function() {
      removeEmptyRanks(g);
    });
    time2("    nestingGraph.cleanup", function() {
      cleanup(g);
    });
    time2("    normalizeRanks", function() {
      normalizeRanks(g);
    });
    time2("    assignRankMinMax", function() {
      assignRankMinMax(g);
    });
    time2("    removeEdgeLabelProxies", function() {
      removeEdgeLabelProxies(g);
    });
    time2("    normalize.run", function() {
      run(g);
    });
    time2("    parentDummyChains", function() {
      parentDummyChains(g);
    });
    time2("    addBorderSegments", function() {
      addBorderSegments(g);
    });
    time2("    order", function() {
      order(g);
    });
    time2("    insertSelfEdges", function() {
      insertSelfEdges(g);
    });
    time2("    adjustCoordinateSystem", function() {
      adjust(g);
    });
    time2("    position", function() {
      position$1(g);
    });
    time2("    positionSelfEdges", function() {
      positionSelfEdges(g);
    });
    time2("    removeBorderNodes", function() {
      removeBorderNodes(g);
    });
    time2("    normalize.undo", function() {
      undo(g);
    });
    time2("    fixupEdgeLabelCoords", function() {
      fixupEdgeLabelCoords(g);
    });
    time2("    undoCoordinateSystem", function() {
      undo$1(g);
    });
    time2("    translateGraph", function() {
      translateGraph(g);
    });
    time2("    assignNodeIntersects", function() {
      assignNodeIntersects(g);
    });
    time2("    reversePoints", function() {
      reversePointsForReversedEdges(g);
    });
    time2("    acyclic.undo", function() {
      undo$2(g);
    });
  }
  function updateInputGraph(inputGraph, layoutGraph) {
    forEach(inputGraph.nodes(), function(v) {
      var inputLabel = inputGraph.node(v);
      var layoutLabel = layoutGraph.node(v);
      if (inputLabel) {
        inputLabel.x = layoutLabel.x;
        inputLabel.y = layoutLabel.y;
        if (layoutGraph.children(v).length) {
          inputLabel.width = layoutLabel.width;
          inputLabel.height = layoutLabel.height;
        }
      }
    });
    forEach(inputGraph.edges(), function(e) {
      var inputLabel = inputGraph.edge(e);
      var layoutLabel = layoutGraph.edge(e);
      inputLabel.points = layoutLabel.points;
      if (has(layoutLabel, "x")) {
        inputLabel.x = layoutLabel.x;
        inputLabel.y = layoutLabel.y;
      }
    });
    inputGraph.graph().width = layoutGraph.graph().width;
    inputGraph.graph().height = layoutGraph.graph().height;
  }
  var graphNumAttrs = ["nodesep", "edgesep", "ranksep", "marginx", "marginy"];
  var graphDefaults = { ranksep: 50, edgesep: 20, nodesep: 50, rankdir: "tb" };
  var graphAttrs = ["acyclicer", "ranker", "rankdir", "align"];
  var nodeNumAttrs = ["width", "height"];
  var nodeDefaults = { width: 0, height: 0 };
  var edgeNumAttrs = ["minlen", "weight", "width", "height", "labeloffset"];
  var edgeDefaults = {
    minlen: 1,
    weight: 1,
    width: 0,
    height: 0,
    labeloffset: 10,
    labelpos: "r"
  };
  var edgeAttrs = ["labelpos"];
  function buildLayoutGraph(inputGraph) {
    var g = new Graph({ multigraph: true, compound: true });
    var graph = canonicalize(inputGraph.graph());
    g.setGraph(
      merge$1({}, graphDefaults, selectNumberAttrs(graph, graphNumAttrs), pick$1(graph, graphAttrs))
    );
    forEach(inputGraph.nodes(), function(v) {
      var node2 = canonicalize(inputGraph.node(v));
      g.setNode(v, defaults$i(selectNumberAttrs(node2, nodeNumAttrs), nodeDefaults));
      g.setParent(v, inputGraph.parent(v));
    });
    forEach(inputGraph.edges(), function(e) {
      var edge = canonicalize(inputGraph.edge(e));
      g.setEdge(
        e,
        merge$1({}, edgeDefaults, selectNumberAttrs(edge, edgeNumAttrs), pick$1(edge, edgeAttrs))
      );
    });
    return g;
  }
  function makeSpaceForEdgeLabels(g) {
    var graph = g.graph();
    graph.ranksep /= 2;
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      edge.minlen *= 2;
      if (edge.labelpos.toLowerCase() !== "c") {
        if (graph.rankdir === "TB" || graph.rankdir === "BT") {
          edge.width += edge.labeloffset;
        } else {
          edge.height += edge.labeloffset;
        }
      }
    });
  }
  function injectEdgeLabelProxies(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.width && edge.height) {
        var v = g.node(e.v);
        var w2 = g.node(e.w);
        var label = { rank: (w2.rank - v.rank) / 2 + v.rank, e };
        addDummyNode(g, "edge-proxy", label, "_ep");
      }
    });
  }
  function assignRankMinMax(g) {
    var maxRank2 = 0;
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.borderTop) {
        node2.minRank = g.node(node2.borderTop).rank;
        node2.maxRank = g.node(node2.borderBottom).rank;
        maxRank2 = max$1(maxRank2, node2.maxRank);
      }
    });
    g.graph().maxRank = maxRank2;
  }
  function removeEdgeLabelProxies(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.dummy === "edge-proxy") {
        g.edge(node2.e).labelRank = node2.rank;
        g.removeNode(v);
      }
    });
  }
  function translateGraph(g) {
    var minX = Number.POSITIVE_INFINITY;
    var maxX = 0;
    var minY = Number.POSITIVE_INFINITY;
    var maxY = 0;
    var graphLabel = g.graph();
    var marginX = graphLabel.marginx || 0;
    var marginY = graphLabel.marginy || 0;
    function getExtremes(attrs) {
      var x2 = attrs.x;
      var y2 = attrs.y;
      var w2 = attrs.width;
      var h = attrs.height;
      minX = Math.min(minX, x2 - w2 / 2);
      maxX = Math.max(maxX, x2 + w2 / 2);
      minY = Math.min(minY, y2 - h / 2);
      maxY = Math.max(maxY, y2 + h / 2);
    }
    forEach(g.nodes(), function(v) {
      getExtremes(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (has(edge, "x")) {
        getExtremes(edge);
      }
    });
    minX -= marginX;
    minY -= marginY;
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      node2.x -= minX;
      node2.y -= minY;
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, function(p2) {
        p2.x -= minX;
        p2.y -= minY;
      });
      if (has(edge, "x")) {
        edge.x -= minX;
      }
      if (has(edge, "y")) {
        edge.y -= minY;
      }
    });
    graphLabel.width = maxX - minX + marginX;
    graphLabel.height = maxY - minY + marginY;
  }
  function assignNodeIntersects(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      var nodeV = g.node(e.v);
      var nodeW = g.node(e.w);
      var p1, p2;
      if (!edge.points) {
        edge.points = [];
        p1 = nodeW;
        p2 = nodeV;
      } else {
        p1 = edge.points[0];
        p2 = edge.points[edge.points.length - 1];
      }
      edge.points.unshift(intersectRect$3(nodeV, p1));
      edge.points.push(intersectRect$3(nodeW, p2));
    });
  }
  function fixupEdgeLabelCoords(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (has(edge, "x")) {
        if (edge.labelpos === "l" || edge.labelpos === "r") {
          edge.width -= edge.labeloffset;
        }
        switch (edge.labelpos) {
          case "l":
            edge.x -= edge.width / 2 + edge.labeloffset;
            break;
          case "r":
            edge.x += edge.width / 2 + edge.labeloffset;
            break;
        }
      }
    });
  }
  function reversePointsForReversedEdges(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.reversed) {
        edge.points.reverse();
      }
    });
  }
  function removeBorderNodes(g) {
    forEach(g.nodes(), function(v) {
      if (g.children(v).length) {
        var node2 = g.node(v);
        var t = g.node(node2.borderTop);
        var b = g.node(node2.borderBottom);
        var l = g.node(last(node2.borderLeft));
        var r = g.node(last(node2.borderRight));
        node2.width = Math.abs(r.x - l.x);
        node2.height = Math.abs(b.y - t.y);
        node2.x = l.x + node2.width / 2;
        node2.y = t.y + node2.height / 2;
      }
    });
    forEach(g.nodes(), function(v) {
      if (g.node(v).dummy === "border") {
        g.removeNode(v);
      }
    });
  }
  function removeSelfEdges(g) {
    forEach(g.edges(), function(e) {
      if (e.v === e.w) {
        var node2 = g.node(e.v);
        if (!node2.selfEdges) {
          node2.selfEdges = [];
        }
        node2.selfEdges.push({ e, label: g.edge(e) });
        g.removeEdge(e);
      }
    });
  }
  function insertSelfEdges(g) {
    var layers = buildLayerMatrix(g);
    forEach(layers, function(layer) {
      var orderShift = 0;
      forEach(layer, function(v, i2) {
        var node2 = g.node(v);
        node2.order = i2 + orderShift;
        forEach(node2.selfEdges, function(selfEdge) {
          addDummyNode(
            g,
            "selfedge",
            {
              width: selfEdge.label.width,
              height: selfEdge.label.height,
              rank: node2.rank,
              order: i2 + ++orderShift,
              e: selfEdge.e,
              label: selfEdge.label
            },
            "_se"
          );
        });
        delete node2.selfEdges;
      });
    });
  }
  function positionSelfEdges(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.dummy === "selfedge") {
        var selfNode = g.node(node2.e.v);
        var x2 = selfNode.x + selfNode.width / 2;
        var y2 = selfNode.y;
        var dx = node2.x - x2;
        var dy = selfNode.height / 2;
        g.setEdge(node2.e, node2.label);
        g.removeNode(v);
        node2.label.points = [
          { x: x2 + 2 * dx / 3, y: y2 - dy },
          { x: x2 + 5 * dx / 6, y: y2 - dy },
          { x: x2 + dx, y: y2 },
          { x: x2 + 5 * dx / 6, y: y2 + dy },
          { x: x2 + 2 * dx / 3, y: y2 + dy }
        ];
        node2.label.x = node2.x;
        node2.label.y = node2.y;
      }
    });
  }
  function selectNumberAttrs(obj, attrs) {
    return mapValues(pick$1(obj, attrs), Number);
  }
  function canonicalize(attrs) {
    var newAttrs = {};
    forEach(attrs, function(v, k) {
      newAttrs[k.toLowerCase()] = v;
    });
    return newAttrs;
  }
  function run(g) {
    g.graph().dummyChains = [];
    forEach(g.edges(), function(edge) {
      normalizeEdge(g, edge);
    });
  }
  function normalizeEdge(g, e) {
    var v = e.v;
    var vRank = g.node(v).rank;
    var w2 = e.w;
    var wRank = g.node(w2).rank;
    var name2 = e.name;
    var edgeLabel = g.edge(e);
    var labelRank = edgeLabel.labelRank;
    if (wRank === vRank + 1)
      return;
    g.removeEdge(e);
    var dummy, attrs, i2;
    for (i2 = 0, ++vRank; vRank < wRank; ++i2, ++vRank) {
      edgeLabel.points = [];
      attrs = {
        width: 0,
        height: 0,
        edgeLabel,
        edgeObj: e,
        rank: vRank
      };
      dummy = addDummyNode(g, "edge", attrs, "_d");
      if (vRank === labelRank) {
        attrs.width = edgeLabel.width;
        attrs.height = edgeLabel.height;
        attrs.dummy = "edge-label";
        attrs.labelpos = edgeLabel.labelpos;
      }
      g.setEdge(v, dummy, { weight: edgeLabel.weight }, name2);
      if (i2 === 0) {
        g.graph().dummyChains.push(dummy);
      }
      v = dummy;
    }
    g.setEdge(v, w2, { weight: edgeLabel.weight }, name2);
  }
  function undo(g) {
    forEach(g.graph().dummyChains, function(v) {
      var node2 = g.node(v);
      var origLabel = node2.edgeLabel;
      var w2;
      g.setEdge(node2.edgeObj, origLabel);
      while (node2.dummy) {
        w2 = g.successors(v)[0];
        g.removeNode(v);
        origLabel.points.push({ x: node2.x, y: node2.y });
        if (node2.dummy === "edge-label") {
          origLabel.x = node2.x;
          origLabel.y = node2.y;
          origLabel.width = node2.width;
          origLabel.height = node2.height;
        }
        v = w2;
        node2 = g.node(v);
      }
    });
  }
  function longestPath(g) {
    var visited = {};
    function dfs2(v) {
      var label = g.node(v);
      if (has(visited, v)) {
        return label.rank;
      }
      visited[v] = true;
      var rank2 = min$1(
        map(g.outEdges(v), function(e) {
          return dfs2(e.w) - g.edge(e).minlen;
        })
      );
      if (rank2 === Number.POSITIVE_INFINITY || rank2 === void 0 || rank2 === null) {
        rank2 = 0;
      }
      return label.rank = rank2;
    }
    forEach(g.sources(), dfs2);
  }
  function slack(g, e) {
    return g.node(e.w).rank - g.node(e.v).rank - g.edge(e).minlen;
  }
  function feasibleTree(g) {
    var t = new Graph({ directed: false });
    var start2 = g.nodes()[0];
    var size2 = g.nodeCount();
    t.setNode(start2, {});
    var edge, delta;
    while (tightTree(t, g) < size2) {
      edge = findMinSlackEdge(t, g);
      delta = t.hasNode(edge.v) ? slack(g, edge) : -slack(g, edge);
      shiftRanks(t, g, delta);
    }
    return t;
  }
  function tightTree(t, g) {
    function dfs2(v) {
      forEach(g.nodeEdges(v), function(e) {
        var edgeV = e.v, w2 = v === edgeV ? e.w : edgeV;
        if (!t.hasNode(w2) && !slack(g, e)) {
          t.setNode(w2, {});
          t.setEdge(v, w2, {});
          dfs2(w2);
        }
      });
    }
    forEach(t.nodes(), dfs2);
    return t.nodeCount();
  }
  function findMinSlackEdge(t, g) {
    return minBy(g.edges(), function(e) {
      if (t.hasNode(e.v) !== t.hasNode(e.w)) {
        return slack(g, e);
      }
    });
  }
  function shiftRanks(t, g, delta) {
    forEach(t.nodes(), function(v) {
      g.node(v).rank += delta;
    });
  }
  function CycleException() {
  }
  CycleException.prototype = new Error();
  function dfs(g, vs, order2) {
    if (!isArray$6(vs)) {
      vs = [vs];
    }
    var navigation = (g.isDirected() ? g.successors : g.neighbors).bind(g);
    var acc = [];
    var visited = {};
    forEach(vs, function(v) {
      if (!g.hasNode(v)) {
        throw new Error("Graph does not have node: " + v);
      }
      doDfs(g, v, order2 === "post", visited, navigation, acc);
    });
    return acc;
  }
  function doDfs(g, v, postorder2, visited, navigation, acc) {
    if (!has(visited, v)) {
      visited[v] = true;
      if (!postorder2) {
        acc.push(v);
      }
      forEach(navigation(v), function(w2) {
        doDfs(g, w2, postorder2, visited, navigation, acc);
      });
      if (postorder2) {
        acc.push(v);
      }
    }
  }
  function postorder(g, vs) {
    return dfs(g, vs, "post");
  }
  function preorder(g, vs) {
    return dfs(g, vs, "pre");
  }
  networkSimplex.initLowLimValues = initLowLimValues;
  networkSimplex.initCutValues = initCutValues;
  networkSimplex.calcCutValue = calcCutValue;
  networkSimplex.leaveEdge = leaveEdge;
  networkSimplex.enterEdge = enterEdge;
  networkSimplex.exchangeEdges = exchangeEdges;
  function networkSimplex(g) {
    g = simplify(g);
    longestPath(g);
    var t = feasibleTree(g);
    initLowLimValues(t);
    initCutValues(t, g);
    var e, f2;
    while (e = leaveEdge(t)) {
      f2 = enterEdge(t, g, e);
      exchangeEdges(t, g, e, f2);
    }
  }
  function initCutValues(t, g) {
    var vs = postorder(t, t.nodes());
    vs = vs.slice(0, vs.length - 1);
    forEach(vs, function(v) {
      assignCutValue(t, g, v);
    });
  }
  function assignCutValue(t, g, child) {
    var childLab = t.node(child);
    var parent = childLab.parent;
    t.edge(child, parent).cutvalue = calcCutValue(t, g, child);
  }
  function calcCutValue(t, g, child) {
    var childLab = t.node(child);
    var parent = childLab.parent;
    var childIsTail = true;
    var graphEdge = g.edge(child, parent);
    var cutValue = 0;
    if (!graphEdge) {
      childIsTail = false;
      graphEdge = g.edge(parent, child);
    }
    cutValue = graphEdge.weight;
    forEach(g.nodeEdges(child), function(e) {
      var isOutEdge = e.v === child, other = isOutEdge ? e.w : e.v;
      if (other !== parent) {
        var pointsToHead = isOutEdge === childIsTail, otherWeight = g.edge(e).weight;
        cutValue += pointsToHead ? otherWeight : -otherWeight;
        if (isTreeEdge(t, child, other)) {
          var otherCutValue = t.edge(child, other).cutvalue;
          cutValue += pointsToHead ? -otherCutValue : otherCutValue;
        }
      }
    });
    return cutValue;
  }
  function initLowLimValues(tree, root2) {
    if (arguments.length < 2) {
      root2 = tree.nodes()[0];
    }
    dfsAssignLowLim(tree, {}, 1, root2);
  }
  function dfsAssignLowLim(tree, visited, nextLim, v, parent) {
    var low = nextLim;
    var label = tree.node(v);
    visited[v] = true;
    forEach(tree.neighbors(v), function(w2) {
      if (!has(visited, w2)) {
        nextLim = dfsAssignLowLim(tree, visited, nextLim, w2, v);
      }
    });
    label.low = low;
    label.lim = nextLim++;
    if (parent) {
      label.parent = parent;
    } else {
      delete label.parent;
    }
    return nextLim;
  }
  function leaveEdge(tree) {
    return find$1(tree.edges(), function(e) {
      return tree.edge(e).cutvalue < 0;
    });
  }
  function enterEdge(t, g, edge) {
    var v = edge.v;
    var w2 = edge.w;
    if (!g.hasEdge(v, w2)) {
      v = edge.w;
      w2 = edge.v;
    }
    var vLabel = t.node(v);
    var wLabel = t.node(w2);
    var tailLabel = vLabel;
    var flip = false;
    if (vLabel.lim > wLabel.lim) {
      tailLabel = wLabel;
      flip = true;
    }
    var candidates = filter$1(g.edges(), function(edge2) {
      return flip === isDescendant$1(t, t.node(edge2.v), tailLabel) && flip !== isDescendant$1(t, t.node(edge2.w), tailLabel);
    });
    return minBy(candidates, function(edge2) {
      return slack(g, edge2);
    });
  }
  function exchangeEdges(t, g, e, f2) {
    var v = e.v;
    var w2 = e.w;
    t.removeEdge(v, w2);
    t.setEdge(f2.v, f2.w, {});
    initLowLimValues(t);
    initCutValues(t, g);
    updateRanks(t, g);
  }
  function updateRanks(t, g) {
    var root2 = find$1(t.nodes(), function(v) {
      return !g.node(v).parent;
    });
    var vs = preorder(t, root2);
    vs = vs.slice(1);
    forEach(vs, function(v) {
      var parent = t.node(v).parent, edge = g.edge(v, parent), flipped = false;
      if (!edge) {
        edge = g.edge(parent, v);
        flipped = true;
      }
      g.node(v).rank = g.node(parent).rank + (flipped ? edge.minlen : -edge.minlen);
    });
  }
  function isTreeEdge(tree, u, v) {
    return tree.hasEdge(u, v);
  }
  function isDescendant$1(tree, vLabel, rootLabel) {
    return rootLabel.low <= vLabel.lim && vLabel.lim <= rootLabel.lim;
  }
  function rank(g) {
    switch (g.graph().ranker) {
      case "network-simplex":
        networkSimplexRanker(g);
        break;
      case "tight-tree":
        tightTreeRanker(g);
        break;
      case "longest-path":
        longestPathRanker(g);
        break;
      default:
        networkSimplexRanker(g);
    }
  }
  var longestPathRanker = longestPath;
  function tightTreeRanker(g) {
    longestPath(g);
    feasibleTree(g);
  }
  function networkSimplexRanker(g) {
    networkSimplex(g);
  }
  let edgeCount$1 = 0;
  const drawEdge$2 = function(elem, path2, relation, conf2, diagObj) {
    const getRelationType = function(type2) {
      switch (type2) {
        case diagObj.db.relationType.AGGREGATION:
          return "aggregation";
        case diagObj.db.relationType.EXTENSION:
          return "extension";
        case diagObj.db.relationType.COMPOSITION:
          return "composition";
        case diagObj.db.relationType.DEPENDENCY:
          return "dependency";
        case diagObj.db.relationType.LOLLIPOP:
          return "lollipop";
      }
    };
    path2.points = path2.points.filter((p2) => !Number.isNaN(p2.y));
    const lineData = path2.points;
    const lineFunction = line$1().x(function(d) {
      return d.x;
    }).y(function(d) {
      return d.y;
    }).curve(curveBasis);
    const svgPath = elem.append("path").attr("d", lineFunction(lineData)).attr("id", "edge" + edgeCount$1).attr("class", "relation");
    let url = "";
    if (conf2.arrowMarkerAbsolute) {
      url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
      url = url.replace(/\(/g, "\\(");
      url = url.replace(/\)/g, "\\)");
    }
    if (relation.relation.lineType == 1) {
      svgPath.attr("class", "relation dashed-line");
    }
    if (relation.relation.lineType == 10) {
      svgPath.attr("class", "relation dotted-line");
    }
    if (relation.relation.type1 !== "none") {
      svgPath.attr(
        "marker-start",
        "url(" + url + "#" + getRelationType(relation.relation.type1) + "Start)"
      );
    }
    if (relation.relation.type2 !== "none") {
      svgPath.attr(
        "marker-end",
        "url(" + url + "#" + getRelationType(relation.relation.type2) + "End)"
      );
    }
    let x2, y2;
    const l = path2.points.length;
    let labelPosition = utils.calcLabelPosition(path2.points);
    x2 = labelPosition.x;
    y2 = labelPosition.y;
    let p1_card_x, p1_card_y;
    let p2_card_x, p2_card_y;
    if (l % 2 !== 0 && l > 1) {
      let cardinality_1_point = utils.calcCardinalityPosition(
        relation.relation.type1 !== "none",
        path2.points,
        path2.points[0]
      );
      let cardinality_2_point = utils.calcCardinalityPosition(
        relation.relation.type2 !== "none",
        path2.points,
        path2.points[l - 1]
      );
      log$1.debug("cardinality_1_point " + JSON.stringify(cardinality_1_point));
      log$1.debug("cardinality_2_point " + JSON.stringify(cardinality_2_point));
      p1_card_x = cardinality_1_point.x;
      p1_card_y = cardinality_1_point.y;
      p2_card_x = cardinality_2_point.x;
      p2_card_y = cardinality_2_point.y;
    }
    if (relation.title !== void 0) {
      const g = elem.append("g").attr("class", "classLabel");
      const label = g.append("text").attr("class", "label").attr("x", x2).attr("y", y2).attr("fill", "red").attr("text-anchor", "middle").text(relation.title);
      window.label = label;
      const bounds2 = label.node().getBBox();
      g.insert("rect", ":first-child").attr("class", "box").attr("x", bounds2.x - conf2.padding / 2).attr("y", bounds2.y - conf2.padding / 2).attr("width", bounds2.width + conf2.padding).attr("height", bounds2.height + conf2.padding);
    }
    log$1.info("Rendering relation " + JSON.stringify(relation));
    if (relation.relationTitle1 !== void 0 && relation.relationTitle1 !== "none") {
      const g = elem.append("g").attr("class", "cardinality");
      g.append("text").attr("class", "type1").attr("x", p1_card_x).attr("y", p1_card_y).attr("fill", "black").attr("font-size", "6").text(relation.relationTitle1);
    }
    if (relation.relationTitle2 !== void 0 && relation.relationTitle2 !== "none") {
      const g = elem.append("g").attr("class", "cardinality");
      g.append("text").attr("class", "type2").attr("x", p2_card_x).attr("y", p2_card_y).attr("fill", "black").attr("font-size", "6").text(relation.relationTitle2);
    }
    edgeCount$1++;
  };
  const drawClass = function(elem, classDef, conf2, diagObj) {
    log$1.debug("Rendering class ", classDef, conf2);
    const id2 = classDef.id;
    const classInfo = {
      id: id2,
      label: classDef.id,
      width: 0,
      height: 0
    };
    const g = elem.append("g").attr("id", diagObj.db.lookUpDomId(id2)).attr("class", "classGroup");
    let title2;
    if (classDef.link) {
      title2 = g.append("svg:a").attr("xlink:href", classDef.link).attr("target", classDef.linkTarget).append("text").attr("y", conf2.textHeight + conf2.padding).attr("x", 0);
    } else {
      title2 = g.append("text").attr("y", conf2.textHeight + conf2.pad