"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inOperator = exports.createPromiseCallback = exports.safeToString = exports.objectToString = void 0;
/** Wrapped `Object.prototype.toString`, so that you don't need to remember to use `.call()`. */
const objectToString = (obj) => Object.prototype.toString.call(obj);
exports.objectToString = objectToString;
/** Safely converts any value to string, using the value's own `toString` when available. */
const safeToString = (val) => {
    // Ideally, we'd just use String() for everything, but it breaks if `toString` is missing (mostly
    // values with no prototype), so we have to use Object#toString as a fallback.
    if (val === undefined || val === null || typeof val.toString === 'function') {
        return String(val);
    }
    else {
        return (0, exports.objectToString)(val);
    }
};
exports.safeToString = safeToString;
/** Converts a callback into a utility object where either a callback or a promise can be used. */
function createPromiseCallback(args) {
    let callback;
    let resolve;
    let reject;
    const promise = new Promise((_resolve, _reject) => {
        resolve = _resolve;
        reject = _reject;
    });
    const cb = args[args.length - 1];
    if (typeof cb === 'function') {
        callback = (err, result) => {
            try {
                cb(err, result);
            }
            catch (e) {
                reject(e instanceof Error ? e : new Error());
            }
        };
    }
    else {
        callback = (err, result) => {
            try {
                err ? reject(err) : resolve(result);
            }
            catch (e) {
                reject(e instanceof Error ? e : new Error());
            }
        };
    }
    return {
        promise,
        callback,
        resolve: (value) => {
            callback(null, value);
            return promise;
        },
        reject: (error) => {
            callback(error, undefined);
            return promise;
        },
    };
}
exports.createPromiseCallback = createPromiseCallback;
function inOperator(k, o) {
    return k in o;
}
exports.inOperator = inOperator;
