/* eslint no-console: 0 */

var fs = require('fs')
var tus = require('../..')

var concurrency = 6
var path = '/dev/shm/1gb.txt'
var size = fs.statSync(path).size
var start = Date.now()

for (var i = 0; i < concurrency; i++) {
  var file = fs.createReadStream(path)
  var options = {
    endpoint: "http://localhost:1080/files/",
    metadata: {
      filename: 'README.md',
      filetype: 'text/plain',
    },
    uploadSize: size,
    onError (error) {
      throw error
    },
    onProgress (bytesUploaded, bytesTotal) {
      var percentage = (bytesUploaded / bytesTotal * 100).toFixed(2)
      console.log(bytesUploaded, bytesTotal, `${percentage}%`)
    },
    onSuccess () {
      console.log('Upload finished:', upload.url)
      console.log('Done in', (Date.now() - start) / 1000);
    },
  }

  var upload = new tus.Upload(file, options)
  upload.start()
}


