"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _isCordova = _interopRequireDefault(require("./isCordova.js"));
var _readAsByteArray = _interopRequireDefault(require("./readAsByteArray.js"));
function _interopRequireDefault(obj: any) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o: any) {
  "@babel/helpers - typeof";

  // @ts-expect-error TS(2630): Cannot assign to '_typeof' because it is a functio... Remove this comment to see the full error message
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o: any) {
    return typeof o;
  } : function (o: any) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}
function _classCallCheck(instance: any, Constructor: any) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target: any, props: any) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor: any, protoProps: any, staticProps: any) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _toPropertyKey(arg: any) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input: any, hint: any) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var FileSource = /*#__PURE__*/function () {
  // Make this.size a method
  function FileSource(file: any) {
    _classCallCheck(this, FileSource);
    this._file = file;
    this.size = file.size;
  }
  // @ts-expect-error TS(2554): Expected 3 arguments, but got 2.
  _createClass(FileSource, [{
    key: "slice",
    value: function slice(start: any, end: any) {
      // In Apache Cordova applications, a File must be resolved using
      // FileReader instances, see
      // https://cordova.apache.org/docs/en/8.x/reference/cordova-plugin-file/index.html#read-a-file
      // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
      if ((0, _isCordova.default)()) {
        // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
        return (0, _readAsByteArray.default)(this._file.slice(start, end));
      }
      var value = this._file.slice(start, end);
      var done = end >= this.size;
      return Promise.resolve({
        value: value,
        done: done
      });
    }
  }, {
    key: "close",
    value: function close() {
      // Nothing to do here since we don't need to release any resources.
    }
  }]);
  return FileSource;
}();
exports.default = FileSource;