"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fs = require("fs");
var _isStream = _interopRequireDefault(require("is-stream"));
var _BufferSource = _interopRequireDefault(require("./sources/BufferSource.js"));
var _FileSource = _interopRequireDefault(require("./sources/FileSource.js"));
var _StreamSource = _interopRequireDefault(require("./sources/StreamSource.js"));
function _interopRequireDefault(obj: any) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o: any) {
  "@babel/helpers - typeof";

  // @ts-expect-error TS(2630): Cannot assign to '_typeof' because it is a functio... Remove this comment to see the full error message
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o: any) {
    return typeof o;
  } : function (o: any) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}
function _classCallCheck(instance: any, Constructor: any) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target: any, props: any) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor: any, protoProps: any, staticProps: any) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _toPropertyKey(arg: any) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input: any, hint: any) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var FileReader = /*#__PURE__*/function () {
  function FileReader() {
    _classCallCheck(this, FileReader);
  }
  // @ts-expect-error TS(2554): Expected 3 arguments, but got 2.
  _createClass(FileReader, [{
    key: "openFile",
    value: function openFile(input: any, chunkSize: any) {
      if (Buffer.isBuffer(input)) {
        return Promise.resolve(new _BufferSource.default(input));
      }
      if (input instanceof _fs.ReadStream && input.path != null) {
        // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
        return (0, _FileSource.default)(input);
      }
      if (_isStream.default.readable(input)) {
        chunkSize = Number(chunkSize);
        if (!Number.isFinite(chunkSize)) {
          return Promise.reject(new Error('cannot create source for stream without a finite value for the `chunkSize` option; specify a chunkSize to control the memory consumption'));
        }
        return Promise.resolve(new _StreamSource.default(input));
      }
      return Promise.reject(new Error('source object may only be an instance of Buffer or Readable in this environment'));
    }
  }]);
  return FileReader;
}();
exports.default = FileReader;