"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = fingerprint;
// @ts-expect-error TS(2451): Cannot redeclare block-scoped variable 'fs'.
var fs = _interopRequireWildcard(require("fs"));
// @ts-expect-error TS(2451): Cannot redeclare block-scoped variable 'path'.
var path = _interopRequireWildcard(require("path"));
var _crypto = require("crypto");
// @ts-expect-error TS(2393): Duplicate function implementation.
function _getRequireWildcardCache(nodeInterop: any) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop: any) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
// @ts-expect-error TS(2393): Duplicate function implementation.
function _interopRequireWildcard(obj: any, nodeInterop: any) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Generate a fingerprint for a file which will be used the store the endpoint
 *
 * @param {File} file
 * @param {Object} options
 */
function fingerprint(file: any, options: any) {
  if (Buffer.isBuffer(file)) {
    // create MD5 hash for buffer type
    var blockSize = 64 * 1024; // 64kb
    var content = file.slice(0, Math.min(blockSize, file.length));
    // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
    var hash = (0, _crypto.createHash)('md5').update(content).digest('hex');
    var ret = ['node-buffer', hash, file.length, options.endpoint].join('-');
    return Promise.resolve(ret);
  }
  if (file instanceof fs.ReadStream && file.path != null) {
    return new Promise(function (resolve, reject) {
      var name = path.resolve(file.path);
      fs.stat(file.path, function (err: any, info: any) {
        if (err) {
          reject(err);
          return;
        }
        var ret = ['node-file', name, info.size, info.mtime.getTime(), options.endpoint].join('-');
        resolve(ret);
      });
    });
  }

  // fingerprint cannot be computed for file input type
  return Promise.resolve(null);
}