"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DefaultHttpStack", {
  enumerable: true,
  get: function () {
    return _httpStack.default;
  }
});
Object.defineProperty(exports, "DetailedError", {
  enumerable: true,
  get: function () {
    return _error.default;
  }
});
Object.defineProperty(exports, "FileUrlStorage", {
  enumerable: true,
  get: function () {
    return _urlStorage.FileUrlStorage;
  }
});
Object.defineProperty(exports, "StreamSource", {
  enumerable: true,
  get: function () {
    return _StreamSource.default;
  }
});
exports.Upload = void 0;
Object.defineProperty(exports, "canStoreURLs", {
  enumerable: true,
  get: function () {
    return _urlStorage.canStoreURLs;
  }
});
exports.defaultOptions = void 0;
Object.defineProperty(exports, "enableDebugLog", {
  enumerable: true,
  get: function () {
    return _logger.enableDebugLog;
  }
});
exports.isSupported = void 0;
var _upload = _interopRequireDefault(require("../upload.js"));
var _noopUrlStorage = _interopRequireDefault(require("../noopUrlStorage.js"));
var _logger = require("../logger.js");
var _error = _interopRequireDefault(require("../error.js"));
var _urlStorage = require("./urlStorage.js");
var _httpStack = _interopRequireDefault(require("./httpStack.js"));
var _fileReader = _interopRequireDefault(require("./fileReader.js"));
var _fileSignature = _interopRequireDefault(require("./fileSignature.js"));
var _StreamSource = _interopRequireDefault(require("./sources/StreamSource.js"));
function _interopRequireDefault(obj: any) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o: any) {
  "@babel/helpers - typeof";

  // @ts-expect-error TS(2630): Cannot assign to '_typeof' because it is a functio... Remove this comment to see the full error message
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o: any) {
    return typeof o;
  } : function (o: any) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}
function _classCallCheck(instance: any, Constructor: any) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target: any, props: any) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor: any, protoProps: any, staticProps: any) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _inherits(subClass: any, superClass: any) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}
// @ts-expect-error TS(7023): '_setPrototypeOf' implicitly has return type 'any'... Remove this comment to see the full error message
function _setPrototypeOf(o: any, p: any) {
  // @ts-expect-error TS(2630): Cannot assign to '_setPrototypeOf' because it is a... Remove this comment to see the full error message
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o: any, p: any) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _createSuper(Derived: any) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived),
      result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self: any, call: any) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self);
}
function _assertThisInitialized(self: any) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  // @ts-expect-error TS(2339): Property 'sham' does not exist on type '(target: F... Remove this comment to see the full error message
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}
// @ts-expect-error TS(7023): '_getPrototypeOf' implicitly has return type 'any'... Remove this comment to see the full error message
function _getPrototypeOf(o: any) {
  // @ts-expect-error TS(2630): Cannot assign to '_getPrototypeOf' because it is a... Remove this comment to see the full error message
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o: any) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}
function ownKeys(e: any, r: any) {
  var t = Object.keys(e);
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(e);
    r && (o = o.filter(function (r) {
      return Object.getOwnPropertyDescriptor(e, r).enumerable;
    })), t.push.apply(t, o);
  }
  return t;
}
function _objectSpread(e: any) {
  for (var r = 1; r < arguments.length; r++) {
    var t = null != arguments[r] ? arguments[r] : {};
    r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
      _defineProperty(e, r, t[r]);
    // @ts-expect-error TS(2554): Expected 2 arguments, but got 1.
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
      Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
    });
  }
  return e;
}
function _defineProperty(obj: any, key: any, value: any) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey(arg: any) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input: any, hint: any) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
// @ts-expect-error TS(2403): Subsequent variable declarations must have the sam... Remove this comment to see the full error message
var defaultOptions = _objectSpread(_objectSpread({}, _upload.default.defaultOptions), {}, {
  httpStack: new _httpStack.default(),
  fileReader: new _fileReader.default(),
  urlStorage: new _noopUrlStorage.default(),
  fingerprint: _fileSignature.default
});
exports.defaultOptions = defaultOptions;
var Upload = /*#__PURE__*/function (_BaseUpload) {
  _inherits(Upload, _BaseUpload);
  var _super = _createSuper(Upload);
  function Upload() {
    var file = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    _classCallCheck(this, Upload);
    // @ts-expect-error TS(2554): Expected 1 arguments, but got 2.
    options = _objectSpread(_objectSpread({}, defaultOptions), options);
    return _super.call(this, file, options);
  }
  _createClass(Upload, null, [{
    key: "terminate",
    value: function terminate(url: any) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      // @ts-expect-error TS(2554): Expected 1 arguments, but got 2.
      options = _objectSpread(_objectSpread({}, defaultOptions), options);
      return _upload.default.terminate(url, options);
    }
  }]);
  return Upload;
}(_upload.default); // The Node.js environment does not have restrictions which may cause
// tus-js-client not to function.
exports.Upload = Upload;
var isSupported = true;

// The usage of the commonjs exporting syntax instead of the new ECMAScript
// one is actually inteded and prevents weird behaviour if we are trying to
// import this module in another module using Babel.
exports.isSupported = isSupported;