"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canStoreURLs = exports.FileUrlStorage = void 0;
var _fs = require("fs");
// @ts-expect-error TS(2554): Expected 2 arguments, but got 1.
var lockfile = _interopRequireWildcard(require("proper-lockfile"));
var _combineErrors = _interopRequireDefault(require("combine-errors"));
function _interopRequireDefault(obj: any) { return obj && obj.__esModule ? obj : { default: obj }; }
// @ts-expect-error TS(2630): Cannot assign to '_getRequireWildcardCache' becaus... Remove this comment to see the full error message
function _getRequireWildcardCache(nodeInterop: any) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop: any) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
// @ts-expect-error TS(7053): Element implicitly has an 'any' type because expre... Remove this comment to see the full error message
function _interopRequireWildcard(obj: any, nodeInterop: any) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(o: any) {
  "@babel/helpers - typeof";

  // @ts-expect-error TS(2630): Cannot assign to '_typeof' because it is a functio... Remove this comment to see the full error message
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o: any) {
    return typeof o;
  } : function (o: any) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}
function _classCallCheck(instance: any, Constructor: any) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target: any, props: any) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor: any, protoProps: any, staticProps: any) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _toPropertyKey(arg: any) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input: any, hint: any) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
/* eslint no-unused-vars: 0 */

var canStoreURLs = true;
exports.canStoreURLs = canStoreURLs;
var FileUrlStorage = /*#__PURE__*/function () {
  function FileUrlStorage(filePath: any) {
    _classCallCheck(this, FileUrlStorage);
    this.path = filePath;
  }
  // @ts-expect-error TS(2554): Expected 3 arguments, but got 2.
  _createClass(FileUrlStorage, [{
    key: "findAllUploads",
    value: function findAllUploads() {
      var _this = this;
      return new Promise(function (resolve, reject) {
        _this._getItems('tus::', function (err: any, results: any) {
          if (err) reject(err);else resolve(results);
        });
      });
    }
  }, {
    key: "findUploadsByFingerprint",
    value: function findUploadsByFingerprint(fingerprint: any) {
      var _this2 = this;
      return new Promise(function (resolve, reject) {
        _this2._getItems("tus::".concat(fingerprint), function (err: any, results: any) {
          if (err) reject(err);else resolve(results);
        });
      });
    }
  }, {
    key: "removeUpload",
    value: function removeUpload(urlStorageKey: any) {
      var _this3 = this;
      return new Promise(function (resolve, reject) {
        _this3._removeItem(urlStorageKey, function (err: any) {
          // @ts-expect-error TS(2794): Expected 1 arguments, but got 0. Did you forget to... Remove this comment to see the full error message
          if (err) reject(err);else resolve();
        });
      });
    }
  }, {
    key: "addUpload",
    value: function addUpload(fingerprint: any, upload: any) {
      var _this4 = this;
      var id = Math.round(Math.random() * 1e12);
      // @ts-expect-error TS(2345): Argument of type 'number' is not assignable to par... Remove this comment to see the full error message
      var key = "tus::".concat(fingerprint, "::").concat(id);
      return new Promise(function (resolve, reject) {
        _this4._setItem(key, upload, function (err: any) {
          if (err) reject(err);else resolve(key);
        });
      });
    }
  }, {
    key: "_setItem",
    value: function _setItem(key: any, value: any, cb: any) {
      var _this5 = this;
      lockfile.lock(this.path, this._lockfileOptions()).then(function (release: any) {
        cb = _this5._releaseAndCb(release, cb);
        _this5._getData(function (err: any, data: any) {
          if (err) {
            cb(err);
            return;
          }
          data[key] = value;
          _this5._writeData(data, function (err2: any) {
            return cb(err2);
          });
        });
      })["catch"](cb);
    }
  }, {
    key: "_getItems",
    value: function _getItems(prefix: any, cb: any) {
      this._getData(function (err: any, data: any) {
        if (err) {
          cb(err);
          return;
        }
        var results = Object.keys(data).filter(function (key) {
          return key.startsWith(prefix);
        }).map(function (key) {
          var obj = data[key];
          obj.urlStorageKey = key;
          return obj;
        });
        cb(null, results);
      });
    }
  }, {
    key: "_removeItem",
    value: function _removeItem(key: any, cb: any) {
      var _this6 = this;
      lockfile.lock(this.path, this._lockfileOptions()).then(function (release: any) {
        cb = _this6._releaseAndCb(release, cb);
        _this6._getData(function (err: any, data: any) {
          if (err) {
            cb(err);
            return;
          }
          delete data[key];
          _this6._writeData(data, function (err2: any) {
            return cb(err2);
          });
        });
      })["catch"](cb);
    }
  }, {
    key: "_lockfileOptions",
    value: function _lockfileOptions() {
      return {
        realpath: false,
        retries: {
          retries: 5,
          minTimeout: 20
        }
      };
    }
  }, {
    key: "_releaseAndCb",
    value: function _releaseAndCb(release: any, cb: any) {
      return function (err: any) {
        if (err) {
          release().then(function () {
            return cb(err);
          })["catch"](function (releaseErr: any) {
            // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
            return cb((0, _combineErrors.default)([err, releaseErr]));
          });
          return;
        }
        release().then(cb)["catch"](cb);
      };
    }
  }, {
    key: "_writeData",
    value: function _writeData(data: any, cb: any) {
      var opts = {
        encoding: 'utf8',
        mode: 432,
        flag: 'w'
      };
      // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
      (0, _fs.writeFile)(this.path, JSON.stringify(data), opts, function (err: any) {
        return cb(err);
      });
    }
  }, {
    key: "_getData",
    value: function _getData(cb: any) {
      // @ts-expect-error TS(2695): Left side of comma operator is unused and has no s... Remove this comment to see the full error message
      (0, _fs.readFile)(this.path, 'utf8', function (err: any, data: any) {
        if (err) {
          // return empty data if file does not exist
          if (err.code === 'ENOENT') cb(null, {});else cb(err);
          return;
        }
        try {
          data = !data.trim().length ? {} : JSON.parse(data);
        } catch (error) {
          cb(error);
          return;
        }
        cb(null, data);
      });
    }
  }]);
  return FileUrlStorage;
}();
exports.FileUrlStorage = FileUrlStorage;