/**
 * @license
 * Video.js 8.3.0 <http://videojs.com/>
 * Copyright Brightcove, Inc. <https://www.brightcove.com/>
 * Available under Apache License Version 2.0
 * <https://github.com/videojs/video.js/blob/main/LICENSE>
 *
 * Includes vtt.js <https://github.com/mozilla/vtt.js>
 * Available under Apache License Version 2.0
 * <https://github.com/mozilla/vtt.js/blob/main/LICENSE>
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).videojs=t()}(this,function(){"use strict";var D="8.3.0";const F={},R=function(e,t){return F[e]=F[e]||[],t&&(F[e]=F[e].concat(t)),F[e]};function B(e,t){return!((t=R(e).indexOf(t))<=-1||(F[e]=F[e].slice(),F[e].splice(t,1),0))}const H={prefixed:!0};var V=[["requestFullscreen","exitFullscreen","fullscreenElement","fullscreenEnabled","fullscreenchange","fullscreenerror","fullscreen"],["webkitRequestFullscreen","webkitExitFullscreen","webkitFullscreenElement","webkitFullscreenEnabled","webkitfullscreenchange","webkitfullscreenerror","-webkit-full-screen"],["mozRequestFullScreen","mozCancelFullScreen","mozFullScreenElement","mozFullScreenEnabled","mozfullscreenchange","mozfullscreenerror","-moz-full-screen"],["msRequestFullscreen","msExitFullscreen","msFullscreenElement","msFullscreenEnabled","MSFullscreenChange","MSFullscreenError","-ms-fullscreen"]],$=V[0];let z;for(let e=0;e<V.length;e++)if(V[e][1]in document){z=V[e];break}if(z){for(let e=0;e<z.length;e++)H[$[e]]=z[e];H.prefixed=z[0]!==$[0]}let l=[];function U(e){return n(e)?Object.keys(e):[]}const h=function t(s){let i="info",r;function n(...e){r("log",i,e)}var a,o;return r=(a=s,(t,s,i)=>{var e,s=o.levels[s],r=new RegExp(`^(${s})$`);if("log"!==t&&i.unshift(t.toUpperCase()+":"),i.unshift(a+":"),l&&(l.push([].concat(i)),e=l.length-1e3,l.splice(0,0<e?e:0)),window.console){let e=window.console[t];(e=e||"debug"!==t?e:window.console.info||window.console.log)&&s&&r.test(t)&&e[Array.isArray(i)?"apply":"call"](window.console,i)}}),(o=n).createLogger=e=>t(s+": "+e),n.levels={all:"debug|log|warn|error",off:"",debug:"debug|log|warn|error",info:"log|warn|error",warn:"warn|error",error:"error",DEFAULT:i},n.level=e=>{if("string"==typeof e){if(!n.levels.hasOwnProperty(e))throw new Error(`"${e}" in not a valid log level`);i=e}return i},n.history=()=>l?[].concat(l):[],n.history.filter=t=>(l||[]).filter(e=>new RegExp(`.*${t}.*`).test(e[0])),n.history.clear=()=>{l&&(l.length=0)},n.history.disable=()=>{null!==l&&(l.length=0,l=null)},n.history.enable=()=>{null===l&&(l=[])},n.error=(...e)=>r("error",i,e),n.warn=(...e)=>r("warn",i,e),n.debug=(...e)=>r("debug",i,e),n}("VIDEOJS"),K=h.createLogger,W=Object.prototype.toString;function q(t,s){U(t).forEach(e=>s(t[e],e))}function X(s,i,e=0){return U(s).reduce((e,t)=>i(e,s[t],t),e)}function n(e){return!!e&&"object"==typeof e}function G(e){return n(e)&&"[object Object]"===W.call(e)&&e.constructor===Object}function c(...e){const s={};return e.forEach(e=>{e&&q(e,(e,t)=>{G(e)?(G(s[t])||(s[t]={}),s[t]=c(s[t],e)):s[t]=e})}),s}function Y(t,s,i,e=!0){const r=e=>Object.defineProperty(t,s,{value:e,enumerable:!0,writable:!0});var n={configurable:!0,enumerable:!0,get(){var e=i();return r(e),e}};return e&&(n.set=r),Object.defineProperty(t,s,n)}var Q=Object.freeze({__proto__:null,each:q,reduce:X,isObject:n,isPlain:G,merge:c,defineLazyProperty:Y});let J=!1,Z=null,o=!1,ee,te=!1,se=!1,ie=!1,u=!1,re=null,ne=null,ae=null,oe=!1,le=!1,he=!1,ce=!1;const ue=Boolean(me()&&("ontouchstart"in window||window.navigator.maxTouchPoints||window.DocumentTouch&&window.document instanceof window.DocumentTouch));var de,e=window.navigator&&window.navigator.userAgentData;if(e&&(o="Android"===e.platform,se=Boolean(e.brands.find(e=>"Microsoft Edge"===e.brand)),ie=Boolean(e.brands.find(e=>"Chromium"===e.brand)),u=!se&&ie,re=ne=(e.brands.find(e=>"Chromium"===e.brand)||{}).version||null,le="Windows"===e.platform),!ie){const N=window.navigator&&window.navigator.userAgent||"";J=/iPod/i.test(N),Z=(e=N.match(/OS (\d+)_/i))&&e[1]?e[1]:null,o=/Android/i.test(N),ee=(e=N.match(/Android (\d+)(?:\.(\d+))?(?:\.(\d+))*/i))?(lt=e[1]&&parseFloat(e[1]),de=e[2]&&parseFloat(e[2]),lt&&de?parseFloat(e[1]+"."+e[2]):lt||null):null,te=/Firefox/i.test(N),se=/Edg/i.test(N),ie=/Chrome/i.test(N)||/CriOS/i.test(N),u=!se&&ie,re=ne=(de=N.match(/(Chrome|CriOS)\/(\d+)/))&&de[2]?parseFloat(de[2]):null,ae=function(){var e=/MSIE\s(\d+)\.\d/.exec(N);let t=e&&parseFloat(e[1]);return t=!t&&/Trident\/7.0/i.test(N)&&/rv:11.0/.test(N)?11:t}(),oe=/Safari/i.test(N)&&!u&&!o&&!se,le=/Windows/i.test(N),he=/iPad/i.test(N)||oe&&ue&&!/iPhone/i.test(N),ce=/iPhone/i.test(N)&&!he}const d=ce||he||J,pe=(oe||d)&&!u;e=Object.freeze({__proto__:null,get IS_IPOD(){return J},get IOS_VERSION(){return Z},get IS_ANDROID(){return o},get ANDROID_VERSION(){return ee},get IS_FIREFOX(){return te},get IS_EDGE(){return se},get IS_CHROMIUM(){return ie},get IS_CHROME(){return u},get CHROMIUM_VERSION(){return re},get CHROME_VERSION(){return ne},get IE_VERSION(){return ae},get IS_SAFARI(){return oe},get IS_WINDOWS(){return le},get IS_IPAD(){return he},get IS_IPHONE(){return ce},TOUCH_ENABLED:ue,IS_IOS:d,IS_ANY_SAFARI:pe});function ge(e){return"string"==typeof e&&Boolean(e.trim())}function me(){return document===window.document}function _e(e){return n(e)&&1===e.nodeType}function fe(){try{return window.parent!==window.self}catch(e){return!0}}function ve(s){return function(e,t){return ge(e)?(t=_e(t=ge(t)?document.querySelector(t):t)?t:document)[s]&&t[s](e):document[s](null)}}function p(e="div",s={},t={},i){const r=document.createElement(e);return Object.getOwnPropertyNames(s).forEach(function(e){var t=s[e];"textContent"===e?ye(r,t):r[e]===t&&"tabIndex"!==e||(r[e]=t)}),Object.getOwnPropertyNames(t).forEach(function(e){r.setAttribute(e,t[e])}),i&&Re(r,i),r}function ye(e,t){return"undefined"==typeof e.textContent?e.innerText=t:e.textContent=t,e}function be(e,t){t.firstChild?t.insertBefore(e,t.firstChild):t.appendChild(e)}function Te(e,t){if(0<=t.indexOf(" "))throw new Error("class has illegal whitespace characters");return e.classList.contains(t)}function ke(e,...t){return e.classList.add(...t.reduce((e,t)=>e.concat(t.split(/\s+/)),[])),e}function Ce(e,...t){return e?(e.classList.remove(...t.reduce((e,t)=>e.concat(t.split(/\s+/)),[])),e):(h.warn("removeClass was called with an element that doesn't exist"),null)}function we(t,e,s){return"boolean"!=typeof(s="function"==typeof s?s(t,e):s)&&(s=void 0),e.split(/\s+/).forEach(e=>t.classList.toggle(e,s)),t}function Ee(s,i){Object.getOwnPropertyNames(i).forEach(function(e){var t=i[e];null===t||"undefined"==typeof t||!1===t?s.removeAttribute(e):s.setAttribute(e,!0===t?"":t)})}function Se(s){var i={};if(s&&s.attributes&&0<s.attributes.length){var r=s.attributes;for(let t=r.length-1;0<=t;t--){var n=r[t].name;let e=r[t].value;"boolean"!=typeof s[n]&&-1===",autoplay,controls,playsinline,loop,muted,default,defaultMuted,".indexOf(","+n+",")||(e=null!==e),i[n]=e}}return i}function xe(e,t){return e.getAttribute(t)}function Pe(e,t,s){e.setAttribute(t,s)}function je(e,t){e.removeAttribute(t)}function Ae(){document.body.focus(),document.onselectstart=function(){return!1}}function Ie(){document.onselectstart=function(){return!0}}function Oe(e){if(e&&e.getBoundingClientRect&&e.parentNode){const t=e.getBoundingClientRect(),s={};return["bottom","height","left","right","top","width"].forEach(e=>{void 0!==t[e]&&(s[e]=t[e])}),s.height||(s.height=parseFloat(ze(e,"height"))),s.width||(s.width=parseFloat(ze(e,"width"))),s}}function Me(e){if(!e||!e.offsetParent)return{left:0,top:0,width:0,height:0};var t=e.offsetWidth,s=e.offsetHeight;let i=0,r=0;for(;e.offsetParent&&e!==document[H.fullscreenElement];)i+=e.offsetLeft,r+=e.offsetTop,e=e.offsetParent;return{left:i,top:r,width:t,height:s}}function Le(t,e){var s={x:0,y:0};if(d){let e=t;for(;e&&"html"!==e.nodeName.toLowerCase();){var i,r=ze(e,"transform");/^matrix/.test(r)?(i=r.slice(7,-1).split(/,\s/).map(Number),s.x+=i[4],s.y+=i[5]):/^matrix3d/.test(r)&&(i=r.slice(9,-1).split(/,\s/).map(Number),s.x+=i[12],s.y+=i[13]),e=e.parentNode}}var n={},a=Me(e.target),t=Me(t),o=t.width,l=t.height;let h=e.offsetY-(t.top-a.top),c=e.offsetX-(t.left-a.left);return e.changedTouches&&(c=e.changedTouches[0].pageX-t.left,h=e.changedTouches[0].pageY+t.top,d)&&(c-=s.x,h-=s.y),n.y=1-Math.max(0,Math.min(1,h/l)),n.x=Math.max(0,Math.min(1,c/o)),n}function Ne(e){return n(e)&&3===e.nodeType}function De(e){for(;e.firstChild;)e.removeChild(e.firstChild);return e}function Fe(e){return"function"==typeof e&&(e=e()),(Array.isArray(e)?e:[e]).map(e=>_e(e="function"==typeof e?e():e)||Ne(e)?e:"string"==typeof e&&/\S/.test(e)?document.createTextNode(e):void 0).filter(e=>e)}function Re(t,e){return Fe(e).forEach(e=>t.appendChild(e)),t}function Be(e,t){return Re(De(e),t)}function He(e){return void 0===e.button&&void 0===e.buttons||0===e.button&&void 0===e.buttons||"mouseup"===e.type&&0===e.button&&0===e.buttons||0===e.button&&1===e.buttons}const Ve=ve("querySelector"),$e=ve("querySelectorAll");function ze(t,s){if(!t||!s)return"";if("function"!=typeof window.getComputedStyle)return"";{let e;try{e=window.getComputedStyle(t)}catch(e){return""}return e?e.getPropertyValue(s)||e[s]:""}}var Ue=Object.freeze({__proto__:null,isReal:me,isEl:_e,isInFrame:fe,createEl:p,textContent:ye,prependTo:be,hasClass:Te,addClass:ke,removeClass:Ce,toggleClass:we,setAttributes:Ee,getAttributes:Se,getAttribute:xe,setAttribute:Pe,removeAttribute:je,blockTextSelection:Ae,unblockTextSelection:Ie,getBoundingClientRect:Oe,findPosition:Me,getPointerPosition:Le,isTextNode:Ne,emptyEl:De,normalizeContent:Fe,appendContent:Re,insertContent:Be,isSingleLeftClick:He,$:Ve,$$:$e,computedStyle:ze});let Ke=!1,We;function qe(){if(!1!==We.options.autoSetup){var e=Array.prototype.slice.call(document.getElementsByTagName("video")),t=Array.prototype.slice.call(document.getElementsByTagName("audio")),s=Array.prototype.slice.call(document.getElementsByTagName("video-js")),i=e.concat(t,s);if(i&&0<i.length)for(let e=0,t=i.length;e<t;e++){var r=i[e];if(!r||!r.getAttribute){Xe(1);break}void 0===r.player&&null!==r.getAttribute("data-setup")&&We(r)}else Ke||Xe(1)}}function Xe(e,t){me()&&(t&&(We=t),window.setTimeout(qe,e))}function Ge(){Ke=!0,window.removeEventListener("load",Ge)}me()&&("complete"===document.readyState?Ge():window.addEventListener("load",Ge));function Ye(e){var t=document.createElement("style");return t.className=e,t}function Qe(e,t){e.styleSheet?e.styleSheet.cssText=t:e.textContent=t}var g=new WeakMap;let m=3;function Je(e,t){var s;g.has(e)&&(0===(s=g.get(e)).handlers[t].length&&(delete s.handlers[t],e.removeEventListener?e.removeEventListener(t,s.dispatcher,!1):e.detachEvent&&e.detachEvent("on"+t,s.dispatcher)),Object.getOwnPropertyNames(s.handlers).length<=0&&(delete s.handlers,delete s.dispatcher,delete s.disabled),0===Object.getOwnPropertyNames(s).length)&&g.delete(e)}function Ze(t,s,e,i){e.forEach(function(e){t(s,e,i)})}function et(e){if(!e.fixed_){if(!e||!e.isPropagationStopped||!e.isImmediatePropagationStopped){const n=e||window.event;e={};for(const a in n)"layerX"===a||"layerY"===a||"keyLocation"===a||"webkitMovementX"===a||"webkitMovementY"===a||"path"===a||"returnValue"===a&&n.preventDefault||(e[a]=n[a]);var t,s;e.target||(e.target=e.srcElement||document),e.relatedTarget||(e.relatedTarget=e.fromElement===e.target?e.toElement:e.fromElement),e.preventDefault=function(){n.preventDefault&&n.preventDefault(),e.returnValue=!1,n.returnValue=!1,e.defaultPrevented=!0},e.defaultPrevented=!1,e.stopPropagation=function(){n.stopPropagation&&n.stopPropagation(),e.cancelBubble=!0,n.cancelBubble=!0,e.isPropagationStopped=i},e.isPropagationStopped=r,e.stopImmediatePropagation=function(){n.stopImmediatePropagation&&n.stopImmediatePropagation(),e.isImmediatePropagationStopped=i,e.stopPropagation()},e.isImmediatePropagationStopped=r,null!==e.clientX&&void 0!==e.clientX&&(t=document.documentElement,s=document.body,e.pageX=e.clientX+(t&&t.scrollLeft||s&&s.scrollLeft||0)-(t&&t.clientLeft||s&&s.clientLeft||0),e.pageY=e.clientY+(t&&t.scrollTop||s&&s.scrollTop||0)-(t&&t.clientTop||s&&s.clientTop||0)),e.which=e.charCode||e.keyCode,null!==e.button&&void 0!==e.button&&(e.button=1&e.button?0:4&e.button?1:2&e.button?2:0)}e.fixed_=!0}return e;function i(){return!0}function r(){return!1}}let tt;const st=["touchstart","touchmove"];function _(n,t,e){if(Array.isArray(t))return Ze(_,n,t,e);g.has(n)||g.set(n,{});const a=g.get(n);if(a.handlers||(a.handlers={}),a.handlers[t]||(a.handlers[t]=[]),e.guid||(e.guid=m++),a.handlers[t].push(e),a.dispatcher||(a.disabled=!1,a.dispatcher=function(s,i){if(!a.disabled){s=et(s);var e=a.handlers[s.type];if(e){var r=e.slice(0);for(let e=0,t=r.length;e<t&&!s.isImmediatePropagationStopped();e++)try{r[e].call(n,s,i)}catch(e){h.error(e)}}}}),1===a.handlers[t].length)if(n.addEventListener){let e=!1;(function(){if("boolean"!=typeof tt){tt=!1;try{var e=Object.defineProperty({},"passive",{get(){tt=!0}});window.addEventListener("test",null,e),window.removeEventListener("test",null,e)}catch(e){}}return tt})()&&-1<st.indexOf(t)&&(e={passive:!0}),n.addEventListener(t,a.dispatcher,e)}else n.attachEvent&&n.attachEvent("on"+t,a.dispatcher)}function f(e,t,s){if(g.has(e)){const n=g.get(e);if(n.handlers){if(Array.isArray(t))return Ze(f,e,t,s);var i=function(e,t){n.handlers[t]=[],Je(e,t)};if(void 0===t)for(const a in n.handlers)Object.prototype.hasOwnProperty.call(n.handlers||{},a)&&i(e,a);else{var r=n.handlers[t];if(r)if(s){if(s.guid)for(let e=0;e<r.length;e++)r[e].guid===s.guid&&r.splice(e--,1);Je(e,t)}else i(e,t)}}}}function it(e,t,s){var i=g.has(e)?g.get(e):{},r=e.parentNode||e.ownerDocument;return"string"==typeof t?t={type:t,target:e}:t.target||(t.target=e),t=et(t),i.dispatcher&&i.dispatcher.call(e,t,s),r&&!t.isPropagationStopped()&&!0===t.bubbles?it.call(null,r,t,s):!r&&!t.defaultPrevented&&t.target&&t.target[t.type]&&(g.has(t.target)||g.set(t.target,{}),i=g.get(t.target),t.target[t.type])&&(i.disabled=!0,"function"==typeof t.target[t.type]&&t.target[t.type](),i.disabled=!1),!t.defaultPrevented}function rt(e,t,s){if(Array.isArray(t))return Ze(rt,e,t,s);function i(){f(e,t,i),s.apply(this,arguments)}i.guid=s.guid=s.guid||m++,_(e,t,i)}function nt(e,t,s){function i(){f(e,t,i),s.apply(this,arguments)}i.guid=s.guid=s.guid||m++,_(e,t,i)}var at=Object.freeze({__proto__:null,fixEvent:et,on:_,off:f,trigger:it,one:rt,any:nt});function v(e,t,s){return t.guid||(t.guid=m++),(e=t.bind(e)).guid=s?s+"_"+t.guid:t.guid,e}function r(s,i){let r=window.performance.now();return function(...e){var t=window.performance.now();t-r>=i&&(s(...e),r=t)}}function ot(i,r,n,a=window){let o;function e(){const e=this,t=arguments;let s=function(){o=null,s=null,n||i.apply(e,t)};!o&&n&&i.apply(e,t),a.clearTimeout(o),o=a.setTimeout(s,r)}return e.cancel=()=>{a.clearTimeout(o),o=null},e}var lt=Object.freeze({__proto__:null,UPDATE_REFRESH_INTERVAL:30,bind_:v,throttle:r,debounce:ot});let ht;class s{on(e,t){var s=this.addEventListener;this.addEventListener=()=>{},_(this,e,t),this.addEventListener=s}off(e,t){f(this,e,t)}one(e,t){var s=this.addEventListener;this.addEventListener=()=>{},rt(this,e,t),this.addEventListener=s}any(e,t){var s=this.addEventListener;this.addEventListener=()=>{},nt(this,e,t),this.addEventListener=s}trigger(e){var t=e.type||e;e=et(e="string"==typeof e?{type:t}:e),this.allowedEvents_[t]&&this["on"+t]&&this["on"+t](e),it(this,e)}queueTrigger(e){ht=ht||new Map;const t=e.type||e;let s=ht.get(this);s||(s=new Map,ht.set(this,s));var i=s.get(t),i=(s.delete(t),window.clearTimeout(i),window.setTimeout(()=>{s.delete(t),0===s.size&&(s=null,ht.delete(this)),this.trigger(e)},0));s.set(t,i)}}s.prototype.allowedEvents_={},s.prototype.addEventListener=s.prototype.on,s.prototype.removeEventListener=s.prototype.off,s.prototype.dispatchEvent=s.prototype.trigger;const ct=e=>"function"==typeof e.name?e.name():"string"==typeof e.name?e.name:e.name_||(e.constructor&&e.constructor.name?e.constructor.name:typeof e),ut=t=>t instanceof s||!!t.eventBusEl_&&["on","one","off","trigger"].every(e=>"function"==typeof t[e]),dt=e=>"string"==typeof e&&/\S/.test(e)||Array.isArray(e)&&!!e.length,pt=(e,t,s)=>{if(!e||!e.nodeName&&!ut(e))throw new Error(`Invalid target for ${ct(t)}#${s}; must be a DOM node or evented object.`)},gt=(e,t,s)=>{if(!dt(e))throw new Error(`Invalid event type for ${ct(t)}#${s}; must be a non-empty string or array.`)},mt=(e,t,s)=>{if("function"!=typeof e)throw new Error(`Invalid listener for ${ct(t)}#${s}; must be a function.`)},_t=(e,t,s)=>{var i=t.length<3||t[0]===e||t[0]===e.eventBusEl_;let r,n,a;return i?(r=e.eventBusEl_,3<=t.length&&t.shift(),[n,a]=t):[r,n,a]=t,pt(r,e,s),gt(n,e,s),mt(a,e,s),a=v(e,a),{isTargetingSelf:i,target:r,type:n,listener:a}},ft=(e,t,s,i)=>{pt(e,e,t),e.nodeName?at[t](e,s,i):e[t](s,i)},vt={on(...e){const{isTargetingSelf:t,target:s,type:i,listener:r}=_t(this,e,"on");if(ft(s,"on",i,r),!t){const n=()=>this.off(s,i,r);n.guid=r.guid;e=()=>this.off("dispose",n);e.guid=r.guid,ft(this,"on","dispose",n),ft(s,"on","dispose",e)}},one(...e){const{isTargetingSelf:t,target:s,type:i,listener:r}=_t(this,e,"one");if(t)ft(s,"one",i,r);else{const n=(...e)=>{this.off(s,i,n),r.apply(null,e)};n.guid=r.guid,ft(s,"one",i,n)}},any(...e){const{isTargetingSelf:t,target:s,type:i,listener:r}=_t(this,e,"any");if(t)ft(s,"any",i,r);else{const n=(...e)=>{this.off(s,i,n),r.apply(null,e)};n.guid=r.guid,ft(s,"any",i,n)}},off(e,t,s){!e||dt(e)?f(this.eventBusEl_,e,t):(e=e,t=t,pt(e,this,"off"),gt(t,this,"off"),mt(s,this,"off"),s=v(this,s),this.off("dispose",s),e.nodeName?(f(e,t,s),f(e,"dispose",s)):ut(e)&&(e.off(t,s),e.off("dispose",s)))},trigger(e,t){pt(this.eventBusEl_,this,"trigger");var s=e&&"string"!=typeof e?e.type:e;if(dt(s))return it(this.eventBusEl_,e,t);throw new Error(`Invalid event type for ${ct(this)}#trigger; `+"must be a non-empty string or object with a type key that has a non-empty value.")}};function yt(e,t={}){t=t.eventBusKey;if(t){if(!e[t].nodeName)throw new Error(`The eventBusKey "${t}" does not refer to an element.`);e.eventBusEl_=e[t]}else e.eventBusEl_=p("span",{className:"vjs-event-bus"});Object.assign(e,vt),e.eventedCallbacks&&e.eventedCallbacks.forEach(e=>{e()}),e.on("dispose",()=>{e.off(),[e,e.el_,e.eventBusEl_].forEach(function(e){e&&g.has(e)&&g.delete(e)}),window.setTimeout(()=>{e.eventBusEl_=null},0)})}const bt={state:{},setState(e){"function"==typeof e&&(e=e());let s;return q(e,(e,t)=>{this.state[t]!==e&&((s=s||{})[t]={from:this.state[t],to:e}),this.state[t]=e}),s&&ut(this)&&this.trigger({changes:s,type:"statechanged"}),s}};function Tt(e,t){Object.assign(e,bt),e.state=Object.assign({},e.state,t),"function"==typeof e.handleStateChanged&&ut(e)&&e.on("statechanged",e.handleStateChanged)}function kt(e){return"string"!=typeof e?e:e.replace(/./,e=>e.toLowerCase())}function y(e){return"string"!=typeof e?e:e.replace(/./,e=>e.toUpperCase())}function Ct(e,t){return y(e)===y(t)}var wt=Object.freeze({__proto__:null,toLowerCase:kt,toTitleCase:y,titleCaseEquals:Ct}),Et="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function St(e,t){return e(t={exports:{}},t.exports),t.exports}var a=St(function(e,t){function s(e){var t;return"number"==typeof(e=e&&"object"==typeof e&&(t=e.which||e.keyCode||e.charCode)?t:e)?o[e]:(t=String(e),i[t.toLowerCase()]||r[t.toLowerCase()]||(1===t.length?t.charCodeAt(0):void 0))}s.isEventKey=function(e,t){if(e&&"object"==typeof e){e=e.which||e.keyCode||e.charCode;if(null!=e)if("string"==typeof t){var s=i[t.toLowerCase()];if(s)return s===e;if(s=r[t.toLowerCase()])return s===e}else if("number"==typeof t)return t===e;return!1}};for(var i=(t=e.exports=s).code=t.codes={backspace:8,tab:9,enter:13,shift:16,ctrl:17,alt:18,"pause/break":19,"caps lock":20,esc:27,space:32,"page up":33,"page down":34,end:35,home:36,left:37,up:38,right:39,down:40,insert:45,delete:46,command:91,"left command":91,"right command":93,"numpad *":106,"numpad +":107,"numpad -":109,"numpad .":110,"numpad /":111,"num lock":144,"scroll lock":145,"my computer":182,"my calculator":183,";":186,"=":187,",":188,"-":189,".":190,"/":191,"`":192,"[":219,"\\":220,"]":221,"'":222},r=t.aliases={windows:91,"⇧":16,"⌥":18,"⌃":17,"⌘":91,ctl:17,control:17,option:18,pause:19,break:19,caps:20,return:13,escape:27,spc:32,spacebar:32,pgup:33,pgdn:34,ins:45,del:46,cmd:91},n=97;n<123;n++)i[String.fromCharCode(n)]=n-32;for(var n=48;n<58;n++)i[n-48]=n;for(n=1;n<13;n++)i["f"+n]=n+111;for(n=0;n<10;n++)i["numpad "+n]=n+96;var a,o=t.names=t.title={};for(n in i)o[i[n]]=n;for(a in r)i[a]=r[a]});a.code,a.codes,a.aliases,a.names,a.title;class b{constructor(e,t,s){!e&&this.play?this.player_=e=this:this.player_=e,this.isDisposed_=!1,this.parentComponent_=null,this.options_=c({},this.options_),t=this.options_=c(this.options_,t),this.id_=t.id||t.el&&t.el.id,this.id_||(e=e&&e.id&&e.id()||"no_player",this.id_=e+"_component_"+m++),this.name_=t.name||null,t.el?this.el_=t.el:!1!==t.createEl&&(this.el_=this.createEl()),t.className&&this.el_&&t.className.split(" ").forEach(e=>this.addClass(e)),["on","off","one","any","trigger"].forEach(e=>{this[e]=void 0}),!1!==t.evented&&(yt(this,{eventBusKey:this.el_?"el_":null}),this.handleLanguagechange=this.handleLanguagechange.bind(this),this.on(this.player_,"languagechange",this.handleLanguagechange)),Tt(this,this.constructor.defaultState),this.children_=[],this.childIndex_={},this.childNameIndex_={},this.setTimeoutIds_=new Set,this.setIntervalIds_=new Set,this.rafIds_=new Set,this.namedRafs_=new Map,(this.clearingTimersOnDispose_=!1)!==t.initChildren&&this.initChildren(),this.ready(s),!1!==t.reportTouchActivity&&this.enableTouchActivity()}on(e,t){}off(e,t){}one(e,t){}any(e,t){}trigger(e){}dispose(e={}){if(!this.isDisposed_){if(this.readyQueue_&&(this.readyQueue_.length=0),this.trigger({type:"dispose",bubbles:!1}),this.isDisposed_=!0,this.children_)for(let e=this.children_.length-1;0<=e;e--)this.children_[e].dispose&&this.children_[e].dispose();this.children_=null,this.childIndex_=null,this.childNameIndex_=null,this.parentComponent_=null,this.el_&&(this.el_.parentNode&&(e.restoreEl?this.el_.parentNode.replaceChild(e.restoreEl,this.el_):this.el_.parentNode.removeChild(this.el_)),this.el_=null),this.player_=null}}isDisposed(){return Boolean(this.isDisposed_)}player(){return this.player_}options(e){return e&&(this.options_=c(this.options_,e)),this.options_}el(){return this.el_}createEl(e,t,s){return p(e,t,s)}localize(e,i,t=e){var s=this.player_.language&&this.player_.language(),r=this.player_.languages&&this.player_.languages(),n=r&&r[s],s=s&&s.split("-")[0],r=r&&r[s];let a=t;return n&&n[e]?a=n[e]:r&&r[e]&&(a=r[e]),a=i?a.replace(/\{(\d+)\}/g,function(e,t){t=i[t-1];let s="undefined"==typeof t?e:t;return s}):a}handleLanguagechange(){}contentEl(){return this.contentEl_||this.el_}id(){return this.id_}name(){return this.name_}children(){return this.children_}getChildById(e){return this.childIndex_[e]}getChild(e){if(e)return this.childNameIndex_[e]}getDescendant(...t){t=t.reduce((e,t)=>e.concat(t),[]);let s=this;for(let e=0;e<t.length;e++)if(!(s=s.getChild(t[e]))||!s.getChild)return;return s}addChild(e,t={},s=this.children_.length){let i,r;if("string"==typeof e){r=y(e);var n=t.componentClass||r,a=(t.name=r,b.getComponent(n));if(!a)throw new Error(`Component ${n} does not exist`);if("function"!=typeof a)return null;i=new a(this.player_||this,t)}else i=e;if(i.parentComponent_&&i.parentComponent_.removeChild(i),this.children_.splice(s,0,i),i.parentComponent_=this,"function"==typeof i.id&&(this.childIndex_[i.id()]=i),(r=r||i.name&&y(i.name()))&&(this.childNameIndex_[r]=i,this.childNameIndex_[kt(r)]=i),"function"==typeof i.el&&i.el()){let e=null;this.children_[s+1]&&(this.children_[s+1].el_?e=this.children_[s+1].el_:_e(this.children_[s+1])&&(e=this.children_[s+1])),this.contentEl().insertBefore(i.el(),e)}return i}removeChild(s){if((s="string"==typeof s?this.getChild(s):s)&&this.children_){let t=!1;for(let e=this.children_.length-1;0<=e;e--)if(this.children_[e]===s){t=!0,this.children_.splice(e,1);break}var e;t&&(s.parentComponent_=null,this.childIndex_[s.id()]=null,this.childNameIndex_[y(s.name())]=null,this.childNameIndex_[kt(s.name())]=null,e=s.el())&&e.parentNode===this.contentEl()&&this.contentEl().removeChild(s.el())}}initChildren(){const i=this.options_.children;if(i){const r=this.options_;let e;const t=b.getComponent("Tech");(e=Array.isArray(i)?i:Object.keys(i)).concat(Object.keys(this.options_).filter(function(t){return!e.some(function(e){return"string"==typeof e?t===e:t===e.name})})).map(e=>{let t,s;return s="string"==typeof e?(t=e,i[t]||this.options_[t]||{}):(t=e.name,e),{name:t,opts:s}}).filter(e=>{e=b.getComponent(e.opts.componentClass||y(e.name));return e&&!t.isTech(e)}).forEach(e=>{var t=e.name;let s=e.opts;!1!==(s=void 0!==r[t]?r[t]:s)&&((s=!0===s?{}:s).playerOptions=this.options_.playerOptions,e=this.addChild(t,s))&&(this[t]=e)})}}buildCSSClass(){return""}ready(e,t=!1){e&&(this.isReady_?t?e.call(this):this.setTimeout(e,1):(this.readyQueue_=this.readyQueue_||[],this.readyQueue_.push(e)))}triggerReady(){this.isReady_=!0,this.setTimeout(function(){var e=this.readyQueue_;this.readyQueue_=[],e&&0<e.length&&e.forEach(function(e){e.call(this)},this),this.trigger("ready")},1)}$(e,t){return Ve(e,t||this.contentEl())}$$(e,t){return $e(e,t||this.contentEl())}hasClass(e){return Te(this.el_,e)}addClass(...e){ke(this.el_,...e)}removeClass(...e){Ce(this.el_,...e)}toggleClass(e,t){we(this.el_,e,t)}show(){this.removeClass("vjs-hidden")}hide(){this.addClass("vjs-hidden")}lockShowing(){this.addClass("vjs-lock-showing")}unlockShowing(){this.removeClass("vjs-lock-showing")}getAttribute(e){return xe(this.el_,e)}setAttribute(e,t){Pe(this.el_,e,t)}removeAttribute(e){je(this.el_,e)}width(e,t){return this.dimension("width",e,t)}height(e,t){return this.dimension("height",e,t)}dimensions(e,t){this.width(e,!0),this.height(t)}dimension(e,t,s){var i,r;if(void 0===t)return this.el_?-1!==(r=(i=this.el_.style[e]).indexOf("px"))?parseInt(i.slice(0,r),10):parseInt(this.el_["offset"+y(e)],10):0;-1!==(""+(t=null!==t&&t==t?t:0)).indexOf("%")||-1!==(""+t).indexOf("px")?this.el_.style[e]=t:this.el_.style[e]="auto"===t?"":t+"px",s||this.trigger("componentresize")}currentDimension(e){let t=0;if("width"!==e&&"height"!==e)throw new Error("currentDimension only accepts width or height value");return t=ze(this.el_,e),0!==(t=parseFloat(t))&&!isNaN(t)||(e="offset"+y(e),t=this.el_[e]),t}currentDimensions(){return{width:this.currentDimension("width"),height:this.currentDimension("height")}}currentWidth(){return this.currentDimension("width")}currentHeight(){return this.currentDimension("height")}focus(){this.el_.focus()}blur(){this.el_.blur()}handleKeyDown(e){this.player_&&(a.isEventKey(e,"Tab")||e.stopPropagation(),this.player_.handleKeyDown(e))}handleKeyPress(e){this.handleKeyDown(e)}emitTapEvents(){let t=0,s=null;let i;this.on("touchstart",function(e){1===e.touches.length&&(s={pageX:e.touches[0].pageX,pageY:e.touches[0].pageY},t=window.performance.now(),i=!0)}),this.on("touchmove",function(e){var t;(1<e.touches.length||s&&(t=e.touches[0].pageX-s.pageX,e=e.touches[0].pageY-s.pageY,10<Math.sqrt(t*t+e*e)))&&(i=!1)});function e(){i=!1}this.on("touchleave",e),this.on("touchcancel",e),this.on("touchend",function(e){!(s=null)===i&&window.performance.now()-t<200&&(e.preventDefault(),this.trigger("tap"))})}enableTouchActivity(){if(this.player()&&this.player().reportUserActivity){const s=v(this.player(),this.player().reportUserActivity);let t;this.on("touchstart",function(){s(),this.clearInterval(t),t=this.setInterval(s,250)});var e=function(e){s(),this.clearInterval(t)};this.on("touchmove",s),this.on("touchend",e),this.on("touchcancel",e)}}setTimeout(e,t){var s;return e=v(this,e),this.clearTimersOnDispose_(),s=window.setTimeout(()=>{this.setTimeoutIds_.has(s)&&this.setTimeoutIds_.delete(s),e()},t),this.setTimeoutIds_.add(s),s}clearTimeout(e){return this.setTimeoutIds_.has(e)&&(this.setTimeoutIds_.delete(e),window.clearTimeout(e)),e}setInterval(e,t){e=v(this,e),this.clearTimersOnDispose_();e=window.setInterval(e,t);return this.setIntervalIds_.add(e),e}clearInterval(e){return this.setIntervalIds_.has(e)&&(this.setIntervalIds_.delete(e),window.clearInterval(e)),e}requestAnimationFrame(e){var t;return this.clearTimersOnDispose_(),e=v(this,e),t=window.requestAnimationFrame(()=>{this.rafIds_.has(t)&&this.rafIds_.delete(t),e()}),this.rafIds_.add(t),t}requestNamedAnimationFrame(e,t){var s;if(!this.namedRafs_.has(e))return this.clearTimersOnDispose_(),t=v(this,t),s=this.requestAnimationFrame(()=>{t(),this.namedRafs_.has(e)&&this.namedRafs_.delete(e)}),this.namedRafs_.set(e,s),e}cancelNamedAnimationFrame(e){this.namedRafs_.has(e)&&(this.cancelAnimationFrame(this.namedRafs_.get(e)),this.namedRafs_.delete(e))}cancelAnimationFrame(e){return this.rafIds_.has(e)&&(this.rafIds_.delete(e),window.cancelAnimationFrame(e)),e}clearTimersOnDispose_(){this.clearingTimersOnDispose_||(this.clearingTimersOnDispose_=!0,this.one("dispose",()=>{[["namedRafs_","cancelNamedAnimationFrame"],["rafIds_","cancelAnimationFrame"],["setTimeoutIds_","clearTimeout"],["setIntervalIds_","clearInterval"]].forEach(([e,s])=>{this[e].forEach((e,t)=>this[s](t))}),this.clearingTimersOnDispose_=!1}))}static registerComponent(t,e){if("string"!=typeof t||!t)throw new Error(`Illegal component name, "${t}"; must be a non-empty string.`);var s=b.getComponent("Tech"),s=s&&s.isTech(e),i=b===e||b.prototype.isPrototypeOf(e.prototype);if(s||!i){let e;throw e=s?"techs must be registered using Tech.registerTech()":"must be a Component subclass",new Error(`Illegal component, "${t}"; ${e}.`)}t=y(t),b.components_||(b.components_={});i=b.getComponent("Player");if("Player"===t&&i&&i.players){const r=i.players;s=Object.keys(r);if(r&&0<s.length&&s.map(e=>r[e]).every(Boolean))throw new Error("Can not register Player component after player has been created.")}return b.components_[t]=e,b.components_[kt(t)]=e}static getComponent(e){if(e&&b.components_)return b.components_[e]}}function xt(e,t,s,i){var r=i,n=s.length-1;if("number"!=typeof r||r<0||n<r)throw new Error(`Failed to execute '${e}' on 'TimeRanges': The index provided (${r}) is non-numeric or out of bounds (0-${n}).`);return s[i][t]}function Pt(e){let t;return t=void 0===e||0===e.length?{length:0,start(){throw new Error("This TimeRanges object is empty")},end(){throw new Error("This TimeRanges object is empty")}}:{length:e.length,start:xt.bind(null,"start",0,e),end:xt.bind(null,"end",1,e)},window.Symbol&&window.Symbol.iterator&&(t[window.Symbol.iterator]=()=>(e||[]).values()),t}function T(e,t){return Array.isArray(e)?Pt(e):void 0===e||void 0===t?Pt():Pt([[e,t]])}b.registerComponent("Component",b);function jt(e,t){e=e<0?0:e;let s=Math.floor(e%60),i=Math.floor(e/60%60),r=Math.floor(e/3600);var n=Math.floor(t/60%60),t=Math.floor(t/3600);return r=0<(r=!isNaN(e)&&e!==1/0?r:i=s="-")||0<t?r+":":"",i=((r||10<=n)&&i<10?"0"+i:i)+":",s=s<10?"0"+s:s,r+i+s}let At=jt;function It(e){At=e}function Ot(){At=jt}function Mt(e,t=e){return At(e,t)}var Lt=Object.freeze({__proto__:null,createTimeRanges:T,createTimeRange:T,setFormatTime:It,resetFormatTime:Ot,formatTime:Mt});function Nt(t,s){let i=0;var r;let n;if(!s)return 0;t&&t.length||(t=T(0,0));for(let e=0;e<t.length;e++)r=t.start(e),(n=t.end(e))>s&&(n=s),i+=n-r;return i/s}function i(e){if(e instanceof i)return e;"number"==typeof e?this.code=e:"string"==typeof e?this.message=e:n(e)&&("number"==typeof e.code&&(this.code=e.code),Object.assign(this,e)),this.message||(this.message=i.defaultMessages[this.code]||"")}i.prototype.code=0,i.prototype.message="",i.prototype.status=null,i.errorTypes=["MEDIA_ERR_CUSTOM","MEDIA_ERR_ABORTED","MEDIA_ERR_NETWORK","MEDIA_ERR_DECODE","MEDIA_ERR_SRC_NOT_SUPPORTED","MEDIA_ERR_ENCRYPTED"],i.defaultMessages={1:"You aborted the media playback",2:"A network error caused the media download to fail part-way.",3:"The media playback was aborted due to a corruption problem or because the media used features your browser did not support.",4:"The media could not be loaded, either because the server or network failed or because the format is not supported.",5:"The media is encrypted and we do not have the keys to decrypt it."};for(let e=0;e<i.errorTypes.length;e++)i[i.errorTypes[e]]=e,i.prototype[i.errorTypes[e]]=e;var Dt=function(e,t){var s,i=null;try{s=JSON.parse(e,t)}catch(e){i=e}return[i,s]};function Ft(e){return null!=e&&"function"==typeof e.then}function k(e){Ft(e)&&e.then(null,e=>{})}function Rt(i){return["kind","label","language","id","inBandMetadataTrackDispatchType","mode","src"].reduce((e,t,s)=>(i[t]&&(e[t]=i[t]),e),{cues:i.cues&&Array.prototype.map.call(i.cues,function(e){return{startTime:e.startTime,endTime:e.endTime,text:e.text,id:e.id}})})}var Bt=function(e){var t=e.$$("track");const s=Array.prototype.map.call(t,e=>e.track);return Array.prototype.map.call(t,function(e){var t=Rt(e.track);return e.src&&(t.src=e.src),t}).concat(Array.prototype.filter.call(e.textTracks(),function(e){return-1===s.indexOf(e)}).map(Rt))},Ht=function(e,s){return e.forEach(function(e){const t=s.addRemoteTextTrack(e).track;!e.src&&e.cues&&e.cues.forEach(e=>t.addCue(e))}),s.textTracks()};Rt;const Vt="vjs-modal-dialog";class $t extends b{constructor(e,t){super(e,t),this.handleKeyDown_=e=>this.handleKeyDown(e),this.close_=e=>this.close(e),this.opened_=this.hasBeenOpened_=this.hasBeenFilled_=!1,this.closeable(!this.options_.uncloseable),this.content(this.options_.content),this.contentEl_=p("div",{className:Vt+"-content"},{role:"document"}),this.descEl_=p("p",{className:Vt+"-description vjs-control-text",id:this.el().getAttribute("aria-describedby")}),ye(this.descEl_,this.description()),this.el_.appendChild(this.descEl_),this.el_.appendChild(this.contentEl_)}createEl(){return super.createEl("div",{className:this.buildCSSClass(),tabIndex:-1},{"aria-describedby":this.id()+"_description","aria-hidden":"true","aria-label":this.label(),role:"dialog"})}dispose(){this.contentEl_=null,this.descEl_=null,this.previouslyActiveEl_=null,super.dispose()}buildCSSClass(){return Vt+" vjs-hidden "+super.buildCSSClass()}label(){return this.localize(this.options_.label||"Modal Window")}description(){let e=this.options_.description||this.localize("This is a modal window.");return this.closeable()&&(e+=" "+this.localize("This modal can be closed by pressing the Escape key or activating the close button.")),e}open(){var e;this.opened_||(e=this.player(),this.trigger("beforemodalopen"),this.opened_=!0,!this.options_.fillAlways&&(this.hasBeenOpened_||this.hasBeenFilled_)||this.fill(),this.wasPlaying_=!e.paused(),this.options_.pauseOnOpen&&this.wasPlaying_&&e.pause(),this.on("keydown",this.handleKeyDown_),this.hadControls_=e.controls(),e.controls(!1),this.show(),this.conditionalFocus_(),this.el().setAttribute("aria-hidden","false"),this.trigger("modalopen"),this.hasBeenOpened_=!0)}opened(e){return"boolean"==typeof e&&this[e?"open":"close"](),this.opened_}close(){var e;this.opened_&&(e=this.player(),this.trigger("beforemodalclose"),this.opened_=!1,this.wasPlaying_&&this.options_.pauseOnOpen&&e.play(),this.off("keydown",this.handleKeyDown_),this.hadControls_&&e.controls(!0),this.hide(),this.el().setAttribute("aria-hidden","true"),this.trigger("modalclose"),this.conditionalBlur_(),this.options_.temporary)&&this.dispose()}closeable(t){if("boolean"==typeof t){var s,t=this.closeable_=!!t;let e=this.getChild("closeButton");t&&!e&&(s=this.contentEl_,this.contentEl_=this.el_,e=this.addChild("closeButton",{controlText:"Close Modal Dialog"}),this.contentEl_=s,this.on(e,"close",this.close_)),!t&&e&&(this.off(e,"close",this.close_),this.removeChild(e),e.dispose())}return this.closeable_}fill(){this.fillWith(this.content())}fillWith(e){var t=this.contentEl(),s=t.parentNode,i=t.nextSibling,e=(this.trigger("beforemodalfill"),this.hasBeenFilled_=!0,s.removeChild(t),this.empty(),Be(t,e),this.trigger("modalfill"),i?s.insertBefore(t,i):s.appendChild(t),this.getChild("closeButton"));e&&s.appendChild(e.el_)}empty(){this.trigger("beforemodalempty"),De(this.contentEl()),this.trigger("modalempty")}content(e){return"undefined"!=typeof e&&(this.content_=e),this.content_}conditionalFocus_(){var e=document.activeElement,t=this.player_.el_;this.previouslyActiveEl_=null,!t.contains(e)&&t!==e||(this.previouslyActiveEl_=e,this.focus())}conditionalBlur_(){this.previouslyActiveEl_&&(this.previouslyActiveEl_.focus(),this.previouslyActiveEl_=null)}handleKeyDown(e){if(e.stopPropagation(),a.isEventKey(e,"Escape")&&this.closeable())e.preventDefault(),this.close();else if(a.isEventKey(e,"Tab")){var s=this.focusableEls_(),i=this.el_.querySelector(":focus");let t;for(let e=0;e<s.length;e++)if(i===s[e]){t=e;break}document.activeElement===this.el_&&(t=0),e.shiftKey&&0===t?(s[s.length-1].focus(),e.preventDefault()):e.shiftKey||t!==s.length-1||(s[0].focus(),e.preventDefault())}}focusableEls_(){var e=this.el_.querySelectorAll("*");return Array.prototype.filter.call(e,e=>(e instanceof window.HTMLAnchorElement||e instanceof window.HTMLAreaElement)&&e.hasAttribute("href")||(e instanceof window.HTMLInputElement||e instanceof window.HTMLSelectElement||e instanceof window.HTMLTextAreaElement||e instanceof window.HTMLButtonElement)&&!e.hasAttribute("disabled")||e instanceof window.HTMLIFrameElement||e instanceof window.HTMLObjectElement||e instanceof window.HTMLEmbedElement||e.hasAttribute("tabindex")&&-1!==e.getAttribute("tabindex")||e.hasAttribute("contenteditable"))}}$t.prototype.options_={pauseOnOpen:!0,temporary:!0},b.registerComponent("ModalDialog",$t);class zt extends s{constructor(t=[]){super(),this.tracks_=[],Object.defineProperty(this,"length",{get(){return this.tracks_.length}});for(let e=0;e<t.length;e++)this.addTrack(t[e])}addTrack(e){const t=this.tracks_.length;""+t in this||Object.defineProperty(this,t,{get(){return this.tracks_[t]}}),-1===this.tracks_.indexOf(e)&&(this.tracks_.push(e),this.trigger({track:e,type:"addtrack",target:this})),e.labelchange_=()=>{this.trigger({track:e,type:"labelchange",target:this})},ut(e)&&e.addEventListener("labelchange",e.labelchange_)}removeTrack(s){let i;for(let e=0,t=this.length;e<t;e++)if(this[e]===s){(i=this[e]).off&&i.off(),this.tracks_.splice(e,1);break}i&&this.trigger({track:i,type:"removetrack",target:this})}getTrackById(s){let i=null;for(let e=0,t=this.length;e<t;e++){var r=this[e];if(r.id===s){i=r;break}}return i}}for(const en in zt.prototype.allowedEvents_={change:"change",addtrack:"addtrack",removetrack:"removetrack",labelchange:"labelchange"})zt.prototype["on"+en]=null;function Ut(t,s){for(let e=0;e<t.length;e++)Object.keys(t[e]).length&&s.id!==t[e].id&&(t[e].enabled=!1)}function Kt(t,s){for(let e=0;e<t.length;e++)Object.keys(t[e]).length&&s.id!==t[e].id&&(t[e].selected=!1)}class Wt extends zt{addTrack(e){super.addTrack(e),this.queueChange_||(this.queueChange_=()=>this.queueTrigger("change")),this.triggerSelectedlanguagechange||(this.triggerSelectedlanguagechange_=()=>this.trigger("selectedlanguagechange")),e.addEventListener("modechange",this.queueChange_);-1===["metadata","chapters"].indexOf(e.kind)&&e.addEventListener("modechange",this.triggerSelectedlanguagechange_)}removeTrack(e){super.removeTrack(e),e.removeEventListener&&(this.queueChange_&&e.removeEventListener("modechange",this.queueChange_),this.selectedlanguagechange_)&&e.removeEventListener("modechange",this.triggerSelectedlanguagechange_)}}class qt{constructor(e){qt.prototype.setCues_.call(this,e),Object.defineProperty(this,"length",{get(){return this.length_}})}setCues_(e){var t=this.length||0;let s=0;function i(e){""+e in this||Object.defineProperty(this,""+e,{get(){return this.cues_[e]}})}var r=e.length;this.cues_=e,this.length_=e.length;if(t<r)for(s=t;s<r;s++)i.call(this,s)}getCueById(s){let i=null;for(let e=0,t=this.length;e<t;e++){var r=this[e];if(r.id===s){i=r;break}}return i}}const Xt={alternative:"alternative",captions:"captions",main:"main",sign:"sign",subtitles:"subtitles",commentary:"commentary"},Gt={alternative:"alternative",descriptions:"descriptions",main:"main","main-desc":"main-desc",translation:"translation",commentary:"commentary"},Yt={subtitles:"subtitles",captions:"captions",descriptions:"descriptions",chapters:"chapters",metadata:"metadata"},Qt={disabled:"disabled",hidden:"hidden",showing:"showing"};class Jt extends s{constructor(e={}){super();const t={id:e.id||"vjs_track_"+m++,kind:e.kind||"",language:e.language||""};let s=e.label||"";for(const i in t)Object.defineProperty(this,i,{get(){return t[i]},set(){}});Object.defineProperty(this,"label",{get(){return s},set(e){e!==s&&(s=e,this.trigger("labelchange"))}})}}function Zt(e){var t=["protocol","hostname","port","pathname","search","hash","host"],s=document.createElement("a"),i=(s.href=e,{});for(let e=0;e<t.length;e++)i[t[e]]=s[t[e]];return"http:"===i.protocol&&(i.host=i.host.replace(/:80$/,"")),"https:"===i.protocol&&(i.host=i.host.replace(/:443$/,"")),i.protocol||(i.protocol=window.location.protocol),i.host||(i.host=window.location.host),i}function es(e){var t;return e.match(/^https?:\/\//)||((t=document.createElement("a")).href=e,e=t.href),e}function ts(e,t=window.location){return(":"===(e=Zt(e)).protocol?t:e).protocol+e.host!==t.protocol+t.host}const ss=function(e){if("string"==typeof e){e=/^(\/?)([\s\S]*?)((?:\.{1,2}|[^\/]+?)(\.([^\.\/\?]+)))(?:[\/]*|[\?].*)$/.exec(e);if(e)return e.pop().toLowerCase()}return""};var is=Object.freeze({__proto__:null,parseUrl:Zt,getAbsoluteURL:es,getFileExtension:ss,isCrossOrigin:ts}),t="undefined"!=typeof window?window:"undefined"!=typeof Et?Et:"undefined"!=typeof self?self:{},C=t,rs=St(function(e){function t(){return e.exports=t=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s,i=arguments[t];for(s in i)Object.prototype.hasOwnProperty.call(i,s)&&(e[s]=i[s])}return e},e.exports.__esModule=!0,e.exports.default=e.exports,t.apply(this,arguments)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports}),ns=((t=rs)&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")&&t.default,function(e){var t;return!!e&&("[object Function]"===(t=as.call(e))||"function"==typeof e&&"[object RegExp]"!==t||"undefined"!=typeof window&&(e===window.setTimeout||e===window.alert||e===window.confirm||e===window.prompt))}),as=Object.prototype.toString;ps.httpHandler=function(i,r){return void 0===r&&(r=!1),function(e,t,s){if(e)i(e);else if(400<=t.statusCode&&t.statusCode<=599){e=s;if(r)if(C.TextDecoder){t=function(e){void 0===e&&(e="");return e.toLowerCase().split(";").reduce(function(e,t){var t=t.split("="),s=t[0],t=t[1];return"charset"===s.trim()?t.trim():e},"utf-8")}(t.headers&&t.headers["content-type"]);try{e=new TextDecoder(t).decode(s)}catch(e){}}else e=String.fromCharCode.apply(null,new Uint8Array(s));i({cause:e})}else i(null,s)}};for(var os=function(e){var i={};return e&&e.trim().split("\n").forEach(function(e){var t=e.indexOf(":"),s=e.slice(0,t).trim().toLowerCase(),e=e.slice(t+1).trim();"undefined"==typeof i[s]?i[s]=e:Array.isArray(i[s])?i[s].push(e):i[s]=[i[s],e]}),i},ls=ps,t=ps,hs=(ps.XMLHttpRequest=C.XMLHttpRequest||function(){},ps.XDomainRequest="withCredentials"in new ps.XMLHttpRequest?ps.XMLHttpRequest:C.XDomainRequest,["get","put","post","patch","head","delete"]),cs=function(i){ps["delete"===i?"del":i]=function(e,t,s){return(t=ds(e,t,s)).method=i.toUpperCase(),gs(t)}},us=0;us<hs.length;us++)cs(hs[us]);function ds(e,t,s){var i=e;return ns(t)?(s=t,"string"==typeof e&&(i={uri:e})):i=rs({},t,{uri:e}),i.callback=s,i}function ps(e,t,s){return gs(t=ds(e,t,s))}function gs(i){if("undefined"==typeof i.callback)throw new Error("callback argument missing");var r=!1,n=function(e,t,s){r||(r=!0,i.callback(e,t,s))};function a(){var e=void 0,e=h.response||h.responseText||function(e){try{if("document"===e.responseType)return e.responseXML;var t=e.responseXML&&"parsererror"===e.responseXML.documentElement.nodeName;if(""===e.responseType&&!t)return e.responseXML}catch(e){}return null}(h);if(m)try{e=JSON.parse(e)}catch(e){}return e}function t(e){return clearTimeout(l),(e=e instanceof Error?e:new Error(""+(e||"Unknown XMLHttpRequest Error"))).statusCode=0,n(e,_)}function e(){var e,t,s;if(!o)return clearTimeout(l),e=i.useXDR&&void 0===h.status?200:1223===h.status?204:h.status,t=_,s=null,0!==e?(t={body:a(),statusCode:e,method:u,headers:{},url:c,rawRequest:h},h.getAllResponseHeaders&&(t.headers=os(h.getAllResponseHeaders()))):s=new Error("Internal XMLHttpRequest Error"),n(s,t,t.body)}var s,o,l,h=i.xhr||null,c=(h=h||new(i.cors||i.useXDR?ps.XDomainRequest:ps.XMLHttpRequest)).url=i.uri||i.url,u=h.method=i.method||"GET",d=i.body||i.data,p=h.headers=i.headers||{},g=!!i.sync,m=!1,_={body:void 0,headers:{},statusCode:0,method:u,url:c,rawRequest:h};if("json"in i&&!1!==i.json&&(m=!0,p.accept||p.Accept||(p.Accept="application/json"),"GET"!==u)&&"HEAD"!==u&&(p["content-type"]||p["Content-Type"]||(p["Content-Type"]="application/json"),d=JSON.stringify(!0===i.json?d:i.json)),h.onreadystatechange=function(){4===h.readyState&&setTimeout(e,0)},h.onload=e,h.onerror=t,h.onprogress=function(){},h.onabort=function(){o=!0},h.ontimeout=t,h.open(u,c,!g,i.username,i.password),g||(h.withCredentials=!!i.withCredentials),!g&&0<i.timeout&&(l=setTimeout(function(){var e;o||(o=!0,h.abort("timeout"),(e=new Error("XMLHttpRequest timeout")).code="ETIMEDOUT",t(e))},i.timeout)),h.setRequestHeader)for(s in p)p.hasOwnProperty(s)&&h.setRequestHeader(s,p[s]);else if(i.headers&&!function(e){for(var t in e)if(e.hasOwnProperty(t))return;return 1}(i.headers))throw new Error("Headers cannot be set on an XDomainRequest object");return"responseType"in i&&(h.responseType=i.responseType),"beforeSend"in i&&"function"==typeof i.beforeSend&&i.beforeSend(h),h.send(d||null),h}ls.default=t;function ms(e,t){var s=new window.WebVTT.Parser(window,window.vttjs,window.WebVTT.StringDecoder());const i=[];s.oncue=function(e){t.addCue(e)},s.onparsingerror=function(e){i.push(e)},s.onflush=function(){t.trigger({type:"loadeddata",target:t})},s.parse(e),0<i.length&&(window.console&&window.console.groupCollapsed&&window.console.groupCollapsed("Text Track parsing errors for "+t.src),i.forEach(e=>h.error(e)),window.console)&&window.console.groupEnd&&window.console.groupEnd(),s.flush()}function _s(e,i){var t={uri:e};(e=ts(e))&&(t.cors=e),(e="use-credentials"===i.tech_.crossOrigin())&&(t.withCredentials=e),ls(t,v(this,function(e,t,s){if(e)return h.error(e,t);i.loaded_=!0,"function"!=typeof window.WebVTT?i.tech_&&i.tech_.any(["vttjsloaded","vttjserror"],e=>{if("vttjserror"!==e.type)return ms(s,i);h.error("vttjs failed to load, stopping trying to process "+i.src)}):ms(s,i)}))}class fs extends Jt{constructor(e={}){if(!e.tech)throw new Error("A tech was not provided.");e=c(e,{kind:Yt[e.kind]||"subtitles",language:e.language||e.srclang||""});let t=Qt[e.mode]||"disabled";const s=e.default,i=("metadata"!==e.kind&&"chapters"!==e.kind||(t="hidden"),super(e),this.tech_=e.tech,this.cues_=[],this.activeCues_=[],this.preload_=!1!==this.tech_.preloadTextTracks,new qt(this.cues_)),n=new qt(this.activeCues_);let a=!1;this.timeupdateHandler=v(this,function(e={}){this.tech_.isDisposed()||(this.tech_.isReady_&&(this.activeCues=this.activeCues,a)&&(this.trigger("cuechange"),a=!1),"timeupdate"!==e.type&&(this.rvf_=this.tech_.requestVideoFrameCallback(this.timeupdateHandler)))});this.tech_.one("dispose",()=>{this.stopTracking()}),"disabled"!==t&&this.startTracking(),Object.defineProperties(this,{default:{get(){return s},set(){}},mode:{get(){return t},set(e){Qt[e]&&t!==e&&(t=e,this.preload_||"disabled"===t||0!==this.cues.length||_s(this.src,this),this.stopTracking(),"disabled"!==t&&this.startTracking(),this.trigger("modechange"))}},cues:{get(){return this.loaded_?i:null},set(){}},activeCues:{get(){if(!this.loaded_)return null;if(0!==this.cues.length){var s=this.tech_.currentTime(),i=[];for(let e=0,t=this.cues.length;e<t;e++){var r=this.cues[e];r.startTime<=s&&r.endTime>=s&&i.push(r)}if(a=!1,i.length!==this.activeCues_.length)a=!0;else for(let e=0;e<i.length;e++)-1===this.activeCues_.indexOf(i[e])&&(a=!0);this.activeCues_=i,n.setCues_(this.activeCues_)}return n},set(){}}}),e.src?(this.src=e.src,this.preload_||(this.loaded_=!0),(this.preload_||"subtitles"!==e.kind&&"captions"!==e.kind)&&_s(this.src,this)):this.loaded_=!0}startTracking(){this.rvf_=this.tech_.requestVideoFrameCallback(this.timeupdateHandler),this.tech_.on("timeupdate",this.timeupdateHandler)}stopTracking(){this.rvf_&&(this.tech_.cancelVideoFrameCallback(this.rvf_),this.rvf_=void 0),this.tech_.off("timeupdate",this.timeupdateHandler)}addCue(e){let t=e;if(window.vttjs&&!(e instanceof window.vttjs.VTTCue)){t=new window.vttjs.VTTCue(e.startTime,e.endTime,e.text);for(const i in e)i in t||(t[i]=e[i]);t.id=e.id,t.originalCue_=e}var s=this.tech_.textTracks();for(let e=0;e<s.length;e++)s[e]!==this&&s[e].removeCue(t);this.cues_.push(t),this.cues.setCues_(this.cues_)}removeCue(e){let t=this.cues_.length;for(;t--;){var s=this.cues_[t];if(s===e||s.originalCue_&&s.originalCue_===e){this.cues_.splice(t,1),this.cues.setCues_(this.cues_);break}}}}fs.prototype.allowedEvents_={cuechange:"cuechange"};class vs extends Jt{constructor(e={}){e=c(e,{kind:Gt[e.kind]||""});super(e);let t=!1;Object.defineProperty(this,"enabled",{get(){return t},set(e){"boolean"==typeof e&&e!==t&&(t=e,this.trigger("enabledchange"))}}),e.enabled&&(this.enabled=e.enabled),this.loaded_=!0}}class ys extends Jt{constructor(e={}){e=c(e,{kind:Xt[e.kind]||""});super(e);let t=!1;Object.defineProperty(this,"selected",{get(){return t},set(e){"boolean"==typeof e&&e!==t&&(t=e,this.trigger("selectedchange"))}}),e.selected&&(this.selected=e.selected)}}class bs extends s{constructor(e={}){super();let t;const s=new fs(e);this.kind=s.kind,this.src=s.src,this.srclang=s.language,this.label=s.label,this.default=s.default,Object.defineProperties(this,{readyState:{get(){return t}},track:{get(){return s}}}),t=bs.NONE,s.addEventListener("loadeddata",()=>{t=bs.LOADED,this.trigger({type:"load",target:this})})}}bs.prototype.allowedEvents_={load:"load"},bs.NONE=0,bs.LOADING=1,bs.LOADED=2,bs.ERROR=3;const w={audio:{ListClass:class extends zt{constructor(t=[]){for(let e=t.length-1;0<=e;e--)if(t[e].enabled){Ut(t,t[e]);break}super(t),this.changing_=!1}addTrack(e){e.enabled&&Ut(this,e),super.addTrack(e),e.addEventListener&&(e.enabledChange_=()=>{this.changing_||(this.changing_=!0,Ut(this,e),this.changing_=!1,this.trigger("change"))},e.addEventListener("enabledchange",e.enabledChange_))}removeTrack(e){super.removeTrack(e),e.removeEventListener&&e.enabledChange_&&(e.removeEventListener("enabledchange",e.enabledChange_),e.enabledChange_=null)}},TrackClass:vs,capitalName:"Audio"},video:{ListClass:class extends zt{constructor(t=[]){for(let e=t.length-1;0<=e;e--)if(t[e].selected){Kt(t,t[e]);break}super(t),this.changing_=!1,Object.defineProperty(this,"selectedIndex",{get(){for(let e=0;e<this.length;e++)if(this[e].selected)return e;return-1},set(){}})}addTrack(e){e.selected&&Kt(this,e),super.addTrack(e),e.addEventListener&&(e.selectedChange_=()=>{this.changing_||(this.changing_=!0,Kt(this,e),this.changing_=!1,this.trigger("change"))},e.addEventListener("selectedchange",e.selectedChange_))}removeTrack(e){super.removeTrack(e),e.removeEventListener&&e.selectedChange_&&(e.removeEventListener("selectedchange",e.selectedChange_),e.selectedChange_=null)}},TrackClass:ys,capitalName:"Video"},text:{ListClass:Wt,TrackClass:fs,capitalName:"Text"}},Ts=(Object.keys(w).forEach(function(e){w[e].getterName=e+"Tracks",w[e].privateName=e+"Tracks_"}),{remoteText:{ListClass:Wt,TrackClass:fs,capitalName:"RemoteText",getterName:"remoteTextTracks",privateName:"remoteTextTracks_"},remoteTextEl:{ListClass:class{constructor(s=[]){this.trackElements_=[],Object.defineProperty(this,"length",{get(){return this.trackElements_.length}});for(let e=0,t=s.length;e<t;e++)this.addTrackElement_(s[e])}addTrackElement_(e){const t=this.trackElements_.length;""+t in this||Object.defineProperty(this,t,{get(){return this.trackElements_[t]}}),-1===this.trackElements_.indexOf(e)&&this.trackElements_.push(e)}getTrackElementByTrack_(s){let i;for(let e=0,t=this.trackElements_.length;e<t;e++)if(s===this.trackElements_[e].track){i=this.trackElements_[e];break}return i}removeTrackElement_(s){for(let e=0,t=this.trackElements_.length;e<t;e++)if(s===this.trackElements_[e]){this.trackElements_[e].track&&"function"==typeof this.trackElements_[e].track.off&&this.trackElements_[e].track.off(),"function"==typeof this.trackElements_[e].off&&this.trackElements_[e].off(),this.trackElements_.splice(e,1);break}}},TrackClass:bs,capitalName:"RemoteTextTrackEls",getterName:"remoteTextTrackEls",privateName:"remoteTextTrackEls_"}}),E=Object.assign({},w,Ts);Ts.names=Object.keys(Ts),w.names=Object.keys(w),E.names=[].concat(Ts.names).concat(w.names);var t="undefined"!=typeof Et?Et:"undefined"!=typeof window?window:{},ks="undefined"!=typeof document?document:(ks=t["__GLOBAL_DOCUMENT_CACHE@4"])||(t["__GLOBAL_DOCUMENT_CACHE@4"]={}),Et=ks,Cs=Object.create||function(e){if(1!==arguments.length)throw new Error("Object.create shim only accepts one parameter.");return ws.prototype=e,new ws};function ws(){}function S(e,t){this.name="ParsingError",this.code=e.code,this.message=t||e.message}function Es(e){function t(e,t,s,i){return 3600*(0|e)+60*(0|t)+(0|s)+(0|i)/1e3}e=e.match(/^(\d+):(\d{1,2})(:\d{1,2})?\.(\d{3})/);return e?e[3]?t(e[1],e[2],e[3].replace(":",""),e[4]):59<e[1]?t(e[1],e[2],0,e[4]):t(0,e[1],e[2],e[4]):null}function Ss(){this.values=Cs(null)}function xs(e,t,s,i){var r,n,a=i?e.split(i):[e];for(r in a)"string"==typeof a[r]&&2===(n=a[r].split(s)).length&&t(n[0].trim(),n[1].trim())}((S.prototype=Cs(Error.prototype)).constructor=S).Errors={BadSignature:{code:0,message:"Malformed WebVTT signature."},BadTimeStamp:{code:1,message:"Malformed time stamp."}},Ss.prototype={set:function(e,t){this.get(e)||""===t||(this.values[e]=t)},get:function(e,t,s){return s?this.has(e)?this.values[e]:t[s]:this.has(e)?this.values[e]:t},has:function(e){return e in this.values},alt:function(e,t,s){for(var i=0;i<s.length;++i)if(t===s[i]){this.set(e,t);break}},integer:function(e,t){/^-?\d+$/.test(t)&&this.set(e,parseInt(t,10))},percent:function(e,t){return!!(t.match(/^([\d]{1,3})(\.[\d]*)?%$/)&&0<=(t=parseFloat(t))&&t<=100)&&(this.set(e,t),!0)}};var Ps=Et.createElement&&Et.createElement("textarea"),js={c:"span",i:"i",b:"b",u:"u",ruby:"ruby",rt:"rt",v:"span",lang:"span"},As={white:"rgba(255,255,255,1)",lime:"rgba(0,255,0,1)",cyan:"rgba(0,255,255,1)",red:"rgba(255,0,0,1)",yellow:"rgba(255,255,0,1)",magenta:"rgba(255,0,255,1)",blue:"rgba(0,0,255,1)",black:"rgba(0,0,0,1)"},Is={v:"title",lang:"lang"},Os={rt:"ruby"};function Ms(e,t){for(var s,i,r,n,a,o,l=e.document.createElement("div"),h=l,c=[];null!==(o=void 0,o=t?(o=(o=t.match(/^([^<]*)(<[^>]*>?)?/))[1]||o[2],t=t.substr(o.length),o):null);)"<"===o[0]?"/"===o[1]?c.length&&c[c.length-1]===o.substr(2).replace(">","")&&(c.pop(),h=h.parentNode):(i=Es(o.substr(1,o.length-2)))?(s=e.document.createProcessingInstruction("timestamp",i),h.appendChild(s)):(i=o.match(/^<([^.\s/0-9>]+)(\.[^\s\\>]+)?([^>\\]+)?(\\?)>?$/))&&(r=i[1],n=i[3],a=void 0,a=js[r],s=a?(a=e.document.createElement(a),(r=Is[r])&&n&&(a[r]=n.trim()),a):null)&&(r=h,Os[(n=s).localName]&&Os[n.localName]!==r.localName||(i[2]&&((a=i[2].split(".")).forEach(function(e){var t=/^bg_/.test(e),e=t?e.slice(3):e;As.hasOwnProperty(e)&&(e=As[e],s.style[t?"background-color":"color"]=e)}),s.className=a.join(" ")),c.push(i[1]),h.appendChild(s),h=s)):h.appendChild(e.document.createTextNode((n=o,Ps.innerHTML=n,n=Ps.textContent,Ps.textContent="",n)));return l}var Ls=[[1470,1470],[1472,1472],[1475,1475],[1478,1478],[1488,1514],[1520,1524],[1544,1544],[1547,1547],[1549,1549],[1563,1563],[1566,1610],[1645,1647],[1649,1749],[1765,1766],[1774,1775],[1786,1805],[1807,1808],[1810,1839],[1869,1957],[1969,1969],[1984,2026],[2036,2037],[2042,2042],[2048,2069],[2074,2074],[2084,2084],[2088,2088],[2096,2110],[2112,2136],[2142,2142],[2208,2208],[2210,2220],[8207,8207],[64285,64285],[64287,64296],[64298,64310],[64312,64316],[64318,64318],[64320,64321],[64323,64324],[64326,64449],[64467,64829],[64848,64911],[64914,64967],[65008,65020],[65136,65140],[65142,65276],[67584,67589],[67592,67592],[67594,67637],[67639,67640],[67644,67644],[67647,67669],[67671,67679],[67840,67867],[67872,67897],[67903,67903],[67968,68023],[68030,68031],[68096,68096],[68112,68115],[68117,68119],[68121,68147],[68160,68167],[68176,68184],[68192,68223],[68352,68405],[68416,68437],[68440,68466],[68472,68479],[68608,68680],[126464,126467],[126469,126495],[126497,126498],[126500,126500],[126503,126503],[126505,126514],[126516,126519],[126521,126521],[126523,126523],[126530,126530],[126535,126535],[126537,126537],[126539,126539],[126541,126543],[126545,126546],[126548,126548],[126551,126551],[126553,126553],[126555,126555],[126557,126557],[126559,126559],[126561,126562],[126564,126564],[126567,126570],[126572,126578],[126580,126583],[126585,126588],[126590,126590],[126592,126601],[126603,126619],[126625,126627],[126629,126633],[126635,126651],[1114109,1114109]];function Ns(e){var t=[],s="";if(e&&e.childNodes)for(n(t,e);s=function e(t){var s,i,r;return t&&t.length?(i=(s=t.pop()).textContent||s.innerText)?(r=i.match(/^.*(\n|\r)/))?r[t.length=0]:i:"ruby"===s.tagName?e(t):s.childNodes?(n(t,s),e(t)):void 0:null}(t);)for(var i=0;i<s.length;i++)if(function(e){for(var t=0;t<Ls.length;t++){var s=Ls[t];if(e>=s[0]&&e<=s[1])return 1}}(s.charCodeAt(i)))return"rtl";return"ltr";function n(e,t){for(var s=t.childNodes.length-1;0<=s;s--)e.push(t.childNodes[s])}}function Ds(){}function Fs(e,t,s){Ds.call(this),this.cue=t,this.cueDiv=Ms(e,t.text);var i={color:"rgba(255, 255, 255, 1)",backgroundColor:"rgba(0, 0, 0, 0.8)",position:"relative",left:0,right:0,top:0,bottom:0,display:"inline",writingMode:""===t.vertical?"horizontal-tb":"lr"===t.vertical?"vertical-lr":"vertical-rl",unicodeBidi:"plaintext"},r=(this.applyStyles(i,this.cueDiv),this.div=e.document.createElement("div"),i={direction:Ns(this.cueDiv),writingMode:""===t.vertical?"horizontal-tb":"lr"===t.vertical?"vertical-lr":"vertical-rl",unicodeBidi:"plaintext",textAlign:"middle"===t.align?"center":t.align,font:s.font,whiteSpace:"pre-line",position:"absolute"},this.applyStyles(i),this.div.appendChild(this.cueDiv),0);switch(t.positionAlign){case"start":r=t.position;break;case"center":r=t.position-t.size/2;break;case"end":r=t.position-t.size}""===t.vertical?this.applyStyles({left:this.formatStyle(r,"%"),width:this.formatStyle(t.size,"%")}):this.applyStyles({top:this.formatStyle(r,"%"),height:this.formatStyle(t.size,"%")}),this.move=function(e){this.applyStyles({top:this.formatStyle(e.top,"px"),bottom:this.formatStyle(e.bottom,"px"),left:this.formatStyle(e.left,"px"),right:this.formatStyle(e.right,"px"),height:this.formatStyle(e.height,"px"),width:this.formatStyle(e.width,"px")})}}function x(e){var t,s,i,r;e.div&&(t=e.div.offsetHeight,s=e.div.offsetWidth,i=e.div.offsetTop,r=(r=(r=e.div.childNodes)&&r[0])&&r.getClientRects&&r.getClientRects(),e=e.div.getBoundingClientRect(),r=r?Math.max(r[0]&&r[0].height||0,e.height/r.length):0),this.left=e.left,this.right=e.right,this.top=e.top||i,this.height=e.height||t,this.bottom=e.bottom||i+(e.height||t),this.width=e.width||s,this.lineHeight=void 0!==r?r:e.lineHeight}function Rs(e,t,o,l){var s,i=new x(t),r=t.cue,n=function(e){if("number"==typeof e.line&&(e.snapToLines||0<=e.line&&e.line<=100))return e.line;if(!e.track||!e.track.textTrackList||!e.track.textTrackList.mediaElement)return-1;for(var t=e.track,s=t.textTrackList,i=0,r=0;r<s.length&&s[r]!==t;r++)"showing"===s[r].mode&&i++;return-1*++i}(r),a=[];if(r.snapToLines){switch(r.vertical){case"":a=["+y","-y"],s="height";break;case"rl":a=["+x","-x"],s="width";break;case"lr":a=["-x","+x"],s="width"}var h=i.lineHeight,c=h*Math.round(n),u=o[s]+h,d=a[0];Math.abs(c)>u&&(c=c<0?-1:1,c*=Math.ceil(u/h)*h),n<0&&(c+=""===r.vertical?o.height:o.width,a=a.reverse()),i.move(d,c)}else{var p=i.lineHeight/o.height*100;switch(r.lineAlign){case"center":n-=p/2;break;case"end":n-=p}switch(r.vertical){case"":t.applyStyles({top:t.formatStyle(n,"%")});break;case"rl":t.applyStyles({left:t.formatStyle(n,"%")});break;case"lr":t.applyStyles({right:t.formatStyle(n,"%")})}a=["+y","-x","+x","-y"],i=new x(t)}u=function(e,t){for(var s,i=new x(e),r=1,n=0;n<t.length;n++){for(;e.overlapsOppositeAxis(o,t[n])||e.within(o)&&e.overlapsAny(l);)e.move(t[n]);if(e.within(o))return e;var a=e.intersectPercentage(o);a<r&&(s=new x(e),r=a),e=new x(i)}return s||i}(i,a);t.move(u.toCSSCompatValues(o))}function Bs(){}Ds.prototype.applyStyles=function(e,t){for(var s in t=t||this.div,e)e.hasOwnProperty(s)&&(t.style[s]=e[s])},Ds.prototype.formatStyle=function(e,t){return 0===e?0:e+t},(Fs.prototype=Cs(Ds.prototype)).constructor=Fs,x.prototype.move=function(e,t){switch(t=void 0!==t?t:this.lineHeight,e){case"+x":this.left+=t,this.right+=t;break;case"-x":this.left-=t,this.right-=t;break;case"+y":this.top+=t,this.bottom+=t;break;case"-y":this.top-=t,this.bottom-=t}},x.prototype.overlaps=function(e){return this.left<e.right&&this.right>e.left&&this.top<e.bottom&&this.bottom>e.top},x.prototype.overlapsAny=function(e){for(var t=0;t<e.length;t++)if(this.overlaps(e[t]))return!0;return!1},x.prototype.within=function(e){return this.top>=e.top&&this.bottom<=e.bottom&&this.left>=e.left&&this.right<=e.right},x.prototype.overlapsOppositeAxis=function(e,t){switch(t){case"+x":return this.left<e.left;case"-x":return this.right>e.right;case"+y":return this.top<e.top;case"-y":return this.bottom>e.bottom}},x.prototype.intersectPercentage=function(e){return Math.max(0,Math.min(this.right,e.right)-Math.max(this.left,e.left))*Math.max(0,Math.min(this.bottom,e.bottom)-Math.max(this.top,e.top))/(this.height*this.width)},x.prototype.toCSSCompatValues=function(e){return{top:this.top-e.top,bottom:e.bottom-this.bottom,left:this.left-e.left,right:e.right-this.right,height:this.height,width:this.width}},x.getSimpleBoxPosition=function(e){var t=e.div?e.div.offsetHeight:e.tagName?e.offsetHeight:0,s=e.div?e.div.offsetWidth:e.tagName?e.offsetWidth:0,i=e.div?e.div.offsetTop:e.tagName?e.offsetTop:0;return{left:(e=e.div?e.div.getBoundingClientRect():e.tagName?e.getBoundingClientRect():e).left,right:e.right,top:e.top||i,height:e.height||t,bottom:e.bottom||i+(e.height||t),width:e.width||s}},Bs.StringDecoder=function(){return{decode:function(e){if(!e)return"";if("string"!=typeof e)throw new Error("Error - expected string data.");return decodeURIComponent(encodeURIComponent(e))}}},Bs.convertCueToDOMTree=function(e,t){return e&&t?Ms(e,t):null};Bs.processCues=function(e,t,s){if(!e||!t||!s)return null;for(;s.firstChild;)s.removeChild(s.firstChild);var i=e.document.createElement("div");if(i.style.position="absolute",i.style.left="0",i.style.right="0",i.style.top="0",i.style.bottom="0",i.style.margin="1.5%",s.appendChild(i),function(e){for(var t=0;t<e.length;t++)if(e[t].hasBeenReset||!e[t].displayState)return 1}(t))for(var r,n,a=[],o=x.getSimpleBoxPosition(i),l={font:Math.round(.05*o.height*100)/100+"px sans-serif"},h=0;h<t.length;h++)n=t[h],r=new Fs(e,n,l),i.appendChild(r.div),Rs(0,r,o,a),n.displayState=r.div,a.push(x.getSimpleBoxPosition(r));else for(var c=0;c<t.length;c++)i.appendChild(t[c].displayState)},(Bs.Parser=function(e,t,s){s||(s=t,t={}),t=t||{},this.window=e,this.vttjs=t,this.state="INITIAL",this.buffer="",this.decoder=s||new TextDecoder("utf8"),this.regionList=[]}).prototype={reportOrThrowError:function(e){if(!(e instanceof S))throw e;this.onparsingerror&&this.onparsingerror(e)},parse:function(e){var i=this;function t(){for(var e=i.buffer,t=0;t<e.length&&"\r"!==e[t]&&"\n"!==e[t];)++t;var s=e.substr(0,t);return"\r"===e[t]&&++t,"\n"===e[t]&&++t,i.buffer=e.substr(t),s}function s(e){e.match(/X-TIMESTAMP-MAP/)?xs(e,function(e,t){var s;"X-TIMESTAMP-MAP"===e&&(e=t,s=new Ss,xs(e,function(e,t){switch(e){case"MPEGT":s.integer(e+"S",t);break;case"LOCA":s.set(e+"L",Es(t))}},/[^\d]:/,/,/),i.ontimestampmap)&&i.ontimestampmap({MPEGTS:s.get("MPEGTS"),LOCAL:s.get("LOCAL")})},/=/):xs(e,function(e,t){var r;"Region"===e&&(e=t,r=new Ss,xs(e,function(e,t){switch(e){case"id":r.set(e,t);break;case"width":r.percent(e,t);break;case"lines":r.integer(e,t);break;case"regionanchor":case"viewportanchor":var s,i=t.split(",");2===i.length&&((s=new Ss).percent("x",i[0]),s.percent("y",i[1]),s.has("x")&&s.has("y"))&&(r.set(e+"X",s.get("x")),r.set(e+"Y",s.get("y")));break;case"scroll":r.alt(e,t,["up"])}},/=/,/\s/),r.has("id"))&&((e=new(i.vttjs.VTTRegion||i.window.VTTRegion)).width=r.get("width",100),e.lines=r.get("lines",3),e.regionAnchorX=r.get("regionanchorX",0),e.regionAnchorY=r.get("regionanchorY",100),e.viewportAnchorX=r.get("viewportanchorX",0),e.viewportAnchorY=r.get("viewportanchorY",100),e.scroll=r.get("scroll",""),i.onregion&&i.onregion(e),i.regionList.push({id:r.get("id"),region:e}))},/:/)}e&&(i.buffer+=i.decoder.decode(e,{stream:!0}));try{if("INITIAL"===i.state){if(!/\r\n|\n/.test(i.buffer))return this;var r,n=(r=t()).match(/^WEBVTT([ \t].*)?$/);if(!n||!n[0])throw new S(S.Errors.BadSignature);i.state="HEADER"}for(var a=!1;i.buffer;){if(!/\r\n|\n/.test(i.buffer))return this;switch(a?a=!1:r=t(),i.state){case"HEADER":/:/.test(r)?s(r):r||(i.state="ID");continue;case"NOTE":r||(i.state="ID");continue;case"ID":if(/^NOTE($|[ \t])/.test(r)){i.state="NOTE";break}if(!r)continue;i.cue=new(i.vttjs.VTTCue||i.window.VTTCue)(0,0,"");try{i.cue.align="center"}catch(e){i.cue.align="middle"}if(i.state="CUE",-1===r.indexOf("--\x3e")){i.cue.id=r;continue}case"CUE":try{!function(t,s,n){var i=t;function e(){var e=Es(t);if(null===e)throw new S(S.Errors.BadTimeStamp,"Malformed timestamp: "+i);return t=t.replace(/^[^\sa-zA-Z-]+/,""),e}function r(){t=t.replace(/^\s+/,"")}if(r(),s.startTime=e(),r(),"--\x3e"!==t.substr(0,3))throw new S(S.Errors.BadTimeStamp,"Malformed time stamp (time stamps must be separated by '--\x3e'): "+i);t=t.substr(3),r(),s.endTime=e(),r();var a=t,o=new Ss;xs(a,function(e,t){switch(e){case"region":for(var s=n.length-1;0<=s;s--)if(n[s].id===t){o.set(e,n[s].region);break}break;case"vertical":o.alt(e,t,["rl","lr"]);break;case"line":var i=t.split(","),r=i[0];o.integer(e,r),o.percent(e,r)&&o.set("snapToLines",!1),o.alt(e,r,["auto"]),2===i.length&&o.alt("lineAlign",i[1],["start","center","end"]);break;case"position":i=t.split(","),o.percent(e,i[0]),2===i.length&&o.alt("positionAlign",i[1],["start","center","end"]);break;case"size":o.percent(e,t);break;case"align":o.alt(e,t,["start","center","end","left","right"])}},/:/,/\s/),s.region=o.get("region",null),s.vertical=o.get("vertical","");try{s.line=o.get("line","auto")}catch(e){}s.lineAlign=o.get("lineAlign","start"),s.snapToLines=o.get("snapToLines",!0),s.size=o.get("size",100);try{s.align=o.get("align","center")}catch(e){s.align=o.get("align","middle")}try{s.position=o.get("position","auto")}catch(e){s.position=o.get("position",{start:0,left:0,center:50,middle:50,end:100,right:100},s.align)}s.positionAlign=o.get("positionAlign",{start:"start",left:"start",center:"center",middle:"center",end:"end",right:"end"},s.align)}(r,i.cue,i.regionList)}catch(e){i.reportOrThrowError(e),i.cue=null,i.state="BADCUE";continue}i.state="CUETEXT";continue;case"CUETEXT":var o=-1!==r.indexOf("--\x3e");if(!r||o&&(a=!0)){i.oncue&&i.oncue(i.cue),i.cue=null,i.state="ID";continue}i.cue.text&&(i.cue.text+="\n"),i.cue.text+=r.replace(/\u2028/g,"\n").replace(/u2029/g,"\n");continue;case"BADCUE":r||(i.state="ID");continue}}}catch(e){i.reportOrThrowError(e),"CUETEXT"===i.state&&i.cue&&i.oncue&&i.oncue(i.cue),i.cue=null,i.state="INITIAL"===i.state?"BADWEBVTT":"BADCUE"}return this},flush:function(){var t=this;try{if(t.buffer+=t.decoder.decode(),!t.cue&&"HEADER"!==t.state||(t.buffer+="\n\n",t.parse()),"INITIAL"===t.state)throw new S(S.Errors.BadSignature)}catch(e){t.reportOrThrowError(e)}return t.onflush&&t.onflush(),this}};var Hs=Bs,Vs={"":1,lr:1,rl:1},$s={start:1,center:1,end:1,left:1,right:1,auto:1,"line-left":1,"line-right":1};function zs(e){return"string"==typeof e&&!!$s[e.toLowerCase()]&&e.toLowerCase()}function Us(e,t,s){this.hasBeenReset=!1;var i="",r=!1,n=e,a=t,o=s,l=null,h="",c=!0,u="auto",d="start",p="auto",g="auto",m=100,_="center";Object.defineProperties(this,{id:{enumerable:!0,get:function(){return i},set:function(e){i=""+e}},pauseOnExit:{enumerable:!0,get:function(){return r},set:function(e){r=!!e}},startTime:{enumerable:!0,get:function(){return n},set:function(e){if("number"!=typeof e)throw new TypeError("Start time must be set to a number.");n=e,this.hasBeenReset=!0}},endTime:{enumerable:!0,get:function(){return a},set:function(e){if("number"!=typeof e)throw new TypeError("End time must be set to a number.");a=e,this.hasBeenReset=!0}},text:{enumerable:!0,get:function(){return o},set:function(e){o=""+e,this.hasBeenReset=!0}},region:{enumerable:!0,get:function(){return l},set:function(e){l=e,this.hasBeenReset=!0}},vertical:{enumerable:!0,get:function(){return h},set:function(e){e="string"==typeof(e=e)&&!!Vs[e.toLowerCase()]&&e.toLowerCase();if(!1===e)throw new SyntaxError("Vertical: an invalid or illegal direction string was specified.");h=e,this.hasBeenReset=!0}},snapToLines:{enumerable:!0,get:function(){return c},set:function(e){c=!!e,this.hasBeenReset=!0}},line:{enumerable:!0,get:function(){return u},set:function(e){if("number"!=typeof e&&"auto"!==e)throw new SyntaxError("Line: an invalid number or illegal string was specified.");u=e,this.hasBeenReset=!0}},lineAlign:{enumerable:!0,get:function(){return d},set:function(e){e=zs(e);e&&(d=e,this.hasBeenReset=!0)}},position:{enumerable:!0,get:function(){return p},set:function(e){if(e<0||100<e)throw new Error("Position must be between 0 and 100.");p=e,this.hasBeenReset=!0}},positionAlign:{enumerable:!0,get:function(){return g},set:function(e){e=zs(e);e&&(g=e,this.hasBeenReset=!0)}},size:{enumerable:!0,get:function(){return m},set:function(e){if(e<0||100<e)throw new Error("Size must be between 0 and 100.");m=e,this.hasBeenReset=!0}},align:{enumerable:!0,get:function(){return _},set:function(e){e=zs(e);if(!e)throw new SyntaxError("align: an invalid or illegal alignment string was specified.");_=e,this.hasBeenReset=!0}}}),this.displayState=void 0}Us.prototype.getCueAsHTML=function(){return WebVTT.convertCueToDOMTree(window,this.text)};var Ks=Us,Ws={"":!0,up:!0};function qs(e){return"number"==typeof e&&0<=e&&e<=100}function Xs(){var t=100,s=3,i=0,r=100,n=0,a=100,o="";Object.defineProperties(this,{width:{enumerable:!0,get:function(){return t},set:function(e){if(!qs(e))throw new Error("Width must be between 0 and 100.");t=e}},lines:{enumerable:!0,get:function(){return s},set:function(e){if("number"!=typeof e)throw new TypeError("Lines must be set to a number.");s=e}},regionAnchorY:{enumerable:!0,get:function(){return r},set:function(e){if(!qs(e))throw new Error("RegionAnchorX must be between 0 and 100.");r=e}},regionAnchorX:{enumerable:!0,get:function(){return i},set:function(e){if(!qs(e))throw new Error("RegionAnchorY must be between 0 and 100.");i=e}},viewportAnchorY:{enumerable:!0,get:function(){return a},set:function(e){if(!qs(e))throw new Error("ViewportAnchorY must be between 0 and 100.");a=e}},viewportAnchorX:{enumerable:!0,get:function(){return n},set:function(e){if(!qs(e))throw new Error("ViewportAnchorX must be between 0 and 100.");n=e}},scroll:{enumerable:!0,get:function(){return o},set:function(e){e="string"==typeof(e=e)&&!!Ws[e.toLowerCase()]&&e.toLowerCase();!1!==e&&(o=e)}}})}var Gs=St(function(e){var e=e.exports={WebVTT:Hs,VTTCue:Ks,VTTRegion:Xs},t=(C.vttjs=e,C.WebVTT=e.WebVTT,e.VTTCue),s=e.VTTRegion,i=C.VTTCue,r=C.VTTRegion;e.shim=function(){C.VTTCue=t,C.VTTRegion=s},e.restore=function(){C.VTTCue=i,C.VTTRegion=r},C.VTTCue||e.shim()});Gs.WebVTT,Gs.VTTCue,Gs.VTTRegion;class P extends b{constructor(t={},e=function(){}){t.reportTouchActivity=!1,super(null,t,e),this.onDurationChange_=e=>this.onDurationChange(e),this.trackProgress_=e=>this.trackProgress(e),this.trackCurrentTime_=e=>this.trackCurrentTime(e),this.stopTrackingCurrentTime_=e=>this.stopTrackingCurrentTime(e),this.disposeSourceHandler_=e=>this.disposeSourceHandler(e),this.queuedHanders_=new Set,this.hasStarted_=!1,this.on("playing",function(){this.hasStarted_=!0}),this.on("loadstart",function(){this.hasStarted_=!1}),E.names.forEach(e=>{e=E[e];t&&t[e.getterName]&&(this[e.privateName]=t[e.getterName])}),this.featuresProgressEvents||this.manualProgressOn(),this.featuresTimeupdateEvents||this.manualTimeUpdatesOn(),["Text","Audio","Video"].forEach(e=>{!1===t[`native${e}Tracks`]&&(this[`featuresNative${e}Tracks`]=!1)}),!1===t.nativeCaptions||!1===t.nativeTextTracks?this.featuresNativeTextTracks=!1:!0!==t.nativeCaptions&&!0!==t.nativeTextTracks||(this.featuresNativeTextTracks=!0),this.featuresNativeTextTracks||this.emulateTextTracks(),this.preloadTextTracks=!1!==t.preloadTextTracks,this.autoRemoteTextTracks_=new E.text.ListClass,this.initTrackListeners(),t.nativeControlsForTouch||this.emitTapEvents(),this.constructor&&(this.name_=this.constructor.name||"Unknown Tech")}triggerSourceset(e){this.isReady_||this.one("ready",()=>this.setTimeout(()=>this.triggerSourceset(e),1)),this.trigger({src:e,type:"sourceset"})}manualProgressOn(){this.on("durationchange",this.onDurationChange_),this.manualProgress=!0,this.one("ready",this.trackProgress_)}manualProgressOff(){this.manualProgress=!1,this.stopTrackingProgress(),this.off("durationchange",this.onDurationChange_)}trackProgress(e){this.stopTrackingProgress(),this.progressInterval=this.setInterval(v(this,function(){var e=this.bufferedPercent();this.bufferedPercent_!==e&&this.trigger("progress"),1===(this.bufferedPercent_=e)&&this.stopTrackingProgress()}),500)}onDurationChange(e){this.duration_=this.duration()}buffered(){return T(0,0)}bufferedPercent(){return Nt(this.buffered(),this.duration_)}stopTrackingProgress(){this.clearInterval(this.progressInterval)}manualTimeUpdatesOn(){this.manualTimeUpdates=!0,this.on("play",this.trackCurrentTime_),this.on("pause",this.stopTrackingCurrentTime_)}manualTimeUpdatesOff(){this.manualTimeUpdates=!1,this.stopTrackingCurrentTime(),this.off("play",this.trackCurrentTime_),this.off("pause",this.stopTrackingCurrentTime_)}trackCurrentTime(){this.currentTimeInterval&&this.stopTrackingCurrentTime(),this.currentTimeInterval=this.setInterval(function(){this.trigger({type:"timeupdate",target:this,manuallyTriggered:!0})},250)}stopTrackingCurrentTime(){this.clearInterval(this.currentTimeInterval),this.trigger({type:"timeupdate",target:this,manuallyTriggered:!0})}dispose(){this.clearTracks(w.names),this.manualProgress&&this.manualProgressOff(),this.manualTimeUpdates&&this.manualTimeUpdatesOff(),super.dispose()}clearTracks(e){(e=[].concat(e)).forEach(e=>{var t=this[e+"Tracks"]()||[];let s=t.length;for(;s--;){var i=t[s];"text"===e&&this.removeRemoteTextTrack(i),t.removeTrack(i)}})}cleanupAutoTextTracks(){var e=this.autoRemoteTextTracks_||[];let t=e.length;for(;t--;){var s=e[t];this.removeRemoteTextTrack(s)}}reset(){}crossOrigin(){}setCrossOrigin(){}error(e){return void 0!==e&&(this.error_=new i(e),this.trigger("error")),this.error_}played(){return this.hasStarted_?T(0,0):T()}play(){}setScrubbing(e){}scrubbing(){}setCurrentTime(e){this.manualTimeUpdates&&this.trigger({type:"timeupdate",target:this,manuallyTriggered:!0})}initTrackListeners(){w.names.forEach(e=>{var t=w[e];const s=()=>{this.trigger(e+"trackchange")},i=this[t.getterName]();i.addEventListener("removetrack",s),i.addEventListener("addtrack",s),this.on("dispose",()=>{i.removeEventListener("removetrack",s),i.removeEventListener("addtrack",s)})})}addWebVttScript_(){if(!window.WebVTT)if(document.body.contains(this.el()))if(!this.options_["vtt.js"]&&G(Gs)&&0<Object.keys(Gs).length)this.trigger("vttjsloaded");else{const e=document.createElement("script");e.src=this.options_["vtt.js"]||"https://vjs.zencdn.net/vttjs/0.14.1/vtt.min.js",e.onload=()=>{this.trigger("vttjsloaded")},e.onerror=()=>{this.trigger("vttjserror")},this.on("dispose",()=>{e.onload=null,e.onerror=null}),window.WebVTT=!0,this.el().parentNode.appendChild(e)}else this.ready(this.addWebVttScript_)}emulateTextTracks(){const s=this.textTracks(),e=this.remoteTextTracks(),t=e=>s.addTrack(e.track),i=e=>s.removeTrack(e.track),r=(e.on("addtrack",t),e.on("removetrack",i),this.addWebVttScript_(),()=>this.trigger("texttrackchange")),n=()=>{r();for(let e=0;e<s.length;e++){var t=s[e];t.removeEventListener("cuechange",r),"showing"===t.mode&&t.addEventListener("cuechange",r)}};n(),s.addEventListener("change",n),s.addEventListener("addtrack",n),s.addEventListener("removetrack",n),this.on("dispose",function(){e.off("addtrack",t),e.off("removetrack",i),s.removeEventListener("change",n),s.removeEventListener("addtrack",n),s.removeEventListener("removetrack",n);for(let e=0;e<s.length;e++)s[e].removeEventListener("cuechange",r)})}addTextTrack(e,t,s){if(e)return e=e,t=t,s=s,r={},n=(i=this).textTracks(),r.kind=e,t&&(r.label=t),s&&(r.language=s),r.tech=i,e=new E.text.TrackClass(r),n.addTrack(e),e;throw new Error("TextTrack kind is required but was not provided");var i,r,n}createRemoteTextTrack(e){e=c(e,{tech:this});return new Ts.remoteTextEl.TrackClass(e)}addRemoteTextTrack(e={},t){const s=this.createRemoteTextTrack(e);return"boolean"!=typeof t&&(t=!1),this.remoteTextTrackEls().addTrackElement_(s),this.remoteTextTracks().addTrack(s.track),!1===t&&this.ready(()=>this.autoRemoteTextTracks_.addTrack(s.track)),s}removeRemoteTextTrack(e){var t=this.remoteTextTrackEls().getTrackElementByTrack_(e);this.remoteTextTrackEls().removeTrackElement_(t),this.remoteTextTracks().removeTrack(e),this.autoRemoteTextTracks_.removeTrack(e)}getVideoPlaybackQuality(){return{}}requestPictureInPicture(){return Promise.reject()}disablePictureInPicture(){return!0}setDisablePictureInPicture(){}requestVideoFrameCallback(e){const t=m++;return!this.isReady_||this.paused()?(this.queuedHanders_.add(t),this.one("playing",()=>{this.queuedHanders_.has(t)&&(this.queuedHanders_.delete(t),e())})):this.requestNamedAnimationFrame(t,e),t}cancelVideoFrameCallback(e){this.queuedHanders_.has(e)?this.queuedHanders_.delete(e):this.cancelNamedAnimationFrame(e)}setPoster(){}playsinline(){}setPlaysinline(){}overrideNativeAudioTracks(e){}overrideNativeVideoTracks(e){}canPlayType(e){return""}static canPlayType(e){return""}static canPlaySource(e,t){return P.canPlayType(e.type)}static isTech(e){return e.prototype instanceof P||e instanceof P||e===P}static registerTech(e,t){if(P.techs_||(P.techs_={}),!P.isTech(t))throw new Error(`Tech ${e} must be a Tech`);if(!P.canPlayType)throw new Error("Techs must have a static canPlayType method on them");if(P.canPlaySource)return e=y(e),P.techs_[e]=t,P.techs_[kt(e)]=t,"Tech"!==e&&P.defaultTechOrder_.push(e),t;throw new Error("Techs must have a static canPlaySource method on them")}static getTech(e){if(e)return P.techs_&&P.techs_[e]?P.techs_[e]:(e=y(e),window&&window.videojs&&window.videojs[e]?(h.warn(`The ${e} tech was added to the videojs object when it should be registered using videojs.registerTech(name, tech)`),window.videojs[e]):void 0)}}E.names.forEach(function(e){const t=E[e];P.prototype[t.getterName]=function(){return this[t.privateName]=this[t.privateName]||new t.ListClass,this[t.privateName]}}),P.prototype.featuresVolumeControl=!0,P.prototype.featuresMuteControl=!0,P.prototype.featuresFullscreenResize=!1,P.prototype.featuresPlaybackRate=!1,P.prototype.featuresProgressEvents=!1,P.prototype.featuresSourceset=!1,P.prototype.featuresTimeupdateEvents=!1,P.prototype.featuresNativeTextTracks=!1,P.prototype.featuresVideoFrameCallback=!1,P.withSourceHandlers=function(r){r.registerSourceHandler=function(e,t){let s=r.sourceHandlers;s=s||(r.sourceHandlers=[]),void 0===t&&(t=s.length),s.splice(t,0,e)},r.canPlayType=function(t){var s,i=r.sourceHandlers||[];for(let e=0;e<i.length;e++)if(s=i[e].canPlayType(t))return s;return""},r.selectSourceHandler=function(t,s){var i=r.sourceHandlers||[];for(let e=0;e<i.length;e++)if(i[e].canHandleSource(t,s))return i[e];return null},r.canPlaySource=function(e,t){var s=r.selectSourceHandler(e,t);return s?s.canHandleSource(e,t):""};["seekable","seeking","duration"].forEach(function(e){const t=this[e];"function"==typeof t&&(this[e]=function(){return this.sourceHandler_&&this.sourceHandler_[e]?this.sourceHandler_[e].apply(this.sourceHandler_,arguments):t.apply(this,arguments)})},r.prototype),r.prototype.setSource=function(e){let t=r.selectSourceHandler(e,this.options_);t||(r.nativeSourceHandler?t=r.nativeSourceHandler:h.error("No source handler found for the current source.")),this.disposeSourceHandler(),this.off("dispose",this.disposeSourceHandler_),t!==r.nativeSourceHandler&&(this.currentSource_=e),this.sourceHandler_=t.handleSource(e,this,this.options_),this.one("dispose",this.disposeSourceHandler_)},r.prototype.disposeSourceHandler=function(){this.currentSource_&&(this.clearTracks(["audio","video"]),this.currentSource_=null),this.cleanupAutoTextTracks(),this.sourceHandler_&&(this.sourceHandler_.dispose&&this.sourceHandler_.dispose(),this.sourceHandler_=null)}},b.registerComponent("Tech",P),P.registerTech("Tech",P),P.defaultTechOrder_=[];const Ys={},Qs={},Js={};function Zs(e,t,s){e.setTimeout(()=>function s(i={},e=[],r,n,a=[],o=!1){const[t,...l]=e;if("string"==typeof t)s(i,Ys[t],r,n,a,o);else if(t){const h=ni(n,t);if(!h.setSource)return a.push(h),s(i,l,r,n,a,o);h.setSource(Object.assign({},i),function(e,t){if(e)return s(i,l,r,n,a,o);a.push(h),s(t,i.type===t.type?l:Ys[t.type],r,n,a,o)})}else l.length?s(i,l,r,n,a,o):o?r(i,a):s(i,Ys["*"],r,n,a,!0)}(t,Ys[t.type],s,e),1)}function ei(e,t,s,i=null){var r="call"+y(s),r=e.reduce(ri(r),i),i=r===Js,t=i?null:t[s](r),n=e,a=s,o=t,l=i;for(let e=n.length-1;0<=e;e--){var h=n[e];h[a]&&h[a](l,o)}return t}const ti={buffered:1,currentTime:1,duration:1,muted:1,played:1,paused:1,seekable:1,volume:1,ended:1},si={setCurrentTime:1,setMuted:1,setVolume:1},ii={play:1,pause:1};function ri(s){return(e,t)=>e===Js?Js:t[s]?t[s](e):e}function ni(e,t){var s=Qs[e.id()];let i=null;if(null==s)i=t(e),Qs[e.id()]=[[t,i]];else{for(let e=0;e<s.length;e++){var[r,n]=s[e];r===t&&(i=n)}null===i&&(i=t(e),s.push([t,i]))}return i}function ai(e){if(Array.isArray(e)){let t=[];e.forEach(function(e){e=ai(e),Array.isArray(e)?t=t.concat(e):n(e)&&t.push(e)}),e=t}else e="string"==typeof e&&e.trim()?[hi({src:e})]:n(e)&&"string"==typeof e.src&&e.src&&e.src.trim()?[hi(e)]:[];return e}const oi={opus:"video/ogg",ogv:"video/ogg",mp4:"video/mp4",mov:"video/mp4",m4v:"video/mp4",mkv:"video/x-matroska",m4a:"audio/mp4",mp3:"audio/mpeg",aac:"audio/aac",caf:"audio/x-caf",flac:"audio/flac",oga:"audio/ogg",wav:"audio/wav",m3u8:"application/x-mpegURL",mpd:"application/dash+xml",jpg:"image/jpeg",jpeg:"image/jpeg",gif:"image/gif",png:"image/png",svg:"image/svg+xml",webp:"image/webp"},li=function(e=""){e=ss(e);return oi[e.toLowerCase()]||""};function hi(e){var t;return e.type||(t=li(e.src))&&(e.type=t),e}class ci extends b{constructor(i,e,t){if(super(i,c({createEl:!1},e),t),e.playerOptions.sources&&0!==e.playerOptions.sources.length)i.src(e.playerOptions.sources);else for(let t=0,s=e.playerOptions.techOrder;t<s.length;t++){var r=y(s[t]);let e=P.getTech(r);if((e=r?e:b.getComponent(r))&&e.isSupported()){i.loadTech_(r);break}}}}b.registerComponent("MediaLoader",ci);class ui extends b{constructor(e,t){super(e,t),this.options_.controlText&&this.controlText(this.options_.controlText),this.handleMouseOver_=e=>this.handleMouseOver(e),this.handleMouseOut_=e=>this.handleMouseOut(e),this.handleClick_=e=>this.handleClick(e),this.handleKeyDown_=e=>this.handleKeyDown(e),this.emitTapEvents(),this.enable()}createEl(e="div",t={},s={}){t=Object.assign({className:this.buildCSSClass(),tabIndex:0},t),"button"===e&&h.error(`Creating a ClickableComponent with an HTML element of ${e} is not supported; use a Button instead.`),s=Object.assign({role:"button"},s),this.tabIndex_=t.tabIndex;e=p(e,t,s);return e.appendChild(p("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),this.createControlTextEl(e),e}dispose(){this.controlTextEl_=null,super.dispose()}createControlTextEl(e){return this.controlTextEl_=p("span",{className:"vjs-control-text"},{"aria-live":"polite"}),e&&e.appendChild(this.controlTextEl_),this.controlText(this.controlText_,e),this.controlTextEl_}controlText(e,t=this.el()){if(void 0===e)return this.controlText_||"Need Text";var s=this.localize(e);this.controlText_=e,ye(this.controlTextEl_,s),this.nonIconControl||this.player_.options_.noUITitleAttributes||t.setAttribute("title",s)}buildCSSClass(){return"vjs-control vjs-button "+super.buildCSSClass()}enable(){this.enabled_||(this.enabled_=!0,this.removeClass("vjs-disabled"),this.el_.setAttribute("aria-disabled","false"),"undefined"!=typeof this.tabIndex_&&this.el_.setAttribute("tabIndex",this.tabIndex_),this.on(["tap","click"],this.handleClick_),this.on("keydown",this.handleKeyDown_))}disable(){this.enabled_=!1,this.addClass("vjs-disabled"),this.el_.setAttribute("aria-disabled","true"),"undefined"!=typeof this.tabIndex_&&this.el_.removeAttribute("tabIndex"),this.off("mouseover",this.handleMouseOver_),this.off("mouseout",this.handleMouseOut_),this.off(["tap","click"],this.handleClick_),this.off("keydown",this.handleKeyDown_)}handleLanguagechange(){this.controlText(this.controlText_)}handleClick(e){this.options_.clickHandler&&this.options_.clickHandler.call(this,arguments)}handleKeyDown(e){a.isEventKey(e,"Space")||a.isEventKey(e,"Enter")?(e.preventDefault(),e.stopPropagation(),this.trigger("click")):super.handleKeyDown(e)}}b.registerComponent("ClickableComponent",ui);class di extends ui{constructor(e,t){super(e,t),this.update(),this.update_=e=>this.update(e),e.on("posterchange",this.update_)}dispose(){this.player().off("posterchange",this.update_),super.dispose()}createEl(){return p("div",{className:"vjs-poster"})}crossOrigin(e){if("undefined"==typeof e)return this.$("img")?this.$("img").crossOrigin:this.player_.tech_&&this.player_.tech_.isReady_?this.player_.crossOrigin():this.player_.options_.crossOrigin||this.player_.options_.crossorigin||null;null!==e&&"anonymous"!==e&&"use-credentials"!==e?this.player_.log.warn(`crossOrigin must be null,  "anonymous" or "use-credentials", given "${e}"`):this.$("img")&&(this.$("img").crossOrigin=e)}update(e){var t=this.player().poster();this.setSrc(t),t?this.show():this.hide()}setSrc(e){e?(this.$("img")||this.el_.appendChild(p("picture",{className:"vjs-poster",tabIndex:-1},{},p("img",{loading:"lazy",crossOrigin:this.crossOrigin()},{alt:""}))),this.$("img").src=e):this.el_.textContent=""}handleClick(e){this.player_.controls()&&(this.player_.tech(!0)&&this.player_.tech(!0).focus(),this.player_.paused()?k(this.player_.play()):this.player_.pause())}}di.prototype.crossorigin=di.prototype.crossOrigin,b.registerComponent("PosterImage",di);const pi={monospace:"monospace",sansSerif:"sans-serif",serif:"serif",monospaceSansSerif:'"Andale Mono", "Lucida Console", monospace',monospaceSerif:'"Courier New", monospace',proportionalSansSerif:"sans-serif",proportionalSerif:"serif",casual:'"Comic Sans MS", Impact, fantasy',script:'"Monotype Corsiva", cursive',smallcaps:'"Andale Mono", "Lucida Console", monospace, sans-serif'};function gi(e,t){let s;if(4===e.length)s=e[1]+e[1]+e[2]+e[2]+e[3]+e[3];else{if(7!==e.length)throw new Error("Invalid color code provided, "+e+"; must be formatted as e.g. #f0e or #f604e2.");s=e.slice(1)}return"rgba("+parseInt(s.slice(0,2),16)+","+parseInt(s.slice(2,4),16)+","+parseInt(s.slice(4,6),16)+","+t+")"}function mi(e,t,s){try{e.style[t]=s}catch(e){}}class _i extends b{constructor(i,e,t){super(i,e,t);const r=e=>this.updateDisplay(e);i.on("loadstart",e=>this.toggleDisplay(e)),i.on("texttrackchange",r),i.on("loadedmetadata",e=>this.preselectTrack(e)),i.ready(v(this,function(){if(i.tech_&&i.tech_.featuresNativeTextTracks)this.hide();else{i.on("fullscreenchange",r),i.on("playerresize",r);const e=window.screen.orientation||window,s=window.screen.orientation?"change":"orientationchange";e.addEventListener(s,r),i.on("dispose",()=>e.removeEventListener(s,r));var t=this.options_.playerOptions.tracks||[];for(let e=0;e<t.length;e++)this.player_.addRemoteTextTrack(t[e],!0);this.preselectTrack()}}))}preselectTrack(){var t={captions:1,subtitles:1},s=this.player_.textTracks(),i=this.player_.cache_.selectedLanguage;let r,n,a;for(let e=0;e<s.length;e++){var o=s[e];i&&i.enabled&&i.language&&i.language===o.language&&o.kind in t?a=o.kind!==i.kind&&a||o:i&&!i.enabled?(a=null,r=null,n=null):o.default&&("descriptions"!==o.kind||r?o.kind in t&&!n&&(n=o):r=o)}a?a.mode="showing":n?n.mode="showing":r&&(r.mode="showing")}toggleDisplay(){this.player_.tech_&&this.player_.tech_.featuresNativeTextTracks?this.hide():this.show()}createEl(){return super.createEl("div",{className:"vjs-text-track-display"},{translate:"yes","aria-live":"off","aria-atomic":"true"})}clearDisplay(){"function"==typeof window.WebVTT&&window.WebVTT.processCues(window,[],this.el_)}updateDisplay(){var i=this.player_.textTracks(),e=this.options_.allowMultipleShowingTracks;if(this.clearDisplay(),e){var t=[];for(let e=0;e<i.length;++e){var s=i[e];"showing"===s.mode&&t.push(s)}this.updateForTrack(t)}else{let e=null,t=null,s=i.length;for(;s--;){var r=i[s];"showing"===r.mode&&("descriptions"===r.kind?e=r:t=r)}t?("off"!==this.getAttribute("aria-live")&&this.setAttribute("aria-live","off"),this.updateForTrack(t)):e&&("assertive"!==this.getAttribute("aria-live")&&this.setAttribute("aria-live","assertive"),this.updateForTrack(e))}}updateDisplayState(e){var t=this.player_.textTrackSettings.getValues(),s=e.activeCues;let i=s.length;for(;i--;){var r,n=s[i];n&&(n=n.displayState,t.color&&(n.firstChild.style.color=t.color),t.textOpacity&&mi(n.firstChild,"color",gi(t.color||"#fff",t.textOpacity)),t.backgroundColor&&(n.firstChild.style.backgroundColor=t.backgroundColor),t.backgroundOpacity&&mi(n.firstChild,"backgroundColor",gi(t.backgroundColor||"#000",t.backgroundOpacity)),t.windowColor&&(t.windowOpacity?mi(n,"backgroundColor",gi(t.windowColor,t.windowOpacity)):n.style.backgroundColor=t.windowColor),t.edgeStyle&&("dropshadow"===t.edgeStyle?n.firstChild.style.textShadow="2px 2px 3px #222, 2px 2px 4px #222, 2px 2px 5px #222":"raised"===t.edgeStyle?n.firstChild.style.textShadow="1px 1px #222, 2px 2px #222, 3px 3px #222":"depressed"===t.edgeStyle?n.firstChild.style.textShadow="1px 1px #ccc, 0 1px #ccc, -1px -1px #222, 0 -1px #222":"uniform"===t.edgeStyle&&(n.firstChild.style.textShadow="0 0 4px #222, 0 0 4px #222, 0 0 4px #222, 0 0 4px #222")),t.fontPercent&&1!==t.fontPercent&&(r=window.parseFloat(n.style.fontSize),n.style.fontSize=r*t.fontPercent+"px",n.style.height="auto",n.style.top="auto"),t.fontFamily)&&"default"!==t.fontFamily&&("small-caps"===t.fontFamily?n.firstChild.style.fontVariant="small-caps":n.firstChild.style.fontFamily=pi[t.fontFamily])}}updateForTrack(s){if(Array.isArray(s)||(s=[s]),"function"==typeof window.WebVTT&&!s.every(e=>!e.activeCues)){var t=[];for(let e=0;e<s.length;++e){var i=s[e];for(let e=0;e<i.activeCues.length;++e)t.push(i.activeCues[e])}window.WebVTT.processCues(window,t,this.el_);for(let t=0;t<s.length;++t){var r=s[t];for(let e=0;e<r.activeCues.length;++e){var n=r.activeCues[e].displayState;ke(n,"vjs-text-track-cue","vjs-text-track-cue-"+(r.language||t)),r.language&&Pe(n,"lang",r.language)}this.player_.textTrackSettings&&this.updateDisplayState(r)}}}}b.registerComponent("TextTrackDisplay",_i);class fi extends b{createEl(){var e=this.player_.isAudio(),e=this.localize(e?"Audio Player":"Video Player"),e=p("span",{className:"vjs-control-text",textContent:this.localize("{1} is loading.",[e])}),t=super.createEl("div",{className:"vjs-loading-spinner",dir:"ltr"});return t.appendChild(e),t}handleLanguagechange(){this.$(".vjs-control-text").textContent=this.localize("{1} is loading.",[this.player_.isAudio()?"Audio Player":"Video Player"])}}b.registerComponent("LoadingSpinner",fi);class j extends ui{createEl(e,t={},s={}){t=p("button",t=Object.assign({className:this.buildCSSClass()},t),s=Object.assign({type:"button"},s));return t.appendChild(p("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),this.createControlTextEl(t),t}addChild(e,t={}){var s=this.constructor.name;return h.warn(`Adding an actionable (user controllable) child to a Button (${s}) is not supported; use a ClickableComponent instead.`),b.prototype.addChild.call(this,e,t)}enable(){super.enable(),this.el_.removeAttribute("disabled")}disable(){super.disable(),this.el_.setAttribute("disabled","disabled")}handleKeyDown(e){a.isEventKey(e,"Space")||a.isEventKey(e,"Enter")?e.stopPropagation():super.handleKeyDown(e)}}b.registerComponent("Button",j);class vi extends j{constructor(e,t){super(e,t),this.mouseused_=!1,this.on("mousedown",e=>this.handleMouseDown(e))}buildCSSClass(){return"vjs-big-play-button"}handleClick(e){var t=this.player_.play();if(this.mouseused_&&e.clientX&&e.clientY)k(t),this.player_.tech(!0)&&this.player_.tech(!0).focus();else{var e=this.player_.getChild("controlBar");const s=e&&e.getChild("playToggle");s?(e=()=>s.focus(),Ft(t)?t.then(e,()=>{}):this.setTimeout(e,1)):this.player_.tech(!0).focus()}}handleKeyDown(e){this.mouseused_=!1,super.handleKeyDown(e)}handleMouseDown(e){this.mouseused_=!0}}vi.prototype.controlText_="Play Video",b.registerComponent("BigPlayButton",vi);j;b.registerComponent("CloseButton",class extends j{constructor(e,t){super(e,t),this.controlText(t&&t.controlText||this.localize("Close"))}buildCSSClass(){return"vjs-close-button "+super.buildCSSClass()}handleClick(e){this.trigger({type:"close",bubbles:!1})}handleKeyDown(e){a.isEventKey(e,"Esc")?(e.preventDefault(),e.stopPropagation(),this.trigger("click")):super.handleKeyDown(e)}});class yi extends j{constructor(e,t={}){super(e,t),t.replay=void 0===t.replay||t.replay,this.on(e,"play",e=>this.handlePlay(e)),this.on(e,"pause",e=>this.handlePause(e)),t.replay&&this.on(e,"ended",e=>this.handleEnded(e))}buildCSSClass(){return"vjs-play-control "+super.buildCSSClass()}handleClick(e){this.player_.paused()?k(this.player_.play()):this.player_.pause()}handleSeeked(e){this.removeClass("vjs-ended"),this.player_.paused()?this.handlePause(e):this.handlePlay(e)}handlePlay(e){this.removeClass("vjs-ended","vjs-paused"),this.addClass("vjs-playing"),this.controlText("Pause")}handlePause(e){this.removeClass("vjs-playing"),this.addClass("vjs-paused"),this.controlText("Play")}handleEnded(e){this.removeClass("vjs-playing"),this.addClass("vjs-ended"),this.controlText("Replay"),this.one(this.player_,"seeked",e=>this.handleSeeked(e))}}yi.prototype.controlText_="Play",b.registerComponent("PlayToggle",yi);class bi extends b{constructor(e,t){super(e,t),this.on(e,["timeupdate","ended"],e=>this.updateContent(e)),this.updateTextNode_()}createEl(){var e=this.buildCSSClass(),t=super.createEl("div",{className:e+" vjs-time-control vjs-control"}),s=p("span",{className:"vjs-control-text",textContent:this.localize(this.labelText_)+" "},{role:"presentation"});return t.appendChild(s),this.contentEl_=p("span",{className:e+"-display"},{role:"presentation"}),t.appendChild(this.contentEl_),t}dispose(){this.contentEl_=null,this.textNode_=null,super.dispose()}updateTextNode_(e=0){e=Mt(e),this.formattedTime_!==e&&(this.formattedTime_=e,this.requestNamedAnimationFrame("TimeDisplay#updateTextNode_",()=>{if(this.contentEl_){let e=this.textNode_;e&&this.contentEl_.firstChild!==e&&(e=null,h.warn("TimeDisplay#updateTextnode_: Prevented replacement of text node element since it was no longer a child of this node. Appending a new node instead.")),this.textNode_=document.createTextNode(this.formattedTime_),this.textNode_&&(e?this.contentEl_.replaceChild(this.textNode_,e):this.contentEl_.appendChild(this.textNode_))}}))}updateContent(e){}}bi.prototype.labelText_="Time",bi.prototype.controlText_="Time",b.registerComponent("TimeDisplay",bi);class Ti extends bi{buildCSSClass(){return"vjs-current-time"}updateContent(e){let t;t=this.player_.ended()?this.player_.duration():this.player_.scrubbing()?this.player_.getCache().currentTime:this.player_.currentTime(),this.updateTextNode_(t)}}Ti.prototype.labelText_="Current Time",Ti.prototype.controlText_="Current Time",b.registerComponent("CurrentTimeDisplay",Ti);class ki extends bi{constructor(e,t){super(e,t);t=e=>this.updateContent(e);this.on(e,"durationchange",t),this.on(e,"loadstart",t),this.on(e,"loadedmetadata",t)}buildCSSClass(){return"vjs-duration"}updateContent(e){var t=this.player_.duration();this.updateTextNode_(t)}}ki.prototype.labelText_="Duration",ki.prototype.controlText_="Duration",b.registerComponent("DurationDisplay",ki);class Ci extends b{createEl(){var e=super.createEl("div",{className:"vjs-time-control vjs-time-divider"},{"aria-hidden":!0}),t=super.createEl("div"),s=super.createEl("span",{textContent:"/"});return t.appendChild(s),e.appendChild(t),e}}b.registerComponent("TimeDivider",Ci);class wi extends bi{constructor(e,t){super(e,t),this.on(e,"durationchange",e=>this.updateContent(e))}buildCSSClass(){return"vjs-remaining-time"}createEl(){var e=super.createEl();return!1!==this.options_.displayNegative&&e.insertBefore(p("span",{},{"aria-hidden":!0},"-"),this.contentEl_),e}updateContent(e){if("number"==typeof this.player_.duration()){let e;e=this.player_.ended()?0:this.player_.remainingTimeDisplay?this.player_.remainingTimeDisplay():this.player_.remainingTime(),this.updateTextNode_(e)}}}wi.prototype.labelText_="Remaining Time",wi.prototype.controlText_="Remaining Time",b.registerComponent("RemainingTimeDisplay",wi);class Ei extends b{constructor(e,t){super(e,t),this.updateShowing(),this.on(this.player(),"durationchange",e=>this.updateShowing(e))}createEl(){var e=super.createEl("div",{className:"vjs-live-control vjs-control"});return this.contentEl_=p("div",{className:"vjs-live-display"},{"aria-live":"off"}),this.contentEl_.appendChild(p("span",{className:"vjs-control-text",textContent:this.localize("Stream Type")+" "})),this.contentEl_.appendChild(document.createTextNode(this.localize("LIVE"))),e.appendChild(this.contentEl_),e}dispose(){this.contentEl_=null,super.dispose()}updateShowing(e){this.player().duration()===1/0?this.show():this.hide()}}b.registerComponent("LiveDisplay",Ei);class Si extends j{constructor(e,t){super(e,t),this.updateLiveEdgeStatus(),this.player_.liveTracker&&(this.updateLiveEdgeStatusHandler_=e=>this.updateLiveEdgeStatus(e),this.on(this.player_.liveTracker,"liveedgechange",this.updateLiveEdgeStatusHandler_))}createEl(){var e=super.createEl("button",{className:"vjs-seek-to-live-control vjs-control"});return this.textEl_=p("span",{className:"vjs-seek-to-live-text",textContent:this.localize("LIVE")},{"aria-hidden":"true"}),e.appendChild(this.textEl_),e}updateLiveEdgeStatus(){!this.player_.liveTracker||this.player_.liveTracker.atLiveEdge()?(this.setAttribute("aria-disabled",!0),this.addClass("vjs-at-live-edge"),this.controlText("Seek to live, currently playing live")):(this.setAttribute("aria-disabled",!1),this.removeClass("vjs-at-live-edge"),this.controlText("Seek to live, currently behind live"))}handleClick(){this.player_.liveTracker.seekToLiveEdge()}dispose(){this.player_.liveTracker&&this.off(this.player_.liveTracker,"liveedgechange",this.updateLiveEdgeStatusHandler_),this.textEl_=null,super.dispose()}}function xi(e,t,s){return e=Number(e),Math.min(s,Math.max(t,isNaN(e)?t:e))}Si.prototype.controlText_="Seek to live, currently playing live",b.registerComponent("SeekToLive",Si);t=Object.freeze({__proto__:null,clamp:xi});class Pi extends b{constructor(e,t){super(e,t),this.handleMouseDown_=e=>this.handleMouseDown(e),this.handleMouseUp_=e=>this.handleMouseUp(e),this.handleKeyDown_=e=>this.handleKeyDown(e),this.handleClick_=e=>this.handleClick(e),this.handleMouseMove_=e=>this.handleMouseMove(e),this.update_=e=>this.update(e),this.bar=this.getChild(this.options_.barName),this.vertical(!!this.options_.vertical),this.enable()}enabled(){return this.enabled_}enable(){this.enabled()||(this.on("mousedown",this.handleMouseDown_),this.on("touchstart",this.handleMouseDown_),this.on("keydown",this.handleKeyDown_),this.on("click",this.handleClick_),this.on(this.player_,"controlsvisible",this.update),this.playerEvent&&this.on(this.player_,this.playerEvent,this.update),this.removeClass("disabled"),this.setAttribute("tabindex",0),this.enabled_=!0)}disable(){var e;this.enabled()&&(e=this.bar.el_.ownerDocument,this.off("mousedown",this.handleMouseDown_),this.off("touchstart",this.handleMouseDown_),this.off("keydown",this.handleKeyDown_),this.off("click",this.handleClick_),this.off(this.player_,"controlsvisible",this.update_),this.off(e,"mousemove",this.handleMouseMove_),this.off(e,"mouseup",this.handleMouseUp_),this.off(e,"touchmove",this.handleMouseMove_),this.off(e,"touchend",this.handleMouseUp_),this.removeAttribute("tabindex"),this.addClass("disabled"),this.playerEvent&&this.off(this.player_,this.playerEvent,this.update),this.enabled_=!1)}createEl(e,t={},s={}){return t.className=t.className+" vjs-slider",t=Object.assign({tabIndex:0},t),s=Object.assign({role:"slider","aria-valuenow":0,"aria-valuemin":0,"aria-valuemax":100},s),super.createEl(e,t,s)}handleMouseDown(e){var t=this.bar.el_.ownerDocument;"mousedown"===e.type&&e.preventDefault(),"touchstart"!==e.type||u||e.preventDefault(),Ae(),this.addClass("vjs-sliding"),this.trigger("slideractive"),this.on(t,"mousemove",this.handleMouseMove_),this.on(t,"mouseup",this.handleMouseUp_),this.on(t,"touchmove",this.handleMouseMove_),this.on(t,"touchend",this.handleMouseUp_),this.handleMouseMove(e,!0)}handleMouseMove(e){}handleMouseUp(e){var t=this.bar.el_.ownerDocument;Ie(),this.removeClass("vjs-sliding"),this.trigger("sliderinactive"),this.off(t,"mousemove",this.handleMouseMove_),this.off(t,"mouseup",this.handleMouseUp_),this.off(t,"touchmove",this.handleMouseMove_),this.off(t,"touchend",this.handleMouseUp_),this.update()}update(){if(this.el_&&this.bar){const t=this.getProgress();return t!==this.progress_&&(this.progress_=t,this.requestNamedAnimationFrame("Slider#update",()=>{var e=this.vertical()?"height":"width";this.bar.el().style[e]=(100*t).toFixed(2)+"%"})),t}}getProgress(){return Number(xi(this.getPercent(),0,1).toFixed(4))}calculateDistance(e){e=Le(this.el_,e);return this.vertical()?e.y:e.x}handleKeyDown(e){a.isEventKey(e,"Left")||a.isEventKey(e,"Down")?(e.preventDefault(),e.stopPropagation(),this.stepBack()):a.isEventKey(e,"Right")||a.isEventKey(e,"Up")?(e.preventDefault(),e.stopPropagation(),this.stepForward()):super.handleKeyDown(e)}handleClick(e){e.stopPropagation(),e.preventDefault()}vertical(e){if(void 0===e)return this.vertical_||!1;this.vertical_=!!e,this.vertical_?this.addClass("vjs-slider-vertical"):this.addClass("vjs-slider-horizontal")}}b.registerComponent("Slider",Pi);const ji=(e,t)=>xi(e/t*100,0,100).toFixed(2)+"%";class Ai extends b{constructor(e,t){super(e,t),this.partEls_=[],this.on(e,"progress",e=>this.update(e))}createEl(){var e=super.createEl("div",{className:"vjs-load-progress"}),t=p("span",{className:"vjs-control-text"}),s=p("span",{textContent:this.localize("Loaded")}),i=document.createTextNode(": ");return this.percentageEl_=p("span",{className:"vjs-control-text-loaded-percentage",textContent:"0%"}),e.appendChild(t),t.appendChild(s),t.appendChild(i),t.appendChild(this.percentageEl_),e}dispose(){this.partEls_=null,this.percentageEl_=null,super.dispose()}update(e){this.requestNamedAnimationFrame("LoadProgressBar#update",()=>{var e=this.player_.liveTracker,s=this.player_.buffered(),e=e&&e.isLive()?e.seekableEnd():this.player_.duration(),i=this.player_.bufferedEnd(),r=this.partEls_,e=ji(i,e);this.percent_!==e&&(this.el_.style.width=e,ye(this.percentageEl_,e),this.percent_=e);for(let t=0;t<s.length;t++){var n=s.start(t),a=s.end(t);let e=r[t];e||(e=this.el_.appendChild(p()),r[t]=e),e.dataset.start===n&&e.dataset.end===a||(e.dataset.start=n,e.dataset.end=a,e.style.left=ji(n,i),e.style.width=ji(a-n,i))}for(let e=r.length;e>s.length;e--)this.el_.removeChild(r[e-1]);r.length=s.length})}}b.registerComponent("LoadProgressBar",Ai);class Ii extends b{constructor(e,t){super(e,t),this.update=r(v(this,this.update),30)}createEl(){return super.createEl("div",{className:"vjs-time-tooltip"},{"aria-hidden":"true"})}update(t,s,i){var r=Me(this.el_),n=Oe(this.player_.el()),s=t.width*s;if(n&&r){var a=t.left-n.left+s,s=t.width-s+(n.right-t.right);let e=r.width/2;a<e?e+=e-a:s<e&&(e=s),e<0?e=0:e>r.width&&(e=r.width),e=Math.round(e),this.el_.style.right=`-${e}px`,this.write(i)}}write(e){ye(this.el_,e)}updateTime(r,n,a,o){this.requestNamedAnimationFrame("TimeTooltip#updateTime",()=>{let e;var t,s,i=this.player_.duration();e=this.player_.liveTracker&&this.player_.liveTracker.isLive()?((s=(t=this.player_.liveTracker.liveWindow())-n*t)<1?"":"-")+Mt(s,t):Mt(a,i),this.update(r,n,e),o&&o()})}}b.registerComponent("TimeTooltip",Ii);class Oi extends b{constructor(e,t){super(e,t),this.update=r(v(this,this.update),30)}createEl(){return super.createEl("div",{className:"vjs-play-progress vjs-slider-bar"},{"aria-hidden":"true"})}update(e,t){var s,i=this.getChild("timeTooltip");i&&(s=this.player_.scrubbing()?this.player_.getCache().currentTime:this.player_.currentTime(),i.updateTime(e,t,s))}}Oi.prototype.options_={children:[]},d||o||Oi.prototype.options_.children.push("timeTooltip"),b.registerComponent("PlayProgressBar",Oi);class Mi extends b{constructor(e,t){super(e,t),this.update=r(v(this,this.update),30)}createEl(){return super.createEl("div",{className:"vjs-mouse-display"})}update(e,t){var s=t*this.player_.duration();this.getChild("timeTooltip").updateTime(e,t,s,()=>{this.el_.style.left=e.width*t+"px"})}}Mi.prototype.options_={children:["timeTooltip"]},b.registerComponent("MouseTimeDisplay",Mi);class Li extends Pi{constructor(e,t){super(e,t),this.setEventHandlers_()}setEventHandlers_(){this.update_=v(this,this.update),this.update=r(this.update_,30),this.on(this.player_,["ended","durationchange","timeupdate"],this.update),this.player_.liveTracker&&this.on(this.player_.liveTracker,"liveedgechange",this.update),this.updateInterval=null,this.enableIntervalHandler_=e=>this.enableInterval_(e),this.disableIntervalHandler_=e=>this.disableInterval_(e),this.on(this.player_,["playing"],this.enableIntervalHandler_),this.on(this.player_,["ended","pause","waiting"],this.disableIntervalHandler_),"hidden"in document&&"visibilityState"in document&&this.on(document,"visibilitychange",this.toggleVisibility_)}toggleVisibility_(e){"hidden"===document.visibilityState?(this.cancelNamedAnimationFrame("SeekBar#update"),this.cancelNamedAnimationFrame("Slider#update"),this.disableInterval_(e)):(this.player_.ended()||this.player_.paused()||this.enableInterval_(),this.update())}enableInterval_(){this.updateInterval||(this.updateInterval=this.setInterval(this.update,30))}disableInterval_(e){this.player_.liveTracker&&this.player_.liveTracker.isLive()&&e&&"ended"!==e.type||this.updateInterval&&(this.clearInterval(this.updateInterval),this.updateInterval=null)}createEl(){return super.createEl("div",{className:"vjs-progress-holder"},{"aria-label":this.localize("Progress Bar")})}update(e){if("hidden"!==document.visibilityState){const i=super.update();return this.requestNamedAnimationFrame("SeekBar#update",()=>{var e=this.player_.ended()?this.player_.duration():this.getCurrentTime_(),t=this.player_.liveTracker;let s=this.player_.duration();t&&t.isLive()&&(s=this.player_.liveTracker.liveCurrentTime()),this.percent_!==i&&(this.el_.setAttribute("aria-valuenow",(100*i).toFixed(2)),this.percent_=i),this.currentTime_===e&&this.duration_===s||(this.el_.setAttribute("aria-valuetext",this.localize("progress bar timing: currentTime={1} duration={2}",[Mt(e,s),Mt(s,s)],"{1} of {2}")),this.currentTime_=e,this.duration_=s),this.bar&&this.bar.update(Oe(this.el()),this.getProgress())}),i}}userSeek_(e){this.player_.liveTracker&&this.player_.liveTracker.isLive()&&this.player_.liveTracker.nextSeekedFromUser(),this.player_.currentTime(e)}getCurrentTime_(){return this.player_.scrubbing()?this.player_.getCache().currentTime:this.player_.currentTime()}getPercent(){var e=this.getCurrentTime_();let t;var s=this.player_.liveTracker;return s&&s.isLive()?(t=(e-s.seekableStart())/s.liveWindow(),s.atLiveEdge()&&(t=1)):t=e/this.player_.duration(),t}handleMouseDown(e){He(e)&&(e.stopPropagation(),this.videoWasPlaying=!this.player_.paused(),this.player_.pause(),super.handleMouseDown(e))}handleMouseMove(t,s=!1){if(He(t)){s||this.player_.scrubbing()||this.player_.scrubbing(!0);let e;s=this.calculateDistance(t),t=this.player_.liveTracker;if(t&&t.isLive()){if(.99<=s)return void t.seekToLiveEdge();var i=t.seekableStart(),r=t.liveCurrentTime();if((e=(e=(e=i+s*t.liveWindow())>=r?r:e)<=i?i+.1:e)===1/0)return}else(e=s*this.player_.duration())===this.player_.duration()&&(e-=.1);this.userSeek_(e)}}enable(){super.enable();var e=this.getChild("mouseTimeDisplay");e&&e.show()}disable(){super.disable();var e=this.getChild("mouseTimeDisplay");e&&e.hide()}handleMouseUp(e){super.handleMouseUp(e),e&&e.stopPropagation(),this.player_.scrubbing(!1),this.player_.trigger({type:"timeupdate",target:this,manuallyTriggered:!0}),this.videoWasPlaying?k(this.player_.play()):this.update_()}stepForward(){this.userSeek_(this.player_.currentTime()+5)}stepBack(){this.userSeek_(this.player_.currentTime()-5)}handleAction(e){this.player_.paused()?this.player_.play():this.player_.pause()}handleKeyDown(e){var t,s=this.player_.liveTracker;a.isEventKey(e,"Space")||a.isEventKey(e,"Enter")?(e.preventDefault(),e.stopPropagation(),this.handleAction(e)):a.isEventKey(e,"Home")?(e.preventDefault(),e.stopPropagation(),this.userSeek_(0)):a.isEventKey(e,"End")?(e.preventDefault(),e.stopPropagation(),s&&s.isLive()?this.userSeek_(s.liveCurrentTime()):this.userSeek_(this.player_.duration())):/^[0-9]$/.test(a(e))?(e.preventDefault(),e.stopPropagation(),t=10*(a.codes[a(e)]-a.codes[0])/100,s&&s.isLive()?this.userSeek_(s.seekableStart()+s.liveWindow()*t):this.userSeek_(this.player_.duration()*t)):a.isEventKey(e,"PgDn")?(e.preventDefault(),e.stopPropagation(),this.userSeek_(this.player_.currentTime()-60)):a.isEventKey(e,"PgUp")?(e.preventDefault(),e.stopPropagation(),this.userSeek_(this.player_.currentTime()+60)):super.handleKeyDown(e)}dispose(){this.disableInterval_(),this.off(this.player_,["ended","durationchange","timeupdate"],this.update),this.player_.liveTracker&&this.off(this.player_.liveTracker,"liveedgechange",this.update),this.off(this.player_,["playing"],this.enableIntervalHandler_),this.off(this.player_,["ended","pause","waiting"],this.disableIntervalHandler_),"hidden"in document&&"visibilityState"in document&&this.off(document,"visibilitychange",this.toggleVisibility_),super.dispose()}}Li.prototype.options_={children:["loadProgressBar","playProgressBar"],barName:"playProgressBar"},d||o||Li.prototype.options_.children.splice(1,0,"mouseTimeDisplay"),b.registerComponent("SeekBar",Li);class Ni extends b{constructor(e,t){super(e,t),this.handleMouseMove=r(v(this,this.handleMouseMove),30),this.throttledHandleMouseSeek=r(v(this,this.handleMouseSeek),30),this.handleMouseUpHandler_=e=>this.handleMouseUp(e),this.handleMouseDownHandler_=e=>this.handleMouseDown(e),this.enable()}createEl(){return super.createEl("div",{className:"vjs-progress-control vjs-control"})}handleMouseMove(e){var t,s,i,r,n=this.getChild("seekBar");n&&(t=n.getChild("playProgressBar"),s=n.getChild("mouseTimeDisplay"),t||s)&&(i=Me(r=n.el()),r=xi(r=Le(r,e).x,0,1),s&&s.update(i,r),t)&&t.update(i,n.getProgress())}handleMouseSeek(e){var t=this.getChild("seekBar");t&&t.handleMouseMove(e)}enabled(){return this.enabled_}disable(){var e;this.children().forEach(e=>e.disable&&e.disable()),this.enabled()&&(this.off(["mousedown","touchstart"],this.handleMouseDownHandler_),this.off(this.el_,"mousemove",this.handleMouseMove),this.removeListenersAddedOnMousedownAndTouchstart(),this.addClass("disabled"),this.enabled_=!1,this.player_.scrubbing())&&(e=this.getChild("seekBar"),this.player_.scrubbing(!1),e.videoWasPlaying)&&k(this.player_.play())}enable(){this.children().forEach(e=>e.enable&&e.enable()),this.enabled()||(this.on(["mousedown","touchstart"],this.handleMouseDownHandler_),this.on(this.el_,"mousemove",this.handleMouseMove),this.removeClass("disabled"),this.enabled_=!0)}removeListenersAddedOnMousedownAndTouchstart(){var e=this.el_.ownerDocument;this.off(e,"mousemove",this.throttledHandleMouseSeek),this.off(e,"touchmove",this.throttledHandleMouseSeek),this.off(e,"mouseup",this.handleMouseUpHandler_),this.off(e,"touchend",this.handleMouseUpHandler_)}handleMouseDown(e){var t=this.el_.ownerDocument,s=this.getChild("seekBar");s&&s.handleMouseDown(e),this.on(t,"mousemove",this.throttledHandleMouseSeek),this.on(t,"touchmove",this.throttledHandleMouseSeek),this.on(t,"mouseup",this.handleMouseUpHandler_),this.on(t,"touchend",this.handleMouseUpHandler_)}handleMouseUp(e){var t=this.getChild("seekBar");t&&t.handleMouseUp(e),this.removeListenersAddedOnMousedownAndTouchstart()}}Ni.prototype.options_={children:["seekBar"]},b.registerComponent("ProgressControl",Ni);class Di extends j{constructor(e,t){super(e,t),this.on(e,["enterpictureinpicture","leavepictureinpicture"],e=>this.handlePictureInPictureChange(e)),this.on(e,["disablepictureinpicturechanged","loadedmetadata"],e=>this.handlePictureInPictureEnabledChange(e)),this.on(e,["loadedmetadata","audioonlymodechange","audiopostermodechange"],()=>{"audio"===e.currentType().substring(0,5)||e.audioPosterMode()||e.audioOnlyMode()?(e.isInPictureInPicture()&&e.exitPictureInPicture(),this.hide()):this.show()}),this.disable()}buildCSSClass(){return"vjs-picture-in-picture-control "+super.buildCSSClass()}handlePictureInPictureEnabledChange(){document.pictureInPictureEnabled&&!1===this.player_.disablePictureInPicture()||this.player_.options_.enableDocumentPictureInPicture&&"documentPictureInPicture"in window?this.enable():this.disable()}handlePictureInPictureChange(e){this.player_.isInPictureInPicture()?this.controlText("Exit Picture-in-Picture"):this.controlText("Picture-in-Picture"),this.handlePictureInPictureEnabledChange()}handleClick(e){this.player_.isInPictureInPicture()?this.player_.exitPictureInPicture():this.player_.requestPictureInPicture()}}Di.prototype.controlText_="Picture-in-Picture",b.registerComponent("PictureInPictureToggle",Di);class Fi extends j{constructor(e,t){super(e,t),this.on(e,"fullscreenchange",e=>this.handleFullscreenChange(e)),!1===document[e.fsApi_.fullscreenEnabled]&&this.disable()}buildCSSClass(){return"vjs-fullscreen-control "+super.buildCSSClass()}handleFullscreenChange(e){this.player_.isFullscreen()?this.controlText("Exit Fullscreen"):this.controlText("Fullscreen")}handleClick(e){this.player_.isFullscreen()?this.player_.exitFullscreen():this.player_.requestFullscreen()}}Fi.prototype.controlText_="Fullscreen",b.registerComponent("FullscreenToggle",Fi);class Ri extends b{createEl(){var e=super.createEl("div",{className:"vjs-volume-level"});return e.appendChild(super.createEl("span",{className:"vjs-control-text"})),e}}b.registerComponent("VolumeLevel",Ri);class Bi extends b{constructor(e,t){super(e,t),this.update=r(v(this,this.update),30)}createEl(){return super.createEl("div",{className:"vjs-volume-tooltip"},{"aria-hidden":"true"})}update(t,s,i,e){if(!i){var i=Oe(this.el_),r=Oe(this.player_.el()),s=t.width*s;if(!r||!i)return;var n=t.left-r.left+s,s=t.width-s+(r.right-t.right);let e=i.width/2;n<e?e+=e-n:s<e&&(e=s),e<0?e=0:e>i.width&&(e=i.width),this.el_.style.right=`-${e}px`}this.write(e+"%")}write(e){ye(this.el_,e)}updateVolume(e,t,s,i,r){this.requestNamedAnimationFrame("VolumeLevelTooltip#updateVolume",()=>{this.update(e,t,s,i.toFixed(0)),r&&r()})}}b.registerComponent("VolumeLevelTooltip",Bi);class Hi extends b{constructor(e,t){super(e,t),this.update=r(v(this,this.update),30)}createEl(){return super.createEl("div",{className:"vjs-mouse-display"})}update(e,t,s){var i=100*t;this.getChild("volumeLevelTooltip").updateVolume(e,t,s,i,()=>{s?this.el_.style.bottom=e.height*t+"px":this.el_.style.left=e.width*t+"px"})}}Hi.prototype.options_={children:["volumeLevelTooltip"]},b.registerComponent("MouseVolumeLevelDisplay",Hi);class Vi extends Pi{constructor(e,t){super(e,t),this.on("slideractive",e=>this.updateLastVolume_(e)),this.on(e,"volumechange",e=>this.updateARIAAttributes(e)),e.ready(()=>this.updateARIAAttributes())}createEl(){return super.createEl("div",{className:"vjs-volume-bar vjs-slider-bar"},{"aria-label":this.localize("Volume Level"),"aria-live":"polite"})}handleMouseDown(e){He(e)&&super.handleMouseDown(e)}handleMouseMove(e){var t,s,i,r=this.getChild("mouseVolumeLevelDisplay");r&&(t=Oe(i=this.el()),s=this.vertical(),i=Le(i,e),i=xi(i=s?i.y:i.x,0,1),r.update(t,i,s)),He(e)&&(this.checkMuted(),this.player_.volume(this.calculateDistance(e)))}checkMuted(){this.player_.muted()&&this.player_.muted(!1)}getPercent(){return this.player_.muted()?0:this.player_.volume()}stepForward(){this.checkMuted(),this.player_.volume(this.player_.volume()+.1)}stepBack(){this.checkMuted(),this.player_.volume(this.player_.volume()-.1)}updateARIAAttributes(e){var t=this.player_.muted()?0:this.volumeAsPercentage_();this.el_.setAttribute("aria-valuenow",t),this.el_.setAttribute("aria-valuetext",t+"%")}volumeAsPercentage_(){return Math.round(100*this.player_.volume())}updateLastVolume_(){const e=this.player_.volume();this.one("sliderinactive",()=>{0===this.player_.volume()&&this.player_.lastVolume_(e)})}}Vi.prototype.options_={children:["volumeLevel"],barName:"volumeLevel"},d||o||Vi.prototype.options_.children.splice(0,0,"mouseVolumeLevelDisplay"),Vi.prototype.playerEvent="volumechange",b.registerComponent("VolumeBar",Vi);class $i extends b{constructor(e,t={}){var s,i;t.vertical=t.vertical||!1,"undefined"!=typeof t.volumeBar&&!G(t.volumeBar)||(t.volumeBar=t.volumeBar||{},t.volumeBar.vertical=t.vertical),super(e,t),s=this,(i=e).tech_&&!i.tech_.featuresVolumeControl&&s.addClass("vjs-hidden"),s.on(i,"loadstart",function(){i.tech_.featuresVolumeControl?s.removeClass("vjs-hidden"):s.addClass("vjs-hidden")}),this.throttledHandleMouseMove=r(v(this,this.handleMouseMove),30),this.handleMouseUpHandler_=e=>this.handleMouseUp(e),this.on("mousedown",e=>this.handleMouseDown(e)),this.on("touchstart",e=>this.handleMouseDown(e)),this.on("mousemove",e=>this.handleMouseMove(e)),this.on(this.volumeBar,["focus","slideractive"],()=>{this.volumeBar.addClass("vjs-slider-active"),this.addClass("vjs-slider-active"),this.trigger("slideractive")}),this.on(this.volumeBar,["blur","sliderinactive"],()=>{this.volumeBar.removeClass("vjs-slider-active"),this.removeClass("vjs-slider-active"),this.trigger("sliderinactive")})}createEl(){let e="vjs-volume-horizontal";return this.options_.vertical&&(e="vjs-volume-vertical"),super.createEl("div",{className:"vjs-volume-control vjs-control "+e})}handleMouseDown(e){var t=this.el_.ownerDocument;this.on(t,"mousemove",this.throttledHandleMouseMove),this.on(t,"touchmove",this.throttledHandleMouseMove),this.on(t,"mouseup",this.handleMouseUpHandler_),this.on(t,"touchend",this.handleMouseUpHandler_)}handleMouseUp(e){var t=this.el_.ownerDocument;this.off(t,"mousemove",this.throttledHandleMouseMove),this.off(t,"touchmove",this.throttledHandleMouseMove),this.off(t,"mouseup",this.handleMouseUpHandler_),this.off(t,"touchend",this.handleMouseUpHandler_)}handleMouseMove(e){this.volumeBar.handleMouseMove(e)}}$i.prototype.options_={children:["volumeBar"]},b.registerComponent("VolumeControl",$i);class zi extends j{constructor(e,t){var s,i;super(e,t),s=this,(i=e).tech_&&!i.tech_.featuresMuteControl&&s.addClass("vjs-hidden"),s.on(i,"loadstart",function(){i.tech_.featuresMuteControl?s.removeClass("vjs-hidden"):s.addClass("vjs-hidden")}),this.on(e,["loadstart","volumechange"],e=>this.update(e))}buildCSSClass(){return"vjs-mute-control "+super.buildCSSClass()}handleClick(e){var t=this.player_.volume(),s=this.player_.lastVolume_();0===t?(this.player_.volume(s<.1?.1:s),this.player_.muted(!1)):this.player_.muted(!this.player_.muted())}update(e){this.updateIcon_(),this.updateControlText_()}updateIcon_(){var e=this.player_.volume();let t=3;d&&this.player_.tech_&&this.player_.tech_.el_&&this.player_.muted(this.player_.tech_.el_.muted),0===e||this.player_.muted()?t=0:e<.33?t=1:e<.67&&(t=2),Ce(this.el_,[0,1,2,3].reduce((e,t)=>e+`${t?" ":""}vjs-vol-`+t,"")),ke(this.el_,"vjs-vol-"+t)}updateControlText_(){var e=this.player_.muted()||0===this.player_.volume()?"Unmute":"Mute";this.controlText()!==e&&this.controlText(e)}}zi.prototype.controlText_="Mute",b.registerComponent("MuteToggle",zi);class Ui extends b{constructor(e,t={}){"undefined"!=typeof t.inline?t.inline=t.inline:t.inline=!0,"undefined"!=typeof t.volumeControl&&!G(t.volumeControl)||(t.volumeControl=t.volumeControl||{},t.volumeControl.vertical=!t.inline),super(e,t),this.handleKeyPressHandler_=e=>this.handleKeyPress(e),this.on(e,["loadstart"],e=>this.volumePanelState_(e)),this.on(this.muteToggle,"keyup",e=>this.handleKeyPress(e)),this.on(this.volumeControl,"keyup",e=>this.handleVolumeControlKeyUp(e)),this.on("keydown",e=>this.handleKeyPress(e)),this.on("mouseover",e=>this.handleMouseOver(e)),this.on("mouseout",e=>this.handleMouseOut(e)),this.on(this.volumeControl,["slideractive"],this.sliderActive_),this.on(this.volumeControl,["sliderinactive"],this.sliderInactive_)}sliderActive_(){this.addClass("vjs-slider-active")}sliderInactive_(){this.removeClass("vjs-slider-active")}volumePanelState_(){this.volumeControl.hasClass("vjs-hidden")&&this.muteToggle.hasClass("vjs-hidden")&&this.addClass("vjs-hidden"),this.volumeControl.hasClass("vjs-hidden")&&!this.muteToggle.hasClass("vjs-hidden")&&this.addClass("vjs-mute-toggle-only")}createEl(){let e="vjs-volume-panel-horizontal";return this.options_.inline||(e="vjs-volume-panel-vertical"),super.createEl("div",{className:"vjs-volume-panel vjs-control "+e})}dispose(){this.handleMouseOut(),super.dispose()}handleVolumeControlKeyUp(e){a.isEventKey(e,"Esc")&&this.muteToggle.focus()}handleMouseOver(e){this.addClass("vjs-hover"),_(document,"keyup",this.handleKeyPressHandler_)}handleMouseOut(e){this.removeClass("vjs-hover"),f(document,"keyup",this.handleKeyPressHandler_)}handleKeyPress(e){a.isEventKey(e,"Esc")&&this.handleMouseOut()}}Ui.prototype.options_={children:["muteToggle","volumeControl"]},b.registerComponent("VolumePanel",Ui);j;b.registerComponent("SkipForward",class extends j{constructor(e,t){super(e,t),this.validOptions=[5,10,30],this.skipTime=this.getSkipForwardTime(),this.skipTime&&this.validOptions.includes(this.skipTime)?(this.controlText(this.localize("Skip forward {1} seconds",[this.skipTime])),this.show()):this.hide()}getSkipForwardTime(){var e=this.options_.playerOptions;return e.controlBar&&e.controlBar.skipButtons&&e.controlBar.skipButtons.forward}buildCSSClass(){return`vjs-skip-forward-${this.getSkipForwardTime()} `+super.buildCSSClass()}handleClick(e){var t=this.player_.currentTime(),s=this.player_.liveTracker,s=s&&s.isLive()?s.seekableEnd():this.player_.duration();let i;i=t+this.skipTime<=s?t+this.skipTime:s,this.player_.currentTime(i)}handleLanguagechange(){this.controlText(this.localize("Skip forward {1} seconds",[this.skipTime]))}});class Ki extends j{constructor(e,t){super(e,t),this.validOptions=[5,10,30],this.skipTime=this.getSkipBackwardTime(),this.skipTime&&this.validOptions.includes(this.skipTime)?(this.controlText(this.localize("Skip backward {1} seconds",[this.skipTime])),this.show()):this.hide()}getSkipBackwardTime(){var e=this.options_.playerOptions;return e.controlBar&&e.controlBar.skipButtons&&e.controlBar.skipButtons.backward}buildCSSClass(){return`vjs-skip-backward-${this.getSkipBackwardTime()} `+super.buildCSSClass()}handleClick(e){var t=this.player_.currentTime(),s=this.player_.liveTracker,s=s&&s.isLive()&&s.seekableStart();let i;i=s&&t-this.skipTime<=s?s:t>=this.skipTime?t-this.skipTime:0,this.player_.currentTime(i)}handleLanguagechange(){this.controlText(this.localize("Skip backward {1} seconds",[this.skipTime]))}}Ki.prototype.controlText_="Skip Backward",b.registerComponent("SkipBackward",Ki);class Wi extends b{constructor(e,t){super(e,t),t&&(this.menuButton_=t.menuButton),this.focusedChild_=-1,this.on("keydown",e=>this.handleKeyDown(e)),this.boundHandleBlur_=e=>this.handleBlur(e),this.boundHandleTapClick_=e=>this.handleTapClick(e)}addEventListenerForItem(e){e instanceof b&&(this.on(e,"blur",this.boundHandleBlur_),this.on(e,["tap","click"],this.boundHandleTapClick_))}removeEventListenerForItem(e){e instanceof b&&(this.off(e,"blur",this.boundHandleBlur_),this.off(e,["tap","click"],this.boundHandleTapClick_))}removeChild(e){"string"==typeof e&&(e=this.getChild(e)),this.removeEventListenerForItem(e),super.removeChild(e)}addItem(e){e=this.addChild(e);e&&this.addEventListenerForItem(e)}createEl(){var e=this.options_.contentElType||"ul",e=(this.contentEl_=p(e,{className:"vjs-menu-content"}),this.contentEl_.setAttribute("role","menu"),super.createEl("div",{append:this.contentEl_,className:"vjs-menu"}));return e.appendChild(this.contentEl_),_(e,"click",function(e){e.preventDefault(),e.stopImmediatePropagation()}),e}dispose(){this.contentEl_=null,this.boundHandleBlur_=null,this.boundHandleTapClick_=null,super.dispose()}handleBlur(e){const t=e.relatedTarget||document.activeElement;this.children().some(e=>e.el()===t)||(e=this.menuButton_)&&e.buttonPressed_&&t!==e.el().firstChild&&e.unpressButton()}handleTapClick(t){var e;this.menuButton_&&(this.menuButton_.unpressButton(),e=this.children(),Array.isArray(e))&&(e=e.filter(e=>e.el()===t.target)[0])&&"CaptionSettingsMenuItem"!==e.name()&&this.menuButton_.focus()}handleKeyDown(e){a.isEventKey(e,"Left")||a.isEventKey(e,"Down")?(e.preventDefault(),e.stopPropagation(),this.stepForward()):(a.isEventKey(e,"Right")||a.isEventKey(e,"Up"))&&(e.preventDefault(),e.stopPropagation(),this.stepBack())}stepForward(){let e=0;void 0!==this.focusedChild_&&(e=this.focusedChild_+1),this.focus(e)}stepBack(){let e=0;void 0!==this.focusedChild_&&(e=this.focusedChild_-1),this.focus(e)}focus(e=0){var t=this.children().slice();t.length&&t[0].hasClass("vjs-menu-title")&&t.shift(),0<t.length&&(e<0?e=0:e>=t.length&&(e=t.length-1),t[this.focusedChild_=e].el_.focus())}}b.registerComponent("Menu",Wi);class qi extends b{constructor(e,t={}){super(e,t),this.menuButton_=new j(e,t),this.menuButton_.controlText(this.controlText_),this.menuButton_.el_.setAttribute("aria-haspopup","true");e=j.prototype.buildCSSClass(),this.menuButton_.el_.className=this.buildCSSClass()+" "+e,this.menuButton_.removeClass("vjs-control"),this.addChild(this.menuButton_),this.update(),this.enabled_=!0,t=e=>this.handleClick(e);this.handleMenuKeyUp_=e=>this.handleMenuKeyUp(e),this.on(this.menuButton_,"tap",t),this.on(this.menuButton_,"click",t),this.on(this.menuButton_,"keydown",e=>this.handleKeyDown(e)),this.on(this.menuButton_,"mouseenter",()=>{this.addClass("vjs-hover"),this.menu.show(),_(document,"keyup",this.handleMenuKeyUp_)}),this.on("mouseleave",e=>this.handleMouseLeave(e)),this.on("keydown",e=>this.handleSubmenuKeyDown(e))}update(){var e=this.createMenu();this.menu&&(this.menu.dispose(),this.removeChild(this.menu)),this.menu=e,this.addChild(e),this.buttonPressed_=!1,this.menuButton_.el_.setAttribute("aria-expanded","false"),this.items&&this.items.length<=this.hideThreshold_?(this.hide(),this.menu.contentEl_.removeAttribute("role")):(this.show(),this.menu.contentEl_.setAttribute("role","menu"))}createMenu(){var e,t=new Wi(this.player_,{menuButton:this});if(this.hideThreshold_=0,this.options_.title&&(e=p("li",{className:"vjs-menu-title",textContent:y(this.options_.title),tabIndex:-1}),e=new b(this.player_,{el:e}),t.addItem(e)),this.items=this.createItems(),this.items)for(let e=0;e<this.items.length;e++)t.addItem(this.items[e]);return t}createItems(){}createEl(){return super.createEl("div",{className:this.buildWrapperCSSClass()},{})}buildWrapperCSSClass(){let e="vjs-menu-button";!0===this.options_.inline?e+="-inline":e+="-popup";var t=j.prototype.buildCSSClass();return`vjs-menu-button ${e} ${t} `+super.buildCSSClass()}buildCSSClass(){let e="vjs-menu-button";return!0===this.options_.inline?e+="-inline":e+="-popup",`vjs-menu-button ${e} `+super.buildCSSClass()}controlText(e,t=this.menuButton_.el()){return this.menuButton_.controlText(e,t)}dispose(){this.handleMouseLeave(),super.dispose()}handleClick(e){this.buttonPressed_?this.unpressButton():this.pressButton()}handleMouseLeave(e){this.removeClass("vjs-hover"),f(document,"keyup",this.handleMenuKeyUp_)}focus(){this.menuButton_.focus()}blur(){this.menuButton_.blur()}handleKeyDown(e){a.isEventKey(e,"Esc")||a.isEventKey(e,"Tab")?(this.buttonPressed_&&this.unpressButton(),a.isEventKey(e,"Tab")||(e.preventDefault(),this.menuButton_.focus())):!a.isEventKey(e,"Up")&&!a.isEventKey(e,"Down")||this.buttonPressed_||(e.preventDefault(),this.pressButton())}handleMenuKeyUp(e){(a.isEventKey(e,"Esc")||a.isEventKey(e,"Tab"))&&this.removeClass("vjs-hover")}handleSubmenuKeyPress(e){this.handleSubmenuKeyDown(e)}handleSubmenuKeyDown(e){(a.isEventKey(e,"Esc")||a.isEventKey(e,"Tab"))&&(this.buttonPressed_&&this.unpressButton(),a.isEventKey(e,"Tab")||(e.preventDefault(),this.menuButton_.focus()))}pressButton(){this.enabled_&&(this.buttonPressed_=!0,this.menu.show(),this.menu.lockShowing(),this.menuButton_.el_.setAttribute("aria-expanded","true"),d&&fe()||this.menu.focus())}unpressButton(){this.enabled_&&(this.buttonPressed_=!1,this.menu.unlockShowing(),this.menu.hide(),this.menuButton_.el_.setAttribute("aria-expanded","false"))}disable(){this.unpressButton(),this.enabled_=!1,this.addClass("vjs-disabled"),this.menuButton_.disable()}enable(){this.enabled_=!0,this.removeClass("vjs-disabled"),this.menuButton_.enable()}}b.registerComponent("MenuButton",qi);class Xi extends qi{constructor(e,t){const s=t.tracks;if(super(e,t),this.items.length<=1&&this.hide(),s){const i=v(this,this.update);s.addEventListener("removetrack",i),s.addEventListener("addtrack",i),s.addEventListener("labelchange",i),this.player_.on("ready",i),this.player_.on("dispose",function(){s.removeEventListener("removetrack",i),s.removeEventListener("addtrack",i),s.removeEventListener("labelchange",i)})}}}b.registerComponent("TrackButton",Xi);const Gi=["Tab","Esc","Up","Down","Right","Left"];class Yi extends ui{constructor(e,t){super(e,t),this.selectable=t.selectable,this.isSelected_=t.selected||!1,this.multiSelectable=t.multiSelectable,this.selected(this.isSelected_),this.selectable?this.multiSelectable?this.el_.setAttribute("role","menuitemcheckbox"):this.el_.setAttribute("role","menuitemradio"):this.el_.setAttribute("role","menuitem")}createEl(e,t,s){this.nonIconControl=!0;t=super.createEl("li",Object.assign({className:"vjs-menu-item",tabIndex:-1},t),s);return t.replaceChild(p("span",{className:"vjs-menu-item-text",textContent:this.localize(this.options_.label)}),t.querySelector(".vjs-icon-placeholder")),t}handleKeyDown(t){Gi.some(e=>a.isEventKey(t,e))||super.handleKeyDown(t)}handleClick(e){this.selected(!0)}selected(e){this.selectable&&(e?(this.addClass("vjs-selected"),this.el_.setAttribute("aria-checked","true"),this.controlText(", selected"),this.isSelected_=!0):(this.removeClass("vjs-selected"),this.el_.setAttribute("aria-checked","false"),this.controlText(""),this.isSelected_=!1))}}b.registerComponent("MenuItem",Yi);class Qi extends Yi{constructor(e,t){var s=t.track;const i=e.textTracks(),r=(t.label=s.label||s.language||"Unknown",t.selected="showing"===s.mode,super(e,t),this.track=s,this.kinds=(t.kinds||[t.kind||this.track.kind]).filter(Boolean),(...e)=>{this.handleTracksChange.apply(this,e)}),n=(...e)=>{this.handleSelectedLanguageChange.apply(this,e)};if(e.on(["loadstart","texttrackchange"],r),i.addEventListener("change",r),i.addEventListener("selectedlanguagechange",n),this.on("dispose",function(){e.off(["loadstart","texttrackchange"],r),i.removeEventListener("change",r),i.removeEventListener("selectedlanguagechange",n)}),void 0===i.onchange){let e;this.on(["tap","click"],function(){if("object"!=typeof window.Event)try{e=new window.Event("change")}catch(e){}e||(e=document.createEvent("Event")).initEvent("change",!0,!0),i.dispatchEvent(e)})}this.handleTracksChange()}handleClick(e){var t=this.track,s=this.player_.textTracks();if(super.handleClick(e),s)for(let e=0;e<s.length;e++){var i=s[e];-1!==this.kinds.indexOf(i.kind)&&(i===t?"showing"!==i.mode&&(i.mode="showing"):"disabled"!==i.mode&&(i.mode="disabled"))}}handleTracksChange(e){var t="showing"===this.track.mode;t!==this.isSelected_&&this.selected(t)}handleSelectedLanguageChange(e){var t;"showing"!==this.track.mode||(t=this.player_.cache_.selectedLanguage)&&t.enabled&&t.language===this.track.language&&t.kind!==this.track.kind||(this.player_.cache_.selectedLanguage={enabled:!0,language:this.track.language,kind:this.track.kind})}dispose(){this.track=null,super.dispose()}}b.registerComponent("TextTrackMenuItem",Qi);class Ji extends Qi{constructor(e,t){t.track={player:e,kind:t.kind,kinds:t.kinds,default:!1,mode:"disabled"},t.kinds||(t.kinds=[t.kind]),t.label?t.track.label=t.label:t.track.label=t.kinds.join(" and ")+" off",t.selectable=!0,t.multiSelectable=!1,super(e,t)}handleTracksChange(e){var s=this.player().textTracks();let i=!0;for(let e=0,t=s.length;e<t;e++){var r=s[e];if(-1<this.options_.kinds.indexOf(r.kind)&&"showing"===r.mode){i=!1;break}}i!==this.isSelected_&&this.selected(i)}handleSelectedLanguageChange(e){var s=this.player().textTracks();let i=!0;for(let e=0,t=s.length;e<t;e++){var r=s[e];if(-1<["captions","descriptions","subtitles"].indexOf(r.kind)&&"showing"===r.mode){i=!1;break}}i&&(this.player_.cache_.selectedLanguage={enabled:!1})}handleLanguagechange(){this.$(".vjs-menu-item-text").textContent=this.player_.localize(this.options_.label),super.handleLanguagechange()}}b.registerComponent("OffTextTrackMenuItem",Ji);class Zi extends Xi{constructor(e,t={}){t.tracks=e.textTracks(),super(e,t)}createItems(t=[],s=Qi){let e;this.label_&&(e=this.label_+" off"),t.push(new Ji(this.player_,{kinds:this.kinds_,kind:this.kind_,label:e})),this.hideThreshold_+=1;var i=this.player_.textTracks();Array.isArray(this.kinds_)||(this.kinds_=[this.kind_]);for(let e=0;e<i.length;e++){var r,n=i[e];-1<this.kinds_.indexOf(n.kind)&&((r=new s(this.player_,{track:n,kinds:this.kinds_,kind:this.kind_,selectable:!0,multiSelectable:!1})).addClass(`vjs-${n.kind}-menu-item`),t.push(r))}return t}}b.registerComponent("TextTrackButton",Zi);class er extends Yi{constructor(e,t){var s=t.track,i=t.cue,r=e.currentTime();t.selectable=!0,t.multiSelectable=!1,t.label=i.text,t.selected=i.startTime<=r&&r<i.endTime,super(e,t),this.track=s,this.cue=i}handleClick(e){super.handleClick(),this.player_.currentTime(this.cue.startTime)}}b.registerComponent("ChaptersTrackMenuItem",er);class tr extends Zi{constructor(e,t,s){super(e,t,s),this.selectCurrentItem_=()=>{this.items.forEach(e=>{e.selected(this.track_.activeCues[0]===e.cue)})}}buildCSSClass(){return"vjs-chapters-button "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-chapters-button "+super.buildWrapperCSSClass()}update(e){e&&e.track&&"chapters"!==e.track.kind||((e=this.findChaptersTrack())!==this.track_?(this.setTrack(e),super.update()):(!this.items||e&&e.cues&&e.cues.length!==this.items.length)&&super.update())}setTrack(e){var t;this.track_!==e&&(this.updateHandler_||(this.updateHandler_=this.update.bind(this)),this.track_&&((t=this.player_.remoteTextTrackEls().getTrackElementByTrack_(this.track_))&&t.removeEventListener("load",this.updateHandler_),this.track_.removeEventListener("cuechange",this.selectCurrentItem_),this.track_=null),this.track_=e,this.track_)&&(this.track_.mode="hidden",(t=this.player_.remoteTextTrackEls().getTrackElementByTrack_(this.track_))&&t.addEventListener("load",this.updateHandler_),this.track_.addEventListener("cuechange",this.selectCurrentItem_))}findChaptersTrack(){var t=this.player_.textTracks()||[];for(let e=t.length-1;0<=e;e--){var s=t[e];if(s.kind===this.kind_)return s}}getMenuCaption(){return this.track_&&this.track_.label?this.track_.label:this.localize(y(this.kind_))}createMenu(){return this.options_.title=this.getMenuCaption(),super.createMenu()}createItems(){var s=[];if(this.track_){var i=this.track_.cues;if(i)for(let e=0,t=i.length;e<t;e++){var r=i[e],r=new er(this.player_,{track:this.track_,cue:r});s.push(r)}}return s}}tr.prototype.kind_="chapters",tr.prototype.controlText_="Chapters",b.registerComponent("ChaptersButton",tr);class sr extends Zi{constructor(e,t,s){super(e,t,s);const i=e.textTracks(),r=v(this,this.handleTracksChange);i.addEventListener("change",r),this.on("dispose",function(){i.removeEventListener("change",r)})}handleTracksChange(e){var s=this.player().textTracks();let i=!1;for(let e=0,t=s.length;e<t;e++){var r=s[e];if(r.kind!==this.kind_&&"showing"===r.mode){i=!0;break}}i?this.disable():this.enable()}buildCSSClass(){return"vjs-descriptions-button "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-descriptions-button "+super.buildWrapperCSSClass()}}sr.prototype.kind_="descriptions",sr.prototype.controlText_="Descriptions",b.registerComponent("DescriptionsButton",sr);class ir extends Zi{constructor(e,t,s){super(e,t,s)}buildCSSClass(){return"vjs-subtitles-button "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-subtitles-button "+super.buildWrapperCSSClass()}}ir.prototype.kind_="subtitles",ir.prototype.controlText_="Subtitles",b.registerComponent("SubtitlesButton",ir);class rr extends Qi{constructor(e,t){t.track={player:e,kind:t.kind,label:t.kind+" settings",selectable:!1,default:!1,mode:"disabled"},t.selectable=!1,t.name="CaptionSettingsMenuItem",super(e,t),this.addClass("vjs-texttrack-settings"),this.controlText(", opens "+t.kind+" settings dialog")}handleClick(e){this.player().getChild("textTrackSettings").open()}handleLanguagechange(){this.$(".vjs-menu-item-text").textContent=this.player_.localize(this.options_.kind+" settings"),super.handleLanguagechange()}}b.registerComponent("CaptionSettingsMenuItem",rr);class nr extends Zi{constructor(e,t,s){super(e,t,s)}buildCSSClass(){return"vjs-captions-button "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-captions-button "+super.buildWrapperCSSClass()}createItems(){var e=[];return this.player().tech_&&this.player().tech_.featuresNativeTextTracks||!this.player().getChild("textTrackSettings")||(e.push(new rr(this.player_,{kind:this.kind_})),this.hideThreshold_+=1),super.createItems(e)}}nr.prototype.kind_="captions",nr.prototype.controlText_="Captions",b.registerComponent("CaptionsButton",nr);class ar extends Qi{createEl(e,t,s){e=super.createEl(e,t,s),t=e.querySelector(".vjs-menu-item-text");return"captions"===this.options_.track.kind&&(t.appendChild(p("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),t.appendChild(p("span",{className:"vjs-control-text",textContent:" "+this.localize("Captions")}))),e}}b.registerComponent("SubsCapsMenuItem",ar);class or extends Zi{constructor(e,t={}){super(e,t),this.label_="subtitles",-1<["en","en-us","en-ca","fr-ca"].indexOf(this.player_.language_)&&(this.label_="captions"),this.menuButton_.controlText(y(this.label_))}buildCSSClass(){return"vjs-subs-caps-button "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-subs-caps-button "+super.buildWrapperCSSClass()}createItems(){let e=[];return this.player().tech_&&this.player().tech_.featuresNativeTextTracks||!this.player().getChild("textTrackSettings")||(e.push(new rr(this.player_,{kind:this.label_})),this.hideThreshold_+=1),e=super.createItems(e,ar)}}or.prototype.kinds_=["captions","subtitles"],or.prototype.controlText_="Subtitles",b.registerComponent("SubsCapsButton",or);class lr extends Yi{constructor(e,t){var s=t.track;const i=e.audioTracks(),r=(t.label=s.label||s.language||"Unknown",t.selected=s.enabled,super(e,t),this.track=s,this.addClass(`vjs-${s.kind}-menu-item`),(...e)=>{this.handleTracksChange.apply(this,e)});i.addEventListener("change",r),this.on("dispose",()=>{i.removeEventListener("change",r)})}createEl(e,t,s){e=super.createEl(e,t,s),t=e.querySelector(".vjs-menu-item-text");return"main-desc"===this.options_.track.kind&&(t.appendChild(p("span",{className:"vjs-icon-placeholder"},{"aria-hidden":!0})),t.appendChild(p("span",{className:"vjs-control-text",textContent:" "+this.localize("Descriptions")}))),e}handleClick(e){if(super.handleClick(e),this.track.enabled=!0,this.player_.tech_.featuresNativeAudioTracks){var t=this.player_.audioTracks();for(let e=0;e<t.length;e++){var s=t[e];s!==this.track&&(s.enabled=s===this.track)}}}handleTracksChange(e){this.selected(this.track.enabled)}}b.registerComponent("AudioTrackMenuItem",lr);class hr extends Xi{constructor(e,t={}){t.tracks=e.audioTracks(),super(e,t)}buildCSSClass(){return"vjs-audio-button "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-audio-button "+super.buildWrapperCSSClass()}createItems(t=[]){this.hideThreshold_=1;var s=this.player_.audioTracks();for(let e=0;e<s.length;e++){var i=s[e];t.push(new lr(this.player_,{track:i,selectable:!0,multiSelectable:!1}))}return t}}hr.prototype.controlText_="Audio Track",b.registerComponent("AudioTrackButton",hr);class cr extends Yi{constructor(e,t){var s=t.rate,i=parseFloat(s,10);t.label=s,t.selected=i===e.playbackRate(),t.selectable=!0,t.multiSelectable=!1,super(e,t),this.label=s,this.rate=i,this.on(e,"ratechange",e=>this.update(e))}handleClick(e){super.handleClick(),this.player().playbackRate(this.rate)}update(e){this.selected(this.player().playbackRate()===this.rate)}}cr.prototype.contentElType="button",b.registerComponent("PlaybackRateMenuItem",cr);class ur extends qi{constructor(e,t){super(e,t),this.menuButton_.el_.setAttribute("aria-describedby",this.labelElId_),this.updateVisibility(),this.updateLabel(),this.on(e,"loadstart",e=>this.updateVisibility(e)),this.on(e,"ratechange",e=>this.updateLabel(e)),this.on(e,"playbackrateschange",e=>this.handlePlaybackRateschange(e))}createEl(){var e=super.createEl();return this.labelElId_="vjs-playback-rate-value-label-"+this.id_,this.labelEl_=p("div",{className:"vjs-playback-rate-value",id:this.labelElId_,textContent:"1x"}),e.appendChild(this.labelEl_),e}dispose(){this.labelEl_=null,super.dispose()}buildCSSClass(){return"vjs-playback-rate "+super.buildCSSClass()}buildWrapperCSSClass(){return"vjs-playback-rate "+super.buildWrapperCSSClass()}createItems(){var t=this.playbackRates(),s=[];for(let e=t.length-1;0<=e;e--)s.push(new cr(this.player(),{rate:t[e]+"x"}));return s}handlePlaybackRateschange(e){this.update()}playbackRates(){var e=this.player();return e.playbackRates&&e.playbackRates()||[]}playbackRateSupported(){return this.player().tech_&&this.player().tech_.featuresPlaybackRate&&this.playbackRates()&&0<this.playbackRates().length}updateVisibility(e){this.playbackRateSupported()?this.removeClass("vjs-hidden"):this.addClass("vjs-hidden")}updateLabel(e){this.playbackRateSupported()&&(this.labelEl_.textContent=this.player().playbackRate()+"x")}}ur.prototype.controlText_="Playback Rate",b.registerComponent("PlaybackRateMenuButton",ur);class dr extends b{buildCSSClass(){return"vjs-spacer "+super.buildCSSClass()}createEl(e="div",t={},s={}){return t.className||(t.className=this.buildCSSClass()),super.createEl(e,t,s)}}b.registerComponent("Spacer",dr);b.registerComponent("CustomControlSpacer",class extends dr{buildCSSClass(){return"vjs-custom-control-spacer "+super.buildCSSClass()}createEl(){return super.createEl("div",{className:this.buildCSSClass(),textContent:" "})}});class pr extends b{createEl(){return super.createEl("div",{className:"vjs-control-bar",dir:"ltr"})}}pr.prototype.options_={children:["playToggle","skipBackward","skipForward","volumePanel","currentTimeDisplay","timeDivider","durationDisplay","progressControl","liveDisplay","seekToLive","remainingTimeDisplay","customControlSpacer","playbackRateMenuButton","chaptersButton","descriptionsButton","subsCapsButton","audioTrackButton","fullscreenToggle"]},"exitPictureInPicture"in document&&pr.prototype.options_.children.splice(pr.prototype.options_.children.length-1,0,"pictureInPictureToggle"),b.registerComponent("ControlBar",pr);class gr extends $t{constructor(e,t){super(e,t),this.on(e,"error",e=>this.open(e))}buildCSSClass(){return"vjs-error-display "+super.buildCSSClass()}content(){var e=this.player().error();return e?this.localize(e.message):""}}gr.prototype.options_=Object.assign({},$t.prototype.options_,{pauseOnOpen:!1,fillAlways:!0,temporary:!1,uncloseable:!0}),b.registerComponent("ErrorDisplay",gr);const mr="vjs-text-track-settings";var ks=["#000","Black"],Et=["#00F","Blue"],_r=["#0FF","Cyan"],fr=["#0F0","Green"],vr=["#F0F","Magenta"],yr=["#F00","Red"],br=["#FFF","White"],Tr=["#FF0","Yellow"],kr=["1","Opaque"],Cr=["0.5","Semi-Transparent"],wr=["0","Transparent"];const Er={backgroundColor:{selector:".vjs-bg-color > select",id:"captions-background-color-%s",label:"Color",options:[ks,br,yr,fr,Et,Tr,vr,_r]},backgroundOpacity:{selector:".vjs-bg-opacity > select",id:"captions-background-opacity-%s",label:"Opacity",options:[kr,Cr,wr]},color:{selector:".vjs-text-color > select",id:"captions-foreground-color-%s",label:"Color",options:[br,ks,yr,fr,Et,Tr,vr,_r]},edgeStyle:{selector:".vjs-edge-style > select",id:"%s",label:"Text Edge Style",options:[["none","None"],["raised","Raised"],["depressed","Depressed"],["uniform","Uniform"],["dropshadow","Dropshadow"]]},fontFamily:{selector:".vjs-font-family > select",id:"captions-font-family-%s",label:"Font Family",options:[["proportionalSansSerif","Proportional Sans-Serif"],["monospaceSansSerif","Monospace Sans-Serif"],["proportionalSerif","Proportional Serif"],["monospaceSerif","Monospace Serif"],["casual","Casual"],["script","Script"],["small-caps","Small Caps"]]},fontPercent:{selector:".vjs-font-percent > select",id:"captions-font-size-%s",label:"Font Size",options:[["0.50","50%"],["0.75","75%"],["1.00","100%"],["1.25","125%"],["1.50","150%"],["1.75","175%"],["2.00","200%"],["3.00","300%"],["4.00","400%"]],default:2,parser:e=>"1.00"===e?null:Number(e)},textOpacity:{selector:".vjs-text-opacity > select",id:"captions-foreground-opacity-%s",label:"Opacity",options:[kr,Cr]},windowColor:{selector:".vjs-window-color > select",id:"captions-window-color-%s",label:"Color"},windowOpacity:{selector:".vjs-window-opacity > select",id:"captions-window-opacity-%s",label:"Opacity",options:[wr,Cr,kr]}};function Sr(e,t){if((e=t?t(e):e)&&"none"!==e)return e}Er.windowColor.options=Er.backgroundColor.options;class xr extends $t{constructor(e,t){t.temporary=!1,super(e,t),this.updateDisplay=this.updateDisplay.bind(this),this.fill(),this.hasBeenOpened_=this.hasBeenFilled_=!0,this.endDialog=p("p",{className:"vjs-control-text",textContent:this.localize("End of dialog window.")}),this.el().appendChild(this.endDialog),this.setDefaults(),void 0===t.persistTextTrackSettings&&(this.options_.persistTextTrackSettings=this.options_.playerOptions.persistTextTrackSettings),this.on(this.$(".vjs-done-button"),"click",()=>{this.saveSettings(),this.close()}),this.on(this.$(".vjs-default-button"),"click",()=>{this.setDefaults(),this.updateDisplay()}),q(Er,e=>{this.on(this.$(e.selector),"change",this.updateDisplay)}),this.options_.persistTextTrackSettings&&this.restoreSettings()}dispose(){this.endDialog=null,super.dispose()}createElSelect_(e,t="",s="label"){e=Er[e];const i=e.id.replace("%s",this.id_),r=[t,i].join(" ").trim();return[`<${s} id="${i}" class="${"label"===s?"vjs-label":""}">`,this.localize(e.label),`</${s}>`,`<select aria-labelledby="${r}">`].concat(e.options.map(e=>{var t=i+"-"+e[1].replace(/\W+/g,"");return[`<option id="${t}" value="${e[0]}" `,`aria-labelledby="${r} ${t}">`,this.localize(e[1]),"</option>"].join("")})).concat("</select>").join("")}createElFgColor_(){var e="captions-text-legend-"+this.id_;return['<fieldset class="vjs-fg vjs-track-setting">',`<legend id="${e}">`,this.localize("Text"),"</legend>",'<span class="vjs-text-color">',this.createElSelect_("color",e),"</span>",'<span class="vjs-text-opacity vjs-opacity">',this.createElSelect_("textOpacity",e),"</span>","</fieldset>"].join("")}createElBgColor_(){var e="captions-background-"+this.id_;return['<fieldset class="vjs-bg vjs-track-setting">',`<legend id="${e}">`,this.localize("Text Background"),"</legend>",'<span class="vjs-bg-color">',this.createElSelect_("backgroundColor",e),"</span>",'<span class="vjs-bg-opacity vjs-opacity">',this.createElSelect_("backgroundOpacity",e),"</span>","</fieldset>"].join("")}createElWinColor_(){var e="captions-window-"+this.id_;return['<fieldset class="vjs-window vjs-track-setting">',`<legend id="${e}">`,this.localize("Caption Area Background"),"</legend>",'<span class="vjs-window-color">',this.createElSelect_("windowColor",e),"</span>",'<span class="vjs-window-opacity vjs-opacity">',this.createElSelect_("windowOpacity",e),"</span>","</fieldset>"].join("")}createElColors_(){return p("div",{className:"vjs-track-settings-colors",innerHTML:[this.createElFgColor_(),this.createElBgColor_(),this.createElWinColor_()].join("")})}createElFont_(){return p("div",{className:"vjs-track-settings-font",innerHTML:['<fieldset class="vjs-font-percent vjs-track-setting">',this.createElSelect_("fontPercent","","legend"),"</fieldset>",'<fieldset class="vjs-edge-style vjs-track-setting">',this.createElSelect_("edgeStyle","","legend"),"</fieldset>",'<fieldset class="vjs-font-family vjs-track-setting">',this.createElSelect_("fontFamily","","legend"),"</fieldset>"].join("")})}createElControls_(){var e=this.localize("restore all settings to the default values");return p("div",{className:"vjs-track-settings-controls",innerHTML:[`<button type="button" class="vjs-default-button" title="${e}">`,this.localize("Reset"),`<span class="vjs-control-text"> ${e}</span>`,"</button>",`<button type="button" class="vjs-done-button">${this.localize("Done")}</button>`].join("")})}content(){return[this.createElColors_(),this.createElFont_(),this.createElControls_()]}label(){return this.localize("Caption Settings Dialog")}description(){return this.localize("Beginning of dialog window. Escape will cancel and close the window.")}buildCSSClass(){return super.buildCSSClass()+" vjs-text-track-settings"}getValues(){return X(Er,(e,t,s)=>{i=this.$(t.selector),t=t.parser;var i=Sr(i.options[i.options.selectedIndex].value,t);return void 0!==i&&(e[s]=i),e},{})}setValues(n){q(Er,(e,t)=>{var s=this.$(e.selector),i=n[t],r=e.parser;if(i)for(let e=0;e<s.options.length;e++)if(Sr(s.options[e].value,r)===i){s.selectedIndex=e;break}})}setDefaults(){q(Er,e=>{var t=e.hasOwnProperty("default")?e.default:0;this.$(e.selector).selectedIndex=t})}restoreSettings(){let e;try{e=JSON.parse(window.localStorage.getItem(mr))}catch(e){h.warn(e)}e&&this.setValues(e)}saveSettings(){if(this.options_.persistTextTrackSettings){var e=this.getValues();try{Object.keys(e).length?window.localStorage.setItem(mr,JSON.stringify(e)):window.localStorage.removeItem(mr)}catch(e){h.warn(e)}}}updateDisplay(){var e=this.player_.getChild("textTrackDisplay");e&&e.updateDisplay()}conditionalBlur_(){this.previouslyActiveEl_=null;var e=this.player_.controlBar,t=e&&e.subsCapsButton,e=e&&e.captionsButton;t?t.focus():e&&e.focus()}handleLanguagechange(){this.fill()}}b.registerComponent("TextTrackSettings",xr);class Pr extends b{constructor(e,t){let s=t.ResizeObserver||window.ResizeObserver;super(e,c({createEl:!(s=null===t.ResizeObserver?!1:s),reportTouchActivity:!1},t)),this.ResizeObserver=t.ResizeObserver||window.ResizeObserver,this.loadListener_=null,this.resizeObserver_=null,this.debouncedHandler_=ot(()=>{this.resizeHandler()},100,!1,this),s?(this.resizeObserver_=new this.ResizeObserver(this.debouncedHandler_),this.resizeObserver_.observe(e.el())):(this.loadListener_=()=>{if(this.el_&&this.el_.contentWindow){const t=this.debouncedHandler_;let e=this.unloadListener_=function(){f(this,"resize",t),f(this,"unload",e),e=null};_(this.el_.contentWindow,"unload",e),_(this.el_.contentWindow,"resize",t)}},this.one("load",this.loadListener_))}createEl(){return super.createEl("iframe",{className:"vjs-resize-manager",tabIndex:-1,title:this.localize("No content")},{"aria-hidden":"true"})}resizeHandler(){this.player_&&this.player_.trigger&&this.player_.trigger("playerresize")}dispose(){this.debouncedHandler_&&this.debouncedHandler_.cancel(),this.resizeObserver_&&(this.player_.el()&&this.resizeObserver_.unobserve(this.player_.el()),this.resizeObserver_.disconnect()),this.loadListener_&&this.off("load",this.loadListener_),this.el_&&this.el_.contentWindow&&this.unloadListener_&&this.unloadListener_.call(this.el_.contentWindow),this.ResizeObserver=null,this.resizeObserver=null,this.debouncedHandler_=null,this.loadListener_=null,super.dispose()}}b.registerComponent("ResizeManager",Pr);const jr={trackingThreshold:20,liveTolerance:15};class Ar extends b{constructor(e,t){super(e,c(jr,t,{createEl:!1})),this.trackLiveHandler_=()=>this.trackLive_(),this.handlePlay_=e=>this.handlePlay(e),this.handleFirstTimeupdate_=e=>this.handleFirstTimeupdate(e),this.handleSeeked_=e=>this.handleSeeked(e),this.seekToLiveEdge_=e=>this.seekToLiveEdge(e),this.reset_(),this.on(this.player_,"durationchange",e=>this.handleDurationchange(e)),this.on(this.player_,"canplay",()=>this.toggleTracking())}trackLive_(){var t=this.player_.seekable();if(t&&t.length){var t=Number(window.performance.now().toFixed(4)),s=-1===this.lastTime_?0:(t-this.lastTime_)/1e3,t=(this.lastTime_=t,this.pastSeekEnd_=this.pastSeekEnd()+s,this.liveCurrentTime()),s=this.player_.currentTime();let e=this.player_.paused()||this.seekedBehindLive_||Math.abs(t-s)>this.options_.liveTolerance;(e=this.timeupdateSeen_&&t!==1/0?e:!1)!==this.behindLiveEdge_&&(this.behindLiveEdge_=e,this.trigger("liveedgechange"))}}handleDurationchange(){this.toggleTracking()}toggleTracking(){this.player_.duration()===1/0&&this.liveWindow()>=this.options_.trackingThreshold?(this.player_.options_.liveui&&this.player_.addClass("vjs-liveui"),this.startTracking()):(this.player_.removeClass("vjs-liveui"),this.stopTracking())}startTracking(){this.isTracking()||(this.timeupdateSeen_||(this.timeupdateSeen_=this.player_.hasStarted()),this.trackingInterval_=this.setInterval(this.trackLiveHandler_,30),this.trackLive_(),this.on(this.player_,["play","pause"],this.trackLiveHandler_),this.timeupdateSeen_?this.on(this.player_,"seeked",this.handleSeeked_):(this.one(this.player_,"play",this.handlePlay_),this.one(this.player_,"timeupdate",this.handleFirstTimeupdate_)))}handleFirstTimeupdate(){this.timeupdateSeen_=!0,this.on(this.player_,"seeked",this.handleSeeked_)}handleSeeked(){var e=Math.abs(this.liveCurrentTime()-this.player_.currentTime());this.seekedBehindLive_=this.nextSeekedFromUser_&&2<e,this.nextSeekedFromUser_=!1,this.trackLive_()}handlePlay(){this.one(this.player_,"timeupdate",this.seekToLiveEdge_)}reset_(){this.lastTime_=-1,this.pastSeekEnd_=0,this.lastSeekEnd_=-1,this.behindLiveEdge_=!0,this.timeupdateSeen_=!1,this.seekedBehindLive_=!1,this.nextSeekedFromUser_=!1,this.clearInterval(this.trackingInterval_),this.trackingInterval_=null,this.off(this.player_,["play","pause"],this.trackLiveHandler_),this.off(this.player_,"seeked",this.handleSeeked_),this.off(this.player_,"play",this.handlePlay_),this.off(this.player_,"timeupdate",this.handleFirstTimeupdate_),this.off(this.player_,"timeupdate",this.seekToLiveEdge_)}nextSeekedFromUser(){this.nextSeekedFromUser_=!0}stopTracking(){this.isTracking()&&(this.reset_(),this.trigger("liveedgechange"))}seekableEnd(){var e=this.player_.seekable(),t=[];let s=e?e.length:0;for(;s--;)t.push(e.end(s));return t.length?t.sort()[t.length-1]:1/0}seekableStart(){var e=this.player_.seekable(),t=[];let s=e?e.length:0;for(;s--;)t.push(e.start(s));return t.length?t.sort()[0]:0}liveWindow(){var e=this.liveCurrentTime();return e===1/0?0:e-this.seekableStart()}isLive(){return this.isTracking()}atLiveEdge(){return!this.behindLiveEdge()}liveCurrentTime(){return this.pastSeekEnd()+this.seekableEnd()}pastSeekEnd(){var e=this.seekableEnd();return-1!==this.lastSeekEnd_&&e!==this.lastSeekEnd_&&(this.pastSeekEnd_=0),this.lastSeekEnd_=e,this.pastSeekEnd_}behindLiveEdge(){return this.behindLiveEdge_}isTracking(){return"number"==typeof this.trackingInterval_}seekToLiveEdge(){this.seekedBehindLive_=!1,this.atLiveEdge()||(this.nextSeekedFromUser_=!1,this.player_.currentTime(this.liveCurrentTime()))}dispose(){this.stopTracking(),super.dispose()}}b.registerComponent("LiveTracker",Ar);class Ir extends b{constructor(e,t){super(e,t),this.on("statechanged",e=>this.updateDom_()),this.updateDom_()}createEl(){return this.els={title:p("div",{className:"vjs-title-bar-title",id:"vjs-title-bar-title-"+m++}),description:p("div",{className:"vjs-title-bar-description",id:"vjs-title-bar-description-"+m++})},p("div",{className:"vjs-title-bar"},{},Object.values(this.els))}updateDom_(){var e=this.player_.tech_;const i=e&&e.el_,r={title:"aria-labelledby",description:"aria-describedby"};["title","description"].forEach(e=>{var t=this.state[e],s=this.els[e],e=r[e];De(s),t&&ye(s,t),i&&(i.removeAttribute(e),t)&&i.setAttribute(e,s.id)}),this.state.title||this.state.description?this.show():this.hide()}update(e){this.setState(e)}dispose(){var e=this.player_.tech_,e=e&&e.el_;e&&(e.removeAttribute("aria-labelledby"),e.removeAttribute("aria-describedby")),super.dispose(),this.els=null}}b.registerComponent("TitleBar",Ir);function Or(s){const i=s.el();if(!i.resetSourceWatch_){const t={},e=Fr(s),r=t=>(...e)=>{e=t.apply(i,e);return Lr(s),e};["append","appendChild","insertAdjacentHTML"].forEach(e=>{i[e]&&(t[e]=i[e],i[e]=r(t[e]))}),Object.defineProperty(i,"innerHTML",c(e,{set:r(e.set)})),i.resetSourceWatch_=()=>{i.resetSourceWatch_=null,Object.keys(t).forEach(e=>{i[e]=t[e]}),Object.defineProperty(i,"innerHTML",e)},s.one("sourceset",i.resetSourceWatch_)}}function Mr(s){if(s.featuresSourceset){const i=s.el();if(!i.resetSourceset_){e=s;const t=Dr([e.el(),window.HTMLMediaElement.prototype,Rr],"src");var e;const r=i.setAttribute,n=i.load;Object.defineProperty(i,"src",c(t,{set:e=>{e=t.set.call(i,e);return s.triggerSourceset(i.src),e}})),i.setAttribute=(e,t)=>{t=r.call(i,e,t);return/src/i.test(e)&&s.triggerSourceset(i.src),t},i.load=()=>{var e=n.call(i);return Lr(s)||(s.triggerSourceset(""),Or(s)),e},i.currentSrc?s.triggerSourceset(i.currentSrc):Lr(s)||Or(s),i.resetSourceset_=()=>{i.resetSourceset_=null,i.load=n,i.setAttribute=r,Object.defineProperty(i,"src",t),i.resetSourceWatch_&&i.resetSourceWatch_()}}}}const Lr=t=>{var e=t.el();if(e.hasAttribute("src"))t.triggerSourceset(e.src);else{var s=t.$$("source"),i=[];let e="";if(!s.length)return!1;for(let e=0;e<s.length;e++){var r=s[e].src;r&&-1===i.indexOf(r)&&i.push(r)}if(!i.length)return!1;1===i.length&&(e=i[0]),t.triggerSourceset(e)}return!0},Nr=Object.defineProperty({},"innerHTML",{get(){return this.cloneNode(!0).innerHTML},set(e){for(var t=document.createElement(this.nodeName.toLowerCase()),s=(t.innerHTML=e,document.createDocumentFragment());t.childNodes.length;)s.appendChild(t.childNodes[0]);return this.innerText="",window.Element.prototype.appendChild.call(this,s),this.innerHTML}}),Dr=(t,s)=>{let i={};for(let e=0;e<t.length&&!((i=Object.getOwnPropertyDescriptor(t[e],s))&&i.set&&i.get);e++);return i.enumerable=!0,i.configurable=!0,i},Fr=e=>Dr([e.el(),window.HTMLMediaElement.prototype,window.Element.prototype,Nr],"innerHTML"),Rr=Object.defineProperty({},"src",{get(){return this.hasAttribute("src")?es(window.Element.prototype.getAttribute.call(this,"src")):""},set(e){return window.Element.prototype.setAttribute.call(this,"src",e),e}});class A extends P{constructor(e,t){super(e,t);t=e.source;let s=!1;if(this.featuresVideoFrameCallback=this.featuresVideoFrameCallback&&"VIDEO"===this.el_.tagName,t&&(this.el_.currentSrc!==t.src||e.tag&&3===e.tag.initNetworkState_)?this.setSource(t):this.handleLateInit_(this.el_),e.enableSourceset&&this.setupSourcesetHandling_(),this.isScrubbing_=!1,this.el_.hasChildNodes()){var i=this.el_.childNodes;let e=i.length;for(var r=[];e--;){var n=i[e];"track"===n.nodeName.toLowerCase()&&(this.featuresNativeTextTracks?(this.remoteTextTrackEls().addTrackElement_(n),this.remoteTextTracks().addTrack(n.track),this.textTracks().addTrack(n.track),s||this.el_.hasAttribute("crossorigin")||!ts(n.src)||(s=!0)):r.push(n))}for(let e=0;e<r.length;e++)this.el_.removeChild(r[e])}this.proxyNativeTracks_(),this.featuresNativeTextTracks&&s&&h.warn("Text Tracks are being loaded from another origin but the crossorigin attribute isn't used.\nThis may prevent text tracks from loading."),this.restoreMetadataTracksInIOSNativePlayer_(),(ue||ce)&&!0===e.nativeControlsForTouch&&this.setControls(!0),this.proxyWebkitFullscreen_(),this.triggerReady()}dispose(){this.el_&&this.el_.resetSourceset_&&this.el_.resetSourceset_(),A.disposeMediaElement(this.el_),this.options_=null,super.dispose()}setupSourcesetHandling_(){Mr(this)}restoreMetadataTracksInIOSNativePlayer_(){const s=this.textTracks();let i;const e=()=>{i=[];for(let e=0;e<s.length;e++){var t=s[e];"metadata"===t.kind&&i.push({track:t,storedMode:t.mode})}},r=(e(),s.addEventListener("change",e),this.on("dispose",()=>s.removeEventListener("change",e)),()=>{for(let e=0;e<i.length;e++){var t=i[e];"disabled"===t.track.mode&&t.track.mode!==t.storedMode&&(t.track.mode=t.storedMode)}s.removeEventListener("change",r)});this.on("webkitbeginfullscreen",()=>{s.removeEventListener("change",e),s.removeEventListener("change",r),s.addEventListener("change",r)}),this.on("webkitendfullscreen",()=>{s.removeEventListener("change",e),s.addEventListener("change",e),s.removeEventListener("change",r)})}overrideNative_(e,t){if(t===this[`featuresNative${e}Tracks`]){const s=e.toLowerCase();this[s+"TracksListeners_"]&&Object.keys(this[s+"TracksListeners_"]).forEach(e=>{this.el()[s+"Tracks"].removeEventListener(e,this[s+"TracksListeners_"][e])}),this[`featuresNative${e}Tracks`]=!t,this[s+"TracksListeners_"]=null,this.proxyNativeTracksForType_(s)}}overrideNativeAudioTracks(e){this.overrideNative_("Audio",e)}overrideNativeVideoTracks(e){this.overrideNative_("Video",e)}proxyNativeTracksForType_(s){var e=w[s];const i=this.el()[e.getterName],r=this[e.getterName]();if(this[`featuresNative${e.capitalName}Tracks`]&&i&&i.addEventListener){const n={change:e=>{var t={type:"change",target:r,currentTarget:r,srcElement:r};r.trigger(t),"text"===s&&this[Ts.remoteText.getterName]().trigger(t)},addtrack(e){r.addTrack(e.track)},removetrack(e){r.removeTrack(e.track)}},t=function(){var e=[];for(let s=0;s<r.length;s++){let t=!1;for(let e=0;e<i.length;e++)if(i[e]===r[s]){t=!0;break}t||e.push(r[s])}for(;e.length;)r.removeTrack(e.shift())};this[e.getterName+"Listeners_"]=n,Object.keys(n).forEach(t=>{const s=n[t];i.addEventListener(t,s),this.on("dispose",e=>i.removeEventListener(t,s))}),this.on("loadstart",t),this.on("dispose",e=>this.off("loadstart",t))}}proxyNativeTracks_(){w.names.forEach(e=>{this.proxyNativeTracksForType_(e)})}createEl(){let t=this.options_.tag;t&&(this.options_.playerElIngest||this.movingMediaElementInDOM)||(t?(e=t.cloneNode(!0),t.parentNode&&t.parentNode.insertBefore(e,t),A.disposeMediaElement(t),t=e):(t=document.createElement("video"),e=c({},this.options_.tag&&Se(this.options_.tag)),ue&&!0===this.options_.nativeControlsForTouch||delete e.controls,Ee(t,Object.assign(e,{id:this.options_.techId,class:"vjs-tech"}))),t.playerId=this.options_.playerId),"undefined"!=typeof this.options_.preload&&Pe(t,"preload",this.options_.preload),void 0!==this.options_.disablePictureInPicture&&(t.disablePictureInPicture=this.options_.disablePictureInPicture);var e,s=["loop","muted","playsinline","autoplay"];for(let e=0;e<s.length;e++){var i=s[e],r=this.options_[i];"undefined"!=typeof r&&(r?Pe(t,i,i):je(t,i),t[i]=r)}return t}handleLateInit_(e){if(0!==e.networkState&&3!==e.networkState)if(0===e.readyState){let e=!1;const t=function(){e=!0},s=(this.on("loadstart",t),function(){e||this.trigger("loadstart")});this.on("loadedmetadata",s),void this.ready(function(){this.off("loadstart",t),this.off("loadedmetadata",s),e||this.trigger("loadstart")})}else{const i=["loadstart"];i.push("loadedmetadata"),2<=e.readyState&&i.push("loadeddata"),3<=e.readyState&&i.push("canplay"),4<=e.readyState&&i.push("canplaythrough"),this.ready(function(){i.forEach(function(e){this.trigger(e)},this)})}}setScrubbing(e){this.isScrubbing_=e}scrubbing(){return this.isScrubbing_}setCurrentTime(e){try{this.isScrubbing_&&this.el_.fastSeek&&pe?this.el_.fastSeek(e):this.el_.currentTime=e}catch(e){h(e,"Video is not ready. (Video.js)")}}duration(){if(this.el_.duration===1/0&&o&&u&&0===this.el_.currentTime){const e=()=>{0<this.el_.currentTime&&(this.el_.duration===1/0&&this.trigger("durationchange"),this.off("timeupdate",e))};return this.on("timeupdate",e),NaN}return this.el_.duration||NaN}width(){return this.el_.offsetWidth}height(){return this.el_.offsetHeight}proxyWebkitFullscreen_(){if("webkitDisplayingFullscreen"in this.el_){const e=function(){this.trigger("fullscreenchange",{isFullscreen:!1}),this.el_.controls&&!this.options_.nativeControlsForTouch&&this.controls()&&(this.el_.controls=!1)},t=function(){"webkitPresentationMode"in this.el_&&"picture-in-picture"!==this.el_.webkitPresentationMode&&(this.one("webkitendfullscreen",e),this.trigger("fullscreenchange",{isFullscreen:!0,nativeIOSFullscreen:!0}))};this.on("webkitbeginfullscreen",t),this.on("dispose",()=>{this.off("webkitbeginfullscreen",t),this.off("webkitendfullscreen",e)})}}supportsFullScreen(){return"function"==typeof this.el_.webkitEnterFullScreen}enterFullScreen(){const e=this.el_;if(e.paused&&e.networkState<=e.HAVE_METADATA)k(this.el_.play()),this.setTimeout(function(){e.pause();try{e.webkitEnterFullScreen()}catch(e){this.trigger("fullscreenerror",e)}},0);else try{e.webkitEnterFullScreen()}catch(e){this.trigger("fullscreenerror",e)}}exitFullScreen(){this.el_.webkitDisplayingFullscreen?this.el_.webkitExitFullScreen():this.trigger("fullscreenerror",new Error("The video is not fullscreen"))}requestPictureInPicture(){return this.el_.requestPictureInPicture()}requestVideoFrameCallback(e){return this.featuresVideoFrameCallback&&!this.el_.webkitKeys?this.el_.requestVideoFrameCallback(e):super.requestVideoFrameCallback(e)}cancelVideoFrameCallback(e){this.featuresVideoFrameCallback&&!this.el_.webkitKeys?this.el_.cancelVideoFrameCallback(e):super.cancelVideoFrameCallback(e)}src(e){if(void 0===e)return this.el_.src;this.setSrc(e)}reset(){A.resetMediaElement(this.el_)}currentSrc(){return this.currentSource_?this.currentSource_.src:this.el_.currentSrc}setControls(e){this.el_.controls=!!e}addTextTrack(e,t,s){return this.featuresNativeTextTracks?this.el_.addTextTrack(e,t,s):super.addTextTrack(e,t,s)}createRemoteTextTrack(e){var t;return this.featuresNativeTextTracks?(t=document.createElement("track"),e.kind&&(t.kind=e.kind),e.label&&(t.label=e.label),(e.language||e.srclang)&&(t.srclang=e.language||e.srclang),e.default&&(t.default=e.default),e.id&&(t.id=e.id),e.src&&(t.src=e.src),t):super.createRemoteTextTrack(e)}addRemoteTextTrack(e,t){e=super.addRemoteTextTrack(e,t);return this.featuresNativeTextTracks&&this.el().appendChild(e),e}removeRemoteTextTrack(t){if(super.removeRemoteTextTrack(t),this.featuresNativeTextTracks){var s=this.$$("track");let e=s.length;for(;e--;)t!==s[e]&&t!==s[e].track||this.el().removeChild(s[e])}}getVideoPlaybackQuality(){var e;return"function"==typeof this.el().getVideoPlaybackQuality?this.el().getVideoPlaybackQuality():(e={},"undefined"!=typeof this.el().webkitDroppedFrameCount&&"undefined"!=typeof this.el().webkitDecodedFrameCount&&(e.droppedVideoFrames=this.el().webkitDroppedFrameCount,e.totalVideoFrames=this.el().webkitDecodedFrameCount),window.performance&&(e.creationTime=window.performance.now()),e)}}Y(A,"TEST_VID",function(){var e,t;if(me())return e=document.createElement("video"),(t=document.createElement("track")).kind="captions",t.srclang="en",t.label="English",e.appendChild(t),e}),A.isSupported=function(){try{A.TEST_VID.volume=.5}catch(e){return!1}return!(!A.TEST_VID||!A.TEST_VID.canPlayType)},A.canPlayType=function(e){return A.TEST_VID.canPlayType(e)},A.canPlaySource=function(e,t){return A.canPlayType(e.type)},A.canControlVolume=function(){try{const t=A.TEST_VID.volume;A.TEST_VID.volume=t/2+.1;var e=t!==A.TEST_VID.volume;return e&&d?(window.setTimeout(()=>{A&&A.prototype&&(A.prototype.featuresVolumeControl=t!==A.TEST_VID.volume)}),!1):e}catch(e){return!1}},A.canMuteVolume=function(){try{var e=A.TEST_VID.muted;return A.TEST_VID.muted=!e,A.TEST_VID.muted?Pe(A.TEST_VID,"muted","muted"):je(A.TEST_VID,"muted"),e!==A.TEST_VID.muted}catch(e){return!1}},A.canControlPlaybackRate=function(){if(o&&u&&ne<58)return!1;try{var e=A.TEST_VID.playbackRate;return A.TEST_VID.playbackRate=e/2+.1,e!==A.TEST_VID.playbackRate}catch(e){return!1}},A.canOverrideAttributes=function(){try{var e=()=>{};Object.defineProperty(document.createElement("video"),"src",{get:e,set:e}),Object.defineProperty(document.createElement("audio"),"src",{get:e,set:e}),Object.defineProperty(document.createElement("video"),"innerHTML",{get:e,set:e}),Object.defineProperty(document.createElement("audio"),"innerHTML",{get:e,set:e})}catch(e){return!1}return!0},A.supportsNativeTextTracks=function(){return pe||d&&u},A.supportsNativeVideoTracks=function(){return!(!A.TEST_VID||!A.TEST_VID.videoTracks)},A.supportsNativeAudioTracks=function(){return!(!A.TEST_VID||!A.TEST_VID.audioTracks)},A.Events=["loadstart","suspend","abort","error","emptied","stalled","loadedmetadata","loadeddata","canplay","canplaythrough","playing","waiting","seeking","seeked","ended","durationchange","timeupdate","progress","play","pause","ratechange","resize","volumechange"],[["featuresMuteControl","canMuteVolume"],["featuresPlaybackRate","canControlPlaybackRate"],["featuresSourceset","canOverrideAttributes"],["featuresNativeTextTracks","supportsNativeTextTracks"],["featuresNativeVideoTracks","supportsNativeVideoTracks"],["featuresNativeAudioTracks","supportsNativeAudioTracks"]].forEach(function([e,t]){Y(A.prototype,e,()=>A[t](),!0)}),A.prototype.featuresVolumeControl=A.canControlVolume(),A.prototype.movingMediaElementInDOM=!d,A.prototype.featuresFullscreenResize=!0,A.prototype.featuresProgressEvents=!0,A.prototype.featuresTimeupdateEvents=!0,A.prototype.featuresVideoFrameCallback=!(!A.TEST_VID||!A.TEST_VID.requestVideoFrameCallback),A.disposeMediaElement=function(e){if(e){for(e.parentNode&&e.parentNode.removeChild(e);e.hasChildNodes();)e.removeChild(e.firstChild);if(e.removeAttribute("src"),"function"==typeof e.load)try{e.load()}catch(e){}}},A.resetMediaElement=function(t){if(t){var s=t.querySelectorAll("source");let e=s.length;for(;e--;)t.removeChild(s[e]);if(t.removeAttribute("src"),"function"==typeof t.load)try{t.load()}catch(e){}}},["muted","defaultMuted","autoplay","controls","loop","playsinline"].forEach(function(e){A.prototype[e]=function(){return this.el_[e]||this.el_.hasAttribute(e)}}),["muted","defaultMuted","autoplay","loop","playsinline"].forEach(function(t){A.prototype["set"+y(t)]=function(e){(this.el_[t]=e)?this.el_.setAttribute(t,t):this.el_.removeAttribute(t)}}),["paused","currentTime","buffered","volume","poster","preload","error","seeking","seekable","ended","playbackRate","defaultPlaybackRate","disablePictureInPicture","played","networkState","readyState","videoWidth","videoHeight","crossOrigin"].forEach(function(e){A.prototype[e]=function(){return this.el_[e]}}),["volume","src","poster","preload","playbackRate","defaultPlaybackRate","disablePictureInPicture","crossOrigin"].forEach(function(t){A.prototype["set"+y(t)]=function(e){this.el_[t]=e}}),["pause","load","play"].forEach(function(e){A.prototype[e]=function(){return this.el_[e]()}}),P.withSourceHandlers(A),A.nativeSourceHandler={},A.nativeSourceHandler.canPlayType=function(e){try{return A.TEST_VID.canPlayType(e)}catch(e){return""}},A.nativeSourceHandler.canHandleSource=function(e,t){return e.type?A.nativeSourceHandler.canPlayType(e.type):e.src?(e=ss(e.src),A.nativeSourceHandler.canPlayType("video/"+e)):""},A.nativeSourceHandler.handleSource=function(e,t,s){t.setSrc(e.src)},A.nativeSourceHandler.dispose=function(){},A.registerSourceHandler(A.nativeSourceHandler),P.registerTech("Html5",A);const Br=["progress","abort","suspend","emptied","stalled","loadedmetadata","loadeddata","timeupdate","resize","volumechange","texttrackchange"],Hr={canplay:"CanPlay",canplaythrough:"CanPlayThrough",playing:"Playing",seeked:"Seeked"},Vr=["tiny","xsmall","small","medium","large","xlarge","huge"],$r={},zr=(Vr.forEach(e=>{var t="x"===e.charAt(0)?"x-"+e.substring(1):e;$r[e]="vjs-layout-"+t}),{tiny:210,xsmall:320,small:425,medium:768,large:1440,xlarge:2560,huge:1/0});class I extends b{constructor(e,t,s){if(e.id=e.id||t.id||"vjs_video_"+m++,(t=Object.assign(I.getTagSettings(e),t)).initChildren=!1,t.createEl=!1,t.evented=!1,t.reportTouchActivity=!1,t.language||(i=e.closest("[lang]"))&&(t.language=i.getAttribute("lang")),super(null,t,s),this.boundDocumentFullscreenChange_=e=>this.documentFullscreenChange_(e),this.boundFullWindowOnEscKey_=e=>this.fullWindowOnEscKey(e),this.boundUpdateStyleEl_=e=>this.updateStyleEl_(e),this.boundApplyInitTime_=e=>this.applyInitTime_(e),this.boundUpdateCurrentBreakpoint_=e=>this.updateCurrentBreakpoint_(e),this.boundHandleTechClick_=e=>this.handleTechClick_(e),this.boundHandleTechDoubleClick_=e=>this.handleTechDoubleClick_(e),this.boundHandleTechTouchStart_=e=>this.handleTechTouchStart_(e),this.boundHandleTechTouchMove_=e=>this.handleTechTouchMove_(e),this.boundHandleTechTouchEnd_=e=>this.handleTechTouchEnd_(e),this.boundHandleTechTap_=e=>this.handleTechTap_(e),this.isFullscreen_=!1,this.log=K(this.id_),this.fsApi_=H,this.isPosterFromTech_=!1,this.queuedCallbacks_=[],this.isReady_=!1,this.hasStarted_=!1,this.userActive_=!1,this.debugEnabled_=!1,this.audioOnlyMode_=!1,this.audioPosterMode_=!1,this.audioOnlyCache_={playerHeight:null,hiddenChildren:[]},!this.options_||!this.options_.techOrder||!this.options_.techOrder.length)throw new Error("No techOrder specified. Did you overwrite videojs.options instead of just changing the properties you want to override?");if(this.tag=e,this.tagAttributes=e&&Se(e),this.language(this.options_.language),t.languages){const r={};Object.getOwnPropertyNames(t.languages).forEach(function(e){r[e.toLowerCase()]=t.languages[e]}),this.languages_=r}else this.languages_=I.prototype.options_.languages;this.resetCache_(),this.poster_=t.poster||"",this.controls_=!!t.controls,e.controls=!1,e.removeAttribute("controls"),this.changingSrc_=!1,this.playCallbacks_=[],this.playTerminatedQueue_=[],e.hasAttribute("autoplay")?this.autoplay(!0):this.autoplay(this.options_.autoplay),t.plugins&&Object.keys(t.plugins).forEach(e=>{if("function"!=typeof this[e])throw new Error(`plugin "${e}" does not exist`)}),this.scrubbing_=!1,this.el_=this.createEl(),yt(this,{eventBusKey:"el_"}),this.fsApi_.requestFullscreen&&(_(document,this.fsApi_.fullscreenchange,this.boundDocumentFullscreenChange_),this.on(this.fsApi_.fullscreenchange,this.boundDocumentFullscreenChange_)),this.fluid_&&this.on(["playerreset","resize"],this.boundUpdateStyleEl_);var i=c(this.options_),s=(t.plugins&&Object.keys(t.plugins).forEach(e=>{this[e](t.plugins[e])}),t.debug&&this.debug(!0),this.options_.playerOptions=i,this.middleware_=[],this.playbackRates(t.playbackRates),this.initChildren(),this.isAudio("audio"===e.nodeName.toLowerCase()),this.controls()?this.addClass("vjs-controls-enabled"):this.addClass("vjs-controls-disabled"),this.el_.setAttribute("role","region"),this.isAudio()?this.el_.setAttribute("aria-label",this.localize("Audio Player")):this.el_.setAttribute("aria-label",this.localize("Video Player")),this.isAudio()&&this.addClass("vjs-audio"),ue&&this.addClass("vjs-touch-enabled"),d||this.addClass("vjs-workinghover"),I.players[this.id_]=this,D.split(".")[0]);this.addClass("vjs-v"+s),this.userActive(!0),this.reportUserActivity(),this.one("play",e=>this.listenForUserActivity_(e)),this.on("keydown",e=>this.handleKeyDown(e)),this.on("languagechange",e=>this.handleLanguagechange(e)),this.breakpoints(this.options_.breakpoints),this.responsive(this.options_.responsive),this.on("ready",()=>{this.audioPosterMode(this.options_.audioPosterMode),this.audioOnlyMode(this.options_.audioOnlyMode)})}dispose(){var e;this.trigger("dispose"),this.off("dispose"),f(document,this.fsApi_.fullscreenchange,this.boundDocumentFullscreenChange_),f(document,"keydown",this.boundFullWindowOnEscKey_),this.styleEl_&&this.styleEl_.parentNode&&(this.styleEl_.parentNode.removeChild(this.styleEl_),this.styleEl_=null),I.players[this.id_]=null,this.tag&&this.tag.player&&(this.tag.player=null),this.el_&&this.el_.player&&(this.el_.player=null),this.tech_&&(this.tech_.dispose(),this.isPosterFromTech_=!1,this.poster_=""),this.playerElIngest_&&(this.playerElIngest_=null),this.tag&&(this.tag=null),e=this,Qs[e.id()]=null,E.names.forEach(e=>{e=this[E[e].getterName]();e&&e.off&&e.off()}),super.dispose({restoreEl:this.options_.restoreEl})}createEl(){let t=this.tag,s,e=this.playerElIngest_=t.parentNode&&t.parentNode.hasAttribute&&t.parentNode.hasAttribute("data-vjs-player");const i="video-js"===this.tag.tagName.toLowerCase(),r=(e?s=this.el_=t.parentNode:i||(s=this.el_=super.createEl("div")),Se(t));if(i){for(s=this.el_=t,t=this.tag=document.createElement("video");s.children.length;)t.appendChild(s.firstChild);Te(s,"video-js")||ke(s,"video-js"),s.appendChild(t),e=this.playerElIngest_=s,Object.keys(s).forEach(e=>{try{t[e]=s[e]}catch(e){}})}t.setAttribute("tabindex","-1"),r.tabindex="-1",u&&le&&(t.setAttribute("role","application"),r.role="application"),t.removeAttribute("width"),t.removeAttribute("height"),"width"in r&&delete r.width,"height"in r&&delete r.height,Object.getOwnPropertyNames(r).forEach(function(e){i&&"class"===e||s.setAttribute(e,r[e]),i&&t.setAttribute(e,r[e])}),t.playerId=t.id,t.id+="_html5_api",t.className="vjs-tech",(t.player=s.player=this).addClass("vjs-paused"),!0!==window.VIDEOJS_NO_DYNAMIC_STYLE&&(this.styleEl_=Ye("vjs-styles-dimensions"),n=Ve(".vjs-styles-defaults"),(a=Ve("head")).insertBefore(this.styleEl_,n?n.nextSibling:a.firstChild)),this.fill_=!1,this.fluid_=!1,this.width(this.options_.width),this.height(this.options_.height),this.fill(this.options_.fill),this.fluid(this.options_.fluid),this.aspectRatio(this.options_.aspectRatio),this.crossOrigin(this.options_.crossOrigin||this.options_.crossorigin);var n,a,o=t.getElementsByTagName("a");for(let e=0;e<o.length;e++){var l=o.item(e);ke(l,"vjs-hidden"),l.setAttribute("hidden","hidden")}return t.initNetworkState_=t.networkState,t.parentNode&&!e&&t.parentNode.insertBefore(s,t),be(t,s),this.children_.unshift(t),this.el_.setAttribute("lang",this.language_),this.el_.setAttribute("translate","no"),this.el_=s}crossOrigin(e){if("undefined"==typeof e)return this.techGet_("crossOrigin");null!==e&&"anonymous"!==e&&"use-credentials"!==e?h.warn(`crossOrigin must be null,  "anonymous" or "use-credentials", given "${e}"`):(this.techCall_("setCrossOrigin",e),this.posterImage&&this.posterImage.crossOrigin(e))}width(e){return this.dimension("width",e)}height(e){return this.dimension("height",e)}dimension(e,t){var s,i=e+"_";if(void 0===t)return this[i]||0;""===t||"auto"===t?(this[i]=void 0,this.updateStyleEl_()):(s=parseFloat(t),isNaN(s)?h.error(`Improper value "${t}" supplied for for `+e):(this[i]=s,this.updateStyleEl_()))}fluid(e){if(void 0===e)return!!this.fluid_;var t;this.fluid_=!!e,ut(this)&&this.off(["playerreset","resize"],this.boundUpdateStyleEl_),e?(this.addClass("vjs-fluid"),this.fill(!1),e=this,t=()=>{this.on(["playerreset","resize"],this.boundUpdateStyleEl_)},ut(e)?t():(e.eventedCallbacks||(e.eventedCallbacks=[]),e.eventedCallbacks.push(t))):this.removeClass("vjs-fluid"),this.updateStyleEl_()}fill(e){if(void 0===e)return!!this.fill_;this.fill_=!!e,e?(this.addClass("vjs-fill"),this.fluid(!1)):this.removeClass("vjs-fill")}aspectRatio(e){if(void 0===e)return this.aspectRatio_;if(!/^\d+\:\d+$/.test(e))throw new Error("Improper value supplied for aspect ratio. The format should be width:height, for example 16:9.");this.aspectRatio_=e,this.fluid(!0),this.updateStyleEl_()}updateStyleEl_(){if(!0===window.VIDEOJS_NO_DYNAMIC_STYLE){const e="number"==typeof this.width_?this.width_:this.options_.width,t="number"==typeof this.height_?this.height_:this.options_.height;var r=this.tech_&&this.tech_.el();void(r&&(0<=e&&(r.width=e),0<=t)&&(r.height=t))}else{let e,t,s,i;r=(s=void 0!==this.aspectRatio_&&"auto"!==this.aspectRatio_?this.aspectRatio_:0<this.videoWidth()?this.videoWidth()+":"+this.videoHeight():"16:9").split(":"),r=r[1]/r[0];e=void 0!==this.width_?this.width_:void 0!==this.height_?this.height_/r:this.videoWidth()||300,t=void 0!==this.height_?this.height_:e*r,i=/^[^a-zA-Z]/.test(this.id())?"dimensions-"+this.id():this.id()+"-dimensions",this.addClass(i),Qe(this.styleEl_,`
      .${i} {
        width: ${e}px;
        height: ${t}px;
      }

      .${i}.vjs-fluid:not(.vjs-audio-only-mode) {
        padding-top: ${100*r}%;
      }
    `)}}loadTech_(e,t){this.tech_&&this.unloadTech_();var s=y(e),i=e.charAt(0).toLowerCase()+e.slice(1);"Html5"!==s&&this.tag&&(P.getTech("Html5").disposeMediaElement(this.tag),this.tag.player=null,this.tag=null),this.techName_=s,this.isReady_=!1;let r=this.autoplay();const n={source:t,autoplay:r="string"==typeof this.autoplay()||!0===this.autoplay()&&this.options_.normalizeAutoplay?!1:r,nativeControlsForTouch:this.options_.nativeControlsForTouch,playerId:this.id(),techId:this.id()+`_${i}_api`,playsinline:this.options_.playsinline,preload:this.options_.preload,loop:this.options_.loop,disablePictureInPicture:this.options_.disablePictureInPicture,muted:this.options_.muted,poster:this.poster(),language:this.language(),playerElIngest:this.playerElIngest_||!1,"vtt.js":this.options_["vtt.js"],canOverridePoster:!!this.options_.techCanOverridePoster,enableSourceset:this.options_.enableSourceset};E.names.forEach(e=>{e=E[e];n[e.getterName]=this[e.privateName]}),Object.assign(n,this.options_[s]),Object.assign(n,this.options_[i]),Object.assign(n,this.options_[e.toLowerCase()]),this.tag&&(n.tag=this.tag),t&&t.src===this.cache_.src&&0<this.cache_.currentTime&&(n.startTime=this.cache_.currentTime);i=P.getTech(e);if(!i)throw new Error(`No Tech named '${s}' exists! '${s}' should be registered using videojs.registerTech()'`);this.tech_=new i(n),this.tech_.ready(v(this,this.handleTechReady_),!0),Ht(this.textTracksJson_||[],this.tech_),Br.forEach(t=>{this.on(this.tech_,t,e=>this[`handleTech${y(t)}_`](e))}),Object.keys(Hr).forEach(t=>{this.on(this.tech_,t,e=>{0===this.tech_.playbackRate()&&this.tech_.seeking()?this.queuedCallbacks_.push({callback:this[`handleTech${Hr[t]}_`].bind(this),event:e}):this[`handleTech${Hr[t]}_`](e)})}),this.on(this.tech_,"loadstart",e=>this.handleTechLoadStart_(e)),this.on(this.tech_,"sourceset",e=>this.handleTechSourceset_(e)),this.on(this.tech_,"waiting",e=>this.handleTechWaiting_(e)),this.on(this.tech_,"ended",e=>this.handleTechEnded_(e)),this.on(this.tech_,"seeking",e=>this.handleTechSeeking_(e)),this.on(this.tech_,"play",e=>this.handleTechPlay_(e)),this.on(this.tech_,"pause",e=>this.handleTechPause_(e)),this.on(this.tech_,"durationchange",e=>this.handleTechDurationChange_(e)),this.on(this.tech_,"fullscreenchange",(e,t)=>this.handleTechFullscreenChange_(e,t)),this.on(this.tech_,"fullscreenerror",(e,t)=>this.handleTechFullscreenError_(e,t)),this.on(this.tech_,"enterpictureinpicture",e=>this.handleTechEnterPictureInPicture_(e)),this.on(this.tech_,"leavepictureinpicture",e=>this.handleTechLeavePictureInPicture_(e)),this.on(this.tech_,"error",e=>this.handleTechError_(e)),this.on(this.tech_,"posterchange",e=>this.handleTechPosterChange_(e)),this.on(this.tech_,"textdata",e=>this.handleTechTextData_(e)),this.on(this.tech_,"ratechange",e=>this.handleTechRateChange_(e)),this.on(this.tech_,"loadedmetadata",this.boundUpdateStyleEl_),this.usingNativeControls(this.techGet_("controls")),this.controls()&&!this.usingNativeControls()&&this.addTechControlsListeners_(),this.tech_.el().parentNode===this.el()||"Html5"===s&&this.tag||be(this.tech_.el(),this.el()),this.tag&&(this.tag.player=null,this.tag=null)}unloadTech_(){E.names.forEach(e=>{e=E[e];this[e.privateName]=this[e.getterName]()}),this.textTracksJson_=Bt(this.tech_),this.isReady_=!1,this.tech_.dispose(),this.tech_=!1,this.isPosterFromTech_&&(this.poster_="",this.trigger("posterchange")),this.isPosterFromTech_=!1}tech(e){return void 0===e&&h.warn("Using the tech directly can be dangerous. I hope you know what you're doing.\nSee https://github.com/videojs/video.js/issues/2617 for more info.\n"),this.tech_}addTechControlsListeners_(){this.removeTechControlsListeners_(),this.on(this.tech_,"click",this.boundHandleTechClick_),this.on(this.tech_,"dblclick",this.boundHandleTechDoubleClick_),this.on(this.tech_,"touchstart",this.boundHandleTechTouchStart_),this.on(this.tech_,"touchmove",this.boundHandleTechTouchMove_),this.on(this.tech_,"touchend",this.boundHandleTechTouchEnd_),this.on(this.tech_,"tap",this.boundHandleTechTap_)}removeTechControlsListeners_(){this.off(this.tech_,"tap",this.boundHandleTechTap_),this.off(this.tech_,"touchstart",this.boundHandleTechTouchStart_),this.off(this.tech_,"touchmove",this.boundHandleTechTouchMove_),this.off(this.tech_,"touchend",this.boundHandleTechTouchEnd_),this.off(this.tech_,"click",this.boundHandleTechClick_),this.off(this.tech_,"dblclick",this.boundHandleTechDoubleClick_)}handleTechReady_(){this.triggerReady(),this.cache_.volume&&this.techCall_("setVolume",this.cache_.volume),this.handleTechPosterChange_(),this.handleTechDurationChange_()}handleTechLoadStart_(){this.removeClass("vjs-ended","vjs-seeking"),this.error(null),this.handleTechDurationChange_(),this.paused()&&this.hasStarted(!1),this.trigger("loadstart"),this.manualAutoplay_(!0===this.autoplay()&&this.options_.normalizeAutoplay?"play":this.autoplay())}manualAutoplay_(t){if(this.tech_&&"string"==typeof t){var s=()=>{const e=this.muted(),t=(this.muted(!0),()=>{this.muted(e)});this.playTerminatedQueue_.push(t);var s=this.play();if(Ft(s))return s.catch(e=>{throw t(),new Error("Rejection at manualAutoplay. Restoring muted value. "+(e||""))})};let e;if("any"!==t||this.muted()?e="muted"!==t||this.muted()?this.play():s():Ft(e=this.play())&&(e=e.catch(s)),Ft(e))return e.then(()=>{this.trigger({type:"autoplay-success",autoplay:t})}).catch(()=>{this.trigger({type:"autoplay-failure",autoplay:t})})}}updateSourceCaches_(e=""){let t=e,s="";"string"!=typeof t&&(t=e.src,s=e.type),this.cache_.source=this.cache_.source||{},this.cache_.sources=this.cache_.sources||[],t&&!s&&(s=((e,t)=>{if(!t)return"";if(e.cache_.source.src===t&&e.cache_.source.type)return e.cache_.source.type;var s=e.cache_.sources.filter(e=>e.src===t);if(s.length)return s[0].type;var i=e.$$("source");for(let e=0;e<i.length;e++){var r=i[e];if(r.type&&r.src&&r.src===t)return r.type}return li(t)})(this,t)),this.cache_.source=c({},e,{src:t,type:s});var e=this.cache_.sources.filter(e=>e.src&&e.src===t),i=[],r=this.$$("source"),n=[];for(let e=0;e<r.length;e++){var a=Se(r[e]);i.push(a),a.src&&a.src===t&&n.push(a.src)}n.length&&!e.length?this.cache_.sources=i:e.length||(this.cache_.sources=[this.cache_.source]),this.cache_.src=t}handleTechSourceset_(t){if(!this.changingSrc_){let e=e=>this.updateSourceCaches_(e);var s=this.currentSource().src,i=t.src;(e=!s||/^blob:/.test(s)||!/^blob:/.test(i)||this.lastSource_&&(this.lastSource_.tech===i||this.lastSource_.player===s)?e:()=>{})(i),t.src||this.tech_.any(["sourceset","loadstart"],e=>{"sourceset"!==e.type&&(e=this.techGet("currentSrc"),this.lastSource_.tech=e,this.updateSourceCaches_(e))})}this.lastSource_={player:this.currentSource().src,tech:t.src},this.trigger({src:t.src,type:"sourceset"})}hasStarted(e){if(void 0===e)return this.hasStarted_;e!==this.hasStarted_&&(this.hasStarted_=e,this.hasStarted_?this.addClass("vjs-has-started"):this.removeClass("vjs-has-started"))}handleTechPlay_(){this.removeClass("vjs-ended","vjs-paused"),this.addClass("vjs-playing"),this.hasStarted(!0),this.trigger("play")}handleTechRateChange_(){0<this.tech_.playbackRate()&&0===this.cache_.lastPlaybackRate&&(this.queuedCallbacks_.forEach(e=>e.callback(e.event)),this.queuedCallbacks_=[]),this.cache_.lastPlaybackRate=this.tech_.playbackRate(),this.trigger("ratechange")}handleTechWaiting_(){this.addClass("vjs-waiting"),this.trigger("waiting");const e=this.currentTime(),t=()=>{e!==this.currentTime()&&(this.removeClass("vjs-waiting"),this.off("timeupdate",t))};this.on("timeupdate",t)}handleTechCanPlay_(){this.removeClass("vjs-waiting"),this.trigger("canplay")}handleTechCanPlayThrough_(){this.removeClass("vjs-waiting"),this.trigger("canplaythrough")}handleTechPlaying_(){this.removeClass("vjs-waiting"),this.trigger("playing")}handleTechSeeking_(){this.addClass("vjs-seeking"),this.trigger("seeking")}handleTechSeeked_(){this.removeClass("vjs-seeking","vjs-ended"),this.trigger("seeked")}handleTechPause_(){this.removeClass("vjs-playing"),this.addClass("vjs-paused"),this.trigger("pause")}handleTechEnded_(){this.addClass("vjs-ended"),this.removeClass("vjs-waiting"),this.options_.loop?(this.currentTime(0),this.play()):this.paused()||this.pause(),this.trigger("ended")}handleTechDurationChange_(){this.duration(this.techGet_("duration"))}handleTechClick_(e){!this.controls_||void 0!==this.options_&&void 0!==this.options_.userActions&&void 0!==this.options_.userActions.click&&!1===this.options_.userActions.click||(void 0!==this.options_&&void 0!==this.options_.userActions&&"function"==typeof this.options_.userActions.click?this.options_.userActions.click.call(this,e):this.paused()?k(this.play()):this.pause())}handleTechDoubleClick_(t){!this.controls_||Array.prototype.some.call(this.$$(".vjs-control-bar, .vjs-modal-dialog"),e=>e.contains(t.target))||void 0!==this.options_&&void 0!==this.options_.userActions&&void 0!==this.options_.userActions.doubleClick&&!1===this.options_.userActions.doubleClick||(void 0!==this.options_&&void 0!==this.options_.userActions&&"function"==typeof this.options_.userActions.doubleClick?this.options_.userActions.doubleClick.call(this,t):this.isFullscreen()?this.exitFullscreen():this.requestFullscreen())}handleTechTap_(){this.userActive(!this.userActive())}handleTechTouchStart_(){this.userWasActive=this.userActive()}handleTechTouchMove_(){this.userWasActive&&this.reportUserActivity()}handleTechTouchEnd_(e){e.cancelable&&e.preventDefault()}toggleFullscreenClass_(){this.isFullscreen()?this.addClass("vjs-fullscreen"):this.removeClass("vjs-fullscreen")}documentFullscreenChange_(t){t=t.target.player;if(!t||t===this){t=this.el();let e=document[this.fsApi_.fullscreenElement]===t;!e&&t.matches?e=t.matches(":"+this.fsApi_.fullscreen):!e&&t.msMatchesSelector&&(e=t.msMatchesSelector(":"+this.fsApi_.fullscreen)),this.isFullscreen(e)}}handleTechFullscreenChange_(e,t){t&&(t.nativeIOSFullscreen&&(this.addClass("vjs-ios-native-fs"),this.tech_.one("webkitendfullscreen",()=>{this.removeClass("vjs-ios-native-fs")})),this.isFullscreen(t.isFullscreen))}handleTechFullscreenError_(e,t){this.trigger("fullscreenerror",t)}togglePictureInPictureClass_(){this.isInPictureInPicture()?this.addClass("vjs-picture-in-picture"):this.removeClass("vjs-picture-in-picture")}handleTechEnterPictureInPicture_(e){this.isInPictureInPicture(!0)}handleTechLeavePictureInPicture_(e){this.isInPictureInPicture(!1)}handleTechError_(){var e=this.tech_.error();this.error(e)}handleTechTextData_(){let e=1<arguments.length?arguments[1]:null;this.trigger("textdata",e)}getCache(){return this.cache_}resetCache_(){this.cache_={currentTime:0,initTime:0,inactivityTimeout:this.options_.inactivityTimeout,duration:NaN,lastVolume:1,lastPlaybackRate:this.defaultPlaybackRate(),media:null,src:"",source:{},sources:[],playbackRates:[],volume:1}}techCall_(t,s){this.ready(function(){if(t in si)return e=this.middleware_,this.tech_[t](e.reduce(ri(t),s));if(t in ii)return ei(this.middleware_,this.tech_,t,s);var e;try{this.tech_&&this.tech_[t](s)}catch(e){throw h(e),e}},!0)}techGet_(t){if(this.tech_&&this.tech_.isReady_){if(t in ti)return e=this.middleware_,s=this.tech_,e.reduceRight(ri(t),s[t]());if(t in ii)return ei(this.middleware_,this.tech_,t);var e,s;try{return this.tech_[t]()}catch(e){throw void 0===this.tech_[t]?h(`Video.js: ${t} method not defined for ${this.techName_} playback technology.`,e):"TypeError"===e.name?(h(`Video.js: ${t} unavailable on ${this.techName_} playback technology element.`,e),this.tech_.isReady_=!1):h(e),e}}}play(){return new Promise(e=>{this.play_(e)})}play_(e=k){this.playCallbacks_.push(e);var t,e=Boolean(!this.changingSrc_&&(this.src()||this.currentSrc())),s=Boolean(pe||d);this.waitToPlay_&&(this.off(["ready","loadstart"],this.waitToPlay_),this.waitToPlay_=null),this.isReady_&&e?(t=this.techGet_("play"),s&&this.hasClass("vjs-ended")&&this.resetProgressBar_(),null===t?this.runPlayTerminatedQueue_():this.runPlayCallbacks_(t)):(this.waitToPlay_=e=>{this.play_()},this.one(["ready","loadstart"],this.waitToPlay_),!e&&s&&this.load())}runPlayTerminatedQueue_(){var e=this.playTerminatedQueue_.slice(0);this.playTerminatedQueue_=[],e.forEach(function(e){e()})}runPlayCallbacks_(t){var e=this.playCallbacks_.slice(0);this.playCallbacks_=[],this.playTerminatedQueue_=[],e.forEach(function(e){e(t)})}pause(){this.techCall_("pause")}paused(){return!1!==this.techGet_("paused")}played(){return this.techGet_("played")||T(0,0)}scrubbing(e){if("undefined"==typeof e)return this.scrubbing_;this.scrubbing_=!!e,this.techCall_("setScrubbing",this.scrubbing_),e?this.addClass("vjs-scrubbing"):this.removeClass("vjs-scrubbing")}currentTime(e){return"undefined"!=typeof e?(e<0&&(e=0),this.isReady_&&!this.changingSrc_&&this.tech_&&this.tech_.isReady_?(this.techCall_("setCurrentTime",e),void(this.cache_.initTime=0)):(this.cache_.initTime=e,this.off("canplay",this.boundApplyInitTime_),void this.one("canplay",this.boundApplyInitTime_))):(this.cache_.currentTime=this.techGet_("currentTime")||0,this.cache_.currentTime)}applyInitTime_(){this.currentTime(this.cache_.initTime)}duration(e){if(void 0===e)return void 0!==this.cache_.duration?this.cache_.duration:NaN;(e=(e=parseFloat(e))<0?1/0:e)!==this.cache_.duration&&((this.cache_.duration=e)===1/0?this.addClass("vjs-live"):this.removeClass("vjs-live"),isNaN(e)||this.trigger("durationchange"))}remainingTime(){return this.duration()-this.currentTime()}remainingTimeDisplay(){return Math.floor(this.duration())-Math.floor(this.currentTime())}buffered(){let e=this.techGet_("buffered");return e=e&&e.length?e:T(0,0)}bufferedPercent(){return Nt(this.buffered(),this.duration())}bufferedEnd(){var e=this.buffered(),t=this.duration();let s=e.end(e.length-1);return s=s>t?t:s}volume(e){let t;if(void 0===e)return t=parseFloat(this.techGet_("volume")),isNaN(t)?1:t;t=Math.max(0,Math.min(1,parseFloat(e))),this.cache_.volume=t,this.techCall_("setVolume",t),0<t&&this.lastVolume_(t)}muted(e){if(void 0===e)return this.techGet_("muted")||!1;this.techCall_("setMuted",e)}defaultMuted(e){return void 0!==e?this.techCall_("setDefaultMuted",e):this.techGet_("defaultMuted")||!1}lastVolume_(e){if(void 0===e||0===e)return this.cache_.lastVolume;this.cache_.lastVolume=e}supportsFullScreen(){return this.techGet_("supportsFullScreen")||!1}isFullscreen(e){var t;if(void 0===e)return this.isFullscreen_;t=this.isFullscreen_,this.isFullscreen_=Boolean(e),this.isFullscreen_!==t&&this.fsApi_.prefixed&&this.trigger("fullscreenchange"),this.toggleFullscreenClass_()}requestFullscreen(a){this.isInPictureInPicture()&&this.exitPictureInPicture();const o=this;return new Promise((e,s)=>{function i(){o.off("fullscreenerror",r),o.off("fullscreenchange",t)}function t(){i(),e()}function r(e,t){i(),s(t)}o.one("fullscreenchange",t),o.one("fullscreenerror",r);var n=o.requestFullscreenHelper_(a);n&&(n.then(i,i),n.then(e,s))})}requestFullscreenHelper_(e){let t;if(this.fsApi_.prefixed||(t=this.options_.fullscreen&&this.options_.fullscreen.options||{},void 0!==e&&(t=e)),this.fsApi_.requestFullscreen)return(e=this.el_[this.fsApi_.requestFullscreen](t))&&e.then(()=>this.isFullscreen(!0),()=>this.isFullscreen(!1)),e;this.tech_.supportsFullScreen()&&!0==!this.options_.preferFullWindow?this.techCall_("enterFullScreen"):this.enterFullWindow()}exitFullscreen(){const a=this;return new Promise((e,s)=>{function i(){a.off("fullscreenerror",r),a.off("fullscreenchange",t)}function t(){i(),e()}function r(e,t){i(),s(t)}a.one("fullscreenchange",t),a.one("fullscreenerror",r);var n=a.exitFullscreenHelper_();n&&(n.then(i,i),n.then(e,s))})}exitFullscreenHelper_(){var e;if(this.fsApi_.requestFullscreen)return(e=document[this.fsApi_.exitFullscreen]())&&k(e.then(()=>this.isFullscreen(!1))),e;this.tech_.supportsFullScreen()&&!0==!this.options_.preferFullWindow?this.techCall_("exitFullScreen"):this.exitFullWindow()}enterFullWindow(){this.isFullscreen(!0),this.isFullWindow=!0,this.docOrigOverflow=document.documentElement.style.overflow,_(document,"keydown",this.boundFullWindowOnEscKey_),document.documentElement.style.overflow="hidden",ke(document.body,"vjs-full-window"),this.trigger("enterFullWindow")}fullWindowOnEscKey(e){a.isEventKey(e,"Esc")&&!0===this.isFullscreen()&&(this.isFullWindow?this.exitFullWindow():this.exitFullscreen())}exitFullWindow(){this.isFullscreen(!1),this.isFullWindow=!1,f(document,"keydown",this.boundFullWindowOnEscKey_),document.documentElement.style.overflow=this.docOrigOverflow,Ce(document.body,"vjs-full-window"),this.trigger("exitFullWindow")}disablePictureInPicture(e){if(void 0===e)return this.techGet_("disablePictureInPicture");this.techCall_("setDisablePictureInPicture",e),this.options_.disablePictureInPicture=e,this.trigger("disablepictureinpicturechanged")}isInPictureInPicture(e){if(void 0===e)return!!this.isInPictureInPicture_;this.isInPictureInPicture_=!!e,this.togglePictureInPictureClass_()}requestPictureInPicture(){if(this.options_.enableDocumentPictureInPicture&&window.documentPictureInPicture){const t=document.createElement(this.el().tagName);return t.classList=this.el().classList,t.classList.add("vjs-pip-container"),this.posterImage&&t.appendChild(this.posterImage.el().cloneNode(!0)),this.titleBar&&t.appendChild(this.titleBar.el().cloneNode(!0)),t.appendChild(p("p",{className:"vjs-pip-text"},{},this.localize("Playing in picture-in-picture"))),window.documentPictureInPicture.requestWindow({initialAspectRatio:this.videoWidth()/this.videoHeight(),copyStyleSheets:!0}).then(e=>(this.el_.parentNode.insertBefore(t,this.el_),e.document.body.append(this.el_),e.document.body.classList.add("vjs-pip-window"),this.player_.isInPictureInPicture(!0),this.player_.trigger("enterpictureinpicture"),e.addEventListener("unload",e=>{e=e.target.querySelector(".video-js");t.replaceWith(e),this.player_.isInPictureInPicture(!1),this.player_.trigger("leavepictureinpicture")}),e))}return"pictureInPictureEnabled"in document&&!1===this.disablePictureInPicture()?this.techGet_("requestPictureInPicture"):Promise.reject("No PiP mode is available")}exitPictureInPicture(){return window.documentPictureInPicture&&window.documentPictureInPicture.window?(window.documentPictureInPicture.window.close(),Promise.resolve()):"pictureInPictureEnabled"in document?document.exitPictureInPicture():void 0}handleKeyDown(e){var t,s,i=this.options_["userActions"];i&&i.hotkeys&&(t=this.el_.ownerDocument.activeElement,s=t.tagName.toLowerCase(),t.isContentEditable||("input"===s?-1===["button","checkbox","hidden","radio","reset","submit"].indexOf(t.type):-1!==["textarea"].indexOf(s))||("function"==typeof i.hotkeys?i.hotkeys.call(this,e):this.handleHotkeys(e)))}handleHotkeys(e){var{fullscreenKey:t=e=>a.isEventKey(e,"f"),muteKey:s=e=>a.isEventKey(e,"m"),playPauseKey:i=e=>a.isEventKey(e,"k")||a.isEventKey(e,"Space")}=this.options_.userActions?this.options_.userActions.hotkeys:{};t.call(this,e)?(e.preventDefault(),e.stopPropagation(),t=b.getComponent("FullscreenToggle"),!1!==document[this.fsApi_.fullscreenEnabled]&&t.prototype.handleClick.call(this,e)):s.call(this,e)?(e.preventDefault(),e.stopPropagation(),b.getComponent("MuteToggle").prototype.handleClick.call(this,e)):i.call(this,e)&&(e.preventDefault(),e.stopPropagation(),b.getComponent("PlayToggle").prototype.handleClick.call(this,e))}canPlayType(i){var r;for(let t=0,s=this.options_.techOrder;t<s.length;t++){var n=s[t];let e=P.getTech(n);if(e=e||b.getComponent(n)){if(e.isSupported()&&(r=e.canPlayType(i)))return r}else h.error(`The "${n}" tech is undefined. Skipped browser support check for that tech.`)}return""}selectSource(e){function t(e,s,i){let r;return e.some(t=>s.some(e=>{if(r=i(t,e))return!0})),r}var s=this.options_.techOrder.map(e=>[e,P.getTech(e)]).filter(([e,t])=>t?t.isSupported():(h.error(`The "${e}" tech is undefined. Skipped browser support check for that tech.`),!1));let i;var r,n=([e,t],s)=>{if(t.canPlaySource(s,this.options_[e.toLowerCase()]))return{source:s,tech:e}};return(i=this.options_.sourceOrder?t(e,s,(r=n,(e,t)=>r(t,e))):t(s,e,n))||!1}handleSrc_(e,i){if("undefined"==typeof e)return this.cache_.src||"";this.resetRetryOnError_&&this.resetRetryOnError_();const r=ai(e);if(r.length){if(this.changingSrc_=!0,i||(this.cache_.sources=r),this.updateSourceCaches_(r[0]),Zs(this,r[0],(e,t)=>{var s;if(this.middleware_=t,i||(this.cache_.sources=r),this.updateSourceCaches_(e),this.src_(e))return 1<r.length?this.handleSrc_(r.slice(1)):(this.changingSrc_=!1,this.setTimeout(function(){this.error({code:4,message:this.options_.notSupportedMessage})},0),void this.triggerReady());s=this.tech_,t.forEach(e=>e.setTech&&e.setTech(s))}),1<r.length){const t=()=>{this.error(null),this.handleSrc_(r.slice(1),!0)},s=()=>{this.off("error",t)};this.one("error",t),this.one("playing",s),this.resetRetryOnError_=()=>{this.off("error",t),this.off("playing",s)}}}else this.setTimeout(function(){this.error({code:4,message:this.options_.notSupportedMessage})},0)}src(e){return this.handleSrc_(e,!1)}src_(e){var t=this.selectSource([e]);return!t||(Ct(t.tech,this.techName_)?this.ready(function(){this.tech_.constructor.prototype.hasOwnProperty("setSource")?this.techCall_("setSource",e):this.techCall_("src",e.src),this.changingSrc_=!1},!0):(this.changingSrc_=!0,this.loadTech_(t.tech,t.source),this.tech_.ready(()=>{this.changingSrc_=!1})),!1)}load(){this.techCall_("load")}reset(){this.paused()?this.doReset_():k(this.play().then(()=>this.doReset_()))}doReset_(){this.tech_&&this.tech_.clearTracks("text"),this.resetCache_(),this.poster(""),this.loadTech_(this.options_.techOrder[0],null),this.techCall_("reset"),this.resetControlBarUI_(),ut(this)&&this.trigger("playerreset")}resetControlBarUI_(){this.resetProgressBar_(),this.resetPlaybackRate_(),this.resetVolumeBar_()}resetProgressBar_(){this.currentTime(0);var{currentTimeDisplay:e,durationDisplay:t,progressControl:s,remainingTimeDisplay:i}=this.controlBar||{},s=(s||{})["seekBar"];e&&e.updateContent(),t&&t.updateContent(),i&&i.updateContent(),s&&(s.update(),s.loadProgressBar)&&s.loadProgressBar.update()}resetPlaybackRate_(){this.playbackRate(this.defaultPlaybackRate()),this.handleTechRateChange_()}resetVolumeBar_(){this.volume(1),this.trigger("volumechange")}currentSources(){var e=this.currentSource(),t=[];return 0!==Object.keys(e).length&&t.push(e),this.cache_.sources||t}currentSource(){return this.cache_.source||{}}currentSrc(){return this.currentSource()&&this.currentSource().src||""}currentType(){return this.currentSource()&&this.currentSource().type||""}preload(e){if(void 0===e)return this.techGet_("preload");this.techCall_("setPreload",e),this.options_.preload=e}autoplay(e){if(void 0===e)return this.options_.autoplay||!1;let t;"string"==typeof e&&/(any|play|muted)/.test(e)||!0===e&&this.options_.normalizeAutoplay?(this.options_.autoplay=e,this.manualAutoplay_("string"==typeof e?e:"play"),t=!1):this.options_.autoplay=!!e,t="undefined"==typeof t?this.options_.autoplay:t,this.tech_&&this.techCall_("setAutoplay",t)}playsinline(e){return void 0!==e?(this.techCall_("setPlaysinline",e),this.options_.playsinline=e,this):this.techGet_("playsinline")}loop(e){if(void 0===e)return this.techGet_("loop");this.techCall_("setLoop",e),this.options_.loop=e}poster(e){if(void 0===e)return this.poster_;(e=e||"")!==this.poster_&&(this.poster_=e,this.techCall_("setPoster",e),this.isPosterFromTech_=!1,this.trigger("posterchange"))}handleTechPosterChange_(){var e;(!this.poster_||this.options_.techCanOverridePoster)&&this.tech_&&this.tech_.poster&&(e=this.tech_.poster()||"")!==this.poster_&&(this.poster_=e,this.isPosterFromTech_=!0,this.trigger("posterchange"))}controls(e){if(void 0===e)return!!this.controls_;this.controls_!==(e=!!e)&&(this.controls_=e,this.usingNativeControls()&&this.techCall_("setControls",e),this.controls_?(this.removeClass("vjs-controls-disabled"),this.addClass("vjs-controls-enabled"),this.trigger("controlsenabled"),this.usingNativeControls()||this.addTechControlsListeners_()):(this.removeClass("vjs-controls-enabled"),this.addClass("vjs-controls-disabled"),this.trigger("controlsdisabled"),this.usingNativeControls()||this.removeTechControlsListeners_()))}usingNativeControls(e){if(void 0===e)return!!this.usingNativeControls_;this.usingNativeControls_!==(e=!!e)&&(this.usingNativeControls_=e,this.usingNativeControls_?(this.addClass("vjs-using-native-controls"),this.trigger("usingnativecontrols")):(this.removeClass("vjs-using-native-controls"),this.trigger("usingcustomcontrols")))}error(t){if(void 0===t)return this.error_||null;if(R("beforeerror").forEach(e=>{e=e(this,t);n(e)&&!Array.isArray(e)||"string"==typeof e||"number"==typeof e||null===e?t=e:this.log.error("please return a value that MediaError expects in beforeerror hooks")}),this.options_.suppressNotSupportedError&&t&&4===t.code){const e=function(){this.error(t)};this.options_.suppressNotSupportedError=!1,this.any(["click","touchstart"],e),void this.one("loadstart",function(){this.off(["click","touchstart"],e)})}else null===t?(this.error_=t,this.removeClass("vjs-error"),this.errorDisplay&&this.errorDisplay.close()):(this.error_=new i(t),this.addClass("vjs-error"),h.error(`(CODE:${this.error_.code} ${i.errorTypes[this.error_.code]})`,this.error_.message,this.error_),this.trigger("error"),R("error").forEach(e=>e(this,this.error_)))}reportUserActivity(e){this.userActivity_=!0}userActive(e){if(void 0===e)return this.userActive_;(e=!!e)!==this.userActive_&&(this.userActive_=e,this.userActive_?(this.userActivity_=!0,this.removeClass("vjs-user-inactive"),this.addClass("vjs-user-active"),this.trigger("useractive")):(this.tech_&&this.tech_.one("mousemove",function(e){e.stopPropagation(),e.preventDefault()}),this.userActivity_=!1,this.removeClass("vjs-user-active"),this.addClass("vjs-user-inactive"),this.trigger("userinactive")))}listenForUserActivity_(){let t,s,i;const r=v(this,this.reportUserActivity);function e(e){r(),this.clearInterval(t)}this.on("mousedown",function(){r(),this.clearInterval(t),t=this.setInterval(r,250)}),this.on("mousemove",function(e){e.screenX===s&&e.screenY===i||(s=e.screenX,i=e.screenY,r())}),this.on("mouseup",e),this.on("mouseleave",e);var n=this.getChild("controlBar");!n||d||o||(n.on("mouseenter",function(e){0!==this.player().options_.inactivityTimeout&&(this.player().cache_.inactivityTimeout=this.player().options_.inactivityTimeout),this.player().options_.inactivityTimeout=0}),n.on("mouseleave",function(e){this.player().options_.inactivityTimeout=this.player().cache_.inactivityTimeout})),this.on("keydown",r),this.on("keyup",r);let a;this.setInterval(function(){var e;this.userActivity_&&(this.userActivity_=!1,this.userActive(!0),this.clearTimeout(a),(e=this.options_.inactivityTimeout)<=0||(a=this.setTimeout(function(){this.userActivity_||this.userActive(!1)},e)))},250)}playbackRate(e){if(void 0===e)return this.tech_&&this.tech_.featuresPlaybackRate?this.cache_.lastPlaybackRate||this.techGet_("playbackRate"):1;this.techCall_("setPlaybackRate",e)}defaultPlaybackRate(e){return void 0!==e?this.techCall_("setDefaultPlaybackRate",e):this.tech_&&this.tech_.featuresPlaybackRate?this.techGet_("defaultPlaybackRate"):1}isAudio(e){if(void 0===e)return!!this.isAudio_;this.isAudio_=!!e}enableAudioOnlyUI_(){this.addClass("vjs-audio-only-mode");var e=this.children();const t=this.getChild("ControlBar");var s=t&&t.currentHeight();e.forEach(e=>{e!==t&&e.el_&&!e.hasClass("vjs-hidden")&&(e.hide(),this.audioOnlyCache_.hiddenChildren.push(e))}),this.audioOnlyCache_.playerHeight=this.currentHeight(),this.height(s),this.trigger("audioonlymodechange")}disableAudioOnlyUI_(){this.removeClass("vjs-audio-only-mode"),this.audioOnlyCache_.hiddenChildren.forEach(e=>e.show()),this.height(this.audioOnlyCache_.playerHeight),this.trigger("audioonlymodechange")}audioOnlyMode(e){return"boolean"!=typeof e||e===this.audioOnlyMode_?this.audioOnlyMode_:(this.audioOnlyMode_=e)?(e=[],this.isInPictureInPicture()&&e.push(this.exitPictureInPicture()),this.isFullscreen()&&e.push(this.exitFullscreen()),this.audioPosterMode()&&e.push(this.audioPosterMode(!1)),Promise.all(e).then(()=>this.enableAudioOnlyUI_())):Promise.resolve().then(()=>this.disableAudioOnlyUI_())}enablePosterModeUI_(){(this.tech_&&this.tech_).hide(),this.addClass("vjs-audio-poster-mode"),this.trigger("audiopostermodechange")}disablePosterModeUI_(){(this.tech_&&this.tech_).show(),this.removeClass("vjs-audio-poster-mode"),this.trigger("audiopostermodechange")}audioPosterMode(e){return"boolean"!=typeof e||e===this.audioPosterMode_?this.audioPosterMode_:(this.audioPosterMode_=e)?(this.audioOnlyMode()?this.audioOnlyMode(!1):Promise.resolve()).then(()=>{this.enablePosterModeUI_()}):Promise.resolve().then(()=>{this.disablePosterModeUI_()})}addTextTrack(e,t,s){if(this.tech_)return this.tech_.addTextTrack(e,t,s)}addRemoteTextTrack(e,t){if(this.tech_)return this.tech_.addRemoteTextTrack(e,t)}removeRemoteTextTrack(e={}){let t=e["track"];if(t=t||e,this.tech_)return this.tech_.removeRemoteTextTrack(t)}getVideoPlaybackQuality(){return this.techGet_("getVideoPlaybackQuality")}videoWidth(){return this.tech_&&this.tech_.videoWidth&&this.tech_.videoWidth()||0}videoHeight(){return this.tech_&&this.tech_.videoHeight&&this.tech_.videoHeight()||0}language(e){if(void 0===e)return this.language_;this.language_!==String(e).toLowerCase()&&(this.language_=String(e).toLowerCase(),ut(this))&&this.trigger("languagechange")}languages(){return c(I.prototype.options_.languages,this.languages_)}toJSON(){var t=c(this.options_),s=t.tracks;t.tracks=[];for(let e=0;e<s.length;e++){var i=s[e];(i=c(i)).player=void 0,t.tracks[e]=i}return t}createModal(e,t){(t=t||{}).content=e||"";const s=new $t(this,t);return this.addChild(s),s.on("dispose",()=>{this.removeChild(s)}),s.open(),s}updateCurrentBreakpoint_(){if(this.responsive()){var t=this.currentBreakpoint(),s=this.currentWidth();for(let e=0;e<Vr.length;e++){var i=Vr[e];if(s<=this.breakpoints_[i]){if(t===i)return;t&&this.removeClass($r[t]),this.addClass($r[i]),this.breakpoint_=i;break}}}}removeCurrentBreakpoint_(){var e=this.currentBreakpointClass();this.breakpoint_="",e&&this.removeClass(e)}breakpoints(e){return void 0!==e&&(this.breakpoint_="",this.breakpoints_=Object.assign({},zr,e),this.updateCurrentBreakpoint_()),Object.assign(this.breakpoints_)}responsive(e){return void 0===e?this.responsive_:(e=Boolean(e))!==this.responsive_?((this.responsive_=e)?(this.on("playerresize",this.boundUpdateCurrentBreakpoint_),this.updateCurrentBreakpoint_()):(this.off("playerresize",this.boundUpdateCurrentBreakpoint_),this.removeCurrentBreakpoint_()),e):void 0}currentBreakpoint(){return this.breakpoint_}currentBreakpointClass(){return $r[this.breakpoint_]||""}loadMedia(e,t){var s,i,r,n,a,o;e&&"object"==typeof e&&(this.reset(),this.cache_.media=c(e),{artist:e,artwork:s,description:i,poster:r,src:n,textTracks:a,title:o}=this.cache_.media,!s&&r&&(this.cache_.media.artwork=[{src:r,type:li(r)}]),n&&this.src(n),r&&this.poster(r),Array.isArray(a)&&a.forEach(e=>this.addRemoteTextTrack(e,!1)),this.titleBar&&this.titleBar.update({title:o,description:i||e||""}),this.ready(t))}getMedia(){var e,t;return this.cache_.media?c(this.cache_.media):(e=this.poster(),t={src:this.currentSources(),textTracks:Array.prototype.map.call(this.remoteTextTracks(),e=>({kind:e.kind,label:e.label,language:e.language,src:e.src}))},e&&(t.poster=e,t.artwork=[{src:t.poster,type:li(t.poster)}]),t)}static getTagSettings(e){var t,s={sources:[],tracks:[]},i=Se(e),r=i["data-setup"];if(Te(e,"vjs-fill")&&(i.fill=!0),Te(e,"vjs-fluid")&&(i.fluid=!0),null!==r&&([r,t]=Dt(r||"{}"),r&&h.error(r),Object.assign(i,t)),Object.assign(s,i),e.hasChildNodes()){var n=e.childNodes;for(let e=0,t=n.length;e<t;e++){var a=n[e],o=a.nodeName.toLowerCase();"source"===o?s.sources.push(Se(a)):"track"===o&&s.tracks.push(Se(a))}}return s}debug(e){if(void 0===e)return this.debugEnabled_;e?(this.trigger("debugon"),this.previousLogLevel_=this.log.level,this.log.level("debug"),this.debugEnabled_=!0):(this.trigger("debugoff"),this.log.level(this.previousLogLevel_),this.previousLogLevel_=void 0,this.debugEnabled_=!1)}playbackRates(e){if(void 0===e)return this.cache_.playbackRates;Array.isArray(e)&&e.every(e=>"number"==typeof e)&&(this.cache_.playbackRates=e,this.trigger("playbackrateschange"))}}E.names.forEach(function(e){const t=E[e];I.prototype[t.getterName]=function(){return this.tech_?this.tech_[t.getterName]():(this[t.privateName]=this[t.privateName]||new t.ListClass,this[t.privateName])}}),I.prototype.crossorigin=I.prototype.crossOrigin,I.players={};br=window.navigator;I.prototype.options_={techOrder:P.defaultTechOrder_,html5:{},enableSourceset:!0,inactivityTimeout:2e3,playbackRates:[],liveui:!1,children:["mediaLoader","posterImage","titleBar","textTrackDisplay","loadingSpinner","bigPlayButton","liveTracker","controlBar","errorDisplay","textTrackSettings","resizeManager"],language:br&&(br.languages&&br.languages[0]||br.userLanguage||br.language)||"en",languages:{},notSupportedMessage:"No compatible source was found for this media.",normalizeAutoplay:!1,fullscreen:{options:{navigationUI:"hide"}},breakpoints:{},responsive:!1,audioOnlyMode:!1,audioPosterMode:!1},["ended","seeking","seekable","networkState","readyState"].forEach(function(e){I.prototype[e]=function(){return this.techGet_(e)}}),Br.forEach(function(e){I.prototype[`handleTech${y(e)}_`]=function(){return this.trigger(e)}}),b.registerComponent("Player",I);function Ur(t,s){function i(){Qr(this,{name:t,plugin:s,instance:null},!0);var e=s.apply(this,arguments);return Yr(this,t),Qr(this,{name:t,plugin:s,instance:e}),e}return Object.keys(s).forEach(function(e){i[e]=s[e]}),i}const Kr="plugin",Wr="activePlugins_",qr={},Xr=e=>qr.hasOwnProperty(e),Gr=e=>Xr(e)?qr[e]:void 0,Yr=(e,t)=>{e[Wr]=e[Wr]||{},e[Wr][t]=!0},Qr=(e,t,s)=>{s=(s?"before":"")+"pluginsetup";e.trigger(s,t),e.trigger(s+":"+t.name,t)},Jr=(s,i)=>(i.prototype.name=s,function(...e){Qr(this,{name:s,plugin:i,instance:null},!0);const t=new i(this,...e);return this[s]=()=>t,Qr(this,t.getEventHash()),t});class O{constructor(e){if(this.constructor===O)throw new Error("Plugin must be sub-classed; not directly instantiated.");this.player=e,this.log||(this.log=this.player.log.createLogger(this.name)),yt(this),delete this.trigger,Tt(this,this.constructor.defaultState),Yr(e,this.name),this.dispose=this.dispose.bind(this),e.on("dispose",this.dispose)}version(){return this.constructor.VERSION}getEventHash(e={}){return e.name=this.name,e.plugin=this.constructor,e.instance=this,e}trigger(e,t={}){return it(this.eventBusEl_,e,this.getEventHash(t))}handleStateChanged(e){}dispose(){var{name:e,player:t}=this;this.trigger("dispose"),this.off(),t.off("dispose",this.dispose),t[Wr][e]=!1,this.player=this.state=null,t[e]=Jr(e,qr[e])}static isBasic(e){e="string"==typeof e?Gr(e):e;return"function"==typeof e&&!O.prototype.isPrototypeOf(e.prototype)}static registerPlugin(e,t){if("string"!=typeof e)throw new Error(`Illegal plugin name, "${e}", must be a string, was ${typeof e}.`);if(Xr(e))h.warn(`A plugin named "${e}" already exists. You may want to avoid re-registering plugins!`);else if(I.prototype.hasOwnProperty(e))throw new Error(`Illegal plugin name, "${e}", cannot share a name with an existing player method!`);if("function"!=typeof t)throw new Error(`Illegal plugin for "${e}", must be a function, was ${typeof t}.`);return qr[e]=t,e!==Kr&&(O.isBasic(t)?I.prototype[e]=Ur(e,t):I.prototype[e]=Jr(e,t)),t}static deregisterPlugin(e){if(e===Kr)throw new Error("Cannot de-register base plugin.");Xr(e)&&(delete qr[e],delete I.prototype[e])}static getPlugins(e=Object.keys(qr)){let s;return e.forEach(e=>{var t=Gr(e);t&&((s=s||{})[e]=t)}),s}static getPluginVersion(e){e=Gr(e);return e&&e.VERSION||""}}function M(e,s,i,r){{var n=s+` is deprecated and will be removed in ${e}.0; please use ${i} instead.`,a=r;let t=!1;return function(...e){return t||h.warn(n),t=!0,a.apply(this,e)}}}O.getPlugin=Gr,O.BASE_PLUGIN_NAME=Kr,O.registerPlugin(Kr,O),I.prototype.usingPlugin=function(e){return!!this[Wr]&&!0===this[Wr][e]},I.prototype.hasPlugin=function(e){return!!Xr(e)};const Zr=e=>0===e.indexOf("#")?e.slice(1):e;function L(e,t,s){let i=L.getPlayer(e);if(i)t&&h.warn(`Player "${e}" is already initialised. Options will not be applied.`),s&&i.ready(s);else{const r="string"==typeof e?Ve("#"+Zr(e)):e;if(!_e(r))throw new TypeError("The element or ID supplied is not valid. (videojs)");r.ownerDocument.defaultView&&r.ownerDocument.body.contains(r)||h.warn("The element supplied is not included in the DOM"),!0===(t=t||{}).restoreEl&&(t.restoreEl=(r.parentNode&&r.parentNode.hasAttribute("data-vjs-player")?r.parentNode:r).cloneNode(!0)),R("beforesetup").forEach(e=>{e=e(r,c(t));!n(e)||Array.isArray(e)?h.error("please return an object in beforesetup hooks"):t=c(t,e)});e=b.getComponent("Player");i=new e(r,t,s),R("setup").forEach(e=>e(i))}return i}return L.hooks_=F,L.hooks=R,L.hook=function(e,t){R(e,t)},L.hookOnce=function(i,e){R(i,[].concat(e).map(t=>{const s=(...e)=>(B(i,s),t(...e));return s}))},L.removeHook=B,!0!==window.VIDEOJS_NO_DYNAMIC_STYLE&&me()&&!(ks=Ve(".vjs-styles-defaults"))&&(ks=Ye("vjs-styles-defaults"),(yr=Ve("head"))&&yr.insertBefore(ks,yr.firstChild),Qe(ks,`
      .video-js {
        width: 300px;
        height: 150px;
      }

      .vjs-fluid:not(.vjs-audio-only-mode) {
        padding-top: 56.25%
      }
    `)),Xe(1,L),L.VERSION=D,L.options=I.prototype.options_,L.getPlayers=()=>I.players,L.getPlayer=e=>{var t=I.players;let s;if("string"==typeof e){var i=Zr(e),r=t[i];if(r)return r;s=Ve("#"+i)}else s=e;if(_e(s)){var{player:r,playerId:i}=s;if(r||t[i])return r||t[i]}},L.getAllPlayers=()=>Object.keys(I.players).map(e=>I.players[e]).filter(Boolean),L.players=I.players,L.getComponent=b.getComponent,L.registerComponent=(e,t)=>{P.isTech(t)&&h.warn(`The ${e} tech was registered as a component. It should instead be registered using videojs.registerTech(name, tech)`),b.registerComponent.call(b,e,t)},L.getTech=P.getTech,L.registerTech=P.registerTech,L.use=function(e,t){Ys[e]=Ys[e]||[],Ys[e].push(t)},Object.defineProperty(L,"middleware",{value:{},writeable:!1,enumerable:!0}),Object.defineProperty(L.middleware,"TERMINATOR",{value:Js,writeable:!1,enumerable:!0}),L.browser=e,L.obj=Q,L.mergeOptions=M(9,"videojs.mergeOptions","videojs.obj.merge",c),L.defineLazyProperty=M(9,"videojs.defineLazyProperty","videojs.obj.defineLazyProperty",Y),L.bind=M(9,"videojs.bind","native Function.prototype.bind",v),L.registerPlugin=O.registerPlugin,L.deregisterPlugin=O.deregisterPlugin,L.plugin=(e,t)=>(h.warn("videojs.plugin() is deprecated; use videojs.registerPlugin() instead"),O.registerPlugin(e,t)),L.getPlugins=O.getPlugins,L.getPlugin=O.getPlugin,L.getPluginVersion=O.getPluginVersion,L.addLanguage=function(e,t){return e=(""+e).toLowerCase(),L.options.languages=c(L.options.languages,{[e]:t}),L.options.languages[e]},L.log=h,L.createLogger=K,L.time=Lt,L.createTimeRange=M(9,"videojs.createTimeRange","videojs.time.createTimeRanges",T),L.createTimeRanges=M(9,"videojs.createTimeRanges","videojs.time.createTimeRanges",T),L.formatTime=M(9,"videojs.formatTime","videojs.time.formatTime",Mt),L.setFormatTime=M(9,"videojs.setFormatTime","videojs.time.setFormatTime",It),L.resetFormatTime=M(9,"videojs.resetFormatTime","videojs.time.resetFormatTime",Ot),L.parseUrl=M(9,"videojs.parseUrl","videojs.url.parseUrl",Zt),L.isCrossOrigin=M(9,"videojs.isCrossOrigin","videojs.url.isCrossOrigin",ts),L.EventTarget=s,L.any=nt,L.on=_,L.one=rt,L.off=f,L.trigger=it,L.xhr=ls,L.TextTrack=fs,L.AudioTrack=vs,L.VideoTrack=ys,["isEl","isTextNode","createEl","hasClass","addClass","removeClass","toggleClass","setAttributes","getAttributes","emptyEl","appendContent","insertContent"].forEach(e=>{L[e]=function(){return h.warn(`videojs.${e}() is deprecated; use videojs.dom.${e}() instead`),Ue[e].apply(null,arguments)}}),L.computedStyle=M(9,"videojs.computedStyle","videojs.dom.computedStyle",ze),L.dom=Ue,L.fn=lt,L.num=t,L.str=wt,L.url=is,L});