"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const yargs = require("yargs");
const clean = require("../cmds/clean");
const shutdown = require("../cmds/shutdown");
const start = require("../cmds/start");
const status = require("../cmds/status");
const update = require("../cmds/update");
const CHROME = 'chrome';
const chromeOption = {
    describe: 'Install or update chromedriver.',
    default: true,
    type: 'boolean'
};
const CHROME_LOGS = 'chrome_logs';
const chromeLogsOption = {
    describe: 'File path to chrome logs.',
    type: 'string'
};
const DETACH = 'detach';
const detachOption = {
    describe: 'Once the selenium server is up and running, return ' +
        'control to the parent process and continue running the server ' +
        'in the background.',
    default: false,
    type: 'boolean'
};
const EDGE = 'edge';
const edgeOption = {
    describe: 'Use an installed Microsoft edge driver. Usually installed: ' +
        '"C:\Program Files (x86)\Microsoft Web Driver\MirosoftWebDriver.exe"',
    type: 'string'
};
const GECKO = 'gecko';
const geckoOption = {
    describe: 'Install or update geckodriver.',
    default: true,
    type: 'boolean'
};
const GITHUB_TOKEN = 'github_token';
const githubTokenOption = {
    describe: 'Use a GitHub token to prevent rate limit issues.',
    type: 'string'
};
const IEDRIVER = 'iedriver';
const ieOption = {
    describe: 'Install or update ie driver.',
    default: false,
    type: 'boolean'
};
const IGNORE_SSL = 'ignore_ssl';
const ignoreSSLOption = {
    describe: 'Ignore SSL certificates.',
    type: 'boolean'
};
const LOG_LEVEL = 'log_level';
const logLevelOption = {
    describe: 'The log level of this CLI.',
    default: 'info',
    type: 'string'
};
const OUT_DIR = 'out_dir';
const outDirOption = {
    describe: 'Location of output.',
    type: 'string'
};
const PROXY = 'proxy';
const proxyOption = {
    describe: 'Use a proxy server to download files.',
    type: 'string'
};
const STANDALONE = 'standalone';
const standaloneOption = {
    describe: 'Install or update selenium server standalone.',
    default: true,
    type: 'boolean'
};
const STANDALONE_NODE = 'standalone_node';
const standaloneNodeOption = {
    describe: 'Start the selenium server standalone with role set to "node".',
    type: 'boolean'
};
const VERSIONS_CHROME = 'versions.chrome';
const versionsChromeOption = {
    describe: 'The chromedriver version.',
    type: 'string'
};
const VERSIONS_GECKO = 'versions.gecko';
const versionsGeckoOption = {
    describe: 'The geckodriver version.',
    type: 'string'
};
const VERSIONS_IE = 'versions.ie';
const versionsIeOption = {
    describe: 'The ie driver version.',
    type: 'string'
};
const VERSIONS_STANDALONE = 'versions.standalone';
const versionsStandaloneOption = {
    describe: 'The selenium server standalone version.',
    type: 'string'
};
// tslint:disable-next-line:no-unused-expression
yargs
    .command('clean', 'Removes downloaded files from the out_dir.', (yargs) => {
    return yargs.option(LOG_LEVEL, logLevelOption)
        .option(OUT_DIR, outDirOption);
}, (argv) => {
    clean.handler(argv);
})
    .command('shutdown', 'Shutdown a local selenium server with GET request', (yargs) => {
    return yargs.option(LOG_LEVEL, logLevelOption);
}, (argv) => {
    shutdown.handler(argv);
})
    .command('start', 'Start up the selenium server.', (yargs) => {
    return yargs.option(CHROME, chromeOption)
        .option(CHROME_LOGS, chromeLogsOption)
        .option(DETACH, detachOption)
        .option(EDGE, edgeOption)
        .option(GECKO, geckoOption)
        .option(IEDRIVER, ieOption)
        .option(LOG_LEVEL, logLevelOption)
        .option(OUT_DIR, outDirOption)
        .option(STANDALONE, standaloneOption)
        .option(STANDALONE_NODE, standaloneNodeOption)
        .option(VERSIONS_CHROME, versionsChromeOption)
        .option(VERSIONS_GECKO, versionsGeckoOption)
        .option(VERSIONS_IE, versionsIeOption)
        .option(VERSIONS_STANDALONE, versionsStandaloneOption);
}, (argv) => {
    start.handler(argv);
})
    .command('status', 'List the current available binaries.', (yargs) => {
    return yargs.option(LOG_LEVEL, logLevelOption)
        .option(OUT_DIR, outDirOption);
}, (argv) => {
    status.handler(argv);
})
    .command('update', 'Install or update selected binaries.', (yargs) => {
    return yargs.option(OUT_DIR, outDirOption)
        .option(CHROME, chromeOption)
        .option(GECKO, geckoOption)
        .option(GITHUB_TOKEN, githubTokenOption)
        .option(IEDRIVER, ieOption)
        .option(IGNORE_SSL, ignoreSSLOption)
        .option(LOG_LEVEL, logLevelOption)
        .option(OUT_DIR, outDirOption)
        .option(PROXY, proxyOption)
        .option(STANDALONE, standaloneOption)
        .option(VERSIONS_CHROME, versionsChromeOption)
        .option(VERSIONS_GECKO, versionsGeckoOption)
        .option(VERSIONS_IE, versionsIeOption)
        .option(VERSIONS_STANDALONE, versionsStandaloneOption);
}, (argv) => {
    update.handler(argv);
})
    .help()
    .argv;
//# sourceMappingURL=index.js.map