import * as yargs from 'yargs';
import { Options } from './options';
import { OptionsBinary } from './options_binary';
/**
 * Handles removing files that were downloaded and logs the files.
 * @param argv The argv from yargs.
 */
export declare function handler(argv: yargs.Arguments): void;
/**
 * Goes through all the providers and removes the downloaded files.
 * @param options The constructed set of all options.
 * @returns A list of deleted files.
 */
export declare function clean(options: Options): string;
/**
 * Goes through all the providers and removes the downloaded files.
 * @param optionsBinary The constructed set of all options with binaries.
 * @returns A list of deleted files.
 */
export declare function cleanBinary(optionsBinary: OptionsBinary): string;
