"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const loglevel = require("loglevel");
const utils_1 = require("./utils");
const log = loglevel.getLogger('webdriver-manager');
/**
 * Handles removing files that were downloaded and logs the files.
 * @param argv The argv from yargs.
 */
function handler(argv) {
    log.setLevel(argv.log_level);
    const options = utils_1.convertArgs2AllOptions(argv);
    log.info(clean(options));
}
exports.handler = handler;
/**
 * Goes through all the providers and removes the downloaded files.
 * @param options The constructed set of all options.
 * @returns A list of deleted files.
 */
function clean(options) {
    const optionsBinary = utils_1.addOptionsBinary(options);
    return cleanBinary(optionsBinary);
}
exports.clean = clean;
/**
 * Goes through all the providers and removes the downloaded files.
 * @param optionsBinary The constructed set of all options with binaries.
 * @returns A list of deleted files.
 */
function cleanBinary(optionsBinary) {
    const filesCleaned = [];
    for (const browserDriver of optionsBinary.browserDrivers) {
        const cleanedFiles = browserDriver.binary.cleanFiles();
        if (cleanedFiles) {
            filesCleaned.push(cleanedFiles);
        }
    }
    if (optionsBinary.server && optionsBinary.server.binary) {
        const cleanedFiles = optionsBinary.server.binary.cleanFiles();
        if (cleanedFiles) {
            filesCleaned.push(cleanedFiles);
        }
    }
    return (filesCleaned.sort()).join('\n');
}
exports.cleanBinary = cleanBinary;
//# sourceMappingURL=clean.js.map