import * as yargs from 'yargs';
import { Options } from './options';
import { OptionsBinary } from './options_binary';
/**
 * Handles making the get request to stop the selenium server standalone if the
 * server has been started with role = node.
 * @param argv The argv from yargs.
 */
export declare function handler(argv: yargs.Arguments): Promise<void>;
/**
 * Shutdown the selenium server with a get request. If the server is not
 * started with role = node, nothing will happen.
 * @param options The constructed option for the server.
 * @returns A promise for the get request.
 */
export declare function shutdown(options: Options): Promise<void>;
/**
 * Shutodown the selenium server with a get request. If the server is not
 * started with role = node, nothing will happen.
 * @param optionsBinary The constructed option for the server with binary.
 * @returns A promise for the get request.
 */
export declare function shutdownBinary(optionsBinary: OptionsBinary): Promise<void>;
