import * as yargs from 'yargs';
import { Options } from './options';
import { OptionsBinary } from './options_binary';
/**
 * Starts the selenium server standalone with browser drivers. Also handles
 * the SIGINT event when the server is stopped.
 * @param argv The argv from yargs.
 */
export declare function handler(argv: yargs.Arguments): Promise<void>;
/**
 * Goes through all the option providers and creates a set of java options
 * to pass to java when starting the selenium server standalone.
 * @param options The constructed options.
 * @returns Promise starting the server with the resolved exit code.
 */
export declare function start(options: Options): Promise<number>;
/**
 * Goes through all the option providers and creates a set of java options
 * to pass to java when starting the selenium server standalone.
 * @param optionsBinary The constructed options with binaries.
 * @returns Promise starting the server with the resolved exit code.
 */
export declare function startBinary(optionsBinary: OptionsBinary): Promise<number>;
