import * as yargs from 'yargs';
import { Options } from './options';
import { OptionsBinary } from './options_binary';
/**
 * Displays which versions of providers that have been downloaded.
 * @param argv The argv from yargs.
 */
export declare function handler(argv: yargs.Arguments): void;
/**
 * Gets a list of versions for server and browser drivers.
 * @param options The constructed set of all options.
 * @returns A string of the versions downloaded.
 */
export declare function status(options: Options): string;
/**
 * Gets a list of versions for server and browser drivers.
 * @param optionsBinary The constructed set of all options with binaries.
 * @returns A string of the versions downloaded.
 */
export declare function statusBinary(optionsBinary: OptionsBinary): string;
