import * as yargs from 'yargs';
import { Options } from './options';
import { OptionsBinary } from './options_binary';
/**
 * Updates / downloads the providers binaries.
 * @param argv The argv from yargs.
 */
export declare function handler(argv: yargs.Arguments): Promise<void>;
/**
 * Updates / downloads the providers binaries.
 * @param options The constructed options.
 * @returns Promise when binaries are all downloaded.
 */
export declare function update(options: Options): Promise<void[]>;
/**
 * Updates / downloads the providers binaries.
 * @param optionsBinary The constructed options with binaries.
 * @returns Promise when binaries are all downloaded.
 */
export declare function updateBinary(optionsBinary: OptionsBinary): Promise<void[]>;
