import { ProviderConfig, ProviderInterface } from './provider';
export declare class IEDriver implements ProviderInterface {
    cacheFileName: string;
    configFileName: string;
    ignoreSSL: boolean;
    osType: string;
    osArch: string;
    outDir: string;
    proxy: string;
    requestUrl: string;
    seleniumFlag: string;
    constructor(providerConfig?: ProviderConfig);
    /**
     * Should update the cache and download, find the version to download,
     * then download that binary.
     * @param version Optional to provide the version number or latest.
     */
    updateBinary(version?: string): Promise<void>;
    /**
     * Gets the binary file path.
     * @param version Optional to provide the version number or latest.
     */
    getBinaryPath(version?: string): string | null;
    /**
     * Gets a comma delimited list of versions downloaded. Also has the "latest"
     * downloaded noted.
     */
    getStatus(): string | null;
    /**
     * Get a line delimited list of files removed.
     */
    cleanFiles(): string;
}
/**
 * Helps translate the os type and arch to the download name associated
 * with composing the download link.
 * @param ostype The operating stystem type.
 * @param osarch The chip architecture.
 * @returns The download name associated with composing the download link.
 */
export declare function osHelper(ostype: string, osarch: string): string;
/**
 * Captures the version name which includes the semantic version and extra
 * metadata. So an example for 12.34/IEDriverServer_win32_12.34.56.zip,
 * the version is 12.34.56.
 * @param xmlKey The xml key including the partial url.
 */
export declare function versionParser(xmlKey: string): string;
/**
 * Captures the semantic version name which includes the semantic version and
 * extra metadata. So an example for 12.34/IEDriverServer_win32_12.34.56.zip,
 * the version is 12.34.56.
 * @param xmlKey The xml key including the partial url.
 */
export declare function semanticVersionParser(xmlKey: string): string;
/**
 * Matches the installed binaries depending on the operating system.
 * @param ostype The operating stystem type.
 */
export declare function matchBinaries(ostype: string): RegExp | null;
