import { JsonObject } from './http_utils';
/**
 * Check to see if the modified timestamp is expired.
 * @param fileName THe xml filename.
 */
export declare function isExpired(fileName: string): boolean;
/**
 * Reads the json file from file.
 * @param fileName The json filename to read.
 * @returns
 */
export declare function readJson(fileName: string): JsonObject[] | JsonObject | null;
/**
 * Reads the xml file.
 * @param fileName The xml filename to read.
 */
export declare function readXml(fileName: string): JsonObject | null;
/**
 * Convert the xml file to an object.
 * @param content The xml contents.
 */
export declare function convertXml2js(content: string): JsonObject | null;
/**
 * Renames a file with a semantic version.
 * @param srcFileName The full path to the original file name.
 * @param versionNumber The semver number.
 * @returns The renamed file name.
 */
export declare function renameFileWithVersion(srcFileName: string, versionNumber: string): string;
/**
 * Gets a list of files in the zip file.
 * @param zipFileName The zip file.
 * @returns A list of files in the zip file.
 */
export declare function zipFileList(zipFileName: string): string[];
/**
 * Uncompress the zip file to a destination directory.
 * @param zipFileName The zip file.
 * @param dstDir The destination directory for the contents of the zip file.
 * @returns A list of uncompressed files.
 */
export declare function unzipFile(zipFileName: string, dstDir: string): string[];
/**
 * Gets a list of files in the tarball file.
 * @param tarball The tarball file.
 * @returns A lsit of files in the tarball file.
 */
export declare function tarFileList(tarball: string): Promise<string[]>;
/**
 * Uncompress the tar file to a destination directory.
 * @param tarball The tarball file.
 * @param dstDir The destination directory for the contents of the zip file.
 * @returns A list of uncompressed files.
 */
export declare function uncompressTarball(tarball: string, dstDir: string): Promise<string[]>;
/**
 * Change the permissions for Linux and MacOS with chmod.
 * @param fileName The full path to the filename to change permissions.
 * @param mode The number to modify.
 * @param osType The OS type to decide if we need to change permissions on the
 *     file.
 */
export declare function changeFilePermissions(fileName: string, mode: string, osType: string): void;
/**
 * Writes a config file that matches the regex pattern.
 * @param outDir The output directory.
 * @param fileName The full path to the file name.
 * @param fileBinaryPathRegex The regExp to match files in the outDir.
 * @param lastFileBinaryPath The full path to the last binary file downloaded.
 */
export declare function generateConfigFile(outDir: string, fileName: string, fileBinaryPathRegex: RegExp, lastFileBinaryPath?: string): void;
/**
 * Gets matching files form the outDir and returns it as an array.
 * @param outDir The output directory.
 * @param fileBinaryPathRegex The regExp to match files in the outDir.
 */
export declare function getMatchingFiles(outDir: string, fileBinaryPathRegex: RegExp): string[];
/**
 * Get the binary path from the configuration file. The configuration file
 * should be formatted as { 'last': string, 'all': string[] }. In the 'all'
 * array, we should match the 'version'. The version does not necessarily have
 * to be a valid semantic version.
 * @param cacheFilePath The cache file path.
 * @param version An optional version that is not necessarily semver.
 */
export declare function getBinaryPathFromConfig(cacheFilePath: string, version?: string): string | null;
/**
 * Removes the files that match the regular expressions and returns a string
 * of removed files.
 * @param outDir The output directory.
 * @param fileRegexes The regExp to match files to remove in the outDir.
 */
export declare function removeFiles(outDir: string, fileRegexes: RegExp[]): string;
