import { HttpOptions, JsonObject } from './http_utils';
import { VersionList } from './version_list';
export interface RequestMethod {
    (jsonUrl: string, httpOptions: HttpOptions, oauthToken?: string): Promise<string | null>;
}
/**
 * Read the json file from cache. If the cache time has been exceeded or the
 * file does not exist, make an http request and write it to the file.
 * @param jsonUrl The json url.
 * @param httpOptions The http options for the request.
 * @param oauthToken An optional oauth token.
 */
export declare function updateJson(jsonUrl: string, httpOptions: HttpOptions, oauthToken?: string): Promise<JsonObject | JsonObject[] | null>;
/**
 * Get the GitHub rate limit with the oauth token.
 * @param oauthToken An optional oauth token.
 * @param requestMethod An overriding requesting method.
 * @returns A promised string of the response body.
 */
export declare function requestRateLimit(oauthToken?: string, requestMethod?: RequestMethod): Promise<string | null>;
/**
 * Request the GitHub json url and log the curl.
 * @param jsonUrl The json url.
 * @param httpOptions The http options for the request.
 * @param oauthToken An optional oauth token.
 * @returns A promised string of the response body.
 */
export declare function requestGitHubJson(jsonUrl: string, httpOptions: HttpOptions, oauthToken?: string): Promise<string | null>;
/**
 * Check quota for remaining GitHub requests.
 * @param oauthToken An optional oauth token.
 * @param requestMethod An overriding requesting method.
 */
export declare function hasQuota(oauthToken?: string, requestMethod?: RequestMethod): Promise<boolean>;
/**
 * Returns a list of versions and the partial url paths.
 * @param fileName the location of the xml file to read.
 * @returns the version list from the xml file.
 */
export declare function convertJsonToVersionList(fileName: string): VersionList | null;
