"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const semver = require("semver");
/**
 * Encapsulates the getVersionObjs and getVersionObj into a single method.
 * @param versionList The version list object.
 * @param osMatch The OS name and architecture.
 * @param version Optional field for the semver version number or latest.
 * * @returns Either a VersionObj or null.
 */
function getVersion(versionList, osMatch, version) {
    const versionObjs = getVersionObjs(versionList, version);
    return getVersionObj(versionObjs, osMatch);
}
exports.getVersion = getVersion;
/**
 * Get the version obj from the version list.
 * @param versionList The version list object.
 * @param version Optional field for the semver version number or latest.
 * @returns The object with paritial urls associated with the binary size.
 */
function getVersionObjs(versionList, version) {
    if (version && version !== 'latest') {
        return versionList[version];
    }
    else {
        let latestVersion = null;
        for (const versionKey of Object.keys(versionList)) {
            if (!latestVersion) {
                latestVersion = versionKey;
            }
            else {
                if (semver.gt(versionKey, latestVersion)) {
                    latestVersion = versionKey;
                }
            }
        }
        return versionList[latestVersion];
    }
}
exports.getVersionObjs = getVersionObjs;
/**
 * Get the version obj from the map.
 * @param versionObjs A map of partial urls to VersionObj
 * @param osMatch The OS name and architecture.
 * @returns Either a VersionObj or null.
 */
function getVersionObj(versionObjMap, osMatch) {
    for (const name of Object.keys(versionObjMap)) {
        if (name.includes(osMatch)) {
            return versionObjMap[name];
        }
    }
    return null;
}
exports.getVersionObj = getVersionObj;
//# sourceMappingURL=version_list.js.map