/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class AssetLocator {
    public static final String[] WEBJARS_PATH_PREFIX = new String[]{"META-INF", "resources", "webjars"};

    public static String getFullPath(String partialPath) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addUrls((Collection)ClasspathHelper.forPackage((String)StringUtils.join((Object[])WEBJARS_PATH_PREFIX, (String)"."), (ClassLoader[])new ClassLoader[]{AssetLocator.class.getClassLoader()})).setScanners(new Scanner[]{new ResourcesScanner()});
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        if (partialPath.contains("/")) {
            for (Multimap paths : reflections.getStore().getStoreMap().values()) {
                for (String path : paths.values()) {
                    if (!path.endsWith(partialPath)) continue;
                    return path;
                }
            }
        } else {
            Set paths = reflections.getStore().getResources(partialPath);
            if (paths.size() > 0) {
                return (String)paths.iterator().next();
            }
        }
        return null;
    }

    public static String getWebJarPath(String partialPath) {
        String fullPath = AssetLocator.getFullPath(partialPath);
        if (fullPath != null) {
            String prefix = WEBJARS_PATH_PREFIX[0] + "/" + WEBJARS_PATH_PREFIX[1] + "/";
            return fullPath.substring(prefix.length());
        }
        return null;
    }
}

