/*
 * Decompiled with CFR 0.152.
 */
package org.webjars.urlprotocols;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.webjars.CloseQuietly;
import org.webjars.urlprotocols.UrlProtocolHandler;

public class FatJarUrlProtocolHandler
implements UrlProtocolHandler {
    @Override
    public boolean accepts(String protocol) {
        return "jar".equals(protocol);
    }

    @Override
    public Set<String> getAssetPaths(URL url, Pattern filterExpr, ClassLoader ... classLoaders) {
        JarFile jarFile;
        HashSet<String> assetPaths = new HashSet<String>();
        String path = url.getPath();
        String[] partialJarPaths = path.split("!");
        if (partialJarPaths.length != 3) {
            return null;
        }
        try {
            File file = new File(URI.create(path.substring(0, path.indexOf("!"))));
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JarInputStream jarJarStream = null;
        try {
            jarJarStream = new JarInputStream(jarFile.getInputStream(jarFile.getEntry(partialJarPaths[1].substring(1))));
            JarEntry jarjarEntry = jarJarStream.getNextJarEntry();
            while (jarjarEntry != null) {
                String assetPathCandidate = jarjarEntry.getName();
                if (!jarjarEntry.isDirectory() && filterExpr.matcher(assetPathCandidate).matches()) {
                    assetPaths.add(assetPathCandidate);
                }
                jarjarEntry = jarJarStream.getNextJarEntry();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CloseQuietly.closeQuietly(jarJarStream);
                CloseQuietly.closeQuietly(jarFile);
                throw throwable;
            }
        }
        CloseQuietly.closeQuietly(jarJarStream);
        CloseQuietly.closeQuietly(jarFile);
        return assetPaths;
    }
}

