/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.webjars.CloseQuietly;
import org.webjars.WebJarExtractor;

public class FileSystemCache
implements WebJarExtractor.Cache {
    private final File cache;
    private Map<String, WebJarExtractor.Cacheable> onFile;
    private Map<String, WebJarExtractor.Cacheable> touched;
    private boolean dirty;

    public FileSystemCache(File cache) throws IOException {
        this.cache = cache;
        this.reset();
    }

    public boolean isUpToDate(String key, WebJarExtractor.Cacheable cacheable) {
        WebJarExtractor.Cacheable t = this.touched.get(key);
        if (t != null) {
            return cacheable.equals(t);
        }
        WebJarExtractor.Cacheable cached = this.onFile.get(key);
        if (cached != null) {
            this.touched.put(key, cached);
        }
        return cacheable.equals(cached);
    }

    public void put(String key, WebJarExtractor.Cacheable cacheable) {
        this.touched.put(key, cacheable);
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.dirty || this.onFile.size() != this.touched.size()) {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cache), "UTF-8");
            try {
                for (Map.Entry<String, WebJarExtractor.Cacheable> item : this.touched.entrySet()) {
                    writer.write(item.getKey() + ":" + item.getValue().getLastModified() + ":" + item.getValue().getPath() + "\n");
                }
                ((Writer)writer).flush();
            }
            finally {
                CloseQuietly.closeQuietly(writer);
            }
        }
        this.onFile = this.touched;
        this.touched = new HashMap<String, WebJarExtractor.Cacheable>();
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        this.onFile = new HashMap<String, WebJarExtractor.Cacheable>();
        if (this.cache.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cache), "UTF-8"));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String[] splitted;
                    if (!line.isEmpty() && (splitted = line.split(":", 3)).length == 3) {
                        String key = splitted[0];
                        String lastModified = splitted[1];
                        String path = splitted[2];
                        try {
                            long lm = Long.parseLong(lastModified);
                            this.onFile.put(key, new WebJarExtractor.Cacheable(path, lm));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    line = reader.readLine();
                }
            }
            finally {
                CloseQuietly.closeQuietly(reader);
            }
        }
        this.touched = new HashMap<String, WebJarExtractor.Cacheable>();
        this.dirty = false;
    }
}

