/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.CloseQuietly;
import org.webjars.WebJarAssetLocator;

public class WebJarExtractor {
    public static final String NODE_MODULES = "node_modules";
    private static final Logger log = LoggerFactory.getLogger(WebJarExtractor.class);
    private final Cache cache;
    private final ClassLoader classLoader;
    public static Cache NO_CACHE = new NoCache();

    public WebJarExtractor() {
        this(WebJarExtractor.class.getClassLoader());
    }

    public WebJarExtractor(ClassLoader classLoader) {
        this(NO_CACHE, classLoader);
    }

    public WebJarExtractor(Cache cache, ClassLoader classLoader) {
        this.cache = cache;
        this.classLoader = classLoader;
    }

    public void extractAllWebJarsTo(File to) throws IOException {
        this.extractWebJarsTo(null, "", to);
    }

    public void extractWebJarTo(String name, File to) throws IOException {
        this.extractWebJarsTo(name, "", to);
    }

    public void extractAllNodeModulesTo(File to) throws IOException {
        this.extractWebJarsTo(null, NODE_MODULES, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractWebJarsTo(String name, String subdir, File to) throws IOException {
        String fullPath = "META-INF/resources/webjars/";
        String searchPath = name != null ? fullPath + name + "/" : fullPath;
        for (URL url : WebJarAssetLocator.listParentURLsWithResource(new ClassLoader[]{this.classLoader}, searchPath)) {
            File file;
            if ("jar".equals(url.getProtocol())) {
                String subdirPath = subdir.isEmpty() ? "" : subdir + "/";
                String urlPath = url.getPath();
                File file2 = new File(URI.create(urlPath.substring(0, urlPath.indexOf("!"))));
                log.debug("Loading webjar from {}", (Object)file2);
                JarFile jarFile = new JarFile(file2);
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().startsWith(fullPath)) continue;
                        String webJarPath = entry.getName().substring(fullPath.length());
                        String[] nameVersion = webJarPath.split("/", 3);
                        if (nameVersion.length == 3) {
                            String relativeName = nameVersion[2];
                            if (!relativeName.startsWith(subdirPath)) continue;
                            String subRelativeName = relativeName.substring(subdirPath.length());
                            File copyTo = new File(to, subRelativeName);
                            this.copyJarEntry(jarFile, entry, copyTo, subRelativeName);
                            continue;
                        }
                        log.debug("Found file entry {} where webjar version directory was expected in {}", (Object)webJarPath, (Object)url);
                    }
                    continue;
                }
                finally {
                    CloseQuietly.closeQuietly(jarFile);
                    continue;
                }
            }
            if (!"file".equals(url.getProtocol())) continue;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            log.debug("Found file system webjar: {}", (Object)file);
            File[] webjars = file.listFiles();
            if (webjars != null) {
                for (File webjar : webjars) {
                    if (webjar.isDirectory()) {
                        File[] versions = webjar.listFiles();
                        if (versions != null) {
                            for (File version : versions) {
                                if (version.isDirectory()) {
                                    log.debug("Found version {} of webjar {}", (Object)version.getName(), (Object)webjar.getName());
                                    this.copyDirectory(new File(version, subdir), to, webjar.getName());
                                    continue;
                                }
                                log.debug("Filesystem webjar version {} is not a directory", (Object)version);
                            }
                            continue;
                        }
                        log.debug("Filesystem webjar has no versions: {}", (Object)webjar);
                        continue;
                    }
                    log.debug("Filesystem webjar {} is not a directory", (Object)webjar);
                }
                continue;
            }
            log.debug("Filesystem webjar has no webjars: {}", (Object)file);
        }
    }

    private void ensureIsDirectory(File dir) {
        boolean created;
        if (dir.exists() && !dir.isDirectory()) {
            log.debug("Destination directory is not a directory, deleting {}", (Object)dir);
            boolean isDeleted = dir.delete();
            if (!isDeleted) {
                log.debug("Destination directory {} wasn't deleted", (Object)dir);
            }
        }
        if (!(created = dir.mkdirs())) {
            log.debug("Destination directory {} didn't need creation", (Object)dir);
        }
    }

    private void copyDirectory(File dir, File to, String key) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                File copyTo = new File(to, file.getName());
                String relativeName = key.isEmpty() ? file.getName() : key + "/" + file.getName();
                if (file.isDirectory()) {
                    this.copyDirectory(file, copyTo, relativeName);
                    continue;
                }
                Cacheable forCache = new Cacheable(file.getPath(), file.lastModified());
                log.debug("Checking whether {} is up to date at {}", (Object)relativeName, (Object)copyTo);
                if (copyTo.exists() && this.cache.isUpToDate(relativeName, forCache)) continue;
                log.debug("Up to date check failed, copying {} to {}", (Object)relativeName, (Object)copyTo);
                this.ensureIsDirectory(copyTo.getParentFile());
                WebJarExtractor.copyAndClose(new FileInputStream(file), copyTo);
                this.cache.put(relativeName, forCache);
            }
        }
    }

    private void copyJarEntry(JarFile jarFile, JarEntry entry, File copyTo, String key) throws IOException {
        Cacheable forCache = new Cacheable(entry.getName(), entry.getTime());
        log.debug("Checking whether {} is up to date at {}", (Object)entry.getName(), (Object)copyTo);
        if (!copyTo.exists() || !this.cache.isUpToDate(key, forCache)) {
            log.debug("Up to date check failed, copying {} to {}", (Object)entry.getName(), (Object)copyTo);
            this.ensureIsDirectory(copyTo.getParentFile());
            WebJarExtractor.copyAndClose(jarFile.getInputStream(entry), copyTo);
            this.cache.put(key, forCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndClose(InputStream source, File to) throws IOException {
        FileOutputStream dest = new FileOutputStream(to);
        try {
            byte[] buffer = new byte[8192];
            int read = source.read(buffer);
            while (read > 0) {
                ((OutputStream)dest).write(buffer, 0, read);
                read = source.read(buffer);
            }
            dest.flush();
        }
        finally {
            CloseQuietly.closeQuietly(source);
            CloseQuietly.closeQuietly(dest);
        }
    }

    public static final class Cacheable {
        private final String path;
        private final long lastModified;

        public Cacheable(String path, long lastModified) {
            this.path = path;
            this.lastModified = lastModified;
        }

        public String getPath() {
            return this.path;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cacheable cacheable = (Cacheable)o;
            if (this.lastModified != cacheable.lastModified) {
                return false;
            }
            return this.path.equals(cacheable.path);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            return result;
        }
    }

    public static class MemoryCache
    implements Cache {
        private final Map<String, Cacheable> cache = new HashMap<String, Cacheable>();

        public boolean isUpToDate(String key, Cacheable cacheable) {
            return cacheable.equals(this.cache.get(key));
        }

        public void put(String key, Cacheable cacheable) {
            this.cache.put(key, cacheable);
        }
    }

    private static class NoCache
    implements Cache {
        private NoCache() {
        }

        public boolean isUpToDate(String key, Cacheable cacheable) {
            return false;
        }

        public void put(String key, Cacheable cacheable) {
        }
    }

    public static interface Cache {
        public boolean isUpToDate(String var1, Cacheable var2);

        public void put(String var1, Cacheable var2);
    }
}

