# example.js

``` javascript
function getTemplate(templateName) {
	return require("./templates/"+templateName);
}
console.log(getTemplate("a"));
console.log(getTemplate("b"));
```

# templates/

* a.js
* b.js
* c.js

All templates are of this pattern:

``` javascript
module.exports = function() {
	return "This text was generated by template X";
}
```

# js/output.js

``` javascript
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "js/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/*!********************!*\
  !*** ./example.js ***!
  \********************/
/***/ function(module, exports, __webpack_require__) {

	function getTemplate(templateName) {
		return __webpack_require__(/*! ./templates */ 4)("./"+templateName);
	}
	console.log(getTemplate("a"));
	console.log(getTemplate("b"));

/***/ },
/* 1 */
/*!************************!*\
  !*** ./templates/a.js ***!
  \************************/
/***/ function(module, exports, __webpack_require__) {

	module.exports = function() {
		return "This text was generated by template A";
	}

/***/ },
/* 2 */
/*!************************!*\
  !*** ./templates/b.js ***!
  \************************/
/***/ function(module, exports, __webpack_require__) {

	module.exports = function() {
		return "This text was generated by template B";
	}

/***/ },
/* 3 */
/*!************************!*\
  !*** ./templates/c.js ***!
  \************************/
/***/ function(module, exports, __webpack_require__) {

	module.exports = function() {
		return "This text was generated by template C";
	}

/***/ },
/* 4 */
/*!****************************!*\
  !*** ./templates ^\.\/.*$ ***!
  \****************************/
/***/ function(module, exports, __webpack_require__) {

	var map = {
		"./a": 1,
		"./a.js": 1,
		"./b": 2,
		"./b.js": 2,
		"./c": 3,
		"./c.js": 3
	};
	function webpackContext(req) {
		return __webpack_require__(webpackContextResolve(req));
	};
	function webpackContextResolve(req) {
		return map[req] || (function() { throw new Error("Cannot find module '" + req + "'.") }());
	};
	webpackContext.keys = function webpackContextKeys() {
		return Object.keys(map);
	};
	webpackContext.resolve = webpackContextResolve;
	module.exports = webpackContext;
	webpackContext.id = 4;


/***/ }
/******/ ])
```

# Info

## Uncompressed

```
Hash: 532ec4ba9a9dceec08e2
Version: webpack 1.5.0
Time: 53ms
    Asset  Size  Chunks             Chunk Names
output.js  3198       0  [emitted]  main
chunk    {0} output.js (main) 613 [rendered]
    > main [0] ./example.js 
    [0] ./example.js 150 {0} [built]
    [1] ./templates/a.js 82 {0} [optional] [built]
        context element ./a.js [4] ./templates ^\.\/.*$
        context element ./a [4] ./templates ^\.\/.*$
    [2] ./templates/b.js 82 {0} [optional] [built]
        context element ./b.js [4] ./templates ^\.\/.*$
        context element ./b [4] ./templates ^\.\/.*$
    [3] ./templates/c.js 82 {0} [optional] [built]
        context element ./c.js [4] ./templates ^\.\/.*$
        context element ./c [4] ./templates ^\.\/.*$
    [4] ./templates ^\.\/.*$ 217 {0} [built]
        cjs require context ./templates [0] ./example.js 2:8-44
```

## Minimized (uglify-js, no zip)

```
Hash: 4e3b87900b36b810e8bc
Version: webpack 1.5.0
Time: 107ms
    Asset  Size  Chunks             Chunk Names
output.js   810       0  [emitted]  main
chunk    {0} output.js (main) 613 [rendered]
    > main [0] ./example.js 
    [0] ./example.js 150 {0} [built]
    [1] ./templates/a.js 82 {0} [optional] [built]
        context element ./a.js [4] ./templates ^\.\/.*$
        context element ./a [4] ./templates ^\.\/.*$
    [2] ./templates/b.js 82 {0} [optional] [built]
        context element ./b.js [4] ./templates ^\.\/.*$
        context element ./b [4] ./templates ^\.\/.*$
    [3] ./templates/c.js 82 {0} [optional] [built]
        context element ./c.js [4] ./templates ^\.\/.*$
        context element ./c [4] ./templates ^\.\/.*$
    [4] ./templates ^\.\/.*$ 217 {0} [built]
        cjs require context ./templates [0] ./example.js 2:8-44
```

# Code Splitting

See [this example combined with code splitting](../code-splitted-require.context)
