/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.ant;

import java.net.URL;
import java.util.jar.Manifest;

public final class Version {
    public static void main(String[] anArgsArray) {
        System.out.println(Version.getFullProductName());
    }

    public static String getFullProductName() {
        return Version.getProductName() + " Version " + Version.getVersion() + " Build " + Version.getBuild();
    }

    public static String getProductName() {
        return Version.readFromManifest("Application-Name", "Wetator");
    }

    public static String getVersion() {
        String tmpVersion = Version.readFromManifest("Version", "local build");
        return tmpVersion.replaceAll("_", ".");
    }

    public static String getBuild() {
        return Version.readFromManifest("Build", "");
    }

    private Version() {
    }

    private static String readFromManifest(String anAttributeName, String aDefault) {
        Class<Version> tmpClass = Version.class;
        String tmpClassName = tmpClass.getSimpleName();
        String tmpClassFileName = tmpClassName + ".class";
        String tmpPathToThisClass = tmpClass.getResource(tmpClassFileName).toExternalForm();
        int tmpPos = tmpPathToThisClass.indexOf(33);
        StringBuilder tmpPathToManifest = new StringBuilder(tmpPathToThisClass.substring(0, tmpPos + 1));
        tmpPathToManifest.append("/META-INF/MANIFEST.MF");
        try {
            Manifest tmpManifest = new Manifest(new URL(tmpPathToManifest.toString()).openStream());
            return tmpManifest.getAttributes("Application").getValue(anAttributeName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return aDefault;
        }
    }
}

