/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.ant;

import java.io.File;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.wetator.ant.AntWriter;
import org.wetator.ant.Version;

public class Wetator
extends Task {
    private String config;
    private Path classpath;
    private FileSet fileSet;
    private List<Property> properties = new ArrayList<Property>();
    private String sysPropertiesLine;
    private List<Environment.Variable> sysProperties = new ArrayList<Environment.Variable>();
    private List<PropertySet> sysPropertySets = new ArrayList<PropertySet>();
    private boolean haltOnFailure;
    private String failureProperty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            String[] tmpPaths;
            if (null == this.getConfig()) {
                throw new BuildException(Version.getProductName() + " Ant: Config is required (set property config).");
            }
            if (null == this.getFileset()) {
                throw new BuildException(Version.getProductName() + " Ant: Fileset is required (define a fileset containing all your test files).");
            }
            if (this.classpath == null) {
                this.log("Classpath not defined", 2);
                throw new RuntimeException("Classpath not defined");
            }
            this.log("Classpath:", 2);
            for (String tmpPath : tmpPaths = this.classpath.list()) {
                this.log("    '" + tmpPath + "'", 2);
            }
            AntClassLoader tmpAntClassLoader = new AntClassLoader(ClassLoader.getSystemClassLoader(), this.getProject(), this.classpath, false);
            Properties tmpOriginalSystemProperties = System.getProperties();
            try {
                tmpAntClassLoader.setThreadContextLoader();
                System.setProperties(this.mergeSystemProperties());
                DirectoryScanner tmpDirScanner = this.getFileset().getDirectoryScanner(this.getProject());
                String[] tmpListOfFiles = tmpDirScanner.getIncludedFiles();
                Class tmpExecutorClass = tmpAntClassLoader.loadClass("org.wetator.ant.WetatorExecutor");
                Constructor tmpConstructor = tmpExecutorClass.getConstructor(File.class, String.class, File.class, String[].class, Map.class, Writer.class);
                Object tmpExecutor = tmpConstructor.newInstance(this.getProject().getBaseDir(), this.getConfig(), tmpDirScanner.getBasedir(), tmpListOfFiles, this.getPropertiesFromAnt(), new AntWriter(this));
                Method tmpRunMethod = tmpExecutorClass.getDeclaredMethod("runWetator", new Class[0]);
                long[] tmpResult = (long[])tmpRunMethod.invoke(tmpExecutor, new Object[0]);
                long tmpTestCountProcessed = tmpResult[0];
                long tmpTestCountError = tmpResult[1];
                long tmpTestCountFailure = tmpResult[2];
                long tmpTestCountIgnored = tmpResult[3];
                long tmpUnsuccessfulTestCount = tmpTestCountError + tmpTestCountFailure + tmpTestCountIgnored;
                if (tmpUnsuccessfulTestCount > 0L) {
                    if (null != this.getFailureProperty()) {
                        this.getProject().setNewProperty(this.getFailureProperty(), "true");
                    }
                    if (this.isHaltOnFailure()) {
                        throw new BuildException(Version.getProductName() + ": AntTask failed. (Tests: " + tmpTestCountProcessed + ",  Errors: " + tmpTestCountError + ",  Failures: " + tmpTestCountFailure + ",  Ignored: " + tmpTestCountIgnored + ")");
                    }
                }
            }
            finally {
                tmpAntClassLoader.resetThreadContextLoader();
                tmpAntClassLoader.cleanup();
                System.setProperties(tmpOriginalSystemProperties);
            }
        }
        catch (InvocationTargetException e) {
            String tmpMessage = e.getTargetException().toString();
            throw new BuildException(Version.getProductName() + ": AntTask failed. (" + tmpMessage + ")", (Throwable)e);
        }
        catch (Throwable e) {
            String tmpMessage = e.toString();
            throw new BuildException(Version.getProductName() + ": AntTask failed. (" + tmpMessage + ")", e);
        }
    }

    protected String getConfig() {
        return this.config;
    }

    public void setConfig(String aConfig) {
        this.config = aConfig;
    }

    protected FileSet getFileset() {
        return this.fileSet;
    }

    public FileSet createFileSet() {
        this.fileSet = new FileSet();
        return this.fileSet;
    }

    public Path createClasspath() {
        if (null == this.classpath) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath;
    }

    public void addProperty(Property aProperty) {
        this.properties.add(aProperty);
    }

    protected Map<String, String> getPropertiesFromAnt() {
        HashMap<String, String> tmpOurProperties = new HashMap<String, String>();
        Hashtable tmpProjectProperties = this.getProject().getProperties();
        for (Map.Entry tmpEntry : tmpProjectProperties.entrySet()) {
            tmpOurProperties.put((String)tmpEntry.getKey(), tmpEntry.getValue() == null ? null : String.valueOf(tmpEntry.getValue()));
        }
        for (Property tmpProperty : this.properties) {
            tmpOurProperties.put(tmpProperty.getName(), tmpProperty.getValue());
        }
        return tmpOurProperties;
    }

    public void setSysproperties(String aSystemPropertiesLine) {
        this.sysPropertiesLine = aSystemPropertiesLine;
    }

    public void addSysproperty(Environment.Variable aSystemProperty) {
        this.sysProperties.add(aSystemProperty);
    }

    public void addSyspropertyset(PropertySet aSystemPropertySet) {
        this.sysPropertySets.add(aSystemPropertySet);
    }

    protected Properties mergeSystemProperties() {
        Properties tmpSystemProperties = new Properties();
        tmpSystemProperties.putAll((Map<?, ?>)System.getProperties());
        String[] tmpLineParts = Commandline.translateCommandline((String)this.sysPropertiesLine);
        for (String tmpLinePart : tmpLineParts) {
            String[] tmpProperty = tmpLinePart.split("=");
            if (tmpProperty.length != 2) continue;
            tmpSystemProperties.put(tmpProperty[0], tmpProperty[1]);
        }
        for (PropertySet tmpSysPropertySet : this.sysPropertySets) {
            tmpSystemProperties.putAll((Map<?, ?>)tmpSysPropertySet.getProperties());
        }
        for (Environment.Variable tmpSysProperty : this.sysProperties) {
            String tmpKey = tmpSysProperty.getKey();
            if (tmpKey == null || tmpKey.isEmpty()) continue;
            tmpSystemProperties.put(tmpKey, tmpSysProperty.getValue());
        }
        return tmpSystemProperties;
    }

    public boolean isHaltOnFailure() {
        return this.haltOnFailure;
    }

    public void setHaltOnFailure(boolean aHaltOnFailure) {
        this.haltOnFailure = aHaltOnFailure;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String aFailureProperty) {
        this.failureProperty = aFailureProperty;
    }
}

