/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.ant;

import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wetator.ant.AntOutProgressListener;
import org.wetator.core.IProgressListener;
import org.wetator.core.WetatorEngine;
import org.wetator.exception.InvalidInputException;

public class WetatorExecutor {
    private static final Log LOG = LogFactory.getLog(WetatorExecutor.class);
    private File baseDir;
    private String config;
    private final File filesBaseDir;
    private final String[] listOfFiles;
    private final Map<String, String> properties;
    private final Writer writer;

    public WetatorExecutor(File aBaseDir, String aConfig, File aFilesBaseDir, String[] aListOfFiles, Map<String, String> aProperties, Writer aWriter) {
        this.baseDir = aBaseDir;
        this.config = aConfig;
        this.filesBaseDir = aFilesBaseDir;
        this.listOfFiles = aListOfFiles;
        this.properties = aProperties;
        this.writer = aWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] runWetator() throws InvalidInputException {
        WetatorEngine tmpWetatorEngine = new WetatorEngine();
        try {
            File tmpConfigFile = new File(this.baseDir, this.config);
            tmpWetatorEngine.setConfigFileName(tmpConfigFile.getAbsolutePath());
            Map<String, String> tmpOurProperties = this.getPropertiesFromAnt();
            tmpWetatorEngine.setExternalProperties(tmpOurProperties);
            AntOutProgressListener tmpListener = new AntOutProgressListener(this.writer);
            tmpWetatorEngine.addProgressListener((IProgressListener)tmpListener);
            tmpWetatorEngine.init();
            for (String tmpFileName : this.listOfFiles) {
                tmpWetatorEngine.addTestCase(tmpFileName, new File(this.filesBaseDir, tmpFileName));
            }
            tmpWetatorEngine.executeTests();
            long[] lArray = new long[]{tmpListener.getTestCountProcessed(), tmpListener.getTestCountError(), tmpListener.getTestCountFailure(), tmpListener.getTestCountIgnored()};
            return lArray;
        }
        finally {
            tmpWetatorEngine.shutdown();
        }
    }

    protected Map<String, String> getPropertiesFromAnt() {
        HashMap<String, String> tmpOurProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> tmpEntry : this.properties.entrySet()) {
            String tmpName = tmpEntry.getKey();
            if (tmpName == null) continue;
            if (tmpName.startsWith("$$")) {
                tmpOurProperties.put(tmpName, tmpEntry.getValue());
                LOG.info((Object)("set property '" + tmpName + "' to '****'"));
                continue;
            }
            if (!tmpName.startsWith("wetator.") && !tmpName.startsWith("$")) continue;
            tmpOurProperties.put(tmpName, tmpEntry.getValue());
            LOG.info((Object)("set property '" + tmpName + "' to '" + tmpEntry.getValue() + "'"));
        }
        return tmpOurProperties;
    }
}

