/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.dropwizard.simpleauth;

import com.google.common.base.Preconditions;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.UnauthorizedHandler;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestFilter;
import org.whispersystems.dropwizard.simpleauth.Authenticator;

@Priority(value=1000)
public abstract class AuthFilter<C, P>
implements ContainerRequestFilter {
    protected String prefix;
    protected String realm;
    protected Authenticator<C, P> authenticator;
    protected Class<P> principalType;
    protected UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();

    public boolean supports(Class<?> clazz) {
        return clazz.equals(this.principalType);
    }

    public static abstract class AuthFilterBuilder<C, P, T extends AuthFilter<C, P>> {
        private String realm = "realm";
        private String prefix = "Basic";
        private Authenticator<C, P> authenticator;
        private Class<P> principalType;

        public AuthFilterBuilder<C, P, T> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setAuthenticator(Authenticator<C, P> authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public AuthFilterBuilder<C, P, T> setPrincipal(Class<P> principalType) {
            this.principalType = principalType;
            return this;
        }

        public T buildAuthFilter() {
            Preconditions.checkArgument((this.realm != null ? 1 : 0) != 0, (Object)"Realm is not set");
            Preconditions.checkArgument((this.prefix != null ? 1 : 0) != 0, (Object)"Prefix is not set");
            Preconditions.checkArgument((this.authenticator != null ? 1 : 0) != 0, (Object)"Authenticator is not set");
            T authFilter = this.newInstance();
            ((AuthFilter)authFilter).authenticator = this.authenticator;
            ((AuthFilter)authFilter).prefix = this.prefix;
            ((AuthFilter)authFilter).realm = this.realm;
            ((AuthFilter)authFilter).principalType = this.principalType;
            return authFilter;
        }

        protected abstract T newInstance();
    }
}

