/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.dropwizard.simpleauth;

import io.dropwizard.auth.Auth;
import java.lang.annotation.Annotation;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.whispersystems.dropwizard.simpleauth.AuthFilter;

public class AuthDynamicFeature
implements DynamicFeature {
    private AuthFilter[] authFilters;

    public AuthDynamicFeature(AuthFilter ... authFilters) {
        this.authFilters = authFilters;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        AnnotatedMethod annotatedMethod = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = annotatedMethod.getParameterAnnotations();
        Class[] parameterTypes = annotatedMethod.getParameterTypes();
        this.verifyAuthAnnotations(parameterAnnotations);
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Auth)) continue;
                context.register((Object)this.getFilterFor(parameterTypes[i]));
            }
        }
    }

    private AuthFilter getFilterFor(Class<?> parameterType) {
        for (AuthFilter filter : this.authFilters) {
            if (!filter.supports(parameterType)) continue;
            return filter;
        }
        throw new IllegalArgumentException("No authenticator for type: " + parameterType);
    }

    private void verifyAuthAnnotations(Annotation[][] parameterAnnotations) {
        int authCount = 0;
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!(annotation instanceof Auth)) continue;
                ++authCount;
            }
        }
        if (authCount > 1) {
            throw new IllegalArgumentException("Only one @Auth tag supported per resource method!");
        }
    }
}

