/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.SignalProtos;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;

public class UnidentifiedSenderMessageContent {
    private final int type;
    private final SenderCertificate senderCertificate;
    private final byte[] content;
    private final byte[] serialized;

    public UnidentifiedSenderMessageContent(byte[] serialized) throws InvalidMetadataMessageException, InvalidCertificateException {
        try {
            SignalProtos.UnidentifiedSenderMessage.Message message = SignalProtos.UnidentifiedSenderMessage.Message.parseFrom(serialized);
            if (!(message.hasType() && message.hasSenderCertificate() && message.hasContent())) {
                throw new InvalidMetadataMessageException("Missing fields");
            }
            switch (message.getType()) {
                case MESSAGE: {
                    this.type = 2;
                    break;
                }
                case PREKEY_MESSAGE: {
                    this.type = 3;
                    break;
                }
                default: {
                    throw new InvalidMetadataMessageException("Unknown type: " + message.getType().getNumber());
                }
            }
            this.senderCertificate = new SenderCertificate(message.getSenderCertificate().toByteArray());
            this.content = message.getContent().toByteArray();
            this.serialized = serialized;
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidMetadataMessageException((Exception)((Object)e));
        }
    }

    public UnidentifiedSenderMessageContent(int type, SenderCertificate senderCertificate, byte[] content) {
        try {
            this.serialized = ((SignalProtos.UnidentifiedSenderMessage.Message)SignalProtos.UnidentifiedSenderMessage.Message.newBuilder().setType(SignalProtos.UnidentifiedSenderMessage.Message.Type.valueOf(this.getProtoType(type))).setSenderCertificate(SignalProtos.SenderCertificate.parseFrom(senderCertificate.getSerialized())).setContent(ByteString.copyFrom((byte[])content)).build()).toByteArray();
            this.type = type;
            this.senderCertificate = senderCertificate;
            this.content = content;
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getType() {
        return this.type;
    }

    public SenderCertificate getSenderCertificate() {
        return this.senderCertificate;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getSerialized() {
        return this.serialized;
    }

    private int getProtoType(int type) {
        switch (type) {
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new AssertionError(type);
    }
}

