/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal;

import org.signal.client.internal.Native;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public class SessionCipher {
    public static final Object SESSION_LOCK = new Object();
    private final SessionStore sessionStore;
    private final IdentityKeyStore identityKeyStore;
    private final PreKeyStore preKeyStore;
    private final SignedPreKeyStore signedPreKeyStore;
    private final SignalProtocolAddress remoteAddress;

    public SessionCipher(SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, IdentityKeyStore identityKeyStore, SignalProtocolAddress remoteAddress) {
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.identityKeyStore = identityKeyStore;
        this.remoteAddress = remoteAddress;
        this.signedPreKeyStore = signedPreKeyStore;
    }

    public SessionCipher(SignalProtocolStore store, SignalProtocolAddress remoteAddress) {
        this(store, store, store, store, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CiphertextMessage encrypt(byte[] paddedMessage) throws UntrustedIdentityException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            return Native.SessionCipher_EncryptMessage(paddedMessage, this.remoteAddress.nativeHandle(), this.sessionStore, this.identityKeyStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(PreKeySignalMessage ciphertext) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            return Native.SessionCipher_DecryptPreKeySignalMessage(ciphertext.nativeHandle(), this.remoteAddress.nativeHandle(), this.sessionStore, this.identityKeyStore, this.preKeyStore, this.signedPreKeyStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(SignalMessage ciphertext) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException, NoSessionException, UntrustedIdentityException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            return Native.SessionCipher_DecryptSignalMessage(ciphertext.nativeHandle(), this.remoteAddress.nativeHandle(), this.sessionStore, this.identityKeyStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteRegistrationId() {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
            return record.getSessionState().getRemoteRegistrationId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionVersion() {
        Object object = SESSION_LOCK;
        synchronized (object) {
            if (!this.sessionStore.containsSession(this.remoteAddress)) {
                throw new IllegalStateException(String.format("No session for (%s)!", this.remoteAddress));
            }
            SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
            return record.getSessionState().getSessionVersion();
        }
    }
}

