/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups;

import org.signal.client.internal.Native;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.groups.SenderKeyName;
import org.whispersystems.libsignal.groups.state.SenderKeyStore;

public class GroupCipher {
    static final Object LOCK = new Object();
    private final SenderKeyStore senderKeyStore;
    private final SenderKeyName senderKeyId;

    public GroupCipher(SenderKeyStore senderKeyStore, SenderKeyName senderKeyId) {
        this.senderKeyStore = senderKeyStore;
        this.senderKeyId = senderKeyId;
    }

    public byte[] encrypt(byte[] paddedPlaintext) throws NoSessionException {
        Object object = LOCK;
        synchronized (object) {
            try {
                return Native.GroupCipher_EncryptMessage(this.senderKeyId.nativeHandle(), paddedPlaintext, this.senderKeyStore);
            }
            catch (IllegalStateException e) {
                throw new NoSessionException(e);
            }
        }
    }

    public byte[] decrypt(byte[] senderKeyMessageBytes) throws LegacyMessageException, DuplicateMessageException, InvalidMessageException, NoSessionException {
        Object object = LOCK;
        synchronized (object) {
            try {
                return Native.GroupCipher_DecryptMessage(this.senderKeyId.nativeHandle(), senderKeyMessageBytes, this.senderKeyStore);
            }
            catch (IllegalStateException e) {
                throw new NoSessionException(e);
            }
        }
    }
}

